package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ActivateApDevice invokes the cloudesl.ActivateApDevice API synchronously
func (client *Client) ActivateApDevice(request *ActivateApDeviceRequest) (response *ActivateApDeviceResponse, err error) {
	response = CreateActivateApDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// ActivateApDeviceWithChan invokes the cloudesl.ActivateApDevice API asynchronously
func (client *Client) ActivateApDeviceWithChan(request *ActivateApDeviceRequest) (<-chan *ActivateApDeviceResponse, <-chan error) {
	responseChan := make(chan *ActivateApDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ActivateApDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ActivateApDeviceWithCallback invokes the cloudesl.ActivateApDevice API asynchronously
func (client *Client) ActivateApDeviceWithCallback(request *ActivateApDeviceRequest, callback func(response *ActivateApDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ActivateApDeviceResponse
		var err error
		defer close(result)
		response, err = client.ActivateApDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ActivateApDeviceRequest is the request struct for api ActivateApDevice
type ActivateApDeviceRequest struct {
	*requests.RpcRequest
	ExtraParams string `position:"Body" name:"ExtraParams"`
	ApMac       string `position:"Body" name:"ApMac"`
	StoreId     string `position:"Body" name:"StoreId"`
}

// ActivateApDeviceResponse is the response struct for api ActivateApDevice
type ActivateApDeviceResponse struct {
	*responses.BaseResponse
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Message        string `json:"Message" xml:"Message"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	Code           string `json:"Code" xml:"Code"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateActivateApDeviceRequest creates a request to invoke ActivateApDevice API
func CreateActivateApDeviceRequest() (request *ActivateApDeviceRequest) {
	request = &ActivateApDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "ActivateApDevice", "cloudesl", "openAPI")
	request.Method = requests.POST
	return
}

// CreateActivateApDeviceResponse creates a response to parse from ActivateApDevice response
func CreateActivateApDeviceResponse() (response *ActivateApDeviceResponse) {
	response = &ActivateApDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
