package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAggregateResourceComplianceGroupByResourceType invokes the config.GetAggregateResourceComplianceGroupByResourceType API synchronously
func (client *Client) GetAggregateResourceComplianceGroupByResourceType(request *GetAggregateResourceComplianceGroupByResourceTypeRequest) (response *GetAggregateResourceComplianceGroupByResourceTypeResponse, err error) {
	response = CreateGetAggregateResourceComplianceGroupByResourceTypeResponse()
	err = client.DoAction(request, response)
	return
}

// GetAggregateResourceComplianceGroupByResourceTypeWithChan invokes the config.GetAggregateResourceComplianceGroupByResourceType API asynchronously
func (client *Client) GetAggregateResourceComplianceGroupByResourceTypeWithChan(request *GetAggregateResourceComplianceGroupByResourceTypeRequest) (<-chan *GetAggregateResourceComplianceGroupByResourceTypeResponse, <-chan error) {
	responseChan := make(chan *GetAggregateResourceComplianceGroupByResourceTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAggregateResourceComplianceGroupByResourceType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAggregateResourceComplianceGroupByResourceTypeWithCallback invokes the config.GetAggregateResourceComplianceGroupByResourceType API asynchronously
func (client *Client) GetAggregateResourceComplianceGroupByResourceTypeWithCallback(request *GetAggregateResourceComplianceGroupByResourceTypeRequest, callback func(response *GetAggregateResourceComplianceGroupByResourceTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAggregateResourceComplianceGroupByResourceTypeResponse
		var err error
		defer close(result)
		response, err = client.GetAggregateResourceComplianceGroupByResourceType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAggregateResourceComplianceGroupByResourceTypeRequest is the request struct for api GetAggregateResourceComplianceGroupByResourceType
type GetAggregateResourceComplianceGroupByResourceTypeRequest struct {
	*requests.RpcRequest
	ConfigRuleIds string `position:"Query" name:"ConfigRuleIds"`
	AggregatorId  string `position:"Query" name:"AggregatorId"`
}

// GetAggregateResourceComplianceGroupByResourceTypeResponse is the response struct for api GetAggregateResourceComplianceGroupByResourceType
type GetAggregateResourceComplianceGroupByResourceTypeResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	ComplianceResult ComplianceResult `json:"ComplianceResult" xml:"ComplianceResult"`
}

// CreateGetAggregateResourceComplianceGroupByResourceTypeRequest creates a request to invoke GetAggregateResourceComplianceGroupByResourceType API
func CreateGetAggregateResourceComplianceGroupByResourceTypeRequest() (request *GetAggregateResourceComplianceGroupByResourceTypeRequest) {
	request = &GetAggregateResourceComplianceGroupByResourceTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetAggregateResourceComplianceGroupByResourceType", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAggregateResourceComplianceGroupByResourceTypeResponse creates a response to parse from GetAggregateResourceComplianceGroupByResourceType response
func CreateGetAggregateResourceComplianceGroupByResourceTypeResponse() (response *GetAggregateResourceComplianceGroupByResourceTypeResponse) {
	response = &GetAggregateResourceComplianceGroupByResourceTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
