package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenAckService invokes the cs.OpenAckService API synchronously
func (client *Client) OpenAckService(request *OpenAckServiceRequest) (response *OpenAckServiceResponse, err error) {
	response = CreateOpenAckServiceResponse()
	err = client.DoAction(request, response)
	return
}

// OpenAckServiceWithChan invokes the cs.OpenAckService API asynchronously
func (client *Client) OpenAckServiceWithChan(request *OpenAckServiceRequest) (<-chan *OpenAckServiceResponse, <-chan error) {
	responseChan := make(chan *OpenAckServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenAckService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenAckServiceWithCallback invokes the cs.OpenAckService API asynchronously
func (client *Client) OpenAckServiceWithCallback(request *OpenAckServiceRequest, callback func(response *OpenAckServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenAckServiceResponse
		var err error
		defer close(result)
		response, err = client.OpenAckService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenAckServiceRequest is the request struct for api OpenAckService
type OpenAckServiceRequest struct {
	*requests.RoaRequest
	Type string `position:"Query" name:"type"`
}

// OpenAckServiceResponse is the response struct for api OpenAckService
type OpenAckServiceResponse struct {
	*responses.BaseResponse
	OrderId   string `json:"order_id" xml:"order_id"`
	RequestId string `json:"request_id" xml:"request_id"`
}

// CreateOpenAckServiceRequest creates a request to invoke OpenAckService API
func CreateOpenAckServiceRequest() (request *OpenAckServiceRequest) {
	request = &OpenAckServiceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "OpenAckService", "/service/open", "", "")
	request.Method = requests.POST
	return
}

// CreateOpenAckServiceResponse creates a response to parse from OpenAckService response
func CreateOpenAckServiceResponse() (response *OpenAckServiceResponse) {
	response = &OpenAckServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
