package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDevopsProjectTaskList invokes the devops_rdc.ListDevopsProjectTaskList API synchronously
func (client *Client) ListDevopsProjectTaskList(request *ListDevopsProjectTaskListRequest) (response *ListDevopsProjectTaskListResponse, err error) {
	response = CreateListDevopsProjectTaskListResponse()
	err = client.DoAction(request, response)
	return
}

// ListDevopsProjectTaskListWithChan invokes the devops_rdc.ListDevopsProjectTaskList API asynchronously
func (client *Client) ListDevopsProjectTaskListWithChan(request *ListDevopsProjectTaskListRequest) (<-chan *ListDevopsProjectTaskListResponse, <-chan error) {
	responseChan := make(chan *ListDevopsProjectTaskListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDevopsProjectTaskList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDevopsProjectTaskListWithCallback invokes the devops_rdc.ListDevopsProjectTaskList API asynchronously
func (client *Client) ListDevopsProjectTaskListWithCallback(request *ListDevopsProjectTaskListRequest, callback func(response *ListDevopsProjectTaskListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDevopsProjectTaskListResponse
		var err error
		defer close(result)
		response, err = client.ListDevopsProjectTaskList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDevopsProjectTaskListRequest is the request struct for api ListDevopsProjectTaskList
type ListDevopsProjectTaskListRequest struct {
	*requests.RpcRequest
	ProjectId string `position:"Body" name:"ProjectId"`
	OrgId     string `position:"Body" name:"OrgId"`
}

// ListDevopsProjectTaskListResponse is the response struct for api ListDevopsProjectTaskList
type ListDevopsProjectTaskListResponse struct {
	*responses.BaseResponse
	Successful bool                              `json:"Successful" xml:"Successful"`
	ErrorCode  string                            `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string                            `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string                            `json:"RequestId" xml:"RequestId"`
	Object     ObjectInListDevopsProjectTaskList `json:"Object" xml:"Object"`
}

// CreateListDevopsProjectTaskListRequest creates a request to invoke ListDevopsProjectTaskList API
func CreateListDevopsProjectTaskListRequest() (request *ListDevopsProjectTaskListRequest) {
	request = &ListDevopsProjectTaskListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "ListDevopsProjectTaskList", "", "")
	request.Method = requests.POST
	return
}

// CreateListDevopsProjectTaskListResponse creates a response to parse from ListDevopsProjectTaskList response
func CreateListDevopsProjectTaskListResponse() (response *ListDevopsProjectTaskListResponse) {
	response = &ListDevopsProjectTaskListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
