package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLogicTableRouteConfig invokes the dms_enterprise.DeleteLogicTableRouteConfig API synchronously
func (client *Client) DeleteLogicTableRouteConfig(request *DeleteLogicTableRouteConfigRequest) (response *DeleteLogicTableRouteConfigResponse, err error) {
	response = CreateDeleteLogicTableRouteConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLogicTableRouteConfigWithChan invokes the dms_enterprise.DeleteLogicTableRouteConfig API asynchronously
func (client *Client) DeleteLogicTableRouteConfigWithChan(request *DeleteLogicTableRouteConfigRequest) (<-chan *DeleteLogicTableRouteConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteLogicTableRouteConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLogicTableRouteConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLogicTableRouteConfigWithCallback invokes the dms_enterprise.DeleteLogicTableRouteConfig API asynchronously
func (client *Client) DeleteLogicTableRouteConfigWithCallback(request *DeleteLogicTableRouteConfigRequest, callback func(response *DeleteLogicTableRouteConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLogicTableRouteConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteLogicTableRouteConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLogicTableRouteConfigRequest is the request struct for api DeleteLogicTableRouteConfig
type DeleteLogicTableRouteConfigRequest struct {
	*requests.RpcRequest
	RouteKey string           `position:"Query" name:"RouteKey"`
	Tid      requests.Integer `position:"Query" name:"Tid"`
	TableId  requests.Integer `position:"Query" name:"TableId"`
}

// DeleteLogicTableRouteConfigResponse is the response struct for api DeleteLogicTableRouteConfig
type DeleteLogicTableRouteConfigResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateDeleteLogicTableRouteConfigRequest creates a request to invoke DeleteLogicTableRouteConfig API
func CreateDeleteLogicTableRouteConfigRequest() (request *DeleteLogicTableRouteConfigRequest) {
	request = &DeleteLogicTableRouteConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "DeleteLogicTableRouteConfig", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLogicTableRouteConfigResponse creates a response to parse from DeleteLogicTableRouteConfig response
func CreateDeleteLogicTableRouteConfigResponse() (response *DeleteLogicTableRouteConfigResponse) {
	response = &DeleteLogicTableRouteConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
