package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MonitorExamination invokes the facebody.MonitorExamination API synchronously
func (client *Client) MonitorExamination(request *MonitorExaminationRequest) (response *MonitorExaminationResponse, err error) {
	response = CreateMonitorExaminationResponse()
	err = client.DoAction(request, response)
	return
}

// MonitorExaminationWithChan invokes the facebody.MonitorExamination API asynchronously
func (client *Client) MonitorExaminationWithChan(request *MonitorExaminationRequest) (<-chan *MonitorExaminationResponse, <-chan error) {
	responseChan := make(chan *MonitorExaminationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MonitorExamination(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MonitorExaminationWithCallback invokes the facebody.MonitorExamination API asynchronously
func (client *Client) MonitorExaminationWithCallback(request *MonitorExaminationRequest, callback func(response *MonitorExaminationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MonitorExaminationResponse
		var err error
		defer close(result)
		response, err = client.MonitorExamination(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MonitorExaminationRequest is the request struct for api MonitorExamination
type MonitorExaminationRequest struct {
	*requests.RpcRequest
	Type     requests.Integer `position:"Body" name:"Type"`
	ImageURL string           `position:"Body" name:"ImageURL"`
}

// MonitorExaminationResponse is the response struct for api MonitorExamination
type MonitorExaminationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateMonitorExaminationRequest creates a request to invoke MonitorExamination API
func CreateMonitorExaminationRequest() (request *MonitorExaminationRequest) {
	request = &MonitorExaminationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "MonitorExamination", "facebody", "openAPI")
	request.Method = requests.POST
	return
}

// CreateMonitorExaminationResponse creates a response to parse from MonitorExamination response
func CreateMonitorExaminationResponse() (response *MonitorExaminationResponse) {
	response = &MonitorExaminationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
