package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListJob invokes the foas.ListJob API synchronously
func (client *Client) ListJob(request *ListJobRequest) (response *ListJobResponse, err error) {
	response = CreateListJobResponse()
	err = client.DoAction(request, response)
	return
}

// ListJobWithChan invokes the foas.ListJob API asynchronously
func (client *Client) ListJobWithChan(request *ListJobRequest) (<-chan *ListJobResponse, <-chan error) {
	responseChan := make(chan *ListJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListJobWithCallback invokes the foas.ListJob API asynchronously
func (client *Client) ListJobWithCallback(request *ListJobRequest, callback func(response *ListJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListJobResponse
		var err error
		defer close(result)
		response, err = client.ListJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListJobRequest is the request struct for api ListJob
type ListJobRequest struct {
	*requests.RoaRequest
	QueueName       string           `position:"Query" name:"queueName"`
	ProjectName     string           `position:"Path" name:"projectName"`
	PageSize        requests.Integer `position:"Query" name:"pageSize"`
	IsShowFullField requests.Boolean `position:"Query" name:"isShowFullField"`
	PageIndex       requests.Integer `position:"Query" name:"pageIndex"`
	EngineVersion   string           `position:"Query" name:"engineVersion"`
	ClusterId       string           `position:"Query" name:"clusterId"`
	JobType         string           `position:"Query" name:"jobType"`
	ApiType         string           `position:"Query" name:"apiType"`
	JobName         string           `position:"Query" name:"jobName"`
	FolderId        requests.Integer `position:"Query" name:"folderId"`
}

// ListJobResponse is the response struct for api ListJob
type ListJobResponse struct {
	*responses.BaseResponse
	RequestId  string        `json:"RequestId" xml:"RequestId"`
	PageIndex  int           `json:"PageIndex" xml:"PageIndex"`
	PageSize   int           `json:"PageSize" xml:"PageSize"`
	TotalPage  int           `json:"TotalPage" xml:"TotalPage"`
	TotalCount int64         `json:"TotalCount" xml:"TotalCount"`
	Jobs       JobsInListJob `json:"Jobs" xml:"Jobs"`
}

// CreateListJobRequest creates a request to invoke ListJob API
func CreateListJobRequest() (request *ListJobRequest) {
	request = &ListJobRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "ListJob", "/api/v2/projects/[projectName]/jobs", "foas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListJobResponse creates a response to parse from ListJob response
func CreateListJobResponse() (response *ListJobResponse) {
	response = &ListJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
