package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteHBaseHaDB invokes the hbase.DeleteHBaseHaDB API synchronously
func (client *Client) DeleteHBaseHaDB(request *DeleteHBaseHaDBRequest) (response *DeleteHBaseHaDBResponse, err error) {
	response = CreateDeleteHBaseHaDBResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteHBaseHaDBWithChan invokes the hbase.DeleteHBaseHaDB API asynchronously
func (client *Client) DeleteHBaseHaDBWithChan(request *DeleteHBaseHaDBRequest) (<-chan *DeleteHBaseHaDBResponse, <-chan error) {
	responseChan := make(chan *DeleteHBaseHaDBResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteHBaseHaDB(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteHBaseHaDBWithCallback invokes the hbase.DeleteHBaseHaDB API asynchronously
func (client *Client) DeleteHBaseHaDBWithCallback(request *DeleteHBaseHaDBRequest, callback func(response *DeleteHBaseHaDBResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteHBaseHaDBResponse
		var err error
		defer close(result)
		response, err = client.DeleteHBaseHaDB(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteHBaseHaDBRequest is the request struct for api DeleteHBaseHaDB
type DeleteHBaseHaDBRequest struct {
	*requests.RpcRequest
	HaId  string `position:"Query" name:"HaId"`
	BdsId string `position:"Query" name:"BdsId"`
}

// DeleteHBaseHaDBResponse is the response struct for api DeleteHBaseHaDB
type DeleteHBaseHaDBResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteHBaseHaDBRequest creates a request to invoke DeleteHBaseHaDB API
func CreateDeleteHBaseHaDBRequest() (request *DeleteHBaseHaDBRequest) {
	request = &DeleteHBaseHaDBRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "DeleteHBaseHaDB", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteHBaseHaDBResponse creates a response to parse from DeleteHBaseHaDB response
func CreateDeleteHBaseHaDBResponse() (response *DeleteHBaseHaDBResponse) {
	response = &DeleteHBaseHaDBResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
