package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserNetProfileDescription invokes the linkwan.GetUserNetProfileDescription API synchronously
func (client *Client) GetUserNetProfileDescription(request *GetUserNetProfileDescriptionRequest) (response *GetUserNetProfileDescriptionResponse, err error) {
	response = CreateGetUserNetProfileDescriptionResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserNetProfileDescriptionWithChan invokes the linkwan.GetUserNetProfileDescription API asynchronously
func (client *Client) GetUserNetProfileDescriptionWithChan(request *GetUserNetProfileDescriptionRequest) (<-chan *GetUserNetProfileDescriptionResponse, <-chan error) {
	responseChan := make(chan *GetUserNetProfileDescriptionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserNetProfileDescription(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserNetProfileDescriptionWithCallback invokes the linkwan.GetUserNetProfileDescription API asynchronously
func (client *Client) GetUserNetProfileDescriptionWithCallback(request *GetUserNetProfileDescriptionRequest, callback func(response *GetUserNetProfileDescriptionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserNetProfileDescriptionResponse
		var err error
		defer close(result)
		response, err = client.GetUserNetProfileDescription(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserNetProfileDescriptionRequest is the request struct for api GetUserNetProfileDescription
type GetUserNetProfileDescriptionRequest struct {
	*requests.RpcRequest
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// GetUserNetProfileDescriptionResponse is the response struct for api GetUserNetProfileDescription
type GetUserNetProfileDescriptionResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateGetUserNetProfileDescriptionRequest creates a request to invoke GetUserNetProfileDescription API
func CreateGetUserNetProfileDescriptionRequest() (request *GetUserNetProfileDescriptionRequest) {
	request = &GetUserNetProfileDescriptionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "GetUserNetProfileDescription", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetUserNetProfileDescriptionResponse creates a response to parse from GetUserNetProfileDescription response
func CreateGetUserNetProfileDescriptionResponse() (response *GetUserNetProfileDescriptionResponse) {
	response = &GetUserNetProfileDescriptionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
