package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopCaster invokes the live.StopCaster API synchronously
func (client *Client) StopCaster(request *StopCasterRequest) (response *StopCasterResponse, err error) {
	response = CreateStopCasterResponse()
	err = client.DoAction(request, response)
	return
}

// StopCasterWithChan invokes the live.StopCaster API asynchronously
func (client *Client) StopCasterWithChan(request *StopCasterRequest) (<-chan *StopCasterResponse, <-chan error) {
	responseChan := make(chan *StopCasterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopCaster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopCasterWithCallback invokes the live.StopCaster API asynchronously
func (client *Client) StopCasterWithCallback(request *StopCasterRequest, callback func(response *StopCasterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopCasterResponse
		var err error
		defer close(result)
		response, err = client.StopCaster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopCasterRequest is the request struct for api StopCaster
type StopCasterRequest struct {
	*requests.RpcRequest
	CasterId string           `position:"Query" name:"CasterId"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
}

// StopCasterResponse is the response struct for api StopCaster
type StopCasterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopCasterRequest creates a request to invoke StopCaster API
func CreateStopCasterRequest() (request *StopCasterRequest) {
	request = &StopCasterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "StopCaster", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopCasterResponse creates a response to parse from StopCaster response
func CreateStopCasterResponse() (response *StopCasterResponse) {
	response = &StopCasterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
