package nlp_automl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PredictMTModel invokes the nlp_automl.PredictMTModel API synchronously
func (client *Client) PredictMTModel(request *PredictMTModelRequest) (response *PredictMTModelResponse, err error) {
	response = CreatePredictMTModelResponse()
	err = client.DoAction(request, response)
	return
}

// PredictMTModelWithChan invokes the nlp_automl.PredictMTModel API asynchronously
func (client *Client) PredictMTModelWithChan(request *PredictMTModelRequest) (<-chan *PredictMTModelResponse, <-chan error) {
	responseChan := make(chan *PredictMTModelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PredictMTModel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PredictMTModelWithCallback invokes the nlp_automl.PredictMTModel API asynchronously
func (client *Client) PredictMTModelWithCallback(request *PredictMTModelRequest, callback func(response *PredictMTModelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PredictMTModelResponse
		var err error
		defer close(result)
		response, err = client.PredictMTModel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PredictMTModelRequest is the request struct for api PredictMTModel
type PredictMTModelRequest struct {
	*requests.RpcRequest
	Product      string `position:"Query" name:"Product"`
	ModelId      string `position:"Query" name:"ModelId"`
	Content      string `position:"Body" name:"Content"`
	ModelVersion string `position:"Query" name:"ModelVersion"`
}

// PredictMTModelResponse is the response struct for api PredictMTModel
type PredictMTModelResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   int    `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreatePredictMTModelRequest creates a request to invoke PredictMTModel API
func CreatePredictMTModelRequest() (request *PredictMTModelRequest) {
	request = &PredictMTModelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nlp-automl", "2019-07-01", "PredictMTModel", "nlpautoml", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePredictMTModelResponse creates a response to parse from PredictMTModel response
func CreatePredictMTModelResponse() (response *PredictMTModelResponse) {
	response = &PredictMTModelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
