package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePropertyCronDetail invokes the sas.DescribePropertyCronDetail API synchronously
func (client *Client) DescribePropertyCronDetail(request *DescribePropertyCronDetailRequest) (response *DescribePropertyCronDetailResponse, err error) {
	response = CreateDescribePropertyCronDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePropertyCronDetailWithChan invokes the sas.DescribePropertyCronDetail API asynchronously
func (client *Client) DescribePropertyCronDetailWithChan(request *DescribePropertyCronDetailRequest) (<-chan *DescribePropertyCronDetailResponse, <-chan error) {
	responseChan := make(chan *DescribePropertyCronDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePropertyCronDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePropertyCronDetailWithCallback invokes the sas.DescribePropertyCronDetail API asynchronously
func (client *Client) DescribePropertyCronDetailWithCallback(request *DescribePropertyCronDetailRequest, callback func(response *DescribePropertyCronDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePropertyCronDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribePropertyCronDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePropertyCronDetailRequest is the request struct for api DescribePropertyCronDetail
type DescribePropertyCronDetailRequest struct {
	*requests.RpcRequest
	Remark      string           `position:"Query" name:"Remark"`
	Source      string           `position:"Query" name:"Source"`
	Uuid        string           `position:"Query" name:"Uuid"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	User        string           `position:"Query" name:"User"`
}

// DescribePropertyCronDetailResponse is the response struct for api DescribePropertyCronDetail
type DescribePropertyCronDetailResponse struct {
	*responses.BaseResponse
	RequestId string         `json:"RequestId" xml:"RequestId"`
	PageInfo  PageInfo       `json:"PageInfo" xml:"PageInfo"`
	Propertys []PropertyCron `json:"Propertys" xml:"Propertys"`
}

// CreateDescribePropertyCronDetailRequest creates a request to invoke DescribePropertyCronDetail API
func CreateDescribePropertyCronDetailRequest() (request *DescribePropertyCronDetailRequest) {
	request = &DescribePropertyCronDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribePropertyCronDetail", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePropertyCronDetailResponse creates a response to parse from DescribePropertyCronDetail response
func CreateDescribePropertyCronDetailResponse() (response *DescribePropertyCronDetailResponse) {
	response = &DescribePropertyCronDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
