package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckMnsService invokes the sgw.CheckMnsService API synchronously
func (client *Client) CheckMnsService(request *CheckMnsServiceRequest) (response *CheckMnsServiceResponse, err error) {
	response = CreateCheckMnsServiceResponse()
	err = client.DoAction(request, response)
	return
}

// CheckMnsServiceWithChan invokes the sgw.CheckMnsService API asynchronously
func (client *Client) CheckMnsServiceWithChan(request *CheckMnsServiceRequest) (<-chan *CheckMnsServiceResponse, <-chan error) {
	responseChan := make(chan *CheckMnsServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckMnsService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckMnsServiceWithCallback invokes the sgw.CheckMnsService API asynchronously
func (client *Client) CheckMnsServiceWithCallback(request *CheckMnsServiceRequest, callback func(response *CheckMnsServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckMnsServiceResponse
		var err error
		defer close(result)
		response, err = client.CheckMnsService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckMnsServiceRequest is the request struct for api CheckMnsService
type CheckMnsServiceRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// CheckMnsServiceResponse is the response struct for api CheckMnsService
type CheckMnsServiceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	Message      string `json:"Message" xml:"Message"`
	IsEnabled    bool   `json:"IsEnabled" xml:"IsEnabled"`
	CheckMessage string `json:"CheckMessage" xml:"CheckMessage"`
}

// CreateCheckMnsServiceRequest creates a request to invoke CheckMnsService API
func CreateCheckMnsServiceRequest() (request *CheckMnsServiceRequest) {
	request = &CheckMnsServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "CheckMnsService", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckMnsServiceResponse creates a response to parse from CheckMnsService response
func CreateCheckMnsServiceResponse() (response *CheckMnsServiceResponse) {
	response = &CheckMnsServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
