package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnsubscribeSpaceEvent invokes the vcs.UnsubscribeSpaceEvent API synchronously
func (client *Client) UnsubscribeSpaceEvent(request *UnsubscribeSpaceEventRequest) (response *UnsubscribeSpaceEventResponse, err error) {
	response = CreateUnsubscribeSpaceEventResponse()
	err = client.DoAction(request, response)
	return
}

// UnsubscribeSpaceEventWithChan invokes the vcs.UnsubscribeSpaceEvent API asynchronously
func (client *Client) UnsubscribeSpaceEventWithChan(request *UnsubscribeSpaceEventRequest) (<-chan *UnsubscribeSpaceEventResponse, <-chan error) {
	responseChan := make(chan *UnsubscribeSpaceEventResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnsubscribeSpaceEvent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnsubscribeSpaceEventWithCallback invokes the vcs.UnsubscribeSpaceEvent API asynchronously
func (client *Client) UnsubscribeSpaceEventWithCallback(request *UnsubscribeSpaceEventRequest, callback func(response *UnsubscribeSpaceEventResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnsubscribeSpaceEventResponse
		var err error
		defer close(result)
		response, err = client.UnsubscribeSpaceEvent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnsubscribeSpaceEventRequest is the request struct for api UnsubscribeSpaceEvent
type UnsubscribeSpaceEventRequest struct {
	*requests.RpcRequest
	SpaceId string `position:"Query" name:"SpaceId"`
}

// UnsubscribeSpaceEventResponse is the response struct for api UnsubscribeSpaceEvent
type UnsubscribeSpaceEventResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUnsubscribeSpaceEventRequest creates a request to invoke UnsubscribeSpaceEvent API
func CreateUnsubscribeSpaceEventRequest() (request *UnsubscribeSpaceEventRequest) {
	request = &UnsubscribeSpaceEventRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "UnsubscribeSpaceEvent", "", "")
	request.Method = requests.POST
	return
}

// CreateUnsubscribeSpaceEventResponse creates a response to parse from UnsubscribeSpaceEvent response
func CreateUnsubscribeSpaceEventResponse() (response *UnsubscribeSpaceEventResponse) {
	response = &UnsubscribeSpaceEventResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
