// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationcostprofiler

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opDeleteReportDefinition = "DeleteReportDefinition"

// DeleteReportDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReportDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReportDefinition for more information on using the DeleteReportDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteReportDefinitionRequest method.
//    req, resp := client.DeleteReportDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/DeleteReportDefinition
func (c *ApplicationCostProfiler) DeleteReportDefinitionRequest(input *DeleteReportDefinitionInput) (req *request.Request, output *DeleteReportDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteReportDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/reportDefinition/{reportId}",
	}

	if input == nil {
		input = &DeleteReportDefinitionInput{}
	}

	output = &DeleteReportDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteReportDefinition API operation for AWS Application Cost Profiler.
//
// Deletes the specified report definition in AWS Application Cost Profiler.
// This stops the report from being generated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Cost Profiler's
// API operation DeleteReportDefinition for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
//   * ThrottlingException
//   The calls to AWS Application Cost Profiler API are throttled. The request
//   was denied.
//
//   * ValidationException
//   The input fails to satisfy the constraints for the API.
//
//   * AccessDeniedException
//   You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/DeleteReportDefinition
func (c *ApplicationCostProfiler) DeleteReportDefinition(input *DeleteReportDefinitionInput) (*DeleteReportDefinitionOutput, error) {
	req, out := c.DeleteReportDefinitionRequest(input)
	return out, req.Send()
}

// DeleteReportDefinitionWithContext is the same as DeleteReportDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReportDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationCostProfiler) DeleteReportDefinitionWithContext(ctx aws.Context, input *DeleteReportDefinitionInput, opts ...request.Option) (*DeleteReportDefinitionOutput, error) {
	req, out := c.DeleteReportDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReportDefinition = "GetReportDefinition"

// GetReportDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the GetReportDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReportDefinition for more information on using the GetReportDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetReportDefinitionRequest method.
//    req, resp := client.GetReportDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/GetReportDefinition
func (c *ApplicationCostProfiler) GetReportDefinitionRequest(input *GetReportDefinitionInput) (req *request.Request, output *GetReportDefinitionOutput) {
	op := &request.Operation{
		Name:       opGetReportDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/reportDefinition/{reportId}",
	}

	if input == nil {
		input = &GetReportDefinitionInput{}
	}

	output = &GetReportDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReportDefinition API operation for AWS Application Cost Profiler.
//
// Retrieves the definition of a report already configured in AWS Application
// Cost Profiler.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Cost Profiler's
// API operation GetReportDefinition for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
//   * ThrottlingException
//   The calls to AWS Application Cost Profiler API are throttled. The request
//   was denied.
//
//   * ValidationException
//   The input fails to satisfy the constraints for the API.
//
//   * AccessDeniedException
//   You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/GetReportDefinition
func (c *ApplicationCostProfiler) GetReportDefinition(input *GetReportDefinitionInput) (*GetReportDefinitionOutput, error) {
	req, out := c.GetReportDefinitionRequest(input)
	return out, req.Send()
}

// GetReportDefinitionWithContext is the same as GetReportDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See GetReportDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationCostProfiler) GetReportDefinitionWithContext(ctx aws.Context, input *GetReportDefinitionInput, opts ...request.Option) (*GetReportDefinitionOutput, error) {
	req, out := c.GetReportDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportApplicationUsage = "ImportApplicationUsage"

// ImportApplicationUsageRequest generates a "aws/request.Request" representing the
// client's request for the ImportApplicationUsage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportApplicationUsage for more information on using the ImportApplicationUsage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportApplicationUsageRequest method.
//    req, resp := client.ImportApplicationUsageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/ImportApplicationUsage
func (c *ApplicationCostProfiler) ImportApplicationUsageRequest(input *ImportApplicationUsageInput) (req *request.Request, output *ImportApplicationUsageOutput) {
	op := &request.Operation{
		Name:       opImportApplicationUsage,
		HTTPMethod: "POST",
		HTTPPath:   "/importApplicationUsage",
	}

	if input == nil {
		input = &ImportApplicationUsageInput{}
	}

	output = &ImportApplicationUsageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportApplicationUsage API operation for AWS Application Cost Profiler.
//
// Ingests application usage data from Amazon Simple Storage Service (Amazon
// S3).
//
// The data must already exist in the S3 location. As part of the action, AWS
// Application Cost Profiler copies the object from your S3 bucket to an S3
// bucket owned by Amazon for processing asynchronously.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Cost Profiler's
// API operation ImportApplicationUsage for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
//   * ThrottlingException
//   The calls to AWS Application Cost Profiler API are throttled. The request
//   was denied.
//
//   * ValidationException
//   The input fails to satisfy the constraints for the API.
//
//   * AccessDeniedException
//   You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/ImportApplicationUsage
func (c *ApplicationCostProfiler) ImportApplicationUsage(input *ImportApplicationUsageInput) (*ImportApplicationUsageOutput, error) {
	req, out := c.ImportApplicationUsageRequest(input)
	return out, req.Send()
}

// ImportApplicationUsageWithContext is the same as ImportApplicationUsage with the addition of
// the ability to pass a context and additional request options.
//
// See ImportApplicationUsage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationCostProfiler) ImportApplicationUsageWithContext(ctx aws.Context, input *ImportApplicationUsageInput, opts ...request.Option) (*ImportApplicationUsageOutput, error) {
	req, out := c.ImportApplicationUsageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListReportDefinitions = "ListReportDefinitions"

// ListReportDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListReportDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReportDefinitions for more information on using the ListReportDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListReportDefinitionsRequest method.
//    req, resp := client.ListReportDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/ListReportDefinitions
func (c *ApplicationCostProfiler) ListReportDefinitionsRequest(input *ListReportDefinitionsInput) (req *request.Request, output *ListReportDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListReportDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/reportDefinition",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReportDefinitionsInput{}
	}

	output = &ListReportDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListReportDefinitions API operation for AWS Application Cost Profiler.
//
// Retrieves a list of all reports and their configurations for your AWS account.
//
// The maximum number of reports is one.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Cost Profiler's
// API operation ListReportDefinitions for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
//   * ThrottlingException
//   The calls to AWS Application Cost Profiler API are throttled. The request
//   was denied.
//
//   * ValidationException
//   The input fails to satisfy the constraints for the API.
//
//   * AccessDeniedException
//   You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/ListReportDefinitions
func (c *ApplicationCostProfiler) ListReportDefinitions(input *ListReportDefinitionsInput) (*ListReportDefinitionsOutput, error) {
	req, out := c.ListReportDefinitionsRequest(input)
	return out, req.Send()
}

// ListReportDefinitionsWithContext is the same as ListReportDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListReportDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationCostProfiler) ListReportDefinitionsWithContext(ctx aws.Context, input *ListReportDefinitionsInput, opts ...request.Option) (*ListReportDefinitionsOutput, error) {
	req, out := c.ListReportDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReportDefinitionsPages iterates over the pages of a ListReportDefinitions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReportDefinitions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListReportDefinitions operation.
//    pageNum := 0
//    err := client.ListReportDefinitionsPages(params,
//        func(page *applicationcostprofiler.ListReportDefinitionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ApplicationCostProfiler) ListReportDefinitionsPages(input *ListReportDefinitionsInput, fn func(*ListReportDefinitionsOutput, bool) bool) error {
	return c.ListReportDefinitionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReportDefinitionsPagesWithContext same as ListReportDefinitionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationCostProfiler) ListReportDefinitionsPagesWithContext(ctx aws.Context, input *ListReportDefinitionsInput, fn func(*ListReportDefinitionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReportDefinitionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReportDefinitionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListReportDefinitionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutReportDefinition = "PutReportDefinition"

// PutReportDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the PutReportDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutReportDefinition for more information on using the PutReportDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutReportDefinitionRequest method.
//    req, resp := client.PutReportDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/PutReportDefinition
func (c *ApplicationCostProfiler) PutReportDefinitionRequest(input *PutReportDefinitionInput) (req *request.Request, output *PutReportDefinitionOutput) {
	op := &request.Operation{
		Name:       opPutReportDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/reportDefinition",
	}

	if input == nil {
		input = &PutReportDefinitionInput{}
	}

	output = &PutReportDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutReportDefinition API operation for AWS Application Cost Profiler.
//
// Creates the report definition for a report in Application Cost Profiler.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Cost Profiler's
// API operation PutReportDefinition for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
//   * ThrottlingException
//   The calls to AWS Application Cost Profiler API are throttled. The request
//   was denied.
//
//   * ValidationException
//   The input fails to satisfy the constraints for the API.
//
//   * AccessDeniedException
//   You do not have permission to perform this action.
//
//   * ServiceQuotaExceededException
//   Your request exceeds one or more of the service quotas.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/PutReportDefinition
func (c *ApplicationCostProfiler) PutReportDefinition(input *PutReportDefinitionInput) (*PutReportDefinitionOutput, error) {
	req, out := c.PutReportDefinitionRequest(input)
	return out, req.Send()
}

// PutReportDefinitionWithContext is the same as PutReportDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See PutReportDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationCostProfiler) PutReportDefinitionWithContext(ctx aws.Context, input *PutReportDefinitionInput, opts ...request.Option) (*PutReportDefinitionOutput, error) {
	req, out := c.PutReportDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateReportDefinition = "UpdateReportDefinition"

// UpdateReportDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateReportDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateReportDefinition for more information on using the UpdateReportDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateReportDefinitionRequest method.
//    req, resp := client.UpdateReportDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/UpdateReportDefinition
func (c *ApplicationCostProfiler) UpdateReportDefinitionRequest(input *UpdateReportDefinitionInput) (req *request.Request, output *UpdateReportDefinitionOutput) {
	op := &request.Operation{
		Name:       opUpdateReportDefinition,
		HTTPMethod: "PUT",
		HTTPPath:   "/reportDefinition/{reportId}",
	}

	if input == nil {
		input = &UpdateReportDefinitionInput{}
	}

	output = &UpdateReportDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateReportDefinition API operation for AWS Application Cost Profiler.
//
// Updates existing report in AWS Application Cost Profiler.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Cost Profiler's
// API operation UpdateReportDefinition for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
//   * ThrottlingException
//   The calls to AWS Application Cost Profiler API are throttled. The request
//   was denied.
//
//   * ValidationException
//   The input fails to satisfy the constraints for the API.
//
//   * AccessDeniedException
//   You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/UpdateReportDefinition
func (c *ApplicationCostProfiler) UpdateReportDefinition(input *UpdateReportDefinitionInput) (*UpdateReportDefinitionOutput, error) {
	req, out := c.UpdateReportDefinitionRequest(input)
	return out, req.Send()
}

// UpdateReportDefinitionWithContext is the same as UpdateReportDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateReportDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationCostProfiler) UpdateReportDefinitionWithContext(ctx aws.Context, input *UpdateReportDefinitionInput, opts ...request.Option) (*UpdateReportDefinitionOutput, error) {
	req, out := c.UpdateReportDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have permission to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeleteReportDefinitionInput struct {
	_ struct{} `type:"structure"`

	// Required. ID of the report to delete.
	//
	// ReportId is a required field
	ReportId *string `location:"uri" locationName:"reportId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReportDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReportDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReportDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReportDefinitionInput"}
	if s.ReportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportId"))
	}
	if s.ReportId != nil && len(*s.ReportId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReportId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportId sets the ReportId field's value.
func (s *DeleteReportDefinitionInput) SetReportId(v string) *DeleteReportDefinitionInput {
	s.ReportId = &v
	return s
}

type DeleteReportDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// ID of the report that was deleted.
	ReportId *string `locationName:"reportId" min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteReportDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReportDefinitionOutput) GoString() string {
	return s.String()
}

// SetReportId sets the ReportId field's value.
func (s *DeleteReportDefinitionOutput) SetReportId(v string) *DeleteReportDefinitionOutput {
	s.ReportId = &v
	return s
}

type GetReportDefinitionInput struct {
	_ struct{} `type:"structure"`

	// ID of the report to retrieve.
	//
	// ReportId is a required field
	ReportId *string `location:"uri" locationName:"reportId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetReportDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReportDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReportDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReportDefinitionInput"}
	if s.ReportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportId"))
	}
	if s.ReportId != nil && len(*s.ReportId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReportId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportId sets the ReportId field's value.
func (s *GetReportDefinitionInput) SetReportId(v string) *GetReportDefinitionInput {
	s.ReportId = &v
	return s
}

type GetReportDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// Timestamp (milliseconds) when this report definition was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// Amazon Simple Storage Service (Amazon S3) location where the report is uploaded.
	//
	// DestinationS3Location is a required field
	DestinationS3Location *S3Location `locationName:"destinationS3Location" type:"structure" required:"true"`

	// Format of the generated report.
	//
	// Format is a required field
	Format *string `locationName:"format" type:"string" required:"true" enum:"Format"`

	// Timestamp (milliseconds) when this report definition was last updated.
	//
	// LastUpdated is a required field
	LastUpdated *time.Time `locationName:"lastUpdated" type:"timestamp" required:"true"`

	// Description of the report.
	//
	// ReportDescription is a required field
	ReportDescription *string `locationName:"reportDescription" min:"1" type:"string" required:"true"`

	// Cadence used to generate the report.
	//
	// ReportFrequency is a required field
	ReportFrequency *string `locationName:"reportFrequency" type:"string" required:"true" enum:"ReportFrequency"`

	// ID of the report retrieved.
	//
	// ReportId is a required field
	ReportId *string `locationName:"reportId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetReportDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReportDefinitionOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetReportDefinitionOutput) SetCreatedAt(v time.Time) *GetReportDefinitionOutput {
	s.CreatedAt = &v
	return s
}

// SetDestinationS3Location sets the DestinationS3Location field's value.
func (s *GetReportDefinitionOutput) SetDestinationS3Location(v *S3Location) *GetReportDefinitionOutput {
	s.DestinationS3Location = v
	return s
}

// SetFormat sets the Format field's value.
func (s *GetReportDefinitionOutput) SetFormat(v string) *GetReportDefinitionOutput {
	s.Format = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *GetReportDefinitionOutput) SetLastUpdated(v time.Time) *GetReportDefinitionOutput {
	s.LastUpdated = &v
	return s
}

// SetReportDescription sets the ReportDescription field's value.
func (s *GetReportDefinitionOutput) SetReportDescription(v string) *GetReportDefinitionOutput {
	s.ReportDescription = &v
	return s
}

// SetReportFrequency sets the ReportFrequency field's value.
func (s *GetReportDefinitionOutput) SetReportFrequency(v string) *GetReportDefinitionOutput {
	s.ReportFrequency = &v
	return s
}

// SetReportId sets the ReportId field's value.
func (s *GetReportDefinitionOutput) SetReportId(v string) *GetReportDefinitionOutput {
	s.ReportId = &v
	return s
}

type ImportApplicationUsageInput struct {
	_ struct{} `type:"structure"`

	// Amazon S3 location to import application usage data from.
	//
	// SourceS3Location is a required field
	SourceS3Location *SourceS3Location `locationName:"sourceS3Location" type:"structure" required:"true"`
}

// String returns the string representation
func (s ImportApplicationUsageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportApplicationUsageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportApplicationUsageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportApplicationUsageInput"}
	if s.SourceS3Location == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceS3Location"))
	}
	if s.SourceS3Location != nil {
		if err := s.SourceS3Location.Validate(); err != nil {
			invalidParams.AddNested("SourceS3Location", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceS3Location sets the SourceS3Location field's value.
func (s *ImportApplicationUsageInput) SetSourceS3Location(v *SourceS3Location) *ImportApplicationUsageInput {
	s.SourceS3Location = v
	return s
}

type ImportApplicationUsageOutput struct {
	_ struct{} `type:"structure"`

	// ID of the import request.
	//
	// ImportId is a required field
	ImportId *string `locationName:"importId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ImportApplicationUsageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportApplicationUsageOutput) GoString() string {
	return s.String()
}

// SetImportId sets the ImportId field's value.
func (s *ImportApplicationUsageOutput) SetImportId(v string) *ImportApplicationUsageOutput {
	s.ImportId = &v
	return s
}

// An internal server error occurred. Retry your request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListReportDefinitionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token value from a previous call to access the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListReportDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReportDefinitionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReportDefinitionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReportDefinitionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListReportDefinitionsInput) SetMaxResults(v int64) *ListReportDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReportDefinitionsInput) SetNextToken(v string) *ListReportDefinitionsInput {
	s.NextToken = &v
	return s
}

type ListReportDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	// The value of the next token, if it exists. Null if there are no more results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The retrieved reports.
	ReportDefinitions []*ReportDefinition `locationName:"reportDefinitions" type:"list"`
}

// String returns the string representation
func (s ListReportDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReportDefinitionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListReportDefinitionsOutput) SetNextToken(v string) *ListReportDefinitionsOutput {
	s.NextToken = &v
	return s
}

// SetReportDefinitions sets the ReportDefinitions field's value.
func (s *ListReportDefinitionsOutput) SetReportDefinitions(v []*ReportDefinition) *ListReportDefinitionsOutput {
	s.ReportDefinitions = v
	return s
}

type PutReportDefinitionInput struct {
	_ struct{} `type:"structure"`

	// Required. Amazon Simple Storage Service (Amazon S3) location where Application
	// Cost Profiler uploads the report.
	//
	// DestinationS3Location is a required field
	DestinationS3Location *S3Location `locationName:"destinationS3Location" type:"structure" required:"true"`

	// Required. The format to use for the generated report.
	//
	// Format is a required field
	Format *string `locationName:"format" type:"string" required:"true" enum:"Format"`

	// Required. Description of the report.
	//
	// ReportDescription is a required field
	ReportDescription *string `locationName:"reportDescription" min:"1" type:"string" required:"true"`

	// Required. The cadence to generate the report.
	//
	// ReportFrequency is a required field
	ReportFrequency *string `locationName:"reportFrequency" type:"string" required:"true" enum:"ReportFrequency"`

	// Required. ID of the report. You can choose any valid string matching the
	// pattern for the ID.
	//
	// ReportId is a required field
	ReportId *string `locationName:"reportId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutReportDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutReportDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutReportDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutReportDefinitionInput"}
	if s.DestinationS3Location == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationS3Location"))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.ReportDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportDescription"))
	}
	if s.ReportDescription != nil && len(*s.ReportDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReportDescription", 1))
	}
	if s.ReportFrequency == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportFrequency"))
	}
	if s.ReportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportId"))
	}
	if s.ReportId != nil && len(*s.ReportId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReportId", 1))
	}
	if s.DestinationS3Location != nil {
		if err := s.DestinationS3Location.Validate(); err != nil {
			invalidParams.AddNested("DestinationS3Location", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationS3Location sets the DestinationS3Location field's value.
func (s *PutReportDefinitionInput) SetDestinationS3Location(v *S3Location) *PutReportDefinitionInput {
	s.DestinationS3Location = v
	return s
}

// SetFormat sets the Format field's value.
func (s *PutReportDefinitionInput) SetFormat(v string) *PutReportDefinitionInput {
	s.Format = &v
	return s
}

// SetReportDescription sets the ReportDescription field's value.
func (s *PutReportDefinitionInput) SetReportDescription(v string) *PutReportDefinitionInput {
	s.ReportDescription = &v
	return s
}

// SetReportFrequency sets the ReportFrequency field's value.
func (s *PutReportDefinitionInput) SetReportFrequency(v string) *PutReportDefinitionInput {
	s.ReportFrequency = &v
	return s
}

// SetReportId sets the ReportId field's value.
func (s *PutReportDefinitionInput) SetReportId(v string) *PutReportDefinitionInput {
	s.ReportId = &v
	return s
}

type PutReportDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// ID of the report.
	ReportId *string `locationName:"reportId" min:"1" type:"string"`
}

// String returns the string representation
func (s PutReportDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutReportDefinitionOutput) GoString() string {
	return s.String()
}

// SetReportId sets the ReportId field's value.
func (s *PutReportDefinitionOutput) SetReportId(v string) *PutReportDefinitionOutput {
	s.ReportId = &v
	return s
}

// The configuration of a report in AWS Application Cost Profiler.
type ReportDefinition struct {
	_ struct{} `type:"structure"`

	// Timestamp (milliseconds) when this report definition was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The location in Amazon Simple Storage Service (Amazon S3) the reports should
	// be saved to.
	DestinationS3Location *S3Location `locationName:"destinationS3Location" type:"structure"`

	// The format used for the generated reports.
	Format *string `locationName:"format" type:"string" enum:"Format"`

	// Timestamp (milliseconds) when this report definition was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// Description of the report
	ReportDescription *string `locationName:"reportDescription" min:"1" type:"string"`

	// The cadence at which the report is generated.
	ReportFrequency *string `locationName:"reportFrequency" type:"string" enum:"ReportFrequency"`

	// The ID of the report.
	ReportId *string `locationName:"reportId" min:"1" type:"string"`
}

// String returns the string representation
func (s ReportDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReportDefinition) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ReportDefinition) SetCreatedAt(v time.Time) *ReportDefinition {
	s.CreatedAt = &v
	return s
}

// SetDestinationS3Location sets the DestinationS3Location field's value.
func (s *ReportDefinition) SetDestinationS3Location(v *S3Location) *ReportDefinition {
	s.DestinationS3Location = v
	return s
}

// SetFormat sets the Format field's value.
func (s *ReportDefinition) SetFormat(v string) *ReportDefinition {
	s.Format = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ReportDefinition) SetLastUpdatedAt(v time.Time) *ReportDefinition {
	s.LastUpdatedAt = &v
	return s
}

// SetReportDescription sets the ReportDescription field's value.
func (s *ReportDefinition) SetReportDescription(v string) *ReportDefinition {
	s.ReportDescription = &v
	return s
}

// SetReportFrequency sets the ReportFrequency field's value.
func (s *ReportDefinition) SetReportFrequency(v string) *ReportDefinition {
	s.ReportFrequency = &v
	return s
}

// SetReportId sets the ReportId field's value.
func (s *ReportDefinition) SetReportId(v string) *ReportDefinition {
	s.ReportId = &v
	return s
}

// Represents the Amazon Simple Storage Service (Amazon S3) location where AWS
// Application Cost Profiler reports are generated and then written to.
type S3Location struct {
	_ struct{} `type:"structure"`

	// Name of the S3 bucket.
	//
	// Bucket is a required field
	Bucket *string `locationName:"bucket" min:"3" type:"string" required:"true"`

	// Prefix for the location to write to.
	//
	// Prefix is a required field
	Prefix *string `locationName:"prefix" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Location) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Location) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Location"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.Prefix == nil {
		invalidParams.Add(request.NewErrParamRequired("Prefix"))
	}
	if s.Prefix != nil && len(*s.Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *S3Location) SetBucket(v string) *S3Location {
	s.Bucket = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3Location) SetPrefix(v string) *S3Location {
	s.Prefix = &v
	return s
}

// Your request exceeds one or more of the service quotas.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the Amazon Simple Storage Service (Amazon S3) location where usage
// data is read from.
type SourceS3Location struct {
	_ struct{} `type:"structure"`

	// Name of the bucket.
	//
	// Bucket is a required field
	Bucket *string `locationName:"bucket" min:"3" type:"string" required:"true"`

	// Key of the object.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// Region of the bucket. Only required for Regions that are disabled by default.
	// For more infomration about Regions that are disabled by default, see Enabling
	// a Region (https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable)
	// in the AWS General Reference guide.
	Region *string `locationName:"region" type:"string" enum:"S3BucketRegion"`
}

// String returns the string representation
func (s SourceS3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceS3Location) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceS3Location) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceS3Location"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *SourceS3Location) SetBucket(v string) *SourceS3Location {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *SourceS3Location) SetKey(v string) *SourceS3Location {
	s.Key = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *SourceS3Location) SetRegion(v string) *SourceS3Location {
	s.Region = &v
	return s
}

// The calls to AWS Application Cost Profiler API are throttled. The request
// was denied.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateReportDefinitionInput struct {
	_ struct{} `type:"structure"`

	// Required. Amazon Simple Storage Service (Amazon S3) location where Application
	// Cost Profiler uploads the report.
	//
	// DestinationS3Location is a required field
	DestinationS3Location *S3Location `locationName:"destinationS3Location" type:"structure" required:"true"`

	// Required. The format to use for the generated report.
	//
	// Format is a required field
	Format *string `locationName:"format" type:"string" required:"true" enum:"Format"`

	// Required. Description of the report.
	//
	// ReportDescription is a required field
	ReportDescription *string `locationName:"reportDescription" min:"1" type:"string" required:"true"`

	// Required. The cadence to generate the report.
	//
	// ReportFrequency is a required field
	ReportFrequency *string `locationName:"reportFrequency" type:"string" required:"true" enum:"ReportFrequency"`

	// Required. ID of the report to update.
	//
	// ReportId is a required field
	ReportId *string `location:"uri" locationName:"reportId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateReportDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateReportDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateReportDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateReportDefinitionInput"}
	if s.DestinationS3Location == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationS3Location"))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.ReportDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportDescription"))
	}
	if s.ReportDescription != nil && len(*s.ReportDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReportDescription", 1))
	}
	if s.ReportFrequency == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportFrequency"))
	}
	if s.ReportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportId"))
	}
	if s.ReportId != nil && len(*s.ReportId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReportId", 1))
	}
	if s.DestinationS3Location != nil {
		if err := s.DestinationS3Location.Validate(); err != nil {
			invalidParams.AddNested("DestinationS3Location", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationS3Location sets the DestinationS3Location field's value.
func (s *UpdateReportDefinitionInput) SetDestinationS3Location(v *S3Location) *UpdateReportDefinitionInput {
	s.DestinationS3Location = v
	return s
}

// SetFormat sets the Format field's value.
func (s *UpdateReportDefinitionInput) SetFormat(v string) *UpdateReportDefinitionInput {
	s.Format = &v
	return s
}

// SetReportDescription sets the ReportDescription field's value.
func (s *UpdateReportDefinitionInput) SetReportDescription(v string) *UpdateReportDefinitionInput {
	s.ReportDescription = &v
	return s
}

// SetReportFrequency sets the ReportFrequency field's value.
func (s *UpdateReportDefinitionInput) SetReportFrequency(v string) *UpdateReportDefinitionInput {
	s.ReportFrequency = &v
	return s
}

// SetReportId sets the ReportId field's value.
func (s *UpdateReportDefinitionInput) SetReportId(v string) *UpdateReportDefinitionInput {
	s.ReportId = &v
	return s
}

type UpdateReportDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// ID of the report.
	ReportId *string `locationName:"reportId" min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateReportDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateReportDefinitionOutput) GoString() string {
	return s.String()
}

// SetReportId sets the ReportId field's value.
func (s *UpdateReportDefinitionOutput) SetReportId(v string) *UpdateReportDefinitionOutput {
	s.ReportId = &v
	return s
}

// The input fails to satisfy the constraints for the API.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// FormatCsv is a Format enum value
	FormatCsv = "CSV"

	// FormatParquet is a Format enum value
	FormatParquet = "PARQUET"
)

// Format_Values returns all elements of the Format enum
func Format_Values() []string {
	return []string{
		FormatCsv,
		FormatParquet,
	}
}

const (
	// ReportFrequencyMonthly is a ReportFrequency enum value
	ReportFrequencyMonthly = "MONTHLY"

	// ReportFrequencyDaily is a ReportFrequency enum value
	ReportFrequencyDaily = "DAILY"

	// ReportFrequencyAll is a ReportFrequency enum value
	ReportFrequencyAll = "ALL"
)

// ReportFrequency_Values returns all elements of the ReportFrequency enum
func ReportFrequency_Values() []string {
	return []string{
		ReportFrequencyMonthly,
		ReportFrequencyDaily,
		ReportFrequencyAll,
	}
}

const (
	// S3BucketRegionApEast1 is a S3BucketRegion enum value
	S3BucketRegionApEast1 = "ap-east-1"

	// S3BucketRegionMeSouth1 is a S3BucketRegion enum value
	S3BucketRegionMeSouth1 = "me-south-1"

	// S3BucketRegionEuSouth1 is a S3BucketRegion enum value
	S3BucketRegionEuSouth1 = "eu-south-1"

	// S3BucketRegionAfSouth1 is a S3BucketRegion enum value
	S3BucketRegionAfSouth1 = "af-south-1"
)

// S3BucketRegion_Values returns all elements of the S3BucketRegion enum
func S3BucketRegion_Values() []string {
	return []string{
		S3BucketRegionApEast1,
		S3BucketRegionMeSouth1,
		S3BucketRegionEuSouth1,
		S3BucketRegionAfSouth1,
	}
}
