package porterstemmer

import (
	"testing"
)

func TestStep1c(t *testing.T) {

	i := 0

	tests := make([]struct {
		S        []rune
		Expected []rune
	}, 17)

	tests[i].S = []rune("happy")
	tests[i].Expected = []rune("happi")
	i++

	tests[i].S = []rune("sky")
	tests[i].Expected = []rune("sky")
	i++

	tests[i].S = []rune("apology")
	tests[i].Expected = []rune("apologi")
	i++

	for _, datum := range tests {

		actual := make([]rune, len(datum.S))
		copy(actual, datum.S)

		actual = step1c(actual)

		lenActual := len(actual)
		lenExpected := len(datum.Expected)

		equal := true
		if 0 == lenActual && 0 == lenExpected {
			equal = true
		} else if lenActual != lenExpected {
			equal = false
		} else if actual[0] != datum.Expected[0] {
			equal = false
		} else if actual[lenActual-1] != datum.Expected[lenExpected-1] {
			equal = false
		} else {
			for j := 0; j < lenActual; j++ {

				if actual[j] != datum.Expected[j] {
					equal = false
				}
			}
		}

		if !equal {
			t.Errorf("Did NOT get what was expected for calling step1c() on [%s]. Expect [%s] but got [%s]", string(datum.S), string(datum.Expected), string(actual))
		}
	}
}
