// This file is generated by "./lib/proto/generate"

package proto

import (
	"github.com/ysmood/gson"
)

/*

Database

*/

// DatabaseDatabaseID Unique identifier of Database object.
type DatabaseDatabaseID string

// DatabaseDatabase Database object.
type DatabaseDatabase struct {
	// ID Database ID.
	ID DatabaseDatabaseID `json:"id"`

	// Domain Database domain.
	Domain string `json:"domain"`

	// Name Database name.
	Name string `json:"name"`

	// Version Database version.
	Version string `json:"version"`
}

// DatabaseError Database error.
type DatabaseError struct {
	// Message Error message.
	Message string `json:"message"`

	// Code Error code.
	Code int `json:"code"`
}

// DatabaseDisable Disables database tracking, prevents database events from being sent to the client.
type DatabaseDisable struct{}

// ProtoReq name
func (m DatabaseDisable) ProtoReq() string { return "Database.disable" }

// Call sends the request
func (m DatabaseDisable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DatabaseEnable Enables database tracking, database events will now be delivered to the client.
type DatabaseEnable struct{}

// ProtoReq name
func (m DatabaseEnable) ProtoReq() string { return "Database.enable" }

// Call sends the request
func (m DatabaseEnable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DatabaseExecuteSQL ...
type DatabaseExecuteSQL struct {
	// DatabaseID ...
	DatabaseID DatabaseDatabaseID `json:"databaseId"`

	// Query ...
	Query string `json:"query"`
}

// ProtoReq name
func (m DatabaseExecuteSQL) ProtoReq() string { return "Database.executeSQL" }

// Call the request
func (m DatabaseExecuteSQL) Call(c Client) (*DatabaseExecuteSQLResult, error) {
	var res DatabaseExecuteSQLResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DatabaseExecuteSQLResult ...
type DatabaseExecuteSQLResult struct {
	// ColumnNames (optional) ...
	ColumnNames []string `json:"columnNames,omitempty"`

	// Values (optional) ...
	Values []gson.JSON `json:"values,omitempty"`

	// SQLError (optional) ...
	SQLError *DatabaseError `json:"sqlError,omitempty"`
}

// DatabaseGetDatabaseTableNames ...
type DatabaseGetDatabaseTableNames struct {
	// DatabaseID ...
	DatabaseID DatabaseDatabaseID `json:"databaseId"`
}

// ProtoReq name
func (m DatabaseGetDatabaseTableNames) ProtoReq() string { return "Database.getDatabaseTableNames" }

// Call the request
func (m DatabaseGetDatabaseTableNames) Call(c Client) (*DatabaseGetDatabaseTableNamesResult, error) {
	var res DatabaseGetDatabaseTableNamesResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DatabaseGetDatabaseTableNamesResult ...
type DatabaseGetDatabaseTableNamesResult struct {
	// TableNames ...
	TableNames []string `json:"tableNames"`
}

// DatabaseAddDatabase ...
type DatabaseAddDatabase struct {
	// Database ...
	Database *DatabaseDatabase `json:"database"`
}

// ProtoEvent name
func (evt DatabaseAddDatabase) ProtoEvent() string {
	return "Database.addDatabase"
}
