// Code generated by go-swagger; DO NOT EDIT.

package network_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewDeletePeeringParams creates a new DeletePeeringParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeletePeeringParams() *DeletePeeringParams {
	return &DeletePeeringParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeletePeeringParamsWithTimeout creates a new DeletePeeringParams object
// with the ability to set a timeout on a request.
func NewDeletePeeringParamsWithTimeout(timeout time.Duration) *DeletePeeringParams {
	return &DeletePeeringParams{
		timeout: timeout,
	}
}

// NewDeletePeeringParamsWithContext creates a new DeletePeeringParams object
// with the ability to set a context for a request.
func NewDeletePeeringParamsWithContext(ctx context.Context) *DeletePeeringParams {
	return &DeletePeeringParams{
		Context: ctx,
	}
}

// NewDeletePeeringParamsWithHTTPClient creates a new DeletePeeringParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeletePeeringParamsWithHTTPClient(client *http.Client) *DeletePeeringParams {
	return &DeletePeeringParams{
		HTTPClient: client,
	}
}

/*
DeletePeeringParams contains all the parameters to send to the API endpoint

	for the delete peering operation.

	Typically these are written to a http.Request.
*/
type DeletePeeringParams struct {

	/* HvnID.

	   HvnId is an ID of the HVN where the peering belongs to
	*/
	HvnID string

	/* ID.

	   Id is the ID of the peering to be deleted.
	*/
	ID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete peering params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeletePeeringParams) WithDefaults() *DeletePeeringParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete peering params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeletePeeringParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete peering params
func (o *DeletePeeringParams) WithTimeout(timeout time.Duration) *DeletePeeringParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete peering params
func (o *DeletePeeringParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete peering params
func (o *DeletePeeringParams) WithContext(ctx context.Context) *DeletePeeringParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete peering params
func (o *DeletePeeringParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete peering params
func (o *DeletePeeringParams) WithHTTPClient(client *http.Client) *DeletePeeringParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete peering params
func (o *DeletePeeringParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithHvnID adds the hvnID to the delete peering params
func (o *DeletePeeringParams) WithHvnID(hvnID string) *DeletePeeringParams {
	o.SetHvnID(hvnID)
	return o
}

// SetHvnID adds the hvnId to the delete peering params
func (o *DeletePeeringParams) SetHvnID(hvnID string) {
	o.HvnID = hvnID
}

// WithID adds the id to the delete peering params
func (o *DeletePeeringParams) WithID(id string) *DeletePeeringParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the delete peering params
func (o *DeletePeeringParams) SetID(id string) {
	o.ID = id
}

// WithLocationOrganizationID adds the locationOrganizationID to the delete peering params
func (o *DeletePeeringParams) WithLocationOrganizationID(locationOrganizationID string) *DeletePeeringParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the delete peering params
func (o *DeletePeeringParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the delete peering params
func (o *DeletePeeringParams) WithLocationProjectID(locationProjectID string) *DeletePeeringParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the delete peering params
func (o *DeletePeeringParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the delete peering params
func (o *DeletePeeringParams) WithLocationRegionProvider(locationRegionProvider *string) *DeletePeeringParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the delete peering params
func (o *DeletePeeringParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the delete peering params
func (o *DeletePeeringParams) WithLocationRegionRegion(locationRegionRegion *string) *DeletePeeringParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the delete peering params
func (o *DeletePeeringParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *DeletePeeringParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param hvn_id
	if err := r.SetPathParam("hvn_id", o.HvnID); err != nil {
		return err
	}

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
