// Code generated by go-swagger; DO NOT EDIT.

package organization_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new organization service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for organization service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	OrganizationServiceCreate(params *OrganizationServiceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OrganizationServiceCreateOK, error)

	OrganizationServiceGet(params *OrganizationServiceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OrganizationServiceGetOK, error)

	OrganizationServiceGetIamPolicy(params *OrganizationServiceGetIamPolicyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OrganizationServiceGetIamPolicyOK, error)

	OrganizationServiceGetRole(params *OrganizationServiceGetRoleParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OrganizationServiceGetRoleOK, error)

	OrganizationServiceList(params *OrganizationServiceListParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OrganizationServiceListOK, error)

	OrganizationServiceListRoles(params *OrganizationServiceListRolesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OrganizationServiceListRolesOK, error)

	OrganizationServiceSetIamPolicy(params *OrganizationServiceSetIamPolicyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OrganizationServiceSetIamPolicyOK, error)

	OrganizationServiceSetName(params *OrganizationServiceSetNameParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OrganizationServiceSetNameOK, error)

	OrganizationServiceTestIamPermissions(params *OrganizationServiceTestIamPermissionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OrganizationServiceTestIamPermissionsOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
OrganizationServiceCreate creates creates a new organization the owner is set to the identity of the caller an organization can not be owned by a machine account
*/
func (a *Client) OrganizationServiceCreate(params *OrganizationServiceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OrganizationServiceCreateOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewOrganizationServiceCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "OrganizationService_Create",
		Method:             "POST",
		PathPattern:        "/resource-manager/2019-12-10/organizations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &OrganizationServiceCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*OrganizationServiceCreateOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*OrganizationServiceCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
OrganizationServiceGet gets retrieves the requested organization by ID
*/
func (a *Client) OrganizationServiceGet(params *OrganizationServiceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OrganizationServiceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewOrganizationServiceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "OrganizationService_Get",
		Method:             "GET",
		PathPattern:        "/resource-manager/2019-12-10/organizations/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &OrganizationServiceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*OrganizationServiceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*OrganizationServiceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
OrganizationServiceGetIamPolicy gets iam policy retrieves the requested organization s i a m policy
*/
func (a *Client) OrganizationServiceGetIamPolicy(params *OrganizationServiceGetIamPolicyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OrganizationServiceGetIamPolicyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewOrganizationServiceGetIamPolicyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "OrganizationService_GetIamPolicy",
		Method:             "GET",
		PathPattern:        "/resource-manager/2019-12-10/organizations/{id}/iam-policy",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &OrganizationServiceGetIamPolicyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*OrganizationServiceGetIamPolicyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*OrganizationServiceGetIamPolicyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
OrganizationServiceGetRole gets role returns a role and its mapped permissions
*/
func (a *Client) OrganizationServiceGetRole(params *OrganizationServiceGetRoleParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OrganizationServiceGetRoleOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewOrganizationServiceGetRoleParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "OrganizationService_GetRole",
		Method:             "GET",
		PathPattern:        "/resource-manager/2019-12-10/organizations/{id}/{role_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &OrganizationServiceGetRoleReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*OrganizationServiceGetRoleOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*OrganizationServiceGetRoleDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
OrganizationServiceList lists lists the organizations the caller has access to
*/
func (a *Client) OrganizationServiceList(params *OrganizationServiceListParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OrganizationServiceListOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewOrganizationServiceListParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "OrganizationService_List",
		Method:             "GET",
		PathPattern:        "/resource-manager/2019-12-10/organizations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &OrganizationServiceListReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*OrganizationServiceListOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*OrganizationServiceListDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
OrganizationServiceListRoles lists roles returns a list of all user facing roles for an organization
*/
func (a *Client) OrganizationServiceListRoles(params *OrganizationServiceListRolesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OrganizationServiceListRolesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewOrganizationServiceListRolesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "OrganizationService_ListRoles",
		Method:             "GET",
		PathPattern:        "/resource-manager/2019-12-10/organizations/{id}/roles",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &OrganizationServiceListRolesReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*OrganizationServiceListRolesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*OrganizationServiceListRolesDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
OrganizationServiceSetIamPolicy sets iam policy sets the i a m policy for an organization since this updates the full policy the policy takes an etag argument that should match with the current policy stored in the system this is to avoid concurrent writes erasing each other s data hence the client should always get the current policy that includes the etag modify the policy and then set the policy with the same etag if there is no existing policy the etag must be empty
*/
func (a *Client) OrganizationServiceSetIamPolicy(params *OrganizationServiceSetIamPolicyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OrganizationServiceSetIamPolicyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewOrganizationServiceSetIamPolicyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "OrganizationService_SetIamPolicy",
		Method:             "PUT",
		PathPattern:        "/resource-manager/2019-12-10/organizations/{id}/iam-policy",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &OrganizationServiceSetIamPolicyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*OrganizationServiceSetIamPolicyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*OrganizationServiceSetIamPolicyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
OrganizationServiceSetName sets name updates the organization s name
*/
func (a *Client) OrganizationServiceSetName(params *OrganizationServiceSetNameParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OrganizationServiceSetNameOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewOrganizationServiceSetNameParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "OrganizationService_SetName",
		Method:             "PUT",
		PathPattern:        "/resource-manager/2019-12-10/organizations/{id}/name",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &OrganizationServiceSetNameReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*OrganizationServiceSetNameOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*OrganizationServiceSetNameDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
OrganizationServiceTestIamPermissions tests iam permissions returns a subset of the request permissions the calling principal has for the organization
*/
func (a *Client) OrganizationServiceTestIamPermissions(params *OrganizationServiceTestIamPermissionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OrganizationServiceTestIamPermissionsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewOrganizationServiceTestIamPermissionsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "OrganizationService_TestIamPermissions",
		Method:             "POST",
		PathPattern:        "/resource-manager/2019-12-10/organizations/{id}/test-iam-permissions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &OrganizationServiceTestIamPermissionsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*OrganizationServiceTestIamPermissionsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*OrganizationServiceTestIamPermissionsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
