// Code generated by command: avogen -output zctors.go ctors. DO NOT EDIT.

package x86

import (
	intrep "github.com/mmcloughlin/avo/ir"
	"github.com/mmcloughlin/avo/operand"
)

// ADCB: Add with Carry.
//
// Forms:
//
//	ADCB imm8 al
//	ADCB imm8 m8
//	ADCB imm8 r8
//	ADCB m8   r8
//	ADCB r8   m8
//	ADCB r8   r8
func ADCB(imr, amr operand.Op) (*intrep.Instruction, error) {
	return build(opcADCB.Forms(), sffxs{}, []operand.Op{imr, amr})
}

// ADCL: Add with Carry.
//
// Forms:
//
//	ADCL imm32 eax
//	ADCL imm32 m32
//	ADCL imm32 r32
//	ADCL imm8  m32
//	ADCL imm8  r32
//	ADCL m32   r32
//	ADCL r32   m32
//	ADCL r32   r32
func ADCL(imr, emr operand.Op) (*intrep.Instruction, error) {
	return build(opcADCL.Forms(), sffxs{}, []operand.Op{imr, emr})
}

// ADCQ: Add with Carry.
//
// Forms:
//
//	ADCQ imm32 m64
//	ADCQ imm32 r64
//	ADCQ imm32 rax
//	ADCQ imm8  m64
//	ADCQ imm8  r64
//	ADCQ m64   r64
//	ADCQ r64   m64
//	ADCQ r64   r64
func ADCQ(imr, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcADCQ.Forms(), sffxs{}, []operand.Op{imr, mr})
}

// ADCW: Add with Carry.
//
// Forms:
//
//	ADCW imm16 ax
//	ADCW imm16 m16
//	ADCW imm16 r16
//	ADCW imm8  m16
//	ADCW imm8  r16
//	ADCW m16   r16
//	ADCW r16   m16
//	ADCW r16   r16
func ADCW(imr, amr operand.Op) (*intrep.Instruction, error) {
	return build(opcADCW.Forms(), sffxs{}, []operand.Op{imr, amr})
}

// ADCXL: Unsigned Integer Addition of Two Operands with Carry Flag.
//
// Forms:
//
//	ADCXL m32 r32
//	ADCXL r32 r32
func ADCXL(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcADCXL.Forms(), sffxs{}, []operand.Op{mr, r})
}

// ADCXQ: Unsigned Integer Addition of Two Operands with Carry Flag.
//
// Forms:
//
//	ADCXQ m64 r64
//	ADCXQ r64 r64
func ADCXQ(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcADCXQ.Forms(), sffxs{}, []operand.Op{mr, r})
}

// ADDB: Add.
//
// Forms:
//
//	ADDB imm8 al
//	ADDB imm8 m8
//	ADDB imm8 r8
//	ADDB m8   r8
//	ADDB r8   m8
//	ADDB r8   r8
func ADDB(imr, amr operand.Op) (*intrep.Instruction, error) {
	return build(opcADDB.Forms(), sffxs{}, []operand.Op{imr, amr})
}

// ADDL: Add.
//
// Forms:
//
//	ADDL imm32 eax
//	ADDL imm32 m32
//	ADDL imm32 r32
//	ADDL imm8  m32
//	ADDL imm8  r32
//	ADDL m32   r32
//	ADDL r32   m32
//	ADDL r32   r32
func ADDL(imr, emr operand.Op) (*intrep.Instruction, error) {
	return build(opcADDL.Forms(), sffxs{}, []operand.Op{imr, emr})
}

// ADDPD: Add Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	ADDPD m128 xmm
//	ADDPD xmm  xmm
func ADDPD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcADDPD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// ADDPS: Add Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	ADDPS m128 xmm
//	ADDPS xmm  xmm
func ADDPS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcADDPS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// ADDQ: Add.
//
// Forms:
//
//	ADDQ imm32 m64
//	ADDQ imm32 r64
//	ADDQ imm32 rax
//	ADDQ imm8  m64
//	ADDQ imm8  r64
//	ADDQ m64   r64
//	ADDQ r64   m64
//	ADDQ r64   r64
func ADDQ(imr, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcADDQ.Forms(), sffxs{}, []operand.Op{imr, mr})
}

// ADDSD: Add Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	ADDSD m64 xmm
//	ADDSD xmm xmm
func ADDSD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcADDSD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// ADDSS: Add Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	ADDSS m32 xmm
//	ADDSS xmm xmm
func ADDSS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcADDSS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// ADDSUBPD: Packed Double-FP Add/Subtract.
//
// Forms:
//
//	ADDSUBPD m128 xmm
//	ADDSUBPD xmm  xmm
func ADDSUBPD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcADDSUBPD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// ADDSUBPS: Packed Single-FP Add/Subtract.
//
// Forms:
//
//	ADDSUBPS m128 xmm
//	ADDSUBPS xmm  xmm
func ADDSUBPS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcADDSUBPS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// ADDW: Add.
//
// Forms:
//
//	ADDW imm16 ax
//	ADDW imm16 m16
//	ADDW imm16 r16
//	ADDW imm8  m16
//	ADDW imm8  r16
//	ADDW m16   r16
//	ADDW r16   m16
//	ADDW r16   r16
func ADDW(imr, amr operand.Op) (*intrep.Instruction, error) {
	return build(opcADDW.Forms(), sffxs{}, []operand.Op{imr, amr})
}

// ADOXL: Unsigned Integer Addition of Two Operands with Overflow Flag.
//
// Forms:
//
//	ADOXL m32 r32
//	ADOXL r32 r32
func ADOXL(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcADOXL.Forms(), sffxs{}, []operand.Op{mr, r})
}

// ADOXQ: Unsigned Integer Addition of Two Operands with Overflow Flag.
//
// Forms:
//
//	ADOXQ m64 r64
//	ADOXQ r64 r64
func ADOXQ(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcADOXQ.Forms(), sffxs{}, []operand.Op{mr, r})
}

// AESDEC: Perform One Round of an AES Decryption Flow.
//
// Forms:
//
//	AESDEC m128 xmm
//	AESDEC xmm  xmm
func AESDEC(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcAESDEC.Forms(), sffxs{}, []operand.Op{mx, x})
}

// AESDECLAST: Perform Last Round of an AES Decryption Flow.
//
// Forms:
//
//	AESDECLAST m128 xmm
//	AESDECLAST xmm  xmm
func AESDECLAST(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcAESDECLAST.Forms(), sffxs{}, []operand.Op{mx, x})
}

// AESENC: Perform One Round of an AES Encryption Flow.
//
// Forms:
//
//	AESENC m128 xmm
//	AESENC xmm  xmm
func AESENC(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcAESENC.Forms(), sffxs{}, []operand.Op{mx, x})
}

// AESENCLAST: Perform Last Round of an AES Encryption Flow.
//
// Forms:
//
//	AESENCLAST m128 xmm
//	AESENCLAST xmm  xmm
func AESENCLAST(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcAESENCLAST.Forms(), sffxs{}, []operand.Op{mx, x})
}

// AESIMC: Perform the AES InvMixColumn Transformation.
//
// Forms:
//
//	AESIMC m128 xmm
//	AESIMC xmm  xmm
func AESIMC(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcAESIMC.Forms(), sffxs{}, []operand.Op{mx, x})
}

// AESKEYGENASSIST: AES Round Key Generation Assist.
//
// Forms:
//
//	AESKEYGENASSIST imm8 m128 xmm
//	AESKEYGENASSIST imm8 xmm  xmm
func AESKEYGENASSIST(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcAESKEYGENASSIST.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// ANDB: Logical AND.
//
// Forms:
//
//	ANDB imm8 al
//	ANDB imm8 m8
//	ANDB imm8 r8
//	ANDB m8   r8
//	ANDB r8   m8
//	ANDB r8   r8
func ANDB(imr, amr operand.Op) (*intrep.Instruction, error) {
	return build(opcANDB.Forms(), sffxs{}, []operand.Op{imr, amr})
}

// ANDL: Logical AND.
//
// Forms:
//
//	ANDL imm32 eax
//	ANDL imm32 m32
//	ANDL imm32 r32
//	ANDL imm8  m32
//	ANDL imm8  r32
//	ANDL m32   r32
//	ANDL r32   m32
//	ANDL r32   r32
func ANDL(imr, emr operand.Op) (*intrep.Instruction, error) {
	return build(opcANDL.Forms(), sffxs{}, []operand.Op{imr, emr})
}

// ANDNL: Logical AND NOT.
//
// Forms:
//
//	ANDNL m32 r32 r32
//	ANDNL r32 r32 r32
func ANDNL(mr, r, r1 operand.Op) (*intrep.Instruction, error) {
	return build(opcANDNL.Forms(), sffxs{}, []operand.Op{mr, r, r1})
}

// ANDNPD: Bitwise Logical AND NOT of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	ANDNPD m128 xmm
//	ANDNPD xmm  xmm
func ANDNPD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcANDNPD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// ANDNPS: Bitwise Logical AND NOT of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	ANDNPS m128 xmm
//	ANDNPS xmm  xmm
func ANDNPS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcANDNPS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// ANDNQ: Logical AND NOT.
//
// Forms:
//
//	ANDNQ m64 r64 r64
//	ANDNQ r64 r64 r64
func ANDNQ(mr, r, r1 operand.Op) (*intrep.Instruction, error) {
	return build(opcANDNQ.Forms(), sffxs{}, []operand.Op{mr, r, r1})
}

// ANDPD: Bitwise Logical AND of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	ANDPD m128 xmm
//	ANDPD xmm  xmm
func ANDPD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcANDPD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// ANDPS: Bitwise Logical AND of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	ANDPS m128 xmm
//	ANDPS xmm  xmm
func ANDPS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcANDPS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// ANDQ: Logical AND.
//
// Forms:
//
//	ANDQ imm32 m64
//	ANDQ imm32 r64
//	ANDQ imm32 rax
//	ANDQ imm8  m64
//	ANDQ imm8  r64
//	ANDQ m64   r64
//	ANDQ r64   m64
//	ANDQ r64   r64
func ANDQ(imr, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcANDQ.Forms(), sffxs{}, []operand.Op{imr, mr})
}

// ANDW: Logical AND.
//
// Forms:
//
//	ANDW imm16 ax
//	ANDW imm16 m16
//	ANDW imm16 r16
//	ANDW imm8  m16
//	ANDW imm8  r16
//	ANDW m16   r16
//	ANDW r16   m16
//	ANDW r16   r16
func ANDW(imr, amr operand.Op) (*intrep.Instruction, error) {
	return build(opcANDW.Forms(), sffxs{}, []operand.Op{imr, amr})
}

// BEXTRL: Bit Field Extract.
//
// Forms:
//
//	BEXTRL r32 m32 r32
//	BEXTRL r32 r32 r32
func BEXTRL(r, mr, r1 operand.Op) (*intrep.Instruction, error) {
	return build(opcBEXTRL.Forms(), sffxs{}, []operand.Op{r, mr, r1})
}

// BEXTRQ: Bit Field Extract.
//
// Forms:
//
//	BEXTRQ r64 m64 r64
//	BEXTRQ r64 r64 r64
func BEXTRQ(r, mr, r1 operand.Op) (*intrep.Instruction, error) {
	return build(opcBEXTRQ.Forms(), sffxs{}, []operand.Op{r, mr, r1})
}

// BLENDPD: Blend Packed Double Precision Floating-Point Values.
//
// Forms:
//
//	BLENDPD imm8 m128 xmm
//	BLENDPD imm8 xmm  xmm
func BLENDPD(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcBLENDPD.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// BLENDPS:  Blend Packed Single Precision Floating-Point Values.
//
// Forms:
//
//	BLENDPS imm8 m128 xmm
//	BLENDPS imm8 xmm  xmm
func BLENDPS(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcBLENDPS.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// BLENDVPD:  Variable Blend Packed Double Precision Floating-Point Values.
//
// Forms:
//
//	BLENDVPD xmm0 m128 xmm
//	BLENDVPD xmm0 xmm  xmm
func BLENDVPD(x, mx, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcBLENDVPD.Forms(), sffxs{}, []operand.Op{x, mx, x1})
}

// BLENDVPS:  Variable Blend Packed Single Precision Floating-Point Values.
//
// Forms:
//
//	BLENDVPS xmm0 m128 xmm
//	BLENDVPS xmm0 xmm  xmm
func BLENDVPS(x, mx, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcBLENDVPS.Forms(), sffxs{}, []operand.Op{x, mx, x1})
}

// BLSIL: Isolate Lowest Set Bit.
//
// Forms:
//
//	BLSIL m32 r32
//	BLSIL r32 r32
func BLSIL(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcBLSIL.Forms(), sffxs{}, []operand.Op{mr, r})
}

// BLSIQ: Isolate Lowest Set Bit.
//
// Forms:
//
//	BLSIQ m64 r64
//	BLSIQ r64 r64
func BLSIQ(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcBLSIQ.Forms(), sffxs{}, []operand.Op{mr, r})
}

// BLSMSKL: Mask From Lowest Set Bit.
//
// Forms:
//
//	BLSMSKL m32 r32
//	BLSMSKL r32 r32
func BLSMSKL(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcBLSMSKL.Forms(), sffxs{}, []operand.Op{mr, r})
}

// BLSMSKQ: Mask From Lowest Set Bit.
//
// Forms:
//
//	BLSMSKQ m64 r64
//	BLSMSKQ r64 r64
func BLSMSKQ(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcBLSMSKQ.Forms(), sffxs{}, []operand.Op{mr, r})
}

// BLSRL: Reset Lowest Set Bit.
//
// Forms:
//
//	BLSRL m32 r32
//	BLSRL r32 r32
func BLSRL(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcBLSRL.Forms(), sffxs{}, []operand.Op{mr, r})
}

// BLSRQ: Reset Lowest Set Bit.
//
// Forms:
//
//	BLSRQ m64 r64
//	BLSRQ r64 r64
func BLSRQ(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcBLSRQ.Forms(), sffxs{}, []operand.Op{mr, r})
}

// BSFL: Bit Scan Forward.
//
// Forms:
//
//	BSFL m32 r32
//	BSFL r32 r32
func BSFL(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcBSFL.Forms(), sffxs{}, []operand.Op{mr, r})
}

// BSFQ: Bit Scan Forward.
//
// Forms:
//
//	BSFQ m64 r64
//	BSFQ r64 r64
func BSFQ(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcBSFQ.Forms(), sffxs{}, []operand.Op{mr, r})
}

// BSFW: Bit Scan Forward.
//
// Forms:
//
//	BSFW m16 r16
//	BSFW r16 r16
func BSFW(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcBSFW.Forms(), sffxs{}, []operand.Op{mr, r})
}

// BSRL: Bit Scan Reverse.
//
// Forms:
//
//	BSRL m32 r32
//	BSRL r32 r32
func BSRL(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcBSRL.Forms(), sffxs{}, []operand.Op{mr, r})
}

// BSRQ: Bit Scan Reverse.
//
// Forms:
//
//	BSRQ m64 r64
//	BSRQ r64 r64
func BSRQ(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcBSRQ.Forms(), sffxs{}, []operand.Op{mr, r})
}

// BSRW: Bit Scan Reverse.
//
// Forms:
//
//	BSRW m16 r16
//	BSRW r16 r16
func BSRW(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcBSRW.Forms(), sffxs{}, []operand.Op{mr, r})
}

// BSWAPL: Byte Swap.
//
// Forms:
//
//	BSWAPL r32
func BSWAPL(r operand.Op) (*intrep.Instruction, error) {
	return build(opcBSWAPL.Forms(), sffxs{}, []operand.Op{r})
}

// BSWAPQ: Byte Swap.
//
// Forms:
//
//	BSWAPQ r64
func BSWAPQ(r operand.Op) (*intrep.Instruction, error) {
	return build(opcBSWAPQ.Forms(), sffxs{}, []operand.Op{r})
}

// BTCL: Bit Test and Complement.
//
// Forms:
//
//	BTCL imm8 m32
//	BTCL imm8 r32
//	BTCL r32  m32
//	BTCL r32  r32
func BTCL(ir, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcBTCL.Forms(), sffxs{}, []operand.Op{ir, mr})
}

// BTCQ: Bit Test and Complement.
//
// Forms:
//
//	BTCQ imm8 m64
//	BTCQ imm8 r64
//	BTCQ r64  m64
//	BTCQ r64  r64
func BTCQ(ir, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcBTCQ.Forms(), sffxs{}, []operand.Op{ir, mr})
}

// BTCW: Bit Test and Complement.
//
// Forms:
//
//	BTCW imm8 m16
//	BTCW imm8 r16
//	BTCW r16  m16
//	BTCW r16  r16
func BTCW(ir, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcBTCW.Forms(), sffxs{}, []operand.Op{ir, mr})
}

// BTL: Bit Test.
//
// Forms:
//
//	BTL imm8 m32
//	BTL imm8 r32
//	BTL r32  m32
//	BTL r32  r32
func BTL(ir, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcBTL.Forms(), sffxs{}, []operand.Op{ir, mr})
}

// BTQ: Bit Test.
//
// Forms:
//
//	BTQ imm8 m64
//	BTQ imm8 r64
//	BTQ r64  m64
//	BTQ r64  r64
func BTQ(ir, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcBTQ.Forms(), sffxs{}, []operand.Op{ir, mr})
}

// BTRL: Bit Test and Reset.
//
// Forms:
//
//	BTRL imm8 m32
//	BTRL imm8 r32
//	BTRL r32  m32
//	BTRL r32  r32
func BTRL(ir, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcBTRL.Forms(), sffxs{}, []operand.Op{ir, mr})
}

// BTRQ: Bit Test and Reset.
//
// Forms:
//
//	BTRQ imm8 m64
//	BTRQ imm8 r64
//	BTRQ r64  m64
//	BTRQ r64  r64
func BTRQ(ir, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcBTRQ.Forms(), sffxs{}, []operand.Op{ir, mr})
}

// BTRW: Bit Test and Reset.
//
// Forms:
//
//	BTRW imm8 m16
//	BTRW imm8 r16
//	BTRW r16  m16
//	BTRW r16  r16
func BTRW(ir, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcBTRW.Forms(), sffxs{}, []operand.Op{ir, mr})
}

// BTSL: Bit Test and Set.
//
// Forms:
//
//	BTSL imm8 m32
//	BTSL imm8 r32
//	BTSL r32  m32
//	BTSL r32  r32
func BTSL(ir, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcBTSL.Forms(), sffxs{}, []operand.Op{ir, mr})
}

// BTSQ: Bit Test and Set.
//
// Forms:
//
//	BTSQ imm8 m64
//	BTSQ imm8 r64
//	BTSQ r64  m64
//	BTSQ r64  r64
func BTSQ(ir, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcBTSQ.Forms(), sffxs{}, []operand.Op{ir, mr})
}

// BTSW: Bit Test and Set.
//
// Forms:
//
//	BTSW imm8 m16
//	BTSW imm8 r16
//	BTSW r16  m16
//	BTSW r16  r16
func BTSW(ir, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcBTSW.Forms(), sffxs{}, []operand.Op{ir, mr})
}

// BTW: Bit Test.
//
// Forms:
//
//	BTW imm8 m16
//	BTW imm8 r16
//	BTW r16  m16
//	BTW r16  r16
func BTW(ir, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcBTW.Forms(), sffxs{}, []operand.Op{ir, mr})
}

// BZHIL: Zero High Bits Starting with Specified Bit Position.
//
// Forms:
//
//	BZHIL r32 m32 r32
//	BZHIL r32 r32 r32
func BZHIL(r, mr, r1 operand.Op) (*intrep.Instruction, error) {
	return build(opcBZHIL.Forms(), sffxs{}, []operand.Op{r, mr, r1})
}

// BZHIQ: Zero High Bits Starting with Specified Bit Position.
//
// Forms:
//
//	BZHIQ r64 m64 r64
//	BZHIQ r64 r64 r64
func BZHIQ(r, mr, r1 operand.Op) (*intrep.Instruction, error) {
	return build(opcBZHIQ.Forms(), sffxs{}, []operand.Op{r, mr, r1})
}

// CALL: Call Procedure.
//
// Forms:
//
//	CALL rel32
func CALL(r operand.Op) (*intrep.Instruction, error) {
	return build(opcCALL.Forms(), sffxs{}, []operand.Op{r})
}

// CBW: Convert Byte to Word.
//
// Forms:
//
//	CBW
func CBW() (*intrep.Instruction, error) {
	return build(opcCBW.Forms(), sffxs{}, []operand.Op{})
}

// CDQ: Convert Doubleword to Quadword.
//
// Forms:
//
//	CDQ
func CDQ() (*intrep.Instruction, error) {
	return build(opcCDQ.Forms(), sffxs{}, []operand.Op{})
}

// CDQE: Convert Doubleword to Quadword.
//
// Forms:
//
//	CDQE
func CDQE() (*intrep.Instruction, error) {
	return build(opcCDQE.Forms(), sffxs{}, []operand.Op{})
}

// CLC: Clear Carry Flag.
//
// Forms:
//
//	CLC
func CLC() (*intrep.Instruction, error) {
	return build(opcCLC.Forms(), sffxs{}, []operand.Op{})
}

// CLD: Clear Direction Flag.
//
// Forms:
//
//	CLD
func CLD() (*intrep.Instruction, error) {
	return build(opcCLD.Forms(), sffxs{}, []operand.Op{})
}

// CLFLUSH: Flush Cache Line.
//
// Forms:
//
//	CLFLUSH m8
func CLFLUSH(m operand.Op) (*intrep.Instruction, error) {
	return build(opcCLFLUSH.Forms(), sffxs{}, []operand.Op{m})
}

// CLFLUSHOPT: Flush Cache Line Optimized.
//
// Forms:
//
//	CLFLUSHOPT m8
func CLFLUSHOPT(m operand.Op) (*intrep.Instruction, error) {
	return build(opcCLFLUSHOPT.Forms(), sffxs{}, []operand.Op{m})
}

// CMC: Complement Carry Flag.
//
// Forms:
//
//	CMC
func CMC() (*intrep.Instruction, error) {
	return build(opcCMC.Forms(), sffxs{}, []operand.Op{})
}

// CMOVLCC: Move if above or equal (CF == 0).
//
// Forms:
//
//	CMOVLCC m32 r32
//	CMOVLCC r32 r32
func CMOVLCC(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVLCC.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVLCS: Move if below (CF == 1).
//
// Forms:
//
//	CMOVLCS m32 r32
//	CMOVLCS r32 r32
func CMOVLCS(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVLCS.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVLEQ: Move if equal (ZF == 1).
//
// Forms:
//
//	CMOVLEQ m32 r32
//	CMOVLEQ r32 r32
func CMOVLEQ(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVLEQ.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVLGE: Move if greater or equal (SF == OF).
//
// Forms:
//
//	CMOVLGE m32 r32
//	CMOVLGE r32 r32
func CMOVLGE(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVLGE.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVLGT: Move if greater (ZF == 0 and SF == OF).
//
// Forms:
//
//	CMOVLGT m32 r32
//	CMOVLGT r32 r32
func CMOVLGT(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVLGT.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVLHI: Move if above (CF == 0 and ZF == 0).
//
// Forms:
//
//	CMOVLHI m32 r32
//	CMOVLHI r32 r32
func CMOVLHI(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVLHI.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVLLE: Move if less or equal (ZF == 1 or SF != OF).
//
// Forms:
//
//	CMOVLLE m32 r32
//	CMOVLLE r32 r32
func CMOVLLE(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVLLE.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVLLS: Move if below or equal (CF == 1 or ZF == 1).
//
// Forms:
//
//	CMOVLLS m32 r32
//	CMOVLLS r32 r32
func CMOVLLS(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVLLS.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVLLT: Move if less (SF != OF).
//
// Forms:
//
//	CMOVLLT m32 r32
//	CMOVLLT r32 r32
func CMOVLLT(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVLLT.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVLMI: Move if sign (SF == 1).
//
// Forms:
//
//	CMOVLMI m32 r32
//	CMOVLMI r32 r32
func CMOVLMI(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVLMI.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVLNE: Move if not equal (ZF == 0).
//
// Forms:
//
//	CMOVLNE m32 r32
//	CMOVLNE r32 r32
func CMOVLNE(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVLNE.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVLOC: Move if not overflow (OF == 0).
//
// Forms:
//
//	CMOVLOC m32 r32
//	CMOVLOC r32 r32
func CMOVLOC(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVLOC.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVLOS: Move if overflow (OF == 1).
//
// Forms:
//
//	CMOVLOS m32 r32
//	CMOVLOS r32 r32
func CMOVLOS(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVLOS.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVLPC: Move if not parity (PF == 0).
//
// Forms:
//
//	CMOVLPC m32 r32
//	CMOVLPC r32 r32
func CMOVLPC(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVLPC.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVLPL: Move if not sign (SF == 0).
//
// Forms:
//
//	CMOVLPL m32 r32
//	CMOVLPL r32 r32
func CMOVLPL(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVLPL.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVLPS: Move if parity (PF == 1).
//
// Forms:
//
//	CMOVLPS m32 r32
//	CMOVLPS r32 r32
func CMOVLPS(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVLPS.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVQCC: Move if above or equal (CF == 0).
//
// Forms:
//
//	CMOVQCC m64 r64
//	CMOVQCC r64 r64
func CMOVQCC(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVQCC.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVQCS: Move if below (CF == 1).
//
// Forms:
//
//	CMOVQCS m64 r64
//	CMOVQCS r64 r64
func CMOVQCS(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVQCS.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVQEQ: Move if equal (ZF == 1).
//
// Forms:
//
//	CMOVQEQ m64 r64
//	CMOVQEQ r64 r64
func CMOVQEQ(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVQEQ.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVQGE: Move if greater or equal (SF == OF).
//
// Forms:
//
//	CMOVQGE m64 r64
//	CMOVQGE r64 r64
func CMOVQGE(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVQGE.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVQGT: Move if greater (ZF == 0 and SF == OF).
//
// Forms:
//
//	CMOVQGT m64 r64
//	CMOVQGT r64 r64
func CMOVQGT(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVQGT.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVQHI: Move if above (CF == 0 and ZF == 0).
//
// Forms:
//
//	CMOVQHI m64 r64
//	CMOVQHI r64 r64
func CMOVQHI(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVQHI.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVQLE: Move if less or equal (ZF == 1 or SF != OF).
//
// Forms:
//
//	CMOVQLE m64 r64
//	CMOVQLE r64 r64
func CMOVQLE(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVQLE.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVQLS: Move if below or equal (CF == 1 or ZF == 1).
//
// Forms:
//
//	CMOVQLS m64 r64
//	CMOVQLS r64 r64
func CMOVQLS(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVQLS.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVQLT: Move if less (SF != OF).
//
// Forms:
//
//	CMOVQLT m64 r64
//	CMOVQLT r64 r64
func CMOVQLT(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVQLT.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVQMI: Move if sign (SF == 1).
//
// Forms:
//
//	CMOVQMI m64 r64
//	CMOVQMI r64 r64
func CMOVQMI(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVQMI.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVQNE: Move if not equal (ZF == 0).
//
// Forms:
//
//	CMOVQNE m64 r64
//	CMOVQNE r64 r64
func CMOVQNE(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVQNE.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVQOC: Move if not overflow (OF == 0).
//
// Forms:
//
//	CMOVQOC m64 r64
//	CMOVQOC r64 r64
func CMOVQOC(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVQOC.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVQOS: Move if overflow (OF == 1).
//
// Forms:
//
//	CMOVQOS m64 r64
//	CMOVQOS r64 r64
func CMOVQOS(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVQOS.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVQPC: Move if not parity (PF == 0).
//
// Forms:
//
//	CMOVQPC m64 r64
//	CMOVQPC r64 r64
func CMOVQPC(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVQPC.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVQPL: Move if not sign (SF == 0).
//
// Forms:
//
//	CMOVQPL m64 r64
//	CMOVQPL r64 r64
func CMOVQPL(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVQPL.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVQPS: Move if parity (PF == 1).
//
// Forms:
//
//	CMOVQPS m64 r64
//	CMOVQPS r64 r64
func CMOVQPS(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVQPS.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVWCC: Move if above or equal (CF == 0).
//
// Forms:
//
//	CMOVWCC m16 r16
//	CMOVWCC r16 r16
func CMOVWCC(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVWCC.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVWCS: Move if below (CF == 1).
//
// Forms:
//
//	CMOVWCS m16 r16
//	CMOVWCS r16 r16
func CMOVWCS(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVWCS.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVWEQ: Move if equal (ZF == 1).
//
// Forms:
//
//	CMOVWEQ m16 r16
//	CMOVWEQ r16 r16
func CMOVWEQ(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVWEQ.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVWGE: Move if greater or equal (SF == OF).
//
// Forms:
//
//	CMOVWGE m16 r16
//	CMOVWGE r16 r16
func CMOVWGE(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVWGE.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVWGT: Move if greater (ZF == 0 and SF == OF).
//
// Forms:
//
//	CMOVWGT m16 r16
//	CMOVWGT r16 r16
func CMOVWGT(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVWGT.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVWHI: Move if above (CF == 0 and ZF == 0).
//
// Forms:
//
//	CMOVWHI m16 r16
//	CMOVWHI r16 r16
func CMOVWHI(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVWHI.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVWLE: Move if less or equal (ZF == 1 or SF != OF).
//
// Forms:
//
//	CMOVWLE m16 r16
//	CMOVWLE r16 r16
func CMOVWLE(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVWLE.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVWLS: Move if below or equal (CF == 1 or ZF == 1).
//
// Forms:
//
//	CMOVWLS m16 r16
//	CMOVWLS r16 r16
func CMOVWLS(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVWLS.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVWLT: Move if less (SF != OF).
//
// Forms:
//
//	CMOVWLT m16 r16
//	CMOVWLT r16 r16
func CMOVWLT(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVWLT.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVWMI: Move if sign (SF == 1).
//
// Forms:
//
//	CMOVWMI m16 r16
//	CMOVWMI r16 r16
func CMOVWMI(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVWMI.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVWNE: Move if not equal (ZF == 0).
//
// Forms:
//
//	CMOVWNE m16 r16
//	CMOVWNE r16 r16
func CMOVWNE(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVWNE.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVWOC: Move if not overflow (OF == 0).
//
// Forms:
//
//	CMOVWOC m16 r16
//	CMOVWOC r16 r16
func CMOVWOC(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVWOC.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVWOS: Move if overflow (OF == 1).
//
// Forms:
//
//	CMOVWOS m16 r16
//	CMOVWOS r16 r16
func CMOVWOS(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVWOS.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVWPC: Move if not parity (PF == 0).
//
// Forms:
//
//	CMOVWPC m16 r16
//	CMOVWPC r16 r16
func CMOVWPC(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVWPC.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVWPL: Move if not sign (SF == 0).
//
// Forms:
//
//	CMOVWPL m16 r16
//	CMOVWPL r16 r16
func CMOVWPL(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVWPL.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMOVWPS: Move if parity (PF == 1).
//
// Forms:
//
//	CMOVWPS m16 r16
//	CMOVWPS r16 r16
func CMOVWPS(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCMOVWPS.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CMPB: Compare Two Operands.
//
// Forms:
//
//	CMPB al imm8
//	CMPB m8 imm8
//	CMPB m8 r8
//	CMPB r8 imm8
//	CMPB r8 m8
//	CMPB r8 r8
func CMPB(amr, imr operand.Op) (*intrep.Instruction, error) {
	return build(opcCMPB.Forms(), sffxs{}, []operand.Op{amr, imr})
}

// CMPL: Compare Two Operands.
//
// Forms:
//
//	CMPL eax imm32
//	CMPL m32 imm32
//	CMPL m32 imm8
//	CMPL m32 r32
//	CMPL r32 imm32
//	CMPL r32 imm8
//	CMPL r32 m32
//	CMPL r32 r32
func CMPL(emr, imr operand.Op) (*intrep.Instruction, error) {
	return build(opcCMPL.Forms(), sffxs{}, []operand.Op{emr, imr})
}

// CMPPD: Compare Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	CMPPD m128 xmm imm8
//	CMPPD xmm  xmm imm8
func CMPPD(mx, x, i operand.Op) (*intrep.Instruction, error) {
	return build(opcCMPPD.Forms(), sffxs{}, []operand.Op{mx, x, i})
}

// CMPPS: Compare Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	CMPPS m128 xmm imm8
//	CMPPS xmm  xmm imm8
func CMPPS(mx, x, i operand.Op) (*intrep.Instruction, error) {
	return build(opcCMPPS.Forms(), sffxs{}, []operand.Op{mx, x, i})
}

// CMPQ: Compare Two Operands.
//
// Forms:
//
//	CMPQ m64 imm32
//	CMPQ m64 imm8
//	CMPQ m64 r64
//	CMPQ r64 imm32
//	CMPQ r64 imm8
//	CMPQ r64 m64
//	CMPQ r64 r64
//	CMPQ rax imm32
func CMPQ(mr, imr operand.Op) (*intrep.Instruction, error) {
	return build(opcCMPQ.Forms(), sffxs{}, []operand.Op{mr, imr})
}

// CMPSD: Compare Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	CMPSD m64 xmm imm8
//	CMPSD xmm xmm imm8
func CMPSD(mx, x, i operand.Op) (*intrep.Instruction, error) {
	return build(opcCMPSD.Forms(), sffxs{}, []operand.Op{mx, x, i})
}

// CMPSS: Compare Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	CMPSS m32 xmm imm8
//	CMPSS xmm xmm imm8
func CMPSS(mx, x, i operand.Op) (*intrep.Instruction, error) {
	return build(opcCMPSS.Forms(), sffxs{}, []operand.Op{mx, x, i})
}

// CMPW: Compare Two Operands.
//
// Forms:
//
//	CMPW ax  imm16
//	CMPW m16 imm16
//	CMPW m16 imm8
//	CMPW m16 r16
//	CMPW r16 imm16
//	CMPW r16 imm8
//	CMPW r16 m16
//	CMPW r16 r16
func CMPW(amr, imr operand.Op) (*intrep.Instruction, error) {
	return build(opcCMPW.Forms(), sffxs{}, []operand.Op{amr, imr})
}

// CMPXCHG16B: Compare and Exchange 16 Bytes.
//
// Forms:
//
//	CMPXCHG16B m128
func CMPXCHG16B(m operand.Op) (*intrep.Instruction, error) {
	return build(opcCMPXCHG16B.Forms(), sffxs{}, []operand.Op{m})
}

// CMPXCHG8B: Compare and Exchange 8 Bytes.
//
// Forms:
//
//	CMPXCHG8B m64
func CMPXCHG8B(m operand.Op) (*intrep.Instruction, error) {
	return build(opcCMPXCHG8B.Forms(), sffxs{}, []operand.Op{m})
}

// CMPXCHGB: Compare and Exchange.
//
// Forms:
//
//	CMPXCHGB r8 m8
//	CMPXCHGB r8 r8
func CMPXCHGB(r, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcCMPXCHGB.Forms(), sffxs{}, []operand.Op{r, mr})
}

// CMPXCHGL: Compare and Exchange.
//
// Forms:
//
//	CMPXCHGL r32 m32
//	CMPXCHGL r32 r32
func CMPXCHGL(r, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcCMPXCHGL.Forms(), sffxs{}, []operand.Op{r, mr})
}

// CMPXCHGQ: Compare and Exchange.
//
// Forms:
//
//	CMPXCHGQ r64 m64
//	CMPXCHGQ r64 r64
func CMPXCHGQ(r, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcCMPXCHGQ.Forms(), sffxs{}, []operand.Op{r, mr})
}

// CMPXCHGW: Compare and Exchange.
//
// Forms:
//
//	CMPXCHGW r16 m16
//	CMPXCHGW r16 r16
func CMPXCHGW(r, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcCMPXCHGW.Forms(), sffxs{}, []operand.Op{r, mr})
}

// COMISD: Compare Scalar Ordered Double-Precision Floating-Point Values and Set EFLAGS.
//
// Forms:
//
//	COMISD m64 xmm
//	COMISD xmm xmm
func COMISD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcCOMISD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// COMISS: Compare Scalar Ordered Single-Precision Floating-Point Values and Set EFLAGS.
//
// Forms:
//
//	COMISS m32 xmm
//	COMISS xmm xmm
func COMISS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcCOMISS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// CPUID: CPU Identification.
//
// Forms:
//
//	CPUID
func CPUID() (*intrep.Instruction, error) {
	return build(opcCPUID.Forms(), sffxs{}, []operand.Op{})
}

// CQO: Convert Quadword to Octaword.
//
// Forms:
//
//	CQO
func CQO() (*intrep.Instruction, error) {
	return build(opcCQO.Forms(), sffxs{}, []operand.Op{})
}

// CRC32B: Accumulate CRC32 Value.
//
// Forms:
//
//	CRC32B m8 r32
//	CRC32B m8 r64
//	CRC32B r8 r32
//	CRC32B r8 r64
func CRC32B(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCRC32B.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CRC32L: Accumulate CRC32 Value.
//
// Forms:
//
//	CRC32L m32 r32
//	CRC32L r32 r32
func CRC32L(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCRC32L.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CRC32Q: Accumulate CRC32 Value.
//
// Forms:
//
//	CRC32Q m64 r64
//	CRC32Q r64 r64
func CRC32Q(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCRC32Q.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CRC32W: Accumulate CRC32 Value.
//
// Forms:
//
//	CRC32W m16 r32
//	CRC32W r16 r32
func CRC32W(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCRC32W.Forms(), sffxs{}, []operand.Op{mr, r})
}

// CVTPD2PL: Convert Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	CVTPD2PL m128 xmm
//	CVTPD2PL xmm  xmm
func CVTPD2PL(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcCVTPD2PL.Forms(), sffxs{}, []operand.Op{mx, x})
}

// CVTPD2PS: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values.
//
// Forms:
//
//	CVTPD2PS m128 xmm
//	CVTPD2PS xmm  xmm
func CVTPD2PS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcCVTPD2PS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// CVTPL2PD: Convert Packed Dword Integers to Packed Double-Precision FP Values.
//
// Forms:
//
//	CVTPL2PD m64 xmm
//	CVTPL2PD xmm xmm
func CVTPL2PD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcCVTPL2PD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// CVTPL2PS: Convert Packed Dword Integers to Packed Single-Precision FP Values.
//
// Forms:
//
//	CVTPL2PS m128 xmm
//	CVTPL2PS xmm  xmm
func CVTPL2PS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcCVTPL2PS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// CVTPS2PD: Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values.
//
// Forms:
//
//	CVTPS2PD m64 xmm
//	CVTPS2PD xmm xmm
func CVTPS2PD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcCVTPS2PD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// CVTPS2PL: Convert Packed Single-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	CVTPS2PL m128 xmm
//	CVTPS2PL xmm  xmm
func CVTPS2PL(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcCVTPS2PL.Forms(), sffxs{}, []operand.Op{mx, x})
}

// CVTSD2SL: Convert Scalar Double-Precision FP Value to Integer.
//
// Forms:
//
//	CVTSD2SL m64 r32
//	CVTSD2SL m64 r64
//	CVTSD2SL xmm r32
//	CVTSD2SL xmm r64
func CVTSD2SL(mx, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCVTSD2SL.Forms(), sffxs{}, []operand.Op{mx, r})
}

// CVTSD2SS: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value.
//
// Forms:
//
//	CVTSD2SS m64 xmm
//	CVTSD2SS xmm xmm
func CVTSD2SS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcCVTSD2SS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// CVTSL2SD: Convert Dword Integer to Scalar Double-Precision FP Value.
//
// Forms:
//
//	CVTSL2SD m32 xmm
//	CVTSL2SD r32 xmm
func CVTSL2SD(mr, x operand.Op) (*intrep.Instruction, error) {
	return build(opcCVTSL2SD.Forms(), sffxs{}, []operand.Op{mr, x})
}

// CVTSL2SS: Convert Dword Integer to Scalar Single-Precision FP Value.
//
// Forms:
//
//	CVTSL2SS m32 xmm
//	CVTSL2SS r32 xmm
func CVTSL2SS(mr, x operand.Op) (*intrep.Instruction, error) {
	return build(opcCVTSL2SS.Forms(), sffxs{}, []operand.Op{mr, x})
}

// CVTSQ2SD: Convert Dword Integer to Scalar Double-Precision FP Value.
//
// Forms:
//
//	CVTSQ2SD m64 xmm
//	CVTSQ2SD r64 xmm
func CVTSQ2SD(mr, x operand.Op) (*intrep.Instruction, error) {
	return build(opcCVTSQ2SD.Forms(), sffxs{}, []operand.Op{mr, x})
}

// CVTSQ2SS: Convert Dword Integer to Scalar Single-Precision FP Value.
//
// Forms:
//
//	CVTSQ2SS m64 xmm
//	CVTSQ2SS r64 xmm
func CVTSQ2SS(mr, x operand.Op) (*intrep.Instruction, error) {
	return build(opcCVTSQ2SS.Forms(), sffxs{}, []operand.Op{mr, x})
}

// CVTSS2SD: Convert Scalar Single-Precision FP Value to Scalar Double-Precision FP Value.
//
// Forms:
//
//	CVTSS2SD m32 xmm
//	CVTSS2SD xmm xmm
func CVTSS2SD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcCVTSS2SD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// CVTSS2SL: Convert Scalar Single-Precision FP Value to Dword Integer.
//
// Forms:
//
//	CVTSS2SL m32 r32
//	CVTSS2SL m32 r64
//	CVTSS2SL xmm r32
//	CVTSS2SL xmm r64
func CVTSS2SL(mx, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCVTSS2SL.Forms(), sffxs{}, []operand.Op{mx, r})
}

// CVTTPD2PL: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	CVTTPD2PL m128 xmm
//	CVTTPD2PL xmm  xmm
func CVTTPD2PL(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcCVTTPD2PL.Forms(), sffxs{}, []operand.Op{mx, x})
}

// CVTTPS2PL: Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	CVTTPS2PL m128 xmm
//	CVTTPS2PL xmm  xmm
func CVTTPS2PL(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcCVTTPS2PL.Forms(), sffxs{}, []operand.Op{mx, x})
}

// CVTTSD2SL: Convert with Truncation Scalar Double-Precision FP Value to Signed Integer.
//
// Forms:
//
//	CVTTSD2SL m64 r32
//	CVTTSD2SL xmm r32
func CVTTSD2SL(mx, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCVTTSD2SL.Forms(), sffxs{}, []operand.Op{mx, r})
}

// CVTTSD2SQ: Convert with Truncation Scalar Double-Precision FP Value to Signed Integer.
//
// Forms:
//
//	CVTTSD2SQ m64 r64
//	CVTTSD2SQ xmm r64
func CVTTSD2SQ(mx, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCVTTSD2SQ.Forms(), sffxs{}, []operand.Op{mx, r})
}

// CVTTSS2SL: Convert with Truncation Scalar Single-Precision FP Value to Dword Integer.
//
// Forms:
//
//	CVTTSS2SL m32 r32
//	CVTTSS2SL m32 r64
//	CVTTSS2SL xmm r32
//	CVTTSS2SL xmm r64
func CVTTSS2SL(mx, r operand.Op) (*intrep.Instruction, error) {
	return build(opcCVTTSS2SL.Forms(), sffxs{}, []operand.Op{mx, r})
}

// CWD: Convert Word to Doubleword.
//
// Forms:
//
//	CWD
func CWD() (*intrep.Instruction, error) {
	return build(opcCWD.Forms(), sffxs{}, []operand.Op{})
}

// CWDE: Convert Word to Doubleword.
//
// Forms:
//
//	CWDE
func CWDE() (*intrep.Instruction, error) {
	return build(opcCWDE.Forms(), sffxs{}, []operand.Op{})
}

// DECB: Decrement by 1.
//
// Forms:
//
//	DECB m8
//	DECB r8
func DECB(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcDECB.Forms(), sffxs{}, []operand.Op{mr})
}

// DECL: Decrement by 1.
//
// Forms:
//
//	DECL m32
//	DECL r32
func DECL(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcDECL.Forms(), sffxs{}, []operand.Op{mr})
}

// DECQ: Decrement by 1.
//
// Forms:
//
//	DECQ m64
//	DECQ r64
func DECQ(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcDECQ.Forms(), sffxs{}, []operand.Op{mr})
}

// DECW: Decrement by 1.
//
// Forms:
//
//	DECW m16
//	DECW r16
func DECW(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcDECW.Forms(), sffxs{}, []operand.Op{mr})
}

// DIVB: Unsigned Divide.
//
// Forms:
//
//	DIVB m8
//	DIVB r8
func DIVB(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcDIVB.Forms(), sffxs{}, []operand.Op{mr})
}

// DIVL: Unsigned Divide.
//
// Forms:
//
//	DIVL m32
//	DIVL r32
func DIVL(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcDIVL.Forms(), sffxs{}, []operand.Op{mr})
}

// DIVPD: Divide Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	DIVPD m128 xmm
//	DIVPD xmm  xmm
func DIVPD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcDIVPD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// DIVPS: Divide Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	DIVPS m128 xmm
//	DIVPS xmm  xmm
func DIVPS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcDIVPS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// DIVQ: Unsigned Divide.
//
// Forms:
//
//	DIVQ m64
//	DIVQ r64
func DIVQ(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcDIVQ.Forms(), sffxs{}, []operand.Op{mr})
}

// DIVSD: Divide Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	DIVSD m64 xmm
//	DIVSD xmm xmm
func DIVSD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcDIVSD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// DIVSS: Divide Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	DIVSS m32 xmm
//	DIVSS xmm xmm
func DIVSS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcDIVSS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// DIVW: Unsigned Divide.
//
// Forms:
//
//	DIVW m16
//	DIVW r16
func DIVW(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcDIVW.Forms(), sffxs{}, []operand.Op{mr})
}

// DPPD: Dot Product of Packed Double Precision Floating-Point Values.
//
// Forms:
//
//	DPPD imm8 m128 xmm
//	DPPD imm8 xmm  xmm
func DPPD(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcDPPD.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// DPPS: Dot Product of Packed Single Precision Floating-Point Values.
//
// Forms:
//
//	DPPS imm8 m128 xmm
//	DPPS imm8 xmm  xmm
func DPPS(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcDPPS.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// EXTRACTPS: Extract Packed Single Precision Floating-Point Value.
//
// Forms:
//
//	EXTRACTPS imm2u xmm m32
//	EXTRACTPS imm2u xmm r32
func EXTRACTPS(i, x, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcEXTRACTPS.Forms(), sffxs{}, []operand.Op{i, x, mr})
}

// HADDPD: Packed Double-FP Horizontal Add.
//
// Forms:
//
//	HADDPD m128 xmm
//	HADDPD xmm  xmm
func HADDPD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcHADDPD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// HADDPS: Packed Single-FP Horizontal Add.
//
// Forms:
//
//	HADDPS m128 xmm
//	HADDPS xmm  xmm
func HADDPS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcHADDPS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// HSUBPD: Packed Double-FP Horizontal Subtract.
//
// Forms:
//
//	HSUBPD m128 xmm
//	HSUBPD xmm  xmm
func HSUBPD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcHSUBPD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// HSUBPS: Packed Single-FP Horizontal Subtract.
//
// Forms:
//
//	HSUBPS m128 xmm
//	HSUBPS xmm  xmm
func HSUBPS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcHSUBPS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// IDIVB: Signed Divide.
//
// Forms:
//
//	IDIVB m8
//	IDIVB r8
func IDIVB(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcIDIVB.Forms(), sffxs{}, []operand.Op{mr})
}

// IDIVL: Signed Divide.
//
// Forms:
//
//	IDIVL m32
//	IDIVL r32
func IDIVL(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcIDIVL.Forms(), sffxs{}, []operand.Op{mr})
}

// IDIVQ: Signed Divide.
//
// Forms:
//
//	IDIVQ m64
//	IDIVQ r64
func IDIVQ(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcIDIVQ.Forms(), sffxs{}, []operand.Op{mr})
}

// IDIVW: Signed Divide.
//
// Forms:
//
//	IDIVW m16
//	IDIVW r16
func IDIVW(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcIDIVW.Forms(), sffxs{}, []operand.Op{mr})
}

// IMUL3L: Signed Multiply.
//
// Forms:
//
//	IMUL3L imm32 m32 r32
//	IMUL3L imm32 r32 r32
//	IMUL3L imm8  m32 r32
//	IMUL3L imm8  r32 r32
func IMUL3L(i, mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcIMUL3L.Forms(), sffxs{}, []operand.Op{i, mr, r})
}

// IMUL3Q: Signed Multiply.
//
// Forms:
//
//	IMUL3Q imm32 m64 r64
//	IMUL3Q imm32 r64 r64
//	IMUL3Q imm8  m64 r64
//	IMUL3Q imm8  r64 r64
func IMUL3Q(i, mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcIMUL3Q.Forms(), sffxs{}, []operand.Op{i, mr, r})
}

// IMUL3W: Signed Multiply.
//
// Forms:
//
//	IMUL3W imm16 m16 r16
//	IMUL3W imm16 r16 r16
//	IMUL3W imm8  m16 r16
//	IMUL3W imm8  r16 r16
func IMUL3W(i, mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcIMUL3W.Forms(), sffxs{}, []operand.Op{i, mr, r})
}

// IMULB: Signed Multiply.
//
// Forms:
//
//	IMULB m8
//	IMULB r8
func IMULB(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcIMULB.Forms(), sffxs{}, []operand.Op{mr})
}

// IMULL: Signed Multiply.
//
// Forms:
//
//	IMULL m32 r32
//	IMULL m32
//	IMULL r32 r32
//	IMULL r32
func IMULL(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcIMULL.Forms(), sffxs{}, ops)
}

// IMULQ: Signed Multiply.
//
// Forms:
//
//	IMULQ m64 r64
//	IMULQ m64
//	IMULQ r64 r64
//	IMULQ r64
func IMULQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcIMULQ.Forms(), sffxs{}, ops)
}

// IMULW: Signed Multiply.
//
// Forms:
//
//	IMULW m16 r16
//	IMULW m16
//	IMULW r16 r16
//	IMULW r16
func IMULW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcIMULW.Forms(), sffxs{}, ops)
}

// INCB: Increment by 1.
//
// Forms:
//
//	INCB m8
//	INCB r8
func INCB(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcINCB.Forms(), sffxs{}, []operand.Op{mr})
}

// INCL: Increment by 1.
//
// Forms:
//
//	INCL m32
//	INCL r32
func INCL(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcINCL.Forms(), sffxs{}, []operand.Op{mr})
}

// INCQ: Increment by 1.
//
// Forms:
//
//	INCQ m64
//	INCQ r64
func INCQ(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcINCQ.Forms(), sffxs{}, []operand.Op{mr})
}

// INCW: Increment by 1.
//
// Forms:
//
//	INCW m16
//	INCW r16
func INCW(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcINCW.Forms(), sffxs{}, []operand.Op{mr})
}

// INSERTPS: Insert Packed Single Precision Floating-Point Value.
//
// Forms:
//
//	INSERTPS imm8 m32 xmm
//	INSERTPS imm8 xmm xmm
func INSERTPS(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcINSERTPS.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// INT: Call to Interrupt Procedure.
//
// Forms:
//
//	INT 3
//	INT imm8
func INT(i operand.Op) (*intrep.Instruction, error) {
	return build(opcINT.Forms(), sffxs{}, []operand.Op{i})
}

// JA: Jump if above (CF == 0 and ZF == 0).
//
// Forms:
//
//	JA rel32
//	JA rel8
func JA(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJA.Forms(), sffxs{}, []operand.Op{r})
}

// JAE: Jump if above or equal (CF == 0).
//
// Forms:
//
//	JAE rel32
//	JAE rel8
func JAE(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJAE.Forms(), sffxs{}, []operand.Op{r})
}

// JB: Jump if below (CF == 1).
//
// Forms:
//
//	JB rel32
//	JB rel8
func JB(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJB.Forms(), sffxs{}, []operand.Op{r})
}

// JBE: Jump if below or equal (CF == 1 or ZF == 1).
//
// Forms:
//
//	JBE rel32
//	JBE rel8
func JBE(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJBE.Forms(), sffxs{}, []operand.Op{r})
}

// JC: Jump if below (CF == 1).
//
// Forms:
//
//	JC rel32
//	JC rel8
func JC(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJC.Forms(), sffxs{}, []operand.Op{r})
}

// JCC: Jump if above or equal (CF == 0).
//
// Forms:
//
//	JCC rel32
//	JCC rel8
func JCC(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJCC.Forms(), sffxs{}, []operand.Op{r})
}

// JCS: Jump if below (CF == 1).
//
// Forms:
//
//	JCS rel32
//	JCS rel8
func JCS(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJCS.Forms(), sffxs{}, []operand.Op{r})
}

// JCXZL: Jump if ECX register is 0.
//
// Forms:
//
//	JCXZL rel8
func JCXZL(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJCXZL.Forms(), sffxs{}, []operand.Op{r})
}

// JCXZQ: Jump if RCX register is 0.
//
// Forms:
//
//	JCXZQ rel8
func JCXZQ(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJCXZQ.Forms(), sffxs{}, []operand.Op{r})
}

// JE: Jump if equal (ZF == 1).
//
// Forms:
//
//	JE rel32
//	JE rel8
func JE(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJE.Forms(), sffxs{}, []operand.Op{r})
}

// JEQ: Jump if equal (ZF == 1).
//
// Forms:
//
//	JEQ rel32
//	JEQ rel8
func JEQ(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJEQ.Forms(), sffxs{}, []operand.Op{r})
}

// JG: Jump if greater (ZF == 0 and SF == OF).
//
// Forms:
//
//	JG rel32
//	JG rel8
func JG(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJG.Forms(), sffxs{}, []operand.Op{r})
}

// JGE: Jump if greater or equal (SF == OF).
//
// Forms:
//
//	JGE rel32
//	JGE rel8
func JGE(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJGE.Forms(), sffxs{}, []operand.Op{r})
}

// JGT: Jump if greater (ZF == 0 and SF == OF).
//
// Forms:
//
//	JGT rel32
//	JGT rel8
func JGT(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJGT.Forms(), sffxs{}, []operand.Op{r})
}

// JHI: Jump if above (CF == 0 and ZF == 0).
//
// Forms:
//
//	JHI rel32
//	JHI rel8
func JHI(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJHI.Forms(), sffxs{}, []operand.Op{r})
}

// JHS: Jump if above or equal (CF == 0).
//
// Forms:
//
//	JHS rel32
//	JHS rel8
func JHS(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJHS.Forms(), sffxs{}, []operand.Op{r})
}

// JL: Jump if less (SF != OF).
//
// Forms:
//
//	JL rel32
//	JL rel8
func JL(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJL.Forms(), sffxs{}, []operand.Op{r})
}

// JLE: Jump if less or equal (ZF == 1 or SF != OF).
//
// Forms:
//
//	JLE rel32
//	JLE rel8
func JLE(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJLE.Forms(), sffxs{}, []operand.Op{r})
}

// JLO: Jump if below (CF == 1).
//
// Forms:
//
//	JLO rel32
//	JLO rel8
func JLO(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJLO.Forms(), sffxs{}, []operand.Op{r})
}

// JLS: Jump if below or equal (CF == 1 or ZF == 1).
//
// Forms:
//
//	JLS rel32
//	JLS rel8
func JLS(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJLS.Forms(), sffxs{}, []operand.Op{r})
}

// JLT: Jump if less (SF != OF).
//
// Forms:
//
//	JLT rel32
//	JLT rel8
func JLT(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJLT.Forms(), sffxs{}, []operand.Op{r})
}

// JMI: Jump if sign (SF == 1).
//
// Forms:
//
//	JMI rel32
//	JMI rel8
func JMI(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJMI.Forms(), sffxs{}, []operand.Op{r})
}

// JMP: Jump Unconditionally.
//
// Forms:
//
//	JMP rel32
//	JMP rel8
//	JMP m64
//	JMP r64
func JMP(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcJMP.Forms(), sffxs{}, []operand.Op{mr})
}

// JNA: Jump if below or equal (CF == 1 or ZF == 1).
//
// Forms:
//
//	JNA rel32
//	JNA rel8
func JNA(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJNA.Forms(), sffxs{}, []operand.Op{r})
}

// JNAE: Jump if below (CF == 1).
//
// Forms:
//
//	JNAE rel32
//	JNAE rel8
func JNAE(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJNAE.Forms(), sffxs{}, []operand.Op{r})
}

// JNB: Jump if above or equal (CF == 0).
//
// Forms:
//
//	JNB rel32
//	JNB rel8
func JNB(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJNB.Forms(), sffxs{}, []operand.Op{r})
}

// JNBE: Jump if above (CF == 0 and ZF == 0).
//
// Forms:
//
//	JNBE rel32
//	JNBE rel8
func JNBE(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJNBE.Forms(), sffxs{}, []operand.Op{r})
}

// JNC: Jump if above or equal (CF == 0).
//
// Forms:
//
//	JNC rel32
//	JNC rel8
func JNC(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJNC.Forms(), sffxs{}, []operand.Op{r})
}

// JNE: Jump if not equal (ZF == 0).
//
// Forms:
//
//	JNE rel32
//	JNE rel8
func JNE(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJNE.Forms(), sffxs{}, []operand.Op{r})
}

// JNG: Jump if less or equal (ZF == 1 or SF != OF).
//
// Forms:
//
//	JNG rel32
//	JNG rel8
func JNG(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJNG.Forms(), sffxs{}, []operand.Op{r})
}

// JNGE: Jump if less (SF != OF).
//
// Forms:
//
//	JNGE rel32
//	JNGE rel8
func JNGE(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJNGE.Forms(), sffxs{}, []operand.Op{r})
}

// JNL: Jump if greater or equal (SF == OF).
//
// Forms:
//
//	JNL rel32
//	JNL rel8
func JNL(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJNL.Forms(), sffxs{}, []operand.Op{r})
}

// JNLE: Jump if greater (ZF == 0 and SF == OF).
//
// Forms:
//
//	JNLE rel32
//	JNLE rel8
func JNLE(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJNLE.Forms(), sffxs{}, []operand.Op{r})
}

// JNO: Jump if not overflow (OF == 0).
//
// Forms:
//
//	JNO rel32
//	JNO rel8
func JNO(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJNO.Forms(), sffxs{}, []operand.Op{r})
}

// JNP: Jump if not parity (PF == 0).
//
// Forms:
//
//	JNP rel32
//	JNP rel8
func JNP(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJNP.Forms(), sffxs{}, []operand.Op{r})
}

// JNS: Jump if not sign (SF == 0).
//
// Forms:
//
//	JNS rel32
//	JNS rel8
func JNS(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJNS.Forms(), sffxs{}, []operand.Op{r})
}

// JNZ: Jump if not equal (ZF == 0).
//
// Forms:
//
//	JNZ rel32
//	JNZ rel8
func JNZ(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJNZ.Forms(), sffxs{}, []operand.Op{r})
}

// JO: Jump if overflow (OF == 1).
//
// Forms:
//
//	JO rel32
//	JO rel8
func JO(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJO.Forms(), sffxs{}, []operand.Op{r})
}

// JOC: Jump if not overflow (OF == 0).
//
// Forms:
//
//	JOC rel32
//	JOC rel8
func JOC(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJOC.Forms(), sffxs{}, []operand.Op{r})
}

// JOS: Jump if overflow (OF == 1).
//
// Forms:
//
//	JOS rel32
//	JOS rel8
func JOS(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJOS.Forms(), sffxs{}, []operand.Op{r})
}

// JP: Jump if parity (PF == 1).
//
// Forms:
//
//	JP rel32
//	JP rel8
func JP(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJP.Forms(), sffxs{}, []operand.Op{r})
}

// JPC: Jump if not parity (PF == 0).
//
// Forms:
//
//	JPC rel32
//	JPC rel8
func JPC(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJPC.Forms(), sffxs{}, []operand.Op{r})
}

// JPE: Jump if parity (PF == 1).
//
// Forms:
//
//	JPE rel32
//	JPE rel8
func JPE(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJPE.Forms(), sffxs{}, []operand.Op{r})
}

// JPL: Jump if not sign (SF == 0).
//
// Forms:
//
//	JPL rel32
//	JPL rel8
func JPL(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJPL.Forms(), sffxs{}, []operand.Op{r})
}

// JPO: Jump if not parity (PF == 0).
//
// Forms:
//
//	JPO rel32
//	JPO rel8
func JPO(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJPO.Forms(), sffxs{}, []operand.Op{r})
}

// JPS: Jump if parity (PF == 1).
//
// Forms:
//
//	JPS rel32
//	JPS rel8
func JPS(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJPS.Forms(), sffxs{}, []operand.Op{r})
}

// JS: Jump if sign (SF == 1).
//
// Forms:
//
//	JS rel32
//	JS rel8
func JS(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJS.Forms(), sffxs{}, []operand.Op{r})
}

// JZ: Jump if equal (ZF == 1).
//
// Forms:
//
//	JZ rel32
//	JZ rel8
func JZ(r operand.Op) (*intrep.Instruction, error) {
	return build(opcJZ.Forms(), sffxs{}, []operand.Op{r})
}

// KADDB: ADD Two 8-bit Masks.
//
// Forms:
//
//	KADDB k k k
func KADDB(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKADDB.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KADDD: ADD Two 32-bit Masks.
//
// Forms:
//
//	KADDD k k k
func KADDD(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKADDD.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KADDQ: ADD Two 64-bit Masks.
//
// Forms:
//
//	KADDQ k k k
func KADDQ(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKADDQ.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KADDW: ADD Two 16-bit Masks.
//
// Forms:
//
//	KADDW k k k
func KADDW(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKADDW.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KANDB: Bitwise Logical AND 8-bit Masks.
//
// Forms:
//
//	KANDB k k k
func KANDB(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKANDB.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KANDD: Bitwise Logical AND 32-bit Masks.
//
// Forms:
//
//	KANDD k k k
func KANDD(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKANDD.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KANDNB: Bitwise Logical AND NOT 8-bit Masks.
//
// Forms:
//
//	KANDNB k k k
func KANDNB(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKANDNB.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KANDND: Bitwise Logical AND NOT 32-bit Masks.
//
// Forms:
//
//	KANDND k k k
func KANDND(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKANDND.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KANDNQ: Bitwise Logical AND NOT 64-bit Masks.
//
// Forms:
//
//	KANDNQ k k k
func KANDNQ(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKANDNQ.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KANDNW: Bitwise Logical AND NOT 16-bit Masks.
//
// Forms:
//
//	KANDNW k k k
func KANDNW(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKANDNW.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KANDQ: Bitwise Logical AND 64-bit Masks.
//
// Forms:
//
//	KANDQ k k k
func KANDQ(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKANDQ.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KANDW: Bitwise Logical AND 16-bit Masks.
//
// Forms:
//
//	KANDW k k k
func KANDW(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKANDW.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KMOVB: Move 8-bit Mask.
//
// Forms:
//
//	KMOVB k   k
//	KMOVB k   m8
//	KMOVB k   r32
//	KMOVB m8  k
//	KMOVB r32 k
func KMOVB(kmr, kmr1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKMOVB.Forms(), sffxs{}, []operand.Op{kmr, kmr1})
}

// KMOVD: Move 32-bit Mask.
//
// Forms:
//
//	KMOVD k   k
//	KMOVD k   m32
//	KMOVD k   r32
//	KMOVD m32 k
//	KMOVD r32 k
func KMOVD(kmr, kmr1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKMOVD.Forms(), sffxs{}, []operand.Op{kmr, kmr1})
}

// KMOVQ: Move 64-bit Mask.
//
// Forms:
//
//	KMOVQ k   k
//	KMOVQ k   m64
//	KMOVQ k   r64
//	KMOVQ m64 k
//	KMOVQ r64 k
func KMOVQ(kmr, kmr1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKMOVQ.Forms(), sffxs{}, []operand.Op{kmr, kmr1})
}

// KMOVW: Move 16-bit Mask.
//
// Forms:
//
//	KMOVW k   k
//	KMOVW k   m16
//	KMOVW k   r32
//	KMOVW m16 k
//	KMOVW r32 k
func KMOVW(kmr, kmr1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKMOVW.Forms(), sffxs{}, []operand.Op{kmr, kmr1})
}

// KNOTB: NOT 8-bit Mask Register.
//
// Forms:
//
//	KNOTB k k
func KNOTB(k, k1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKNOTB.Forms(), sffxs{}, []operand.Op{k, k1})
}

// KNOTD: NOT 32-bit Mask Register.
//
// Forms:
//
//	KNOTD k k
func KNOTD(k, k1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKNOTD.Forms(), sffxs{}, []operand.Op{k, k1})
}

// KNOTQ: NOT 64-bit Mask Register.
//
// Forms:
//
//	KNOTQ k k
func KNOTQ(k, k1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKNOTQ.Forms(), sffxs{}, []operand.Op{k, k1})
}

// KNOTW: NOT 16-bit Mask Register.
//
// Forms:
//
//	KNOTW k k
func KNOTW(k, k1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKNOTW.Forms(), sffxs{}, []operand.Op{k, k1})
}

// KORB: Bitwise Logical OR 8-bit Masks.
//
// Forms:
//
//	KORB k k k
func KORB(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKORB.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KORD: Bitwise Logical OR 32-bit Masks.
//
// Forms:
//
//	KORD k k k
func KORD(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKORD.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KORQ: Bitwise Logical OR 64-bit Masks.
//
// Forms:
//
//	KORQ k k k
func KORQ(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKORQ.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KORTESTB: OR 8-bit Masks and Set Flags.
//
// Forms:
//
//	KORTESTB k k
func KORTESTB(k, k1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKORTESTB.Forms(), sffxs{}, []operand.Op{k, k1})
}

// KORTESTD: OR 32-bit Masks and Set Flags.
//
// Forms:
//
//	KORTESTD k k
func KORTESTD(k, k1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKORTESTD.Forms(), sffxs{}, []operand.Op{k, k1})
}

// KORTESTQ: OR 64-bit Masks and Set Flags.
//
// Forms:
//
//	KORTESTQ k k
func KORTESTQ(k, k1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKORTESTQ.Forms(), sffxs{}, []operand.Op{k, k1})
}

// KORTESTW: OR 16-bit Masks and Set Flags.
//
// Forms:
//
//	KORTESTW k k
func KORTESTW(k, k1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKORTESTW.Forms(), sffxs{}, []operand.Op{k, k1})
}

// KORW: Bitwise Logical OR 16-bit Masks.
//
// Forms:
//
//	KORW k k k
func KORW(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKORW.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KSHIFTLB: Shift Left 8-bit Masks.
//
// Forms:
//
//	KSHIFTLB imm8 k k
func KSHIFTLB(i, k, k1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKSHIFTLB.Forms(), sffxs{}, []operand.Op{i, k, k1})
}

// KSHIFTLD: Shift Left 32-bit Masks.
//
// Forms:
//
//	KSHIFTLD imm8 k k
func KSHIFTLD(i, k, k1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKSHIFTLD.Forms(), sffxs{}, []operand.Op{i, k, k1})
}

// KSHIFTLQ: Shift Left 64-bit Masks.
//
// Forms:
//
//	KSHIFTLQ imm8 k k
func KSHIFTLQ(i, k, k1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKSHIFTLQ.Forms(), sffxs{}, []operand.Op{i, k, k1})
}

// KSHIFTLW: Shift Left 16-bit Masks.
//
// Forms:
//
//	KSHIFTLW imm8 k k
func KSHIFTLW(i, k, k1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKSHIFTLW.Forms(), sffxs{}, []operand.Op{i, k, k1})
}

// KSHIFTRB: Shift Right 8-bit Masks.
//
// Forms:
//
//	KSHIFTRB imm8 k k
func KSHIFTRB(i, k, k1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKSHIFTRB.Forms(), sffxs{}, []operand.Op{i, k, k1})
}

// KSHIFTRD: Shift Right 32-bit Masks.
//
// Forms:
//
//	KSHIFTRD imm8 k k
func KSHIFTRD(i, k, k1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKSHIFTRD.Forms(), sffxs{}, []operand.Op{i, k, k1})
}

// KSHIFTRQ: Shift Right 64-bit Masks.
//
// Forms:
//
//	KSHIFTRQ imm8 k k
func KSHIFTRQ(i, k, k1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKSHIFTRQ.Forms(), sffxs{}, []operand.Op{i, k, k1})
}

// KSHIFTRW: Shift Right 16-bit Masks.
//
// Forms:
//
//	KSHIFTRW imm8 k k
func KSHIFTRW(i, k, k1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKSHIFTRW.Forms(), sffxs{}, []operand.Op{i, k, k1})
}

// KTESTB: Bit Test 8-bit Masks and Set Flags.
//
// Forms:
//
//	KTESTB k k
func KTESTB(k, k1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKTESTB.Forms(), sffxs{}, []operand.Op{k, k1})
}

// KTESTD: Bit Test 32-bit Masks and Set Flags.
//
// Forms:
//
//	KTESTD k k
func KTESTD(k, k1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKTESTD.Forms(), sffxs{}, []operand.Op{k, k1})
}

// KTESTQ: Bit Test 64-bit Masks and Set Flags.
//
// Forms:
//
//	KTESTQ k k
func KTESTQ(k, k1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKTESTQ.Forms(), sffxs{}, []operand.Op{k, k1})
}

// KTESTW: Bit Test 16-bit Masks and Set Flags.
//
// Forms:
//
//	KTESTW k k
func KTESTW(k, k1 operand.Op) (*intrep.Instruction, error) {
	return build(opcKTESTW.Forms(), sffxs{}, []operand.Op{k, k1})
}

// KUNPCKBW: Unpack and Interleave 8-bit Masks.
//
// Forms:
//
//	KUNPCKBW k k k
func KUNPCKBW(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKUNPCKBW.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KUNPCKDQ: Unpack and Interleave 32-bit Masks.
//
// Forms:
//
//	KUNPCKDQ k k k
func KUNPCKDQ(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKUNPCKDQ.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KUNPCKWD: Unpack and Interleave 16-bit Masks.
//
// Forms:
//
//	KUNPCKWD k k k
func KUNPCKWD(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKUNPCKWD.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KXNORB: Bitwise Logical XNOR 8-bit Masks.
//
// Forms:
//
//	KXNORB k k k
func KXNORB(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKXNORB.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KXNORD: Bitwise Logical XNOR 32-bit Masks.
//
// Forms:
//
//	KXNORD k k k
func KXNORD(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKXNORD.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KXNORQ: Bitwise Logical XNOR 64-bit Masks.
//
// Forms:
//
//	KXNORQ k k k
func KXNORQ(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKXNORQ.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KXNORW: Bitwise Logical XNOR 16-bit Masks.
//
// Forms:
//
//	KXNORW k k k
func KXNORW(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKXNORW.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KXORB: Bitwise Logical XOR 8-bit Masks.
//
// Forms:
//
//	KXORB k k k
func KXORB(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKXORB.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KXORD: Bitwise Logical XOR 32-bit Masks.
//
// Forms:
//
//	KXORD k k k
func KXORD(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKXORD.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KXORQ: Bitwise Logical XOR 64-bit Masks.
//
// Forms:
//
//	KXORQ k k k
func KXORQ(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKXORQ.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// KXORW: Bitwise Logical XOR 16-bit Masks.
//
// Forms:
//
//	KXORW k k k
func KXORW(k, k1, k2 operand.Op) (*intrep.Instruction, error) {
	return build(opcKXORW.Forms(), sffxs{}, []operand.Op{k, k1, k2})
}

// LDDQU: Load Unaligned Integer 128 Bits.
//
// Forms:
//
//	LDDQU m128 xmm
func LDDQU(m, x operand.Op) (*intrep.Instruction, error) {
	return build(opcLDDQU.Forms(), sffxs{}, []operand.Op{m, x})
}

// LDMXCSR: Load MXCSR Register.
//
// Forms:
//
//	LDMXCSR m32
func LDMXCSR(m operand.Op) (*intrep.Instruction, error) {
	return build(opcLDMXCSR.Forms(), sffxs{}, []operand.Op{m})
}

// LEAL: Load Effective Address.
//
// Forms:
//
//	LEAL m r32
func LEAL(m, r operand.Op) (*intrep.Instruction, error) {
	return build(opcLEAL.Forms(), sffxs{}, []operand.Op{m, r})
}

// LEAQ: Load Effective Address.
//
// Forms:
//
//	LEAQ m r64
func LEAQ(m, r operand.Op) (*intrep.Instruction, error) {
	return build(opcLEAQ.Forms(), sffxs{}, []operand.Op{m, r})
}

// LEAW: Load Effective Address.
//
// Forms:
//
//	LEAW m r16
func LEAW(m, r operand.Op) (*intrep.Instruction, error) {
	return build(opcLEAW.Forms(), sffxs{}, []operand.Op{m, r})
}

// LFENCE: Load Fence.
//
// Forms:
//
//	LFENCE
func LFENCE() (*intrep.Instruction, error) {
	return build(opcLFENCE.Forms(), sffxs{}, []operand.Op{})
}

// LZCNTL: Count the Number of Leading Zero Bits.
//
// Forms:
//
//	LZCNTL m32 r32
//	LZCNTL r32 r32
func LZCNTL(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcLZCNTL.Forms(), sffxs{}, []operand.Op{mr, r})
}

// LZCNTQ: Count the Number of Leading Zero Bits.
//
// Forms:
//
//	LZCNTQ m64 r64
//	LZCNTQ r64 r64
func LZCNTQ(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcLZCNTQ.Forms(), sffxs{}, []operand.Op{mr, r})
}

// LZCNTW: Count the Number of Leading Zero Bits.
//
// Forms:
//
//	LZCNTW m16 r16
//	LZCNTW r16 r16
func LZCNTW(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcLZCNTW.Forms(), sffxs{}, []operand.Op{mr, r})
}

// MASKMOVDQU: Store Selected Bytes of Double Quadword.
//
// Forms:
//
//	MASKMOVDQU xmm xmm
func MASKMOVDQU(x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMASKMOVDQU.Forms(), sffxs{}, []operand.Op{x, x1})
}

// MASKMOVOU: Store Selected Bytes of Double Quadword.
//
// Forms:
//
//	MASKMOVOU xmm xmm
func MASKMOVOU(x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMASKMOVOU.Forms(), sffxs{}, []operand.Op{x, x1})
}

// MAXPD: Return Maximum Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	MAXPD m128 xmm
//	MAXPD xmm  xmm
func MAXPD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcMAXPD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// MAXPS: Return Maximum Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	MAXPS m128 xmm
//	MAXPS xmm  xmm
func MAXPS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcMAXPS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// MAXSD: Return Maximum Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	MAXSD m64 xmm
//	MAXSD xmm xmm
func MAXSD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcMAXSD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// MAXSS: Return Maximum Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	MAXSS m32 xmm
//	MAXSS xmm xmm
func MAXSS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcMAXSS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// MFENCE: Memory Fence.
//
// Forms:
//
//	MFENCE
func MFENCE() (*intrep.Instruction, error) {
	return build(opcMFENCE.Forms(), sffxs{}, []operand.Op{})
}

// MINPD: Return Minimum Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	MINPD m128 xmm
//	MINPD xmm  xmm
func MINPD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcMINPD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// MINPS: Return Minimum Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	MINPS m128 xmm
//	MINPS xmm  xmm
func MINPS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcMINPS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// MINSD: Return Minimum Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	MINSD m64 xmm
//	MINSD xmm xmm
func MINSD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcMINSD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// MINSS: Return Minimum Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	MINSS m32 xmm
//	MINSS xmm xmm
func MINSS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcMINSS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// MONITOR: Monitor a Linear Address Range.
//
// Forms:
//
//	MONITOR
func MONITOR() (*intrep.Instruction, error) {
	return build(opcMONITOR.Forms(), sffxs{}, []operand.Op{})
}

// MOVAPD: Move Aligned Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	MOVAPD m128 xmm
//	MOVAPD xmm  m128
//	MOVAPD xmm  xmm
func MOVAPD(mx, mx1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVAPD.Forms(), sffxs{}, []operand.Op{mx, mx1})
}

// MOVAPS: Move Aligned Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	MOVAPS m128 xmm
//	MOVAPS xmm  m128
//	MOVAPS xmm  xmm
func MOVAPS(mx, mx1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVAPS.Forms(), sffxs{}, []operand.Op{mx, mx1})
}

// MOVB: Move.
//
// Forms:
//
//	MOVB imm8 m8
//	MOVB imm8 r8
//	MOVB m8   r8
//	MOVB r8   m8
//	MOVB r8   r8
func MOVB(imr, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVB.Forms(), sffxs{}, []operand.Op{imr, mr})
}

// MOVBELL: Move Data After Swapping Bytes.
//
// Forms:
//
//	MOVBELL m32 r32
//	MOVBELL r32 m32
func MOVBELL(mr, mr1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVBELL.Forms(), sffxs{}, []operand.Op{mr, mr1})
}

// MOVBEQQ: Move Data After Swapping Bytes.
//
// Forms:
//
//	MOVBEQQ m64 r64
//	MOVBEQQ r64 m64
func MOVBEQQ(mr, mr1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVBEQQ.Forms(), sffxs{}, []operand.Op{mr, mr1})
}

// MOVBEWW: Move Data After Swapping Bytes.
//
// Forms:
//
//	MOVBEWW m16 r16
//	MOVBEWW r16 m16
func MOVBEWW(mr, mr1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVBEWW.Forms(), sffxs{}, []operand.Op{mr, mr1})
}

// MOVBLSX: Move with Sign-Extension.
//
// Forms:
//
//	MOVBLSX m8 r32
//	MOVBLSX r8 r32
func MOVBLSX(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVBLSX.Forms(), sffxs{}, []operand.Op{mr, r})
}

// MOVBLZX: Move with Zero-Extend.
//
// Forms:
//
//	MOVBLZX m8 r32
//	MOVBLZX r8 r32
func MOVBLZX(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVBLZX.Forms(), sffxs{}, []operand.Op{mr, r})
}

// MOVBQSX: Move with Sign-Extension.
//
// Forms:
//
//	MOVBQSX m8 r64
//	MOVBQSX r8 r64
func MOVBQSX(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVBQSX.Forms(), sffxs{}, []operand.Op{mr, r})
}

// MOVBQZX: Move with Zero-Extend.
//
// Forms:
//
//	MOVBQZX m8 r64
//	MOVBQZX r8 r64
func MOVBQZX(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVBQZX.Forms(), sffxs{}, []operand.Op{mr, r})
}

// MOVBWSX: Move with Sign-Extension.
//
// Forms:
//
//	MOVBWSX m8 r16
//	MOVBWSX r8 r16
func MOVBWSX(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVBWSX.Forms(), sffxs{}, []operand.Op{mr, r})
}

// MOVBWZX: Move with Zero-Extend.
//
// Forms:
//
//	MOVBWZX m8 r16
//	MOVBWZX r8 r16
func MOVBWZX(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVBWZX.Forms(), sffxs{}, []operand.Op{mr, r})
}

// MOVD: Move.
//
// Forms:
//
//	MOVD m32   xmm
//	MOVD m64   xmm
//	MOVD r32   xmm
//	MOVD r64   xmm
//	MOVD xmm   m32
//	MOVD xmm   m64
//	MOVD xmm   r32
//	MOVD xmm   r64
//	MOVD xmm   xmm
//	MOVD imm32 m64
//	MOVD imm32 r64
//	MOVD imm64 r64
//	MOVD m64   r64
//	MOVD r64   m64
//	MOVD r64   r64
func MOVD(imrx, mrx operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVD.Forms(), sffxs{}, []operand.Op{imrx, mrx})
}

// MOVDDUP: Move One Double-FP and Duplicate.
//
// Forms:
//
//	MOVDDUP m64 xmm
//	MOVDDUP xmm xmm
func MOVDDUP(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVDDUP.Forms(), sffxs{}, []operand.Op{mx, x})
}

// MOVDQ2Q: Move.
//
// Forms:
//
//	MOVDQ2Q m32   xmm
//	MOVDQ2Q m64   xmm
//	MOVDQ2Q r32   xmm
//	MOVDQ2Q r64   xmm
//	MOVDQ2Q xmm   m32
//	MOVDQ2Q xmm   m64
//	MOVDQ2Q xmm   r32
//	MOVDQ2Q xmm   r64
//	MOVDQ2Q xmm   xmm
//	MOVDQ2Q imm32 m64
//	MOVDQ2Q imm32 r64
//	MOVDQ2Q imm64 r64
//	MOVDQ2Q m64   r64
//	MOVDQ2Q r64   m64
//	MOVDQ2Q r64   r64
func MOVDQ2Q(imrx, mrx operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVDQ2Q.Forms(), sffxs{}, []operand.Op{imrx, mrx})
}

// MOVHLPS: Move Packed Single-Precision Floating-Point Values High to Low.
//
// Forms:
//
//	MOVHLPS xmm xmm
func MOVHLPS(x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVHLPS.Forms(), sffxs{}, []operand.Op{x, x1})
}

// MOVHPD: Move High Packed Double-Precision Floating-Point Value.
//
// Forms:
//
//	MOVHPD m64 xmm
//	MOVHPD xmm m64
func MOVHPD(mx, mx1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVHPD.Forms(), sffxs{}, []operand.Op{mx, mx1})
}

// MOVHPS: Move High Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	MOVHPS m64 xmm
//	MOVHPS xmm m64
func MOVHPS(mx, mx1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVHPS.Forms(), sffxs{}, []operand.Op{mx, mx1})
}

// MOVL: Move.
//
// Forms:
//
//	MOVL imm32 m32
//	MOVL imm32 r32
//	MOVL m32   r32
//	MOVL r32   m32
//	MOVL r32   r32
func MOVL(imr, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVL.Forms(), sffxs{}, []operand.Op{imr, mr})
}

// MOVLHPS: Move Packed Single-Precision Floating-Point Values Low to High.
//
// Forms:
//
//	MOVLHPS xmm xmm
func MOVLHPS(x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVLHPS.Forms(), sffxs{}, []operand.Op{x, x1})
}

// MOVLPD: Move Low Packed Double-Precision Floating-Point Value.
//
// Forms:
//
//	MOVLPD m64 xmm
//	MOVLPD xmm m64
func MOVLPD(mx, mx1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVLPD.Forms(), sffxs{}, []operand.Op{mx, mx1})
}

// MOVLPS: Move Low Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	MOVLPS m64 xmm
//	MOVLPS xmm m64
func MOVLPS(mx, mx1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVLPS.Forms(), sffxs{}, []operand.Op{mx, mx1})
}

// MOVLQSX: Move Doubleword to Quadword with Sign-Extension.
//
// Forms:
//
//	MOVLQSX m32 r64
//	MOVLQSX r32 r64
func MOVLQSX(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVLQSX.Forms(), sffxs{}, []operand.Op{mr, r})
}

// MOVLQZX: Move with Zero-Extend.
//
// Forms:
//
//	MOVLQZX m32 r64
func MOVLQZX(m, r operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVLQZX.Forms(), sffxs{}, []operand.Op{m, r})
}

// MOVMSKPD: Extract Packed Double-Precision Floating-Point Sign Mask.
//
// Forms:
//
//	MOVMSKPD xmm r32
func MOVMSKPD(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVMSKPD.Forms(), sffxs{}, []operand.Op{x, r})
}

// MOVMSKPS: Extract Packed Single-Precision Floating-Point Sign Mask.
//
// Forms:
//
//	MOVMSKPS xmm r32
func MOVMSKPS(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVMSKPS.Forms(), sffxs{}, []operand.Op{x, r})
}

// MOVNTDQ: Store Double Quadword Using Non-Temporal Hint.
//
// Forms:
//
//	MOVNTDQ xmm m128
func MOVNTDQ(x, m operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVNTDQ.Forms(), sffxs{}, []operand.Op{x, m})
}

// MOVNTDQA: Load Double Quadword Non-Temporal Aligned Hint.
//
// Forms:
//
//	MOVNTDQA m128 xmm
func MOVNTDQA(m, x operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVNTDQA.Forms(), sffxs{}, []operand.Op{m, x})
}

// MOVNTIL: Store Doubleword Using Non-Temporal Hint.
//
// Forms:
//
//	MOVNTIL r32 m32
func MOVNTIL(r, m operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVNTIL.Forms(), sffxs{}, []operand.Op{r, m})
}

// MOVNTIQ: Store Doubleword Using Non-Temporal Hint.
//
// Forms:
//
//	MOVNTIQ r64 m64
func MOVNTIQ(r, m operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVNTIQ.Forms(), sffxs{}, []operand.Op{r, m})
}

// MOVNTO: Store Double Quadword Using Non-Temporal Hint.
//
// Forms:
//
//	MOVNTO xmm m128
func MOVNTO(x, m operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVNTO.Forms(), sffxs{}, []operand.Op{x, m})
}

// MOVNTPD: Store Packed Double-Precision Floating-Point Values Using Non-Temporal Hint.
//
// Forms:
//
//	MOVNTPD xmm m128
func MOVNTPD(x, m operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVNTPD.Forms(), sffxs{}, []operand.Op{x, m})
}

// MOVNTPS: Store Packed Single-Precision Floating-Point Values Using Non-Temporal Hint.
//
// Forms:
//
//	MOVNTPS xmm m128
func MOVNTPS(x, m operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVNTPS.Forms(), sffxs{}, []operand.Op{x, m})
}

// MOVO: Move Aligned Double Quadword.
//
// Forms:
//
//	MOVO m128 xmm
//	MOVO xmm  m128
//	MOVO xmm  xmm
func MOVO(mx, mx1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVO.Forms(), sffxs{}, []operand.Op{mx, mx1})
}

// MOVOA: Move Aligned Double Quadword.
//
// Forms:
//
//	MOVOA m128 xmm
//	MOVOA xmm  m128
//	MOVOA xmm  xmm
func MOVOA(mx, mx1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVOA.Forms(), sffxs{}, []operand.Op{mx, mx1})
}

// MOVOU: Move Unaligned Double Quadword.
//
// Forms:
//
//	MOVOU m128 xmm
//	MOVOU xmm  m128
//	MOVOU xmm  xmm
func MOVOU(mx, mx1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVOU.Forms(), sffxs{}, []operand.Op{mx, mx1})
}

// MOVQ: Move.
//
// Forms:
//
//	MOVQ m32   xmm
//	MOVQ m64   xmm
//	MOVQ r32   xmm
//	MOVQ r64   xmm
//	MOVQ xmm   m32
//	MOVQ xmm   m64
//	MOVQ xmm   r32
//	MOVQ xmm   r64
//	MOVQ xmm   xmm
//	MOVQ imm32 m64
//	MOVQ imm32 r64
//	MOVQ imm64 r64
//	MOVQ m64   r64
//	MOVQ r64   m64
//	MOVQ r64   r64
func MOVQ(imrx, mrx operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVQ.Forms(), sffxs{}, []operand.Op{imrx, mrx})
}

// MOVSD: Move Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	MOVSD m64 xmm
//	MOVSD xmm m64
//	MOVSD xmm xmm
func MOVSD(mx, mx1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVSD.Forms(), sffxs{}, []operand.Op{mx, mx1})
}

// MOVSHDUP: Move Packed Single-FP High and Duplicate.
//
// Forms:
//
//	MOVSHDUP m128 xmm
//	MOVSHDUP xmm  xmm
func MOVSHDUP(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVSHDUP.Forms(), sffxs{}, []operand.Op{mx, x})
}

// MOVSLDUP: Move Packed Single-FP Low and Duplicate.
//
// Forms:
//
//	MOVSLDUP m128 xmm
//	MOVSLDUP xmm  xmm
func MOVSLDUP(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVSLDUP.Forms(), sffxs{}, []operand.Op{mx, x})
}

// MOVSS: Move Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	MOVSS m32 xmm
//	MOVSS xmm m32
//	MOVSS xmm xmm
func MOVSS(mx, mx1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVSS.Forms(), sffxs{}, []operand.Op{mx, mx1})
}

// MOVUPD: Move Unaligned Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	MOVUPD m128 xmm
//	MOVUPD xmm  m128
//	MOVUPD xmm  xmm
func MOVUPD(mx, mx1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVUPD.Forms(), sffxs{}, []operand.Op{mx, mx1})
}

// MOVUPS: Move Unaligned Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	MOVUPS m128 xmm
//	MOVUPS xmm  m128
//	MOVUPS xmm  xmm
func MOVUPS(mx, mx1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVUPS.Forms(), sffxs{}, []operand.Op{mx, mx1})
}

// MOVW: Move.
//
// Forms:
//
//	MOVW imm16 m16
//	MOVW imm16 r16
//	MOVW m16   r16
//	MOVW r16   m16
//	MOVW r16   r16
func MOVW(imr, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVW.Forms(), sffxs{}, []operand.Op{imr, mr})
}

// MOVWLSX: Move with Sign-Extension.
//
// Forms:
//
//	MOVWLSX m16 r32
//	MOVWLSX r16 r32
func MOVWLSX(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVWLSX.Forms(), sffxs{}, []operand.Op{mr, r})
}

// MOVWLZX: Move with Zero-Extend.
//
// Forms:
//
//	MOVWLZX m16 r32
//	MOVWLZX r16 r32
func MOVWLZX(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVWLZX.Forms(), sffxs{}, []operand.Op{mr, r})
}

// MOVWQSX: Move with Sign-Extension.
//
// Forms:
//
//	MOVWQSX m16 r64
//	MOVWQSX r16 r64
func MOVWQSX(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVWQSX.Forms(), sffxs{}, []operand.Op{mr, r})
}

// MOVWQZX: Move with Zero-Extend.
//
// Forms:
//
//	MOVWQZX m16 r64
//	MOVWQZX r16 r64
func MOVWQZX(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcMOVWQZX.Forms(), sffxs{}, []operand.Op{mr, r})
}

// MPSADBW: Compute Multiple Packed Sums of Absolute Difference.
//
// Forms:
//
//	MPSADBW imm8 m128 xmm
//	MPSADBW imm8 xmm  xmm
func MPSADBW(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcMPSADBW.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// MULB: Unsigned Multiply.
//
// Forms:
//
//	MULB m8
//	MULB r8
func MULB(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcMULB.Forms(), sffxs{}, []operand.Op{mr})
}

// MULL: Unsigned Multiply.
//
// Forms:
//
//	MULL m32
//	MULL r32
func MULL(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcMULL.Forms(), sffxs{}, []operand.Op{mr})
}

// MULPD: Multiply Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	MULPD m128 xmm
//	MULPD xmm  xmm
func MULPD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcMULPD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// MULPS: Multiply Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	MULPS m128 xmm
//	MULPS xmm  xmm
func MULPS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcMULPS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// MULQ: Unsigned Multiply.
//
// Forms:
//
//	MULQ m64
//	MULQ r64
func MULQ(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcMULQ.Forms(), sffxs{}, []operand.Op{mr})
}

// MULSD: Multiply Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	MULSD m64 xmm
//	MULSD xmm xmm
func MULSD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcMULSD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// MULSS: Multiply Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	MULSS m32 xmm
//	MULSS xmm xmm
func MULSS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcMULSS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// MULW: Unsigned Multiply.
//
// Forms:
//
//	MULW m16
//	MULW r16
func MULW(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcMULW.Forms(), sffxs{}, []operand.Op{mr})
}

// MULXL: Unsigned Multiply Without Affecting Flags.
//
// Forms:
//
//	MULXL m32 r32 r32
//	MULXL r32 r32 r32
func MULXL(mr, r, r1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMULXL.Forms(), sffxs{}, []operand.Op{mr, r, r1})
}

// MULXQ: Unsigned Multiply Without Affecting Flags.
//
// Forms:
//
//	MULXQ m64 r64 r64
//	MULXQ r64 r64 r64
func MULXQ(mr, r, r1 operand.Op) (*intrep.Instruction, error) {
	return build(opcMULXQ.Forms(), sffxs{}, []operand.Op{mr, r, r1})
}

// MWAIT: Monitor Wait.
//
// Forms:
//
//	MWAIT
func MWAIT() (*intrep.Instruction, error) {
	return build(opcMWAIT.Forms(), sffxs{}, []operand.Op{})
}

// NEGB: Two's Complement Negation.
//
// Forms:
//
//	NEGB m8
//	NEGB r8
func NEGB(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcNEGB.Forms(), sffxs{}, []operand.Op{mr})
}

// NEGL: Two's Complement Negation.
//
// Forms:
//
//	NEGL m32
//	NEGL r32
func NEGL(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcNEGL.Forms(), sffxs{}, []operand.Op{mr})
}

// NEGQ: Two's Complement Negation.
//
// Forms:
//
//	NEGQ m64
//	NEGQ r64
func NEGQ(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcNEGQ.Forms(), sffxs{}, []operand.Op{mr})
}

// NEGW: Two's Complement Negation.
//
// Forms:
//
//	NEGW m16
//	NEGW r16
func NEGW(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcNEGW.Forms(), sffxs{}, []operand.Op{mr})
}

// NOP: No Operation.
//
// Forms:
//
//	NOP
func NOP() (*intrep.Instruction, error) {
	return build(opcNOP.Forms(), sffxs{}, []operand.Op{})
}

// NOTB: One's Complement Negation.
//
// Forms:
//
//	NOTB m8
//	NOTB r8
func NOTB(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcNOTB.Forms(), sffxs{}, []operand.Op{mr})
}

// NOTL: One's Complement Negation.
//
// Forms:
//
//	NOTL m32
//	NOTL r32
func NOTL(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcNOTL.Forms(), sffxs{}, []operand.Op{mr})
}

// NOTQ: One's Complement Negation.
//
// Forms:
//
//	NOTQ m64
//	NOTQ r64
func NOTQ(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcNOTQ.Forms(), sffxs{}, []operand.Op{mr})
}

// NOTW: One's Complement Negation.
//
// Forms:
//
//	NOTW m16
//	NOTW r16
func NOTW(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcNOTW.Forms(), sffxs{}, []operand.Op{mr})
}

// ORB: Logical Inclusive OR.
//
// Forms:
//
//	ORB imm8 al
//	ORB imm8 m8
//	ORB imm8 r8
//	ORB m8   r8
//	ORB r8   m8
//	ORB r8   r8
func ORB(imr, amr operand.Op) (*intrep.Instruction, error) {
	return build(opcORB.Forms(), sffxs{}, []operand.Op{imr, amr})
}

// ORL: Logical Inclusive OR.
//
// Forms:
//
//	ORL imm32 eax
//	ORL imm32 m32
//	ORL imm32 r32
//	ORL imm8  m32
//	ORL imm8  r32
//	ORL m32   r32
//	ORL r32   m32
//	ORL r32   r32
func ORL(imr, emr operand.Op) (*intrep.Instruction, error) {
	return build(opcORL.Forms(), sffxs{}, []operand.Op{imr, emr})
}

// ORPD: Bitwise Logical OR of Double-Precision Floating-Point Values.
//
// Forms:
//
//	ORPD m128 xmm
//	ORPD xmm  xmm
func ORPD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcORPD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// ORPS: Bitwise Logical OR of Single-Precision Floating-Point Values.
//
// Forms:
//
//	ORPS m128 xmm
//	ORPS xmm  xmm
func ORPS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcORPS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// ORQ: Logical Inclusive OR.
//
// Forms:
//
//	ORQ imm32 m64
//	ORQ imm32 r64
//	ORQ imm32 rax
//	ORQ imm8  m64
//	ORQ imm8  r64
//	ORQ m64   r64
//	ORQ r64   m64
//	ORQ r64   r64
func ORQ(imr, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcORQ.Forms(), sffxs{}, []operand.Op{imr, mr})
}

// ORW: Logical Inclusive OR.
//
// Forms:
//
//	ORW imm16 ax
//	ORW imm16 m16
//	ORW imm16 r16
//	ORW imm8  m16
//	ORW imm8  r16
//	ORW m16   r16
//	ORW r16   m16
//	ORW r16   r16
func ORW(imr, amr operand.Op) (*intrep.Instruction, error) {
	return build(opcORW.Forms(), sffxs{}, []operand.Op{imr, amr})
}

// PABSB: Packed Absolute Value of Byte Integers.
//
// Forms:
//
//	PABSB m128 xmm
//	PABSB xmm  xmm
func PABSB(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPABSB.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PABSD: Packed Absolute Value of Doubleword Integers.
//
// Forms:
//
//	PABSD m128 xmm
//	PABSD xmm  xmm
func PABSD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPABSD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PABSW: Packed Absolute Value of Word Integers.
//
// Forms:
//
//	PABSW m128 xmm
//	PABSW xmm  xmm
func PABSW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPABSW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PACKSSLW: Pack Doublewords into Words with Signed Saturation.
//
// Forms:
//
//	PACKSSLW m128 xmm
//	PACKSSLW xmm  xmm
func PACKSSLW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPACKSSLW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PACKSSWB: Pack Words into Bytes with Signed Saturation.
//
// Forms:
//
//	PACKSSWB m128 xmm
//	PACKSSWB xmm  xmm
func PACKSSWB(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPACKSSWB.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PACKUSDW: Pack Doublewords into Words with Unsigned Saturation.
//
// Forms:
//
//	PACKUSDW m128 xmm
//	PACKUSDW xmm  xmm
func PACKUSDW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPACKUSDW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PACKUSWB: Pack Words into Bytes with Unsigned Saturation.
//
// Forms:
//
//	PACKUSWB m128 xmm
//	PACKUSWB xmm  xmm
func PACKUSWB(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPACKUSWB.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PADDB: Add Packed Byte Integers.
//
// Forms:
//
//	PADDB m128 xmm
//	PADDB xmm  xmm
func PADDB(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPADDB.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PADDD: Add Packed Doubleword Integers.
//
// Forms:
//
//	PADDD m128 xmm
//	PADDD xmm  xmm
func PADDD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPADDD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PADDL: Add Packed Doubleword Integers.
//
// Forms:
//
//	PADDL m128 xmm
//	PADDL xmm  xmm
func PADDL(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPADDL.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PADDQ: Add Packed Quadword Integers.
//
// Forms:
//
//	PADDQ m128 xmm
//	PADDQ xmm  xmm
func PADDQ(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPADDQ.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PADDSB: Add Packed Signed Byte Integers with Signed Saturation.
//
// Forms:
//
//	PADDSB m128 xmm
//	PADDSB xmm  xmm
func PADDSB(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPADDSB.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PADDSW: Add Packed Signed Word Integers with Signed Saturation.
//
// Forms:
//
//	PADDSW m128 xmm
//	PADDSW xmm  xmm
func PADDSW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPADDSW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PADDUSB: Add Packed Unsigned Byte Integers with Unsigned Saturation.
//
// Forms:
//
//	PADDUSB m128 xmm
//	PADDUSB xmm  xmm
func PADDUSB(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPADDUSB.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PADDUSW: Add Packed Unsigned Word Integers with Unsigned Saturation.
//
// Forms:
//
//	PADDUSW m128 xmm
//	PADDUSW xmm  xmm
func PADDUSW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPADDUSW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PADDW: Add Packed Word Integers.
//
// Forms:
//
//	PADDW m128 xmm
//	PADDW xmm  xmm
func PADDW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPADDW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PALIGNR: Packed Align Right.
//
// Forms:
//
//	PALIGNR imm8 m128 xmm
//	PALIGNR imm8 xmm  xmm
func PALIGNR(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPALIGNR.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// PAND: Packed Bitwise Logical AND.
//
// Forms:
//
//	PAND m128 xmm
//	PAND xmm  xmm
func PAND(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPAND.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PANDN: Packed Bitwise Logical AND NOT.
//
// Forms:
//
//	PANDN m128 xmm
//	PANDN xmm  xmm
func PANDN(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPANDN.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PAUSE: Spin Loop Hint.
//
// Forms:
//
//	PAUSE
func PAUSE() (*intrep.Instruction, error) {
	return build(opcPAUSE.Forms(), sffxs{}, []operand.Op{})
}

// PAVGB: Average Packed Byte Integers.
//
// Forms:
//
//	PAVGB m128 xmm
//	PAVGB xmm  xmm
func PAVGB(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPAVGB.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PAVGW: Average Packed Word Integers.
//
// Forms:
//
//	PAVGW m128 xmm
//	PAVGW xmm  xmm
func PAVGW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPAVGW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PBLENDVB: Variable Blend Packed Bytes.
//
// Forms:
//
//	PBLENDVB xmm0 m128 xmm
//	PBLENDVB xmm0 xmm  xmm
func PBLENDVB(x, mx, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcPBLENDVB.Forms(), sffxs{}, []operand.Op{x, mx, x1})
}

// PBLENDW: Blend Packed Words.
//
// Forms:
//
//	PBLENDW imm8 m128 xmm
//	PBLENDW imm8 xmm  xmm
func PBLENDW(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPBLENDW.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// PCLMULQDQ: Carry-Less Quadword Multiplication.
//
// Forms:
//
//	PCLMULQDQ imm8 m128 xmm
//	PCLMULQDQ imm8 xmm  xmm
func PCLMULQDQ(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPCLMULQDQ.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// PCMPEQB: Compare Packed Byte Data for Equality.
//
// Forms:
//
//	PCMPEQB m128 xmm
//	PCMPEQB xmm  xmm
func PCMPEQB(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPCMPEQB.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PCMPEQL: Compare Packed Doubleword Data for Equality.
//
// Forms:
//
//	PCMPEQL m128 xmm
//	PCMPEQL xmm  xmm
func PCMPEQL(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPCMPEQL.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PCMPEQQ: Compare Packed Quadword Data for Equality.
//
// Forms:
//
//	PCMPEQQ m128 xmm
//	PCMPEQQ xmm  xmm
func PCMPEQQ(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPCMPEQQ.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PCMPEQW: Compare Packed Word Data for Equality.
//
// Forms:
//
//	PCMPEQW m128 xmm
//	PCMPEQW xmm  xmm
func PCMPEQW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPCMPEQW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PCMPESTRI: Packed Compare Explicit Length Strings, Return Index.
//
// Forms:
//
//	PCMPESTRI imm8 m128 xmm
//	PCMPESTRI imm8 xmm  xmm
func PCMPESTRI(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPCMPESTRI.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// PCMPESTRM: Packed Compare Explicit Length Strings, Return Mask.
//
// Forms:
//
//	PCMPESTRM imm8 m128 xmm
//	PCMPESTRM imm8 xmm  xmm
func PCMPESTRM(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPCMPESTRM.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// PCMPGTB: Compare Packed Signed Byte Integers for Greater Than.
//
// Forms:
//
//	PCMPGTB m128 xmm
//	PCMPGTB xmm  xmm
func PCMPGTB(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPCMPGTB.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PCMPGTL: Compare Packed Signed Doubleword Integers for Greater Than.
//
// Forms:
//
//	PCMPGTL m128 xmm
//	PCMPGTL xmm  xmm
func PCMPGTL(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPCMPGTL.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PCMPGTQ: Compare Packed Data for Greater Than.
//
// Forms:
//
//	PCMPGTQ m128 xmm
//	PCMPGTQ xmm  xmm
func PCMPGTQ(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPCMPGTQ.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PCMPGTW: Compare Packed Signed Word Integers for Greater Than.
//
// Forms:
//
//	PCMPGTW m128 xmm
//	PCMPGTW xmm  xmm
func PCMPGTW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPCMPGTW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PCMPISTRI: Packed Compare Implicit Length Strings, Return Index.
//
// Forms:
//
//	PCMPISTRI imm8 m128 xmm
//	PCMPISTRI imm8 xmm  xmm
func PCMPISTRI(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPCMPISTRI.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// PCMPISTRM: Packed Compare Implicit Length Strings, Return Mask.
//
// Forms:
//
//	PCMPISTRM imm8 m128 xmm
//	PCMPISTRM imm8 xmm  xmm
func PCMPISTRM(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPCMPISTRM.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// PDEPL: Parallel Bits Deposit.
//
// Forms:
//
//	PDEPL m32 r32 r32
//	PDEPL r32 r32 r32
func PDEPL(mr, r, r1 operand.Op) (*intrep.Instruction, error) {
	return build(opcPDEPL.Forms(), sffxs{}, []operand.Op{mr, r, r1})
}

// PDEPQ: Parallel Bits Deposit.
//
// Forms:
//
//	PDEPQ m64 r64 r64
//	PDEPQ r64 r64 r64
func PDEPQ(mr, r, r1 operand.Op) (*intrep.Instruction, error) {
	return build(opcPDEPQ.Forms(), sffxs{}, []operand.Op{mr, r, r1})
}

// PEXTL: Parallel Bits Extract.
//
// Forms:
//
//	PEXTL m32 r32 r32
//	PEXTL r32 r32 r32
func PEXTL(mr, r, r1 operand.Op) (*intrep.Instruction, error) {
	return build(opcPEXTL.Forms(), sffxs{}, []operand.Op{mr, r, r1})
}

// PEXTQ: Parallel Bits Extract.
//
// Forms:
//
//	PEXTQ m64 r64 r64
//	PEXTQ r64 r64 r64
func PEXTQ(mr, r, r1 operand.Op) (*intrep.Instruction, error) {
	return build(opcPEXTQ.Forms(), sffxs{}, []operand.Op{mr, r, r1})
}

// PEXTRB: Extract Byte.
//
// Forms:
//
//	PEXTRB imm8 xmm m8
//	PEXTRB imm8 xmm r32
func PEXTRB(i, x, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcPEXTRB.Forms(), sffxs{}, []operand.Op{i, x, mr})
}

// PEXTRD: Extract Doubleword.
//
// Forms:
//
//	PEXTRD imm8 xmm m32
//	PEXTRD imm8 xmm r32
func PEXTRD(i, x, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcPEXTRD.Forms(), sffxs{}, []operand.Op{i, x, mr})
}

// PEXTRQ: Extract Quadword.
//
// Forms:
//
//	PEXTRQ imm8 xmm m64
//	PEXTRQ imm8 xmm r64
func PEXTRQ(i, x, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcPEXTRQ.Forms(), sffxs{}, []operand.Op{i, x, mr})
}

// PEXTRW: Extract Word.
//
// Forms:
//
//	PEXTRW imm8 xmm m16
//	PEXTRW imm8 xmm r32
func PEXTRW(i, x, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcPEXTRW.Forms(), sffxs{}, []operand.Op{i, x, mr})
}

// PHADDD: Packed Horizontal Add Doubleword Integer.
//
// Forms:
//
//	PHADDD m128 xmm
//	PHADDD xmm  xmm
func PHADDD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPHADDD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PHADDSW: Packed Horizontal Add Signed Word Integers with Signed Saturation.
//
// Forms:
//
//	PHADDSW m128 xmm
//	PHADDSW xmm  xmm
func PHADDSW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPHADDSW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PHADDW: Packed Horizontal Add Word Integers.
//
// Forms:
//
//	PHADDW m128 xmm
//	PHADDW xmm  xmm
func PHADDW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPHADDW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PHMINPOSUW: Packed Horizontal Minimum of Unsigned Word Integers.
//
// Forms:
//
//	PHMINPOSUW m128 xmm
//	PHMINPOSUW xmm  xmm
func PHMINPOSUW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPHMINPOSUW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PHSUBD: Packed Horizontal Subtract Doubleword Integers.
//
// Forms:
//
//	PHSUBD m128 xmm
//	PHSUBD xmm  xmm
func PHSUBD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPHSUBD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PHSUBSW: Packed Horizontal Subtract Signed Word Integers with Signed Saturation.
//
// Forms:
//
//	PHSUBSW m128 xmm
//	PHSUBSW xmm  xmm
func PHSUBSW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPHSUBSW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PHSUBW: Packed Horizontal Subtract Word Integers.
//
// Forms:
//
//	PHSUBW m128 xmm
//	PHSUBW xmm  xmm
func PHSUBW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPHSUBW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PINSRB: Insert Byte.
//
// Forms:
//
//	PINSRB imm8 m8  xmm
//	PINSRB imm8 r32 xmm
func PINSRB(i, mr, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPINSRB.Forms(), sffxs{}, []operand.Op{i, mr, x})
}

// PINSRD: Insert Doubleword.
//
// Forms:
//
//	PINSRD imm8 m32 xmm
//	PINSRD imm8 r32 xmm
func PINSRD(i, mr, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPINSRD.Forms(), sffxs{}, []operand.Op{i, mr, x})
}

// PINSRQ: Insert Quadword.
//
// Forms:
//
//	PINSRQ imm8 m64 xmm
//	PINSRQ imm8 r64 xmm
func PINSRQ(i, mr, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPINSRQ.Forms(), sffxs{}, []operand.Op{i, mr, x})
}

// PINSRW: Insert Word.
//
// Forms:
//
//	PINSRW imm8 m16 xmm
//	PINSRW imm8 r32 xmm
func PINSRW(i, mr, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPINSRW.Forms(), sffxs{}, []operand.Op{i, mr, x})
}

// PMADDUBSW: Multiply and Add Packed Signed and Unsigned Byte Integers.
//
// Forms:
//
//	PMADDUBSW m128 xmm
//	PMADDUBSW xmm  xmm
func PMADDUBSW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMADDUBSW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMADDWL: Multiply and Add Packed Signed Word Integers.
//
// Forms:
//
//	PMADDWL m128 xmm
//	PMADDWL xmm  xmm
func PMADDWL(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMADDWL.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMAXSB: Maximum of Packed Signed Byte Integers.
//
// Forms:
//
//	PMAXSB m128 xmm
//	PMAXSB xmm  xmm
func PMAXSB(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMAXSB.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMAXSD: Maximum of Packed Signed Doubleword Integers.
//
// Forms:
//
//	PMAXSD m128 xmm
//	PMAXSD xmm  xmm
func PMAXSD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMAXSD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMAXSW: Maximum of Packed Signed Word Integers.
//
// Forms:
//
//	PMAXSW m128 xmm
//	PMAXSW xmm  xmm
func PMAXSW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMAXSW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMAXUB: Maximum of Packed Unsigned Byte Integers.
//
// Forms:
//
//	PMAXUB m128 xmm
//	PMAXUB xmm  xmm
func PMAXUB(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMAXUB.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMAXUD: Maximum of Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	PMAXUD m128 xmm
//	PMAXUD xmm  xmm
func PMAXUD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMAXUD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMAXUW: Maximum of Packed Unsigned Word Integers.
//
// Forms:
//
//	PMAXUW m128 xmm
//	PMAXUW xmm  xmm
func PMAXUW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMAXUW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMINSB: Minimum of Packed Signed Byte Integers.
//
// Forms:
//
//	PMINSB m128 xmm
//	PMINSB xmm  xmm
func PMINSB(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMINSB.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMINSD: Minimum of Packed Signed Doubleword Integers.
//
// Forms:
//
//	PMINSD m128 xmm
//	PMINSD xmm  xmm
func PMINSD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMINSD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMINSW: Minimum of Packed Signed Word Integers.
//
// Forms:
//
//	PMINSW m128 xmm
//	PMINSW xmm  xmm
func PMINSW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMINSW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMINUB: Minimum of Packed Unsigned Byte Integers.
//
// Forms:
//
//	PMINUB m128 xmm
//	PMINUB xmm  xmm
func PMINUB(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMINUB.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMINUD: Minimum of Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	PMINUD m128 xmm
//	PMINUD xmm  xmm
func PMINUD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMINUD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMINUW: Minimum of Packed Unsigned Word Integers.
//
// Forms:
//
//	PMINUW m128 xmm
//	PMINUW xmm  xmm
func PMINUW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMINUW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMOVMSKB: Move Byte Mask.
//
// Forms:
//
//	PMOVMSKB xmm r32
func PMOVMSKB(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcPMOVMSKB.Forms(), sffxs{}, []operand.Op{x, r})
}

// PMOVSXBD: Move Packed Byte Integers to Doubleword Integers with Sign Extension.
//
// Forms:
//
//	PMOVSXBD m32 xmm
//	PMOVSXBD xmm xmm
func PMOVSXBD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMOVSXBD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMOVSXBQ: Move Packed Byte Integers to Quadword Integers with Sign Extension.
//
// Forms:
//
//	PMOVSXBQ m16 xmm
//	PMOVSXBQ xmm xmm
func PMOVSXBQ(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMOVSXBQ.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMOVSXBW: Move Packed Byte Integers to Word Integers with Sign Extension.
//
// Forms:
//
//	PMOVSXBW m64 xmm
//	PMOVSXBW xmm xmm
func PMOVSXBW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMOVSXBW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMOVSXDQ: Move Packed Doubleword Integers to Quadword Integers with Sign Extension.
//
// Forms:
//
//	PMOVSXDQ m64 xmm
//	PMOVSXDQ xmm xmm
func PMOVSXDQ(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMOVSXDQ.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMOVSXWD: Move Packed Word Integers to Doubleword Integers with Sign Extension.
//
// Forms:
//
//	PMOVSXWD m64 xmm
//	PMOVSXWD xmm xmm
func PMOVSXWD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMOVSXWD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMOVSXWQ: Move Packed Word Integers to Quadword Integers with Sign Extension.
//
// Forms:
//
//	PMOVSXWQ m32 xmm
//	PMOVSXWQ xmm xmm
func PMOVSXWQ(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMOVSXWQ.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMOVZXBD: Move Packed Byte Integers to Doubleword Integers with Zero Extension.
//
// Forms:
//
//	PMOVZXBD m32 xmm
//	PMOVZXBD xmm xmm
func PMOVZXBD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMOVZXBD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMOVZXBQ: Move Packed Byte Integers to Quadword Integers with Zero Extension.
//
// Forms:
//
//	PMOVZXBQ m16 xmm
//	PMOVZXBQ xmm xmm
func PMOVZXBQ(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMOVZXBQ.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMOVZXBW: Move Packed Byte Integers to Word Integers with Zero Extension.
//
// Forms:
//
//	PMOVZXBW m64 xmm
//	PMOVZXBW xmm xmm
func PMOVZXBW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMOVZXBW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMOVZXDQ: Move Packed Doubleword Integers to Quadword Integers with Zero Extension.
//
// Forms:
//
//	PMOVZXDQ m64 xmm
//	PMOVZXDQ xmm xmm
func PMOVZXDQ(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMOVZXDQ.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMOVZXWD: Move Packed Word Integers to Doubleword Integers with Zero Extension.
//
// Forms:
//
//	PMOVZXWD m64 xmm
//	PMOVZXWD xmm xmm
func PMOVZXWD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMOVZXWD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMOVZXWQ: Move Packed Word Integers to Quadword Integers with Zero Extension.
//
// Forms:
//
//	PMOVZXWQ m32 xmm
//	PMOVZXWQ xmm xmm
func PMOVZXWQ(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMOVZXWQ.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMULDQ: Multiply Packed Signed Doubleword Integers and Store Quadword Result.
//
// Forms:
//
//	PMULDQ m128 xmm
//	PMULDQ xmm  xmm
func PMULDQ(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMULDQ.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMULHRSW: Packed Multiply Signed Word Integers and Store High Result with Round and Scale.
//
// Forms:
//
//	PMULHRSW m128 xmm
//	PMULHRSW xmm  xmm
func PMULHRSW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMULHRSW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMULHUW: Multiply Packed Unsigned Word Integers and Store High Result.
//
// Forms:
//
//	PMULHUW m128 xmm
//	PMULHUW xmm  xmm
func PMULHUW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMULHUW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMULHW: Multiply Packed Signed Word Integers and Store High Result.
//
// Forms:
//
//	PMULHW m128 xmm
//	PMULHW xmm  xmm
func PMULHW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMULHW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMULLD: Multiply Packed Signed Doubleword Integers and Store Low Result.
//
// Forms:
//
//	PMULLD m128 xmm
//	PMULLD xmm  xmm
func PMULLD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMULLD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMULLW: Multiply Packed Signed Word Integers and Store Low Result.
//
// Forms:
//
//	PMULLW m128 xmm
//	PMULLW xmm  xmm
func PMULLW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMULLW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PMULULQ: Multiply Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	PMULULQ m128 xmm
//	PMULULQ xmm  xmm
func PMULULQ(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPMULULQ.Forms(), sffxs{}, []operand.Op{mx, x})
}

// POPCNTL: Count of Number of Bits Set to 1.
//
// Forms:
//
//	POPCNTL m32 r32
//	POPCNTL r32 r32
func POPCNTL(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcPOPCNTL.Forms(), sffxs{}, []operand.Op{mr, r})
}

// POPCNTQ: Count of Number of Bits Set to 1.
//
// Forms:
//
//	POPCNTQ m64 r64
//	POPCNTQ r64 r64
func POPCNTQ(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcPOPCNTQ.Forms(), sffxs{}, []operand.Op{mr, r})
}

// POPCNTW: Count of Number of Bits Set to 1.
//
// Forms:
//
//	POPCNTW m16 r16
//	POPCNTW r16 r16
func POPCNTW(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcPOPCNTW.Forms(), sffxs{}, []operand.Op{mr, r})
}

// POPQ: Pop a Value from the Stack.
//
// Forms:
//
//	POPQ m64
//	POPQ r64
func POPQ(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcPOPQ.Forms(), sffxs{}, []operand.Op{mr})
}

// POPW: Pop a Value from the Stack.
//
// Forms:
//
//	POPW m16
//	POPW r16
func POPW(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcPOPW.Forms(), sffxs{}, []operand.Op{mr})
}

// POR: Packed Bitwise Logical OR.
//
// Forms:
//
//	POR m128 xmm
//	POR xmm  xmm
func POR(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPOR.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PREFETCHNTA: Prefetch Data Into Caches using NTA Hint.
//
// Forms:
//
//	PREFETCHNTA m8
func PREFETCHNTA(m operand.Op) (*intrep.Instruction, error) {
	return build(opcPREFETCHNTA.Forms(), sffxs{}, []operand.Op{m})
}

// PREFETCHT0: Prefetch Data Into Caches using T0 Hint.
//
// Forms:
//
//	PREFETCHT0 m8
func PREFETCHT0(m operand.Op) (*intrep.Instruction, error) {
	return build(opcPREFETCHT0.Forms(), sffxs{}, []operand.Op{m})
}

// PREFETCHT1: Prefetch Data Into Caches using T1 Hint.
//
// Forms:
//
//	PREFETCHT1 m8
func PREFETCHT1(m operand.Op) (*intrep.Instruction, error) {
	return build(opcPREFETCHT1.Forms(), sffxs{}, []operand.Op{m})
}

// PREFETCHT2: Prefetch Data Into Caches using T2 Hint.
//
// Forms:
//
//	PREFETCHT2 m8
func PREFETCHT2(m operand.Op) (*intrep.Instruction, error) {
	return build(opcPREFETCHT2.Forms(), sffxs{}, []operand.Op{m})
}

// PSADBW: Compute Sum of Absolute Differences.
//
// Forms:
//
//	PSADBW m128 xmm
//	PSADBW xmm  xmm
func PSADBW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSADBW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PSHUFB: Packed Shuffle Bytes.
//
// Forms:
//
//	PSHUFB m128 xmm
//	PSHUFB xmm  xmm
func PSHUFB(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSHUFB.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PSHUFD: Shuffle Packed Doublewords.
//
// Forms:
//
//	PSHUFD imm8 m128 xmm
//	PSHUFD imm8 xmm  xmm
func PSHUFD(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSHUFD.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// PSHUFHW: Shuffle Packed High Words.
//
// Forms:
//
//	PSHUFHW imm8 m128 xmm
//	PSHUFHW imm8 xmm  xmm
func PSHUFHW(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSHUFHW.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// PSHUFL: Shuffle Packed Doublewords.
//
// Forms:
//
//	PSHUFL imm8 m128 xmm
//	PSHUFL imm8 xmm  xmm
func PSHUFL(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSHUFL.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// PSHUFLW: Shuffle Packed Low Words.
//
// Forms:
//
//	PSHUFLW imm8 m128 xmm
//	PSHUFLW imm8 xmm  xmm
func PSHUFLW(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSHUFLW.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// PSIGNB: Packed Sign of Byte Integers.
//
// Forms:
//
//	PSIGNB m128 xmm
//	PSIGNB xmm  xmm
func PSIGNB(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSIGNB.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PSIGND: Packed Sign of Doubleword Integers.
//
// Forms:
//
//	PSIGND m128 xmm
//	PSIGND xmm  xmm
func PSIGND(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSIGND.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PSIGNW: Packed Sign of Word Integers.
//
// Forms:
//
//	PSIGNW m128 xmm
//	PSIGNW xmm  xmm
func PSIGNW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSIGNW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PSLLDQ: Shift Packed Double Quadword Left Logical.
//
// Forms:
//
//	PSLLDQ imm8 xmm
func PSLLDQ(i, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSLLDQ.Forms(), sffxs{}, []operand.Op{i, x})
}

// PSLLL: Shift Packed Doubleword Data Left Logical.
//
// Forms:
//
//	PSLLL imm8 xmm
//	PSLLL m128 xmm
//	PSLLL xmm  xmm
func PSLLL(imx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSLLL.Forms(), sffxs{}, []operand.Op{imx, x})
}

// PSLLO: Shift Packed Double Quadword Left Logical.
//
// Forms:
//
//	PSLLO imm8 xmm
func PSLLO(i, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSLLO.Forms(), sffxs{}, []operand.Op{i, x})
}

// PSLLQ: Shift Packed Quadword Data Left Logical.
//
// Forms:
//
//	PSLLQ imm8 xmm
//	PSLLQ m128 xmm
//	PSLLQ xmm  xmm
func PSLLQ(imx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSLLQ.Forms(), sffxs{}, []operand.Op{imx, x})
}

// PSLLW: Shift Packed Word Data Left Logical.
//
// Forms:
//
//	PSLLW imm8 xmm
//	PSLLW m128 xmm
//	PSLLW xmm  xmm
func PSLLW(imx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSLLW.Forms(), sffxs{}, []operand.Op{imx, x})
}

// PSRAL: Shift Packed Doubleword Data Right Arithmetic.
//
// Forms:
//
//	PSRAL imm8 xmm
//	PSRAL m128 xmm
//	PSRAL xmm  xmm
func PSRAL(imx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSRAL.Forms(), sffxs{}, []operand.Op{imx, x})
}

// PSRAW: Shift Packed Word Data Right Arithmetic.
//
// Forms:
//
//	PSRAW imm8 xmm
//	PSRAW m128 xmm
//	PSRAW xmm  xmm
func PSRAW(imx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSRAW.Forms(), sffxs{}, []operand.Op{imx, x})
}

// PSRLDQ: Shift Packed Double Quadword Right Logical.
//
// Forms:
//
//	PSRLDQ imm8 xmm
func PSRLDQ(i, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSRLDQ.Forms(), sffxs{}, []operand.Op{i, x})
}

// PSRLL: Shift Packed Doubleword Data Right Logical.
//
// Forms:
//
//	PSRLL imm8 xmm
//	PSRLL m128 xmm
//	PSRLL xmm  xmm
func PSRLL(imx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSRLL.Forms(), sffxs{}, []operand.Op{imx, x})
}

// PSRLO: Shift Packed Double Quadword Right Logical.
//
// Forms:
//
//	PSRLO imm8 xmm
func PSRLO(i, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSRLO.Forms(), sffxs{}, []operand.Op{i, x})
}

// PSRLQ: Shift Packed Quadword Data Right Logical.
//
// Forms:
//
//	PSRLQ imm8 xmm
//	PSRLQ m128 xmm
//	PSRLQ xmm  xmm
func PSRLQ(imx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSRLQ.Forms(), sffxs{}, []operand.Op{imx, x})
}

// PSRLW: Shift Packed Word Data Right Logical.
//
// Forms:
//
//	PSRLW imm8 xmm
//	PSRLW m128 xmm
//	PSRLW xmm  xmm
func PSRLW(imx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSRLW.Forms(), sffxs{}, []operand.Op{imx, x})
}

// PSUBB: Subtract Packed Byte Integers.
//
// Forms:
//
//	PSUBB m128 xmm
//	PSUBB xmm  xmm
func PSUBB(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSUBB.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PSUBL: Subtract Packed Doubleword Integers.
//
// Forms:
//
//	PSUBL m128 xmm
//	PSUBL xmm  xmm
func PSUBL(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSUBL.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PSUBQ: Subtract Packed Quadword Integers.
//
// Forms:
//
//	PSUBQ m128 xmm
//	PSUBQ xmm  xmm
func PSUBQ(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSUBQ.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PSUBSB: Subtract Packed Signed Byte Integers with Signed Saturation.
//
// Forms:
//
//	PSUBSB m128 xmm
//	PSUBSB xmm  xmm
func PSUBSB(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSUBSB.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PSUBSW: Subtract Packed Signed Word Integers with Signed Saturation.
//
// Forms:
//
//	PSUBSW m128 xmm
//	PSUBSW xmm  xmm
func PSUBSW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSUBSW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PSUBUSB: Subtract Packed Unsigned Byte Integers with Unsigned Saturation.
//
// Forms:
//
//	PSUBUSB m128 xmm
//	PSUBUSB xmm  xmm
func PSUBUSB(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSUBUSB.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PSUBUSW: Subtract Packed Unsigned Word Integers with Unsigned Saturation.
//
// Forms:
//
//	PSUBUSW m128 xmm
//	PSUBUSW xmm  xmm
func PSUBUSW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSUBUSW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PSUBW: Subtract Packed Word Integers.
//
// Forms:
//
//	PSUBW m128 xmm
//	PSUBW xmm  xmm
func PSUBW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPSUBW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PTEST: Packed Logical Compare.
//
// Forms:
//
//	PTEST m128 xmm
//	PTEST xmm  xmm
func PTEST(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPTEST.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PUNPCKHBW: Unpack and Interleave High-Order Bytes into Words.
//
// Forms:
//
//	PUNPCKHBW m128 xmm
//	PUNPCKHBW xmm  xmm
func PUNPCKHBW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPUNPCKHBW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PUNPCKHLQ: Unpack and Interleave High-Order Doublewords into Quadwords.
//
// Forms:
//
//	PUNPCKHLQ m128 xmm
//	PUNPCKHLQ xmm  xmm
func PUNPCKHLQ(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPUNPCKHLQ.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PUNPCKHQDQ: Unpack and Interleave High-Order Quadwords into Double Quadwords.
//
// Forms:
//
//	PUNPCKHQDQ m128 xmm
//	PUNPCKHQDQ xmm  xmm
func PUNPCKHQDQ(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPUNPCKHQDQ.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PUNPCKHWL: Unpack and Interleave High-Order Words into Doublewords.
//
// Forms:
//
//	PUNPCKHWL m128 xmm
//	PUNPCKHWL xmm  xmm
func PUNPCKHWL(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPUNPCKHWL.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PUNPCKLBW: Unpack and Interleave Low-Order Bytes into Words.
//
// Forms:
//
//	PUNPCKLBW m128 xmm
//	PUNPCKLBW xmm  xmm
func PUNPCKLBW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPUNPCKLBW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PUNPCKLLQ: Unpack and Interleave Low-Order Doublewords into Quadwords.
//
// Forms:
//
//	PUNPCKLLQ m128 xmm
//	PUNPCKLLQ xmm  xmm
func PUNPCKLLQ(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPUNPCKLLQ.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PUNPCKLQDQ: Unpack and Interleave Low-Order Quadwords into Double Quadwords.
//
// Forms:
//
//	PUNPCKLQDQ m128 xmm
//	PUNPCKLQDQ xmm  xmm
func PUNPCKLQDQ(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPUNPCKLQDQ.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PUNPCKLWL: Unpack and Interleave Low-Order Words into Doublewords.
//
// Forms:
//
//	PUNPCKLWL m128 xmm
//	PUNPCKLWL xmm  xmm
func PUNPCKLWL(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPUNPCKLWL.Forms(), sffxs{}, []operand.Op{mx, x})
}

// PUSHQ: Push Value Onto the Stack.
//
// Forms:
//
//	PUSHQ imm32
//	PUSHQ imm8
//	PUSHQ m64
//	PUSHQ r64
func PUSHQ(imr operand.Op) (*intrep.Instruction, error) {
	return build(opcPUSHQ.Forms(), sffxs{}, []operand.Op{imr})
}

// PUSHW: Push Value Onto the Stack.
//
// Forms:
//
//	PUSHW m16
//	PUSHW r16
func PUSHW(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcPUSHW.Forms(), sffxs{}, []operand.Op{mr})
}

// PXOR: Packed Bitwise Logical Exclusive OR.
//
// Forms:
//
//	PXOR m128 xmm
//	PXOR xmm  xmm
func PXOR(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcPXOR.Forms(), sffxs{}, []operand.Op{mx, x})
}

// RCLB: Rotate Left through Carry Flag.
//
// Forms:
//
//	RCLB 1    m8
//	RCLB 1    r8
//	RCLB cl   m8
//	RCLB cl   r8
//	RCLB imm8 m8
//	RCLB imm8 r8
func RCLB(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcRCLB.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// RCLL: Rotate Left through Carry Flag.
//
// Forms:
//
//	RCLL 1    m32
//	RCLL 1    r32
//	RCLL cl   m32
//	RCLL cl   r32
//	RCLL imm8 m32
//	RCLL imm8 r32
func RCLL(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcRCLL.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// RCLQ: Rotate Left through Carry Flag.
//
// Forms:
//
//	RCLQ 1    m64
//	RCLQ 1    r64
//	RCLQ cl   m64
//	RCLQ cl   r64
//	RCLQ imm8 m64
//	RCLQ imm8 r64
func RCLQ(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcRCLQ.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// RCLW: Rotate Left through Carry Flag.
//
// Forms:
//
//	RCLW 1    m16
//	RCLW 1    r16
//	RCLW cl   m16
//	RCLW cl   r16
//	RCLW imm8 m16
//	RCLW imm8 r16
func RCLW(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcRCLW.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// RCPPS: Compute Approximate Reciprocals of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	RCPPS m128 xmm
//	RCPPS xmm  xmm
func RCPPS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcRCPPS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// RCPSS: Compute Approximate Reciprocal of Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	RCPSS m32 xmm
//	RCPSS xmm xmm
func RCPSS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcRCPSS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// RCRB: Rotate Right through Carry Flag.
//
// Forms:
//
//	RCRB 1    m8
//	RCRB 1    r8
//	RCRB cl   m8
//	RCRB cl   r8
//	RCRB imm8 m8
//	RCRB imm8 r8
func RCRB(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcRCRB.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// RCRL: Rotate Right through Carry Flag.
//
// Forms:
//
//	RCRL 1    m32
//	RCRL 1    r32
//	RCRL cl   m32
//	RCRL cl   r32
//	RCRL imm8 m32
//	RCRL imm8 r32
func RCRL(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcRCRL.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// RCRQ: Rotate Right through Carry Flag.
//
// Forms:
//
//	RCRQ 1    m64
//	RCRQ 1    r64
//	RCRQ cl   m64
//	RCRQ cl   r64
//	RCRQ imm8 m64
//	RCRQ imm8 r64
func RCRQ(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcRCRQ.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// RCRW: Rotate Right through Carry Flag.
//
// Forms:
//
//	RCRW 1    m16
//	RCRW 1    r16
//	RCRW cl   m16
//	RCRW cl   r16
//	RCRW imm8 m16
//	RCRW imm8 r16
func RCRW(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcRCRW.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// RDRANDL: Read Random Number.
//
// Forms:
//
//	RDRANDL r16
//	RDRANDL r32
//	RDRANDL r64
func RDRANDL(r operand.Op) (*intrep.Instruction, error) {
	return build(opcRDRANDL.Forms(), sffxs{}, []operand.Op{r})
}

// RDSEEDL: Read Random SEED.
//
// Forms:
//
//	RDSEEDL r16
//	RDSEEDL r32
//	RDSEEDL r64
func RDSEEDL(r operand.Op) (*intrep.Instruction, error) {
	return build(opcRDSEEDL.Forms(), sffxs{}, []operand.Op{r})
}

// RDTSC: Read Time-Stamp Counter.
//
// Forms:
//
//	RDTSC
func RDTSC() (*intrep.Instruction, error) {
	return build(opcRDTSC.Forms(), sffxs{}, []operand.Op{})
}

// RDTSCP: Read Time-Stamp Counter and Processor ID.
//
// Forms:
//
//	RDTSCP
func RDTSCP() (*intrep.Instruction, error) {
	return build(opcRDTSCP.Forms(), sffxs{}, []operand.Op{})
}

// RET: Return from Procedure.
//
// Forms:
//
//	RET
func RET() (*intrep.Instruction, error) {
	return build(opcRET.Forms(), sffxs{}, []operand.Op{})
}

// RETFL: Return from Procedure.
//
// Forms:
//
//	RETFL imm16
func RETFL(i operand.Op) (*intrep.Instruction, error) {
	return build(opcRETFL.Forms(), sffxs{}, []operand.Op{i})
}

// RETFQ: Return from Procedure.
//
// Forms:
//
//	RETFQ imm16
func RETFQ(i operand.Op) (*intrep.Instruction, error) {
	return build(opcRETFQ.Forms(), sffxs{}, []operand.Op{i})
}

// RETFW: Return from Procedure.
//
// Forms:
//
//	RETFW imm16
func RETFW(i operand.Op) (*intrep.Instruction, error) {
	return build(opcRETFW.Forms(), sffxs{}, []operand.Op{i})
}

// ROLB: Rotate Left.
//
// Forms:
//
//	ROLB 1    m8
//	ROLB 1    r8
//	ROLB cl   m8
//	ROLB cl   r8
//	ROLB imm8 m8
//	ROLB imm8 r8
func ROLB(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcROLB.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// ROLL: Rotate Left.
//
// Forms:
//
//	ROLL 1    m32
//	ROLL 1    r32
//	ROLL cl   m32
//	ROLL cl   r32
//	ROLL imm8 m32
//	ROLL imm8 r32
func ROLL(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcROLL.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// ROLQ: Rotate Left.
//
// Forms:
//
//	ROLQ 1    m64
//	ROLQ 1    r64
//	ROLQ cl   m64
//	ROLQ cl   r64
//	ROLQ imm8 m64
//	ROLQ imm8 r64
func ROLQ(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcROLQ.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// ROLW: Rotate Left.
//
// Forms:
//
//	ROLW 1    m16
//	ROLW 1    r16
//	ROLW cl   m16
//	ROLW cl   r16
//	ROLW imm8 m16
//	ROLW imm8 r16
func ROLW(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcROLW.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// RORB: Rotate Right.
//
// Forms:
//
//	RORB 1    m8
//	RORB 1    r8
//	RORB cl   m8
//	RORB cl   r8
//	RORB imm8 m8
//	RORB imm8 r8
func RORB(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcRORB.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// RORL: Rotate Right.
//
// Forms:
//
//	RORL 1    m32
//	RORL 1    r32
//	RORL cl   m32
//	RORL cl   r32
//	RORL imm8 m32
//	RORL imm8 r32
func RORL(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcRORL.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// RORQ: Rotate Right.
//
// Forms:
//
//	RORQ 1    m64
//	RORQ 1    r64
//	RORQ cl   m64
//	RORQ cl   r64
//	RORQ imm8 m64
//	RORQ imm8 r64
func RORQ(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcRORQ.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// RORW: Rotate Right.
//
// Forms:
//
//	RORW 1    m16
//	RORW 1    r16
//	RORW cl   m16
//	RORW cl   r16
//	RORW imm8 m16
//	RORW imm8 r16
func RORW(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcRORW.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// RORXL: Rotate Right Logical Without Affecting Flags.
//
// Forms:
//
//	RORXL imm8 m32 r32
//	RORXL imm8 r32 r32
func RORXL(i, mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcRORXL.Forms(), sffxs{}, []operand.Op{i, mr, r})
}

// RORXQ: Rotate Right Logical Without Affecting Flags.
//
// Forms:
//
//	RORXQ imm8 m64 r64
//	RORXQ imm8 r64 r64
func RORXQ(i, mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcRORXQ.Forms(), sffxs{}, []operand.Op{i, mr, r})
}

// ROUNDPD: Round Packed Double Precision Floating-Point Values.
//
// Forms:
//
//	ROUNDPD imm8 m128 xmm
//	ROUNDPD imm8 xmm  xmm
func ROUNDPD(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcROUNDPD.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// ROUNDPS: Round Packed Single Precision Floating-Point Values.
//
// Forms:
//
//	ROUNDPS imm8 m128 xmm
//	ROUNDPS imm8 xmm  xmm
func ROUNDPS(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcROUNDPS.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// ROUNDSD: Round Scalar Double Precision Floating-Point Values.
//
// Forms:
//
//	ROUNDSD imm8 m64 xmm
//	ROUNDSD imm8 xmm xmm
func ROUNDSD(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcROUNDSD.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// ROUNDSS: Round Scalar Single Precision Floating-Point Values.
//
// Forms:
//
//	ROUNDSS imm8 m32 xmm
//	ROUNDSS imm8 xmm xmm
func ROUNDSS(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcROUNDSS.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// RSQRTPS: Compute Reciprocals of Square Roots of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	RSQRTPS m128 xmm
//	RSQRTPS xmm  xmm
func RSQRTPS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcRSQRTPS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// RSQRTSS: Compute Reciprocal of Square Root of Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	RSQRTSS m32 xmm
//	RSQRTSS xmm xmm
func RSQRTSS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcRSQRTSS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// SALB: Arithmetic Shift Left.
//
// Forms:
//
//	SALB 1    m8
//	SALB 1    r8
//	SALB cl   m8
//	SALB cl   r8
//	SALB imm8 m8
//	SALB imm8 r8
func SALB(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSALB.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// SALL: Arithmetic Shift Left.
//
// Forms:
//
//	SALL 1    m32
//	SALL 1    r32
//	SALL cl   m32
//	SALL cl   r32
//	SALL imm8 m32
//	SALL imm8 r32
func SALL(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSALL.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// SALQ: Arithmetic Shift Left.
//
// Forms:
//
//	SALQ 1    m64
//	SALQ 1    r64
//	SALQ cl   m64
//	SALQ cl   r64
//	SALQ imm8 m64
//	SALQ imm8 r64
func SALQ(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSALQ.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// SALW: Arithmetic Shift Left.
//
// Forms:
//
//	SALW 1    m16
//	SALW 1    r16
//	SALW cl   m16
//	SALW cl   r16
//	SALW imm8 m16
//	SALW imm8 r16
func SALW(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSALW.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// SARB: Arithmetic Shift Right.
//
// Forms:
//
//	SARB 1    m8
//	SARB 1    r8
//	SARB cl   m8
//	SARB cl   r8
//	SARB imm8 m8
//	SARB imm8 r8
func SARB(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSARB.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// SARL: Arithmetic Shift Right.
//
// Forms:
//
//	SARL 1    m32
//	SARL 1    r32
//	SARL cl   m32
//	SARL cl   r32
//	SARL imm8 m32
//	SARL imm8 r32
func SARL(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSARL.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// SARQ: Arithmetic Shift Right.
//
// Forms:
//
//	SARQ 1    m64
//	SARQ 1    r64
//	SARQ cl   m64
//	SARQ cl   r64
//	SARQ imm8 m64
//	SARQ imm8 r64
func SARQ(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSARQ.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// SARW: Arithmetic Shift Right.
//
// Forms:
//
//	SARW 1    m16
//	SARW 1    r16
//	SARW cl   m16
//	SARW cl   r16
//	SARW imm8 m16
//	SARW imm8 r16
func SARW(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSARW.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// SARXL: Arithmetic Shift Right Without Affecting Flags.
//
// Forms:
//
//	SARXL r32 m32 r32
//	SARXL r32 r32 r32
func SARXL(r, mr, r1 operand.Op) (*intrep.Instruction, error) {
	return build(opcSARXL.Forms(), sffxs{}, []operand.Op{r, mr, r1})
}

// SARXQ: Arithmetic Shift Right Without Affecting Flags.
//
// Forms:
//
//	SARXQ r64 m64 r64
//	SARXQ r64 r64 r64
func SARXQ(r, mr, r1 operand.Op) (*intrep.Instruction, error) {
	return build(opcSARXQ.Forms(), sffxs{}, []operand.Op{r, mr, r1})
}

// SBBB: Subtract with Borrow.
//
// Forms:
//
//	SBBB imm8 al
//	SBBB imm8 m8
//	SBBB imm8 r8
//	SBBB m8   r8
//	SBBB r8   m8
//	SBBB r8   r8
func SBBB(imr, amr operand.Op) (*intrep.Instruction, error) {
	return build(opcSBBB.Forms(), sffxs{}, []operand.Op{imr, amr})
}

// SBBL: Subtract with Borrow.
//
// Forms:
//
//	SBBL imm32 eax
//	SBBL imm32 m32
//	SBBL imm32 r32
//	SBBL imm8  m32
//	SBBL imm8  r32
//	SBBL m32   r32
//	SBBL r32   m32
//	SBBL r32   r32
func SBBL(imr, emr operand.Op) (*intrep.Instruction, error) {
	return build(opcSBBL.Forms(), sffxs{}, []operand.Op{imr, emr})
}

// SBBQ: Subtract with Borrow.
//
// Forms:
//
//	SBBQ imm32 m64
//	SBBQ imm32 r64
//	SBBQ imm32 rax
//	SBBQ imm8  m64
//	SBBQ imm8  r64
//	SBBQ m64   r64
//	SBBQ r64   m64
//	SBBQ r64   r64
func SBBQ(imr, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSBBQ.Forms(), sffxs{}, []operand.Op{imr, mr})
}

// SBBW: Subtract with Borrow.
//
// Forms:
//
//	SBBW imm16 ax
//	SBBW imm16 m16
//	SBBW imm16 r16
//	SBBW imm8  m16
//	SBBW imm8  r16
//	SBBW m16   r16
//	SBBW r16   m16
//	SBBW r16   r16
func SBBW(imr, amr operand.Op) (*intrep.Instruction, error) {
	return build(opcSBBW.Forms(), sffxs{}, []operand.Op{imr, amr})
}

// SETCC: Set byte if above or equal (CF == 0).
//
// Forms:
//
//	SETCC m8
//	SETCC r8
func SETCC(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSETCC.Forms(), sffxs{}, []operand.Op{mr})
}

// SETCS: Set byte if below (CF == 1).
//
// Forms:
//
//	SETCS m8
//	SETCS r8
func SETCS(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSETCS.Forms(), sffxs{}, []operand.Op{mr})
}

// SETEQ: Set byte if equal (ZF == 1).
//
// Forms:
//
//	SETEQ m8
//	SETEQ r8
func SETEQ(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSETEQ.Forms(), sffxs{}, []operand.Op{mr})
}

// SETGE: Set byte if greater or equal (SF == OF).
//
// Forms:
//
//	SETGE m8
//	SETGE r8
func SETGE(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSETGE.Forms(), sffxs{}, []operand.Op{mr})
}

// SETGT: Set byte if greater (ZF == 0 and SF == OF).
//
// Forms:
//
//	SETGT m8
//	SETGT r8
func SETGT(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSETGT.Forms(), sffxs{}, []operand.Op{mr})
}

// SETHI: Set byte if above (CF == 0 and ZF == 0).
//
// Forms:
//
//	SETHI m8
//	SETHI r8
func SETHI(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSETHI.Forms(), sffxs{}, []operand.Op{mr})
}

// SETLE: Set byte if less or equal (ZF == 1 or SF != OF).
//
// Forms:
//
//	SETLE m8
//	SETLE r8
func SETLE(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSETLE.Forms(), sffxs{}, []operand.Op{mr})
}

// SETLS: Set byte if below or equal (CF == 1 or ZF == 1).
//
// Forms:
//
//	SETLS m8
//	SETLS r8
func SETLS(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSETLS.Forms(), sffxs{}, []operand.Op{mr})
}

// SETLT: Set byte if less (SF != OF).
//
// Forms:
//
//	SETLT m8
//	SETLT r8
func SETLT(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSETLT.Forms(), sffxs{}, []operand.Op{mr})
}

// SETMI: Set byte if sign (SF == 1).
//
// Forms:
//
//	SETMI m8
//	SETMI r8
func SETMI(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSETMI.Forms(), sffxs{}, []operand.Op{mr})
}

// SETNE: Set byte if not equal (ZF == 0).
//
// Forms:
//
//	SETNE m8
//	SETNE r8
func SETNE(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSETNE.Forms(), sffxs{}, []operand.Op{mr})
}

// SETOC: Set byte if not overflow (OF == 0).
//
// Forms:
//
//	SETOC m8
//	SETOC r8
func SETOC(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSETOC.Forms(), sffxs{}, []operand.Op{mr})
}

// SETOS: Set byte if overflow (OF == 1).
//
// Forms:
//
//	SETOS m8
//	SETOS r8
func SETOS(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSETOS.Forms(), sffxs{}, []operand.Op{mr})
}

// SETPC: Set byte if not parity (PF == 0).
//
// Forms:
//
//	SETPC m8
//	SETPC r8
func SETPC(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSETPC.Forms(), sffxs{}, []operand.Op{mr})
}

// SETPL: Set byte if not sign (SF == 0).
//
// Forms:
//
//	SETPL m8
//	SETPL r8
func SETPL(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSETPL.Forms(), sffxs{}, []operand.Op{mr})
}

// SETPS: Set byte if parity (PF == 1).
//
// Forms:
//
//	SETPS m8
//	SETPS r8
func SETPS(mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSETPS.Forms(), sffxs{}, []operand.Op{mr})
}

// SFENCE: Store Fence.
//
// Forms:
//
//	SFENCE
func SFENCE() (*intrep.Instruction, error) {
	return build(opcSFENCE.Forms(), sffxs{}, []operand.Op{})
}

// SHA1MSG1: Perform an Intermediate Calculation for the Next Four SHA1 Message Doublewords.
//
// Forms:
//
//	SHA1MSG1 m128 xmm
//	SHA1MSG1 xmm  xmm
func SHA1MSG1(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcSHA1MSG1.Forms(), sffxs{}, []operand.Op{mx, x})
}

// SHA1MSG2: Perform a Final Calculation for the Next Four SHA1 Message Doublewords.
//
// Forms:
//
//	SHA1MSG2 m128 xmm
//	SHA1MSG2 xmm  xmm
func SHA1MSG2(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcSHA1MSG2.Forms(), sffxs{}, []operand.Op{mx, x})
}

// SHA1NEXTE: Calculate SHA1 State Variable E after Four Rounds.
//
// Forms:
//
//	SHA1NEXTE m128 xmm
//	SHA1NEXTE xmm  xmm
func SHA1NEXTE(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcSHA1NEXTE.Forms(), sffxs{}, []operand.Op{mx, x})
}

// SHA1RNDS4: Perform Four Rounds of SHA1 Operation.
//
// Forms:
//
//	SHA1RNDS4 imm2u m128 xmm
//	SHA1RNDS4 imm2u xmm  xmm
func SHA1RNDS4(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcSHA1RNDS4.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// SHA256MSG1: Perform an Intermediate Calculation for the Next Four SHA256 Message Doublewords.
//
// Forms:
//
//	SHA256MSG1 m128 xmm
//	SHA256MSG1 xmm  xmm
func SHA256MSG1(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcSHA256MSG1.Forms(), sffxs{}, []operand.Op{mx, x})
}

// SHA256MSG2: Perform a Final Calculation for the Next Four SHA256 Message Doublewords.
//
// Forms:
//
//	SHA256MSG2 m128 xmm
//	SHA256MSG2 xmm  xmm
func SHA256MSG2(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcSHA256MSG2.Forms(), sffxs{}, []operand.Op{mx, x})
}

// SHA256RNDS2: Perform Two Rounds of SHA256 Operation.
//
// Forms:
//
//	SHA256RNDS2 xmm0 m128 xmm
//	SHA256RNDS2 xmm0 xmm  xmm
func SHA256RNDS2(x, mx, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcSHA256RNDS2.Forms(), sffxs{}, []operand.Op{x, mx, x1})
}

// SHLB: Logical Shift Left.
//
// Forms:
//
//	SHLB 1    m8
//	SHLB 1    r8
//	SHLB cl   m8
//	SHLB cl   r8
//	SHLB imm8 m8
//	SHLB imm8 r8
func SHLB(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSHLB.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// SHLL: Logical Shift Left.
//
// Forms:
//
//	SHLL 1    m32
//	SHLL 1    r32
//	SHLL cl   m32
//	SHLL cl   r32
//	SHLL cl   r32 m32
//	SHLL cl   r32 r32
//	SHLL imm8 m32
//	SHLL imm8 r32
//	SHLL imm8 r32 m32
//	SHLL imm8 r32 r32
func SHLL(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcSHLL.Forms(), sffxs{}, ops)
}

// SHLQ: Logical Shift Left.
//
// Forms:
//
//	SHLQ 1    m64
//	SHLQ 1    r64
//	SHLQ cl   m64
//	SHLQ cl   r64
//	SHLQ cl   r64 m64
//	SHLQ cl   r64 r64
//	SHLQ imm8 m64
//	SHLQ imm8 r64
//	SHLQ imm8 r64 m64
//	SHLQ imm8 r64 r64
func SHLQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcSHLQ.Forms(), sffxs{}, ops)
}

// SHLW: Logical Shift Left.
//
// Forms:
//
//	SHLW 1    m16
//	SHLW 1    r16
//	SHLW cl   m16
//	SHLW cl   r16
//	SHLW cl   r16 m16
//	SHLW cl   r16 r16
//	SHLW imm8 m16
//	SHLW imm8 r16
//	SHLW imm8 r16 m16
//	SHLW imm8 r16 r16
func SHLW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcSHLW.Forms(), sffxs{}, ops)
}

// SHLXL: Logical Shift Left Without Affecting Flags.
//
// Forms:
//
//	SHLXL r32 m32 r32
//	SHLXL r32 r32 r32
func SHLXL(r, mr, r1 operand.Op) (*intrep.Instruction, error) {
	return build(opcSHLXL.Forms(), sffxs{}, []operand.Op{r, mr, r1})
}

// SHLXQ: Logical Shift Left Without Affecting Flags.
//
// Forms:
//
//	SHLXQ r64 m64 r64
//	SHLXQ r64 r64 r64
func SHLXQ(r, mr, r1 operand.Op) (*intrep.Instruction, error) {
	return build(opcSHLXQ.Forms(), sffxs{}, []operand.Op{r, mr, r1})
}

// SHRB: Logical Shift Right.
//
// Forms:
//
//	SHRB 1    m8
//	SHRB 1    r8
//	SHRB cl   m8
//	SHRB cl   r8
//	SHRB imm8 m8
//	SHRB imm8 r8
func SHRB(ci, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSHRB.Forms(), sffxs{}, []operand.Op{ci, mr})
}

// SHRL: Logical Shift Right.
//
// Forms:
//
//	SHRL 1    m32
//	SHRL 1    r32
//	SHRL cl   m32
//	SHRL cl   r32
//	SHRL cl   r32 m32
//	SHRL cl   r32 r32
//	SHRL imm8 m32
//	SHRL imm8 r32
//	SHRL imm8 r32 m32
//	SHRL imm8 r32 r32
func SHRL(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcSHRL.Forms(), sffxs{}, ops)
}

// SHRQ: Logical Shift Right.
//
// Forms:
//
//	SHRQ 1    m64
//	SHRQ 1    r64
//	SHRQ cl   m64
//	SHRQ cl   r64
//	SHRQ cl   r64 m64
//	SHRQ cl   r64 r64
//	SHRQ imm8 m64
//	SHRQ imm8 r64
//	SHRQ imm8 r64 m64
//	SHRQ imm8 r64 r64
func SHRQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcSHRQ.Forms(), sffxs{}, ops)
}

// SHRW: Logical Shift Right.
//
// Forms:
//
//	SHRW 1    m16
//	SHRW 1    r16
//	SHRW cl   m16
//	SHRW cl   r16
//	SHRW cl   r16 m16
//	SHRW cl   r16 r16
//	SHRW imm8 m16
//	SHRW imm8 r16
//	SHRW imm8 r16 m16
//	SHRW imm8 r16 r16
func SHRW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcSHRW.Forms(), sffxs{}, ops)
}

// SHRXL: Logical Shift Right Without Affecting Flags.
//
// Forms:
//
//	SHRXL r32 m32 r32
//	SHRXL r32 r32 r32
func SHRXL(r, mr, r1 operand.Op) (*intrep.Instruction, error) {
	return build(opcSHRXL.Forms(), sffxs{}, []operand.Op{r, mr, r1})
}

// SHRXQ: Logical Shift Right Without Affecting Flags.
//
// Forms:
//
//	SHRXQ r64 m64 r64
//	SHRXQ r64 r64 r64
func SHRXQ(r, mr, r1 operand.Op) (*intrep.Instruction, error) {
	return build(opcSHRXQ.Forms(), sffxs{}, []operand.Op{r, mr, r1})
}

// SHUFPD: Shuffle Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	SHUFPD imm8 m128 xmm
//	SHUFPD imm8 xmm  xmm
func SHUFPD(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcSHUFPD.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// SHUFPS: Shuffle Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	SHUFPS imm8 m128 xmm
//	SHUFPS imm8 xmm  xmm
func SHUFPS(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcSHUFPS.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// SQRTPD: Compute Square Roots of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	SQRTPD m128 xmm
//	SQRTPD xmm  xmm
func SQRTPD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcSQRTPD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// SQRTPS: Compute Square Roots of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	SQRTPS m128 xmm
//	SQRTPS xmm  xmm
func SQRTPS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcSQRTPS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// SQRTSD: Compute Square Root of Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	SQRTSD m64 xmm
//	SQRTSD xmm xmm
func SQRTSD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcSQRTSD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// SQRTSS: Compute Square Root of Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	SQRTSS m32 xmm
//	SQRTSS xmm xmm
func SQRTSS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcSQRTSS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// STC: Set Carry Flag.
//
// Forms:
//
//	STC
func STC() (*intrep.Instruction, error) {
	return build(opcSTC.Forms(), sffxs{}, []operand.Op{})
}

// STD: Set Direction Flag.
//
// Forms:
//
//	STD
func STD() (*intrep.Instruction, error) {
	return build(opcSTD.Forms(), sffxs{}, []operand.Op{})
}

// STMXCSR: Store MXCSR Register State.
//
// Forms:
//
//	STMXCSR m32
func STMXCSR(m operand.Op) (*intrep.Instruction, error) {
	return build(opcSTMXCSR.Forms(), sffxs{}, []operand.Op{m})
}

// SUBB: Subtract.
//
// Forms:
//
//	SUBB imm8 al
//	SUBB imm8 m8
//	SUBB imm8 r8
//	SUBB m8   r8
//	SUBB r8   m8
//	SUBB r8   r8
func SUBB(imr, amr operand.Op) (*intrep.Instruction, error) {
	return build(opcSUBB.Forms(), sffxs{}, []operand.Op{imr, amr})
}

// SUBL: Subtract.
//
// Forms:
//
//	SUBL imm32 eax
//	SUBL imm32 m32
//	SUBL imm32 r32
//	SUBL imm8  m32
//	SUBL imm8  r32
//	SUBL m32   r32
//	SUBL r32   m32
//	SUBL r32   r32
func SUBL(imr, emr operand.Op) (*intrep.Instruction, error) {
	return build(opcSUBL.Forms(), sffxs{}, []operand.Op{imr, emr})
}

// SUBPD: Subtract Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	SUBPD m128 xmm
//	SUBPD xmm  xmm
func SUBPD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcSUBPD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// SUBPS: Subtract Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	SUBPS m128 xmm
//	SUBPS xmm  xmm
func SUBPS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcSUBPS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// SUBQ: Subtract.
//
// Forms:
//
//	SUBQ imm32 m64
//	SUBQ imm32 r64
//	SUBQ imm32 rax
//	SUBQ imm8  m64
//	SUBQ imm8  r64
//	SUBQ m64   r64
//	SUBQ r64   m64
//	SUBQ r64   r64
func SUBQ(imr, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcSUBQ.Forms(), sffxs{}, []operand.Op{imr, mr})
}

// SUBSD: Subtract Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	SUBSD m64 xmm
//	SUBSD xmm xmm
func SUBSD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcSUBSD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// SUBSS: Subtract Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	SUBSS m32 xmm
//	SUBSS xmm xmm
func SUBSS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcSUBSS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// SUBW: Subtract.
//
// Forms:
//
//	SUBW imm16 ax
//	SUBW imm16 m16
//	SUBW imm16 r16
//	SUBW imm8  m16
//	SUBW imm8  r16
//	SUBW m16   r16
//	SUBW r16   m16
//	SUBW r16   r16
func SUBW(imr, amr operand.Op) (*intrep.Instruction, error) {
	return build(opcSUBW.Forms(), sffxs{}, []operand.Op{imr, amr})
}

// SYSCALL: Fast System Call.
//
// Forms:
//
//	SYSCALL
func SYSCALL() (*intrep.Instruction, error) {
	return build(opcSYSCALL.Forms(), sffxs{}, []operand.Op{})
}

// TESTB: Logical Compare.
//
// Forms:
//
//	TESTB imm8 al
//	TESTB imm8 m8
//	TESTB imm8 r8
//	TESTB r8   m8
//	TESTB r8   r8
func TESTB(ir, amr operand.Op) (*intrep.Instruction, error) {
	return build(opcTESTB.Forms(), sffxs{}, []operand.Op{ir, amr})
}

// TESTL: Logical Compare.
//
// Forms:
//
//	TESTL imm32 eax
//	TESTL imm32 m32
//	TESTL imm32 r32
//	TESTL r32   m32
//	TESTL r32   r32
func TESTL(ir, emr operand.Op) (*intrep.Instruction, error) {
	return build(opcTESTL.Forms(), sffxs{}, []operand.Op{ir, emr})
}

// TESTQ: Logical Compare.
//
// Forms:
//
//	TESTQ imm32 m64
//	TESTQ imm32 r64
//	TESTQ imm32 rax
//	TESTQ r64   m64
//	TESTQ r64   r64
func TESTQ(ir, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcTESTQ.Forms(), sffxs{}, []operand.Op{ir, mr})
}

// TESTW: Logical Compare.
//
// Forms:
//
//	TESTW imm16 ax
//	TESTW imm16 m16
//	TESTW imm16 r16
//	TESTW r16   m16
//	TESTW r16   r16
func TESTW(ir, amr operand.Op) (*intrep.Instruction, error) {
	return build(opcTESTW.Forms(), sffxs{}, []operand.Op{ir, amr})
}

// TZCNTL: Count the Number of Trailing Zero Bits.
//
// Forms:
//
//	TZCNTL m32 r32
//	TZCNTL r32 r32
func TZCNTL(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcTZCNTL.Forms(), sffxs{}, []operand.Op{mr, r})
}

// TZCNTQ: Count the Number of Trailing Zero Bits.
//
// Forms:
//
//	TZCNTQ m64 r64
//	TZCNTQ r64 r64
func TZCNTQ(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcTZCNTQ.Forms(), sffxs{}, []operand.Op{mr, r})
}

// TZCNTW: Count the Number of Trailing Zero Bits.
//
// Forms:
//
//	TZCNTW m16 r16
//	TZCNTW r16 r16
func TZCNTW(mr, r operand.Op) (*intrep.Instruction, error) {
	return build(opcTZCNTW.Forms(), sffxs{}, []operand.Op{mr, r})
}

// UCOMISD: Unordered Compare Scalar Double-Precision Floating-Point Values and Set EFLAGS.
//
// Forms:
//
//	UCOMISD m64 xmm
//	UCOMISD xmm xmm
func UCOMISD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcUCOMISD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// UCOMISS: Unordered Compare Scalar Single-Precision Floating-Point Values and Set EFLAGS.
//
// Forms:
//
//	UCOMISS m32 xmm
//	UCOMISS xmm xmm
func UCOMISS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcUCOMISS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// UD2: Undefined Instruction.
//
// Forms:
//
//	UD2
func UD2() (*intrep.Instruction, error) {
	return build(opcUD2.Forms(), sffxs{}, []operand.Op{})
}

// UNPCKHPD: Unpack and Interleave High Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	UNPCKHPD m128 xmm
//	UNPCKHPD xmm  xmm
func UNPCKHPD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcUNPCKHPD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// UNPCKHPS: Unpack and Interleave High Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	UNPCKHPS m128 xmm
//	UNPCKHPS xmm  xmm
func UNPCKHPS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcUNPCKHPS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// UNPCKLPD: Unpack and Interleave Low Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	UNPCKLPD m128 xmm
//	UNPCKLPD xmm  xmm
func UNPCKLPD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcUNPCKLPD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// UNPCKLPS: Unpack and Interleave Low Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	UNPCKLPS m128 xmm
//	UNPCKLPS xmm  xmm
func UNPCKLPS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcUNPCKLPS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// VADDPD: Add Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VADDPD m128 xmm xmm
//	VADDPD m256 ymm ymm
//	VADDPD xmm  xmm xmm
//	VADDPD ymm  ymm ymm
//	VADDPD m128 xmm k xmm
//	VADDPD m256 ymm k ymm
//	VADDPD xmm  xmm k xmm
//	VADDPD ymm  ymm k ymm
//	VADDPD m512 zmm k zmm
//	VADDPD m512 zmm zmm
//	VADDPD zmm  zmm k zmm
//	VADDPD zmm  zmm zmm
func VADDPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPD.Forms(), sffxs{}, ops)
}

// VADDPD_BCST: Add Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VADDPD.BCST m64 xmm k xmm
//	VADDPD.BCST m64 xmm xmm
//	VADDPD.BCST m64 ymm k ymm
//	VADDPD.BCST m64 ymm ymm
//	VADDPD.BCST m64 zmm k zmm
//	VADDPD.BCST m64 zmm zmm
func VADDPD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPD.Forms(), sffxs{sffxBCST}, ops)
}

// VADDPD_BCST_Z: Add Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VADDPD.BCST.Z m64 xmm k xmm
//	VADDPD.BCST.Z m64 ymm k ymm
//	VADDPD.BCST.Z m64 zmm k zmm
func VADDPD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VADDPD_RD_SAE: Add Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VADDPD.RD_SAE zmm zmm k zmm
//	VADDPD.RD_SAE zmm zmm zmm
func VADDPD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VADDPD_RD_SAE_Z: Add Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDPD.RD_SAE.Z zmm zmm k zmm
func VADDPD_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VADDPD_RN_SAE: Add Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VADDPD.RN_SAE zmm zmm k zmm
//	VADDPD.RN_SAE zmm zmm zmm
func VADDPD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VADDPD_RN_SAE_Z: Add Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VADDPD.RN_SAE.Z zmm zmm k zmm
func VADDPD_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VADDPD_RU_SAE: Add Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VADDPD.RU_SAE zmm zmm k zmm
//	VADDPD.RU_SAE zmm zmm zmm
func VADDPD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VADDPD_RU_SAE_Z: Add Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDPD.RU_SAE.Z zmm zmm k zmm
func VADDPD_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VADDPD_RZ_SAE: Add Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VADDPD.RZ_SAE zmm zmm k zmm
//	VADDPD.RZ_SAE zmm zmm zmm
func VADDPD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VADDPD_RZ_SAE_Z: Add Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VADDPD.RZ_SAE.Z zmm zmm k zmm
func VADDPD_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VADDPD_Z: Add Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VADDPD.Z m128 xmm k xmm
//	VADDPD.Z m256 ymm k ymm
//	VADDPD.Z xmm  xmm k xmm
//	VADDPD.Z ymm  ymm k ymm
//	VADDPD.Z m512 zmm k zmm
//	VADDPD.Z zmm  zmm k zmm
func VADDPD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VADDPS: Add Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VADDPS m128 xmm xmm
//	VADDPS m256 ymm ymm
//	VADDPS xmm  xmm xmm
//	VADDPS ymm  ymm ymm
//	VADDPS m128 xmm k xmm
//	VADDPS m256 ymm k ymm
//	VADDPS xmm  xmm k xmm
//	VADDPS ymm  ymm k ymm
//	VADDPS m512 zmm k zmm
//	VADDPS m512 zmm zmm
//	VADDPS zmm  zmm k zmm
//	VADDPS zmm  zmm zmm
func VADDPS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPS.Forms(), sffxs{}, ops)
}

// VADDPS_BCST: Add Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VADDPS.BCST m32 xmm k xmm
//	VADDPS.BCST m32 xmm xmm
//	VADDPS.BCST m32 ymm k ymm
//	VADDPS.BCST m32 ymm ymm
//	VADDPS.BCST m32 zmm k zmm
//	VADDPS.BCST m32 zmm zmm
func VADDPS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPS.Forms(), sffxs{sffxBCST}, ops)
}

// VADDPS_BCST_Z: Add Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VADDPS.BCST.Z m32 xmm k xmm
//	VADDPS.BCST.Z m32 ymm k ymm
//	VADDPS.BCST.Z m32 zmm k zmm
func VADDPS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VADDPS_RD_SAE: Add Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VADDPS.RD_SAE zmm zmm k zmm
//	VADDPS.RD_SAE zmm zmm zmm
func VADDPS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VADDPS_RD_SAE_Z: Add Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDPS.RD_SAE.Z zmm zmm k zmm
func VADDPS_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VADDPS_RN_SAE: Add Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VADDPS.RN_SAE zmm zmm k zmm
//	VADDPS.RN_SAE zmm zmm zmm
func VADDPS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VADDPS_RN_SAE_Z: Add Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VADDPS.RN_SAE.Z zmm zmm k zmm
func VADDPS_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VADDPS_RU_SAE: Add Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VADDPS.RU_SAE zmm zmm k zmm
//	VADDPS.RU_SAE zmm zmm zmm
func VADDPS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VADDPS_RU_SAE_Z: Add Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDPS.RU_SAE.Z zmm zmm k zmm
func VADDPS_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VADDPS_RZ_SAE: Add Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VADDPS.RZ_SAE zmm zmm k zmm
//	VADDPS.RZ_SAE zmm zmm zmm
func VADDPS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VADDPS_RZ_SAE_Z: Add Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VADDPS.RZ_SAE.Z zmm zmm k zmm
func VADDPS_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VADDPS_Z: Add Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VADDPS.Z m128 xmm k xmm
//	VADDPS.Z m256 ymm k ymm
//	VADDPS.Z xmm  xmm k xmm
//	VADDPS.Z ymm  ymm k ymm
//	VADDPS.Z m512 zmm k zmm
//	VADDPS.Z zmm  zmm k zmm
func VADDPS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDPS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VADDSD: Add Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VADDSD m64 xmm xmm
//	VADDSD xmm xmm xmm
//	VADDSD m64 xmm k xmm
//	VADDSD xmm xmm k xmm
func VADDSD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSD.Forms(), sffxs{}, ops)
}

// VADDSD_RD_SAE: Add Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VADDSD.RD_SAE xmm xmm k xmm
//	VADDSD.RD_SAE xmm xmm xmm
func VADDSD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VADDSD_RD_SAE_Z: Add Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDSD.RD_SAE.Z xmm xmm k xmm
func VADDSD_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VADDSD_RN_SAE: Add Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VADDSD.RN_SAE xmm xmm k xmm
//	VADDSD.RN_SAE xmm xmm xmm
func VADDSD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VADDSD_RN_SAE_Z: Add Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VADDSD.RN_SAE.Z xmm xmm k xmm
func VADDSD_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VADDSD_RU_SAE: Add Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VADDSD.RU_SAE xmm xmm k xmm
//	VADDSD.RU_SAE xmm xmm xmm
func VADDSD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VADDSD_RU_SAE_Z: Add Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDSD.RU_SAE.Z xmm xmm k xmm
func VADDSD_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VADDSD_RZ_SAE: Add Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VADDSD.RZ_SAE xmm xmm k xmm
//	VADDSD.RZ_SAE xmm xmm xmm
func VADDSD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VADDSD_RZ_SAE_Z: Add Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VADDSD.RZ_SAE.Z xmm xmm k xmm
func VADDSD_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VADDSD_Z: Add Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VADDSD.Z m64 xmm k xmm
//	VADDSD.Z xmm xmm k xmm
func VADDSD_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSD.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VADDSS: Add Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VADDSS m32 xmm xmm
//	VADDSS xmm xmm xmm
//	VADDSS m32 xmm k xmm
//	VADDSS xmm xmm k xmm
func VADDSS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSS.Forms(), sffxs{}, ops)
}

// VADDSS_RD_SAE: Add Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VADDSS.RD_SAE xmm xmm k xmm
//	VADDSS.RD_SAE xmm xmm xmm
func VADDSS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VADDSS_RD_SAE_Z: Add Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDSS.RD_SAE.Z xmm xmm k xmm
func VADDSS_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VADDSS_RN_SAE: Add Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VADDSS.RN_SAE xmm xmm k xmm
//	VADDSS.RN_SAE xmm xmm xmm
func VADDSS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VADDSS_RN_SAE_Z: Add Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VADDSS.RN_SAE.Z xmm xmm k xmm
func VADDSS_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VADDSS_RU_SAE: Add Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VADDSS.RU_SAE xmm xmm k xmm
//	VADDSS.RU_SAE xmm xmm xmm
func VADDSS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VADDSS_RU_SAE_Z: Add Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDSS.RU_SAE.Z xmm xmm k xmm
func VADDSS_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VADDSS_RZ_SAE: Add Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VADDSS.RZ_SAE xmm xmm k xmm
//	VADDSS.RZ_SAE xmm xmm xmm
func VADDSS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VADDSS_RZ_SAE_Z: Add Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VADDSS.RZ_SAE.Z xmm xmm k xmm
func VADDSS_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VADDSS_Z: Add Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VADDSS.Z m32 xmm k xmm
//	VADDSS.Z xmm xmm k xmm
func VADDSS_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSS.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VADDSUBPD: Packed Double-FP Add/Subtract.
//
// Forms:
//
//	VADDSUBPD m128 xmm xmm
//	VADDSUBPD m256 ymm ymm
//	VADDSUBPD xmm  xmm xmm
//	VADDSUBPD ymm  ymm ymm
func VADDSUBPD(mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSUBPD.Forms(), sffxs{}, []operand.Op{mxy, xy, xy1})
}

// VADDSUBPS: Packed Single-FP Add/Subtract.
//
// Forms:
//
//	VADDSUBPS m128 xmm xmm
//	VADDSUBPS m256 ymm ymm
//	VADDSUBPS xmm  xmm xmm
//	VADDSUBPS ymm  ymm ymm
func VADDSUBPS(mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVADDSUBPS.Forms(), sffxs{}, []operand.Op{mxy, xy, xy1})
}

// VAESDEC: Perform One Round of an AES Decryption Flow.
//
// Forms:
//
//	VAESDEC m128 xmm xmm
//	VAESDEC xmm  xmm xmm
//	VAESDEC m256 ymm ymm
//	VAESDEC ymm  ymm ymm
//	VAESDEC m512 zmm zmm
//	VAESDEC zmm  zmm zmm
func VAESDEC(mxyz, xyz, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVAESDEC.Forms(), sffxs{}, []operand.Op{mxyz, xyz, xyz1})
}

// VAESDECLAST: Perform Last Round of an AES Decryption Flow.
//
// Forms:
//
//	VAESDECLAST m128 xmm xmm
//	VAESDECLAST xmm  xmm xmm
//	VAESDECLAST m256 ymm ymm
//	VAESDECLAST ymm  ymm ymm
//	VAESDECLAST m512 zmm zmm
//	VAESDECLAST zmm  zmm zmm
func VAESDECLAST(mxyz, xyz, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVAESDECLAST.Forms(), sffxs{}, []operand.Op{mxyz, xyz, xyz1})
}

// VAESENC: Perform One Round of an AES Encryption Flow.
//
// Forms:
//
//	VAESENC m128 xmm xmm
//	VAESENC xmm  xmm xmm
//	VAESENC m256 ymm ymm
//	VAESENC ymm  ymm ymm
//	VAESENC m512 zmm zmm
//	VAESENC zmm  zmm zmm
func VAESENC(mxyz, xyz, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVAESENC.Forms(), sffxs{}, []operand.Op{mxyz, xyz, xyz1})
}

// VAESENCLAST: Perform Last Round of an AES Encryption Flow.
//
// Forms:
//
//	VAESENCLAST m128 xmm xmm
//	VAESENCLAST xmm  xmm xmm
//	VAESENCLAST m256 ymm ymm
//	VAESENCLAST ymm  ymm ymm
//	VAESENCLAST m512 zmm zmm
//	VAESENCLAST zmm  zmm zmm
func VAESENCLAST(mxyz, xyz, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVAESENCLAST.Forms(), sffxs{}, []operand.Op{mxyz, xyz, xyz1})
}

// VAESIMC: Perform the AES InvMixColumn Transformation.
//
// Forms:
//
//	VAESIMC m128 xmm
//	VAESIMC xmm  xmm
func VAESIMC(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVAESIMC.Forms(), sffxs{}, []operand.Op{mx, x})
}

// VAESKEYGENASSIST: AES Round Key Generation Assist.
//
// Forms:
//
//	VAESKEYGENASSIST imm8 m128 xmm
//	VAESKEYGENASSIST imm8 xmm  xmm
func VAESKEYGENASSIST(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVAESKEYGENASSIST.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// VALIGND: Align Doubleword Vectors.
//
// Forms:
//
//	VALIGND imm8 m128 xmm k xmm
//	VALIGND imm8 m128 xmm xmm
//	VALIGND imm8 m256 ymm k ymm
//	VALIGND imm8 m256 ymm ymm
//	VALIGND imm8 xmm  xmm k xmm
//	VALIGND imm8 xmm  xmm xmm
//	VALIGND imm8 ymm  ymm k ymm
//	VALIGND imm8 ymm  ymm ymm
//	VALIGND imm8 m512 zmm k zmm
//	VALIGND imm8 m512 zmm zmm
//	VALIGND imm8 zmm  zmm k zmm
//	VALIGND imm8 zmm  zmm zmm
func VALIGND(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVALIGND.Forms(), sffxs{}, ops)
}

// VALIGND_BCST: Align Doubleword Vectors (Broadcast).
//
// Forms:
//
//	VALIGND.BCST imm8 m32 xmm k xmm
//	VALIGND.BCST imm8 m32 xmm xmm
//	VALIGND.BCST imm8 m32 ymm k ymm
//	VALIGND.BCST imm8 m32 ymm ymm
//	VALIGND.BCST imm8 m32 zmm k zmm
//	VALIGND.BCST imm8 m32 zmm zmm
func VALIGND_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVALIGND.Forms(), sffxs{sffxBCST}, ops)
}

// VALIGND_BCST_Z: Align Doubleword Vectors (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VALIGND.BCST.Z imm8 m32 xmm k xmm
//	VALIGND.BCST.Z imm8 m32 ymm k ymm
//	VALIGND.BCST.Z imm8 m32 zmm k zmm
func VALIGND_BCST_Z(i, m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVALIGND.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, xyz, k, xyz1})
}

// VALIGND_Z: Align Doubleword Vectors (Zeroing Masking).
//
// Forms:
//
//	VALIGND.Z imm8 m128 xmm k xmm
//	VALIGND.Z imm8 m256 ymm k ymm
//	VALIGND.Z imm8 xmm  xmm k xmm
//	VALIGND.Z imm8 ymm  ymm k ymm
//	VALIGND.Z imm8 m512 zmm k zmm
//	VALIGND.Z imm8 zmm  zmm k zmm
func VALIGND_Z(i, mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVALIGND.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, xyz, k, xyz1})
}

// VALIGNQ: Align Quadword Vectors.
//
// Forms:
//
//	VALIGNQ imm8 m128 xmm k xmm
//	VALIGNQ imm8 m128 xmm xmm
//	VALIGNQ imm8 m256 ymm k ymm
//	VALIGNQ imm8 m256 ymm ymm
//	VALIGNQ imm8 xmm  xmm k xmm
//	VALIGNQ imm8 xmm  xmm xmm
//	VALIGNQ imm8 ymm  ymm k ymm
//	VALIGNQ imm8 ymm  ymm ymm
//	VALIGNQ imm8 m512 zmm k zmm
//	VALIGNQ imm8 m512 zmm zmm
//	VALIGNQ imm8 zmm  zmm k zmm
//	VALIGNQ imm8 zmm  zmm zmm
func VALIGNQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVALIGNQ.Forms(), sffxs{}, ops)
}

// VALIGNQ_BCST: Align Quadword Vectors (Broadcast).
//
// Forms:
//
//	VALIGNQ.BCST imm8 m64 xmm k xmm
//	VALIGNQ.BCST imm8 m64 xmm xmm
//	VALIGNQ.BCST imm8 m64 ymm k ymm
//	VALIGNQ.BCST imm8 m64 ymm ymm
//	VALIGNQ.BCST imm8 m64 zmm k zmm
//	VALIGNQ.BCST imm8 m64 zmm zmm
func VALIGNQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVALIGNQ.Forms(), sffxs{sffxBCST}, ops)
}

// VALIGNQ_BCST_Z: Align Quadword Vectors (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VALIGNQ.BCST.Z imm8 m64 xmm k xmm
//	VALIGNQ.BCST.Z imm8 m64 ymm k ymm
//	VALIGNQ.BCST.Z imm8 m64 zmm k zmm
func VALIGNQ_BCST_Z(i, m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVALIGNQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, xyz, k, xyz1})
}

// VALIGNQ_Z: Align Quadword Vectors (Zeroing Masking).
//
// Forms:
//
//	VALIGNQ.Z imm8 m128 xmm k xmm
//	VALIGNQ.Z imm8 m256 ymm k ymm
//	VALIGNQ.Z imm8 xmm  xmm k xmm
//	VALIGNQ.Z imm8 ymm  ymm k ymm
//	VALIGNQ.Z imm8 m512 zmm k zmm
//	VALIGNQ.Z imm8 zmm  zmm k zmm
func VALIGNQ_Z(i, mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVALIGNQ.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, xyz, k, xyz1})
}

// VANDNPD: Bitwise Logical AND NOT of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VANDNPD m128 xmm xmm
//	VANDNPD m256 ymm ymm
//	VANDNPD xmm  xmm xmm
//	VANDNPD ymm  ymm ymm
//	VANDNPD m128 xmm k xmm
//	VANDNPD m256 ymm k ymm
//	VANDNPD xmm  xmm k xmm
//	VANDNPD ymm  ymm k ymm
//	VANDNPD m512 zmm k zmm
//	VANDNPD m512 zmm zmm
//	VANDNPD zmm  zmm k zmm
//	VANDNPD zmm  zmm zmm
func VANDNPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVANDNPD.Forms(), sffxs{}, ops)
}

// VANDNPD_BCST: Bitwise Logical AND NOT of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VANDNPD.BCST m64 xmm k xmm
//	VANDNPD.BCST m64 xmm xmm
//	VANDNPD.BCST m64 ymm k ymm
//	VANDNPD.BCST m64 ymm ymm
//	VANDNPD.BCST m64 zmm k zmm
//	VANDNPD.BCST m64 zmm zmm
func VANDNPD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVANDNPD.Forms(), sffxs{sffxBCST}, ops)
}

// VANDNPD_BCST_Z: Bitwise Logical AND NOT of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VANDNPD.BCST.Z m64 xmm k xmm
//	VANDNPD.BCST.Z m64 ymm k ymm
//	VANDNPD.BCST.Z m64 zmm k zmm
func VANDNPD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVANDNPD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VANDNPD_Z: Bitwise Logical AND NOT of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VANDNPD.Z m128 xmm k xmm
//	VANDNPD.Z m256 ymm k ymm
//	VANDNPD.Z xmm  xmm k xmm
//	VANDNPD.Z ymm  ymm k ymm
//	VANDNPD.Z m512 zmm k zmm
//	VANDNPD.Z zmm  zmm k zmm
func VANDNPD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVANDNPD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VANDNPS: Bitwise Logical AND NOT of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VANDNPS m128 xmm xmm
//	VANDNPS m256 ymm ymm
//	VANDNPS xmm  xmm xmm
//	VANDNPS ymm  ymm ymm
//	VANDNPS m128 xmm k xmm
//	VANDNPS m256 ymm k ymm
//	VANDNPS xmm  xmm k xmm
//	VANDNPS ymm  ymm k ymm
//	VANDNPS m512 zmm k zmm
//	VANDNPS m512 zmm zmm
//	VANDNPS zmm  zmm k zmm
//	VANDNPS zmm  zmm zmm
func VANDNPS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVANDNPS.Forms(), sffxs{}, ops)
}

// VANDNPS_BCST: Bitwise Logical AND NOT of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VANDNPS.BCST m32 xmm k xmm
//	VANDNPS.BCST m32 xmm xmm
//	VANDNPS.BCST m32 ymm k ymm
//	VANDNPS.BCST m32 ymm ymm
//	VANDNPS.BCST m32 zmm k zmm
//	VANDNPS.BCST m32 zmm zmm
func VANDNPS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVANDNPS.Forms(), sffxs{sffxBCST}, ops)
}

// VANDNPS_BCST_Z: Bitwise Logical AND NOT of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VANDNPS.BCST.Z m32 xmm k xmm
//	VANDNPS.BCST.Z m32 ymm k ymm
//	VANDNPS.BCST.Z m32 zmm k zmm
func VANDNPS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVANDNPS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VANDNPS_Z: Bitwise Logical AND NOT of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VANDNPS.Z m128 xmm k xmm
//	VANDNPS.Z m256 ymm k ymm
//	VANDNPS.Z xmm  xmm k xmm
//	VANDNPS.Z ymm  ymm k ymm
//	VANDNPS.Z m512 zmm k zmm
//	VANDNPS.Z zmm  zmm k zmm
func VANDNPS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVANDNPS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VANDPD: Bitwise Logical AND of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VANDPD m128 xmm xmm
//	VANDPD m256 ymm ymm
//	VANDPD xmm  xmm xmm
//	VANDPD ymm  ymm ymm
//	VANDPD m128 xmm k xmm
//	VANDPD m256 ymm k ymm
//	VANDPD xmm  xmm k xmm
//	VANDPD ymm  ymm k ymm
//	VANDPD m512 zmm k zmm
//	VANDPD m512 zmm zmm
//	VANDPD zmm  zmm k zmm
//	VANDPD zmm  zmm zmm
func VANDPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVANDPD.Forms(), sffxs{}, ops)
}

// VANDPD_BCST: Bitwise Logical AND of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VANDPD.BCST m64 xmm k xmm
//	VANDPD.BCST m64 xmm xmm
//	VANDPD.BCST m64 ymm k ymm
//	VANDPD.BCST m64 ymm ymm
//	VANDPD.BCST m64 zmm k zmm
//	VANDPD.BCST m64 zmm zmm
func VANDPD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVANDPD.Forms(), sffxs{sffxBCST}, ops)
}

// VANDPD_BCST_Z: Bitwise Logical AND of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VANDPD.BCST.Z m64 xmm k xmm
//	VANDPD.BCST.Z m64 ymm k ymm
//	VANDPD.BCST.Z m64 zmm k zmm
func VANDPD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVANDPD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VANDPD_Z: Bitwise Logical AND of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VANDPD.Z m128 xmm k xmm
//	VANDPD.Z m256 ymm k ymm
//	VANDPD.Z xmm  xmm k xmm
//	VANDPD.Z ymm  ymm k ymm
//	VANDPD.Z m512 zmm k zmm
//	VANDPD.Z zmm  zmm k zmm
func VANDPD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVANDPD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VANDPS: Bitwise Logical AND of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VANDPS m128 xmm xmm
//	VANDPS m256 ymm ymm
//	VANDPS xmm  xmm xmm
//	VANDPS ymm  ymm ymm
//	VANDPS m128 xmm k xmm
//	VANDPS m256 ymm k ymm
//	VANDPS xmm  xmm k xmm
//	VANDPS ymm  ymm k ymm
//	VANDPS m512 zmm k zmm
//	VANDPS m512 zmm zmm
//	VANDPS zmm  zmm k zmm
//	VANDPS zmm  zmm zmm
func VANDPS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVANDPS.Forms(), sffxs{}, ops)
}

// VANDPS_BCST: Bitwise Logical AND of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VANDPS.BCST m32 xmm k xmm
//	VANDPS.BCST m32 xmm xmm
//	VANDPS.BCST m32 ymm k ymm
//	VANDPS.BCST m32 ymm ymm
//	VANDPS.BCST m32 zmm k zmm
//	VANDPS.BCST m32 zmm zmm
func VANDPS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVANDPS.Forms(), sffxs{sffxBCST}, ops)
}

// VANDPS_BCST_Z: Bitwise Logical AND of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VANDPS.BCST.Z m32 xmm k xmm
//	VANDPS.BCST.Z m32 ymm k ymm
//	VANDPS.BCST.Z m32 zmm k zmm
func VANDPS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVANDPS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VANDPS_Z: Bitwise Logical AND of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VANDPS.Z m128 xmm k xmm
//	VANDPS.Z m256 ymm k ymm
//	VANDPS.Z xmm  xmm k xmm
//	VANDPS.Z ymm  ymm k ymm
//	VANDPS.Z m512 zmm k zmm
//	VANDPS.Z zmm  zmm k zmm
func VANDPS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVANDPS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VBLENDMPD: Blend Packed Double-Precision Floating-Point Vectors Using an OpMask Control.
//
// Forms:
//
//	VBLENDMPD m128 xmm k xmm
//	VBLENDMPD m128 xmm xmm
//	VBLENDMPD m256 ymm k ymm
//	VBLENDMPD m256 ymm ymm
//	VBLENDMPD xmm  xmm k xmm
//	VBLENDMPD xmm  xmm xmm
//	VBLENDMPD ymm  ymm k ymm
//	VBLENDMPD ymm  ymm ymm
//	VBLENDMPD m512 zmm k zmm
//	VBLENDMPD m512 zmm zmm
//	VBLENDMPD zmm  zmm k zmm
//	VBLENDMPD zmm  zmm zmm
func VBLENDMPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVBLENDMPD.Forms(), sffxs{}, ops)
}

// VBLENDMPD_BCST: Blend Packed Double-Precision Floating-Point Vectors Using an OpMask Control (Broadcast).
//
// Forms:
//
//	VBLENDMPD.BCST m64 xmm k xmm
//	VBLENDMPD.BCST m64 xmm xmm
//	VBLENDMPD.BCST m64 ymm k ymm
//	VBLENDMPD.BCST m64 ymm ymm
//	VBLENDMPD.BCST m64 zmm k zmm
//	VBLENDMPD.BCST m64 zmm zmm
func VBLENDMPD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVBLENDMPD.Forms(), sffxs{sffxBCST}, ops)
}

// VBLENDMPD_BCST_Z: Blend Packed Double-Precision Floating-Point Vectors Using an OpMask Control (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VBLENDMPD.BCST.Z m64 xmm k xmm
//	VBLENDMPD.BCST.Z m64 ymm k ymm
//	VBLENDMPD.BCST.Z m64 zmm k zmm
func VBLENDMPD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVBLENDMPD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VBLENDMPD_Z: Blend Packed Double-Precision Floating-Point Vectors Using an OpMask Control (Zeroing Masking).
//
// Forms:
//
//	VBLENDMPD.Z m128 xmm k xmm
//	VBLENDMPD.Z m256 ymm k ymm
//	VBLENDMPD.Z xmm  xmm k xmm
//	VBLENDMPD.Z ymm  ymm k ymm
//	VBLENDMPD.Z m512 zmm k zmm
//	VBLENDMPD.Z zmm  zmm k zmm
func VBLENDMPD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVBLENDMPD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VBLENDMPS: Blend Packed Single-Precision Floating-Point Vectors Using an OpMask Control.
//
// Forms:
//
//	VBLENDMPS m128 xmm k xmm
//	VBLENDMPS m128 xmm xmm
//	VBLENDMPS m256 ymm k ymm
//	VBLENDMPS m256 ymm ymm
//	VBLENDMPS xmm  xmm k xmm
//	VBLENDMPS xmm  xmm xmm
//	VBLENDMPS ymm  ymm k ymm
//	VBLENDMPS ymm  ymm ymm
//	VBLENDMPS m512 zmm k zmm
//	VBLENDMPS m512 zmm zmm
//	VBLENDMPS zmm  zmm k zmm
//	VBLENDMPS zmm  zmm zmm
func VBLENDMPS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVBLENDMPS.Forms(), sffxs{}, ops)
}

// VBLENDMPS_BCST: Blend Packed Single-Precision Floating-Point Vectors Using an OpMask Control (Broadcast).
//
// Forms:
//
//	VBLENDMPS.BCST m32 xmm k xmm
//	VBLENDMPS.BCST m32 xmm xmm
//	VBLENDMPS.BCST m32 ymm k ymm
//	VBLENDMPS.BCST m32 ymm ymm
//	VBLENDMPS.BCST m32 zmm k zmm
//	VBLENDMPS.BCST m32 zmm zmm
func VBLENDMPS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVBLENDMPS.Forms(), sffxs{sffxBCST}, ops)
}

// VBLENDMPS_BCST_Z: Blend Packed Single-Precision Floating-Point Vectors Using an OpMask Control (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VBLENDMPS.BCST.Z m32 xmm k xmm
//	VBLENDMPS.BCST.Z m32 ymm k ymm
//	VBLENDMPS.BCST.Z m32 zmm k zmm
func VBLENDMPS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVBLENDMPS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VBLENDMPS_Z: Blend Packed Single-Precision Floating-Point Vectors Using an OpMask Control (Zeroing Masking).
//
// Forms:
//
//	VBLENDMPS.Z m128 xmm k xmm
//	VBLENDMPS.Z m256 ymm k ymm
//	VBLENDMPS.Z xmm  xmm k xmm
//	VBLENDMPS.Z ymm  ymm k ymm
//	VBLENDMPS.Z m512 zmm k zmm
//	VBLENDMPS.Z zmm  zmm k zmm
func VBLENDMPS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVBLENDMPS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VBLENDPD: Blend Packed Double Precision Floating-Point Values.
//
// Forms:
//
//	VBLENDPD imm8 m128 xmm xmm
//	VBLENDPD imm8 m256 ymm ymm
//	VBLENDPD imm8 xmm  xmm xmm
//	VBLENDPD imm8 ymm  ymm ymm
func VBLENDPD(i, mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVBLENDPD.Forms(), sffxs{}, []operand.Op{i, mxy, xy, xy1})
}

// VBLENDPS:  Blend Packed Single Precision Floating-Point Values.
//
// Forms:
//
//	VBLENDPS imm8 m128 xmm xmm
//	VBLENDPS imm8 m256 ymm ymm
//	VBLENDPS imm8 xmm  xmm xmm
//	VBLENDPS imm8 ymm  ymm ymm
func VBLENDPS(i, mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVBLENDPS.Forms(), sffxs{}, []operand.Op{i, mxy, xy, xy1})
}

// VBLENDVPD:  Variable Blend Packed Double Precision Floating-Point Values.
//
// Forms:
//
//	VBLENDVPD xmm m128 xmm xmm
//	VBLENDVPD xmm xmm  xmm xmm
//	VBLENDVPD ymm m256 ymm ymm
//	VBLENDVPD ymm ymm  ymm ymm
func VBLENDVPD(xy, mxy, xy1, xy2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVBLENDVPD.Forms(), sffxs{}, []operand.Op{xy, mxy, xy1, xy2})
}

// VBLENDVPS:  Variable Blend Packed Single Precision Floating-Point Values.
//
// Forms:
//
//	VBLENDVPS xmm m128 xmm xmm
//	VBLENDVPS xmm xmm  xmm xmm
//	VBLENDVPS ymm m256 ymm ymm
//	VBLENDVPS ymm ymm  ymm ymm
func VBLENDVPS(xy, mxy, xy1, xy2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVBLENDVPS.Forms(), sffxs{}, []operand.Op{xy, mxy, xy1, xy2})
}

// VBROADCASTF128: Broadcast 128 Bit of Floating-Point Data.
//
// Forms:
//
//	VBROADCASTF128 m128 ymm
func VBROADCASTF128(m, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTF128.Forms(), sffxs{}, []operand.Op{m, y})
}

// VBROADCASTF32X2: Broadcast Two Single-Precision Floating-Point Elements.
//
// Forms:
//
//	VBROADCASTF32X2 m64 k ymm
//	VBROADCASTF32X2 m64 ymm
//	VBROADCASTF32X2 xmm k ymm
//	VBROADCASTF32X2 xmm ymm
//	VBROADCASTF32X2 m64 k zmm
//	VBROADCASTF32X2 m64 zmm
//	VBROADCASTF32X2 xmm k zmm
//	VBROADCASTF32X2 xmm zmm
func VBROADCASTF32X2(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTF32X2.Forms(), sffxs{}, ops)
}

// VBROADCASTF32X2_Z: Broadcast Two Single-Precision Floating-Point Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTF32X2.Z m64 k ymm
//	VBROADCASTF32X2.Z xmm k ymm
//	VBROADCASTF32X2.Z m64 k zmm
//	VBROADCASTF32X2.Z xmm k zmm
func VBROADCASTF32X2_Z(mx, k, yz operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTF32X2.Forms(), sffxs{sffxZ}, []operand.Op{mx, k, yz})
}

// VBROADCASTF32X4: Broadcast Four Single-Precision Floating-Point Elements.
//
// Forms:
//
//	VBROADCASTF32X4 m128 k ymm
//	VBROADCASTF32X4 m128 ymm
//	VBROADCASTF32X4 m128 k zmm
//	VBROADCASTF32X4 m128 zmm
func VBROADCASTF32X4(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTF32X4.Forms(), sffxs{}, ops)
}

// VBROADCASTF32X4_Z: Broadcast Four Single-Precision Floating-Point Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTF32X4.Z m128 k ymm
//	VBROADCASTF32X4.Z m128 k zmm
func VBROADCASTF32X4_Z(m, k, yz operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTF32X4.Forms(), sffxs{sffxZ}, []operand.Op{m, k, yz})
}

// VBROADCASTF32X8: Broadcast Eight Single-Precision Floating-Point Elements.
//
// Forms:
//
//	VBROADCASTF32X8 m256 k zmm
//	VBROADCASTF32X8 m256 zmm
func VBROADCASTF32X8(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTF32X8.Forms(), sffxs{}, ops)
}

// VBROADCASTF32X8_Z: Broadcast Eight Single-Precision Floating-Point Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTF32X8.Z m256 k zmm
func VBROADCASTF32X8_Z(m, k, z operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTF32X8.Forms(), sffxs{sffxZ}, []operand.Op{m, k, z})
}

// VBROADCASTF64X2: Broadcast Two Double-Precision Floating-Point Elements.
//
// Forms:
//
//	VBROADCASTF64X2 m128 k ymm
//	VBROADCASTF64X2 m128 ymm
//	VBROADCASTF64X2 m128 k zmm
//	VBROADCASTF64X2 m128 zmm
func VBROADCASTF64X2(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTF64X2.Forms(), sffxs{}, ops)
}

// VBROADCASTF64X2_Z: Broadcast Two Double-Precision Floating-Point Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTF64X2.Z m128 k ymm
//	VBROADCASTF64X2.Z m128 k zmm
func VBROADCASTF64X2_Z(m, k, yz operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTF64X2.Forms(), sffxs{sffxZ}, []operand.Op{m, k, yz})
}

// VBROADCASTF64X4: Broadcast Four Double-Precision Floating-Point Elements.
//
// Forms:
//
//	VBROADCASTF64X4 m256 k zmm
//	VBROADCASTF64X4 m256 zmm
func VBROADCASTF64X4(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTF64X4.Forms(), sffxs{}, ops)
}

// VBROADCASTF64X4_Z: Broadcast Four Double-Precision Floating-Point Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTF64X4.Z m256 k zmm
func VBROADCASTF64X4_Z(m, k, z operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTF64X4.Forms(), sffxs{sffxZ}, []operand.Op{m, k, z})
}

// VBROADCASTI128: Broadcast 128 Bits of Integer Data.
//
// Forms:
//
//	VBROADCASTI128 m128 ymm
func VBROADCASTI128(m, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTI128.Forms(), sffxs{}, []operand.Op{m, y})
}

// VBROADCASTI32X2: Broadcast Two Doubleword Elements.
//
// Forms:
//
//	VBROADCASTI32X2 m64 k xmm
//	VBROADCASTI32X2 m64 k ymm
//	VBROADCASTI32X2 m64 xmm
//	VBROADCASTI32X2 m64 ymm
//	VBROADCASTI32X2 xmm k xmm
//	VBROADCASTI32X2 xmm k ymm
//	VBROADCASTI32X2 xmm xmm
//	VBROADCASTI32X2 xmm ymm
//	VBROADCASTI32X2 m64 k zmm
//	VBROADCASTI32X2 m64 zmm
//	VBROADCASTI32X2 xmm k zmm
//	VBROADCASTI32X2 xmm zmm
func VBROADCASTI32X2(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTI32X2.Forms(), sffxs{}, ops)
}

// VBROADCASTI32X2_Z: Broadcast Two Doubleword Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTI32X2.Z m64 k xmm
//	VBROADCASTI32X2.Z m64 k ymm
//	VBROADCASTI32X2.Z xmm k xmm
//	VBROADCASTI32X2.Z xmm k ymm
//	VBROADCASTI32X2.Z m64 k zmm
//	VBROADCASTI32X2.Z xmm k zmm
func VBROADCASTI32X2_Z(mx, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTI32X2.Forms(), sffxs{sffxZ}, []operand.Op{mx, k, xyz})
}

// VBROADCASTI32X4: Broadcast Four Doubleword Elements.
//
// Forms:
//
//	VBROADCASTI32X4 m128 k ymm
//	VBROADCASTI32X4 m128 ymm
//	VBROADCASTI32X4 m128 k zmm
//	VBROADCASTI32X4 m128 zmm
func VBROADCASTI32X4(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTI32X4.Forms(), sffxs{}, ops)
}

// VBROADCASTI32X4_Z: Broadcast Four Doubleword Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTI32X4.Z m128 k ymm
//	VBROADCASTI32X4.Z m128 k zmm
func VBROADCASTI32X4_Z(m, k, yz operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTI32X4.Forms(), sffxs{sffxZ}, []operand.Op{m, k, yz})
}

// VBROADCASTI32X8: Broadcast Eight Doubleword Elements.
//
// Forms:
//
//	VBROADCASTI32X8 m256 k zmm
//	VBROADCASTI32X8 m256 zmm
func VBROADCASTI32X8(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTI32X8.Forms(), sffxs{}, ops)
}

// VBROADCASTI32X8_Z: Broadcast Eight Doubleword Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTI32X8.Z m256 k zmm
func VBROADCASTI32X8_Z(m, k, z operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTI32X8.Forms(), sffxs{sffxZ}, []operand.Op{m, k, z})
}

// VBROADCASTI64X2: Broadcast Two Quadword Elements.
//
// Forms:
//
//	VBROADCASTI64X2 m128 k ymm
//	VBROADCASTI64X2 m128 ymm
//	VBROADCASTI64X2 m128 k zmm
//	VBROADCASTI64X2 m128 zmm
func VBROADCASTI64X2(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTI64X2.Forms(), sffxs{}, ops)
}

// VBROADCASTI64X2_Z: Broadcast Two Quadword Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTI64X2.Z m128 k ymm
//	VBROADCASTI64X2.Z m128 k zmm
func VBROADCASTI64X2_Z(m, k, yz operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTI64X2.Forms(), sffxs{sffxZ}, []operand.Op{m, k, yz})
}

// VBROADCASTI64X4: Broadcast Four Quadword Elements.
//
// Forms:
//
//	VBROADCASTI64X4 m256 k zmm
//	VBROADCASTI64X4 m256 zmm
func VBROADCASTI64X4(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTI64X4.Forms(), sffxs{}, ops)
}

// VBROADCASTI64X4_Z: Broadcast Four Quadword Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTI64X4.Z m256 k zmm
func VBROADCASTI64X4_Z(m, k, z operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTI64X4.Forms(), sffxs{sffxZ}, []operand.Op{m, k, z})
}

// VBROADCASTSD: Broadcast Double-Precision Floating-Point Element.
//
// Forms:
//
//	VBROADCASTSD xmm ymm
//	VBROADCASTSD m64 ymm
//	VBROADCASTSD m64 k ymm
//	VBROADCASTSD xmm k ymm
//	VBROADCASTSD m64 k zmm
//	VBROADCASTSD m64 zmm
//	VBROADCASTSD xmm k zmm
//	VBROADCASTSD xmm zmm
func VBROADCASTSD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTSD.Forms(), sffxs{}, ops)
}

// VBROADCASTSD_Z: Broadcast Double-Precision Floating-Point Element (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTSD.Z m64 k ymm
//	VBROADCASTSD.Z xmm k ymm
//	VBROADCASTSD.Z m64 k zmm
//	VBROADCASTSD.Z xmm k zmm
func VBROADCASTSD_Z(mx, k, yz operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTSD.Forms(), sffxs{sffxZ}, []operand.Op{mx, k, yz})
}

// VBROADCASTSS: Broadcast Single-Precision Floating-Point Element.
//
// Forms:
//
//	VBROADCASTSS xmm xmm
//	VBROADCASTSS xmm ymm
//	VBROADCASTSS m32 xmm
//	VBROADCASTSS m32 ymm
//	VBROADCASTSS m32 k ymm
//	VBROADCASTSS xmm k ymm
//	VBROADCASTSS m32 k zmm
//	VBROADCASTSS m32 zmm
//	VBROADCASTSS xmm k zmm
//	VBROADCASTSS xmm zmm
func VBROADCASTSS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTSS.Forms(), sffxs{}, ops)
}

// VBROADCASTSS_Z: Broadcast Single-Precision Floating-Point Element (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTSS.Z m32 k ymm
//	VBROADCASTSS.Z xmm k ymm
//	VBROADCASTSS.Z m32 k zmm
//	VBROADCASTSS.Z xmm k zmm
func VBROADCASTSS_Z(mx, k, yz operand.Op) (*intrep.Instruction, error) {
	return build(opcVBROADCASTSS.Forms(), sffxs{sffxZ}, []operand.Op{mx, k, yz})
}

// VCMPPD: Compare Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VCMPPD imm8 m128 xmm xmm
//	VCMPPD imm8 m256 ymm ymm
//	VCMPPD imm8 xmm  xmm xmm
//	VCMPPD imm8 ymm  ymm ymm
//	VCMPPD imm8 m128 xmm k k
//	VCMPPD imm8 m128 xmm k
//	VCMPPD imm8 m256 ymm k k
//	VCMPPD imm8 m256 ymm k
//	VCMPPD imm8 xmm  xmm k k
//	VCMPPD imm8 xmm  xmm k
//	VCMPPD imm8 ymm  ymm k k
//	VCMPPD imm8 ymm  ymm k
//	VCMPPD imm8 m512 zmm k k
//	VCMPPD imm8 m512 zmm k
//	VCMPPD imm8 zmm  zmm k k
//	VCMPPD imm8 zmm  zmm k
func VCMPPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCMPPD.Forms(), sffxs{}, ops)
}

// VCMPPD_BCST: Compare Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCMPPD.BCST imm8 m64 xmm k k
//	VCMPPD.BCST imm8 m64 xmm k
//	VCMPPD.BCST imm8 m64 ymm k k
//	VCMPPD.BCST imm8 m64 ymm k
//	VCMPPD.BCST imm8 m64 zmm k k
//	VCMPPD.BCST imm8 m64 zmm k
func VCMPPD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCMPPD.Forms(), sffxs{sffxBCST}, ops)
}

// VCMPPD_SAE: Compare Packed Double-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VCMPPD.SAE imm8 zmm zmm k k
//	VCMPPD.SAE imm8 zmm zmm k
func VCMPPD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCMPPD.Forms(), sffxs{sffxSAE}, ops)
}

// VCMPPS: Compare Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCMPPS imm8 m128 xmm xmm
//	VCMPPS imm8 m256 ymm ymm
//	VCMPPS imm8 xmm  xmm xmm
//	VCMPPS imm8 ymm  ymm ymm
//	VCMPPS imm8 m128 xmm k k
//	VCMPPS imm8 m128 xmm k
//	VCMPPS imm8 m256 ymm k k
//	VCMPPS imm8 m256 ymm k
//	VCMPPS imm8 xmm  xmm k k
//	VCMPPS imm8 xmm  xmm k
//	VCMPPS imm8 ymm  ymm k k
//	VCMPPS imm8 ymm  ymm k
//	VCMPPS imm8 m512 zmm k k
//	VCMPPS imm8 m512 zmm k
//	VCMPPS imm8 zmm  zmm k k
//	VCMPPS imm8 zmm  zmm k
func VCMPPS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCMPPS.Forms(), sffxs{}, ops)
}

// VCMPPS_BCST: Compare Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCMPPS.BCST imm8 m32 xmm k k
//	VCMPPS.BCST imm8 m32 xmm k
//	VCMPPS.BCST imm8 m32 ymm k k
//	VCMPPS.BCST imm8 m32 ymm k
//	VCMPPS.BCST imm8 m32 zmm k k
//	VCMPPS.BCST imm8 m32 zmm k
func VCMPPS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCMPPS.Forms(), sffxs{sffxBCST}, ops)
}

// VCMPPS_SAE: Compare Packed Single-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VCMPPS.SAE imm8 zmm zmm k k
//	VCMPPS.SAE imm8 zmm zmm k
func VCMPPS_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCMPPS.Forms(), sffxs{sffxSAE}, ops)
}

// VCMPSD: Compare Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VCMPSD imm8 m64 xmm xmm
//	VCMPSD imm8 xmm xmm xmm
//	VCMPSD imm8 m64 xmm k k
//	VCMPSD imm8 m64 xmm k
//	VCMPSD imm8 xmm xmm k k
//	VCMPSD imm8 xmm xmm k
func VCMPSD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCMPSD.Forms(), sffxs{}, ops)
}

// VCMPSD_SAE: Compare Scalar Double-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VCMPSD.SAE imm8 xmm xmm k k
//	VCMPSD.SAE imm8 xmm xmm k
func VCMPSD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCMPSD.Forms(), sffxs{sffxSAE}, ops)
}

// VCMPSS: Compare Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCMPSS imm8 m32 xmm xmm
//	VCMPSS imm8 xmm xmm xmm
//	VCMPSS imm8 m32 xmm k k
//	VCMPSS imm8 m32 xmm k
//	VCMPSS imm8 xmm xmm k k
//	VCMPSS imm8 xmm xmm k
func VCMPSS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCMPSS.Forms(), sffxs{}, ops)
}

// VCMPSS_SAE: Compare Scalar Single-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VCMPSS.SAE imm8 xmm xmm k k
//	VCMPSS.SAE imm8 xmm xmm k
func VCMPSS_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCMPSS.Forms(), sffxs{sffxSAE}, ops)
}

// VCOMISD: Compare Scalar Ordered Double-Precision Floating-Point Values and Set EFLAGS.
//
// Forms:
//
//	VCOMISD m64 xmm
//	VCOMISD xmm xmm
func VCOMISD(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCOMISD.Forms(), sffxs{}, []operand.Op{mx, x})
}

// VCOMISD_SAE: Compare Scalar Ordered Double-Precision Floating-Point Values and Set EFLAGS (Suppress All Exceptions).
//
// Forms:
//
//	VCOMISD.SAE xmm xmm
func VCOMISD_SAE(x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCOMISD.Forms(), sffxs{sffxSAE}, []operand.Op{x, x1})
}

// VCOMISS: Compare Scalar Ordered Single-Precision Floating-Point Values and Set EFLAGS.
//
// Forms:
//
//	VCOMISS m32 xmm
//	VCOMISS xmm xmm
func VCOMISS(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCOMISS.Forms(), sffxs{}, []operand.Op{mx, x})
}

// VCOMISS_SAE: Compare Scalar Ordered Single-Precision Floating-Point Values and Set EFLAGS (Suppress All Exceptions).
//
// Forms:
//
//	VCOMISS.SAE xmm xmm
func VCOMISS_SAE(x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCOMISS.Forms(), sffxs{sffxSAE}, []operand.Op{x, x1})
}

// VCOMPRESSPD: Store Sparse Packed Double-Precision Floating-Point Values into Dense Memory/Register.
//
// Forms:
//
//	VCOMPRESSPD xmm k m128
//	VCOMPRESSPD xmm k xmm
//	VCOMPRESSPD xmm m128
//	VCOMPRESSPD xmm xmm
//	VCOMPRESSPD ymm k m256
//	VCOMPRESSPD ymm k ymm
//	VCOMPRESSPD ymm m256
//	VCOMPRESSPD ymm ymm
//	VCOMPRESSPD zmm k m512
//	VCOMPRESSPD zmm k zmm
//	VCOMPRESSPD zmm m512
//	VCOMPRESSPD zmm zmm
func VCOMPRESSPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCOMPRESSPD.Forms(), sffxs{}, ops)
}

// VCOMPRESSPD_Z: Store Sparse Packed Double-Precision Floating-Point Values into Dense Memory/Register (Zeroing Masking).
//
// Forms:
//
//	VCOMPRESSPD.Z xmm k m128
//	VCOMPRESSPD.Z xmm k xmm
//	VCOMPRESSPD.Z ymm k m256
//	VCOMPRESSPD.Z ymm k ymm
//	VCOMPRESSPD.Z zmm k m512
//	VCOMPRESSPD.Z zmm k zmm
func VCOMPRESSPD_Z(xyz, k, mxyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCOMPRESSPD.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mxyz})
}

// VCOMPRESSPS: Store Sparse Packed Single-Precision Floating-Point Values into Dense Memory/Register.
//
// Forms:
//
//	VCOMPRESSPS xmm k m128
//	VCOMPRESSPS xmm k xmm
//	VCOMPRESSPS xmm m128
//	VCOMPRESSPS xmm xmm
//	VCOMPRESSPS ymm k m256
//	VCOMPRESSPS ymm k ymm
//	VCOMPRESSPS ymm m256
//	VCOMPRESSPS ymm ymm
//	VCOMPRESSPS zmm k m512
//	VCOMPRESSPS zmm k zmm
//	VCOMPRESSPS zmm m512
//	VCOMPRESSPS zmm zmm
func VCOMPRESSPS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCOMPRESSPS.Forms(), sffxs{}, ops)
}

// VCOMPRESSPS_Z: Store Sparse Packed Single-Precision Floating-Point Values into Dense Memory/Register (Zeroing Masking).
//
// Forms:
//
//	VCOMPRESSPS.Z xmm k m128
//	VCOMPRESSPS.Z xmm k xmm
//	VCOMPRESSPS.Z ymm k m256
//	VCOMPRESSPS.Z ymm k ymm
//	VCOMPRESSPS.Z zmm k m512
//	VCOMPRESSPS.Z zmm k zmm
func VCOMPRESSPS_Z(xyz, k, mxyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCOMPRESSPS.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mxyz})
}

// VCVTDQ2PD: Convert Packed Dword Integers to Packed Double-Precision FP Values.
//
// Forms:
//
//	VCVTDQ2PD m128 ymm
//	VCVTDQ2PD m64  xmm
//	VCVTDQ2PD xmm  xmm
//	VCVTDQ2PD xmm  ymm
//	VCVTDQ2PD m128 k ymm
//	VCVTDQ2PD m64  k xmm
//	VCVTDQ2PD xmm  k xmm
//	VCVTDQ2PD xmm  k ymm
//	VCVTDQ2PD m256 k zmm
//	VCVTDQ2PD m256 zmm
//	VCVTDQ2PD ymm  k zmm
//	VCVTDQ2PD ymm  zmm
func VCVTDQ2PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTDQ2PD.Forms(), sffxs{}, ops)
}

// VCVTDQ2PD_BCST: Convert Packed Dword Integers to Packed Double-Precision FP Values (Broadcast).
//
// Forms:
//
//	VCVTDQ2PD.BCST m32 k xmm
//	VCVTDQ2PD.BCST m32 k ymm
//	VCVTDQ2PD.BCST m32 xmm
//	VCVTDQ2PD.BCST m32 ymm
//	VCVTDQ2PD.BCST m32 k zmm
//	VCVTDQ2PD.BCST m32 zmm
func VCVTDQ2PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTDQ2PD.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTDQ2PD_BCST_Z: Convert Packed Dword Integers to Packed Double-Precision FP Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PD.BCST.Z m32 k xmm
//	VCVTDQ2PD.BCST.Z m32 k ymm
//	VCVTDQ2PD.BCST.Z m32 k zmm
func VCVTDQ2PD_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTDQ2PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VCVTDQ2PD_Z: Convert Packed Dword Integers to Packed Double-Precision FP Values (Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PD.Z m128 k ymm
//	VCVTDQ2PD.Z m64  k xmm
//	VCVTDQ2PD.Z xmm  k xmm
//	VCVTDQ2PD.Z xmm  k ymm
//	VCVTDQ2PD.Z m256 k zmm
//	VCVTDQ2PD.Z ymm  k zmm
func VCVTDQ2PD_Z(mxy, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTDQ2PD.Forms(), sffxs{sffxZ}, []operand.Op{mxy, k, xyz})
}

// VCVTDQ2PS: Convert Packed Dword Integers to Packed Single-Precision FP Values.
//
// Forms:
//
//	VCVTDQ2PS m128 xmm
//	VCVTDQ2PS m256 ymm
//	VCVTDQ2PS xmm  xmm
//	VCVTDQ2PS ymm  ymm
//	VCVTDQ2PS m128 k xmm
//	VCVTDQ2PS m256 k ymm
//	VCVTDQ2PS xmm  k xmm
//	VCVTDQ2PS ymm  k ymm
//	VCVTDQ2PS m512 k zmm
//	VCVTDQ2PS m512 zmm
//	VCVTDQ2PS zmm  k zmm
//	VCVTDQ2PS zmm  zmm
func VCVTDQ2PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTDQ2PS.Forms(), sffxs{}, ops)
}

// VCVTDQ2PS_BCST: Convert Packed Dword Integers to Packed Single-Precision FP Values (Broadcast).
//
// Forms:
//
//	VCVTDQ2PS.BCST m32 k xmm
//	VCVTDQ2PS.BCST m32 k ymm
//	VCVTDQ2PS.BCST m32 xmm
//	VCVTDQ2PS.BCST m32 ymm
//	VCVTDQ2PS.BCST m32 k zmm
//	VCVTDQ2PS.BCST m32 zmm
func VCVTDQ2PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTDQ2PS.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTDQ2PS_BCST_Z: Convert Packed Dword Integers to Packed Single-Precision FP Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PS.BCST.Z m32 k xmm
//	VCVTDQ2PS.BCST.Z m32 k ymm
//	VCVTDQ2PS.BCST.Z m32 k zmm
func VCVTDQ2PS_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTDQ2PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VCVTDQ2PS_RD_SAE: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTDQ2PS.RD_SAE zmm k zmm
//	VCVTDQ2PS.RD_SAE zmm zmm
func VCVTDQ2PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTDQ2PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VCVTDQ2PS_RD_SAE_Z: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PS.RD_SAE.Z zmm k zmm
func VCVTDQ2PS_RD_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTDQ2PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTDQ2PS_RN_SAE: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTDQ2PS.RN_SAE zmm k zmm
//	VCVTDQ2PS.RN_SAE zmm zmm
func VCVTDQ2PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTDQ2PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VCVTDQ2PS_RN_SAE_Z: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PS.RN_SAE.Z zmm k zmm
func VCVTDQ2PS_RN_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTDQ2PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTDQ2PS_RU_SAE: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTDQ2PS.RU_SAE zmm k zmm
//	VCVTDQ2PS.RU_SAE zmm zmm
func VCVTDQ2PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTDQ2PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VCVTDQ2PS_RU_SAE_Z: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PS.RU_SAE.Z zmm k zmm
func VCVTDQ2PS_RU_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTDQ2PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTDQ2PS_RZ_SAE: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Zero).
//
// Forms:
//
//	VCVTDQ2PS.RZ_SAE zmm k zmm
//	VCVTDQ2PS.RZ_SAE zmm zmm
func VCVTDQ2PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTDQ2PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VCVTDQ2PS_RZ_SAE_Z: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PS.RZ_SAE.Z zmm k zmm
func VCVTDQ2PS_RZ_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTDQ2PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTDQ2PS_Z: Convert Packed Dword Integers to Packed Single-Precision FP Values (Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PS.Z m128 k xmm
//	VCVTDQ2PS.Z m256 k ymm
//	VCVTDQ2PS.Z xmm  k xmm
//	VCVTDQ2PS.Z ymm  k ymm
//	VCVTDQ2PS.Z m512 k zmm
//	VCVTDQ2PS.Z zmm  k zmm
func VCVTDQ2PS_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTDQ2PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VCVTPD2DQ: Convert Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTPD2DQ m512 k ymm
//	VCVTPD2DQ m512 ymm
//	VCVTPD2DQ zmm  k ymm
//	VCVTPD2DQ zmm  ymm
func VCVTPD2DQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2DQ.Forms(), sffxs{}, ops)
}

// VCVTPD2DQX: Convert Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTPD2DQX m128 xmm
//	VCVTPD2DQX xmm  xmm
//	VCVTPD2DQX m128 k xmm
//	VCVTPD2DQX xmm  k xmm
func VCVTPD2DQX(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2DQX.Forms(), sffxs{}, ops)
}

// VCVTPD2DQX_BCST: Convert Packed Double-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2DQX.BCST m64 k xmm
//	VCVTPD2DQX.BCST m64 xmm
func VCVTPD2DQX_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2DQX.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTPD2DQX_BCST_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQX.BCST.Z m64 k xmm
func VCVTPD2DQX_BCST_Z(m, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2DQX.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, x})
}

// VCVTPD2DQX_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQX.Z m128 k xmm
//	VCVTPD2DQX.Z xmm  k xmm
func VCVTPD2DQX_Z(mx, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2DQX.Forms(), sffxs{sffxZ}, []operand.Op{mx, k, x})
}

// VCVTPD2DQY: Convert Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTPD2DQY m256 xmm
//	VCVTPD2DQY ymm  xmm
//	VCVTPD2DQY m256 k xmm
//	VCVTPD2DQY ymm  k xmm
func VCVTPD2DQY(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2DQY.Forms(), sffxs{}, ops)
}

// VCVTPD2DQY_BCST: Convert Packed Double-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2DQY.BCST m64 k xmm
//	VCVTPD2DQY.BCST m64 xmm
func VCVTPD2DQY_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2DQY.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTPD2DQY_BCST_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQY.BCST.Z m64 k xmm
func VCVTPD2DQY_BCST_Z(m, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2DQY.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, x})
}

// VCVTPD2DQY_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQY.Z m256 k xmm
//	VCVTPD2DQY.Z ymm  k xmm
func VCVTPD2DQY_Z(my, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2DQY.Forms(), sffxs{sffxZ}, []operand.Op{my, k, x})
}

// VCVTPD2DQ_BCST: Convert Packed Double-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2DQ.BCST m64 k ymm
//	VCVTPD2DQ.BCST m64 ymm
func VCVTPD2DQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2DQ.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTPD2DQ_BCST_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQ.BCST.Z m64 k ymm
func VCVTPD2DQ_BCST_Z(m, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2DQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, y})
}

// VCVTPD2DQ_RD_SAE: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPD2DQ.RD_SAE zmm k ymm
//	VCVTPD2DQ.RD_SAE zmm ymm
func VCVTPD2DQ_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2DQ.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VCVTPD2DQ_RD_SAE_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQ.RD_SAE.Z zmm k ymm
func VCVTPD2DQ_RD_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2DQ.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTPD2DQ_RN_SAE: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Nearest).
//
// Forms:
//
//	VCVTPD2DQ.RN_SAE zmm k ymm
//	VCVTPD2DQ.RN_SAE zmm ymm
func VCVTPD2DQ_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2DQ.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VCVTPD2DQ_RN_SAE_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQ.RN_SAE.Z zmm k ymm
func VCVTPD2DQ_RN_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2DQ.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTPD2DQ_RU_SAE: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPD2DQ.RU_SAE zmm k ymm
//	VCVTPD2DQ.RU_SAE zmm ymm
func VCVTPD2DQ_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2DQ.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VCVTPD2DQ_RU_SAE_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQ.RU_SAE.Z zmm k ymm
func VCVTPD2DQ_RU_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2DQ.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTPD2DQ_RZ_SAE: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Zero).
//
// Forms:
//
//	VCVTPD2DQ.RZ_SAE zmm k ymm
//	VCVTPD2DQ.RZ_SAE zmm ymm
func VCVTPD2DQ_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2DQ.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VCVTPD2DQ_RZ_SAE_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQ.RZ_SAE.Z zmm k ymm
func VCVTPD2DQ_RZ_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2DQ.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTPD2DQ_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQ.Z m512 k ymm
//	VCVTPD2DQ.Z zmm  k ymm
func VCVTPD2DQ_Z(mz, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2DQ.Forms(), sffxs{sffxZ}, []operand.Op{mz, k, y})
}

// VCVTPD2PS: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values.
//
// Forms:
//
//	VCVTPD2PS m512 k ymm
//	VCVTPD2PS m512 ymm
//	VCVTPD2PS zmm  k ymm
//	VCVTPD2PS zmm  ymm
func VCVTPD2PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2PS.Forms(), sffxs{}, ops)
}

// VCVTPD2PSX: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values.
//
// Forms:
//
//	VCVTPD2PSX m128 xmm
//	VCVTPD2PSX xmm  xmm
//	VCVTPD2PSX m128 k xmm
//	VCVTPD2PSX xmm  k xmm
func VCVTPD2PSX(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2PSX.Forms(), sffxs{}, ops)
}

// VCVTPD2PSX_BCST: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Broadcast).
//
// Forms:
//
//	VCVTPD2PSX.BCST m64 k xmm
//	VCVTPD2PSX.BCST m64 xmm
func VCVTPD2PSX_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2PSX.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTPD2PSX_BCST_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PSX.BCST.Z m64 k xmm
func VCVTPD2PSX_BCST_Z(m, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2PSX.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, x})
}

// VCVTPD2PSX_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PSX.Z m128 k xmm
//	VCVTPD2PSX.Z xmm  k xmm
func VCVTPD2PSX_Z(mx, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2PSX.Forms(), sffxs{sffxZ}, []operand.Op{mx, k, x})
}

// VCVTPD2PSY: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values.
//
// Forms:
//
//	VCVTPD2PSY m256 xmm
//	VCVTPD2PSY ymm  xmm
//	VCVTPD2PSY m256 k xmm
//	VCVTPD2PSY ymm  k xmm
func VCVTPD2PSY(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2PSY.Forms(), sffxs{}, ops)
}

// VCVTPD2PSY_BCST: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Broadcast).
//
// Forms:
//
//	VCVTPD2PSY.BCST m64 k xmm
//	VCVTPD2PSY.BCST m64 xmm
func VCVTPD2PSY_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2PSY.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTPD2PSY_BCST_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PSY.BCST.Z m64 k xmm
func VCVTPD2PSY_BCST_Z(m, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2PSY.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, x})
}

// VCVTPD2PSY_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PSY.Z m256 k xmm
//	VCVTPD2PSY.Z ymm  k xmm
func VCVTPD2PSY_Z(my, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2PSY.Forms(), sffxs{sffxZ}, []operand.Op{my, k, x})
}

// VCVTPD2PS_BCST: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Broadcast).
//
// Forms:
//
//	VCVTPD2PS.BCST m64 k ymm
//	VCVTPD2PS.BCST m64 ymm
func VCVTPD2PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2PS.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTPD2PS_BCST_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PS.BCST.Z m64 k ymm
func VCVTPD2PS_BCST_Z(m, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, y})
}

// VCVTPD2PS_RD_SAE: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPD2PS.RD_SAE zmm k ymm
//	VCVTPD2PS.RD_SAE zmm ymm
func VCVTPD2PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VCVTPD2PS_RD_SAE_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PS.RD_SAE.Z zmm k ymm
func VCVTPD2PS_RD_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTPD2PS_RN_SAE: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTPD2PS.RN_SAE zmm k ymm
//	VCVTPD2PS.RN_SAE zmm ymm
func VCVTPD2PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VCVTPD2PS_RN_SAE_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PS.RN_SAE.Z zmm k ymm
func VCVTPD2PS_RN_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTPD2PS_RU_SAE: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPD2PS.RU_SAE zmm k ymm
//	VCVTPD2PS.RU_SAE zmm ymm
func VCVTPD2PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VCVTPD2PS_RU_SAE_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PS.RU_SAE.Z zmm k ymm
func VCVTPD2PS_RU_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTPD2PS_RZ_SAE: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Zero).
//
// Forms:
//
//	VCVTPD2PS.RZ_SAE zmm k ymm
//	VCVTPD2PS.RZ_SAE zmm ymm
func VCVTPD2PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VCVTPD2PS_RZ_SAE_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PS.RZ_SAE.Z zmm k ymm
func VCVTPD2PS_RZ_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTPD2PS_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PS.Z m512 k ymm
//	VCVTPD2PS.Z zmm  k ymm
func VCVTPD2PS_Z(mz, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2PS.Forms(), sffxs{sffxZ}, []operand.Op{mz, k, y})
}

// VCVTPD2QQ: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers.
//
// Forms:
//
//	VCVTPD2QQ m128 k xmm
//	VCVTPD2QQ m128 xmm
//	VCVTPD2QQ m256 k ymm
//	VCVTPD2QQ m256 ymm
//	VCVTPD2QQ xmm  k xmm
//	VCVTPD2QQ xmm  xmm
//	VCVTPD2QQ ymm  k ymm
//	VCVTPD2QQ ymm  ymm
//	VCVTPD2QQ m512 k zmm
//	VCVTPD2QQ m512 zmm
//	VCVTPD2QQ zmm  k zmm
//	VCVTPD2QQ zmm  zmm
func VCVTPD2QQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2QQ.Forms(), sffxs{}, ops)
}

// VCVTPD2QQ_BCST: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2QQ.BCST m64 k xmm
//	VCVTPD2QQ.BCST m64 k ymm
//	VCVTPD2QQ.BCST m64 xmm
//	VCVTPD2QQ.BCST m64 ymm
//	VCVTPD2QQ.BCST m64 k zmm
//	VCVTPD2QQ.BCST m64 zmm
func VCVTPD2QQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2QQ.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTPD2QQ_BCST_Z: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2QQ.BCST.Z m64 k xmm
//	VCVTPD2QQ.BCST.Z m64 k ymm
//	VCVTPD2QQ.BCST.Z m64 k zmm
func VCVTPD2QQ_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2QQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VCVTPD2QQ_RD_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPD2QQ.RD_SAE zmm k zmm
//	VCVTPD2QQ.RD_SAE zmm zmm
func VCVTPD2QQ_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2QQ.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VCVTPD2QQ_RD_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2QQ.RD_SAE.Z zmm k zmm
func VCVTPD2QQ_RD_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2QQ.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTPD2QQ_RN_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Nearest).
//
// Forms:
//
//	VCVTPD2QQ.RN_SAE zmm k zmm
//	VCVTPD2QQ.RN_SAE zmm zmm
func VCVTPD2QQ_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2QQ.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VCVTPD2QQ_RN_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2QQ.RN_SAE.Z zmm k zmm
func VCVTPD2QQ_RN_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2QQ.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTPD2QQ_RU_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPD2QQ.RU_SAE zmm k zmm
//	VCVTPD2QQ.RU_SAE zmm zmm
func VCVTPD2QQ_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2QQ.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VCVTPD2QQ_RU_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2QQ.RU_SAE.Z zmm k zmm
func VCVTPD2QQ_RU_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2QQ.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTPD2QQ_RZ_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Zero).
//
// Forms:
//
//	VCVTPD2QQ.RZ_SAE zmm k zmm
//	VCVTPD2QQ.RZ_SAE zmm zmm
func VCVTPD2QQ_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2QQ.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VCVTPD2QQ_RZ_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2QQ.RZ_SAE.Z zmm k zmm
func VCVTPD2QQ_RZ_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2QQ.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTPD2QQ_Z: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2QQ.Z m128 k xmm
//	VCVTPD2QQ.Z m256 k ymm
//	VCVTPD2QQ.Z xmm  k xmm
//	VCVTPD2QQ.Z ymm  k ymm
//	VCVTPD2QQ.Z m512 k zmm
//	VCVTPD2QQ.Z zmm  k zmm
func VCVTPD2QQ_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2QQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VCVTPD2UDQ: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	VCVTPD2UDQ m512 k ymm
//	VCVTPD2UDQ m512 ymm
//	VCVTPD2UDQ zmm  k ymm
//	VCVTPD2UDQ zmm  ymm
func VCVTPD2UDQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UDQ.Forms(), sffxs{}, ops)
}

// VCVTPD2UDQX: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	VCVTPD2UDQX m128 k xmm
//	VCVTPD2UDQX m128 xmm
//	VCVTPD2UDQX xmm  k xmm
//	VCVTPD2UDQX xmm  xmm
func VCVTPD2UDQX(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UDQX.Forms(), sffxs{}, ops)
}

// VCVTPD2UDQX_BCST: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2UDQX.BCST m64 k xmm
//	VCVTPD2UDQX.BCST m64 xmm
func VCVTPD2UDQX_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UDQX.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTPD2UDQX_BCST_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQX.BCST.Z m64 k xmm
func VCVTPD2UDQX_BCST_Z(m, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UDQX.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, x})
}

// VCVTPD2UDQX_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQX.Z m128 k xmm
//	VCVTPD2UDQX.Z xmm  k xmm
func VCVTPD2UDQX_Z(mx, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UDQX.Forms(), sffxs{sffxZ}, []operand.Op{mx, k, x})
}

// VCVTPD2UDQY: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	VCVTPD2UDQY m256 k xmm
//	VCVTPD2UDQY m256 xmm
//	VCVTPD2UDQY ymm  k xmm
//	VCVTPD2UDQY ymm  xmm
func VCVTPD2UDQY(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UDQY.Forms(), sffxs{}, ops)
}

// VCVTPD2UDQY_BCST: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2UDQY.BCST m64 k xmm
//	VCVTPD2UDQY.BCST m64 xmm
func VCVTPD2UDQY_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UDQY.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTPD2UDQY_BCST_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQY.BCST.Z m64 k xmm
func VCVTPD2UDQY_BCST_Z(m, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UDQY.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, x})
}

// VCVTPD2UDQY_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQY.Z m256 k xmm
//	VCVTPD2UDQY.Z ymm  k xmm
func VCVTPD2UDQY_Z(my, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UDQY.Forms(), sffxs{sffxZ}, []operand.Op{my, k, x})
}

// VCVTPD2UDQ_BCST: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2UDQ.BCST m64 k ymm
//	VCVTPD2UDQ.BCST m64 ymm
func VCVTPD2UDQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UDQ.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTPD2UDQ_BCST_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQ.BCST.Z m64 k ymm
func VCVTPD2UDQ_BCST_Z(m, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UDQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, y})
}

// VCVTPD2UDQ_RD_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPD2UDQ.RD_SAE zmm k ymm
//	VCVTPD2UDQ.RD_SAE zmm ymm
func VCVTPD2UDQ_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UDQ.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VCVTPD2UDQ_RD_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQ.RD_SAE.Z zmm k ymm
func VCVTPD2UDQ_RD_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UDQ.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTPD2UDQ_RN_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Nearest).
//
// Forms:
//
//	VCVTPD2UDQ.RN_SAE zmm k ymm
//	VCVTPD2UDQ.RN_SAE zmm ymm
func VCVTPD2UDQ_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UDQ.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VCVTPD2UDQ_RN_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQ.RN_SAE.Z zmm k ymm
func VCVTPD2UDQ_RN_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UDQ.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTPD2UDQ_RU_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPD2UDQ.RU_SAE zmm k ymm
//	VCVTPD2UDQ.RU_SAE zmm ymm
func VCVTPD2UDQ_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UDQ.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VCVTPD2UDQ_RU_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQ.RU_SAE.Z zmm k ymm
func VCVTPD2UDQ_RU_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UDQ.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTPD2UDQ_RZ_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Zero).
//
// Forms:
//
//	VCVTPD2UDQ.RZ_SAE zmm k ymm
//	VCVTPD2UDQ.RZ_SAE zmm ymm
func VCVTPD2UDQ_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UDQ.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VCVTPD2UDQ_RZ_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQ.RZ_SAE.Z zmm k ymm
func VCVTPD2UDQ_RZ_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UDQ.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTPD2UDQ_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQ.Z m512 k ymm
//	VCVTPD2UDQ.Z zmm  k ymm
func VCVTPD2UDQ_Z(mz, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UDQ.Forms(), sffxs{sffxZ}, []operand.Op{mz, k, y})
}

// VCVTPD2UQQ: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers.
//
// Forms:
//
//	VCVTPD2UQQ m128 k xmm
//	VCVTPD2UQQ m128 xmm
//	VCVTPD2UQQ m256 k ymm
//	VCVTPD2UQQ m256 ymm
//	VCVTPD2UQQ xmm  k xmm
//	VCVTPD2UQQ xmm  xmm
//	VCVTPD2UQQ ymm  k ymm
//	VCVTPD2UQQ ymm  ymm
//	VCVTPD2UQQ m512 k zmm
//	VCVTPD2UQQ m512 zmm
//	VCVTPD2UQQ zmm  k zmm
//	VCVTPD2UQQ zmm  zmm
func VCVTPD2UQQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UQQ.Forms(), sffxs{}, ops)
}

// VCVTPD2UQQ_BCST: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2UQQ.BCST m64 k xmm
//	VCVTPD2UQQ.BCST m64 k ymm
//	VCVTPD2UQQ.BCST m64 xmm
//	VCVTPD2UQQ.BCST m64 ymm
//	VCVTPD2UQQ.BCST m64 k zmm
//	VCVTPD2UQQ.BCST m64 zmm
func VCVTPD2UQQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UQQ.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTPD2UQQ_BCST_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UQQ.BCST.Z m64 k xmm
//	VCVTPD2UQQ.BCST.Z m64 k ymm
//	VCVTPD2UQQ.BCST.Z m64 k zmm
func VCVTPD2UQQ_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UQQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VCVTPD2UQQ_RD_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPD2UQQ.RD_SAE zmm k zmm
//	VCVTPD2UQQ.RD_SAE zmm zmm
func VCVTPD2UQQ_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UQQ.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VCVTPD2UQQ_RD_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UQQ.RD_SAE.Z zmm k zmm
func VCVTPD2UQQ_RD_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UQQ.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTPD2UQQ_RN_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Nearest).
//
// Forms:
//
//	VCVTPD2UQQ.RN_SAE zmm k zmm
//	VCVTPD2UQQ.RN_SAE zmm zmm
func VCVTPD2UQQ_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UQQ.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VCVTPD2UQQ_RN_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UQQ.RN_SAE.Z zmm k zmm
func VCVTPD2UQQ_RN_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UQQ.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTPD2UQQ_RU_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPD2UQQ.RU_SAE zmm k zmm
//	VCVTPD2UQQ.RU_SAE zmm zmm
func VCVTPD2UQQ_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UQQ.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VCVTPD2UQQ_RU_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UQQ.RU_SAE.Z zmm k zmm
func VCVTPD2UQQ_RU_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UQQ.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTPD2UQQ_RZ_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Zero).
//
// Forms:
//
//	VCVTPD2UQQ.RZ_SAE zmm k zmm
//	VCVTPD2UQQ.RZ_SAE zmm zmm
func VCVTPD2UQQ_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UQQ.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VCVTPD2UQQ_RZ_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UQQ.RZ_SAE.Z zmm k zmm
func VCVTPD2UQQ_RZ_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UQQ.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTPD2UQQ_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UQQ.Z m128 k xmm
//	VCVTPD2UQQ.Z m256 k ymm
//	VCVTPD2UQQ.Z xmm  k xmm
//	VCVTPD2UQQ.Z ymm  k ymm
//	VCVTPD2UQQ.Z m512 k zmm
//	VCVTPD2UQQ.Z zmm  k zmm
func VCVTPD2UQQ_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPD2UQQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VCVTPH2PS: Convert Half-Precision FP Values to Single-Precision FP Values.
//
// Forms:
//
//	VCVTPH2PS m128 ymm
//	VCVTPH2PS m64  xmm
//	VCVTPH2PS xmm  xmm
//	VCVTPH2PS xmm  ymm
//	VCVTPH2PS m128 k ymm
//	VCVTPH2PS m64  k xmm
//	VCVTPH2PS xmm  k xmm
//	VCVTPH2PS xmm  k ymm
//	VCVTPH2PS m256 k zmm
//	VCVTPH2PS m256 zmm
//	VCVTPH2PS ymm  k zmm
//	VCVTPH2PS ymm  zmm
func VCVTPH2PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPH2PS.Forms(), sffxs{}, ops)
}

// VCVTPH2PS_SAE: Convert Half-Precision FP Values to Single-Precision FP Values (Suppress All Exceptions).
//
// Forms:
//
//	VCVTPH2PS.SAE ymm k zmm
//	VCVTPH2PS.SAE ymm zmm
func VCVTPH2PS_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPH2PS.Forms(), sffxs{sffxSAE}, ops)
}

// VCVTPH2PS_SAE_Z: Convert Half-Precision FP Values to Single-Precision FP Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTPH2PS.SAE.Z ymm k zmm
func VCVTPH2PS_SAE_Z(y, k, z operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPH2PS.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{y, k, z})
}

// VCVTPH2PS_Z: Convert Half-Precision FP Values to Single-Precision FP Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPH2PS.Z m128 k ymm
//	VCVTPH2PS.Z m64  k xmm
//	VCVTPH2PS.Z xmm  k xmm
//	VCVTPH2PS.Z xmm  k ymm
//	VCVTPH2PS.Z m256 k zmm
//	VCVTPH2PS.Z ymm  k zmm
func VCVTPH2PS_Z(mxy, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPH2PS.Forms(), sffxs{sffxZ}, []operand.Op{mxy, k, xyz})
}

// VCVTPS2DQ: Convert Packed Single-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTPS2DQ m128 xmm
//	VCVTPS2DQ m256 ymm
//	VCVTPS2DQ xmm  xmm
//	VCVTPS2DQ ymm  ymm
//	VCVTPS2DQ m128 k xmm
//	VCVTPS2DQ m256 k ymm
//	VCVTPS2DQ xmm  k xmm
//	VCVTPS2DQ ymm  k ymm
//	VCVTPS2DQ m512 k zmm
//	VCVTPS2DQ m512 zmm
//	VCVTPS2DQ zmm  k zmm
//	VCVTPS2DQ zmm  zmm
func VCVTPS2DQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2DQ.Forms(), sffxs{}, ops)
}

// VCVTPS2DQ_BCST: Convert Packed Single-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTPS2DQ.BCST m32 k xmm
//	VCVTPS2DQ.BCST m32 k ymm
//	VCVTPS2DQ.BCST m32 xmm
//	VCVTPS2DQ.BCST m32 ymm
//	VCVTPS2DQ.BCST m32 k zmm
//	VCVTPS2DQ.BCST m32 zmm
func VCVTPS2DQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2DQ.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTPS2DQ_BCST_Z: Convert Packed Single-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2DQ.BCST.Z m32 k xmm
//	VCVTPS2DQ.BCST.Z m32 k ymm
//	VCVTPS2DQ.BCST.Z m32 k zmm
func VCVTPS2DQ_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2DQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VCVTPS2DQ_RD_SAE: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPS2DQ.RD_SAE zmm k zmm
//	VCVTPS2DQ.RD_SAE zmm zmm
func VCVTPS2DQ_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2DQ.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VCVTPS2DQ_RD_SAE_Z: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2DQ.RD_SAE.Z zmm k zmm
func VCVTPS2DQ_RD_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2DQ.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTPS2DQ_RN_SAE: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Nearest).
//
// Forms:
//
//	VCVTPS2DQ.RN_SAE zmm k zmm
//	VCVTPS2DQ.RN_SAE zmm zmm
func VCVTPS2DQ_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2DQ.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VCVTPS2DQ_RN_SAE_Z: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2DQ.RN_SAE.Z zmm k zmm
func VCVTPS2DQ_RN_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2DQ.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTPS2DQ_RU_SAE: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPS2DQ.RU_SAE zmm k zmm
//	VCVTPS2DQ.RU_SAE zmm zmm
func VCVTPS2DQ_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2DQ.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VCVTPS2DQ_RU_SAE_Z: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2DQ.RU_SAE.Z zmm k zmm
func VCVTPS2DQ_RU_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2DQ.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTPS2DQ_RZ_SAE: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Zero).
//
// Forms:
//
//	VCVTPS2DQ.RZ_SAE zmm k zmm
//	VCVTPS2DQ.RZ_SAE zmm zmm
func VCVTPS2DQ_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2DQ.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VCVTPS2DQ_RZ_SAE_Z: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2DQ.RZ_SAE.Z zmm k zmm
func VCVTPS2DQ_RZ_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2DQ.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTPS2DQ_Z: Convert Packed Single-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPS2DQ.Z m128 k xmm
//	VCVTPS2DQ.Z m256 k ymm
//	VCVTPS2DQ.Z xmm  k xmm
//	VCVTPS2DQ.Z ymm  k ymm
//	VCVTPS2DQ.Z m512 k zmm
//	VCVTPS2DQ.Z zmm  k zmm
func VCVTPS2DQ_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2DQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VCVTPS2PD: Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values.
//
// Forms:
//
//	VCVTPS2PD m128 ymm
//	VCVTPS2PD m64  xmm
//	VCVTPS2PD xmm  xmm
//	VCVTPS2PD xmm  ymm
//	VCVTPS2PD m64  k xmm
//	VCVTPS2PD xmm  k xmm
//	VCVTPS2PD m256 k zmm
//	VCVTPS2PD m256 zmm
//	VCVTPS2PD ymm  k zmm
//	VCVTPS2PD ymm  zmm
//	VCVTPS2PD m128 k ymm
//	VCVTPS2PD xmm  k ymm
func VCVTPS2PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2PD.Forms(), sffxs{}, ops)
}

// VCVTPS2PD_BCST: Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values (Broadcast).
//
// Forms:
//
//	VCVTPS2PD.BCST m32 k xmm
//	VCVTPS2PD.BCST m32 xmm
//	VCVTPS2PD.BCST m32 k zmm
//	VCVTPS2PD.BCST m32 zmm
//	VCVTPS2PD.BCST m32 k ymm
//	VCVTPS2PD.BCST m32 ymm
func VCVTPS2PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2PD.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTPS2PD_BCST_Z: Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2PD.BCST.Z m32 k xmm
//	VCVTPS2PD.BCST.Z m32 k zmm
//	VCVTPS2PD.BCST.Z m32 k ymm
func VCVTPS2PD_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VCVTPS2PD_SAE: Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values (Suppress All Exceptions).
//
// Forms:
//
//	VCVTPS2PD.SAE ymm k zmm
//	VCVTPS2PD.SAE ymm zmm
func VCVTPS2PD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2PD.Forms(), sffxs{sffxSAE}, ops)
}

// VCVTPS2PD_SAE_Z: Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2PD.SAE.Z ymm k zmm
func VCVTPS2PD_SAE_Z(y, k, z operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2PD.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{y, k, z})
}

// VCVTPS2PD_Z: Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPS2PD.Z m64  k xmm
//	VCVTPS2PD.Z xmm  k xmm
//	VCVTPS2PD.Z m256 k zmm
//	VCVTPS2PD.Z ymm  k zmm
//	VCVTPS2PD.Z m128 k ymm
//	VCVTPS2PD.Z xmm  k ymm
func VCVTPS2PD_Z(mxy, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2PD.Forms(), sffxs{sffxZ}, []operand.Op{mxy, k, xyz})
}

// VCVTPS2PH: Convert Single-Precision FP value to Half-Precision FP value.
//
// Forms:
//
//	VCVTPS2PH imm8 xmm m64
//	VCVTPS2PH imm8 xmm xmm
//	VCVTPS2PH imm8 ymm m128
//	VCVTPS2PH imm8 ymm xmm
//	VCVTPS2PH imm8 xmm k m64
//	VCVTPS2PH imm8 xmm k xmm
//	VCVTPS2PH imm8 ymm k m128
//	VCVTPS2PH imm8 ymm k xmm
//	VCVTPS2PH imm8 zmm k m256
//	VCVTPS2PH imm8 zmm k ymm
//	VCVTPS2PH imm8 zmm m256
//	VCVTPS2PH imm8 zmm ymm
func VCVTPS2PH(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2PH.Forms(), sffxs{}, ops)
}

// VCVTPS2PH_SAE: Convert Single-Precision FP value to Half-Precision FP value (Suppress All Exceptions).
//
// Forms:
//
//	VCVTPS2PH.SAE imm8 zmm k ymm
//	VCVTPS2PH.SAE imm8 zmm ymm
func VCVTPS2PH_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2PH.Forms(), sffxs{sffxSAE}, ops)
}

// VCVTPS2PH_SAE_Z: Convert Single-Precision FP value to Half-Precision FP value (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2PH.SAE.Z imm8 zmm k ymm
func VCVTPS2PH_SAE_Z(i, z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2PH.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{i, z, k, y})
}

// VCVTPS2PH_Z: Convert Single-Precision FP value to Half-Precision FP value (Zeroing Masking).
//
// Forms:
//
//	VCVTPS2PH.Z imm8 xmm k m64
//	VCVTPS2PH.Z imm8 xmm k xmm
//	VCVTPS2PH.Z imm8 ymm k m128
//	VCVTPS2PH.Z imm8 ymm k xmm
//	VCVTPS2PH.Z imm8 zmm k m256
//	VCVTPS2PH.Z imm8 zmm k ymm
func VCVTPS2PH_Z(i, xyz, k, mxy operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2PH.Forms(), sffxs{sffxZ}, []operand.Op{i, xyz, k, mxy})
}

// VCVTPS2QQ: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values.
//
// Forms:
//
//	VCVTPS2QQ m128 k ymm
//	VCVTPS2QQ m128 ymm
//	VCVTPS2QQ m64  k xmm
//	VCVTPS2QQ m64  xmm
//	VCVTPS2QQ xmm  k xmm
//	VCVTPS2QQ xmm  k ymm
//	VCVTPS2QQ xmm  xmm
//	VCVTPS2QQ xmm  ymm
//	VCVTPS2QQ m256 k zmm
//	VCVTPS2QQ m256 zmm
//	VCVTPS2QQ ymm  k zmm
//	VCVTPS2QQ ymm  zmm
func VCVTPS2QQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2QQ.Forms(), sffxs{}, ops)
}

// VCVTPS2QQ_BCST: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Broadcast).
//
// Forms:
//
//	VCVTPS2QQ.BCST m32 k xmm
//	VCVTPS2QQ.BCST m32 k ymm
//	VCVTPS2QQ.BCST m32 xmm
//	VCVTPS2QQ.BCST m32 ymm
//	VCVTPS2QQ.BCST m32 k zmm
//	VCVTPS2QQ.BCST m32 zmm
func VCVTPS2QQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2QQ.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTPS2QQ_BCST_Z: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2QQ.BCST.Z m32 k xmm
//	VCVTPS2QQ.BCST.Z m32 k ymm
//	VCVTPS2QQ.BCST.Z m32 k zmm
func VCVTPS2QQ_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2QQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VCVTPS2QQ_RD_SAE: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPS2QQ.RD_SAE ymm k zmm
//	VCVTPS2QQ.RD_SAE ymm zmm
func VCVTPS2QQ_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2QQ.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VCVTPS2QQ_RD_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2QQ.RD_SAE.Z ymm k zmm
func VCVTPS2QQ_RD_SAE_Z(y, k, z operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2QQ.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{y, k, z})
}

// VCVTPS2QQ_RN_SAE: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTPS2QQ.RN_SAE ymm k zmm
//	VCVTPS2QQ.RN_SAE ymm zmm
func VCVTPS2QQ_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2QQ.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VCVTPS2QQ_RN_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2QQ.RN_SAE.Z ymm k zmm
func VCVTPS2QQ_RN_SAE_Z(y, k, z operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2QQ.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{y, k, z})
}

// VCVTPS2QQ_RU_SAE: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPS2QQ.RU_SAE ymm k zmm
//	VCVTPS2QQ.RU_SAE ymm zmm
func VCVTPS2QQ_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2QQ.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VCVTPS2QQ_RU_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2QQ.RU_SAE.Z ymm k zmm
func VCVTPS2QQ_RU_SAE_Z(y, k, z operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2QQ.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{y, k, z})
}

// VCVTPS2QQ_RZ_SAE: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Zero).
//
// Forms:
//
//	VCVTPS2QQ.RZ_SAE ymm k zmm
//	VCVTPS2QQ.RZ_SAE ymm zmm
func VCVTPS2QQ_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2QQ.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VCVTPS2QQ_RZ_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2QQ.RZ_SAE.Z ymm k zmm
func VCVTPS2QQ_RZ_SAE_Z(y, k, z operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2QQ.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{y, k, z})
}

// VCVTPS2QQ_Z: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPS2QQ.Z m128 k ymm
//	VCVTPS2QQ.Z m64  k xmm
//	VCVTPS2QQ.Z xmm  k xmm
//	VCVTPS2QQ.Z xmm  k ymm
//	VCVTPS2QQ.Z m256 k zmm
//	VCVTPS2QQ.Z ymm  k zmm
func VCVTPS2QQ_Z(mxy, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2QQ.Forms(), sffxs{sffxZ}, []operand.Op{mxy, k, xyz})
}

// VCVTPS2UDQ: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values.
//
// Forms:
//
//	VCVTPS2UDQ m128 k xmm
//	VCVTPS2UDQ m128 xmm
//	VCVTPS2UDQ m256 k ymm
//	VCVTPS2UDQ m256 ymm
//	VCVTPS2UDQ xmm  k xmm
//	VCVTPS2UDQ xmm  xmm
//	VCVTPS2UDQ ymm  k ymm
//	VCVTPS2UDQ ymm  ymm
//	VCVTPS2UDQ m512 k zmm
//	VCVTPS2UDQ m512 zmm
//	VCVTPS2UDQ zmm  k zmm
//	VCVTPS2UDQ zmm  zmm
func VCVTPS2UDQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UDQ.Forms(), sffxs{}, ops)
}

// VCVTPS2UDQ_BCST: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Broadcast).
//
// Forms:
//
//	VCVTPS2UDQ.BCST m32 k xmm
//	VCVTPS2UDQ.BCST m32 k ymm
//	VCVTPS2UDQ.BCST m32 xmm
//	VCVTPS2UDQ.BCST m32 ymm
//	VCVTPS2UDQ.BCST m32 k zmm
//	VCVTPS2UDQ.BCST m32 zmm
func VCVTPS2UDQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UDQ.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTPS2UDQ_BCST_Z: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UDQ.BCST.Z m32 k xmm
//	VCVTPS2UDQ.BCST.Z m32 k ymm
//	VCVTPS2UDQ.BCST.Z m32 k zmm
func VCVTPS2UDQ_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UDQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VCVTPS2UDQ_RD_SAE: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPS2UDQ.RD_SAE zmm k zmm
//	VCVTPS2UDQ.RD_SAE zmm zmm
func VCVTPS2UDQ_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UDQ.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VCVTPS2UDQ_RD_SAE_Z: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UDQ.RD_SAE.Z zmm k zmm
func VCVTPS2UDQ_RD_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UDQ.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTPS2UDQ_RN_SAE: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTPS2UDQ.RN_SAE zmm k zmm
//	VCVTPS2UDQ.RN_SAE zmm zmm
func VCVTPS2UDQ_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UDQ.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VCVTPS2UDQ_RN_SAE_Z: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UDQ.RN_SAE.Z zmm k zmm
func VCVTPS2UDQ_RN_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UDQ.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTPS2UDQ_RU_SAE: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPS2UDQ.RU_SAE zmm k zmm
//	VCVTPS2UDQ.RU_SAE zmm zmm
func VCVTPS2UDQ_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UDQ.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VCVTPS2UDQ_RU_SAE_Z: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UDQ.RU_SAE.Z zmm k zmm
func VCVTPS2UDQ_RU_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UDQ.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTPS2UDQ_RZ_SAE: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Zero).
//
// Forms:
//
//	VCVTPS2UDQ.RZ_SAE zmm k zmm
//	VCVTPS2UDQ.RZ_SAE zmm zmm
func VCVTPS2UDQ_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UDQ.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VCVTPS2UDQ_RZ_SAE_Z: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UDQ.RZ_SAE.Z zmm k zmm
func VCVTPS2UDQ_RZ_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UDQ.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTPS2UDQ_Z: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UDQ.Z m128 k xmm
//	VCVTPS2UDQ.Z m256 k ymm
//	VCVTPS2UDQ.Z xmm  k xmm
//	VCVTPS2UDQ.Z ymm  k ymm
//	VCVTPS2UDQ.Z m512 k zmm
//	VCVTPS2UDQ.Z zmm  k zmm
func VCVTPS2UDQ_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UDQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VCVTPS2UQQ: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values.
//
// Forms:
//
//	VCVTPS2UQQ m128 k ymm
//	VCVTPS2UQQ m128 ymm
//	VCVTPS2UQQ m64  k xmm
//	VCVTPS2UQQ m64  xmm
//	VCVTPS2UQQ xmm  k xmm
//	VCVTPS2UQQ xmm  k ymm
//	VCVTPS2UQQ xmm  xmm
//	VCVTPS2UQQ xmm  ymm
//	VCVTPS2UQQ m256 k zmm
//	VCVTPS2UQQ m256 zmm
//	VCVTPS2UQQ ymm  k zmm
//	VCVTPS2UQQ ymm  zmm
func VCVTPS2UQQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UQQ.Forms(), sffxs{}, ops)
}

// VCVTPS2UQQ_BCST: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Broadcast).
//
// Forms:
//
//	VCVTPS2UQQ.BCST m32 k xmm
//	VCVTPS2UQQ.BCST m32 k ymm
//	VCVTPS2UQQ.BCST m32 xmm
//	VCVTPS2UQQ.BCST m32 ymm
//	VCVTPS2UQQ.BCST m32 k zmm
//	VCVTPS2UQQ.BCST m32 zmm
func VCVTPS2UQQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UQQ.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTPS2UQQ_BCST_Z: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UQQ.BCST.Z m32 k xmm
//	VCVTPS2UQQ.BCST.Z m32 k ymm
//	VCVTPS2UQQ.BCST.Z m32 k zmm
func VCVTPS2UQQ_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UQQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VCVTPS2UQQ_RD_SAE: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPS2UQQ.RD_SAE ymm k zmm
//	VCVTPS2UQQ.RD_SAE ymm zmm
func VCVTPS2UQQ_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UQQ.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VCVTPS2UQQ_RD_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UQQ.RD_SAE.Z ymm k zmm
func VCVTPS2UQQ_RD_SAE_Z(y, k, z operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UQQ.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{y, k, z})
}

// VCVTPS2UQQ_RN_SAE: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTPS2UQQ.RN_SAE ymm k zmm
//	VCVTPS2UQQ.RN_SAE ymm zmm
func VCVTPS2UQQ_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UQQ.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VCVTPS2UQQ_RN_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UQQ.RN_SAE.Z ymm k zmm
func VCVTPS2UQQ_RN_SAE_Z(y, k, z operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UQQ.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{y, k, z})
}

// VCVTPS2UQQ_RU_SAE: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPS2UQQ.RU_SAE ymm k zmm
//	VCVTPS2UQQ.RU_SAE ymm zmm
func VCVTPS2UQQ_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UQQ.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VCVTPS2UQQ_RU_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UQQ.RU_SAE.Z ymm k zmm
func VCVTPS2UQQ_RU_SAE_Z(y, k, z operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UQQ.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{y, k, z})
}

// VCVTPS2UQQ_RZ_SAE: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Zero).
//
// Forms:
//
//	VCVTPS2UQQ.RZ_SAE ymm k zmm
//	VCVTPS2UQQ.RZ_SAE ymm zmm
func VCVTPS2UQQ_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UQQ.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VCVTPS2UQQ_RZ_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UQQ.RZ_SAE.Z ymm k zmm
func VCVTPS2UQQ_RZ_SAE_Z(y, k, z operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UQQ.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{y, k, z})
}

// VCVTPS2UQQ_Z: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UQQ.Z m128 k ymm
//	VCVTPS2UQQ.Z m64  k xmm
//	VCVTPS2UQQ.Z xmm  k xmm
//	VCVTPS2UQQ.Z xmm  k ymm
//	VCVTPS2UQQ.Z m256 k zmm
//	VCVTPS2UQQ.Z ymm  k zmm
func VCVTPS2UQQ_Z(mxy, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTPS2UQQ.Forms(), sffxs{sffxZ}, []operand.Op{mxy, k, xyz})
}

// VCVTQQ2PD: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTQQ2PD m128 k xmm
//	VCVTQQ2PD m128 xmm
//	VCVTQQ2PD m256 k ymm
//	VCVTQQ2PD m256 ymm
//	VCVTQQ2PD xmm  k xmm
//	VCVTQQ2PD xmm  xmm
//	VCVTQQ2PD ymm  k ymm
//	VCVTQQ2PD ymm  ymm
//	VCVTQQ2PD m512 k zmm
//	VCVTQQ2PD m512 zmm
//	VCVTQQ2PD zmm  k zmm
//	VCVTQQ2PD zmm  zmm
func VCVTQQ2PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PD.Forms(), sffxs{}, ops)
}

// VCVTQQ2PD_BCST: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTQQ2PD.BCST m64 k xmm
//	VCVTQQ2PD.BCST m64 k ymm
//	VCVTQQ2PD.BCST m64 xmm
//	VCVTQQ2PD.BCST m64 ymm
//	VCVTQQ2PD.BCST m64 k zmm
//	VCVTQQ2PD.BCST m64 zmm
func VCVTQQ2PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PD.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTQQ2PD_BCST_Z: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PD.BCST.Z m64 k xmm
//	VCVTQQ2PD.BCST.Z m64 k ymm
//	VCVTQQ2PD.BCST.Z m64 k zmm
func VCVTQQ2PD_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VCVTQQ2PD_RD_SAE: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTQQ2PD.RD_SAE zmm k zmm
//	VCVTQQ2PD.RD_SAE zmm zmm
func VCVTQQ2PD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VCVTQQ2PD_RD_SAE_Z: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PD.RD_SAE.Z zmm k zmm
func VCVTQQ2PD_RD_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTQQ2PD_RN_SAE: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTQQ2PD.RN_SAE zmm k zmm
//	VCVTQQ2PD.RN_SAE zmm zmm
func VCVTQQ2PD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VCVTQQ2PD_RN_SAE_Z: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PD.RN_SAE.Z zmm k zmm
func VCVTQQ2PD_RN_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTQQ2PD_RU_SAE: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTQQ2PD.RU_SAE zmm k zmm
//	VCVTQQ2PD.RU_SAE zmm zmm
func VCVTQQ2PD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VCVTQQ2PD_RU_SAE_Z: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PD.RU_SAE.Z zmm k zmm
func VCVTQQ2PD_RU_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTQQ2PD_RZ_SAE: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VCVTQQ2PD.RZ_SAE zmm k zmm
//	VCVTQQ2PD.RZ_SAE zmm zmm
func VCVTQQ2PD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VCVTQQ2PD_RZ_SAE_Z: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PD.RZ_SAE.Z zmm k zmm
func VCVTQQ2PD_RZ_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTQQ2PD_Z: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PD.Z m128 k xmm
//	VCVTQQ2PD.Z m256 k ymm
//	VCVTQQ2PD.Z xmm  k xmm
//	VCVTQQ2PD.Z ymm  k ymm
//	VCVTQQ2PD.Z m512 k zmm
//	VCVTQQ2PD.Z zmm  k zmm
func VCVTQQ2PD_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VCVTQQ2PS: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTQQ2PS m512 k ymm
//	VCVTQQ2PS m512 ymm
//	VCVTQQ2PS zmm  k ymm
//	VCVTQQ2PS zmm  ymm
func VCVTQQ2PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PS.Forms(), sffxs{}, ops)
}

// VCVTQQ2PSX: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTQQ2PSX m128 k xmm
//	VCVTQQ2PSX m128 xmm
//	VCVTQQ2PSX xmm  k xmm
//	VCVTQQ2PSX xmm  xmm
func VCVTQQ2PSX(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PSX.Forms(), sffxs{}, ops)
}

// VCVTQQ2PSX_BCST: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTQQ2PSX.BCST m64 k xmm
//	VCVTQQ2PSX.BCST m64 xmm
func VCVTQQ2PSX_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PSX.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTQQ2PSX_BCST_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PSX.BCST.Z m64 k xmm
func VCVTQQ2PSX_BCST_Z(m, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PSX.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, x})
}

// VCVTQQ2PSX_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PSX.Z m128 k xmm
//	VCVTQQ2PSX.Z xmm  k xmm
func VCVTQQ2PSX_Z(mx, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PSX.Forms(), sffxs{sffxZ}, []operand.Op{mx, k, x})
}

// VCVTQQ2PSY: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTQQ2PSY m256 k xmm
//	VCVTQQ2PSY m256 xmm
//	VCVTQQ2PSY ymm  k xmm
//	VCVTQQ2PSY ymm  xmm
func VCVTQQ2PSY(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PSY.Forms(), sffxs{}, ops)
}

// VCVTQQ2PSY_BCST: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTQQ2PSY.BCST m64 k xmm
//	VCVTQQ2PSY.BCST m64 xmm
func VCVTQQ2PSY_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PSY.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTQQ2PSY_BCST_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PSY.BCST.Z m64 k xmm
func VCVTQQ2PSY_BCST_Z(m, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PSY.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, x})
}

// VCVTQQ2PSY_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PSY.Z m256 k xmm
//	VCVTQQ2PSY.Z ymm  k xmm
func VCVTQQ2PSY_Z(my, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PSY.Forms(), sffxs{sffxZ}, []operand.Op{my, k, x})
}

// VCVTQQ2PS_BCST: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTQQ2PS.BCST m64 k ymm
//	VCVTQQ2PS.BCST m64 ymm
func VCVTQQ2PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PS.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTQQ2PS_BCST_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PS.BCST.Z m64 k ymm
func VCVTQQ2PS_BCST_Z(m, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, y})
}

// VCVTQQ2PS_RD_SAE: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTQQ2PS.RD_SAE zmm k ymm
//	VCVTQQ2PS.RD_SAE zmm ymm
func VCVTQQ2PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VCVTQQ2PS_RD_SAE_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PS.RD_SAE.Z zmm k ymm
func VCVTQQ2PS_RD_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTQQ2PS_RN_SAE: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTQQ2PS.RN_SAE zmm k ymm
//	VCVTQQ2PS.RN_SAE zmm ymm
func VCVTQQ2PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VCVTQQ2PS_RN_SAE_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PS.RN_SAE.Z zmm k ymm
func VCVTQQ2PS_RN_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTQQ2PS_RU_SAE: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTQQ2PS.RU_SAE zmm k ymm
//	VCVTQQ2PS.RU_SAE zmm ymm
func VCVTQQ2PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VCVTQQ2PS_RU_SAE_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PS.RU_SAE.Z zmm k ymm
func VCVTQQ2PS_RU_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTQQ2PS_RZ_SAE: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VCVTQQ2PS.RZ_SAE zmm k ymm
//	VCVTQQ2PS.RZ_SAE zmm ymm
func VCVTQQ2PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VCVTQQ2PS_RZ_SAE_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PS.RZ_SAE.Z zmm k ymm
func VCVTQQ2PS_RZ_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTQQ2PS_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PS.Z m512 k ymm
//	VCVTQQ2PS.Z zmm  k ymm
func VCVTQQ2PS_Z(mz, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTQQ2PS.Forms(), sffxs{sffxZ}, []operand.Op{mz, k, y})
}

// VCVTSD2SI: Convert Scalar Double-Precision FP Value to Integer.
//
// Forms:
//
//	VCVTSD2SI m64 r32
//	VCVTSD2SI xmm r32
func VCVTSD2SI(mx, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2SI.Forms(), sffxs{}, []operand.Op{mx, r})
}

// VCVTSD2SIQ: Convert Scalar Double-Precision FP Value to Integer.
//
// Forms:
//
//	VCVTSD2SIQ m64 r64
//	VCVTSD2SIQ xmm r64
func VCVTSD2SIQ(mx, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2SIQ.Forms(), sffxs{}, []operand.Op{mx, r})
}

// VCVTSD2SIQ_RD_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSD2SIQ.RD_SAE xmm r64
func VCVTSD2SIQ_RD_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2SIQ.Forms(), sffxs{sffxRD_SAE}, []operand.Op{x, r})
}

// VCVTSD2SIQ_RN_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSD2SIQ.RN_SAE xmm r64
func VCVTSD2SIQ_RN_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2SIQ.Forms(), sffxs{sffxRN_SAE}, []operand.Op{x, r})
}

// VCVTSD2SIQ_RU_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSD2SIQ.RU_SAE xmm r64
func VCVTSD2SIQ_RU_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2SIQ.Forms(), sffxs{sffxRU_SAE}, []operand.Op{x, r})
}

// VCVTSD2SIQ_RZ_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSD2SIQ.RZ_SAE xmm r64
func VCVTSD2SIQ_RZ_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2SIQ.Forms(), sffxs{sffxRZ_SAE}, []operand.Op{x, r})
}

// VCVTSD2SI_RD_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSD2SI.RD_SAE xmm r32
func VCVTSD2SI_RD_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2SI.Forms(), sffxs{sffxRD_SAE}, []operand.Op{x, r})
}

// VCVTSD2SI_RN_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSD2SI.RN_SAE xmm r32
func VCVTSD2SI_RN_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2SI.Forms(), sffxs{sffxRN_SAE}, []operand.Op{x, r})
}

// VCVTSD2SI_RU_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSD2SI.RU_SAE xmm r32
func VCVTSD2SI_RU_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2SI.Forms(), sffxs{sffxRU_SAE}, []operand.Op{x, r})
}

// VCVTSD2SI_RZ_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSD2SI.RZ_SAE xmm r32
func VCVTSD2SI_RZ_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2SI.Forms(), sffxs{sffxRZ_SAE}, []operand.Op{x, r})
}

// VCVTSD2SS: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value.
//
// Forms:
//
//	VCVTSD2SS m64 xmm xmm
//	VCVTSD2SS xmm xmm xmm
//	VCVTSD2SS m64 xmm k xmm
//	VCVTSD2SS xmm xmm k xmm
func VCVTSD2SS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2SS.Forms(), sffxs{}, ops)
}

// VCVTSD2SS_RD_SAE: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSD2SS.RD_SAE xmm xmm k xmm
//	VCVTSD2SS.RD_SAE xmm xmm xmm
func VCVTSD2SS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2SS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VCVTSD2SS_RD_SAE_Z: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTSD2SS.RD_SAE.Z xmm xmm k xmm
func VCVTSD2SS_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2SS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VCVTSD2SS_RN_SAE: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Nearest).
//
// Forms:
//
//	VCVTSD2SS.RN_SAE xmm xmm k xmm
//	VCVTSD2SS.RN_SAE xmm xmm xmm
func VCVTSD2SS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2SS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VCVTSD2SS_RN_SAE_Z: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTSD2SS.RN_SAE.Z xmm xmm k xmm
func VCVTSD2SS_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2SS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VCVTSD2SS_RU_SAE: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSD2SS.RU_SAE xmm xmm k xmm
//	VCVTSD2SS.RU_SAE xmm xmm xmm
func VCVTSD2SS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2SS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VCVTSD2SS_RU_SAE_Z: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTSD2SS.RU_SAE.Z xmm xmm k xmm
func VCVTSD2SS_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2SS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VCVTSD2SS_RZ_SAE: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Zero).
//
// Forms:
//
//	VCVTSD2SS.RZ_SAE xmm xmm k xmm
//	VCVTSD2SS.RZ_SAE xmm xmm xmm
func VCVTSD2SS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2SS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VCVTSD2SS_RZ_SAE_Z: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTSD2SS.RZ_SAE.Z xmm xmm k xmm
func VCVTSD2SS_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2SS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VCVTSD2SS_Z: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Zeroing Masking).
//
// Forms:
//
//	VCVTSD2SS.Z m64 xmm k xmm
//	VCVTSD2SS.Z xmm xmm k xmm
func VCVTSD2SS_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2SS.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VCVTSD2USIL: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer.
//
// Forms:
//
//	VCVTSD2USIL m64 r32
//	VCVTSD2USIL xmm r32
func VCVTSD2USIL(mx, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2USIL.Forms(), sffxs{}, []operand.Op{mx, r})
}

// VCVTSD2USIL_RD_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSD2USIL.RD_SAE xmm r32
func VCVTSD2USIL_RD_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2USIL.Forms(), sffxs{sffxRD_SAE}, []operand.Op{x, r})
}

// VCVTSD2USIL_RN_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSD2USIL.RN_SAE xmm r32
func VCVTSD2USIL_RN_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2USIL.Forms(), sffxs{sffxRN_SAE}, []operand.Op{x, r})
}

// VCVTSD2USIL_RU_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSD2USIL.RU_SAE xmm r32
func VCVTSD2USIL_RU_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2USIL.Forms(), sffxs{sffxRU_SAE}, []operand.Op{x, r})
}

// VCVTSD2USIL_RZ_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSD2USIL.RZ_SAE xmm r32
func VCVTSD2USIL_RZ_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2USIL.Forms(), sffxs{sffxRZ_SAE}, []operand.Op{x, r})
}

// VCVTSD2USIQ: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer.
//
// Forms:
//
//	VCVTSD2USIQ m64 r64
//	VCVTSD2USIQ xmm r64
func VCVTSD2USIQ(mx, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2USIQ.Forms(), sffxs{}, []operand.Op{mx, r})
}

// VCVTSD2USIQ_RD_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSD2USIQ.RD_SAE xmm r64
func VCVTSD2USIQ_RD_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2USIQ.Forms(), sffxs{sffxRD_SAE}, []operand.Op{x, r})
}

// VCVTSD2USIQ_RN_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSD2USIQ.RN_SAE xmm r64
func VCVTSD2USIQ_RN_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2USIQ.Forms(), sffxs{sffxRN_SAE}, []operand.Op{x, r})
}

// VCVTSD2USIQ_RU_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSD2USIQ.RU_SAE xmm r64
func VCVTSD2USIQ_RU_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2USIQ.Forms(), sffxs{sffxRU_SAE}, []operand.Op{x, r})
}

// VCVTSD2USIQ_RZ_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSD2USIQ.RZ_SAE xmm r64
func VCVTSD2USIQ_RZ_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSD2USIQ.Forms(), sffxs{sffxRZ_SAE}, []operand.Op{x, r})
}

// VCVTSI2SDL: Convert Dword Integer to Scalar Double-Precision FP Value.
//
// Forms:
//
//	VCVTSI2SDL m32 xmm xmm
//	VCVTSI2SDL r32 xmm xmm
func VCVTSI2SDL(mr, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSI2SDL.Forms(), sffxs{}, []operand.Op{mr, x, x1})
}

// VCVTSI2SDQ: Convert Dword Integer to Scalar Double-Precision FP Value.
//
// Forms:
//
//	VCVTSI2SDQ m64 xmm xmm
//	VCVTSI2SDQ r64 xmm xmm
func VCVTSI2SDQ(mr, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSI2SDQ.Forms(), sffxs{}, []operand.Op{mr, x, x1})
}

// VCVTSI2SDQ_RD_SAE: Convert Dword Integer to Scalar Double-Precision FP Value (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSI2SDQ.RD_SAE r64 xmm xmm
func VCVTSI2SDQ_RD_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSI2SDQ.Forms(), sffxs{sffxRD_SAE}, []operand.Op{r, x, x1})
}

// VCVTSI2SDQ_RN_SAE: Convert Dword Integer to Scalar Double-Precision FP Value (Round Towards Nearest).
//
// Forms:
//
//	VCVTSI2SDQ.RN_SAE r64 xmm xmm
func VCVTSI2SDQ_RN_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSI2SDQ.Forms(), sffxs{sffxRN_SAE}, []operand.Op{r, x, x1})
}

// VCVTSI2SDQ_RU_SAE: Convert Dword Integer to Scalar Double-Precision FP Value (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSI2SDQ.RU_SAE r64 xmm xmm
func VCVTSI2SDQ_RU_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSI2SDQ.Forms(), sffxs{sffxRU_SAE}, []operand.Op{r, x, x1})
}

// VCVTSI2SDQ_RZ_SAE: Convert Dword Integer to Scalar Double-Precision FP Value (Round Towards Zero).
//
// Forms:
//
//	VCVTSI2SDQ.RZ_SAE r64 xmm xmm
func VCVTSI2SDQ_RZ_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSI2SDQ.Forms(), sffxs{sffxRZ_SAE}, []operand.Op{r, x, x1})
}

// VCVTSI2SSL: Convert Dword Integer to Scalar Single-Precision FP Value.
//
// Forms:
//
//	VCVTSI2SSL m32 xmm xmm
//	VCVTSI2SSL r32 xmm xmm
func VCVTSI2SSL(mr, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSI2SSL.Forms(), sffxs{}, []operand.Op{mr, x, x1})
}

// VCVTSI2SSL_RD_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSI2SSL.RD_SAE r32 xmm xmm
func VCVTSI2SSL_RD_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSI2SSL.Forms(), sffxs{sffxRD_SAE}, []operand.Op{r, x, x1})
}

// VCVTSI2SSL_RN_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Nearest).
//
// Forms:
//
//	VCVTSI2SSL.RN_SAE r32 xmm xmm
func VCVTSI2SSL_RN_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSI2SSL.Forms(), sffxs{sffxRN_SAE}, []operand.Op{r, x, x1})
}

// VCVTSI2SSL_RU_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSI2SSL.RU_SAE r32 xmm xmm
func VCVTSI2SSL_RU_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSI2SSL.Forms(), sffxs{sffxRU_SAE}, []operand.Op{r, x, x1})
}

// VCVTSI2SSL_RZ_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Zero).
//
// Forms:
//
//	VCVTSI2SSL.RZ_SAE r32 xmm xmm
func VCVTSI2SSL_RZ_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSI2SSL.Forms(), sffxs{sffxRZ_SAE}, []operand.Op{r, x, x1})
}

// VCVTSI2SSQ: Convert Dword Integer to Scalar Single-Precision FP Value.
//
// Forms:
//
//	VCVTSI2SSQ m64 xmm xmm
//	VCVTSI2SSQ r64 xmm xmm
func VCVTSI2SSQ(mr, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSI2SSQ.Forms(), sffxs{}, []operand.Op{mr, x, x1})
}

// VCVTSI2SSQ_RD_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSI2SSQ.RD_SAE r64 xmm xmm
func VCVTSI2SSQ_RD_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSI2SSQ.Forms(), sffxs{sffxRD_SAE}, []operand.Op{r, x, x1})
}

// VCVTSI2SSQ_RN_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Nearest).
//
// Forms:
//
//	VCVTSI2SSQ.RN_SAE r64 xmm xmm
func VCVTSI2SSQ_RN_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSI2SSQ.Forms(), sffxs{sffxRN_SAE}, []operand.Op{r, x, x1})
}

// VCVTSI2SSQ_RU_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSI2SSQ.RU_SAE r64 xmm xmm
func VCVTSI2SSQ_RU_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSI2SSQ.Forms(), sffxs{sffxRU_SAE}, []operand.Op{r, x, x1})
}

// VCVTSI2SSQ_RZ_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Zero).
//
// Forms:
//
//	VCVTSI2SSQ.RZ_SAE r64 xmm xmm
func VCVTSI2SSQ_RZ_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSI2SSQ.Forms(), sffxs{sffxRZ_SAE}, []operand.Op{r, x, x1})
}

// VCVTSS2SD: Convert Scalar Single-Precision FP Value to Scalar Double-Precision FP Value.
//
// Forms:
//
//	VCVTSS2SD m32 xmm xmm
//	VCVTSS2SD xmm xmm xmm
//	VCVTSS2SD m32 xmm k xmm
//	VCVTSS2SD xmm xmm k xmm
func VCVTSS2SD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2SD.Forms(), sffxs{}, ops)
}

// VCVTSS2SD_SAE: Convert Scalar Single-Precision FP Value to Scalar Double-Precision FP Value (Suppress All Exceptions).
//
// Forms:
//
//	VCVTSS2SD.SAE xmm xmm k xmm
//	VCVTSS2SD.SAE xmm xmm xmm
func VCVTSS2SD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2SD.Forms(), sffxs{sffxSAE}, ops)
}

// VCVTSS2SD_SAE_Z: Convert Scalar Single-Precision FP Value to Scalar Double-Precision FP Value (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTSS2SD.SAE.Z xmm xmm k xmm
func VCVTSS2SD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2SD.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VCVTSS2SD_Z: Convert Scalar Single-Precision FP Value to Scalar Double-Precision FP Value (Zeroing Masking).
//
// Forms:
//
//	VCVTSS2SD.Z m32 xmm k xmm
//	VCVTSS2SD.Z xmm xmm k xmm
func VCVTSS2SD_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2SD.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VCVTSS2SI: Convert Scalar Single-Precision FP Value to Dword Integer.
//
// Forms:
//
//	VCVTSS2SI m32 r32
//	VCVTSS2SI xmm r32
func VCVTSS2SI(mx, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2SI.Forms(), sffxs{}, []operand.Op{mx, r})
}

// VCVTSS2SIQ: Convert Scalar Single-Precision FP Value to Dword Integer.
//
// Forms:
//
//	VCVTSS2SIQ m32 r64
//	VCVTSS2SIQ xmm r64
func VCVTSS2SIQ(mx, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2SIQ.Forms(), sffxs{}, []operand.Op{mx, r})
}

// VCVTSS2SIQ_RD_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSS2SIQ.RD_SAE xmm r64
func VCVTSS2SIQ_RD_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2SIQ.Forms(), sffxs{sffxRD_SAE}, []operand.Op{x, r})
}

// VCVTSS2SIQ_RN_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSS2SIQ.RN_SAE xmm r64
func VCVTSS2SIQ_RN_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2SIQ.Forms(), sffxs{sffxRN_SAE}, []operand.Op{x, r})
}

// VCVTSS2SIQ_RU_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSS2SIQ.RU_SAE xmm r64
func VCVTSS2SIQ_RU_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2SIQ.Forms(), sffxs{sffxRU_SAE}, []operand.Op{x, r})
}

// VCVTSS2SIQ_RZ_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSS2SIQ.RZ_SAE xmm r64
func VCVTSS2SIQ_RZ_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2SIQ.Forms(), sffxs{sffxRZ_SAE}, []operand.Op{x, r})
}

// VCVTSS2SI_RD_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSS2SI.RD_SAE xmm r32
func VCVTSS2SI_RD_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2SI.Forms(), sffxs{sffxRD_SAE}, []operand.Op{x, r})
}

// VCVTSS2SI_RN_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSS2SI.RN_SAE xmm r32
func VCVTSS2SI_RN_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2SI.Forms(), sffxs{sffxRN_SAE}, []operand.Op{x, r})
}

// VCVTSS2SI_RU_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSS2SI.RU_SAE xmm r32
func VCVTSS2SI_RU_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2SI.Forms(), sffxs{sffxRU_SAE}, []operand.Op{x, r})
}

// VCVTSS2SI_RZ_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSS2SI.RZ_SAE xmm r32
func VCVTSS2SI_RZ_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2SI.Forms(), sffxs{sffxRZ_SAE}, []operand.Op{x, r})
}

// VCVTSS2USIL: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer.
//
// Forms:
//
//	VCVTSS2USIL m32 r32
//	VCVTSS2USIL xmm r32
func VCVTSS2USIL(mx, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2USIL.Forms(), sffxs{}, []operand.Op{mx, r})
}

// VCVTSS2USIL_RD_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSS2USIL.RD_SAE xmm r32
func VCVTSS2USIL_RD_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2USIL.Forms(), sffxs{sffxRD_SAE}, []operand.Op{x, r})
}

// VCVTSS2USIL_RN_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSS2USIL.RN_SAE xmm r32
func VCVTSS2USIL_RN_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2USIL.Forms(), sffxs{sffxRN_SAE}, []operand.Op{x, r})
}

// VCVTSS2USIL_RU_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSS2USIL.RU_SAE xmm r32
func VCVTSS2USIL_RU_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2USIL.Forms(), sffxs{sffxRU_SAE}, []operand.Op{x, r})
}

// VCVTSS2USIL_RZ_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSS2USIL.RZ_SAE xmm r32
func VCVTSS2USIL_RZ_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2USIL.Forms(), sffxs{sffxRZ_SAE}, []operand.Op{x, r})
}

// VCVTSS2USIQ: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer.
//
// Forms:
//
//	VCVTSS2USIQ m32 r64
//	VCVTSS2USIQ xmm r64
func VCVTSS2USIQ(mx, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2USIQ.Forms(), sffxs{}, []operand.Op{mx, r})
}

// VCVTSS2USIQ_RD_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSS2USIQ.RD_SAE xmm r64
func VCVTSS2USIQ_RD_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2USIQ.Forms(), sffxs{sffxRD_SAE}, []operand.Op{x, r})
}

// VCVTSS2USIQ_RN_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSS2USIQ.RN_SAE xmm r64
func VCVTSS2USIQ_RN_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2USIQ.Forms(), sffxs{sffxRN_SAE}, []operand.Op{x, r})
}

// VCVTSS2USIQ_RU_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSS2USIQ.RU_SAE xmm r64
func VCVTSS2USIQ_RU_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2USIQ.Forms(), sffxs{sffxRU_SAE}, []operand.Op{x, r})
}

// VCVTSS2USIQ_RZ_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSS2USIQ.RZ_SAE xmm r64
func VCVTSS2USIQ_RZ_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTSS2USIQ.Forms(), sffxs{sffxRZ_SAE}, []operand.Op{x, r})
}

// VCVTTPD2DQ: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTTPD2DQ m512 k ymm
//	VCVTTPD2DQ m512 ymm
//	VCVTTPD2DQ zmm  k ymm
//	VCVTTPD2DQ zmm  ymm
func VCVTTPD2DQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2DQ.Forms(), sffxs{}, ops)
}

// VCVTTPD2DQX: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTTPD2DQX m128 xmm
//	VCVTTPD2DQX xmm  xmm
//	VCVTTPD2DQX m128 k xmm
//	VCVTTPD2DQX xmm  k xmm
func VCVTTPD2DQX(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2DQX.Forms(), sffxs{}, ops)
}

// VCVTTPD2DQX_BCST: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2DQX.BCST m64 k xmm
//	VCVTTPD2DQX.BCST m64 xmm
func VCVTTPD2DQX_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2DQX.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTTPD2DQX_BCST_Z: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2DQX.BCST.Z m64 k xmm
func VCVTTPD2DQX_BCST_Z(m, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2DQX.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, x})
}

// VCVTTPD2DQX_Z: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2DQX.Z m128 k xmm
//	VCVTTPD2DQX.Z xmm  k xmm
func VCVTTPD2DQX_Z(mx, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2DQX.Forms(), sffxs{sffxZ}, []operand.Op{mx, k, x})
}

// VCVTTPD2DQY: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTTPD2DQY m256 xmm
//	VCVTTPD2DQY ymm  xmm
//	VCVTTPD2DQY m256 k xmm
//	VCVTTPD2DQY ymm  k xmm
func VCVTTPD2DQY(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2DQY.Forms(), sffxs{}, ops)
}

// VCVTTPD2DQY_BCST: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2DQY.BCST m64 k xmm
//	VCVTTPD2DQY.BCST m64 xmm
func VCVTTPD2DQY_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2DQY.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTTPD2DQY_BCST_Z: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2DQY.BCST.Z m64 k xmm
func VCVTTPD2DQY_BCST_Z(m, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2DQY.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, x})
}

// VCVTTPD2DQY_Z: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2DQY.Z m256 k xmm
//	VCVTTPD2DQY.Z ymm  k xmm
func VCVTTPD2DQY_Z(my, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2DQY.Forms(), sffxs{sffxZ}, []operand.Op{my, k, x})
}

// VCVTTPD2DQ_BCST: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2DQ.BCST m64 k ymm
//	VCVTTPD2DQ.BCST m64 ymm
func VCVTTPD2DQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2DQ.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTTPD2DQ_BCST_Z: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2DQ.BCST.Z m64 k ymm
func VCVTTPD2DQ_BCST_Z(m, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2DQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, y})
}

// VCVTTPD2DQ_SAE: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPD2DQ.SAE zmm k ymm
//	VCVTTPD2DQ.SAE zmm ymm
func VCVTTPD2DQ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2DQ.Forms(), sffxs{sffxSAE}, ops)
}

// VCVTTPD2DQ_SAE_Z: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2DQ.SAE.Z zmm k ymm
func VCVTTPD2DQ_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2DQ.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTTPD2DQ_Z: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2DQ.Z m512 k ymm
//	VCVTTPD2DQ.Z zmm  k ymm
func VCVTTPD2DQ_Z(mz, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2DQ.Forms(), sffxs{sffxZ}, []operand.Op{mz, k, y})
}

// VCVTTPD2QQ: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Quadword Integers.
//
// Forms:
//
//	VCVTTPD2QQ m128 k xmm
//	VCVTTPD2QQ m128 xmm
//	VCVTTPD2QQ m256 k ymm
//	VCVTTPD2QQ m256 ymm
//	VCVTTPD2QQ xmm  k xmm
//	VCVTTPD2QQ xmm  xmm
//	VCVTTPD2QQ ymm  k ymm
//	VCVTTPD2QQ ymm  ymm
//	VCVTTPD2QQ m512 k zmm
//	VCVTTPD2QQ m512 zmm
//	VCVTTPD2QQ zmm  k zmm
//	VCVTTPD2QQ zmm  zmm
func VCVTTPD2QQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2QQ.Forms(), sffxs{}, ops)
}

// VCVTTPD2QQ_BCST: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2QQ.BCST m64 k xmm
//	VCVTTPD2QQ.BCST m64 k ymm
//	VCVTTPD2QQ.BCST m64 xmm
//	VCVTTPD2QQ.BCST m64 ymm
//	VCVTTPD2QQ.BCST m64 k zmm
//	VCVTTPD2QQ.BCST m64 zmm
func VCVTTPD2QQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2QQ.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTTPD2QQ_BCST_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2QQ.BCST.Z m64 k xmm
//	VCVTTPD2QQ.BCST.Z m64 k ymm
//	VCVTTPD2QQ.BCST.Z m64 k zmm
func VCVTTPD2QQ_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2QQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VCVTTPD2QQ_SAE: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPD2QQ.SAE zmm k zmm
//	VCVTTPD2QQ.SAE zmm zmm
func VCVTTPD2QQ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2QQ.Forms(), sffxs{sffxSAE}, ops)
}

// VCVTTPD2QQ_SAE_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2QQ.SAE.Z zmm k zmm
func VCVTTPD2QQ_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2QQ.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTTPD2QQ_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2QQ.Z m128 k xmm
//	VCVTTPD2QQ.Z m256 k ymm
//	VCVTTPD2QQ.Z xmm  k xmm
//	VCVTTPD2QQ.Z ymm  k ymm
//	VCVTTPD2QQ.Z m512 k zmm
//	VCVTTPD2QQ.Z zmm  k zmm
func VCVTTPD2QQ_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2QQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VCVTTPD2UDQ: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	VCVTTPD2UDQ m512 k ymm
//	VCVTTPD2UDQ m512 ymm
//	VCVTTPD2UDQ zmm  k ymm
//	VCVTTPD2UDQ zmm  ymm
func VCVTTPD2UDQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2UDQ.Forms(), sffxs{}, ops)
}

// VCVTTPD2UDQX: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	VCVTTPD2UDQX m128 k xmm
//	VCVTTPD2UDQX m128 xmm
//	VCVTTPD2UDQX xmm  k xmm
//	VCVTTPD2UDQX xmm  xmm
func VCVTTPD2UDQX(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2UDQX.Forms(), sffxs{}, ops)
}

// VCVTTPD2UDQX_BCST: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2UDQX.BCST m64 k xmm
//	VCVTTPD2UDQX.BCST m64 xmm
func VCVTTPD2UDQX_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2UDQX.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTTPD2UDQX_BCST_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UDQX.BCST.Z m64 k xmm
func VCVTTPD2UDQX_BCST_Z(m, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2UDQX.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, x})
}

// VCVTTPD2UDQX_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UDQX.Z m128 k xmm
//	VCVTTPD2UDQX.Z xmm  k xmm
func VCVTTPD2UDQX_Z(mx, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2UDQX.Forms(), sffxs{sffxZ}, []operand.Op{mx, k, x})
}

// VCVTTPD2UDQY: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	VCVTTPD2UDQY m256 k xmm
//	VCVTTPD2UDQY m256 xmm
//	VCVTTPD2UDQY ymm  k xmm
//	VCVTTPD2UDQY ymm  xmm
func VCVTTPD2UDQY(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2UDQY.Forms(), sffxs{}, ops)
}

// VCVTTPD2UDQY_BCST: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2UDQY.BCST m64 k xmm
//	VCVTTPD2UDQY.BCST m64 xmm
func VCVTTPD2UDQY_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2UDQY.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTTPD2UDQY_BCST_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UDQY.BCST.Z m64 k xmm
func VCVTTPD2UDQY_BCST_Z(m, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2UDQY.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, x})
}

// VCVTTPD2UDQY_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UDQY.Z m256 k xmm
//	VCVTTPD2UDQY.Z ymm  k xmm
func VCVTTPD2UDQY_Z(my, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2UDQY.Forms(), sffxs{sffxZ}, []operand.Op{my, k, x})
}

// VCVTTPD2UDQ_BCST: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2UDQ.BCST m64 k ymm
//	VCVTTPD2UDQ.BCST m64 ymm
func VCVTTPD2UDQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2UDQ.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTTPD2UDQ_BCST_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UDQ.BCST.Z m64 k ymm
func VCVTTPD2UDQ_BCST_Z(m, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2UDQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, y})
}

// VCVTTPD2UDQ_SAE: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPD2UDQ.SAE zmm k ymm
//	VCVTTPD2UDQ.SAE zmm ymm
func VCVTTPD2UDQ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2UDQ.Forms(), sffxs{sffxSAE}, ops)
}

// VCVTTPD2UDQ_SAE_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UDQ.SAE.Z zmm k ymm
func VCVTTPD2UDQ_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2UDQ.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTTPD2UDQ_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UDQ.Z m512 k ymm
//	VCVTTPD2UDQ.Z zmm  k ymm
func VCVTTPD2UDQ_Z(mz, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2UDQ.Forms(), sffxs{sffxZ}, []operand.Op{mz, k, y})
}

// VCVTTPD2UQQ: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers.
//
// Forms:
//
//	VCVTTPD2UQQ m128 k xmm
//	VCVTTPD2UQQ m128 xmm
//	VCVTTPD2UQQ m256 k ymm
//	VCVTTPD2UQQ m256 ymm
//	VCVTTPD2UQQ xmm  k xmm
//	VCVTTPD2UQQ xmm  xmm
//	VCVTTPD2UQQ ymm  k ymm
//	VCVTTPD2UQQ ymm  ymm
//	VCVTTPD2UQQ m512 k zmm
//	VCVTTPD2UQQ m512 zmm
//	VCVTTPD2UQQ zmm  k zmm
//	VCVTTPD2UQQ zmm  zmm
func VCVTTPD2UQQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2UQQ.Forms(), sffxs{}, ops)
}

// VCVTTPD2UQQ_BCST: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2UQQ.BCST m64 k xmm
//	VCVTTPD2UQQ.BCST m64 k ymm
//	VCVTTPD2UQQ.BCST m64 xmm
//	VCVTTPD2UQQ.BCST m64 ymm
//	VCVTTPD2UQQ.BCST m64 k zmm
//	VCVTTPD2UQQ.BCST m64 zmm
func VCVTTPD2UQQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2UQQ.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTTPD2UQQ_BCST_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UQQ.BCST.Z m64 k xmm
//	VCVTTPD2UQQ.BCST.Z m64 k ymm
//	VCVTTPD2UQQ.BCST.Z m64 k zmm
func VCVTTPD2UQQ_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2UQQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VCVTTPD2UQQ_SAE: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPD2UQQ.SAE zmm k zmm
//	VCVTTPD2UQQ.SAE zmm zmm
func VCVTTPD2UQQ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2UQQ.Forms(), sffxs{sffxSAE}, ops)
}

// VCVTTPD2UQQ_SAE_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UQQ.SAE.Z zmm k zmm
func VCVTTPD2UQQ_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2UQQ.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTTPD2UQQ_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UQQ.Z m128 k xmm
//	VCVTTPD2UQQ.Z m256 k ymm
//	VCVTTPD2UQQ.Z xmm  k xmm
//	VCVTTPD2UQQ.Z ymm  k ymm
//	VCVTTPD2UQQ.Z m512 k zmm
//	VCVTTPD2UQQ.Z zmm  k zmm
func VCVTTPD2UQQ_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPD2UQQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VCVTTPS2DQ: Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTTPS2DQ m128 xmm
//	VCVTTPS2DQ m256 ymm
//	VCVTTPS2DQ xmm  xmm
//	VCVTTPS2DQ ymm  ymm
//	VCVTTPS2DQ m128 k xmm
//	VCVTTPS2DQ m256 k ymm
//	VCVTTPS2DQ xmm  k xmm
//	VCVTTPS2DQ ymm  k ymm
//	VCVTTPS2DQ m512 k zmm
//	VCVTTPS2DQ m512 zmm
//	VCVTTPS2DQ zmm  k zmm
//	VCVTTPS2DQ zmm  zmm
func VCVTTPS2DQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2DQ.Forms(), sffxs{}, ops)
}

// VCVTTPS2DQ_BCST: Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPS2DQ.BCST m32 k xmm
//	VCVTTPS2DQ.BCST m32 k ymm
//	VCVTTPS2DQ.BCST m32 xmm
//	VCVTTPS2DQ.BCST m32 ymm
//	VCVTTPS2DQ.BCST m32 k zmm
//	VCVTTPS2DQ.BCST m32 zmm
func VCVTTPS2DQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2DQ.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTTPS2DQ_BCST_Z: Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2DQ.BCST.Z m32 k xmm
//	VCVTTPS2DQ.BCST.Z m32 k ymm
//	VCVTTPS2DQ.BCST.Z m32 k zmm
func VCVTTPS2DQ_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2DQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VCVTTPS2DQ_SAE: Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPS2DQ.SAE zmm k zmm
//	VCVTTPS2DQ.SAE zmm zmm
func VCVTTPS2DQ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2DQ.Forms(), sffxs{sffxSAE}, ops)
}

// VCVTTPS2DQ_SAE_Z: Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2DQ.SAE.Z zmm k zmm
func VCVTTPS2DQ_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2DQ.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTTPS2DQ_Z: Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2DQ.Z m128 k xmm
//	VCVTTPS2DQ.Z m256 k ymm
//	VCVTTPS2DQ.Z xmm  k xmm
//	VCVTTPS2DQ.Z ymm  k ymm
//	VCVTTPS2DQ.Z m512 k zmm
//	VCVTTPS2DQ.Z zmm  k zmm
func VCVTTPS2DQ_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2DQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VCVTTPS2QQ: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values.
//
// Forms:
//
//	VCVTTPS2QQ m128 k ymm
//	VCVTTPS2QQ m128 ymm
//	VCVTTPS2QQ m64  k xmm
//	VCVTTPS2QQ m64  xmm
//	VCVTTPS2QQ xmm  k xmm
//	VCVTTPS2QQ xmm  k ymm
//	VCVTTPS2QQ xmm  xmm
//	VCVTTPS2QQ xmm  ymm
//	VCVTTPS2QQ m256 k zmm
//	VCVTTPS2QQ m256 zmm
//	VCVTTPS2QQ ymm  k zmm
//	VCVTTPS2QQ ymm  zmm
func VCVTTPS2QQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2QQ.Forms(), sffxs{}, ops)
}

// VCVTTPS2QQ_BCST: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Broadcast).
//
// Forms:
//
//	VCVTTPS2QQ.BCST m32 k xmm
//	VCVTTPS2QQ.BCST m32 k ymm
//	VCVTTPS2QQ.BCST m32 xmm
//	VCVTTPS2QQ.BCST m32 ymm
//	VCVTTPS2QQ.BCST m32 k zmm
//	VCVTTPS2QQ.BCST m32 zmm
func VCVTTPS2QQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2QQ.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTTPS2QQ_BCST_Z: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2QQ.BCST.Z m32 k xmm
//	VCVTTPS2QQ.BCST.Z m32 k ymm
//	VCVTTPS2QQ.BCST.Z m32 k zmm
func VCVTTPS2QQ_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2QQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VCVTTPS2QQ_SAE: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPS2QQ.SAE ymm k zmm
//	VCVTTPS2QQ.SAE ymm zmm
func VCVTTPS2QQ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2QQ.Forms(), sffxs{sffxSAE}, ops)
}

// VCVTTPS2QQ_SAE_Z: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2QQ.SAE.Z ymm k zmm
func VCVTTPS2QQ_SAE_Z(y, k, z operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2QQ.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{y, k, z})
}

// VCVTTPS2QQ_Z: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2QQ.Z m128 k ymm
//	VCVTTPS2QQ.Z m64  k xmm
//	VCVTTPS2QQ.Z xmm  k xmm
//	VCVTTPS2QQ.Z xmm  k ymm
//	VCVTTPS2QQ.Z m256 k zmm
//	VCVTTPS2QQ.Z ymm  k zmm
func VCVTTPS2QQ_Z(mxy, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2QQ.Forms(), sffxs{sffxZ}, []operand.Op{mxy, k, xyz})
}

// VCVTTPS2UDQ: Convert with Truncation Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values.
//
// Forms:
//
//	VCVTTPS2UDQ m128 k xmm
//	VCVTTPS2UDQ m128 xmm
//	VCVTTPS2UDQ m256 k ymm
//	VCVTTPS2UDQ m256 ymm
//	VCVTTPS2UDQ xmm  k xmm
//	VCVTTPS2UDQ xmm  xmm
//	VCVTTPS2UDQ ymm  k ymm
//	VCVTTPS2UDQ ymm  ymm
//	VCVTTPS2UDQ m512 k zmm
//	VCVTTPS2UDQ m512 zmm
//	VCVTTPS2UDQ zmm  k zmm
//	VCVTTPS2UDQ zmm  zmm
func VCVTTPS2UDQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2UDQ.Forms(), sffxs{}, ops)
}

// VCVTTPS2UDQ_BCST: Convert with Truncation Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Broadcast).
//
// Forms:
//
//	VCVTTPS2UDQ.BCST m32 k xmm
//	VCVTTPS2UDQ.BCST m32 k ymm
//	VCVTTPS2UDQ.BCST m32 xmm
//	VCVTTPS2UDQ.BCST m32 ymm
//	VCVTTPS2UDQ.BCST m32 k zmm
//	VCVTTPS2UDQ.BCST m32 zmm
func VCVTTPS2UDQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2UDQ.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTTPS2UDQ_BCST_Z: Convert with Truncation Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2UDQ.BCST.Z m32 k xmm
//	VCVTTPS2UDQ.BCST.Z m32 k ymm
//	VCVTTPS2UDQ.BCST.Z m32 k zmm
func VCVTTPS2UDQ_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2UDQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VCVTTPS2UDQ_SAE: Convert with Truncation Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPS2UDQ.SAE zmm k zmm
//	VCVTTPS2UDQ.SAE zmm zmm
func VCVTTPS2UDQ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2UDQ.Forms(), sffxs{sffxSAE}, ops)
}

// VCVTTPS2UDQ_SAE_Z: Convert with Truncation Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2UDQ.SAE.Z zmm k zmm
func VCVTTPS2UDQ_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2UDQ.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTTPS2UDQ_Z: Convert with Truncation Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2UDQ.Z m128 k xmm
//	VCVTTPS2UDQ.Z m256 k ymm
//	VCVTTPS2UDQ.Z xmm  k xmm
//	VCVTTPS2UDQ.Z ymm  k ymm
//	VCVTTPS2UDQ.Z m512 k zmm
//	VCVTTPS2UDQ.Z zmm  k zmm
func VCVTTPS2UDQ_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2UDQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VCVTTPS2UQQ: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values.
//
// Forms:
//
//	VCVTTPS2UQQ m128 k ymm
//	VCVTTPS2UQQ m128 ymm
//	VCVTTPS2UQQ m64  k xmm
//	VCVTTPS2UQQ m64  xmm
//	VCVTTPS2UQQ xmm  k xmm
//	VCVTTPS2UQQ xmm  k ymm
//	VCVTTPS2UQQ xmm  xmm
//	VCVTTPS2UQQ xmm  ymm
//	VCVTTPS2UQQ m256 k zmm
//	VCVTTPS2UQQ m256 zmm
//	VCVTTPS2UQQ ymm  k zmm
//	VCVTTPS2UQQ ymm  zmm
func VCVTTPS2UQQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2UQQ.Forms(), sffxs{}, ops)
}

// VCVTTPS2UQQ_BCST: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Broadcast).
//
// Forms:
//
//	VCVTTPS2UQQ.BCST m32 k xmm
//	VCVTTPS2UQQ.BCST m32 k ymm
//	VCVTTPS2UQQ.BCST m32 xmm
//	VCVTTPS2UQQ.BCST m32 ymm
//	VCVTTPS2UQQ.BCST m32 k zmm
//	VCVTTPS2UQQ.BCST m32 zmm
func VCVTTPS2UQQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2UQQ.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTTPS2UQQ_BCST_Z: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2UQQ.BCST.Z m32 k xmm
//	VCVTTPS2UQQ.BCST.Z m32 k ymm
//	VCVTTPS2UQQ.BCST.Z m32 k zmm
func VCVTTPS2UQQ_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2UQQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VCVTTPS2UQQ_SAE: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPS2UQQ.SAE ymm k zmm
//	VCVTTPS2UQQ.SAE ymm zmm
func VCVTTPS2UQQ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2UQQ.Forms(), sffxs{sffxSAE}, ops)
}

// VCVTTPS2UQQ_SAE_Z: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2UQQ.SAE.Z ymm k zmm
func VCVTTPS2UQQ_SAE_Z(y, k, z operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2UQQ.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{y, k, z})
}

// VCVTTPS2UQQ_Z: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2UQQ.Z m128 k ymm
//	VCVTTPS2UQQ.Z m64  k xmm
//	VCVTTPS2UQQ.Z xmm  k xmm
//	VCVTTPS2UQQ.Z xmm  k ymm
//	VCVTTPS2UQQ.Z m256 k zmm
//	VCVTTPS2UQQ.Z ymm  k zmm
func VCVTTPS2UQQ_Z(mxy, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTPS2UQQ.Forms(), sffxs{sffxZ}, []operand.Op{mxy, k, xyz})
}

// VCVTTSD2SI: Convert with Truncation Scalar Double-Precision FP Value to Signed Integer.
//
// Forms:
//
//	VCVTTSD2SI m64 r32
//	VCVTTSD2SI xmm r32
func VCVTTSD2SI(mx, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTSD2SI.Forms(), sffxs{}, []operand.Op{mx, r})
}

// VCVTTSD2SIQ: Convert with Truncation Scalar Double-Precision FP Value to Signed Integer.
//
// Forms:
//
//	VCVTTSD2SIQ m64 r64
//	VCVTTSD2SIQ xmm r64
func VCVTTSD2SIQ(mx, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTSD2SIQ.Forms(), sffxs{}, []operand.Op{mx, r})
}

// VCVTTSD2SIQ_SAE: Convert with Truncation Scalar Double-Precision FP Value to Signed Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSD2SIQ.SAE xmm r64
func VCVTTSD2SIQ_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTSD2SIQ.Forms(), sffxs{sffxSAE}, []operand.Op{x, r})
}

// VCVTTSD2SI_SAE: Convert with Truncation Scalar Double-Precision FP Value to Signed Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSD2SI.SAE xmm r32
func VCVTTSD2SI_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTSD2SI.Forms(), sffxs{sffxSAE}, []operand.Op{x, r})
}

// VCVTTSD2USIL: Convert with Truncation Scalar Double-Precision Floating-Point Value to Unsigned Integer.
//
// Forms:
//
//	VCVTTSD2USIL m64 r32
//	VCVTTSD2USIL xmm r32
func VCVTTSD2USIL(mx, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTSD2USIL.Forms(), sffxs{}, []operand.Op{mx, r})
}

// VCVTTSD2USIL_SAE: Convert with Truncation Scalar Double-Precision Floating-Point Value to Unsigned Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSD2USIL.SAE xmm r32
func VCVTTSD2USIL_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTSD2USIL.Forms(), sffxs{sffxSAE}, []operand.Op{x, r})
}

// VCVTTSD2USIQ: Convert with Truncation Scalar Double-Precision Floating-Point Value to Unsigned Integer.
//
// Forms:
//
//	VCVTTSD2USIQ m64 r64
//	VCVTTSD2USIQ xmm r64
func VCVTTSD2USIQ(mx, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTSD2USIQ.Forms(), sffxs{}, []operand.Op{mx, r})
}

// VCVTTSD2USIQ_SAE: Convert with Truncation Scalar Double-Precision Floating-Point Value to Unsigned Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSD2USIQ.SAE xmm r64
func VCVTTSD2USIQ_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTSD2USIQ.Forms(), sffxs{sffxSAE}, []operand.Op{x, r})
}

// VCVTTSS2SI: Convert with Truncation Scalar Single-Precision FP Value to Dword Integer.
//
// Forms:
//
//	VCVTTSS2SI m32 r32
//	VCVTTSS2SI xmm r32
func VCVTTSS2SI(mx, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTSS2SI.Forms(), sffxs{}, []operand.Op{mx, r})
}

// VCVTTSS2SIQ: Convert with Truncation Scalar Single-Precision FP Value to Dword Integer.
//
// Forms:
//
//	VCVTTSS2SIQ m32 r64
//	VCVTTSS2SIQ xmm r64
func VCVTTSS2SIQ(mx, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTSS2SIQ.Forms(), sffxs{}, []operand.Op{mx, r})
}

// VCVTTSS2SIQ_SAE: Convert with Truncation Scalar Single-Precision FP Value to Dword Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSS2SIQ.SAE xmm r64
func VCVTTSS2SIQ_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTSS2SIQ.Forms(), sffxs{sffxSAE}, []operand.Op{x, r})
}

// VCVTTSS2SI_SAE: Convert with Truncation Scalar Single-Precision FP Value to Dword Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSS2SI.SAE xmm r32
func VCVTTSS2SI_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTSS2SI.Forms(), sffxs{sffxSAE}, []operand.Op{x, r})
}

// VCVTTSS2USIL: Convert with Truncation Scalar Single-Precision Floating-Point Value to Unsigned Integer.
//
// Forms:
//
//	VCVTTSS2USIL m32 r32
//	VCVTTSS2USIL xmm r32
func VCVTTSS2USIL(mx, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTSS2USIL.Forms(), sffxs{}, []operand.Op{mx, r})
}

// VCVTTSS2USIL_SAE: Convert with Truncation Scalar Single-Precision Floating-Point Value to Unsigned Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSS2USIL.SAE xmm r32
func VCVTTSS2USIL_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTSS2USIL.Forms(), sffxs{sffxSAE}, []operand.Op{x, r})
}

// VCVTTSS2USIQ: Convert with Truncation Scalar Single-Precision Floating-Point Value to Unsigned Integer.
//
// Forms:
//
//	VCVTTSS2USIQ m32 r64
//	VCVTTSS2USIQ xmm r64
func VCVTTSS2USIQ(mx, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTSS2USIQ.Forms(), sffxs{}, []operand.Op{mx, r})
}

// VCVTTSS2USIQ_SAE: Convert with Truncation Scalar Single-Precision Floating-Point Value to Unsigned Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSS2USIQ.SAE xmm r64
func VCVTTSS2USIQ_SAE(x, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTTSS2USIQ.Forms(), sffxs{sffxSAE}, []operand.Op{x, r})
}

// VCVTUDQ2PD: Convert Packed Unsigned Doubleword Integers to Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTUDQ2PD m128 k ymm
//	VCVTUDQ2PD m128 ymm
//	VCVTUDQ2PD m64  k xmm
//	VCVTUDQ2PD m64  xmm
//	VCVTUDQ2PD xmm  k xmm
//	VCVTUDQ2PD xmm  k ymm
//	VCVTUDQ2PD xmm  xmm
//	VCVTUDQ2PD xmm  ymm
//	VCVTUDQ2PD m256 k zmm
//	VCVTUDQ2PD m256 zmm
//	VCVTUDQ2PD ymm  k zmm
//	VCVTUDQ2PD ymm  zmm
func VCVTUDQ2PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUDQ2PD.Forms(), sffxs{}, ops)
}

// VCVTUDQ2PD_BCST: Convert Packed Unsigned Doubleword Integers to Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTUDQ2PD.BCST m32 k xmm
//	VCVTUDQ2PD.BCST m32 k ymm
//	VCVTUDQ2PD.BCST m32 xmm
//	VCVTUDQ2PD.BCST m32 ymm
//	VCVTUDQ2PD.BCST m32 k zmm
//	VCVTUDQ2PD.BCST m32 zmm
func VCVTUDQ2PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUDQ2PD.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTUDQ2PD_BCST_Z: Convert Packed Unsigned Doubleword Integers to Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PD.BCST.Z m32 k xmm
//	VCVTUDQ2PD.BCST.Z m32 k ymm
//	VCVTUDQ2PD.BCST.Z m32 k zmm
func VCVTUDQ2PD_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUDQ2PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VCVTUDQ2PD_Z: Convert Packed Unsigned Doubleword Integers to Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PD.Z m128 k ymm
//	VCVTUDQ2PD.Z m64  k xmm
//	VCVTUDQ2PD.Z xmm  k xmm
//	VCVTUDQ2PD.Z xmm  k ymm
//	VCVTUDQ2PD.Z m256 k zmm
//	VCVTUDQ2PD.Z ymm  k zmm
func VCVTUDQ2PD_Z(mxy, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUDQ2PD.Forms(), sffxs{sffxZ}, []operand.Op{mxy, k, xyz})
}

// VCVTUDQ2PS: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTUDQ2PS m128 k xmm
//	VCVTUDQ2PS m128 xmm
//	VCVTUDQ2PS m256 k ymm
//	VCVTUDQ2PS m256 ymm
//	VCVTUDQ2PS xmm  k xmm
//	VCVTUDQ2PS xmm  xmm
//	VCVTUDQ2PS ymm  k ymm
//	VCVTUDQ2PS ymm  ymm
//	VCVTUDQ2PS m512 k zmm
//	VCVTUDQ2PS m512 zmm
//	VCVTUDQ2PS zmm  k zmm
//	VCVTUDQ2PS zmm  zmm
func VCVTUDQ2PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUDQ2PS.Forms(), sffxs{}, ops)
}

// VCVTUDQ2PS_BCST: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTUDQ2PS.BCST m32 k xmm
//	VCVTUDQ2PS.BCST m32 k ymm
//	VCVTUDQ2PS.BCST m32 xmm
//	VCVTUDQ2PS.BCST m32 ymm
//	VCVTUDQ2PS.BCST m32 k zmm
//	VCVTUDQ2PS.BCST m32 zmm
func VCVTUDQ2PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUDQ2PS.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTUDQ2PS_BCST_Z: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PS.BCST.Z m32 k xmm
//	VCVTUDQ2PS.BCST.Z m32 k ymm
//	VCVTUDQ2PS.BCST.Z m32 k zmm
func VCVTUDQ2PS_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUDQ2PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VCVTUDQ2PS_RD_SAE: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTUDQ2PS.RD_SAE zmm k zmm
//	VCVTUDQ2PS.RD_SAE zmm zmm
func VCVTUDQ2PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUDQ2PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VCVTUDQ2PS_RD_SAE_Z: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PS.RD_SAE.Z zmm k zmm
func VCVTUDQ2PS_RD_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUDQ2PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTUDQ2PS_RN_SAE: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTUDQ2PS.RN_SAE zmm k zmm
//	VCVTUDQ2PS.RN_SAE zmm zmm
func VCVTUDQ2PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUDQ2PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VCVTUDQ2PS_RN_SAE_Z: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PS.RN_SAE.Z zmm k zmm
func VCVTUDQ2PS_RN_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUDQ2PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTUDQ2PS_RU_SAE: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTUDQ2PS.RU_SAE zmm k zmm
//	VCVTUDQ2PS.RU_SAE zmm zmm
func VCVTUDQ2PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUDQ2PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VCVTUDQ2PS_RU_SAE_Z: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PS.RU_SAE.Z zmm k zmm
func VCVTUDQ2PS_RU_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUDQ2PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTUDQ2PS_RZ_SAE: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VCVTUDQ2PS.RZ_SAE zmm k zmm
//	VCVTUDQ2PS.RZ_SAE zmm zmm
func VCVTUDQ2PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUDQ2PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VCVTUDQ2PS_RZ_SAE_Z: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PS.RZ_SAE.Z zmm k zmm
func VCVTUDQ2PS_RZ_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUDQ2PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTUDQ2PS_Z: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PS.Z m128 k xmm
//	VCVTUDQ2PS.Z m256 k ymm
//	VCVTUDQ2PS.Z xmm  k xmm
//	VCVTUDQ2PS.Z ymm  k ymm
//	VCVTUDQ2PS.Z m512 k zmm
//	VCVTUDQ2PS.Z zmm  k zmm
func VCVTUDQ2PS_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUDQ2PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VCVTUQQ2PD: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTUQQ2PD m128 k xmm
//	VCVTUQQ2PD m128 xmm
//	VCVTUQQ2PD m256 k ymm
//	VCVTUQQ2PD m256 ymm
//	VCVTUQQ2PD xmm  k xmm
//	VCVTUQQ2PD xmm  xmm
//	VCVTUQQ2PD ymm  k ymm
//	VCVTUQQ2PD ymm  ymm
//	VCVTUQQ2PD m512 k zmm
//	VCVTUQQ2PD m512 zmm
//	VCVTUQQ2PD zmm  k zmm
//	VCVTUQQ2PD zmm  zmm
func VCVTUQQ2PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PD.Forms(), sffxs{}, ops)
}

// VCVTUQQ2PD_BCST: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTUQQ2PD.BCST m64 k xmm
//	VCVTUQQ2PD.BCST m64 k ymm
//	VCVTUQQ2PD.BCST m64 xmm
//	VCVTUQQ2PD.BCST m64 ymm
//	VCVTUQQ2PD.BCST m64 k zmm
//	VCVTUQQ2PD.BCST m64 zmm
func VCVTUQQ2PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PD.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTUQQ2PD_BCST_Z: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PD.BCST.Z m64 k xmm
//	VCVTUQQ2PD.BCST.Z m64 k ymm
//	VCVTUQQ2PD.BCST.Z m64 k zmm
func VCVTUQQ2PD_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VCVTUQQ2PD_RD_SAE: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTUQQ2PD.RD_SAE zmm k zmm
//	VCVTUQQ2PD.RD_SAE zmm zmm
func VCVTUQQ2PD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VCVTUQQ2PD_RD_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PD.RD_SAE.Z zmm k zmm
func VCVTUQQ2PD_RD_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTUQQ2PD_RN_SAE: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTUQQ2PD.RN_SAE zmm k zmm
//	VCVTUQQ2PD.RN_SAE zmm zmm
func VCVTUQQ2PD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VCVTUQQ2PD_RN_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PD.RN_SAE.Z zmm k zmm
func VCVTUQQ2PD_RN_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTUQQ2PD_RU_SAE: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTUQQ2PD.RU_SAE zmm k zmm
//	VCVTUQQ2PD.RU_SAE zmm zmm
func VCVTUQQ2PD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VCVTUQQ2PD_RU_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PD.RU_SAE.Z zmm k zmm
func VCVTUQQ2PD_RU_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTUQQ2PD_RZ_SAE: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VCVTUQQ2PD.RZ_SAE zmm k zmm
//	VCVTUQQ2PD.RZ_SAE zmm zmm
func VCVTUQQ2PD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VCVTUQQ2PD_RZ_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PD.RZ_SAE.Z zmm k zmm
func VCVTUQQ2PD_RZ_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, k, z1})
}

// VCVTUQQ2PD_Z: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PD.Z m128 k xmm
//	VCVTUQQ2PD.Z m256 k ymm
//	VCVTUQQ2PD.Z xmm  k xmm
//	VCVTUQQ2PD.Z ymm  k ymm
//	VCVTUQQ2PD.Z m512 k zmm
//	VCVTUQQ2PD.Z zmm  k zmm
func VCVTUQQ2PD_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VCVTUQQ2PS: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTUQQ2PS m512 k ymm
//	VCVTUQQ2PS m512 ymm
//	VCVTUQQ2PS zmm  k ymm
//	VCVTUQQ2PS zmm  ymm
func VCVTUQQ2PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PS.Forms(), sffxs{}, ops)
}

// VCVTUQQ2PSX: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTUQQ2PSX m128 k xmm
//	VCVTUQQ2PSX m128 xmm
//	VCVTUQQ2PSX xmm  k xmm
//	VCVTUQQ2PSX xmm  xmm
func VCVTUQQ2PSX(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PSX.Forms(), sffxs{}, ops)
}

// VCVTUQQ2PSX_BCST: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTUQQ2PSX.BCST m64 k xmm
//	VCVTUQQ2PSX.BCST m64 xmm
func VCVTUQQ2PSX_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PSX.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTUQQ2PSX_BCST_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PSX.BCST.Z m64 k xmm
func VCVTUQQ2PSX_BCST_Z(m, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PSX.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, x})
}

// VCVTUQQ2PSX_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PSX.Z m128 k xmm
//	VCVTUQQ2PSX.Z xmm  k xmm
func VCVTUQQ2PSX_Z(mx, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PSX.Forms(), sffxs{sffxZ}, []operand.Op{mx, k, x})
}

// VCVTUQQ2PSY: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTUQQ2PSY m256 k xmm
//	VCVTUQQ2PSY m256 xmm
//	VCVTUQQ2PSY ymm  k xmm
//	VCVTUQQ2PSY ymm  xmm
func VCVTUQQ2PSY(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PSY.Forms(), sffxs{}, ops)
}

// VCVTUQQ2PSY_BCST: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTUQQ2PSY.BCST m64 k xmm
//	VCVTUQQ2PSY.BCST m64 xmm
func VCVTUQQ2PSY_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PSY.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTUQQ2PSY_BCST_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PSY.BCST.Z m64 k xmm
func VCVTUQQ2PSY_BCST_Z(m, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PSY.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, x})
}

// VCVTUQQ2PSY_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PSY.Z m256 k xmm
//	VCVTUQQ2PSY.Z ymm  k xmm
func VCVTUQQ2PSY_Z(my, k, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PSY.Forms(), sffxs{sffxZ}, []operand.Op{my, k, x})
}

// VCVTUQQ2PS_BCST: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTUQQ2PS.BCST m64 k ymm
//	VCVTUQQ2PS.BCST m64 ymm
func VCVTUQQ2PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PS.Forms(), sffxs{sffxBCST}, ops)
}

// VCVTUQQ2PS_BCST_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PS.BCST.Z m64 k ymm
func VCVTUQQ2PS_BCST_Z(m, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, y})
}

// VCVTUQQ2PS_RD_SAE: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTUQQ2PS.RD_SAE zmm k ymm
//	VCVTUQQ2PS.RD_SAE zmm ymm
func VCVTUQQ2PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VCVTUQQ2PS_RD_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PS.RD_SAE.Z zmm k ymm
func VCVTUQQ2PS_RD_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTUQQ2PS_RN_SAE: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTUQQ2PS.RN_SAE zmm k ymm
//	VCVTUQQ2PS.RN_SAE zmm ymm
func VCVTUQQ2PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VCVTUQQ2PS_RN_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PS.RN_SAE.Z zmm k ymm
func VCVTUQQ2PS_RN_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTUQQ2PS_RU_SAE: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTUQQ2PS.RU_SAE zmm k ymm
//	VCVTUQQ2PS.RU_SAE zmm ymm
func VCVTUQQ2PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VCVTUQQ2PS_RU_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PS.RU_SAE.Z zmm k ymm
func VCVTUQQ2PS_RU_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTUQQ2PS_RZ_SAE: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VCVTUQQ2PS.RZ_SAE zmm k ymm
//	VCVTUQQ2PS.RZ_SAE zmm ymm
func VCVTUQQ2PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VCVTUQQ2PS_RZ_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PS.RZ_SAE.Z zmm k ymm
func VCVTUQQ2PS_RZ_SAE_Z(z, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, k, y})
}

// VCVTUQQ2PS_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PS.Z m512 k ymm
//	VCVTUQQ2PS.Z zmm  k ymm
func VCVTUQQ2PS_Z(mz, k, y operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUQQ2PS.Forms(), sffxs{sffxZ}, []operand.Op{mz, k, y})
}

// VCVTUSI2SDL: Convert Unsigned Integer to Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	VCVTUSI2SDL m32 xmm xmm
//	VCVTUSI2SDL r32 xmm xmm
func VCVTUSI2SDL(mr, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUSI2SDL.Forms(), sffxs{}, []operand.Op{mr, x, x1})
}

// VCVTUSI2SDQ: Convert Unsigned Integer to Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	VCVTUSI2SDQ m64 xmm xmm
//	VCVTUSI2SDQ r64 xmm xmm
func VCVTUSI2SDQ(mr, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUSI2SDQ.Forms(), sffxs{}, []operand.Op{mr, x, x1})
}

// VCVTUSI2SDQ_RD_SAE: Convert Unsigned Integer to Scalar Double-Precision Floating-Point Value (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTUSI2SDQ.RD_SAE r64 xmm xmm
func VCVTUSI2SDQ_RD_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUSI2SDQ.Forms(), sffxs{sffxRD_SAE}, []operand.Op{r, x, x1})
}

// VCVTUSI2SDQ_RN_SAE: Convert Unsigned Integer to Scalar Double-Precision Floating-Point Value (Round Towards Nearest).
//
// Forms:
//
//	VCVTUSI2SDQ.RN_SAE r64 xmm xmm
func VCVTUSI2SDQ_RN_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUSI2SDQ.Forms(), sffxs{sffxRN_SAE}, []operand.Op{r, x, x1})
}

// VCVTUSI2SDQ_RU_SAE: Convert Unsigned Integer to Scalar Double-Precision Floating-Point Value (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTUSI2SDQ.RU_SAE r64 xmm xmm
func VCVTUSI2SDQ_RU_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUSI2SDQ.Forms(), sffxs{sffxRU_SAE}, []operand.Op{r, x, x1})
}

// VCVTUSI2SDQ_RZ_SAE: Convert Unsigned Integer to Scalar Double-Precision Floating-Point Value (Round Towards Zero).
//
// Forms:
//
//	VCVTUSI2SDQ.RZ_SAE r64 xmm xmm
func VCVTUSI2SDQ_RZ_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUSI2SDQ.Forms(), sffxs{sffxRZ_SAE}, []operand.Op{r, x, x1})
}

// VCVTUSI2SSL: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	VCVTUSI2SSL m32 xmm xmm
//	VCVTUSI2SSL r32 xmm xmm
func VCVTUSI2SSL(mr, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUSI2SSL.Forms(), sffxs{}, []operand.Op{mr, x, x1})
}

// VCVTUSI2SSL_RD_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTUSI2SSL.RD_SAE r32 xmm xmm
func VCVTUSI2SSL_RD_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUSI2SSL.Forms(), sffxs{sffxRD_SAE}, []operand.Op{r, x, x1})
}

// VCVTUSI2SSL_RN_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Nearest).
//
// Forms:
//
//	VCVTUSI2SSL.RN_SAE r32 xmm xmm
func VCVTUSI2SSL_RN_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUSI2SSL.Forms(), sffxs{sffxRN_SAE}, []operand.Op{r, x, x1})
}

// VCVTUSI2SSL_RU_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTUSI2SSL.RU_SAE r32 xmm xmm
func VCVTUSI2SSL_RU_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUSI2SSL.Forms(), sffxs{sffxRU_SAE}, []operand.Op{r, x, x1})
}

// VCVTUSI2SSL_RZ_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Zero).
//
// Forms:
//
//	VCVTUSI2SSL.RZ_SAE r32 xmm xmm
func VCVTUSI2SSL_RZ_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUSI2SSL.Forms(), sffxs{sffxRZ_SAE}, []operand.Op{r, x, x1})
}

// VCVTUSI2SSQ: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	VCVTUSI2SSQ m64 xmm xmm
//	VCVTUSI2SSQ r64 xmm xmm
func VCVTUSI2SSQ(mr, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUSI2SSQ.Forms(), sffxs{}, []operand.Op{mr, x, x1})
}

// VCVTUSI2SSQ_RD_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTUSI2SSQ.RD_SAE r64 xmm xmm
func VCVTUSI2SSQ_RD_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUSI2SSQ.Forms(), sffxs{sffxRD_SAE}, []operand.Op{r, x, x1})
}

// VCVTUSI2SSQ_RN_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Nearest).
//
// Forms:
//
//	VCVTUSI2SSQ.RN_SAE r64 xmm xmm
func VCVTUSI2SSQ_RN_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUSI2SSQ.Forms(), sffxs{sffxRN_SAE}, []operand.Op{r, x, x1})
}

// VCVTUSI2SSQ_RU_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTUSI2SSQ.RU_SAE r64 xmm xmm
func VCVTUSI2SSQ_RU_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUSI2SSQ.Forms(), sffxs{sffxRU_SAE}, []operand.Op{r, x, x1})
}

// VCVTUSI2SSQ_RZ_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Zero).
//
// Forms:
//
//	VCVTUSI2SSQ.RZ_SAE r64 xmm xmm
func VCVTUSI2SSQ_RZ_SAE(r, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVCVTUSI2SSQ.Forms(), sffxs{sffxRZ_SAE}, []operand.Op{r, x, x1})
}

// VDBPSADBW: Double Block Packed Sum-Absolute-Differences on Unsigned Bytes.
//
// Forms:
//
//	VDBPSADBW imm8 m128 xmm k xmm
//	VDBPSADBW imm8 m128 xmm xmm
//	VDBPSADBW imm8 m256 ymm k ymm
//	VDBPSADBW imm8 m256 ymm ymm
//	VDBPSADBW imm8 xmm  xmm k xmm
//	VDBPSADBW imm8 xmm  xmm xmm
//	VDBPSADBW imm8 ymm  ymm k ymm
//	VDBPSADBW imm8 ymm  ymm ymm
//	VDBPSADBW imm8 m512 zmm k zmm
//	VDBPSADBW imm8 m512 zmm zmm
//	VDBPSADBW imm8 zmm  zmm k zmm
//	VDBPSADBW imm8 zmm  zmm zmm
func VDBPSADBW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDBPSADBW.Forms(), sffxs{}, ops)
}

// VDBPSADBW_Z: Double Block Packed Sum-Absolute-Differences on Unsigned Bytes (Zeroing Masking).
//
// Forms:
//
//	VDBPSADBW.Z imm8 m128 xmm k xmm
//	VDBPSADBW.Z imm8 m256 ymm k ymm
//	VDBPSADBW.Z imm8 xmm  xmm k xmm
//	VDBPSADBW.Z imm8 ymm  ymm k ymm
//	VDBPSADBW.Z imm8 m512 zmm k zmm
//	VDBPSADBW.Z imm8 zmm  zmm k zmm
func VDBPSADBW_Z(i, mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDBPSADBW.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, xyz, k, xyz1})
}

// VDIVPD: Divide Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VDIVPD m128 xmm xmm
//	VDIVPD m256 ymm ymm
//	VDIVPD xmm  xmm xmm
//	VDIVPD ymm  ymm ymm
//	VDIVPD m128 xmm k xmm
//	VDIVPD m256 ymm k ymm
//	VDIVPD xmm  xmm k xmm
//	VDIVPD ymm  ymm k ymm
//	VDIVPD m512 zmm k zmm
//	VDIVPD m512 zmm zmm
//	VDIVPD zmm  zmm k zmm
//	VDIVPD zmm  zmm zmm
func VDIVPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPD.Forms(), sffxs{}, ops)
}

// VDIVPD_BCST: Divide Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VDIVPD.BCST m64 xmm k xmm
//	VDIVPD.BCST m64 xmm xmm
//	VDIVPD.BCST m64 ymm k ymm
//	VDIVPD.BCST m64 ymm ymm
//	VDIVPD.BCST m64 zmm k zmm
//	VDIVPD.BCST m64 zmm zmm
func VDIVPD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPD.Forms(), sffxs{sffxBCST}, ops)
}

// VDIVPD_BCST_Z: Divide Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VDIVPD.BCST.Z m64 xmm k xmm
//	VDIVPD.BCST.Z m64 ymm k ymm
//	VDIVPD.BCST.Z m64 zmm k zmm
func VDIVPD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VDIVPD_RD_SAE: Divide Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VDIVPD.RD_SAE zmm zmm k zmm
//	VDIVPD.RD_SAE zmm zmm zmm
func VDIVPD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VDIVPD_RD_SAE_Z: Divide Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVPD.RD_SAE.Z zmm zmm k zmm
func VDIVPD_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VDIVPD_RN_SAE: Divide Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VDIVPD.RN_SAE zmm zmm k zmm
//	VDIVPD.RN_SAE zmm zmm zmm
func VDIVPD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VDIVPD_RN_SAE_Z: Divide Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VDIVPD.RN_SAE.Z zmm zmm k zmm
func VDIVPD_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VDIVPD_RU_SAE: Divide Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VDIVPD.RU_SAE zmm zmm k zmm
//	VDIVPD.RU_SAE zmm zmm zmm
func VDIVPD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VDIVPD_RU_SAE_Z: Divide Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVPD.RU_SAE.Z zmm zmm k zmm
func VDIVPD_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VDIVPD_RZ_SAE: Divide Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VDIVPD.RZ_SAE zmm zmm k zmm
//	VDIVPD.RZ_SAE zmm zmm zmm
func VDIVPD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VDIVPD_RZ_SAE_Z: Divide Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VDIVPD.RZ_SAE.Z zmm zmm k zmm
func VDIVPD_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VDIVPD_Z: Divide Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VDIVPD.Z m128 xmm k xmm
//	VDIVPD.Z m256 ymm k ymm
//	VDIVPD.Z xmm  xmm k xmm
//	VDIVPD.Z ymm  ymm k ymm
//	VDIVPD.Z m512 zmm k zmm
//	VDIVPD.Z zmm  zmm k zmm
func VDIVPD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VDIVPS: Divide Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VDIVPS m128 xmm xmm
//	VDIVPS m256 ymm ymm
//	VDIVPS xmm  xmm xmm
//	VDIVPS ymm  ymm ymm
//	VDIVPS m128 xmm k xmm
//	VDIVPS m256 ymm k ymm
//	VDIVPS xmm  xmm k xmm
//	VDIVPS ymm  ymm k ymm
//	VDIVPS m512 zmm k zmm
//	VDIVPS m512 zmm zmm
//	VDIVPS zmm  zmm k zmm
//	VDIVPS zmm  zmm zmm
func VDIVPS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPS.Forms(), sffxs{}, ops)
}

// VDIVPS_BCST: Divide Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VDIVPS.BCST m32 xmm k xmm
//	VDIVPS.BCST m32 xmm xmm
//	VDIVPS.BCST m32 ymm k ymm
//	VDIVPS.BCST m32 ymm ymm
//	VDIVPS.BCST m32 zmm k zmm
//	VDIVPS.BCST m32 zmm zmm
func VDIVPS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPS.Forms(), sffxs{sffxBCST}, ops)
}

// VDIVPS_BCST_Z: Divide Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VDIVPS.BCST.Z m32 xmm k xmm
//	VDIVPS.BCST.Z m32 ymm k ymm
//	VDIVPS.BCST.Z m32 zmm k zmm
func VDIVPS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VDIVPS_RD_SAE: Divide Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VDIVPS.RD_SAE zmm zmm k zmm
//	VDIVPS.RD_SAE zmm zmm zmm
func VDIVPS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VDIVPS_RD_SAE_Z: Divide Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVPS.RD_SAE.Z zmm zmm k zmm
func VDIVPS_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VDIVPS_RN_SAE: Divide Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VDIVPS.RN_SAE zmm zmm k zmm
//	VDIVPS.RN_SAE zmm zmm zmm
func VDIVPS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VDIVPS_RN_SAE_Z: Divide Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VDIVPS.RN_SAE.Z zmm zmm k zmm
func VDIVPS_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VDIVPS_RU_SAE: Divide Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VDIVPS.RU_SAE zmm zmm k zmm
//	VDIVPS.RU_SAE zmm zmm zmm
func VDIVPS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VDIVPS_RU_SAE_Z: Divide Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVPS.RU_SAE.Z zmm zmm k zmm
func VDIVPS_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VDIVPS_RZ_SAE: Divide Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VDIVPS.RZ_SAE zmm zmm k zmm
//	VDIVPS.RZ_SAE zmm zmm zmm
func VDIVPS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VDIVPS_RZ_SAE_Z: Divide Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VDIVPS.RZ_SAE.Z zmm zmm k zmm
func VDIVPS_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VDIVPS_Z: Divide Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VDIVPS.Z m128 xmm k xmm
//	VDIVPS.Z m256 ymm k ymm
//	VDIVPS.Z xmm  xmm k xmm
//	VDIVPS.Z ymm  ymm k ymm
//	VDIVPS.Z m512 zmm k zmm
//	VDIVPS.Z zmm  zmm k zmm
func VDIVPS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVPS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VDIVSD: Divide Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VDIVSD m64 xmm xmm
//	VDIVSD xmm xmm xmm
//	VDIVSD m64 xmm k xmm
//	VDIVSD xmm xmm k xmm
func VDIVSD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVSD.Forms(), sffxs{}, ops)
}

// VDIVSD_RD_SAE: Divide Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VDIVSD.RD_SAE xmm xmm k xmm
//	VDIVSD.RD_SAE xmm xmm xmm
func VDIVSD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVSD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VDIVSD_RD_SAE_Z: Divide Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVSD.RD_SAE.Z xmm xmm k xmm
func VDIVSD_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVSD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VDIVSD_RN_SAE: Divide Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VDIVSD.RN_SAE xmm xmm k xmm
//	VDIVSD.RN_SAE xmm xmm xmm
func VDIVSD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVSD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VDIVSD_RN_SAE_Z: Divide Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VDIVSD.RN_SAE.Z xmm xmm k xmm
func VDIVSD_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVSD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VDIVSD_RU_SAE: Divide Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VDIVSD.RU_SAE xmm xmm k xmm
//	VDIVSD.RU_SAE xmm xmm xmm
func VDIVSD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVSD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VDIVSD_RU_SAE_Z: Divide Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVSD.RU_SAE.Z xmm xmm k xmm
func VDIVSD_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVSD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VDIVSD_RZ_SAE: Divide Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VDIVSD.RZ_SAE xmm xmm k xmm
//	VDIVSD.RZ_SAE xmm xmm xmm
func VDIVSD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVSD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VDIVSD_RZ_SAE_Z: Divide Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VDIVSD.RZ_SAE.Z xmm xmm k xmm
func VDIVSD_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVSD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VDIVSD_Z: Divide Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VDIVSD.Z m64 xmm k xmm
//	VDIVSD.Z xmm xmm k xmm
func VDIVSD_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVSD.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VDIVSS: Divide Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VDIVSS m32 xmm xmm
//	VDIVSS xmm xmm xmm
//	VDIVSS m32 xmm k xmm
//	VDIVSS xmm xmm k xmm
func VDIVSS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVSS.Forms(), sffxs{}, ops)
}

// VDIVSS_RD_SAE: Divide Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VDIVSS.RD_SAE xmm xmm k xmm
//	VDIVSS.RD_SAE xmm xmm xmm
func VDIVSS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVSS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VDIVSS_RD_SAE_Z: Divide Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVSS.RD_SAE.Z xmm xmm k xmm
func VDIVSS_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVSS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VDIVSS_RN_SAE: Divide Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VDIVSS.RN_SAE xmm xmm k xmm
//	VDIVSS.RN_SAE xmm xmm xmm
func VDIVSS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVSS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VDIVSS_RN_SAE_Z: Divide Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VDIVSS.RN_SAE.Z xmm xmm k xmm
func VDIVSS_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVSS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VDIVSS_RU_SAE: Divide Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VDIVSS.RU_SAE xmm xmm k xmm
//	VDIVSS.RU_SAE xmm xmm xmm
func VDIVSS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVSS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VDIVSS_RU_SAE_Z: Divide Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVSS.RU_SAE.Z xmm xmm k xmm
func VDIVSS_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVSS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VDIVSS_RZ_SAE: Divide Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VDIVSS.RZ_SAE xmm xmm k xmm
//	VDIVSS.RZ_SAE xmm xmm xmm
func VDIVSS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVSS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VDIVSS_RZ_SAE_Z: Divide Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VDIVSS.RZ_SAE.Z xmm xmm k xmm
func VDIVSS_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVSS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VDIVSS_Z: Divide Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VDIVSS.Z m32 xmm k xmm
//	VDIVSS.Z xmm xmm k xmm
func VDIVSS_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDIVSS.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VDPPD: Dot Product of Packed Double Precision Floating-Point Values.
//
// Forms:
//
//	VDPPD imm8 m128 xmm xmm
//	VDPPD imm8 xmm  xmm xmm
func VDPPD(i, mx, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDPPD.Forms(), sffxs{}, []operand.Op{i, mx, x, x1})
}

// VDPPS: Dot Product of Packed Single Precision Floating-Point Values.
//
// Forms:
//
//	VDPPS imm8 m128 xmm xmm
//	VDPPS imm8 m256 ymm ymm
//	VDPPS imm8 xmm  xmm xmm
//	VDPPS imm8 ymm  ymm ymm
func VDPPS(i, mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVDPPS.Forms(), sffxs{}, []operand.Op{i, mxy, xy, xy1})
}

// VEXP2PD: Approximation to the Exponential 2^x of Packed Double-Precision Floating-Point Values with Less Than 2^-23 Relative Error.
//
// Forms:
//
//	VEXP2PD m512 k zmm
//	VEXP2PD m512 zmm
//	VEXP2PD zmm  k zmm
//	VEXP2PD zmm  zmm
func VEXP2PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXP2PD.Forms(), sffxs{}, ops)
}

// VEXP2PD_BCST: Approximation to the Exponential 2^x of Packed Double-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Broadcast).
//
// Forms:
//
//	VEXP2PD.BCST m64 k zmm
//	VEXP2PD.BCST m64 zmm
func VEXP2PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXP2PD.Forms(), sffxs{sffxBCST}, ops)
}

// VEXP2PD_BCST_Z: Approximation to the Exponential 2^x of Packed Double-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VEXP2PD.BCST.Z m64 k zmm
func VEXP2PD_BCST_Z(m, k, z operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXP2PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, z})
}

// VEXP2PD_SAE: Approximation to the Exponential 2^x of Packed Double-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Suppress All Exceptions).
//
// Forms:
//
//	VEXP2PD.SAE zmm k zmm
//	VEXP2PD.SAE zmm zmm
func VEXP2PD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXP2PD.Forms(), sffxs{sffxSAE}, ops)
}

// VEXP2PD_SAE_Z: Approximation to the Exponential 2^x of Packed Double-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VEXP2PD.SAE.Z zmm k zmm
func VEXP2PD_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXP2PD.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{z, k, z1})
}

// VEXP2PD_Z: Approximation to the Exponential 2^x of Packed Double-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Zeroing Masking).
//
// Forms:
//
//	VEXP2PD.Z m512 k zmm
//	VEXP2PD.Z zmm  k zmm
func VEXP2PD_Z(mz, k, z operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXP2PD.Forms(), sffxs{sffxZ}, []operand.Op{mz, k, z})
}

// VEXP2PS: Approximation to the Exponential 2^x of Packed Single-Precision Floating-Point Values with Less Than 2^-23 Relative Error.
//
// Forms:
//
//	VEXP2PS m512 k zmm
//	VEXP2PS m512 zmm
//	VEXP2PS zmm  k zmm
//	VEXP2PS zmm  zmm
func VEXP2PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXP2PS.Forms(), sffxs{}, ops)
}

// VEXP2PS_BCST: Approximation to the Exponential 2^x of Packed Single-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Broadcast).
//
// Forms:
//
//	VEXP2PS.BCST m32 k zmm
//	VEXP2PS.BCST m32 zmm
func VEXP2PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXP2PS.Forms(), sffxs{sffxBCST}, ops)
}

// VEXP2PS_BCST_Z: Approximation to the Exponential 2^x of Packed Single-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VEXP2PS.BCST.Z m32 k zmm
func VEXP2PS_BCST_Z(m, k, z operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXP2PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, z})
}

// VEXP2PS_SAE: Approximation to the Exponential 2^x of Packed Single-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Suppress All Exceptions).
//
// Forms:
//
//	VEXP2PS.SAE zmm k zmm
//	VEXP2PS.SAE zmm zmm
func VEXP2PS_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXP2PS.Forms(), sffxs{sffxSAE}, ops)
}

// VEXP2PS_SAE_Z: Approximation to the Exponential 2^x of Packed Single-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VEXP2PS.SAE.Z zmm k zmm
func VEXP2PS_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXP2PS.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{z, k, z1})
}

// VEXP2PS_Z: Approximation to the Exponential 2^x of Packed Single-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Zeroing Masking).
//
// Forms:
//
//	VEXP2PS.Z m512 k zmm
//	VEXP2PS.Z zmm  k zmm
func VEXP2PS_Z(mz, k, z operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXP2PS.Forms(), sffxs{sffxZ}, []operand.Op{mz, k, z})
}

// VEXPANDPD: Load Sparse Packed Double-Precision Floating-Point Values from Dense Memory.
//
// Forms:
//
//	VEXPANDPD m256 k ymm
//	VEXPANDPD m256 ymm
//	VEXPANDPD ymm  k ymm
//	VEXPANDPD ymm  ymm
//	VEXPANDPD m512 k zmm
//	VEXPANDPD m512 zmm
//	VEXPANDPD zmm  k zmm
//	VEXPANDPD zmm  zmm
//	VEXPANDPD m128 k xmm
//	VEXPANDPD m128 xmm
//	VEXPANDPD xmm  k xmm
//	VEXPANDPD xmm  xmm
func VEXPANDPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXPANDPD.Forms(), sffxs{}, ops)
}

// VEXPANDPD_Z: Load Sparse Packed Double-Precision Floating-Point Values from Dense Memory (Zeroing Masking).
//
// Forms:
//
//	VEXPANDPD.Z m256 k ymm
//	VEXPANDPD.Z ymm  k ymm
//	VEXPANDPD.Z m512 k zmm
//	VEXPANDPD.Z zmm  k zmm
//	VEXPANDPD.Z m128 k xmm
//	VEXPANDPD.Z xmm  k xmm
func VEXPANDPD_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXPANDPD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VEXPANDPS: Load Sparse Packed Single-Precision Floating-Point Values from Dense Memory.
//
// Forms:
//
//	VEXPANDPS m128 k xmm
//	VEXPANDPS m128 xmm
//	VEXPANDPS m256 k ymm
//	VEXPANDPS m256 ymm
//	VEXPANDPS xmm  k xmm
//	VEXPANDPS xmm  xmm
//	VEXPANDPS ymm  k ymm
//	VEXPANDPS ymm  ymm
//	VEXPANDPS m512 k zmm
//	VEXPANDPS m512 zmm
//	VEXPANDPS zmm  k zmm
//	VEXPANDPS zmm  zmm
func VEXPANDPS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXPANDPS.Forms(), sffxs{}, ops)
}

// VEXPANDPS_Z: Load Sparse Packed Single-Precision Floating-Point Values from Dense Memory (Zeroing Masking).
//
// Forms:
//
//	VEXPANDPS.Z m128 k xmm
//	VEXPANDPS.Z m256 k ymm
//	VEXPANDPS.Z xmm  k xmm
//	VEXPANDPS.Z ymm  k ymm
//	VEXPANDPS.Z m512 k zmm
//	VEXPANDPS.Z zmm  k zmm
func VEXPANDPS_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXPANDPS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VEXTRACTF128: Extract Packed Floating-Point Values.
//
// Forms:
//
//	VEXTRACTF128 imm8 ymm m128
//	VEXTRACTF128 imm8 ymm xmm
func VEXTRACTF128(i, y, mx operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXTRACTF128.Forms(), sffxs{}, []operand.Op{i, y, mx})
}

// VEXTRACTF32X4: Extract 128 Bits of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VEXTRACTF32X4 imm8 ymm k m128
//	VEXTRACTF32X4 imm8 ymm k xmm
//	VEXTRACTF32X4 imm8 ymm m128
//	VEXTRACTF32X4 imm8 ymm xmm
//	VEXTRACTF32X4 imm8 zmm k m128
//	VEXTRACTF32X4 imm8 zmm k xmm
//	VEXTRACTF32X4 imm8 zmm m128
//	VEXTRACTF32X4 imm8 zmm xmm
func VEXTRACTF32X4(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXTRACTF32X4.Forms(), sffxs{}, ops)
}

// VEXTRACTF32X4_Z: Extract 128 Bits of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTF32X4.Z imm8 ymm k m128
//	VEXTRACTF32X4.Z imm8 ymm k xmm
//	VEXTRACTF32X4.Z imm8 zmm k m128
//	VEXTRACTF32X4.Z imm8 zmm k xmm
func VEXTRACTF32X4_Z(i, yz, k, mx operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXTRACTF32X4.Forms(), sffxs{sffxZ}, []operand.Op{i, yz, k, mx})
}

// VEXTRACTF32X8: Extract 256 Bits of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VEXTRACTF32X8 imm8 zmm k m256
//	VEXTRACTF32X8 imm8 zmm k ymm
//	VEXTRACTF32X8 imm8 zmm m256
//	VEXTRACTF32X8 imm8 zmm ymm
func VEXTRACTF32X8(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXTRACTF32X8.Forms(), sffxs{}, ops)
}

// VEXTRACTF32X8_Z: Extract 256 Bits of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTF32X8.Z imm8 zmm k m256
//	VEXTRACTF32X8.Z imm8 zmm k ymm
func VEXTRACTF32X8_Z(i, z, k, my operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXTRACTF32X8.Forms(), sffxs{sffxZ}, []operand.Op{i, z, k, my})
}

// VEXTRACTF64X2: Extract 128 Bits of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VEXTRACTF64X2 imm8 ymm k m128
//	VEXTRACTF64X2 imm8 ymm k xmm
//	VEXTRACTF64X2 imm8 ymm m128
//	VEXTRACTF64X2 imm8 ymm xmm
//	VEXTRACTF64X2 imm8 zmm k m128
//	VEXTRACTF64X2 imm8 zmm k xmm
//	VEXTRACTF64X2 imm8 zmm m128
//	VEXTRACTF64X2 imm8 zmm xmm
func VEXTRACTF64X2(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXTRACTF64X2.Forms(), sffxs{}, ops)
}

// VEXTRACTF64X2_Z: Extract 128 Bits of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTF64X2.Z imm8 ymm k m128
//	VEXTRACTF64X2.Z imm8 ymm k xmm
//	VEXTRACTF64X2.Z imm8 zmm k m128
//	VEXTRACTF64X2.Z imm8 zmm k xmm
func VEXTRACTF64X2_Z(i, yz, k, mx operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXTRACTF64X2.Forms(), sffxs{sffxZ}, []operand.Op{i, yz, k, mx})
}

// VEXTRACTF64X4: Extract 256 Bits of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VEXTRACTF64X4 imm8 zmm k m256
//	VEXTRACTF64X4 imm8 zmm k ymm
//	VEXTRACTF64X4 imm8 zmm m256
//	VEXTRACTF64X4 imm8 zmm ymm
func VEXTRACTF64X4(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXTRACTF64X4.Forms(), sffxs{}, ops)
}

// VEXTRACTF64X4_Z: Extract 256 Bits of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTF64X4.Z imm8 zmm k m256
//	VEXTRACTF64X4.Z imm8 zmm k ymm
func VEXTRACTF64X4_Z(i, z, k, my operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXTRACTF64X4.Forms(), sffxs{sffxZ}, []operand.Op{i, z, k, my})
}

// VEXTRACTI128: Extract Packed Integer Values.
//
// Forms:
//
//	VEXTRACTI128 imm8 ymm m128
//	VEXTRACTI128 imm8 ymm xmm
func VEXTRACTI128(i, y, mx operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXTRACTI128.Forms(), sffxs{}, []operand.Op{i, y, mx})
}

// VEXTRACTI32X4: Extract 128 Bits of Packed Doubleword Integer Values.
//
// Forms:
//
//	VEXTRACTI32X4 imm8 ymm k m128
//	VEXTRACTI32X4 imm8 ymm k xmm
//	VEXTRACTI32X4 imm8 ymm m128
//	VEXTRACTI32X4 imm8 ymm xmm
//	VEXTRACTI32X4 imm8 zmm k m128
//	VEXTRACTI32X4 imm8 zmm k xmm
//	VEXTRACTI32X4 imm8 zmm m128
//	VEXTRACTI32X4 imm8 zmm xmm
func VEXTRACTI32X4(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXTRACTI32X4.Forms(), sffxs{}, ops)
}

// VEXTRACTI32X4_Z: Extract 128 Bits of Packed Doubleword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTI32X4.Z imm8 ymm k m128
//	VEXTRACTI32X4.Z imm8 ymm k xmm
//	VEXTRACTI32X4.Z imm8 zmm k m128
//	VEXTRACTI32X4.Z imm8 zmm k xmm
func VEXTRACTI32X4_Z(i, yz, k, mx operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXTRACTI32X4.Forms(), sffxs{sffxZ}, []operand.Op{i, yz, k, mx})
}

// VEXTRACTI32X8: Extract 256 Bits of Packed Doubleword Integer Values.
//
// Forms:
//
//	VEXTRACTI32X8 imm8 zmm k m256
//	VEXTRACTI32X8 imm8 zmm k ymm
//	VEXTRACTI32X8 imm8 zmm m256
//	VEXTRACTI32X8 imm8 zmm ymm
func VEXTRACTI32X8(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXTRACTI32X8.Forms(), sffxs{}, ops)
}

// VEXTRACTI32X8_Z: Extract 256 Bits of Packed Doubleword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTI32X8.Z imm8 zmm k m256
//	VEXTRACTI32X8.Z imm8 zmm k ymm
func VEXTRACTI32X8_Z(i, z, k, my operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXTRACTI32X8.Forms(), sffxs{sffxZ}, []operand.Op{i, z, k, my})
}

// VEXTRACTI64X2: Extract 128 Bits of Packed Quadword Integer Values.
//
// Forms:
//
//	VEXTRACTI64X2 imm8 ymm k m128
//	VEXTRACTI64X2 imm8 ymm k xmm
//	VEXTRACTI64X2 imm8 ymm m128
//	VEXTRACTI64X2 imm8 ymm xmm
//	VEXTRACTI64X2 imm8 zmm k m128
//	VEXTRACTI64X2 imm8 zmm k xmm
//	VEXTRACTI64X2 imm8 zmm m128
//	VEXTRACTI64X2 imm8 zmm xmm
func VEXTRACTI64X2(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXTRACTI64X2.Forms(), sffxs{}, ops)
}

// VEXTRACTI64X2_Z: Extract 128 Bits of Packed Quadword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTI64X2.Z imm8 ymm k m128
//	VEXTRACTI64X2.Z imm8 ymm k xmm
//	VEXTRACTI64X2.Z imm8 zmm k m128
//	VEXTRACTI64X2.Z imm8 zmm k xmm
func VEXTRACTI64X2_Z(i, yz, k, mx operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXTRACTI64X2.Forms(), sffxs{sffxZ}, []operand.Op{i, yz, k, mx})
}

// VEXTRACTI64X4: Extract 256 Bits of Packed Quadword Integer Values.
//
// Forms:
//
//	VEXTRACTI64X4 imm8 zmm k m256
//	VEXTRACTI64X4 imm8 zmm k ymm
//	VEXTRACTI64X4 imm8 zmm m256
//	VEXTRACTI64X4 imm8 zmm ymm
func VEXTRACTI64X4(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXTRACTI64X4.Forms(), sffxs{}, ops)
}

// VEXTRACTI64X4_Z: Extract 256 Bits of Packed Quadword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTI64X4.Z imm8 zmm k m256
//	VEXTRACTI64X4.Z imm8 zmm k ymm
func VEXTRACTI64X4_Z(i, z, k, my operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXTRACTI64X4.Forms(), sffxs{sffxZ}, []operand.Op{i, z, k, my})
}

// VEXTRACTPS: Extract Packed Single Precision Floating-Point Value.
//
// Forms:
//
//	VEXTRACTPS imm8 xmm m32
//	VEXTRACTPS imm8 xmm r32
func VEXTRACTPS(i, x, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcVEXTRACTPS.Forms(), sffxs{}, []operand.Op{i, x, mr})
}

// VFIXUPIMMPD: Fix Up Special Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFIXUPIMMPD imm8 m128 xmm k xmm
//	VFIXUPIMMPD imm8 m128 xmm xmm
//	VFIXUPIMMPD imm8 m256 ymm k ymm
//	VFIXUPIMMPD imm8 m256 ymm ymm
//	VFIXUPIMMPD imm8 xmm  xmm k xmm
//	VFIXUPIMMPD imm8 xmm  xmm xmm
//	VFIXUPIMMPD imm8 ymm  ymm k ymm
//	VFIXUPIMMPD imm8 ymm  ymm ymm
//	VFIXUPIMMPD imm8 m512 zmm k zmm
//	VFIXUPIMMPD imm8 m512 zmm zmm
//	VFIXUPIMMPD imm8 zmm  zmm k zmm
//	VFIXUPIMMPD imm8 zmm  zmm zmm
func VFIXUPIMMPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFIXUPIMMPD.Forms(), sffxs{}, ops)
}

// VFIXUPIMMPD_BCST: Fix Up Special Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFIXUPIMMPD.BCST imm8 m64 xmm k xmm
//	VFIXUPIMMPD.BCST imm8 m64 xmm xmm
//	VFIXUPIMMPD.BCST imm8 m64 ymm k ymm
//	VFIXUPIMMPD.BCST imm8 m64 ymm ymm
//	VFIXUPIMMPD.BCST imm8 m64 zmm k zmm
//	VFIXUPIMMPD.BCST imm8 m64 zmm zmm
func VFIXUPIMMPD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFIXUPIMMPD.Forms(), sffxs{sffxBCST}, ops)
}

// VFIXUPIMMPD_BCST_Z: Fix Up Special Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMPD.BCST.Z imm8 m64 xmm k xmm
//	VFIXUPIMMPD.BCST.Z imm8 m64 ymm k ymm
//	VFIXUPIMMPD.BCST.Z imm8 m64 zmm k zmm
func VFIXUPIMMPD_BCST_Z(i, m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFIXUPIMMPD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, xyz, k, xyz1})
}

// VFIXUPIMMPD_SAE: Fix Up Special Packed Double-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VFIXUPIMMPD.SAE imm8 zmm zmm k zmm
//	VFIXUPIMMPD.SAE imm8 zmm zmm zmm
func VFIXUPIMMPD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFIXUPIMMPD.Forms(), sffxs{sffxSAE}, ops)
}

// VFIXUPIMMPD_SAE_Z: Fix Up Special Packed Double-Precision Floating-Point Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMPD.SAE.Z imm8 zmm zmm k zmm
func VFIXUPIMMPD_SAE_Z(i, z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFIXUPIMMPD.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{i, z, z1, k, z2})
}

// VFIXUPIMMPD_Z: Fix Up Special Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMPD.Z imm8 m128 xmm k xmm
//	VFIXUPIMMPD.Z imm8 m256 ymm k ymm
//	VFIXUPIMMPD.Z imm8 xmm  xmm k xmm
//	VFIXUPIMMPD.Z imm8 ymm  ymm k ymm
//	VFIXUPIMMPD.Z imm8 m512 zmm k zmm
//	VFIXUPIMMPD.Z imm8 zmm  zmm k zmm
func VFIXUPIMMPD_Z(i, mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFIXUPIMMPD.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, xyz, k, xyz1})
}

// VFIXUPIMMPS: Fix Up Special Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFIXUPIMMPS imm8 m256 ymm k ymm
//	VFIXUPIMMPS imm8 m256 ymm ymm
//	VFIXUPIMMPS imm8 ymm  ymm k ymm
//	VFIXUPIMMPS imm8 ymm  ymm ymm
//	VFIXUPIMMPS imm8 m512 zmm k zmm
//	VFIXUPIMMPS imm8 m512 zmm zmm
//	VFIXUPIMMPS imm8 zmm  zmm k zmm
//	VFIXUPIMMPS imm8 zmm  zmm zmm
//	VFIXUPIMMPS imm8 m128 xmm k xmm
//	VFIXUPIMMPS imm8 m128 xmm xmm
//	VFIXUPIMMPS imm8 xmm  xmm k xmm
//	VFIXUPIMMPS imm8 xmm  xmm xmm
func VFIXUPIMMPS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFIXUPIMMPS.Forms(), sffxs{}, ops)
}

// VFIXUPIMMPS_BCST: Fix Up Special Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFIXUPIMMPS.BCST imm8 m32 ymm k ymm
//	VFIXUPIMMPS.BCST imm8 m32 ymm ymm
//	VFIXUPIMMPS.BCST imm8 m32 zmm k zmm
//	VFIXUPIMMPS.BCST imm8 m32 zmm zmm
//	VFIXUPIMMPS.BCST imm8 m32 xmm k xmm
//	VFIXUPIMMPS.BCST imm8 m32 xmm xmm
func VFIXUPIMMPS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFIXUPIMMPS.Forms(), sffxs{sffxBCST}, ops)
}

// VFIXUPIMMPS_BCST_Z: Fix Up Special Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMPS.BCST.Z imm8 m32 ymm k ymm
//	VFIXUPIMMPS.BCST.Z imm8 m32 zmm k zmm
//	VFIXUPIMMPS.BCST.Z imm8 m32 xmm k xmm
func VFIXUPIMMPS_BCST_Z(i, m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFIXUPIMMPS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, xyz, k, xyz1})
}

// VFIXUPIMMPS_SAE: Fix Up Special Packed Single-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VFIXUPIMMPS.SAE imm8 zmm zmm k zmm
//	VFIXUPIMMPS.SAE imm8 zmm zmm zmm
func VFIXUPIMMPS_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFIXUPIMMPS.Forms(), sffxs{sffxSAE}, ops)
}

// VFIXUPIMMPS_SAE_Z: Fix Up Special Packed Single-Precision Floating-Point Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMPS.SAE.Z imm8 zmm zmm k zmm
func VFIXUPIMMPS_SAE_Z(i, z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFIXUPIMMPS.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{i, z, z1, k, z2})
}

// VFIXUPIMMPS_Z: Fix Up Special Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMPS.Z imm8 m256 ymm k ymm
//	VFIXUPIMMPS.Z imm8 ymm  ymm k ymm
//	VFIXUPIMMPS.Z imm8 m512 zmm k zmm
//	VFIXUPIMMPS.Z imm8 zmm  zmm k zmm
//	VFIXUPIMMPS.Z imm8 m128 xmm k xmm
//	VFIXUPIMMPS.Z imm8 xmm  xmm k xmm
func VFIXUPIMMPS_Z(i, mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFIXUPIMMPS.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, xyz, k, xyz1})
}

// VFIXUPIMMSD: Fix Up Special Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	VFIXUPIMMSD imm8 m64 xmm k xmm
//	VFIXUPIMMSD imm8 m64 xmm xmm
//	VFIXUPIMMSD imm8 xmm xmm k xmm
//	VFIXUPIMMSD imm8 xmm xmm xmm
func VFIXUPIMMSD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFIXUPIMMSD.Forms(), sffxs{}, ops)
}

// VFIXUPIMMSD_SAE: Fix Up Special Scalar Double-Precision Floating-Point Value (Suppress All Exceptions).
//
// Forms:
//
//	VFIXUPIMMSD.SAE imm8 xmm xmm k xmm
//	VFIXUPIMMSD.SAE imm8 xmm xmm xmm
func VFIXUPIMMSD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFIXUPIMMSD.Forms(), sffxs{sffxSAE}, ops)
}

// VFIXUPIMMSD_SAE_Z: Fix Up Special Scalar Double-Precision Floating-Point Value (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMSD.SAE.Z imm8 xmm xmm k xmm
func VFIXUPIMMSD_SAE_Z(i, x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFIXUPIMMSD.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{i, x, x1, k, x2})
}

// VFIXUPIMMSD_Z: Fix Up Special Scalar Double-Precision Floating-Point Value (Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMSD.Z imm8 m64 xmm k xmm
//	VFIXUPIMMSD.Z imm8 xmm xmm k xmm
func VFIXUPIMMSD_Z(i, mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFIXUPIMMSD.Forms(), sffxs{sffxZ}, []operand.Op{i, mx, x, k, x1})
}

// VFIXUPIMMSS: Fix Up Special Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	VFIXUPIMMSS imm8 m32 xmm k xmm
//	VFIXUPIMMSS imm8 m32 xmm xmm
//	VFIXUPIMMSS imm8 xmm xmm k xmm
//	VFIXUPIMMSS imm8 xmm xmm xmm
func VFIXUPIMMSS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFIXUPIMMSS.Forms(), sffxs{}, ops)
}

// VFIXUPIMMSS_SAE: Fix Up Special Scalar Single-Precision Floating-Point Value (Suppress All Exceptions).
//
// Forms:
//
//	VFIXUPIMMSS.SAE imm8 xmm xmm k xmm
//	VFIXUPIMMSS.SAE imm8 xmm xmm xmm
func VFIXUPIMMSS_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFIXUPIMMSS.Forms(), sffxs{sffxSAE}, ops)
}

// VFIXUPIMMSS_SAE_Z: Fix Up Special Scalar Single-Precision Floating-Point Value (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMSS.SAE.Z imm8 xmm xmm k xmm
func VFIXUPIMMSS_SAE_Z(i, x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFIXUPIMMSS.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{i, x, x1, k, x2})
}

// VFIXUPIMMSS_Z: Fix Up Special Scalar Single-Precision Floating-Point Value (Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMSS.Z imm8 m32 xmm k xmm
//	VFIXUPIMMSS.Z imm8 xmm xmm k xmm
func VFIXUPIMMSS_Z(i, mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFIXUPIMMSS.Forms(), sffxs{sffxZ}, []operand.Op{i, mx, x, k, x1})
}

// VFMADD132PD: Fused Multiply-Add of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD132PD m128 xmm xmm
//	VFMADD132PD m256 ymm ymm
//	VFMADD132PD xmm  xmm xmm
//	VFMADD132PD ymm  ymm ymm
//	VFMADD132PD m128 xmm k xmm
//	VFMADD132PD m256 ymm k ymm
//	VFMADD132PD xmm  xmm k xmm
//	VFMADD132PD ymm  ymm k ymm
//	VFMADD132PD m512 zmm k zmm
//	VFMADD132PD m512 zmm zmm
//	VFMADD132PD zmm  zmm k zmm
//	VFMADD132PD zmm  zmm zmm
func VFMADD132PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PD.Forms(), sffxs{}, ops)
}

// VFMADD132PD_BCST: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADD132PD.BCST m64 xmm k xmm
//	VFMADD132PD.BCST m64 xmm xmm
//	VFMADD132PD.BCST m64 ymm k ymm
//	VFMADD132PD.BCST m64 ymm ymm
//	VFMADD132PD.BCST m64 zmm k zmm
//	VFMADD132PD.BCST m64 zmm zmm
func VFMADD132PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PD.Forms(), sffxs{sffxBCST}, ops)
}

// VFMADD132PD_BCST_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PD.BCST.Z m64 xmm k xmm
//	VFMADD132PD.BCST.Z m64 ymm k ymm
//	VFMADD132PD.BCST.Z m64 zmm k zmm
func VFMADD132PD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMADD132PD_RD_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD132PD.RD_SAE zmm zmm k zmm
//	VFMADD132PD.RD_SAE zmm zmm zmm
func VFMADD132PD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMADD132PD_RD_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PD.RD_SAE.Z zmm zmm k zmm
func VFMADD132PD_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD132PD_RN_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD132PD.RN_SAE zmm zmm k zmm
//	VFMADD132PD.RN_SAE zmm zmm zmm
func VFMADD132PD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMADD132PD_RN_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PD.RN_SAE.Z zmm zmm k zmm
func VFMADD132PD_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD132PD_RU_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD132PD.RU_SAE zmm zmm k zmm
//	VFMADD132PD.RU_SAE zmm zmm zmm
func VFMADD132PD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMADD132PD_RU_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PD.RU_SAE.Z zmm zmm k zmm
func VFMADD132PD_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD132PD_RZ_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD132PD.RZ_SAE zmm zmm k zmm
//	VFMADD132PD.RZ_SAE zmm zmm zmm
func VFMADD132PD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMADD132PD_RZ_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PD.RZ_SAE.Z zmm zmm k zmm
func VFMADD132PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD132PD_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD132PD.Z m128 xmm k xmm
//	VFMADD132PD.Z m256 ymm k ymm
//	VFMADD132PD.Z xmm  xmm k xmm
//	VFMADD132PD.Z ymm  ymm k ymm
//	VFMADD132PD.Z m512 zmm k zmm
//	VFMADD132PD.Z zmm  zmm k zmm
func VFMADD132PD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMADD132PS: Fused Multiply-Add of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD132PS m128 xmm xmm
//	VFMADD132PS m256 ymm ymm
//	VFMADD132PS xmm  xmm xmm
//	VFMADD132PS ymm  ymm ymm
//	VFMADD132PS m128 xmm k xmm
//	VFMADD132PS m256 ymm k ymm
//	VFMADD132PS xmm  xmm k xmm
//	VFMADD132PS ymm  ymm k ymm
//	VFMADD132PS m512 zmm k zmm
//	VFMADD132PS m512 zmm zmm
//	VFMADD132PS zmm  zmm k zmm
//	VFMADD132PS zmm  zmm zmm
func VFMADD132PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PS.Forms(), sffxs{}, ops)
}

// VFMADD132PS_BCST: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADD132PS.BCST m32 xmm k xmm
//	VFMADD132PS.BCST m32 xmm xmm
//	VFMADD132PS.BCST m32 ymm k ymm
//	VFMADD132PS.BCST m32 ymm ymm
//	VFMADD132PS.BCST m32 zmm k zmm
//	VFMADD132PS.BCST m32 zmm zmm
func VFMADD132PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PS.Forms(), sffxs{sffxBCST}, ops)
}

// VFMADD132PS_BCST_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PS.BCST.Z m32 xmm k xmm
//	VFMADD132PS.BCST.Z m32 ymm k ymm
//	VFMADD132PS.BCST.Z m32 zmm k zmm
func VFMADD132PS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMADD132PS_RD_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD132PS.RD_SAE zmm zmm k zmm
//	VFMADD132PS.RD_SAE zmm zmm zmm
func VFMADD132PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMADD132PS_RD_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PS.RD_SAE.Z zmm zmm k zmm
func VFMADD132PS_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD132PS_RN_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD132PS.RN_SAE zmm zmm k zmm
//	VFMADD132PS.RN_SAE zmm zmm zmm
func VFMADD132PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMADD132PS_RN_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PS.RN_SAE.Z zmm zmm k zmm
func VFMADD132PS_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD132PS_RU_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD132PS.RU_SAE zmm zmm k zmm
//	VFMADD132PS.RU_SAE zmm zmm zmm
func VFMADD132PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMADD132PS_RU_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PS.RU_SAE.Z zmm zmm k zmm
func VFMADD132PS_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD132PS_RZ_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD132PS.RZ_SAE zmm zmm k zmm
//	VFMADD132PS.RZ_SAE zmm zmm zmm
func VFMADD132PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMADD132PS_RZ_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PS.RZ_SAE.Z zmm zmm k zmm
func VFMADD132PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD132PS_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD132PS.Z m128 xmm k xmm
//	VFMADD132PS.Z m256 ymm k ymm
//	VFMADD132PS.Z xmm  xmm k xmm
//	VFMADD132PS.Z ymm  ymm k ymm
//	VFMADD132PS.Z m512 zmm k zmm
//	VFMADD132PS.Z zmm  zmm k zmm
func VFMADD132PS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMADD132SD: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD132SD m64 xmm xmm
//	VFMADD132SD xmm xmm xmm
//	VFMADD132SD m64 xmm k xmm
//	VFMADD132SD xmm xmm k xmm
func VFMADD132SD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132SD.Forms(), sffxs{}, ops)
}

// VFMADD132SD_RD_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD132SD.RD_SAE xmm xmm k xmm
//	VFMADD132SD.RD_SAE xmm xmm xmm
func VFMADD132SD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132SD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMADD132SD_RD_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SD.RD_SAE.Z xmm xmm k xmm
func VFMADD132SD_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132SD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD132SD_RN_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD132SD.RN_SAE xmm xmm k xmm
//	VFMADD132SD.RN_SAE xmm xmm xmm
func VFMADD132SD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132SD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMADD132SD_RN_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SD.RN_SAE.Z xmm xmm k xmm
func VFMADD132SD_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132SD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD132SD_RU_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD132SD.RU_SAE xmm xmm k xmm
//	VFMADD132SD.RU_SAE xmm xmm xmm
func VFMADD132SD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132SD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMADD132SD_RU_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SD.RU_SAE.Z xmm xmm k xmm
func VFMADD132SD_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132SD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD132SD_RZ_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD132SD.RZ_SAE xmm xmm k xmm
//	VFMADD132SD.RZ_SAE xmm xmm xmm
func VFMADD132SD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132SD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMADD132SD_RZ_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SD.RZ_SAE.Z xmm xmm k xmm
func VFMADD132SD_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132SD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD132SD_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD132SD.Z m64 xmm k xmm
//	VFMADD132SD.Z xmm xmm k xmm
func VFMADD132SD_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132SD.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFMADD132SS: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD132SS m32 xmm xmm
//	VFMADD132SS xmm xmm xmm
//	VFMADD132SS m32 xmm k xmm
//	VFMADD132SS xmm xmm k xmm
func VFMADD132SS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132SS.Forms(), sffxs{}, ops)
}

// VFMADD132SS_RD_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD132SS.RD_SAE xmm xmm k xmm
//	VFMADD132SS.RD_SAE xmm xmm xmm
func VFMADD132SS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132SS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMADD132SS_RD_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SS.RD_SAE.Z xmm xmm k xmm
func VFMADD132SS_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132SS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD132SS_RN_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD132SS.RN_SAE xmm xmm k xmm
//	VFMADD132SS.RN_SAE xmm xmm xmm
func VFMADD132SS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132SS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMADD132SS_RN_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SS.RN_SAE.Z xmm xmm k xmm
func VFMADD132SS_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132SS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD132SS_RU_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD132SS.RU_SAE xmm xmm k xmm
//	VFMADD132SS.RU_SAE xmm xmm xmm
func VFMADD132SS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132SS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMADD132SS_RU_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SS.RU_SAE.Z xmm xmm k xmm
func VFMADD132SS_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132SS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD132SS_RZ_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD132SS.RZ_SAE xmm xmm k xmm
//	VFMADD132SS.RZ_SAE xmm xmm xmm
func VFMADD132SS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132SS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMADD132SS_RZ_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SS.RZ_SAE.Z xmm xmm k xmm
func VFMADD132SS_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132SS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD132SS_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD132SS.Z m32 xmm k xmm
//	VFMADD132SS.Z xmm xmm k xmm
func VFMADD132SS_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD132SS.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFMADD213PD: Fused Multiply-Add of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD213PD m128 xmm xmm
//	VFMADD213PD m256 ymm ymm
//	VFMADD213PD xmm  xmm xmm
//	VFMADD213PD ymm  ymm ymm
//	VFMADD213PD m128 xmm k xmm
//	VFMADD213PD m256 ymm k ymm
//	VFMADD213PD xmm  xmm k xmm
//	VFMADD213PD ymm  ymm k ymm
//	VFMADD213PD m512 zmm k zmm
//	VFMADD213PD m512 zmm zmm
//	VFMADD213PD zmm  zmm k zmm
//	VFMADD213PD zmm  zmm zmm
func VFMADD213PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PD.Forms(), sffxs{}, ops)
}

// VFMADD213PD_BCST: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADD213PD.BCST m64 xmm k xmm
//	VFMADD213PD.BCST m64 xmm xmm
//	VFMADD213PD.BCST m64 ymm k ymm
//	VFMADD213PD.BCST m64 ymm ymm
//	VFMADD213PD.BCST m64 zmm k zmm
//	VFMADD213PD.BCST m64 zmm zmm
func VFMADD213PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PD.Forms(), sffxs{sffxBCST}, ops)
}

// VFMADD213PD_BCST_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PD.BCST.Z m64 xmm k xmm
//	VFMADD213PD.BCST.Z m64 ymm k ymm
//	VFMADD213PD.BCST.Z m64 zmm k zmm
func VFMADD213PD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMADD213PD_RD_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD213PD.RD_SAE zmm zmm k zmm
//	VFMADD213PD.RD_SAE zmm zmm zmm
func VFMADD213PD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMADD213PD_RD_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PD.RD_SAE.Z zmm zmm k zmm
func VFMADD213PD_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD213PD_RN_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD213PD.RN_SAE zmm zmm k zmm
//	VFMADD213PD.RN_SAE zmm zmm zmm
func VFMADD213PD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMADD213PD_RN_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PD.RN_SAE.Z zmm zmm k zmm
func VFMADD213PD_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD213PD_RU_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD213PD.RU_SAE zmm zmm k zmm
//	VFMADD213PD.RU_SAE zmm zmm zmm
func VFMADD213PD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMADD213PD_RU_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PD.RU_SAE.Z zmm zmm k zmm
func VFMADD213PD_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD213PD_RZ_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD213PD.RZ_SAE zmm zmm k zmm
//	VFMADD213PD.RZ_SAE zmm zmm zmm
func VFMADD213PD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMADD213PD_RZ_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PD.RZ_SAE.Z zmm zmm k zmm
func VFMADD213PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD213PD_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD213PD.Z m128 xmm k xmm
//	VFMADD213PD.Z m256 ymm k ymm
//	VFMADD213PD.Z xmm  xmm k xmm
//	VFMADD213PD.Z ymm  ymm k ymm
//	VFMADD213PD.Z m512 zmm k zmm
//	VFMADD213PD.Z zmm  zmm k zmm
func VFMADD213PD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMADD213PS: Fused Multiply-Add of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD213PS m128 xmm xmm
//	VFMADD213PS m256 ymm ymm
//	VFMADD213PS xmm  xmm xmm
//	VFMADD213PS ymm  ymm ymm
//	VFMADD213PS m128 xmm k xmm
//	VFMADD213PS m256 ymm k ymm
//	VFMADD213PS xmm  xmm k xmm
//	VFMADD213PS ymm  ymm k ymm
//	VFMADD213PS m512 zmm k zmm
//	VFMADD213PS m512 zmm zmm
//	VFMADD213PS zmm  zmm k zmm
//	VFMADD213PS zmm  zmm zmm
func VFMADD213PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PS.Forms(), sffxs{}, ops)
}

// VFMADD213PS_BCST: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADD213PS.BCST m32 xmm k xmm
//	VFMADD213PS.BCST m32 xmm xmm
//	VFMADD213PS.BCST m32 ymm k ymm
//	VFMADD213PS.BCST m32 ymm ymm
//	VFMADD213PS.BCST m32 zmm k zmm
//	VFMADD213PS.BCST m32 zmm zmm
func VFMADD213PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PS.Forms(), sffxs{sffxBCST}, ops)
}

// VFMADD213PS_BCST_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PS.BCST.Z m32 xmm k xmm
//	VFMADD213PS.BCST.Z m32 ymm k ymm
//	VFMADD213PS.BCST.Z m32 zmm k zmm
func VFMADD213PS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMADD213PS_RD_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD213PS.RD_SAE zmm zmm k zmm
//	VFMADD213PS.RD_SAE zmm zmm zmm
func VFMADD213PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMADD213PS_RD_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PS.RD_SAE.Z zmm zmm k zmm
func VFMADD213PS_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD213PS_RN_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD213PS.RN_SAE zmm zmm k zmm
//	VFMADD213PS.RN_SAE zmm zmm zmm
func VFMADD213PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMADD213PS_RN_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PS.RN_SAE.Z zmm zmm k zmm
func VFMADD213PS_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD213PS_RU_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD213PS.RU_SAE zmm zmm k zmm
//	VFMADD213PS.RU_SAE zmm zmm zmm
func VFMADD213PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMADD213PS_RU_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PS.RU_SAE.Z zmm zmm k zmm
func VFMADD213PS_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD213PS_RZ_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD213PS.RZ_SAE zmm zmm k zmm
//	VFMADD213PS.RZ_SAE zmm zmm zmm
func VFMADD213PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMADD213PS_RZ_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PS.RZ_SAE.Z zmm zmm k zmm
func VFMADD213PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD213PS_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD213PS.Z m128 xmm k xmm
//	VFMADD213PS.Z m256 ymm k ymm
//	VFMADD213PS.Z xmm  xmm k xmm
//	VFMADD213PS.Z ymm  ymm k ymm
//	VFMADD213PS.Z m512 zmm k zmm
//	VFMADD213PS.Z zmm  zmm k zmm
func VFMADD213PS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMADD213SD: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD213SD m64 xmm xmm
//	VFMADD213SD xmm xmm xmm
//	VFMADD213SD m64 xmm k xmm
//	VFMADD213SD xmm xmm k xmm
func VFMADD213SD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213SD.Forms(), sffxs{}, ops)
}

// VFMADD213SD_RD_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD213SD.RD_SAE xmm xmm k xmm
//	VFMADD213SD.RD_SAE xmm xmm xmm
func VFMADD213SD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213SD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMADD213SD_RD_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SD.RD_SAE.Z xmm xmm k xmm
func VFMADD213SD_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213SD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD213SD_RN_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD213SD.RN_SAE xmm xmm k xmm
//	VFMADD213SD.RN_SAE xmm xmm xmm
func VFMADD213SD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213SD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMADD213SD_RN_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SD.RN_SAE.Z xmm xmm k xmm
func VFMADD213SD_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213SD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD213SD_RU_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD213SD.RU_SAE xmm xmm k xmm
//	VFMADD213SD.RU_SAE xmm xmm xmm
func VFMADD213SD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213SD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMADD213SD_RU_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SD.RU_SAE.Z xmm xmm k xmm
func VFMADD213SD_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213SD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD213SD_RZ_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD213SD.RZ_SAE xmm xmm k xmm
//	VFMADD213SD.RZ_SAE xmm xmm xmm
func VFMADD213SD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213SD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMADD213SD_RZ_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SD.RZ_SAE.Z xmm xmm k xmm
func VFMADD213SD_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213SD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD213SD_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD213SD.Z m64 xmm k xmm
//	VFMADD213SD.Z xmm xmm k xmm
func VFMADD213SD_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213SD.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFMADD213SS: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD213SS m32 xmm xmm
//	VFMADD213SS xmm xmm xmm
//	VFMADD213SS m32 xmm k xmm
//	VFMADD213SS xmm xmm k xmm
func VFMADD213SS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213SS.Forms(), sffxs{}, ops)
}

// VFMADD213SS_RD_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD213SS.RD_SAE xmm xmm k xmm
//	VFMADD213SS.RD_SAE xmm xmm xmm
func VFMADD213SS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213SS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMADD213SS_RD_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SS.RD_SAE.Z xmm xmm k xmm
func VFMADD213SS_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213SS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD213SS_RN_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD213SS.RN_SAE xmm xmm k xmm
//	VFMADD213SS.RN_SAE xmm xmm xmm
func VFMADD213SS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213SS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMADD213SS_RN_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SS.RN_SAE.Z xmm xmm k xmm
func VFMADD213SS_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213SS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD213SS_RU_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD213SS.RU_SAE xmm xmm k xmm
//	VFMADD213SS.RU_SAE xmm xmm xmm
func VFMADD213SS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213SS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMADD213SS_RU_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SS.RU_SAE.Z xmm xmm k xmm
func VFMADD213SS_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213SS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD213SS_RZ_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD213SS.RZ_SAE xmm xmm k xmm
//	VFMADD213SS.RZ_SAE xmm xmm xmm
func VFMADD213SS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213SS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMADD213SS_RZ_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SS.RZ_SAE.Z xmm xmm k xmm
func VFMADD213SS_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213SS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD213SS_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD213SS.Z m32 xmm k xmm
//	VFMADD213SS.Z xmm xmm k xmm
func VFMADD213SS_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD213SS.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFMADD231PD: Fused Multiply-Add of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD231PD m128 xmm xmm
//	VFMADD231PD m256 ymm ymm
//	VFMADD231PD xmm  xmm xmm
//	VFMADD231PD ymm  ymm ymm
//	VFMADD231PD m128 xmm k xmm
//	VFMADD231PD m256 ymm k ymm
//	VFMADD231PD xmm  xmm k xmm
//	VFMADD231PD ymm  ymm k ymm
//	VFMADD231PD m512 zmm k zmm
//	VFMADD231PD m512 zmm zmm
//	VFMADD231PD zmm  zmm k zmm
//	VFMADD231PD zmm  zmm zmm
func VFMADD231PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PD.Forms(), sffxs{}, ops)
}

// VFMADD231PD_BCST: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADD231PD.BCST m64 xmm k xmm
//	VFMADD231PD.BCST m64 xmm xmm
//	VFMADD231PD.BCST m64 ymm k ymm
//	VFMADD231PD.BCST m64 ymm ymm
//	VFMADD231PD.BCST m64 zmm k zmm
//	VFMADD231PD.BCST m64 zmm zmm
func VFMADD231PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PD.Forms(), sffxs{sffxBCST}, ops)
}

// VFMADD231PD_BCST_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PD.BCST.Z m64 xmm k xmm
//	VFMADD231PD.BCST.Z m64 ymm k ymm
//	VFMADD231PD.BCST.Z m64 zmm k zmm
func VFMADD231PD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMADD231PD_RD_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD231PD.RD_SAE zmm zmm k zmm
//	VFMADD231PD.RD_SAE zmm zmm zmm
func VFMADD231PD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMADD231PD_RD_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PD.RD_SAE.Z zmm zmm k zmm
func VFMADD231PD_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD231PD_RN_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD231PD.RN_SAE zmm zmm k zmm
//	VFMADD231PD.RN_SAE zmm zmm zmm
func VFMADD231PD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMADD231PD_RN_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PD.RN_SAE.Z zmm zmm k zmm
func VFMADD231PD_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD231PD_RU_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD231PD.RU_SAE zmm zmm k zmm
//	VFMADD231PD.RU_SAE zmm zmm zmm
func VFMADD231PD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMADD231PD_RU_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PD.RU_SAE.Z zmm zmm k zmm
func VFMADD231PD_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD231PD_RZ_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD231PD.RZ_SAE zmm zmm k zmm
//	VFMADD231PD.RZ_SAE zmm zmm zmm
func VFMADD231PD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMADD231PD_RZ_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PD.RZ_SAE.Z zmm zmm k zmm
func VFMADD231PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD231PD_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD231PD.Z m128 xmm k xmm
//	VFMADD231PD.Z m256 ymm k ymm
//	VFMADD231PD.Z xmm  xmm k xmm
//	VFMADD231PD.Z ymm  ymm k ymm
//	VFMADD231PD.Z m512 zmm k zmm
//	VFMADD231PD.Z zmm  zmm k zmm
func VFMADD231PD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMADD231PS: Fused Multiply-Add of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD231PS m128 xmm xmm
//	VFMADD231PS m256 ymm ymm
//	VFMADD231PS xmm  xmm xmm
//	VFMADD231PS ymm  ymm ymm
//	VFMADD231PS m128 xmm k xmm
//	VFMADD231PS m256 ymm k ymm
//	VFMADD231PS xmm  xmm k xmm
//	VFMADD231PS ymm  ymm k ymm
//	VFMADD231PS m512 zmm k zmm
//	VFMADD231PS m512 zmm zmm
//	VFMADD231PS zmm  zmm k zmm
//	VFMADD231PS zmm  zmm zmm
func VFMADD231PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PS.Forms(), sffxs{}, ops)
}

// VFMADD231PS_BCST: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADD231PS.BCST m32 xmm k xmm
//	VFMADD231PS.BCST m32 xmm xmm
//	VFMADD231PS.BCST m32 ymm k ymm
//	VFMADD231PS.BCST m32 ymm ymm
//	VFMADD231PS.BCST m32 zmm k zmm
//	VFMADD231PS.BCST m32 zmm zmm
func VFMADD231PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PS.Forms(), sffxs{sffxBCST}, ops)
}

// VFMADD231PS_BCST_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PS.BCST.Z m32 xmm k xmm
//	VFMADD231PS.BCST.Z m32 ymm k ymm
//	VFMADD231PS.BCST.Z m32 zmm k zmm
func VFMADD231PS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMADD231PS_RD_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD231PS.RD_SAE zmm zmm k zmm
//	VFMADD231PS.RD_SAE zmm zmm zmm
func VFMADD231PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMADD231PS_RD_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PS.RD_SAE.Z zmm zmm k zmm
func VFMADD231PS_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD231PS_RN_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD231PS.RN_SAE zmm zmm k zmm
//	VFMADD231PS.RN_SAE zmm zmm zmm
func VFMADD231PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMADD231PS_RN_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PS.RN_SAE.Z zmm zmm k zmm
func VFMADD231PS_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD231PS_RU_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD231PS.RU_SAE zmm zmm k zmm
//	VFMADD231PS.RU_SAE zmm zmm zmm
func VFMADD231PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMADD231PS_RU_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PS.RU_SAE.Z zmm zmm k zmm
func VFMADD231PS_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD231PS_RZ_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD231PS.RZ_SAE zmm zmm k zmm
//	VFMADD231PS.RZ_SAE zmm zmm zmm
func VFMADD231PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMADD231PS_RZ_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PS.RZ_SAE.Z zmm zmm k zmm
func VFMADD231PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADD231PS_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD231PS.Z m128 xmm k xmm
//	VFMADD231PS.Z m256 ymm k ymm
//	VFMADD231PS.Z xmm  xmm k xmm
//	VFMADD231PS.Z ymm  ymm k ymm
//	VFMADD231PS.Z m512 zmm k zmm
//	VFMADD231PS.Z zmm  zmm k zmm
func VFMADD231PS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMADD231SD: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD231SD m64 xmm xmm
//	VFMADD231SD xmm xmm xmm
//	VFMADD231SD m64 xmm k xmm
//	VFMADD231SD xmm xmm k xmm
func VFMADD231SD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231SD.Forms(), sffxs{}, ops)
}

// VFMADD231SD_RD_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD231SD.RD_SAE xmm xmm k xmm
//	VFMADD231SD.RD_SAE xmm xmm xmm
func VFMADD231SD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231SD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMADD231SD_RD_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SD.RD_SAE.Z xmm xmm k xmm
func VFMADD231SD_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231SD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD231SD_RN_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD231SD.RN_SAE xmm xmm k xmm
//	VFMADD231SD.RN_SAE xmm xmm xmm
func VFMADD231SD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231SD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMADD231SD_RN_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SD.RN_SAE.Z xmm xmm k xmm
func VFMADD231SD_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231SD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD231SD_RU_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD231SD.RU_SAE xmm xmm k xmm
//	VFMADD231SD.RU_SAE xmm xmm xmm
func VFMADD231SD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231SD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMADD231SD_RU_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SD.RU_SAE.Z xmm xmm k xmm
func VFMADD231SD_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231SD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD231SD_RZ_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD231SD.RZ_SAE xmm xmm k xmm
//	VFMADD231SD.RZ_SAE xmm xmm xmm
func VFMADD231SD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231SD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMADD231SD_RZ_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SD.RZ_SAE.Z xmm xmm k xmm
func VFMADD231SD_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231SD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD231SD_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD231SD.Z m64 xmm k xmm
//	VFMADD231SD.Z xmm xmm k xmm
func VFMADD231SD_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231SD.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFMADD231SS: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD231SS m32 xmm xmm
//	VFMADD231SS xmm xmm xmm
//	VFMADD231SS m32 xmm k xmm
//	VFMADD231SS xmm xmm k xmm
func VFMADD231SS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231SS.Forms(), sffxs{}, ops)
}

// VFMADD231SS_RD_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD231SS.RD_SAE xmm xmm k xmm
//	VFMADD231SS.RD_SAE xmm xmm xmm
func VFMADD231SS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231SS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMADD231SS_RD_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SS.RD_SAE.Z xmm xmm k xmm
func VFMADD231SS_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231SS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD231SS_RN_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD231SS.RN_SAE xmm xmm k xmm
//	VFMADD231SS.RN_SAE xmm xmm xmm
func VFMADD231SS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231SS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMADD231SS_RN_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SS.RN_SAE.Z xmm xmm k xmm
func VFMADD231SS_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231SS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD231SS_RU_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD231SS.RU_SAE xmm xmm k xmm
//	VFMADD231SS.RU_SAE xmm xmm xmm
func VFMADD231SS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231SS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMADD231SS_RU_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SS.RU_SAE.Z xmm xmm k xmm
func VFMADD231SS_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231SS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD231SS_RZ_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD231SS.RZ_SAE xmm xmm k xmm
//	VFMADD231SS.RZ_SAE xmm xmm xmm
func VFMADD231SS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231SS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMADD231SS_RZ_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SS.RZ_SAE.Z xmm xmm k xmm
func VFMADD231SS_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231SS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMADD231SS_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD231SS.Z m32 xmm k xmm
//	VFMADD231SS.Z xmm xmm k xmm
func VFMADD231SS_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADD231SS.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFMADDSUB132PD: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADDSUB132PD m128 xmm xmm
//	VFMADDSUB132PD m256 ymm ymm
//	VFMADDSUB132PD xmm  xmm xmm
//	VFMADDSUB132PD ymm  ymm ymm
//	VFMADDSUB132PD m128 xmm k xmm
//	VFMADDSUB132PD m256 ymm k ymm
//	VFMADDSUB132PD xmm  xmm k xmm
//	VFMADDSUB132PD ymm  ymm k ymm
//	VFMADDSUB132PD m512 zmm k zmm
//	VFMADDSUB132PD m512 zmm zmm
//	VFMADDSUB132PD zmm  zmm k zmm
//	VFMADDSUB132PD zmm  zmm zmm
func VFMADDSUB132PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PD.Forms(), sffxs{}, ops)
}

// VFMADDSUB132PD_BCST: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADDSUB132PD.BCST m64 xmm k xmm
//	VFMADDSUB132PD.BCST m64 xmm xmm
//	VFMADDSUB132PD.BCST m64 ymm k ymm
//	VFMADDSUB132PD.BCST m64 ymm ymm
//	VFMADDSUB132PD.BCST m64 zmm k zmm
//	VFMADDSUB132PD.BCST m64 zmm zmm
func VFMADDSUB132PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PD.Forms(), sffxs{sffxBCST}, ops)
}

// VFMADDSUB132PD_BCST_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PD.BCST.Z m64 xmm k xmm
//	VFMADDSUB132PD.BCST.Z m64 ymm k ymm
//	VFMADDSUB132PD.BCST.Z m64 zmm k zmm
func VFMADDSUB132PD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMADDSUB132PD_RD_SAE: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADDSUB132PD.RD_SAE zmm zmm k zmm
//	VFMADDSUB132PD.RD_SAE zmm zmm zmm
func VFMADDSUB132PD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMADDSUB132PD_RD_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PD.RD_SAE.Z zmm zmm k zmm
func VFMADDSUB132PD_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB132PD_RN_SAE: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADDSUB132PD.RN_SAE zmm zmm k zmm
//	VFMADDSUB132PD.RN_SAE zmm zmm zmm
func VFMADDSUB132PD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMADDSUB132PD_RN_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PD.RN_SAE.Z zmm zmm k zmm
func VFMADDSUB132PD_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB132PD_RU_SAE: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADDSUB132PD.RU_SAE zmm zmm k zmm
//	VFMADDSUB132PD.RU_SAE zmm zmm zmm
func VFMADDSUB132PD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMADDSUB132PD_RU_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PD.RU_SAE.Z zmm zmm k zmm
func VFMADDSUB132PD_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB132PD_RZ_SAE: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADDSUB132PD.RZ_SAE zmm zmm k zmm
//	VFMADDSUB132PD.RZ_SAE zmm zmm zmm
func VFMADDSUB132PD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMADDSUB132PD_RZ_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PD.RZ_SAE.Z zmm zmm k zmm
func VFMADDSUB132PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB132PD_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PD.Z m128 xmm k xmm
//	VFMADDSUB132PD.Z m256 ymm k ymm
//	VFMADDSUB132PD.Z xmm  xmm k xmm
//	VFMADDSUB132PD.Z ymm  ymm k ymm
//	VFMADDSUB132PD.Z m512 zmm k zmm
//	VFMADDSUB132PD.Z zmm  zmm k zmm
func VFMADDSUB132PD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMADDSUB132PS: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADDSUB132PS m128 xmm xmm
//	VFMADDSUB132PS m256 ymm ymm
//	VFMADDSUB132PS xmm  xmm xmm
//	VFMADDSUB132PS ymm  ymm ymm
//	VFMADDSUB132PS m128 xmm k xmm
//	VFMADDSUB132PS m256 ymm k ymm
//	VFMADDSUB132PS xmm  xmm k xmm
//	VFMADDSUB132PS ymm  ymm k ymm
//	VFMADDSUB132PS m512 zmm k zmm
//	VFMADDSUB132PS m512 zmm zmm
//	VFMADDSUB132PS zmm  zmm k zmm
//	VFMADDSUB132PS zmm  zmm zmm
func VFMADDSUB132PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PS.Forms(), sffxs{}, ops)
}

// VFMADDSUB132PS_BCST: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADDSUB132PS.BCST m32 xmm k xmm
//	VFMADDSUB132PS.BCST m32 xmm xmm
//	VFMADDSUB132PS.BCST m32 ymm k ymm
//	VFMADDSUB132PS.BCST m32 ymm ymm
//	VFMADDSUB132PS.BCST m32 zmm k zmm
//	VFMADDSUB132PS.BCST m32 zmm zmm
func VFMADDSUB132PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PS.Forms(), sffxs{sffxBCST}, ops)
}

// VFMADDSUB132PS_BCST_Z: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PS.BCST.Z m32 xmm k xmm
//	VFMADDSUB132PS.BCST.Z m32 ymm k ymm
//	VFMADDSUB132PS.BCST.Z m32 zmm k zmm
func VFMADDSUB132PS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMADDSUB132PS_RD_SAE: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADDSUB132PS.RD_SAE zmm zmm k zmm
//	VFMADDSUB132PS.RD_SAE zmm zmm zmm
func VFMADDSUB132PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMADDSUB132PS_RD_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PS.RD_SAE.Z zmm zmm k zmm
func VFMADDSUB132PS_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB132PS_RN_SAE: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADDSUB132PS.RN_SAE zmm zmm k zmm
//	VFMADDSUB132PS.RN_SAE zmm zmm zmm
func VFMADDSUB132PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMADDSUB132PS_RN_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PS.RN_SAE.Z zmm zmm k zmm
func VFMADDSUB132PS_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB132PS_RU_SAE: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADDSUB132PS.RU_SAE zmm zmm k zmm
//	VFMADDSUB132PS.RU_SAE zmm zmm zmm
func VFMADDSUB132PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMADDSUB132PS_RU_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PS.RU_SAE.Z zmm zmm k zmm
func VFMADDSUB132PS_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB132PS_RZ_SAE: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADDSUB132PS.RZ_SAE zmm zmm k zmm
//	VFMADDSUB132PS.RZ_SAE zmm zmm zmm
func VFMADDSUB132PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMADDSUB132PS_RZ_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PS.RZ_SAE.Z zmm zmm k zmm
func VFMADDSUB132PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB132PS_Z: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PS.Z m128 xmm k xmm
//	VFMADDSUB132PS.Z m256 ymm k ymm
//	VFMADDSUB132PS.Z xmm  xmm k xmm
//	VFMADDSUB132PS.Z ymm  ymm k ymm
//	VFMADDSUB132PS.Z m512 zmm k zmm
//	VFMADDSUB132PS.Z zmm  zmm k zmm
func VFMADDSUB132PS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB132PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMADDSUB213PD: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADDSUB213PD m128 xmm xmm
//	VFMADDSUB213PD m256 ymm ymm
//	VFMADDSUB213PD xmm  xmm xmm
//	VFMADDSUB213PD ymm  ymm ymm
//	VFMADDSUB213PD m128 xmm k xmm
//	VFMADDSUB213PD m256 ymm k ymm
//	VFMADDSUB213PD xmm  xmm k xmm
//	VFMADDSUB213PD ymm  ymm k ymm
//	VFMADDSUB213PD m512 zmm k zmm
//	VFMADDSUB213PD m512 zmm zmm
//	VFMADDSUB213PD zmm  zmm k zmm
//	VFMADDSUB213PD zmm  zmm zmm
func VFMADDSUB213PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PD.Forms(), sffxs{}, ops)
}

// VFMADDSUB213PD_BCST: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADDSUB213PD.BCST m64 xmm k xmm
//	VFMADDSUB213PD.BCST m64 xmm xmm
//	VFMADDSUB213PD.BCST m64 ymm k ymm
//	VFMADDSUB213PD.BCST m64 ymm ymm
//	VFMADDSUB213PD.BCST m64 zmm k zmm
//	VFMADDSUB213PD.BCST m64 zmm zmm
func VFMADDSUB213PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PD.Forms(), sffxs{sffxBCST}, ops)
}

// VFMADDSUB213PD_BCST_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB213PD.BCST.Z m64 xmm k xmm
//	VFMADDSUB213PD.BCST.Z m64 ymm k ymm
//	VFMADDSUB213PD.BCST.Z m64 zmm k zmm
func VFMADDSUB213PD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMADDSUB213PD_RD_SAE: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADDSUB213PD.RD_SAE zmm zmm k zmm
//	VFMADDSUB213PD.RD_SAE zmm zmm zmm
func VFMADDSUB213PD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMADDSUB213PD_RD_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB213PD.RD_SAE.Z zmm zmm k zmm
func VFMADDSUB213PD_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB213PD_RN_SAE: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADDSUB213PD.RN_SAE zmm zmm k zmm
//	VFMADDSUB213PD.RN_SAE zmm zmm zmm
func VFMADDSUB213PD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMADDSUB213PD_RN_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB213PD.RN_SAE.Z zmm zmm k zmm
func VFMADDSUB213PD_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB213PD_RU_SAE: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADDSUB213PD.RU_SAE zmm zmm k zmm
//	VFMADDSUB213PD.RU_SAE zmm zmm zmm
func VFMADDSUB213PD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMADDSUB213PD_RU_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB213PD.RU_SAE.Z zmm zmm k zmm
func VFMADDSUB213PD_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB213PD_RZ_SAE: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADDSUB213PD.RZ_SAE zmm zmm k zmm
//	VFMADDSUB213PD.RZ_SAE zmm zmm zmm
func VFMADDSUB213PD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMADDSUB213PD_RZ_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB213PD.RZ_SAE.Z zmm zmm k zmm
func VFMADDSUB213PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB213PD_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB213PD.Z m128 xmm k xmm
//	VFMADDSUB213PD.Z m256 ymm k ymm
//	VFMADDSUB213PD.Z xmm  xmm k xmm
//	VFMADDSUB213PD.Z ymm  ymm k ymm
//	VFMADDSUB213PD.Z m512 zmm k zmm
//	VFMADDSUB213PD.Z zmm  zmm k zmm
func VFMADDSUB213PD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMADDSUB213PS: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADDSUB213PS m128 xmm xmm
//	VFMADDSUB213PS m256 ymm ymm
//	VFMADDSUB213PS xmm  xmm xmm
//	VFMADDSUB213PS ymm  ymm ymm
//	VFMADDSUB213PS m128 xmm k xmm
//	VFMADDSUB213PS m256 ymm k ymm
//	VFMADDSUB213PS xmm  xmm k xmm
//	VFMADDSUB213PS ymm  ymm k ymm
//	VFMADDSUB213PS m512 zmm k zmm
//	VFMADDSUB213PS m512 zmm zmm
//	VFMADDSUB213PS zmm  zmm k zmm
//	VFMADDSUB213PS zmm  zmm zmm
func VFMADDSUB213PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PS.Forms(), sffxs{}, ops)
}

// VFMADDSUB213PS_BCST: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADDSUB213PS.BCST m32 xmm k xmm
//	VFMADDSUB213PS.BCST m32 xmm xmm
//	VFMADDSUB213PS.BCST m32 ymm k ymm
//	VFMADDSUB213PS.BCST m32 ymm ymm
//	VFMADDSUB213PS.BCST m32 zmm k zmm
//	VFMADDSUB213PS.BCST m32 zmm zmm
func VFMADDSUB213PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PS.Forms(), sffxs{sffxBCST}, ops)
}

// VFMADDSUB213PS_BCST_Z: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB213PS.BCST.Z m32 xmm k xmm
//	VFMADDSUB213PS.BCST.Z m32 ymm k ymm
//	VFMADDSUB213PS.BCST.Z m32 zmm k zmm
func VFMADDSUB213PS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMADDSUB213PS_RD_SAE: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADDSUB213PS.RD_SAE zmm zmm k zmm
//	VFMADDSUB213PS.RD_SAE zmm zmm zmm
func VFMADDSUB213PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMADDSUB213PS_RD_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB213PS.RD_SAE.Z zmm zmm k zmm
func VFMADDSUB213PS_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB213PS_RN_SAE: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADDSUB213PS.RN_SAE zmm zmm k zmm
//	VFMADDSUB213PS.RN_SAE zmm zmm zmm
func VFMADDSUB213PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMADDSUB213PS_RN_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB213PS.RN_SAE.Z zmm zmm k zmm
func VFMADDSUB213PS_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB213PS_RU_SAE: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADDSUB213PS.RU_SAE zmm zmm k zmm
//	VFMADDSUB213PS.RU_SAE zmm zmm zmm
func VFMADDSUB213PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMADDSUB213PS_RU_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB213PS.RU_SAE.Z zmm zmm k zmm
func VFMADDSUB213PS_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB213PS_RZ_SAE: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADDSUB213PS.RZ_SAE zmm zmm k zmm
//	VFMADDSUB213PS.RZ_SAE zmm zmm zmm
func VFMADDSUB213PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMADDSUB213PS_RZ_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB213PS.RZ_SAE.Z zmm zmm k zmm
func VFMADDSUB213PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB213PS_Z: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB213PS.Z m128 xmm k xmm
//	VFMADDSUB213PS.Z m256 ymm k ymm
//	VFMADDSUB213PS.Z xmm  xmm k xmm
//	VFMADDSUB213PS.Z ymm  ymm k ymm
//	VFMADDSUB213PS.Z m512 zmm k zmm
//	VFMADDSUB213PS.Z zmm  zmm k zmm
func VFMADDSUB213PS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB213PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMADDSUB231PD: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADDSUB231PD m128 xmm xmm
//	VFMADDSUB231PD m256 ymm ymm
//	VFMADDSUB231PD xmm  xmm xmm
//	VFMADDSUB231PD ymm  ymm ymm
//	VFMADDSUB231PD m128 xmm k xmm
//	VFMADDSUB231PD m256 ymm k ymm
//	VFMADDSUB231PD xmm  xmm k xmm
//	VFMADDSUB231PD ymm  ymm k ymm
//	VFMADDSUB231PD m512 zmm k zmm
//	VFMADDSUB231PD m512 zmm zmm
//	VFMADDSUB231PD zmm  zmm k zmm
//	VFMADDSUB231PD zmm  zmm zmm
func VFMADDSUB231PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PD.Forms(), sffxs{}, ops)
}

// VFMADDSUB231PD_BCST: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADDSUB231PD.BCST m64 xmm k xmm
//	VFMADDSUB231PD.BCST m64 xmm xmm
//	VFMADDSUB231PD.BCST m64 ymm k ymm
//	VFMADDSUB231PD.BCST m64 ymm ymm
//	VFMADDSUB231PD.BCST m64 zmm k zmm
//	VFMADDSUB231PD.BCST m64 zmm zmm
func VFMADDSUB231PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PD.Forms(), sffxs{sffxBCST}, ops)
}

// VFMADDSUB231PD_BCST_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB231PD.BCST.Z m64 xmm k xmm
//	VFMADDSUB231PD.BCST.Z m64 ymm k ymm
//	VFMADDSUB231PD.BCST.Z m64 zmm k zmm
func VFMADDSUB231PD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMADDSUB231PD_RD_SAE: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADDSUB231PD.RD_SAE zmm zmm k zmm
//	VFMADDSUB231PD.RD_SAE zmm zmm zmm
func VFMADDSUB231PD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMADDSUB231PD_RD_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB231PD.RD_SAE.Z zmm zmm k zmm
func VFMADDSUB231PD_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB231PD_RN_SAE: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADDSUB231PD.RN_SAE zmm zmm k zmm
//	VFMADDSUB231PD.RN_SAE zmm zmm zmm
func VFMADDSUB231PD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMADDSUB231PD_RN_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB231PD.RN_SAE.Z zmm zmm k zmm
func VFMADDSUB231PD_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB231PD_RU_SAE: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADDSUB231PD.RU_SAE zmm zmm k zmm
//	VFMADDSUB231PD.RU_SAE zmm zmm zmm
func VFMADDSUB231PD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMADDSUB231PD_RU_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB231PD.RU_SAE.Z zmm zmm k zmm
func VFMADDSUB231PD_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB231PD_RZ_SAE: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADDSUB231PD.RZ_SAE zmm zmm k zmm
//	VFMADDSUB231PD.RZ_SAE zmm zmm zmm
func VFMADDSUB231PD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMADDSUB231PD_RZ_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB231PD.RZ_SAE.Z zmm zmm k zmm
func VFMADDSUB231PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB231PD_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB231PD.Z m128 xmm k xmm
//	VFMADDSUB231PD.Z m256 ymm k ymm
//	VFMADDSUB231PD.Z xmm  xmm k xmm
//	VFMADDSUB231PD.Z ymm  ymm k ymm
//	VFMADDSUB231PD.Z m512 zmm k zmm
//	VFMADDSUB231PD.Z zmm  zmm k zmm
func VFMADDSUB231PD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMADDSUB231PS: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADDSUB231PS m128 xmm xmm
//	VFMADDSUB231PS m256 ymm ymm
//	VFMADDSUB231PS xmm  xmm xmm
//	VFMADDSUB231PS ymm  ymm ymm
//	VFMADDSUB231PS m128 xmm k xmm
//	VFMADDSUB231PS m256 ymm k ymm
//	VFMADDSUB231PS xmm  xmm k xmm
//	VFMADDSUB231PS ymm  ymm k ymm
//	VFMADDSUB231PS m512 zmm k zmm
//	VFMADDSUB231PS m512 zmm zmm
//	VFMADDSUB231PS zmm  zmm k zmm
//	VFMADDSUB231PS zmm  zmm zmm
func VFMADDSUB231PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PS.Forms(), sffxs{}, ops)
}

// VFMADDSUB231PS_BCST: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADDSUB231PS.BCST m32 xmm k xmm
//	VFMADDSUB231PS.BCST m32 xmm xmm
//	VFMADDSUB231PS.BCST m32 ymm k ymm
//	VFMADDSUB231PS.BCST m32 ymm ymm
//	VFMADDSUB231PS.BCST m32 zmm k zmm
//	VFMADDSUB231PS.BCST m32 zmm zmm
func VFMADDSUB231PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PS.Forms(), sffxs{sffxBCST}, ops)
}

// VFMADDSUB231PS_BCST_Z: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB231PS.BCST.Z m32 xmm k xmm
//	VFMADDSUB231PS.BCST.Z m32 ymm k ymm
//	VFMADDSUB231PS.BCST.Z m32 zmm k zmm
func VFMADDSUB231PS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMADDSUB231PS_RD_SAE: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADDSUB231PS.RD_SAE zmm zmm k zmm
//	VFMADDSUB231PS.RD_SAE zmm zmm zmm
func VFMADDSUB231PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMADDSUB231PS_RD_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB231PS.RD_SAE.Z zmm zmm k zmm
func VFMADDSUB231PS_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB231PS_RN_SAE: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADDSUB231PS.RN_SAE zmm zmm k zmm
//	VFMADDSUB231PS.RN_SAE zmm zmm zmm
func VFMADDSUB231PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMADDSUB231PS_RN_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB231PS.RN_SAE.Z zmm zmm k zmm
func VFMADDSUB231PS_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB231PS_RU_SAE: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADDSUB231PS.RU_SAE zmm zmm k zmm
//	VFMADDSUB231PS.RU_SAE zmm zmm zmm
func VFMADDSUB231PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMADDSUB231PS_RU_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB231PS.RU_SAE.Z zmm zmm k zmm
func VFMADDSUB231PS_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB231PS_RZ_SAE: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADDSUB231PS.RZ_SAE zmm zmm k zmm
//	VFMADDSUB231PS.RZ_SAE zmm zmm zmm
func VFMADDSUB231PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMADDSUB231PS_RZ_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB231PS.RZ_SAE.Z zmm zmm k zmm
func VFMADDSUB231PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMADDSUB231PS_Z: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB231PS.Z m128 xmm k xmm
//	VFMADDSUB231PS.Z m256 ymm k ymm
//	VFMADDSUB231PS.Z xmm  xmm k xmm
//	VFMADDSUB231PS.Z ymm  ymm k ymm
//	VFMADDSUB231PS.Z m512 zmm k zmm
//	VFMADDSUB231PS.Z zmm  zmm k zmm
func VFMADDSUB231PS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMADDSUB231PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMSUB132PD: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMSUB132PD m128 xmm xmm
//	VFMSUB132PD m256 ymm ymm
//	VFMSUB132PD xmm  xmm xmm
//	VFMSUB132PD ymm  ymm ymm
//	VFMSUB132PD m128 xmm k xmm
//	VFMSUB132PD m256 ymm k ymm
//	VFMSUB132PD xmm  xmm k xmm
//	VFMSUB132PD ymm  ymm k ymm
//	VFMSUB132PD m512 zmm k zmm
//	VFMSUB132PD m512 zmm zmm
//	VFMSUB132PD zmm  zmm k zmm
//	VFMSUB132PD zmm  zmm zmm
func VFMSUB132PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PD.Forms(), sffxs{}, ops)
}

// VFMSUB132PD_BCST: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMSUB132PD.BCST m64 xmm k xmm
//	VFMSUB132PD.BCST m64 xmm xmm
//	VFMSUB132PD.BCST m64 ymm k ymm
//	VFMSUB132PD.BCST m64 ymm ymm
//	VFMSUB132PD.BCST m64 zmm k zmm
//	VFMSUB132PD.BCST m64 zmm zmm
func VFMSUB132PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PD.Forms(), sffxs{sffxBCST}, ops)
}

// VFMSUB132PD_BCST_Z: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMSUB132PD.BCST.Z m64 xmm k xmm
//	VFMSUB132PD.BCST.Z m64 ymm k ymm
//	VFMSUB132PD.BCST.Z m64 zmm k zmm
func VFMSUB132PD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMSUB132PD_RD_SAE: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMSUB132PD.RD_SAE zmm zmm k zmm
//	VFMSUB132PD.RD_SAE zmm zmm zmm
func VFMSUB132PD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMSUB132PD_RD_SAE_Z: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB132PD.RD_SAE.Z zmm zmm k zmm
func VFMSUB132PD_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB132PD_RN_SAE: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMSUB132PD.RN_SAE zmm zmm k zmm
//	VFMSUB132PD.RN_SAE zmm zmm zmm
func VFMSUB132PD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMSUB132PD_RN_SAE_Z: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMSUB132PD.RN_SAE.Z zmm zmm k zmm
func VFMSUB132PD_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB132PD_RU_SAE: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMSUB132PD.RU_SAE zmm zmm k zmm
//	VFMSUB132PD.RU_SAE zmm zmm zmm
func VFMSUB132PD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMSUB132PD_RU_SAE_Z: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB132PD.RU_SAE.Z zmm zmm k zmm
func VFMSUB132PD_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB132PD_RZ_SAE: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMSUB132PD.RZ_SAE zmm zmm k zmm
//	VFMSUB132PD.RZ_SAE zmm zmm zmm
func VFMSUB132PD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMSUB132PD_RZ_SAE_Z: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMSUB132PD.RZ_SAE.Z zmm zmm k zmm
func VFMSUB132PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB132PD_Z: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMSUB132PD.Z m128 xmm k xmm
//	VFMSUB132PD.Z m256 ymm k ymm
//	VFMSUB132PD.Z xmm  xmm k xmm
//	VFMSUB132PD.Z ymm  ymm k ymm
//	VFMSUB132PD.Z m512 zmm k zmm
//	VFMSUB132PD.Z zmm  zmm k zmm
func VFMSUB132PD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMSUB132PS: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMSUB132PS m128 xmm xmm
//	VFMSUB132PS m256 ymm ymm
//	VFMSUB132PS xmm  xmm xmm
//	VFMSUB132PS ymm  ymm ymm
//	VFMSUB132PS m128 xmm k xmm
//	VFMSUB132PS m256 ymm k ymm
//	VFMSUB132PS xmm  xmm k xmm
//	VFMSUB132PS ymm  ymm k ymm
//	VFMSUB132PS m512 zmm k zmm
//	VFMSUB132PS m512 zmm zmm
//	VFMSUB132PS zmm  zmm k zmm
//	VFMSUB132PS zmm  zmm zmm
func VFMSUB132PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PS.Forms(), sffxs{}, ops)
}

// VFMSUB132PS_BCST: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMSUB132PS.BCST m32 xmm k xmm
//	VFMSUB132PS.BCST m32 xmm xmm
//	VFMSUB132PS.BCST m32 ymm k ymm
//	VFMSUB132PS.BCST m32 ymm ymm
//	VFMSUB132PS.BCST m32 zmm k zmm
//	VFMSUB132PS.BCST m32 zmm zmm
func VFMSUB132PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PS.Forms(), sffxs{sffxBCST}, ops)
}

// VFMSUB132PS_BCST_Z: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMSUB132PS.BCST.Z m32 xmm k xmm
//	VFMSUB132PS.BCST.Z m32 ymm k ymm
//	VFMSUB132PS.BCST.Z m32 zmm k zmm
func VFMSUB132PS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMSUB132PS_RD_SAE: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMSUB132PS.RD_SAE zmm zmm k zmm
//	VFMSUB132PS.RD_SAE zmm zmm zmm
func VFMSUB132PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMSUB132PS_RD_SAE_Z: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB132PS.RD_SAE.Z zmm zmm k zmm
func VFMSUB132PS_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB132PS_RN_SAE: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMSUB132PS.RN_SAE zmm zmm k zmm
//	VFMSUB132PS.RN_SAE zmm zmm zmm
func VFMSUB132PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMSUB132PS_RN_SAE_Z: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMSUB132PS.RN_SAE.Z zmm zmm k zmm
func VFMSUB132PS_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB132PS_RU_SAE: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMSUB132PS.RU_SAE zmm zmm k zmm
//	VFMSUB132PS.RU_SAE zmm zmm zmm
func VFMSUB132PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMSUB132PS_RU_SAE_Z: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB132PS.RU_SAE.Z zmm zmm k zmm
func VFMSUB132PS_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB132PS_RZ_SAE: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMSUB132PS.RZ_SAE zmm zmm k zmm
//	VFMSUB132PS.RZ_SAE zmm zmm zmm
func VFMSUB132PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMSUB132PS_RZ_SAE_Z: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMSUB132PS.RZ_SAE.Z zmm zmm k zmm
func VFMSUB132PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB132PS_Z: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMSUB132PS.Z m128 xmm k xmm
//	VFMSUB132PS.Z m256 ymm k ymm
//	VFMSUB132PS.Z xmm  xmm k xmm
//	VFMSUB132PS.Z ymm  ymm k ymm
//	VFMSUB132PS.Z m512 zmm k zmm
//	VFMSUB132PS.Z zmm  zmm k zmm
func VFMSUB132PS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMSUB132SD: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMSUB132SD m64 xmm xmm
//	VFMSUB132SD xmm xmm xmm
//	VFMSUB132SD m64 xmm k xmm
//	VFMSUB132SD xmm xmm k xmm
func VFMSUB132SD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132SD.Forms(), sffxs{}, ops)
}

// VFMSUB132SD_RD_SAE: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMSUB132SD.RD_SAE xmm xmm k xmm
//	VFMSUB132SD.RD_SAE xmm xmm xmm
func VFMSUB132SD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132SD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMSUB132SD_RD_SAE_Z: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB132SD.RD_SAE.Z xmm xmm k xmm
func VFMSUB132SD_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132SD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB132SD_RN_SAE: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMSUB132SD.RN_SAE xmm xmm k xmm
//	VFMSUB132SD.RN_SAE xmm xmm xmm
func VFMSUB132SD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132SD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMSUB132SD_RN_SAE_Z: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMSUB132SD.RN_SAE.Z xmm xmm k xmm
func VFMSUB132SD_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132SD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB132SD_RU_SAE: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMSUB132SD.RU_SAE xmm xmm k xmm
//	VFMSUB132SD.RU_SAE xmm xmm xmm
func VFMSUB132SD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132SD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMSUB132SD_RU_SAE_Z: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB132SD.RU_SAE.Z xmm xmm k xmm
func VFMSUB132SD_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132SD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB132SD_RZ_SAE: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMSUB132SD.RZ_SAE xmm xmm k xmm
//	VFMSUB132SD.RZ_SAE xmm xmm xmm
func VFMSUB132SD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132SD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMSUB132SD_RZ_SAE_Z: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMSUB132SD.RZ_SAE.Z xmm xmm k xmm
func VFMSUB132SD_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132SD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB132SD_Z: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMSUB132SD.Z m64 xmm k xmm
//	VFMSUB132SD.Z xmm xmm k xmm
func VFMSUB132SD_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132SD.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFMSUB132SS: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMSUB132SS m32 xmm xmm
//	VFMSUB132SS xmm xmm xmm
//	VFMSUB132SS m32 xmm k xmm
//	VFMSUB132SS xmm xmm k xmm
func VFMSUB132SS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132SS.Forms(), sffxs{}, ops)
}

// VFMSUB132SS_RD_SAE: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMSUB132SS.RD_SAE xmm xmm k xmm
//	VFMSUB132SS.RD_SAE xmm xmm xmm
func VFMSUB132SS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132SS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMSUB132SS_RD_SAE_Z: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB132SS.RD_SAE.Z xmm xmm k xmm
func VFMSUB132SS_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132SS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB132SS_RN_SAE: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMSUB132SS.RN_SAE xmm xmm k xmm
//	VFMSUB132SS.RN_SAE xmm xmm xmm
func VFMSUB132SS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132SS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMSUB132SS_RN_SAE_Z: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMSUB132SS.RN_SAE.Z xmm xmm k xmm
func VFMSUB132SS_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132SS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB132SS_RU_SAE: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMSUB132SS.RU_SAE xmm xmm k xmm
//	VFMSUB132SS.RU_SAE xmm xmm xmm
func VFMSUB132SS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132SS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMSUB132SS_RU_SAE_Z: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB132SS.RU_SAE.Z xmm xmm k xmm
func VFMSUB132SS_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132SS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB132SS_RZ_SAE: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMSUB132SS.RZ_SAE xmm xmm k xmm
//	VFMSUB132SS.RZ_SAE xmm xmm xmm
func VFMSUB132SS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132SS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMSUB132SS_RZ_SAE_Z: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMSUB132SS.RZ_SAE.Z xmm xmm k xmm
func VFMSUB132SS_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132SS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB132SS_Z: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMSUB132SS.Z m32 xmm k xmm
//	VFMSUB132SS.Z xmm xmm k xmm
func VFMSUB132SS_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB132SS.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFMSUB213PD: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMSUB213PD m128 xmm xmm
//	VFMSUB213PD m256 ymm ymm
//	VFMSUB213PD xmm  xmm xmm
//	VFMSUB213PD ymm  ymm ymm
//	VFMSUB213PD m128 xmm k xmm
//	VFMSUB213PD m256 ymm k ymm
//	VFMSUB213PD xmm  xmm k xmm
//	VFMSUB213PD ymm  ymm k ymm
//	VFMSUB213PD m512 zmm k zmm
//	VFMSUB213PD m512 zmm zmm
//	VFMSUB213PD zmm  zmm k zmm
//	VFMSUB213PD zmm  zmm zmm
func VFMSUB213PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PD.Forms(), sffxs{}, ops)
}

// VFMSUB213PD_BCST: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMSUB213PD.BCST m64 xmm k xmm
//	VFMSUB213PD.BCST m64 xmm xmm
//	VFMSUB213PD.BCST m64 ymm k ymm
//	VFMSUB213PD.BCST m64 ymm ymm
//	VFMSUB213PD.BCST m64 zmm k zmm
//	VFMSUB213PD.BCST m64 zmm zmm
func VFMSUB213PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PD.Forms(), sffxs{sffxBCST}, ops)
}

// VFMSUB213PD_BCST_Z: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMSUB213PD.BCST.Z m64 xmm k xmm
//	VFMSUB213PD.BCST.Z m64 ymm k ymm
//	VFMSUB213PD.BCST.Z m64 zmm k zmm
func VFMSUB213PD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMSUB213PD_RD_SAE: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMSUB213PD.RD_SAE zmm zmm k zmm
//	VFMSUB213PD.RD_SAE zmm zmm zmm
func VFMSUB213PD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMSUB213PD_RD_SAE_Z: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB213PD.RD_SAE.Z zmm zmm k zmm
func VFMSUB213PD_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB213PD_RN_SAE: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMSUB213PD.RN_SAE zmm zmm k zmm
//	VFMSUB213PD.RN_SAE zmm zmm zmm
func VFMSUB213PD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMSUB213PD_RN_SAE_Z: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMSUB213PD.RN_SAE.Z zmm zmm k zmm
func VFMSUB213PD_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB213PD_RU_SAE: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMSUB213PD.RU_SAE zmm zmm k zmm
//	VFMSUB213PD.RU_SAE zmm zmm zmm
func VFMSUB213PD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMSUB213PD_RU_SAE_Z: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB213PD.RU_SAE.Z zmm zmm k zmm
func VFMSUB213PD_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB213PD_RZ_SAE: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMSUB213PD.RZ_SAE zmm zmm k zmm
//	VFMSUB213PD.RZ_SAE zmm zmm zmm
func VFMSUB213PD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMSUB213PD_RZ_SAE_Z: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMSUB213PD.RZ_SAE.Z zmm zmm k zmm
func VFMSUB213PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB213PD_Z: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMSUB213PD.Z m128 xmm k xmm
//	VFMSUB213PD.Z m256 ymm k ymm
//	VFMSUB213PD.Z xmm  xmm k xmm
//	VFMSUB213PD.Z ymm  ymm k ymm
//	VFMSUB213PD.Z m512 zmm k zmm
//	VFMSUB213PD.Z zmm  zmm k zmm
func VFMSUB213PD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMSUB213PS: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMSUB213PS m128 xmm xmm
//	VFMSUB213PS m256 ymm ymm
//	VFMSUB213PS xmm  xmm xmm
//	VFMSUB213PS ymm  ymm ymm
//	VFMSUB213PS m128 xmm k xmm
//	VFMSUB213PS m256 ymm k ymm
//	VFMSUB213PS xmm  xmm k xmm
//	VFMSUB213PS ymm  ymm k ymm
//	VFMSUB213PS m512 zmm k zmm
//	VFMSUB213PS m512 zmm zmm
//	VFMSUB213PS zmm  zmm k zmm
//	VFMSUB213PS zmm  zmm zmm
func VFMSUB213PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PS.Forms(), sffxs{}, ops)
}

// VFMSUB213PS_BCST: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMSUB213PS.BCST m32 xmm k xmm
//	VFMSUB213PS.BCST m32 xmm xmm
//	VFMSUB213PS.BCST m32 ymm k ymm
//	VFMSUB213PS.BCST m32 ymm ymm
//	VFMSUB213PS.BCST m32 zmm k zmm
//	VFMSUB213PS.BCST m32 zmm zmm
func VFMSUB213PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PS.Forms(), sffxs{sffxBCST}, ops)
}

// VFMSUB213PS_BCST_Z: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMSUB213PS.BCST.Z m32 xmm k xmm
//	VFMSUB213PS.BCST.Z m32 ymm k ymm
//	VFMSUB213PS.BCST.Z m32 zmm k zmm
func VFMSUB213PS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMSUB213PS_RD_SAE: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMSUB213PS.RD_SAE zmm zmm k zmm
//	VFMSUB213PS.RD_SAE zmm zmm zmm
func VFMSUB213PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMSUB213PS_RD_SAE_Z: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB213PS.RD_SAE.Z zmm zmm k zmm
func VFMSUB213PS_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB213PS_RN_SAE: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMSUB213PS.RN_SAE zmm zmm k zmm
//	VFMSUB213PS.RN_SAE zmm zmm zmm
func VFMSUB213PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMSUB213PS_RN_SAE_Z: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMSUB213PS.RN_SAE.Z zmm zmm k zmm
func VFMSUB213PS_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB213PS_RU_SAE: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMSUB213PS.RU_SAE zmm zmm k zmm
//	VFMSUB213PS.RU_SAE zmm zmm zmm
func VFMSUB213PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMSUB213PS_RU_SAE_Z: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB213PS.RU_SAE.Z zmm zmm k zmm
func VFMSUB213PS_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB213PS_RZ_SAE: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMSUB213PS.RZ_SAE zmm zmm k zmm
//	VFMSUB213PS.RZ_SAE zmm zmm zmm
func VFMSUB213PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMSUB213PS_RZ_SAE_Z: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMSUB213PS.RZ_SAE.Z zmm zmm k zmm
func VFMSUB213PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB213PS_Z: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMSUB213PS.Z m128 xmm k xmm
//	VFMSUB213PS.Z m256 ymm k ymm
//	VFMSUB213PS.Z xmm  xmm k xmm
//	VFMSUB213PS.Z ymm  ymm k ymm
//	VFMSUB213PS.Z m512 zmm k zmm
//	VFMSUB213PS.Z zmm  zmm k zmm
func VFMSUB213PS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMSUB213SD: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMSUB213SD m64 xmm xmm
//	VFMSUB213SD xmm xmm xmm
//	VFMSUB213SD m64 xmm k xmm
//	VFMSUB213SD xmm xmm k xmm
func VFMSUB213SD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213SD.Forms(), sffxs{}, ops)
}

// VFMSUB213SD_RD_SAE: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMSUB213SD.RD_SAE xmm xmm k xmm
//	VFMSUB213SD.RD_SAE xmm xmm xmm
func VFMSUB213SD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213SD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMSUB213SD_RD_SAE_Z: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB213SD.RD_SAE.Z xmm xmm k xmm
func VFMSUB213SD_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213SD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB213SD_RN_SAE: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMSUB213SD.RN_SAE xmm xmm k xmm
//	VFMSUB213SD.RN_SAE xmm xmm xmm
func VFMSUB213SD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213SD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMSUB213SD_RN_SAE_Z: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMSUB213SD.RN_SAE.Z xmm xmm k xmm
func VFMSUB213SD_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213SD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB213SD_RU_SAE: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMSUB213SD.RU_SAE xmm xmm k xmm
//	VFMSUB213SD.RU_SAE xmm xmm xmm
func VFMSUB213SD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213SD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMSUB213SD_RU_SAE_Z: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB213SD.RU_SAE.Z xmm xmm k xmm
func VFMSUB213SD_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213SD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB213SD_RZ_SAE: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMSUB213SD.RZ_SAE xmm xmm k xmm
//	VFMSUB213SD.RZ_SAE xmm xmm xmm
func VFMSUB213SD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213SD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMSUB213SD_RZ_SAE_Z: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMSUB213SD.RZ_SAE.Z xmm xmm k xmm
func VFMSUB213SD_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213SD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB213SD_Z: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMSUB213SD.Z m64 xmm k xmm
//	VFMSUB213SD.Z xmm xmm k xmm
func VFMSUB213SD_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213SD.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFMSUB213SS: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMSUB213SS m32 xmm xmm
//	VFMSUB213SS xmm xmm xmm
//	VFMSUB213SS m32 xmm k xmm
//	VFMSUB213SS xmm xmm k xmm
func VFMSUB213SS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213SS.Forms(), sffxs{}, ops)
}

// VFMSUB213SS_RD_SAE: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMSUB213SS.RD_SAE xmm xmm k xmm
//	VFMSUB213SS.RD_SAE xmm xmm xmm
func VFMSUB213SS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213SS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMSUB213SS_RD_SAE_Z: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB213SS.RD_SAE.Z xmm xmm k xmm
func VFMSUB213SS_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213SS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB213SS_RN_SAE: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMSUB213SS.RN_SAE xmm xmm k xmm
//	VFMSUB213SS.RN_SAE xmm xmm xmm
func VFMSUB213SS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213SS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMSUB213SS_RN_SAE_Z: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMSUB213SS.RN_SAE.Z xmm xmm k xmm
func VFMSUB213SS_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213SS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB213SS_RU_SAE: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMSUB213SS.RU_SAE xmm xmm k xmm
//	VFMSUB213SS.RU_SAE xmm xmm xmm
func VFMSUB213SS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213SS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMSUB213SS_RU_SAE_Z: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB213SS.RU_SAE.Z xmm xmm k xmm
func VFMSUB213SS_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213SS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB213SS_RZ_SAE: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMSUB213SS.RZ_SAE xmm xmm k xmm
//	VFMSUB213SS.RZ_SAE xmm xmm xmm
func VFMSUB213SS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213SS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMSUB213SS_RZ_SAE_Z: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMSUB213SS.RZ_SAE.Z xmm xmm k xmm
func VFMSUB213SS_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213SS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB213SS_Z: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMSUB213SS.Z m32 xmm k xmm
//	VFMSUB213SS.Z xmm xmm k xmm
func VFMSUB213SS_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB213SS.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFMSUB231PD: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMSUB231PD m128 xmm xmm
//	VFMSUB231PD m256 ymm ymm
//	VFMSUB231PD xmm  xmm xmm
//	VFMSUB231PD ymm  ymm ymm
//	VFMSUB231PD m128 xmm k xmm
//	VFMSUB231PD m256 ymm k ymm
//	VFMSUB231PD xmm  xmm k xmm
//	VFMSUB231PD ymm  ymm k ymm
//	VFMSUB231PD m512 zmm k zmm
//	VFMSUB231PD m512 zmm zmm
//	VFMSUB231PD zmm  zmm k zmm
//	VFMSUB231PD zmm  zmm zmm
func VFMSUB231PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PD.Forms(), sffxs{}, ops)
}

// VFMSUB231PD_BCST: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMSUB231PD.BCST m64 xmm k xmm
//	VFMSUB231PD.BCST m64 xmm xmm
//	VFMSUB231PD.BCST m64 ymm k ymm
//	VFMSUB231PD.BCST m64 ymm ymm
//	VFMSUB231PD.BCST m64 zmm k zmm
//	VFMSUB231PD.BCST m64 zmm zmm
func VFMSUB231PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PD.Forms(), sffxs{sffxBCST}, ops)
}

// VFMSUB231PD_BCST_Z: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMSUB231PD.BCST.Z m64 xmm k xmm
//	VFMSUB231PD.BCST.Z m64 ymm k ymm
//	VFMSUB231PD.BCST.Z m64 zmm k zmm
func VFMSUB231PD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMSUB231PD_RD_SAE: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMSUB231PD.RD_SAE zmm zmm k zmm
//	VFMSUB231PD.RD_SAE zmm zmm zmm
func VFMSUB231PD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMSUB231PD_RD_SAE_Z: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB231PD.RD_SAE.Z zmm zmm k zmm
func VFMSUB231PD_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB231PD_RN_SAE: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMSUB231PD.RN_SAE zmm zmm k zmm
//	VFMSUB231PD.RN_SAE zmm zmm zmm
func VFMSUB231PD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMSUB231PD_RN_SAE_Z: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMSUB231PD.RN_SAE.Z zmm zmm k zmm
func VFMSUB231PD_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB231PD_RU_SAE: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMSUB231PD.RU_SAE zmm zmm k zmm
//	VFMSUB231PD.RU_SAE zmm zmm zmm
func VFMSUB231PD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMSUB231PD_RU_SAE_Z: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB231PD.RU_SAE.Z zmm zmm k zmm
func VFMSUB231PD_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB231PD_RZ_SAE: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMSUB231PD.RZ_SAE zmm zmm k zmm
//	VFMSUB231PD.RZ_SAE zmm zmm zmm
func VFMSUB231PD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMSUB231PD_RZ_SAE_Z: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMSUB231PD.RZ_SAE.Z zmm zmm k zmm
func VFMSUB231PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB231PD_Z: Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMSUB231PD.Z m128 xmm k xmm
//	VFMSUB231PD.Z m256 ymm k ymm
//	VFMSUB231PD.Z xmm  xmm k xmm
//	VFMSUB231PD.Z ymm  ymm k ymm
//	VFMSUB231PD.Z m512 zmm k zmm
//	VFMSUB231PD.Z zmm  zmm k zmm
func VFMSUB231PD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMSUB231PS: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMSUB231PS m128 xmm xmm
//	VFMSUB231PS m256 ymm ymm
//	VFMSUB231PS xmm  xmm xmm
//	VFMSUB231PS ymm  ymm ymm
//	VFMSUB231PS m128 xmm k xmm
//	VFMSUB231PS m256 ymm k ymm
//	VFMSUB231PS xmm  xmm k xmm
//	VFMSUB231PS ymm  ymm k ymm
//	VFMSUB231PS m512 zmm k zmm
//	VFMSUB231PS m512 zmm zmm
//	VFMSUB231PS zmm  zmm k zmm
//	VFMSUB231PS zmm  zmm zmm
func VFMSUB231PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PS.Forms(), sffxs{}, ops)
}

// VFMSUB231PS_BCST: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMSUB231PS.BCST m32 xmm k xmm
//	VFMSUB231PS.BCST m32 xmm xmm
//	VFMSUB231PS.BCST m32 ymm k ymm
//	VFMSUB231PS.BCST m32 ymm ymm
//	VFMSUB231PS.BCST m32 zmm k zmm
//	VFMSUB231PS.BCST m32 zmm zmm
func VFMSUB231PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PS.Forms(), sffxs{sffxBCST}, ops)
}

// VFMSUB231PS_BCST_Z: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMSUB231PS.BCST.Z m32 xmm k xmm
//	VFMSUB231PS.BCST.Z m32 ymm k ymm
//	VFMSUB231PS.BCST.Z m32 zmm k zmm
func VFMSUB231PS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMSUB231PS_RD_SAE: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMSUB231PS.RD_SAE zmm zmm k zmm
//	VFMSUB231PS.RD_SAE zmm zmm zmm
func VFMSUB231PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMSUB231PS_RD_SAE_Z: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB231PS.RD_SAE.Z zmm zmm k zmm
func VFMSUB231PS_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB231PS_RN_SAE: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMSUB231PS.RN_SAE zmm zmm k zmm
//	VFMSUB231PS.RN_SAE zmm zmm zmm
func VFMSUB231PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMSUB231PS_RN_SAE_Z: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMSUB231PS.RN_SAE.Z zmm zmm k zmm
func VFMSUB231PS_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB231PS_RU_SAE: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMSUB231PS.RU_SAE zmm zmm k zmm
//	VFMSUB231PS.RU_SAE zmm zmm zmm
func VFMSUB231PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMSUB231PS_RU_SAE_Z: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB231PS.RU_SAE.Z zmm zmm k zmm
func VFMSUB231PS_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB231PS_RZ_SAE: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMSUB231PS.RZ_SAE zmm zmm k zmm
//	VFMSUB231PS.RZ_SAE zmm zmm zmm
func VFMSUB231PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMSUB231PS_RZ_SAE_Z: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMSUB231PS.RZ_SAE.Z zmm zmm k zmm
func VFMSUB231PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUB231PS_Z: Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMSUB231PS.Z m128 xmm k xmm
//	VFMSUB231PS.Z m256 ymm k ymm
//	VFMSUB231PS.Z xmm  xmm k xmm
//	VFMSUB231PS.Z ymm  ymm k ymm
//	VFMSUB231PS.Z m512 zmm k zmm
//	VFMSUB231PS.Z zmm  zmm k zmm
func VFMSUB231PS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMSUB231SD: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMSUB231SD m64 xmm xmm
//	VFMSUB231SD xmm xmm xmm
//	VFMSUB231SD m64 xmm k xmm
//	VFMSUB231SD xmm xmm k xmm
func VFMSUB231SD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231SD.Forms(), sffxs{}, ops)
}

// VFMSUB231SD_RD_SAE: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMSUB231SD.RD_SAE xmm xmm k xmm
//	VFMSUB231SD.RD_SAE xmm xmm xmm
func VFMSUB231SD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231SD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMSUB231SD_RD_SAE_Z: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB231SD.RD_SAE.Z xmm xmm k xmm
func VFMSUB231SD_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231SD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB231SD_RN_SAE: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMSUB231SD.RN_SAE xmm xmm k xmm
//	VFMSUB231SD.RN_SAE xmm xmm xmm
func VFMSUB231SD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231SD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMSUB231SD_RN_SAE_Z: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMSUB231SD.RN_SAE.Z xmm xmm k xmm
func VFMSUB231SD_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231SD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB231SD_RU_SAE: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMSUB231SD.RU_SAE xmm xmm k xmm
//	VFMSUB231SD.RU_SAE xmm xmm xmm
func VFMSUB231SD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231SD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMSUB231SD_RU_SAE_Z: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB231SD.RU_SAE.Z xmm xmm k xmm
func VFMSUB231SD_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231SD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB231SD_RZ_SAE: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMSUB231SD.RZ_SAE xmm xmm k xmm
//	VFMSUB231SD.RZ_SAE xmm xmm xmm
func VFMSUB231SD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231SD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMSUB231SD_RZ_SAE_Z: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMSUB231SD.RZ_SAE.Z xmm xmm k xmm
func VFMSUB231SD_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231SD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB231SD_Z: Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMSUB231SD.Z m64 xmm k xmm
//	VFMSUB231SD.Z xmm xmm k xmm
func VFMSUB231SD_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231SD.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFMSUB231SS: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMSUB231SS m32 xmm xmm
//	VFMSUB231SS xmm xmm xmm
//	VFMSUB231SS m32 xmm k xmm
//	VFMSUB231SS xmm xmm k xmm
func VFMSUB231SS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231SS.Forms(), sffxs{}, ops)
}

// VFMSUB231SS_RD_SAE: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMSUB231SS.RD_SAE xmm xmm k xmm
//	VFMSUB231SS.RD_SAE xmm xmm xmm
func VFMSUB231SS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231SS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMSUB231SS_RD_SAE_Z: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB231SS.RD_SAE.Z xmm xmm k xmm
func VFMSUB231SS_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231SS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB231SS_RN_SAE: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMSUB231SS.RN_SAE xmm xmm k xmm
//	VFMSUB231SS.RN_SAE xmm xmm xmm
func VFMSUB231SS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231SS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMSUB231SS_RN_SAE_Z: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMSUB231SS.RN_SAE.Z xmm xmm k xmm
func VFMSUB231SS_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231SS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB231SS_RU_SAE: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMSUB231SS.RU_SAE xmm xmm k xmm
//	VFMSUB231SS.RU_SAE xmm xmm xmm
func VFMSUB231SS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231SS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMSUB231SS_RU_SAE_Z: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUB231SS.RU_SAE.Z xmm xmm k xmm
func VFMSUB231SS_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231SS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB231SS_RZ_SAE: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMSUB231SS.RZ_SAE xmm xmm k xmm
//	VFMSUB231SS.RZ_SAE xmm xmm xmm
func VFMSUB231SS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231SS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMSUB231SS_RZ_SAE_Z: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMSUB231SS.RZ_SAE.Z xmm xmm k xmm
func VFMSUB231SS_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231SS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFMSUB231SS_Z: Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMSUB231SS.Z m32 xmm k xmm
//	VFMSUB231SS.Z xmm xmm k xmm
func VFMSUB231SS_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUB231SS.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFMSUBADD132PD: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMSUBADD132PD m128 xmm xmm
//	VFMSUBADD132PD m256 ymm ymm
//	VFMSUBADD132PD xmm  xmm xmm
//	VFMSUBADD132PD ymm  ymm ymm
//	VFMSUBADD132PD m128 xmm k xmm
//	VFMSUBADD132PD m256 ymm k ymm
//	VFMSUBADD132PD xmm  xmm k xmm
//	VFMSUBADD132PD ymm  ymm k ymm
//	VFMSUBADD132PD m512 zmm k zmm
//	VFMSUBADD132PD m512 zmm zmm
//	VFMSUBADD132PD zmm  zmm k zmm
//	VFMSUBADD132PD zmm  zmm zmm
func VFMSUBADD132PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PD.Forms(), sffxs{}, ops)
}

// VFMSUBADD132PD_BCST: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMSUBADD132PD.BCST m64 xmm k xmm
//	VFMSUBADD132PD.BCST m64 xmm xmm
//	VFMSUBADD132PD.BCST m64 ymm k ymm
//	VFMSUBADD132PD.BCST m64 ymm ymm
//	VFMSUBADD132PD.BCST m64 zmm k zmm
//	VFMSUBADD132PD.BCST m64 zmm zmm
func VFMSUBADD132PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PD.Forms(), sffxs{sffxBCST}, ops)
}

// VFMSUBADD132PD_BCST_Z: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD132PD.BCST.Z m64 xmm k xmm
//	VFMSUBADD132PD.BCST.Z m64 ymm k ymm
//	VFMSUBADD132PD.BCST.Z m64 zmm k zmm
func VFMSUBADD132PD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMSUBADD132PD_RD_SAE: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMSUBADD132PD.RD_SAE zmm zmm k zmm
//	VFMSUBADD132PD.RD_SAE zmm zmm zmm
func VFMSUBADD132PD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMSUBADD132PD_RD_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD132PD.RD_SAE.Z zmm zmm k zmm
func VFMSUBADD132PD_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD132PD_RN_SAE: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMSUBADD132PD.RN_SAE zmm zmm k zmm
//	VFMSUBADD132PD.RN_SAE zmm zmm zmm
func VFMSUBADD132PD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMSUBADD132PD_RN_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD132PD.RN_SAE.Z zmm zmm k zmm
func VFMSUBADD132PD_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD132PD_RU_SAE: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMSUBADD132PD.RU_SAE zmm zmm k zmm
//	VFMSUBADD132PD.RU_SAE zmm zmm zmm
func VFMSUBADD132PD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMSUBADD132PD_RU_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD132PD.RU_SAE.Z zmm zmm k zmm
func VFMSUBADD132PD_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD132PD_RZ_SAE: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMSUBADD132PD.RZ_SAE zmm zmm k zmm
//	VFMSUBADD132PD.RZ_SAE zmm zmm zmm
func VFMSUBADD132PD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMSUBADD132PD_RZ_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD132PD.RZ_SAE.Z zmm zmm k zmm
func VFMSUBADD132PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD132PD_Z: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD132PD.Z m128 xmm k xmm
//	VFMSUBADD132PD.Z m256 ymm k ymm
//	VFMSUBADD132PD.Z xmm  xmm k xmm
//	VFMSUBADD132PD.Z ymm  ymm k ymm
//	VFMSUBADD132PD.Z m512 zmm k zmm
//	VFMSUBADD132PD.Z zmm  zmm k zmm
func VFMSUBADD132PD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMSUBADD132PS: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMSUBADD132PS m128 xmm xmm
//	VFMSUBADD132PS m256 ymm ymm
//	VFMSUBADD132PS xmm  xmm xmm
//	VFMSUBADD132PS ymm  ymm ymm
//	VFMSUBADD132PS m128 xmm k xmm
//	VFMSUBADD132PS m256 ymm k ymm
//	VFMSUBADD132PS xmm  xmm k xmm
//	VFMSUBADD132PS ymm  ymm k ymm
//	VFMSUBADD132PS m512 zmm k zmm
//	VFMSUBADD132PS m512 zmm zmm
//	VFMSUBADD132PS zmm  zmm k zmm
//	VFMSUBADD132PS zmm  zmm zmm
func VFMSUBADD132PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PS.Forms(), sffxs{}, ops)
}

// VFMSUBADD132PS_BCST: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMSUBADD132PS.BCST m32 xmm k xmm
//	VFMSUBADD132PS.BCST m32 xmm xmm
//	VFMSUBADD132PS.BCST m32 ymm k ymm
//	VFMSUBADD132PS.BCST m32 ymm ymm
//	VFMSUBADD132PS.BCST m32 zmm k zmm
//	VFMSUBADD132PS.BCST m32 zmm zmm
func VFMSUBADD132PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PS.Forms(), sffxs{sffxBCST}, ops)
}

// VFMSUBADD132PS_BCST_Z: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD132PS.BCST.Z m32 xmm k xmm
//	VFMSUBADD132PS.BCST.Z m32 ymm k ymm
//	VFMSUBADD132PS.BCST.Z m32 zmm k zmm
func VFMSUBADD132PS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMSUBADD132PS_RD_SAE: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMSUBADD132PS.RD_SAE zmm zmm k zmm
//	VFMSUBADD132PS.RD_SAE zmm zmm zmm
func VFMSUBADD132PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMSUBADD132PS_RD_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD132PS.RD_SAE.Z zmm zmm k zmm
func VFMSUBADD132PS_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD132PS_RN_SAE: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMSUBADD132PS.RN_SAE zmm zmm k zmm
//	VFMSUBADD132PS.RN_SAE zmm zmm zmm
func VFMSUBADD132PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMSUBADD132PS_RN_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD132PS.RN_SAE.Z zmm zmm k zmm
func VFMSUBADD132PS_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD132PS_RU_SAE: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMSUBADD132PS.RU_SAE zmm zmm k zmm
//	VFMSUBADD132PS.RU_SAE zmm zmm zmm
func VFMSUBADD132PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMSUBADD132PS_RU_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD132PS.RU_SAE.Z zmm zmm k zmm
func VFMSUBADD132PS_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD132PS_RZ_SAE: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMSUBADD132PS.RZ_SAE zmm zmm k zmm
//	VFMSUBADD132PS.RZ_SAE zmm zmm zmm
func VFMSUBADD132PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMSUBADD132PS_RZ_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD132PS.RZ_SAE.Z zmm zmm k zmm
func VFMSUBADD132PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD132PS_Z: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD132PS.Z m128 xmm k xmm
//	VFMSUBADD132PS.Z m256 ymm k ymm
//	VFMSUBADD132PS.Z xmm  xmm k xmm
//	VFMSUBADD132PS.Z ymm  ymm k ymm
//	VFMSUBADD132PS.Z m512 zmm k zmm
//	VFMSUBADD132PS.Z zmm  zmm k zmm
func VFMSUBADD132PS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD132PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMSUBADD213PD: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMSUBADD213PD m128 xmm xmm
//	VFMSUBADD213PD m256 ymm ymm
//	VFMSUBADD213PD xmm  xmm xmm
//	VFMSUBADD213PD ymm  ymm ymm
//	VFMSUBADD213PD m128 xmm k xmm
//	VFMSUBADD213PD m256 ymm k ymm
//	VFMSUBADD213PD xmm  xmm k xmm
//	VFMSUBADD213PD ymm  ymm k ymm
//	VFMSUBADD213PD m512 zmm k zmm
//	VFMSUBADD213PD m512 zmm zmm
//	VFMSUBADD213PD zmm  zmm k zmm
//	VFMSUBADD213PD zmm  zmm zmm
func VFMSUBADD213PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PD.Forms(), sffxs{}, ops)
}

// VFMSUBADD213PD_BCST: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMSUBADD213PD.BCST m64 xmm k xmm
//	VFMSUBADD213PD.BCST m64 xmm xmm
//	VFMSUBADD213PD.BCST m64 ymm k ymm
//	VFMSUBADD213PD.BCST m64 ymm ymm
//	VFMSUBADD213PD.BCST m64 zmm k zmm
//	VFMSUBADD213PD.BCST m64 zmm zmm
func VFMSUBADD213PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PD.Forms(), sffxs{sffxBCST}, ops)
}

// VFMSUBADD213PD_BCST_Z: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD213PD.BCST.Z m64 xmm k xmm
//	VFMSUBADD213PD.BCST.Z m64 ymm k ymm
//	VFMSUBADD213PD.BCST.Z m64 zmm k zmm
func VFMSUBADD213PD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMSUBADD213PD_RD_SAE: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMSUBADD213PD.RD_SAE zmm zmm k zmm
//	VFMSUBADD213PD.RD_SAE zmm zmm zmm
func VFMSUBADD213PD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMSUBADD213PD_RD_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD213PD.RD_SAE.Z zmm zmm k zmm
func VFMSUBADD213PD_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD213PD_RN_SAE: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMSUBADD213PD.RN_SAE zmm zmm k zmm
//	VFMSUBADD213PD.RN_SAE zmm zmm zmm
func VFMSUBADD213PD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMSUBADD213PD_RN_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD213PD.RN_SAE.Z zmm zmm k zmm
func VFMSUBADD213PD_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD213PD_RU_SAE: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMSUBADD213PD.RU_SAE zmm zmm k zmm
//	VFMSUBADD213PD.RU_SAE zmm zmm zmm
func VFMSUBADD213PD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMSUBADD213PD_RU_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD213PD.RU_SAE.Z zmm zmm k zmm
func VFMSUBADD213PD_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD213PD_RZ_SAE: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMSUBADD213PD.RZ_SAE zmm zmm k zmm
//	VFMSUBADD213PD.RZ_SAE zmm zmm zmm
func VFMSUBADD213PD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMSUBADD213PD_RZ_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD213PD.RZ_SAE.Z zmm zmm k zmm
func VFMSUBADD213PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD213PD_Z: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD213PD.Z m128 xmm k xmm
//	VFMSUBADD213PD.Z m256 ymm k ymm
//	VFMSUBADD213PD.Z xmm  xmm k xmm
//	VFMSUBADD213PD.Z ymm  ymm k ymm
//	VFMSUBADD213PD.Z m512 zmm k zmm
//	VFMSUBADD213PD.Z zmm  zmm k zmm
func VFMSUBADD213PD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMSUBADD213PS: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMSUBADD213PS m128 xmm xmm
//	VFMSUBADD213PS m256 ymm ymm
//	VFMSUBADD213PS xmm  xmm xmm
//	VFMSUBADD213PS ymm  ymm ymm
//	VFMSUBADD213PS m128 xmm k xmm
//	VFMSUBADD213PS m256 ymm k ymm
//	VFMSUBADD213PS xmm  xmm k xmm
//	VFMSUBADD213PS ymm  ymm k ymm
//	VFMSUBADD213PS m512 zmm k zmm
//	VFMSUBADD213PS m512 zmm zmm
//	VFMSUBADD213PS zmm  zmm k zmm
//	VFMSUBADD213PS zmm  zmm zmm
func VFMSUBADD213PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PS.Forms(), sffxs{}, ops)
}

// VFMSUBADD213PS_BCST: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMSUBADD213PS.BCST m32 xmm k xmm
//	VFMSUBADD213PS.BCST m32 xmm xmm
//	VFMSUBADD213PS.BCST m32 ymm k ymm
//	VFMSUBADD213PS.BCST m32 ymm ymm
//	VFMSUBADD213PS.BCST m32 zmm k zmm
//	VFMSUBADD213PS.BCST m32 zmm zmm
func VFMSUBADD213PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PS.Forms(), sffxs{sffxBCST}, ops)
}

// VFMSUBADD213PS_BCST_Z: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD213PS.BCST.Z m32 xmm k xmm
//	VFMSUBADD213PS.BCST.Z m32 ymm k ymm
//	VFMSUBADD213PS.BCST.Z m32 zmm k zmm
func VFMSUBADD213PS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMSUBADD213PS_RD_SAE: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMSUBADD213PS.RD_SAE zmm zmm k zmm
//	VFMSUBADD213PS.RD_SAE zmm zmm zmm
func VFMSUBADD213PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMSUBADD213PS_RD_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD213PS.RD_SAE.Z zmm zmm k zmm
func VFMSUBADD213PS_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD213PS_RN_SAE: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMSUBADD213PS.RN_SAE zmm zmm k zmm
//	VFMSUBADD213PS.RN_SAE zmm zmm zmm
func VFMSUBADD213PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMSUBADD213PS_RN_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD213PS.RN_SAE.Z zmm zmm k zmm
func VFMSUBADD213PS_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD213PS_RU_SAE: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMSUBADD213PS.RU_SAE zmm zmm k zmm
//	VFMSUBADD213PS.RU_SAE zmm zmm zmm
func VFMSUBADD213PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMSUBADD213PS_RU_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD213PS.RU_SAE.Z zmm zmm k zmm
func VFMSUBADD213PS_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD213PS_RZ_SAE: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMSUBADD213PS.RZ_SAE zmm zmm k zmm
//	VFMSUBADD213PS.RZ_SAE zmm zmm zmm
func VFMSUBADD213PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMSUBADD213PS_RZ_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD213PS.RZ_SAE.Z zmm zmm k zmm
func VFMSUBADD213PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD213PS_Z: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD213PS.Z m128 xmm k xmm
//	VFMSUBADD213PS.Z m256 ymm k ymm
//	VFMSUBADD213PS.Z xmm  xmm k xmm
//	VFMSUBADD213PS.Z ymm  ymm k ymm
//	VFMSUBADD213PS.Z m512 zmm k zmm
//	VFMSUBADD213PS.Z zmm  zmm k zmm
func VFMSUBADD213PS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD213PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMSUBADD231PD: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMSUBADD231PD m128 xmm xmm
//	VFMSUBADD231PD m256 ymm ymm
//	VFMSUBADD231PD xmm  xmm xmm
//	VFMSUBADD231PD ymm  ymm ymm
//	VFMSUBADD231PD m128 xmm k xmm
//	VFMSUBADD231PD m256 ymm k ymm
//	VFMSUBADD231PD xmm  xmm k xmm
//	VFMSUBADD231PD ymm  ymm k ymm
//	VFMSUBADD231PD m512 zmm k zmm
//	VFMSUBADD231PD m512 zmm zmm
//	VFMSUBADD231PD zmm  zmm k zmm
//	VFMSUBADD231PD zmm  zmm zmm
func VFMSUBADD231PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PD.Forms(), sffxs{}, ops)
}

// VFMSUBADD231PD_BCST: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMSUBADD231PD.BCST m64 xmm k xmm
//	VFMSUBADD231PD.BCST m64 xmm xmm
//	VFMSUBADD231PD.BCST m64 ymm k ymm
//	VFMSUBADD231PD.BCST m64 ymm ymm
//	VFMSUBADD231PD.BCST m64 zmm k zmm
//	VFMSUBADD231PD.BCST m64 zmm zmm
func VFMSUBADD231PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PD.Forms(), sffxs{sffxBCST}, ops)
}

// VFMSUBADD231PD_BCST_Z: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD231PD.BCST.Z m64 xmm k xmm
//	VFMSUBADD231PD.BCST.Z m64 ymm k ymm
//	VFMSUBADD231PD.BCST.Z m64 zmm k zmm
func VFMSUBADD231PD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMSUBADD231PD_RD_SAE: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMSUBADD231PD.RD_SAE zmm zmm k zmm
//	VFMSUBADD231PD.RD_SAE zmm zmm zmm
func VFMSUBADD231PD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMSUBADD231PD_RD_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD231PD.RD_SAE.Z zmm zmm k zmm
func VFMSUBADD231PD_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD231PD_RN_SAE: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMSUBADD231PD.RN_SAE zmm zmm k zmm
//	VFMSUBADD231PD.RN_SAE zmm zmm zmm
func VFMSUBADD231PD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMSUBADD231PD_RN_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD231PD.RN_SAE.Z zmm zmm k zmm
func VFMSUBADD231PD_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD231PD_RU_SAE: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMSUBADD231PD.RU_SAE zmm zmm k zmm
//	VFMSUBADD231PD.RU_SAE zmm zmm zmm
func VFMSUBADD231PD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMSUBADD231PD_RU_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD231PD.RU_SAE.Z zmm zmm k zmm
func VFMSUBADD231PD_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD231PD_RZ_SAE: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMSUBADD231PD.RZ_SAE zmm zmm k zmm
//	VFMSUBADD231PD.RZ_SAE zmm zmm zmm
func VFMSUBADD231PD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMSUBADD231PD_RZ_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD231PD.RZ_SAE.Z zmm zmm k zmm
func VFMSUBADD231PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD231PD_Z: Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD231PD.Z m128 xmm k xmm
//	VFMSUBADD231PD.Z m256 ymm k ymm
//	VFMSUBADD231PD.Z xmm  xmm k xmm
//	VFMSUBADD231PD.Z ymm  ymm k ymm
//	VFMSUBADD231PD.Z m512 zmm k zmm
//	VFMSUBADD231PD.Z zmm  zmm k zmm
func VFMSUBADD231PD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFMSUBADD231PS: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMSUBADD231PS m128 xmm xmm
//	VFMSUBADD231PS m256 ymm ymm
//	VFMSUBADD231PS xmm  xmm xmm
//	VFMSUBADD231PS ymm  ymm ymm
//	VFMSUBADD231PS m128 xmm k xmm
//	VFMSUBADD231PS m256 ymm k ymm
//	VFMSUBADD231PS xmm  xmm k xmm
//	VFMSUBADD231PS ymm  ymm k ymm
//	VFMSUBADD231PS m512 zmm k zmm
//	VFMSUBADD231PS m512 zmm zmm
//	VFMSUBADD231PS zmm  zmm k zmm
//	VFMSUBADD231PS zmm  zmm zmm
func VFMSUBADD231PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PS.Forms(), sffxs{}, ops)
}

// VFMSUBADD231PS_BCST: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMSUBADD231PS.BCST m32 xmm k xmm
//	VFMSUBADD231PS.BCST m32 xmm xmm
//	VFMSUBADD231PS.BCST m32 ymm k ymm
//	VFMSUBADD231PS.BCST m32 ymm ymm
//	VFMSUBADD231PS.BCST m32 zmm k zmm
//	VFMSUBADD231PS.BCST m32 zmm zmm
func VFMSUBADD231PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PS.Forms(), sffxs{sffxBCST}, ops)
}

// VFMSUBADD231PS_BCST_Z: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD231PS.BCST.Z m32 xmm k xmm
//	VFMSUBADD231PS.BCST.Z m32 ymm k ymm
//	VFMSUBADD231PS.BCST.Z m32 zmm k zmm
func VFMSUBADD231PS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFMSUBADD231PS_RD_SAE: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMSUBADD231PS.RD_SAE zmm zmm k zmm
//	VFMSUBADD231PS.RD_SAE zmm zmm zmm
func VFMSUBADD231PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFMSUBADD231PS_RD_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD231PS.RD_SAE.Z zmm zmm k zmm
func VFMSUBADD231PS_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD231PS_RN_SAE: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMSUBADD231PS.RN_SAE zmm zmm k zmm
//	VFMSUBADD231PS.RN_SAE zmm zmm zmm
func VFMSUBADD231PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFMSUBADD231PS_RN_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD231PS.RN_SAE.Z zmm zmm k zmm
func VFMSUBADD231PS_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD231PS_RU_SAE: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMSUBADD231PS.RU_SAE zmm zmm k zmm
//	VFMSUBADD231PS.RU_SAE zmm zmm zmm
func VFMSUBADD231PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFMSUBADD231PS_RU_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD231PS.RU_SAE.Z zmm zmm k zmm
func VFMSUBADD231PS_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD231PS_RZ_SAE: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMSUBADD231PS.RZ_SAE zmm zmm k zmm
//	VFMSUBADD231PS.RZ_SAE zmm zmm zmm
func VFMSUBADD231PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFMSUBADD231PS_RZ_SAE_Z: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD231PS.RZ_SAE.Z zmm zmm k zmm
func VFMSUBADD231PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFMSUBADD231PS_Z: Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMSUBADD231PS.Z m128 xmm k xmm
//	VFMSUBADD231PS.Z m256 ymm k ymm
//	VFMSUBADD231PS.Z xmm  xmm k xmm
//	VFMSUBADD231PS.Z ymm  ymm k ymm
//	VFMSUBADD231PS.Z m512 zmm k zmm
//	VFMSUBADD231PS.Z zmm  zmm k zmm
func VFMSUBADD231PS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFMSUBADD231PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFNMADD132PD: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMADD132PD m128 xmm xmm
//	VFNMADD132PD m256 ymm ymm
//	VFNMADD132PD xmm  xmm xmm
//	VFNMADD132PD ymm  ymm ymm
//	VFNMADD132PD m128 xmm k xmm
//	VFNMADD132PD m256 ymm k ymm
//	VFNMADD132PD xmm  xmm k xmm
//	VFNMADD132PD ymm  ymm k ymm
//	VFNMADD132PD m512 zmm k zmm
//	VFNMADD132PD m512 zmm zmm
//	VFNMADD132PD zmm  zmm k zmm
//	VFNMADD132PD zmm  zmm zmm
func VFNMADD132PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PD.Forms(), sffxs{}, ops)
}

// VFNMADD132PD_BCST: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFNMADD132PD.BCST m64 xmm k xmm
//	VFNMADD132PD.BCST m64 xmm xmm
//	VFNMADD132PD.BCST m64 ymm k ymm
//	VFNMADD132PD.BCST m64 ymm ymm
//	VFNMADD132PD.BCST m64 zmm k zmm
//	VFNMADD132PD.BCST m64 zmm zmm
func VFNMADD132PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PD.Forms(), sffxs{sffxBCST}, ops)
}

// VFNMADD132PD_BCST_Z: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFNMADD132PD.BCST.Z m64 xmm k xmm
//	VFNMADD132PD.BCST.Z m64 ymm k ymm
//	VFNMADD132PD.BCST.Z m64 zmm k zmm
func VFNMADD132PD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFNMADD132PD_RD_SAE: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMADD132PD.RD_SAE zmm zmm k zmm
//	VFNMADD132PD.RD_SAE zmm zmm zmm
func VFNMADD132PD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMADD132PD_RD_SAE_Z: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD132PD.RD_SAE.Z zmm zmm k zmm
func VFNMADD132PD_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD132PD_RN_SAE: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMADD132PD.RN_SAE zmm zmm k zmm
//	VFNMADD132PD.RN_SAE zmm zmm zmm
func VFNMADD132PD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMADD132PD_RN_SAE_Z: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMADD132PD.RN_SAE.Z zmm zmm k zmm
func VFNMADD132PD_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD132PD_RU_SAE: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMADD132PD.RU_SAE zmm zmm k zmm
//	VFNMADD132PD.RU_SAE zmm zmm zmm
func VFNMADD132PD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMADD132PD_RU_SAE_Z: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD132PD.RU_SAE.Z zmm zmm k zmm
func VFNMADD132PD_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD132PD_RZ_SAE: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMADD132PD.RZ_SAE zmm zmm k zmm
//	VFNMADD132PD.RZ_SAE zmm zmm zmm
func VFNMADD132PD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMADD132PD_RZ_SAE_Z: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMADD132PD.RZ_SAE.Z zmm zmm k zmm
func VFNMADD132PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD132PD_Z: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMADD132PD.Z m128 xmm k xmm
//	VFNMADD132PD.Z m256 ymm k ymm
//	VFNMADD132PD.Z xmm  xmm k xmm
//	VFNMADD132PD.Z ymm  ymm k ymm
//	VFNMADD132PD.Z m512 zmm k zmm
//	VFNMADD132PD.Z zmm  zmm k zmm
func VFNMADD132PD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFNMADD132PS: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMADD132PS m128 xmm xmm
//	VFNMADD132PS m256 ymm ymm
//	VFNMADD132PS xmm  xmm xmm
//	VFNMADD132PS ymm  ymm ymm
//	VFNMADD132PS m128 xmm k xmm
//	VFNMADD132PS m256 ymm k ymm
//	VFNMADD132PS xmm  xmm k xmm
//	VFNMADD132PS ymm  ymm k ymm
//	VFNMADD132PS m512 zmm k zmm
//	VFNMADD132PS m512 zmm zmm
//	VFNMADD132PS zmm  zmm k zmm
//	VFNMADD132PS zmm  zmm zmm
func VFNMADD132PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PS.Forms(), sffxs{}, ops)
}

// VFNMADD132PS_BCST: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFNMADD132PS.BCST m32 xmm k xmm
//	VFNMADD132PS.BCST m32 xmm xmm
//	VFNMADD132PS.BCST m32 ymm k ymm
//	VFNMADD132PS.BCST m32 ymm ymm
//	VFNMADD132PS.BCST m32 zmm k zmm
//	VFNMADD132PS.BCST m32 zmm zmm
func VFNMADD132PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PS.Forms(), sffxs{sffxBCST}, ops)
}

// VFNMADD132PS_BCST_Z: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFNMADD132PS.BCST.Z m32 xmm k xmm
//	VFNMADD132PS.BCST.Z m32 ymm k ymm
//	VFNMADD132PS.BCST.Z m32 zmm k zmm
func VFNMADD132PS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFNMADD132PS_RD_SAE: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMADD132PS.RD_SAE zmm zmm k zmm
//	VFNMADD132PS.RD_SAE zmm zmm zmm
func VFNMADD132PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMADD132PS_RD_SAE_Z: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD132PS.RD_SAE.Z zmm zmm k zmm
func VFNMADD132PS_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD132PS_RN_SAE: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMADD132PS.RN_SAE zmm zmm k zmm
//	VFNMADD132PS.RN_SAE zmm zmm zmm
func VFNMADD132PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMADD132PS_RN_SAE_Z: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMADD132PS.RN_SAE.Z zmm zmm k zmm
func VFNMADD132PS_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD132PS_RU_SAE: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMADD132PS.RU_SAE zmm zmm k zmm
//	VFNMADD132PS.RU_SAE zmm zmm zmm
func VFNMADD132PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMADD132PS_RU_SAE_Z: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD132PS.RU_SAE.Z zmm zmm k zmm
func VFNMADD132PS_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD132PS_RZ_SAE: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMADD132PS.RZ_SAE zmm zmm k zmm
//	VFNMADD132PS.RZ_SAE zmm zmm zmm
func VFNMADD132PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMADD132PS_RZ_SAE_Z: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMADD132PS.RZ_SAE.Z zmm zmm k zmm
func VFNMADD132PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD132PS_Z: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMADD132PS.Z m128 xmm k xmm
//	VFNMADD132PS.Z m256 ymm k ymm
//	VFNMADD132PS.Z xmm  xmm k xmm
//	VFNMADD132PS.Z ymm  ymm k ymm
//	VFNMADD132PS.Z m512 zmm k zmm
//	VFNMADD132PS.Z zmm  zmm k zmm
func VFNMADD132PS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFNMADD132SD: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMADD132SD m64 xmm xmm
//	VFNMADD132SD xmm xmm xmm
//	VFNMADD132SD m64 xmm k xmm
//	VFNMADD132SD xmm xmm k xmm
func VFNMADD132SD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132SD.Forms(), sffxs{}, ops)
}

// VFNMADD132SD_RD_SAE: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMADD132SD.RD_SAE xmm xmm k xmm
//	VFNMADD132SD.RD_SAE xmm xmm xmm
func VFNMADD132SD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132SD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMADD132SD_RD_SAE_Z: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD132SD.RD_SAE.Z xmm xmm k xmm
func VFNMADD132SD_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132SD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD132SD_RN_SAE: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMADD132SD.RN_SAE xmm xmm k xmm
//	VFNMADD132SD.RN_SAE xmm xmm xmm
func VFNMADD132SD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132SD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMADD132SD_RN_SAE_Z: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMADD132SD.RN_SAE.Z xmm xmm k xmm
func VFNMADD132SD_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132SD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD132SD_RU_SAE: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMADD132SD.RU_SAE xmm xmm k xmm
//	VFNMADD132SD.RU_SAE xmm xmm xmm
func VFNMADD132SD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132SD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMADD132SD_RU_SAE_Z: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD132SD.RU_SAE.Z xmm xmm k xmm
func VFNMADD132SD_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132SD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD132SD_RZ_SAE: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMADD132SD.RZ_SAE xmm xmm k xmm
//	VFNMADD132SD.RZ_SAE xmm xmm xmm
func VFNMADD132SD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132SD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMADD132SD_RZ_SAE_Z: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMADD132SD.RZ_SAE.Z xmm xmm k xmm
func VFNMADD132SD_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132SD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD132SD_Z: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMADD132SD.Z m64 xmm k xmm
//	VFNMADD132SD.Z xmm xmm k xmm
func VFNMADD132SD_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132SD.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFNMADD132SS: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMADD132SS m32 xmm xmm
//	VFNMADD132SS xmm xmm xmm
//	VFNMADD132SS m32 xmm k xmm
//	VFNMADD132SS xmm xmm k xmm
func VFNMADD132SS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132SS.Forms(), sffxs{}, ops)
}

// VFNMADD132SS_RD_SAE: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMADD132SS.RD_SAE xmm xmm k xmm
//	VFNMADD132SS.RD_SAE xmm xmm xmm
func VFNMADD132SS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132SS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMADD132SS_RD_SAE_Z: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD132SS.RD_SAE.Z xmm xmm k xmm
func VFNMADD132SS_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132SS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD132SS_RN_SAE: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMADD132SS.RN_SAE xmm xmm k xmm
//	VFNMADD132SS.RN_SAE xmm xmm xmm
func VFNMADD132SS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132SS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMADD132SS_RN_SAE_Z: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMADD132SS.RN_SAE.Z xmm xmm k xmm
func VFNMADD132SS_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132SS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD132SS_RU_SAE: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMADD132SS.RU_SAE xmm xmm k xmm
//	VFNMADD132SS.RU_SAE xmm xmm xmm
func VFNMADD132SS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132SS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMADD132SS_RU_SAE_Z: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD132SS.RU_SAE.Z xmm xmm k xmm
func VFNMADD132SS_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132SS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD132SS_RZ_SAE: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMADD132SS.RZ_SAE xmm xmm k xmm
//	VFNMADD132SS.RZ_SAE xmm xmm xmm
func VFNMADD132SS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132SS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMADD132SS_RZ_SAE_Z: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMADD132SS.RZ_SAE.Z xmm xmm k xmm
func VFNMADD132SS_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132SS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD132SS_Z: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMADD132SS.Z m32 xmm k xmm
//	VFNMADD132SS.Z xmm xmm k xmm
func VFNMADD132SS_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD132SS.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFNMADD213PD: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMADD213PD m128 xmm xmm
//	VFNMADD213PD m256 ymm ymm
//	VFNMADD213PD xmm  xmm xmm
//	VFNMADD213PD ymm  ymm ymm
//	VFNMADD213PD m128 xmm k xmm
//	VFNMADD213PD m256 ymm k ymm
//	VFNMADD213PD xmm  xmm k xmm
//	VFNMADD213PD ymm  ymm k ymm
//	VFNMADD213PD m512 zmm k zmm
//	VFNMADD213PD m512 zmm zmm
//	VFNMADD213PD zmm  zmm k zmm
//	VFNMADD213PD zmm  zmm zmm
func VFNMADD213PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PD.Forms(), sffxs{}, ops)
}

// VFNMADD213PD_BCST: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFNMADD213PD.BCST m64 xmm k xmm
//	VFNMADD213PD.BCST m64 xmm xmm
//	VFNMADD213PD.BCST m64 ymm k ymm
//	VFNMADD213PD.BCST m64 ymm ymm
//	VFNMADD213PD.BCST m64 zmm k zmm
//	VFNMADD213PD.BCST m64 zmm zmm
func VFNMADD213PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PD.Forms(), sffxs{sffxBCST}, ops)
}

// VFNMADD213PD_BCST_Z: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFNMADD213PD.BCST.Z m64 xmm k xmm
//	VFNMADD213PD.BCST.Z m64 ymm k ymm
//	VFNMADD213PD.BCST.Z m64 zmm k zmm
func VFNMADD213PD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFNMADD213PD_RD_SAE: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMADD213PD.RD_SAE zmm zmm k zmm
//	VFNMADD213PD.RD_SAE zmm zmm zmm
func VFNMADD213PD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMADD213PD_RD_SAE_Z: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD213PD.RD_SAE.Z zmm zmm k zmm
func VFNMADD213PD_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD213PD_RN_SAE: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMADD213PD.RN_SAE zmm zmm k zmm
//	VFNMADD213PD.RN_SAE zmm zmm zmm
func VFNMADD213PD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMADD213PD_RN_SAE_Z: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMADD213PD.RN_SAE.Z zmm zmm k zmm
func VFNMADD213PD_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD213PD_RU_SAE: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMADD213PD.RU_SAE zmm zmm k zmm
//	VFNMADD213PD.RU_SAE zmm zmm zmm
func VFNMADD213PD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMADD213PD_RU_SAE_Z: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD213PD.RU_SAE.Z zmm zmm k zmm
func VFNMADD213PD_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD213PD_RZ_SAE: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMADD213PD.RZ_SAE zmm zmm k zmm
//	VFNMADD213PD.RZ_SAE zmm zmm zmm
func VFNMADD213PD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMADD213PD_RZ_SAE_Z: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMADD213PD.RZ_SAE.Z zmm zmm k zmm
func VFNMADD213PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD213PD_Z: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMADD213PD.Z m128 xmm k xmm
//	VFNMADD213PD.Z m256 ymm k ymm
//	VFNMADD213PD.Z xmm  xmm k xmm
//	VFNMADD213PD.Z ymm  ymm k ymm
//	VFNMADD213PD.Z m512 zmm k zmm
//	VFNMADD213PD.Z zmm  zmm k zmm
func VFNMADD213PD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFNMADD213PS: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMADD213PS m128 xmm xmm
//	VFNMADD213PS m256 ymm ymm
//	VFNMADD213PS xmm  xmm xmm
//	VFNMADD213PS ymm  ymm ymm
//	VFNMADD213PS m128 xmm k xmm
//	VFNMADD213PS m256 ymm k ymm
//	VFNMADD213PS xmm  xmm k xmm
//	VFNMADD213PS ymm  ymm k ymm
//	VFNMADD213PS m512 zmm k zmm
//	VFNMADD213PS m512 zmm zmm
//	VFNMADD213PS zmm  zmm k zmm
//	VFNMADD213PS zmm  zmm zmm
func VFNMADD213PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PS.Forms(), sffxs{}, ops)
}

// VFNMADD213PS_BCST: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFNMADD213PS.BCST m32 xmm k xmm
//	VFNMADD213PS.BCST m32 xmm xmm
//	VFNMADD213PS.BCST m32 ymm k ymm
//	VFNMADD213PS.BCST m32 ymm ymm
//	VFNMADD213PS.BCST m32 zmm k zmm
//	VFNMADD213PS.BCST m32 zmm zmm
func VFNMADD213PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PS.Forms(), sffxs{sffxBCST}, ops)
}

// VFNMADD213PS_BCST_Z: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFNMADD213PS.BCST.Z m32 xmm k xmm
//	VFNMADD213PS.BCST.Z m32 ymm k ymm
//	VFNMADD213PS.BCST.Z m32 zmm k zmm
func VFNMADD213PS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFNMADD213PS_RD_SAE: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMADD213PS.RD_SAE zmm zmm k zmm
//	VFNMADD213PS.RD_SAE zmm zmm zmm
func VFNMADD213PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMADD213PS_RD_SAE_Z: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD213PS.RD_SAE.Z zmm zmm k zmm
func VFNMADD213PS_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD213PS_RN_SAE: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMADD213PS.RN_SAE zmm zmm k zmm
//	VFNMADD213PS.RN_SAE zmm zmm zmm
func VFNMADD213PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMADD213PS_RN_SAE_Z: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMADD213PS.RN_SAE.Z zmm zmm k zmm
func VFNMADD213PS_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD213PS_RU_SAE: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMADD213PS.RU_SAE zmm zmm k zmm
//	VFNMADD213PS.RU_SAE zmm zmm zmm
func VFNMADD213PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMADD213PS_RU_SAE_Z: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD213PS.RU_SAE.Z zmm zmm k zmm
func VFNMADD213PS_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD213PS_RZ_SAE: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMADD213PS.RZ_SAE zmm zmm k zmm
//	VFNMADD213PS.RZ_SAE zmm zmm zmm
func VFNMADD213PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMADD213PS_RZ_SAE_Z: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMADD213PS.RZ_SAE.Z zmm zmm k zmm
func VFNMADD213PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD213PS_Z: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMADD213PS.Z m128 xmm k xmm
//	VFNMADD213PS.Z m256 ymm k ymm
//	VFNMADD213PS.Z xmm  xmm k xmm
//	VFNMADD213PS.Z ymm  ymm k ymm
//	VFNMADD213PS.Z m512 zmm k zmm
//	VFNMADD213PS.Z zmm  zmm k zmm
func VFNMADD213PS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFNMADD213SD: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMADD213SD m64 xmm xmm
//	VFNMADD213SD xmm xmm xmm
//	VFNMADD213SD m64 xmm k xmm
//	VFNMADD213SD xmm xmm k xmm
func VFNMADD213SD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213SD.Forms(), sffxs{}, ops)
}

// VFNMADD213SD_RD_SAE: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMADD213SD.RD_SAE xmm xmm k xmm
//	VFNMADD213SD.RD_SAE xmm xmm xmm
func VFNMADD213SD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213SD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMADD213SD_RD_SAE_Z: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD213SD.RD_SAE.Z xmm xmm k xmm
func VFNMADD213SD_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213SD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD213SD_RN_SAE: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMADD213SD.RN_SAE xmm xmm k xmm
//	VFNMADD213SD.RN_SAE xmm xmm xmm
func VFNMADD213SD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213SD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMADD213SD_RN_SAE_Z: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMADD213SD.RN_SAE.Z xmm xmm k xmm
func VFNMADD213SD_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213SD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD213SD_RU_SAE: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMADD213SD.RU_SAE xmm xmm k xmm
//	VFNMADD213SD.RU_SAE xmm xmm xmm
func VFNMADD213SD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213SD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMADD213SD_RU_SAE_Z: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD213SD.RU_SAE.Z xmm xmm k xmm
func VFNMADD213SD_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213SD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD213SD_RZ_SAE: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMADD213SD.RZ_SAE xmm xmm k xmm
//	VFNMADD213SD.RZ_SAE xmm xmm xmm
func VFNMADD213SD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213SD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMADD213SD_RZ_SAE_Z: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMADD213SD.RZ_SAE.Z xmm xmm k xmm
func VFNMADD213SD_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213SD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD213SD_Z: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMADD213SD.Z m64 xmm k xmm
//	VFNMADD213SD.Z xmm xmm k xmm
func VFNMADD213SD_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213SD.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFNMADD213SS: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMADD213SS m32 xmm xmm
//	VFNMADD213SS xmm xmm xmm
//	VFNMADD213SS m32 xmm k xmm
//	VFNMADD213SS xmm xmm k xmm
func VFNMADD213SS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213SS.Forms(), sffxs{}, ops)
}

// VFNMADD213SS_RD_SAE: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMADD213SS.RD_SAE xmm xmm k xmm
//	VFNMADD213SS.RD_SAE xmm xmm xmm
func VFNMADD213SS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213SS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMADD213SS_RD_SAE_Z: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD213SS.RD_SAE.Z xmm xmm k xmm
func VFNMADD213SS_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213SS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD213SS_RN_SAE: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMADD213SS.RN_SAE xmm xmm k xmm
//	VFNMADD213SS.RN_SAE xmm xmm xmm
func VFNMADD213SS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213SS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMADD213SS_RN_SAE_Z: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMADD213SS.RN_SAE.Z xmm xmm k xmm
func VFNMADD213SS_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213SS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD213SS_RU_SAE: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMADD213SS.RU_SAE xmm xmm k xmm
//	VFNMADD213SS.RU_SAE xmm xmm xmm
func VFNMADD213SS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213SS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMADD213SS_RU_SAE_Z: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD213SS.RU_SAE.Z xmm xmm k xmm
func VFNMADD213SS_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213SS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD213SS_RZ_SAE: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMADD213SS.RZ_SAE xmm xmm k xmm
//	VFNMADD213SS.RZ_SAE xmm xmm xmm
func VFNMADD213SS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213SS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMADD213SS_RZ_SAE_Z: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMADD213SS.RZ_SAE.Z xmm xmm k xmm
func VFNMADD213SS_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213SS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD213SS_Z: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMADD213SS.Z m32 xmm k xmm
//	VFNMADD213SS.Z xmm xmm k xmm
func VFNMADD213SS_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD213SS.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFNMADD231PD: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMADD231PD m128 xmm xmm
//	VFNMADD231PD m256 ymm ymm
//	VFNMADD231PD xmm  xmm xmm
//	VFNMADD231PD ymm  ymm ymm
//	VFNMADD231PD m128 xmm k xmm
//	VFNMADD231PD m256 ymm k ymm
//	VFNMADD231PD xmm  xmm k xmm
//	VFNMADD231PD ymm  ymm k ymm
//	VFNMADD231PD m512 zmm k zmm
//	VFNMADD231PD m512 zmm zmm
//	VFNMADD231PD zmm  zmm k zmm
//	VFNMADD231PD zmm  zmm zmm
func VFNMADD231PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PD.Forms(), sffxs{}, ops)
}

// VFNMADD231PD_BCST: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFNMADD231PD.BCST m64 xmm k xmm
//	VFNMADD231PD.BCST m64 xmm xmm
//	VFNMADD231PD.BCST m64 ymm k ymm
//	VFNMADD231PD.BCST m64 ymm ymm
//	VFNMADD231PD.BCST m64 zmm k zmm
//	VFNMADD231PD.BCST m64 zmm zmm
func VFNMADD231PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PD.Forms(), sffxs{sffxBCST}, ops)
}

// VFNMADD231PD_BCST_Z: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFNMADD231PD.BCST.Z m64 xmm k xmm
//	VFNMADD231PD.BCST.Z m64 ymm k ymm
//	VFNMADD231PD.BCST.Z m64 zmm k zmm
func VFNMADD231PD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFNMADD231PD_RD_SAE: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMADD231PD.RD_SAE zmm zmm k zmm
//	VFNMADD231PD.RD_SAE zmm zmm zmm
func VFNMADD231PD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMADD231PD_RD_SAE_Z: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD231PD.RD_SAE.Z zmm zmm k zmm
func VFNMADD231PD_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD231PD_RN_SAE: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMADD231PD.RN_SAE zmm zmm k zmm
//	VFNMADD231PD.RN_SAE zmm zmm zmm
func VFNMADD231PD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMADD231PD_RN_SAE_Z: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMADD231PD.RN_SAE.Z zmm zmm k zmm
func VFNMADD231PD_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD231PD_RU_SAE: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMADD231PD.RU_SAE zmm zmm k zmm
//	VFNMADD231PD.RU_SAE zmm zmm zmm
func VFNMADD231PD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMADD231PD_RU_SAE_Z: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD231PD.RU_SAE.Z zmm zmm k zmm
func VFNMADD231PD_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD231PD_RZ_SAE: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMADD231PD.RZ_SAE zmm zmm k zmm
//	VFNMADD231PD.RZ_SAE zmm zmm zmm
func VFNMADD231PD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMADD231PD_RZ_SAE_Z: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMADD231PD.RZ_SAE.Z zmm zmm k zmm
func VFNMADD231PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD231PD_Z: Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMADD231PD.Z m128 xmm k xmm
//	VFNMADD231PD.Z m256 ymm k ymm
//	VFNMADD231PD.Z xmm  xmm k xmm
//	VFNMADD231PD.Z ymm  ymm k ymm
//	VFNMADD231PD.Z m512 zmm k zmm
//	VFNMADD231PD.Z zmm  zmm k zmm
func VFNMADD231PD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFNMADD231PS: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMADD231PS m128 xmm xmm
//	VFNMADD231PS m256 ymm ymm
//	VFNMADD231PS xmm  xmm xmm
//	VFNMADD231PS ymm  ymm ymm
//	VFNMADD231PS m128 xmm k xmm
//	VFNMADD231PS m256 ymm k ymm
//	VFNMADD231PS xmm  xmm k xmm
//	VFNMADD231PS ymm  ymm k ymm
//	VFNMADD231PS m512 zmm k zmm
//	VFNMADD231PS m512 zmm zmm
//	VFNMADD231PS zmm  zmm k zmm
//	VFNMADD231PS zmm  zmm zmm
func VFNMADD231PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PS.Forms(), sffxs{}, ops)
}

// VFNMADD231PS_BCST: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFNMADD231PS.BCST m32 xmm k xmm
//	VFNMADD231PS.BCST m32 xmm xmm
//	VFNMADD231PS.BCST m32 ymm k ymm
//	VFNMADD231PS.BCST m32 ymm ymm
//	VFNMADD231PS.BCST m32 zmm k zmm
//	VFNMADD231PS.BCST m32 zmm zmm
func VFNMADD231PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PS.Forms(), sffxs{sffxBCST}, ops)
}

// VFNMADD231PS_BCST_Z: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFNMADD231PS.BCST.Z m32 xmm k xmm
//	VFNMADD231PS.BCST.Z m32 ymm k ymm
//	VFNMADD231PS.BCST.Z m32 zmm k zmm
func VFNMADD231PS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFNMADD231PS_RD_SAE: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMADD231PS.RD_SAE zmm zmm k zmm
//	VFNMADD231PS.RD_SAE zmm zmm zmm
func VFNMADD231PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMADD231PS_RD_SAE_Z: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD231PS.RD_SAE.Z zmm zmm k zmm
func VFNMADD231PS_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD231PS_RN_SAE: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMADD231PS.RN_SAE zmm zmm k zmm
//	VFNMADD231PS.RN_SAE zmm zmm zmm
func VFNMADD231PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMADD231PS_RN_SAE_Z: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMADD231PS.RN_SAE.Z zmm zmm k zmm
func VFNMADD231PS_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD231PS_RU_SAE: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMADD231PS.RU_SAE zmm zmm k zmm
//	VFNMADD231PS.RU_SAE zmm zmm zmm
func VFNMADD231PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMADD231PS_RU_SAE_Z: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD231PS.RU_SAE.Z zmm zmm k zmm
func VFNMADD231PS_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD231PS_RZ_SAE: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMADD231PS.RZ_SAE zmm zmm k zmm
//	VFNMADD231PS.RZ_SAE zmm zmm zmm
func VFNMADD231PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMADD231PS_RZ_SAE_Z: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMADD231PS.RZ_SAE.Z zmm zmm k zmm
func VFNMADD231PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMADD231PS_Z: Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMADD231PS.Z m128 xmm k xmm
//	VFNMADD231PS.Z m256 ymm k ymm
//	VFNMADD231PS.Z xmm  xmm k xmm
//	VFNMADD231PS.Z ymm  ymm k ymm
//	VFNMADD231PS.Z m512 zmm k zmm
//	VFNMADD231PS.Z zmm  zmm k zmm
func VFNMADD231PS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFNMADD231SD: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMADD231SD m64 xmm xmm
//	VFNMADD231SD xmm xmm xmm
//	VFNMADD231SD m64 xmm k xmm
//	VFNMADD231SD xmm xmm k xmm
func VFNMADD231SD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231SD.Forms(), sffxs{}, ops)
}

// VFNMADD231SD_RD_SAE: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMADD231SD.RD_SAE xmm xmm k xmm
//	VFNMADD231SD.RD_SAE xmm xmm xmm
func VFNMADD231SD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231SD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMADD231SD_RD_SAE_Z: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD231SD.RD_SAE.Z xmm xmm k xmm
func VFNMADD231SD_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231SD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD231SD_RN_SAE: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMADD231SD.RN_SAE xmm xmm k xmm
//	VFNMADD231SD.RN_SAE xmm xmm xmm
func VFNMADD231SD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231SD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMADD231SD_RN_SAE_Z: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMADD231SD.RN_SAE.Z xmm xmm k xmm
func VFNMADD231SD_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231SD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD231SD_RU_SAE: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMADD231SD.RU_SAE xmm xmm k xmm
//	VFNMADD231SD.RU_SAE xmm xmm xmm
func VFNMADD231SD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231SD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMADD231SD_RU_SAE_Z: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD231SD.RU_SAE.Z xmm xmm k xmm
func VFNMADD231SD_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231SD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD231SD_RZ_SAE: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMADD231SD.RZ_SAE xmm xmm k xmm
//	VFNMADD231SD.RZ_SAE xmm xmm xmm
func VFNMADD231SD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231SD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMADD231SD_RZ_SAE_Z: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMADD231SD.RZ_SAE.Z xmm xmm k xmm
func VFNMADD231SD_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231SD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD231SD_Z: Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMADD231SD.Z m64 xmm k xmm
//	VFNMADD231SD.Z xmm xmm k xmm
func VFNMADD231SD_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231SD.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFNMADD231SS: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMADD231SS m32 xmm xmm
//	VFNMADD231SS xmm xmm xmm
//	VFNMADD231SS m32 xmm k xmm
//	VFNMADD231SS xmm xmm k xmm
func VFNMADD231SS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231SS.Forms(), sffxs{}, ops)
}

// VFNMADD231SS_RD_SAE: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMADD231SS.RD_SAE xmm xmm k xmm
//	VFNMADD231SS.RD_SAE xmm xmm xmm
func VFNMADD231SS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231SS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMADD231SS_RD_SAE_Z: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD231SS.RD_SAE.Z xmm xmm k xmm
func VFNMADD231SS_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231SS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD231SS_RN_SAE: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMADD231SS.RN_SAE xmm xmm k xmm
//	VFNMADD231SS.RN_SAE xmm xmm xmm
func VFNMADD231SS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231SS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMADD231SS_RN_SAE_Z: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMADD231SS.RN_SAE.Z xmm xmm k xmm
func VFNMADD231SS_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231SS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD231SS_RU_SAE: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMADD231SS.RU_SAE xmm xmm k xmm
//	VFNMADD231SS.RU_SAE xmm xmm xmm
func VFNMADD231SS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231SS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMADD231SS_RU_SAE_Z: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMADD231SS.RU_SAE.Z xmm xmm k xmm
func VFNMADD231SS_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231SS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD231SS_RZ_SAE: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMADD231SS.RZ_SAE xmm xmm k xmm
//	VFNMADD231SS.RZ_SAE xmm xmm xmm
func VFNMADD231SS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231SS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMADD231SS_RZ_SAE_Z: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMADD231SS.RZ_SAE.Z xmm xmm k xmm
func VFNMADD231SS_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231SS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMADD231SS_Z: Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMADD231SS.Z m32 xmm k xmm
//	VFNMADD231SS.Z xmm xmm k xmm
func VFNMADD231SS_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMADD231SS.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFNMSUB132PD: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMSUB132PD m128 xmm xmm
//	VFNMSUB132PD m256 ymm ymm
//	VFNMSUB132PD xmm  xmm xmm
//	VFNMSUB132PD ymm  ymm ymm
//	VFNMSUB132PD m128 xmm k xmm
//	VFNMSUB132PD m256 ymm k ymm
//	VFNMSUB132PD xmm  xmm k xmm
//	VFNMSUB132PD ymm  ymm k ymm
//	VFNMSUB132PD m512 zmm k zmm
//	VFNMSUB132PD m512 zmm zmm
//	VFNMSUB132PD zmm  zmm k zmm
//	VFNMSUB132PD zmm  zmm zmm
func VFNMSUB132PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PD.Forms(), sffxs{}, ops)
}

// VFNMSUB132PD_BCST: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFNMSUB132PD.BCST m64 xmm k xmm
//	VFNMSUB132PD.BCST m64 xmm xmm
//	VFNMSUB132PD.BCST m64 ymm k ymm
//	VFNMSUB132PD.BCST m64 ymm ymm
//	VFNMSUB132PD.BCST m64 zmm k zmm
//	VFNMSUB132PD.BCST m64 zmm zmm
func VFNMSUB132PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PD.Forms(), sffxs{sffxBCST}, ops)
}

// VFNMSUB132PD_BCST_Z: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132PD.BCST.Z m64 xmm k xmm
//	VFNMSUB132PD.BCST.Z m64 ymm k ymm
//	VFNMSUB132PD.BCST.Z m64 zmm k zmm
func VFNMSUB132PD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFNMSUB132PD_RD_SAE: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMSUB132PD.RD_SAE zmm zmm k zmm
//	VFNMSUB132PD.RD_SAE zmm zmm zmm
func VFNMSUB132PD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMSUB132PD_RD_SAE_Z: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132PD.RD_SAE.Z zmm zmm k zmm
func VFNMSUB132PD_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB132PD_RN_SAE: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMSUB132PD.RN_SAE zmm zmm k zmm
//	VFNMSUB132PD.RN_SAE zmm zmm zmm
func VFNMSUB132PD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMSUB132PD_RN_SAE_Z: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132PD.RN_SAE.Z zmm zmm k zmm
func VFNMSUB132PD_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB132PD_RU_SAE: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMSUB132PD.RU_SAE zmm zmm k zmm
//	VFNMSUB132PD.RU_SAE zmm zmm zmm
func VFNMSUB132PD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMSUB132PD_RU_SAE_Z: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132PD.RU_SAE.Z zmm zmm k zmm
func VFNMSUB132PD_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB132PD_RZ_SAE: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMSUB132PD.RZ_SAE zmm zmm k zmm
//	VFNMSUB132PD.RZ_SAE zmm zmm zmm
func VFNMSUB132PD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMSUB132PD_RZ_SAE_Z: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132PD.RZ_SAE.Z zmm zmm k zmm
func VFNMSUB132PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB132PD_Z: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132PD.Z m128 xmm k xmm
//	VFNMSUB132PD.Z m256 ymm k ymm
//	VFNMSUB132PD.Z xmm  xmm k xmm
//	VFNMSUB132PD.Z ymm  ymm k ymm
//	VFNMSUB132PD.Z m512 zmm k zmm
//	VFNMSUB132PD.Z zmm  zmm k zmm
func VFNMSUB132PD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFNMSUB132PS: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMSUB132PS m128 xmm xmm
//	VFNMSUB132PS m256 ymm ymm
//	VFNMSUB132PS xmm  xmm xmm
//	VFNMSUB132PS ymm  ymm ymm
//	VFNMSUB132PS m128 xmm k xmm
//	VFNMSUB132PS m256 ymm k ymm
//	VFNMSUB132PS xmm  xmm k xmm
//	VFNMSUB132PS ymm  ymm k ymm
//	VFNMSUB132PS m512 zmm k zmm
//	VFNMSUB132PS m512 zmm zmm
//	VFNMSUB132PS zmm  zmm k zmm
//	VFNMSUB132PS zmm  zmm zmm
func VFNMSUB132PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PS.Forms(), sffxs{}, ops)
}

// VFNMSUB132PS_BCST: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFNMSUB132PS.BCST m32 xmm k xmm
//	VFNMSUB132PS.BCST m32 xmm xmm
//	VFNMSUB132PS.BCST m32 ymm k ymm
//	VFNMSUB132PS.BCST m32 ymm ymm
//	VFNMSUB132PS.BCST m32 zmm k zmm
//	VFNMSUB132PS.BCST m32 zmm zmm
func VFNMSUB132PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PS.Forms(), sffxs{sffxBCST}, ops)
}

// VFNMSUB132PS_BCST_Z: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132PS.BCST.Z m32 xmm k xmm
//	VFNMSUB132PS.BCST.Z m32 ymm k ymm
//	VFNMSUB132PS.BCST.Z m32 zmm k zmm
func VFNMSUB132PS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFNMSUB132PS_RD_SAE: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMSUB132PS.RD_SAE zmm zmm k zmm
//	VFNMSUB132PS.RD_SAE zmm zmm zmm
func VFNMSUB132PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMSUB132PS_RD_SAE_Z: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132PS.RD_SAE.Z zmm zmm k zmm
func VFNMSUB132PS_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB132PS_RN_SAE: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMSUB132PS.RN_SAE zmm zmm k zmm
//	VFNMSUB132PS.RN_SAE zmm zmm zmm
func VFNMSUB132PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMSUB132PS_RN_SAE_Z: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132PS.RN_SAE.Z zmm zmm k zmm
func VFNMSUB132PS_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB132PS_RU_SAE: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMSUB132PS.RU_SAE zmm zmm k zmm
//	VFNMSUB132PS.RU_SAE zmm zmm zmm
func VFNMSUB132PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMSUB132PS_RU_SAE_Z: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132PS.RU_SAE.Z zmm zmm k zmm
func VFNMSUB132PS_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB132PS_RZ_SAE: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMSUB132PS.RZ_SAE zmm zmm k zmm
//	VFNMSUB132PS.RZ_SAE zmm zmm zmm
func VFNMSUB132PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMSUB132PS_RZ_SAE_Z: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132PS.RZ_SAE.Z zmm zmm k zmm
func VFNMSUB132PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB132PS_Z: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132PS.Z m128 xmm k xmm
//	VFNMSUB132PS.Z m256 ymm k ymm
//	VFNMSUB132PS.Z xmm  xmm k xmm
//	VFNMSUB132PS.Z ymm  ymm k ymm
//	VFNMSUB132PS.Z m512 zmm k zmm
//	VFNMSUB132PS.Z zmm  zmm k zmm
func VFNMSUB132PS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFNMSUB132SD: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMSUB132SD m64 xmm xmm
//	VFNMSUB132SD xmm xmm xmm
//	VFNMSUB132SD m64 xmm k xmm
//	VFNMSUB132SD xmm xmm k xmm
func VFNMSUB132SD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132SD.Forms(), sffxs{}, ops)
}

// VFNMSUB132SD_RD_SAE: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMSUB132SD.RD_SAE xmm xmm k xmm
//	VFNMSUB132SD.RD_SAE xmm xmm xmm
func VFNMSUB132SD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132SD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMSUB132SD_RD_SAE_Z: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132SD.RD_SAE.Z xmm xmm k xmm
func VFNMSUB132SD_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132SD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB132SD_RN_SAE: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMSUB132SD.RN_SAE xmm xmm k xmm
//	VFNMSUB132SD.RN_SAE xmm xmm xmm
func VFNMSUB132SD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132SD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMSUB132SD_RN_SAE_Z: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132SD.RN_SAE.Z xmm xmm k xmm
func VFNMSUB132SD_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132SD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB132SD_RU_SAE: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMSUB132SD.RU_SAE xmm xmm k xmm
//	VFNMSUB132SD.RU_SAE xmm xmm xmm
func VFNMSUB132SD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132SD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMSUB132SD_RU_SAE_Z: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132SD.RU_SAE.Z xmm xmm k xmm
func VFNMSUB132SD_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132SD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB132SD_RZ_SAE: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMSUB132SD.RZ_SAE xmm xmm k xmm
//	VFNMSUB132SD.RZ_SAE xmm xmm xmm
func VFNMSUB132SD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132SD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMSUB132SD_RZ_SAE_Z: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132SD.RZ_SAE.Z xmm xmm k xmm
func VFNMSUB132SD_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132SD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB132SD_Z: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132SD.Z m64 xmm k xmm
//	VFNMSUB132SD.Z xmm xmm k xmm
func VFNMSUB132SD_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132SD.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFNMSUB132SS: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMSUB132SS m32 xmm xmm
//	VFNMSUB132SS xmm xmm xmm
//	VFNMSUB132SS m32 xmm k xmm
//	VFNMSUB132SS xmm xmm k xmm
func VFNMSUB132SS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132SS.Forms(), sffxs{}, ops)
}

// VFNMSUB132SS_RD_SAE: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMSUB132SS.RD_SAE xmm xmm k xmm
//	VFNMSUB132SS.RD_SAE xmm xmm xmm
func VFNMSUB132SS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132SS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMSUB132SS_RD_SAE_Z: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132SS.RD_SAE.Z xmm xmm k xmm
func VFNMSUB132SS_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132SS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB132SS_RN_SAE: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMSUB132SS.RN_SAE xmm xmm k xmm
//	VFNMSUB132SS.RN_SAE xmm xmm xmm
func VFNMSUB132SS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132SS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMSUB132SS_RN_SAE_Z: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132SS.RN_SAE.Z xmm xmm k xmm
func VFNMSUB132SS_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132SS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB132SS_RU_SAE: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMSUB132SS.RU_SAE xmm xmm k xmm
//	VFNMSUB132SS.RU_SAE xmm xmm xmm
func VFNMSUB132SS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132SS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMSUB132SS_RU_SAE_Z: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132SS.RU_SAE.Z xmm xmm k xmm
func VFNMSUB132SS_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132SS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB132SS_RZ_SAE: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMSUB132SS.RZ_SAE xmm xmm k xmm
//	VFNMSUB132SS.RZ_SAE xmm xmm xmm
func VFNMSUB132SS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132SS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMSUB132SS_RZ_SAE_Z: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132SS.RZ_SAE.Z xmm xmm k xmm
func VFNMSUB132SS_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132SS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB132SS_Z: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMSUB132SS.Z m32 xmm k xmm
//	VFNMSUB132SS.Z xmm xmm k xmm
func VFNMSUB132SS_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB132SS.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFNMSUB213PD: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMSUB213PD m128 xmm xmm
//	VFNMSUB213PD m256 ymm ymm
//	VFNMSUB213PD xmm  xmm xmm
//	VFNMSUB213PD ymm  ymm ymm
//	VFNMSUB213PD m128 xmm k xmm
//	VFNMSUB213PD m256 ymm k ymm
//	VFNMSUB213PD xmm  xmm k xmm
//	VFNMSUB213PD ymm  ymm k ymm
//	VFNMSUB213PD m512 zmm k zmm
//	VFNMSUB213PD m512 zmm zmm
//	VFNMSUB213PD zmm  zmm k zmm
//	VFNMSUB213PD zmm  zmm zmm
func VFNMSUB213PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PD.Forms(), sffxs{}, ops)
}

// VFNMSUB213PD_BCST: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFNMSUB213PD.BCST m64 xmm k xmm
//	VFNMSUB213PD.BCST m64 xmm xmm
//	VFNMSUB213PD.BCST m64 ymm k ymm
//	VFNMSUB213PD.BCST m64 ymm ymm
//	VFNMSUB213PD.BCST m64 zmm k zmm
//	VFNMSUB213PD.BCST m64 zmm zmm
func VFNMSUB213PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PD.Forms(), sffxs{sffxBCST}, ops)
}

// VFNMSUB213PD_BCST_Z: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213PD.BCST.Z m64 xmm k xmm
//	VFNMSUB213PD.BCST.Z m64 ymm k ymm
//	VFNMSUB213PD.BCST.Z m64 zmm k zmm
func VFNMSUB213PD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFNMSUB213PD_RD_SAE: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMSUB213PD.RD_SAE zmm zmm k zmm
//	VFNMSUB213PD.RD_SAE zmm zmm zmm
func VFNMSUB213PD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMSUB213PD_RD_SAE_Z: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213PD.RD_SAE.Z zmm zmm k zmm
func VFNMSUB213PD_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB213PD_RN_SAE: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMSUB213PD.RN_SAE zmm zmm k zmm
//	VFNMSUB213PD.RN_SAE zmm zmm zmm
func VFNMSUB213PD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMSUB213PD_RN_SAE_Z: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213PD.RN_SAE.Z zmm zmm k zmm
func VFNMSUB213PD_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB213PD_RU_SAE: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMSUB213PD.RU_SAE zmm zmm k zmm
//	VFNMSUB213PD.RU_SAE zmm zmm zmm
func VFNMSUB213PD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMSUB213PD_RU_SAE_Z: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213PD.RU_SAE.Z zmm zmm k zmm
func VFNMSUB213PD_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB213PD_RZ_SAE: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMSUB213PD.RZ_SAE zmm zmm k zmm
//	VFNMSUB213PD.RZ_SAE zmm zmm zmm
func VFNMSUB213PD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMSUB213PD_RZ_SAE_Z: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213PD.RZ_SAE.Z zmm zmm k zmm
func VFNMSUB213PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB213PD_Z: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213PD.Z m128 xmm k xmm
//	VFNMSUB213PD.Z m256 ymm k ymm
//	VFNMSUB213PD.Z xmm  xmm k xmm
//	VFNMSUB213PD.Z ymm  ymm k ymm
//	VFNMSUB213PD.Z m512 zmm k zmm
//	VFNMSUB213PD.Z zmm  zmm k zmm
func VFNMSUB213PD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFNMSUB213PS: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMSUB213PS m128 xmm xmm
//	VFNMSUB213PS m256 ymm ymm
//	VFNMSUB213PS xmm  xmm xmm
//	VFNMSUB213PS ymm  ymm ymm
//	VFNMSUB213PS m128 xmm k xmm
//	VFNMSUB213PS m256 ymm k ymm
//	VFNMSUB213PS xmm  xmm k xmm
//	VFNMSUB213PS ymm  ymm k ymm
//	VFNMSUB213PS m512 zmm k zmm
//	VFNMSUB213PS m512 zmm zmm
//	VFNMSUB213PS zmm  zmm k zmm
//	VFNMSUB213PS zmm  zmm zmm
func VFNMSUB213PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PS.Forms(), sffxs{}, ops)
}

// VFNMSUB213PS_BCST: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFNMSUB213PS.BCST m32 xmm k xmm
//	VFNMSUB213PS.BCST m32 xmm xmm
//	VFNMSUB213PS.BCST m32 ymm k ymm
//	VFNMSUB213PS.BCST m32 ymm ymm
//	VFNMSUB213PS.BCST m32 zmm k zmm
//	VFNMSUB213PS.BCST m32 zmm zmm
func VFNMSUB213PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PS.Forms(), sffxs{sffxBCST}, ops)
}

// VFNMSUB213PS_BCST_Z: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213PS.BCST.Z m32 xmm k xmm
//	VFNMSUB213PS.BCST.Z m32 ymm k ymm
//	VFNMSUB213PS.BCST.Z m32 zmm k zmm
func VFNMSUB213PS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFNMSUB213PS_RD_SAE: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMSUB213PS.RD_SAE zmm zmm k zmm
//	VFNMSUB213PS.RD_SAE zmm zmm zmm
func VFNMSUB213PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMSUB213PS_RD_SAE_Z: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213PS.RD_SAE.Z zmm zmm k zmm
func VFNMSUB213PS_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB213PS_RN_SAE: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMSUB213PS.RN_SAE zmm zmm k zmm
//	VFNMSUB213PS.RN_SAE zmm zmm zmm
func VFNMSUB213PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMSUB213PS_RN_SAE_Z: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213PS.RN_SAE.Z zmm zmm k zmm
func VFNMSUB213PS_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB213PS_RU_SAE: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMSUB213PS.RU_SAE zmm zmm k zmm
//	VFNMSUB213PS.RU_SAE zmm zmm zmm
func VFNMSUB213PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMSUB213PS_RU_SAE_Z: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213PS.RU_SAE.Z zmm zmm k zmm
func VFNMSUB213PS_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB213PS_RZ_SAE: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMSUB213PS.RZ_SAE zmm zmm k zmm
//	VFNMSUB213PS.RZ_SAE zmm zmm zmm
func VFNMSUB213PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMSUB213PS_RZ_SAE_Z: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213PS.RZ_SAE.Z zmm zmm k zmm
func VFNMSUB213PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB213PS_Z: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213PS.Z m128 xmm k xmm
//	VFNMSUB213PS.Z m256 ymm k ymm
//	VFNMSUB213PS.Z xmm  xmm k xmm
//	VFNMSUB213PS.Z ymm  ymm k ymm
//	VFNMSUB213PS.Z m512 zmm k zmm
//	VFNMSUB213PS.Z zmm  zmm k zmm
func VFNMSUB213PS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFNMSUB213SD: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMSUB213SD m64 xmm xmm
//	VFNMSUB213SD xmm xmm xmm
//	VFNMSUB213SD m64 xmm k xmm
//	VFNMSUB213SD xmm xmm k xmm
func VFNMSUB213SD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213SD.Forms(), sffxs{}, ops)
}

// VFNMSUB213SD_RD_SAE: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMSUB213SD.RD_SAE xmm xmm k xmm
//	VFNMSUB213SD.RD_SAE xmm xmm xmm
func VFNMSUB213SD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213SD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMSUB213SD_RD_SAE_Z: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213SD.RD_SAE.Z xmm xmm k xmm
func VFNMSUB213SD_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213SD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB213SD_RN_SAE: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMSUB213SD.RN_SAE xmm xmm k xmm
//	VFNMSUB213SD.RN_SAE xmm xmm xmm
func VFNMSUB213SD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213SD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMSUB213SD_RN_SAE_Z: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213SD.RN_SAE.Z xmm xmm k xmm
func VFNMSUB213SD_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213SD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB213SD_RU_SAE: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMSUB213SD.RU_SAE xmm xmm k xmm
//	VFNMSUB213SD.RU_SAE xmm xmm xmm
func VFNMSUB213SD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213SD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMSUB213SD_RU_SAE_Z: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213SD.RU_SAE.Z xmm xmm k xmm
func VFNMSUB213SD_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213SD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB213SD_RZ_SAE: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMSUB213SD.RZ_SAE xmm xmm k xmm
//	VFNMSUB213SD.RZ_SAE xmm xmm xmm
func VFNMSUB213SD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213SD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMSUB213SD_RZ_SAE_Z: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213SD.RZ_SAE.Z xmm xmm k xmm
func VFNMSUB213SD_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213SD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB213SD_Z: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213SD.Z m64 xmm k xmm
//	VFNMSUB213SD.Z xmm xmm k xmm
func VFNMSUB213SD_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213SD.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFNMSUB213SS: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMSUB213SS m32 xmm xmm
//	VFNMSUB213SS xmm xmm xmm
//	VFNMSUB213SS m32 xmm k xmm
//	VFNMSUB213SS xmm xmm k xmm
func VFNMSUB213SS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213SS.Forms(), sffxs{}, ops)
}

// VFNMSUB213SS_RD_SAE: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMSUB213SS.RD_SAE xmm xmm k xmm
//	VFNMSUB213SS.RD_SAE xmm xmm xmm
func VFNMSUB213SS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213SS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMSUB213SS_RD_SAE_Z: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213SS.RD_SAE.Z xmm xmm k xmm
func VFNMSUB213SS_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213SS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB213SS_RN_SAE: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMSUB213SS.RN_SAE xmm xmm k xmm
//	VFNMSUB213SS.RN_SAE xmm xmm xmm
func VFNMSUB213SS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213SS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMSUB213SS_RN_SAE_Z: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213SS.RN_SAE.Z xmm xmm k xmm
func VFNMSUB213SS_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213SS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB213SS_RU_SAE: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMSUB213SS.RU_SAE xmm xmm k xmm
//	VFNMSUB213SS.RU_SAE xmm xmm xmm
func VFNMSUB213SS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213SS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMSUB213SS_RU_SAE_Z: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213SS.RU_SAE.Z xmm xmm k xmm
func VFNMSUB213SS_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213SS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB213SS_RZ_SAE: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMSUB213SS.RZ_SAE xmm xmm k xmm
//	VFNMSUB213SS.RZ_SAE xmm xmm xmm
func VFNMSUB213SS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213SS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMSUB213SS_RZ_SAE_Z: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213SS.RZ_SAE.Z xmm xmm k xmm
func VFNMSUB213SS_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213SS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB213SS_Z: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMSUB213SS.Z m32 xmm k xmm
//	VFNMSUB213SS.Z xmm xmm k xmm
func VFNMSUB213SS_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB213SS.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFNMSUB231PD: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMSUB231PD m128 xmm xmm
//	VFNMSUB231PD m256 ymm ymm
//	VFNMSUB231PD xmm  xmm xmm
//	VFNMSUB231PD ymm  ymm ymm
//	VFNMSUB231PD m128 xmm k xmm
//	VFNMSUB231PD m256 ymm k ymm
//	VFNMSUB231PD xmm  xmm k xmm
//	VFNMSUB231PD ymm  ymm k ymm
//	VFNMSUB231PD m512 zmm k zmm
//	VFNMSUB231PD m512 zmm zmm
//	VFNMSUB231PD zmm  zmm k zmm
//	VFNMSUB231PD zmm  zmm zmm
func VFNMSUB231PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PD.Forms(), sffxs{}, ops)
}

// VFNMSUB231PD_BCST: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFNMSUB231PD.BCST m64 xmm k xmm
//	VFNMSUB231PD.BCST m64 xmm xmm
//	VFNMSUB231PD.BCST m64 ymm k ymm
//	VFNMSUB231PD.BCST m64 ymm ymm
//	VFNMSUB231PD.BCST m64 zmm k zmm
//	VFNMSUB231PD.BCST m64 zmm zmm
func VFNMSUB231PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PD.Forms(), sffxs{sffxBCST}, ops)
}

// VFNMSUB231PD_BCST_Z: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231PD.BCST.Z m64 xmm k xmm
//	VFNMSUB231PD.BCST.Z m64 ymm k ymm
//	VFNMSUB231PD.BCST.Z m64 zmm k zmm
func VFNMSUB231PD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFNMSUB231PD_RD_SAE: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMSUB231PD.RD_SAE zmm zmm k zmm
//	VFNMSUB231PD.RD_SAE zmm zmm zmm
func VFNMSUB231PD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMSUB231PD_RD_SAE_Z: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231PD.RD_SAE.Z zmm zmm k zmm
func VFNMSUB231PD_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB231PD_RN_SAE: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMSUB231PD.RN_SAE zmm zmm k zmm
//	VFNMSUB231PD.RN_SAE zmm zmm zmm
func VFNMSUB231PD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMSUB231PD_RN_SAE_Z: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231PD.RN_SAE.Z zmm zmm k zmm
func VFNMSUB231PD_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB231PD_RU_SAE: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMSUB231PD.RU_SAE zmm zmm k zmm
//	VFNMSUB231PD.RU_SAE zmm zmm zmm
func VFNMSUB231PD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMSUB231PD_RU_SAE_Z: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231PD.RU_SAE.Z zmm zmm k zmm
func VFNMSUB231PD_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB231PD_RZ_SAE: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMSUB231PD.RZ_SAE zmm zmm k zmm
//	VFNMSUB231PD.RZ_SAE zmm zmm zmm
func VFNMSUB231PD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMSUB231PD_RZ_SAE_Z: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231PD.RZ_SAE.Z zmm zmm k zmm
func VFNMSUB231PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB231PD_Z: Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231PD.Z m128 xmm k xmm
//	VFNMSUB231PD.Z m256 ymm k ymm
//	VFNMSUB231PD.Z xmm  xmm k xmm
//	VFNMSUB231PD.Z ymm  ymm k ymm
//	VFNMSUB231PD.Z m512 zmm k zmm
//	VFNMSUB231PD.Z zmm  zmm k zmm
func VFNMSUB231PD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFNMSUB231PS: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMSUB231PS m128 xmm xmm
//	VFNMSUB231PS m256 ymm ymm
//	VFNMSUB231PS xmm  xmm xmm
//	VFNMSUB231PS ymm  ymm ymm
//	VFNMSUB231PS m128 xmm k xmm
//	VFNMSUB231PS m256 ymm k ymm
//	VFNMSUB231PS xmm  xmm k xmm
//	VFNMSUB231PS ymm  ymm k ymm
//	VFNMSUB231PS m512 zmm k zmm
//	VFNMSUB231PS m512 zmm zmm
//	VFNMSUB231PS zmm  zmm k zmm
//	VFNMSUB231PS zmm  zmm zmm
func VFNMSUB231PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PS.Forms(), sffxs{}, ops)
}

// VFNMSUB231PS_BCST: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFNMSUB231PS.BCST m32 xmm k xmm
//	VFNMSUB231PS.BCST m32 xmm xmm
//	VFNMSUB231PS.BCST m32 ymm k ymm
//	VFNMSUB231PS.BCST m32 ymm ymm
//	VFNMSUB231PS.BCST m32 zmm k zmm
//	VFNMSUB231PS.BCST m32 zmm zmm
func VFNMSUB231PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PS.Forms(), sffxs{sffxBCST}, ops)
}

// VFNMSUB231PS_BCST_Z: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231PS.BCST.Z m32 xmm k xmm
//	VFNMSUB231PS.BCST.Z m32 ymm k ymm
//	VFNMSUB231PS.BCST.Z m32 zmm k zmm
func VFNMSUB231PS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VFNMSUB231PS_RD_SAE: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMSUB231PS.RD_SAE zmm zmm k zmm
//	VFNMSUB231PS.RD_SAE zmm zmm zmm
func VFNMSUB231PS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMSUB231PS_RD_SAE_Z: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231PS.RD_SAE.Z zmm zmm k zmm
func VFNMSUB231PS_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB231PS_RN_SAE: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMSUB231PS.RN_SAE zmm zmm k zmm
//	VFNMSUB231PS.RN_SAE zmm zmm zmm
func VFNMSUB231PS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMSUB231PS_RN_SAE_Z: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231PS.RN_SAE.Z zmm zmm k zmm
func VFNMSUB231PS_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB231PS_RU_SAE: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMSUB231PS.RU_SAE zmm zmm k zmm
//	VFNMSUB231PS.RU_SAE zmm zmm zmm
func VFNMSUB231PS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMSUB231PS_RU_SAE_Z: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231PS.RU_SAE.Z zmm zmm k zmm
func VFNMSUB231PS_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB231PS_RZ_SAE: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMSUB231PS.RZ_SAE zmm zmm k zmm
//	VFNMSUB231PS.RZ_SAE zmm zmm zmm
func VFNMSUB231PS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMSUB231PS_RZ_SAE_Z: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231PS.RZ_SAE.Z zmm zmm k zmm
func VFNMSUB231PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VFNMSUB231PS_Z: Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231PS.Z m128 xmm k xmm
//	VFNMSUB231PS.Z m256 ymm k ymm
//	VFNMSUB231PS.Z xmm  xmm k xmm
//	VFNMSUB231PS.Z ymm  ymm k ymm
//	VFNMSUB231PS.Z m512 zmm k zmm
//	VFNMSUB231PS.Z zmm  zmm k zmm
func VFNMSUB231PS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VFNMSUB231SD: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMSUB231SD m64 xmm xmm
//	VFNMSUB231SD xmm xmm xmm
//	VFNMSUB231SD m64 xmm k xmm
//	VFNMSUB231SD xmm xmm k xmm
func VFNMSUB231SD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231SD.Forms(), sffxs{}, ops)
}

// VFNMSUB231SD_RD_SAE: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMSUB231SD.RD_SAE xmm xmm k xmm
//	VFNMSUB231SD.RD_SAE xmm xmm xmm
func VFNMSUB231SD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231SD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMSUB231SD_RD_SAE_Z: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231SD.RD_SAE.Z xmm xmm k xmm
func VFNMSUB231SD_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231SD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB231SD_RN_SAE: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMSUB231SD.RN_SAE xmm xmm k xmm
//	VFNMSUB231SD.RN_SAE xmm xmm xmm
func VFNMSUB231SD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231SD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMSUB231SD_RN_SAE_Z: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231SD.RN_SAE.Z xmm xmm k xmm
func VFNMSUB231SD_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231SD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB231SD_RU_SAE: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMSUB231SD.RU_SAE xmm xmm k xmm
//	VFNMSUB231SD.RU_SAE xmm xmm xmm
func VFNMSUB231SD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231SD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMSUB231SD_RU_SAE_Z: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231SD.RU_SAE.Z xmm xmm k xmm
func VFNMSUB231SD_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231SD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB231SD_RZ_SAE: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMSUB231SD.RZ_SAE xmm xmm k xmm
//	VFNMSUB231SD.RZ_SAE xmm xmm xmm
func VFNMSUB231SD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231SD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMSUB231SD_RZ_SAE_Z: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231SD.RZ_SAE.Z xmm xmm k xmm
func VFNMSUB231SD_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231SD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB231SD_Z: Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231SD.Z m64 xmm k xmm
//	VFNMSUB231SD.Z xmm xmm k xmm
func VFNMSUB231SD_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231SD.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFNMSUB231SS: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFNMSUB231SS m32 xmm xmm
//	VFNMSUB231SS xmm xmm xmm
//	VFNMSUB231SS m32 xmm k xmm
//	VFNMSUB231SS xmm xmm k xmm
func VFNMSUB231SS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231SS.Forms(), sffxs{}, ops)
}

// VFNMSUB231SS_RD_SAE: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFNMSUB231SS.RD_SAE xmm xmm k xmm
//	VFNMSUB231SS.RD_SAE xmm xmm xmm
func VFNMSUB231SS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231SS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VFNMSUB231SS_RD_SAE_Z: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231SS.RD_SAE.Z xmm xmm k xmm
func VFNMSUB231SS_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231SS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB231SS_RN_SAE: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFNMSUB231SS.RN_SAE xmm xmm k xmm
//	VFNMSUB231SS.RN_SAE xmm xmm xmm
func VFNMSUB231SS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231SS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VFNMSUB231SS_RN_SAE_Z: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231SS.RN_SAE.Z xmm xmm k xmm
func VFNMSUB231SS_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231SS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB231SS_RU_SAE: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFNMSUB231SS.RU_SAE xmm xmm k xmm
//	VFNMSUB231SS.RU_SAE xmm xmm xmm
func VFNMSUB231SS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231SS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VFNMSUB231SS_RU_SAE_Z: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231SS.RU_SAE.Z xmm xmm k xmm
func VFNMSUB231SS_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231SS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB231SS_RZ_SAE: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFNMSUB231SS.RZ_SAE xmm xmm k xmm
//	VFNMSUB231SS.RZ_SAE xmm xmm xmm
func VFNMSUB231SS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231SS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VFNMSUB231SS_RZ_SAE_Z: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231SS.RZ_SAE.Z xmm xmm k xmm
func VFNMSUB231SS_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231SS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VFNMSUB231SS_Z: Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFNMSUB231SS.Z m32 xmm k xmm
//	VFNMSUB231SS.Z xmm xmm k xmm
func VFNMSUB231SS_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVFNMSUB231SS.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VFPCLASSPDX: Test Class of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFPCLASSPDX imm8 m128 k k
//	VFPCLASSPDX imm8 m128 k
//	VFPCLASSPDX imm8 xmm  k k
//	VFPCLASSPDX imm8 xmm  k
func VFPCLASSPDX(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFPCLASSPDX.Forms(), sffxs{}, ops)
}

// VFPCLASSPDX_BCST: Test Class of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFPCLASSPDX.BCST imm8 m64 k k
//	VFPCLASSPDX.BCST imm8 m64 k
func VFPCLASSPDX_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFPCLASSPDX.Forms(), sffxs{sffxBCST}, ops)
}

// VFPCLASSPDY: Test Class of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFPCLASSPDY imm8 m256 k k
//	VFPCLASSPDY imm8 m256 k
//	VFPCLASSPDY imm8 ymm  k k
//	VFPCLASSPDY imm8 ymm  k
func VFPCLASSPDY(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFPCLASSPDY.Forms(), sffxs{}, ops)
}

// VFPCLASSPDY_BCST: Test Class of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFPCLASSPDY.BCST imm8 m64 k k
//	VFPCLASSPDY.BCST imm8 m64 k
func VFPCLASSPDY_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFPCLASSPDY.Forms(), sffxs{sffxBCST}, ops)
}

// VFPCLASSPDZ: Test Class of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFPCLASSPDZ imm8 m512 k k
//	VFPCLASSPDZ imm8 m512 k
//	VFPCLASSPDZ imm8 zmm  k k
//	VFPCLASSPDZ imm8 zmm  k
func VFPCLASSPDZ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFPCLASSPDZ.Forms(), sffxs{}, ops)
}

// VFPCLASSPDZ_BCST: Test Class of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFPCLASSPDZ.BCST imm8 m64 k k
//	VFPCLASSPDZ.BCST imm8 m64 k
func VFPCLASSPDZ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFPCLASSPDZ.Forms(), sffxs{sffxBCST}, ops)
}

// VFPCLASSPSX: Test Class of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFPCLASSPSX imm8 m128 k k
//	VFPCLASSPSX imm8 m128 k
//	VFPCLASSPSX imm8 xmm  k k
//	VFPCLASSPSX imm8 xmm  k
func VFPCLASSPSX(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFPCLASSPSX.Forms(), sffxs{}, ops)
}

// VFPCLASSPSX_BCST: Test Class of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFPCLASSPSX.BCST imm8 m32 k k
//	VFPCLASSPSX.BCST imm8 m32 k
func VFPCLASSPSX_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFPCLASSPSX.Forms(), sffxs{sffxBCST}, ops)
}

// VFPCLASSPSY: Test Class of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFPCLASSPSY imm8 m256 k k
//	VFPCLASSPSY imm8 m256 k
//	VFPCLASSPSY imm8 ymm  k k
//	VFPCLASSPSY imm8 ymm  k
func VFPCLASSPSY(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFPCLASSPSY.Forms(), sffxs{}, ops)
}

// VFPCLASSPSY_BCST: Test Class of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFPCLASSPSY.BCST imm8 m32 k k
//	VFPCLASSPSY.BCST imm8 m32 k
func VFPCLASSPSY_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFPCLASSPSY.Forms(), sffxs{sffxBCST}, ops)
}

// VFPCLASSPSZ: Test Class of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFPCLASSPSZ imm8 m512 k k
//	VFPCLASSPSZ imm8 m512 k
//	VFPCLASSPSZ imm8 zmm  k k
//	VFPCLASSPSZ imm8 zmm  k
func VFPCLASSPSZ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFPCLASSPSZ.Forms(), sffxs{}, ops)
}

// VFPCLASSPSZ_BCST: Test Class of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFPCLASSPSZ.BCST imm8 m32 k k
//	VFPCLASSPSZ.BCST imm8 m32 k
func VFPCLASSPSZ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFPCLASSPSZ.Forms(), sffxs{sffxBCST}, ops)
}

// VFPCLASSSD: Test Class of Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	VFPCLASSSD imm8 m64 k k
//	VFPCLASSSD imm8 m64 k
//	VFPCLASSSD imm8 xmm k k
//	VFPCLASSSD imm8 xmm k
func VFPCLASSSD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFPCLASSSD.Forms(), sffxs{}, ops)
}

// VFPCLASSSS: Test Class of Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	VFPCLASSSS imm8 m32 k k
//	VFPCLASSSS imm8 m32 k
//	VFPCLASSSS imm8 xmm k k
//	VFPCLASSSS imm8 xmm k
func VFPCLASSSS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVFPCLASSSS.Forms(), sffxs{}, ops)
}

// VGATHERDPD: Gather Packed Double-Precision Floating-Point Values Using Signed Doubleword Indices.
//
// Forms:
//
//	VGATHERDPD xmm   vm32x xmm
//	VGATHERDPD ymm   vm32x ymm
//	VGATHERDPD vm32x k     xmm
//	VGATHERDPD vm32x k     ymm
//	VGATHERDPD vm32y k     zmm
func VGATHERDPD(vxy, kv, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVGATHERDPD.Forms(), sffxs{}, []operand.Op{vxy, kv, xyz})
}

// VGATHERDPS: Gather Packed Single-Precision Floating-Point Values Using Signed Doubleword Indices.
//
// Forms:
//
//	VGATHERDPS xmm   vm32x xmm
//	VGATHERDPS ymm   vm32y ymm
//	VGATHERDPS vm32x k     xmm
//	VGATHERDPS vm32y k     ymm
//	VGATHERDPS vm32z k     zmm
func VGATHERDPS(vxy, kv, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVGATHERDPS.Forms(), sffxs{}, []operand.Op{vxy, kv, xyz})
}

// VGATHERQPD: Gather Packed Double-Precision Floating-Point Values Using Signed Quadword Indices.
//
// Forms:
//
//	VGATHERQPD xmm   vm64x xmm
//	VGATHERQPD ymm   vm64y ymm
//	VGATHERQPD vm64x k     xmm
//	VGATHERQPD vm64y k     ymm
//	VGATHERQPD vm64z k     zmm
func VGATHERQPD(vxy, kv, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVGATHERQPD.Forms(), sffxs{}, []operand.Op{vxy, kv, xyz})
}

// VGATHERQPS: Gather Packed Single-Precision Floating-Point Values Using Signed Quadword Indices.
//
// Forms:
//
//	VGATHERQPS xmm   vm64x xmm
//	VGATHERQPS xmm   vm64y xmm
//	VGATHERQPS vm64x k     xmm
//	VGATHERQPS vm64y k     xmm
//	VGATHERQPS vm64z k     ymm
func VGATHERQPS(vx, kv, xy operand.Op) (*intrep.Instruction, error) {
	return build(opcVGATHERQPS.Forms(), sffxs{}, []operand.Op{vx, kv, xy})
}

// VGETEXPPD: Extract Exponents of Packed Double-Precision Floating-Point Values as Double-Precision Floating-Point Values.
//
// Forms:
//
//	VGETEXPPD m128 k xmm
//	VGETEXPPD m128 xmm
//	VGETEXPPD m256 k ymm
//	VGETEXPPD m256 ymm
//	VGETEXPPD xmm  k xmm
//	VGETEXPPD xmm  xmm
//	VGETEXPPD ymm  k ymm
//	VGETEXPPD ymm  ymm
//	VGETEXPPD m512 k zmm
//	VGETEXPPD m512 zmm
//	VGETEXPPD zmm  k zmm
//	VGETEXPPD zmm  zmm
func VGETEXPPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETEXPPD.Forms(), sffxs{}, ops)
}

// VGETEXPPD_BCST: Extract Exponents of Packed Double-Precision Floating-Point Values as Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VGETEXPPD.BCST m64 k xmm
//	VGETEXPPD.BCST m64 k ymm
//	VGETEXPPD.BCST m64 xmm
//	VGETEXPPD.BCST m64 ymm
//	VGETEXPPD.BCST m64 k zmm
//	VGETEXPPD.BCST m64 zmm
func VGETEXPPD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETEXPPD.Forms(), sffxs{sffxBCST}, ops)
}

// VGETEXPPD_BCST_Z: Extract Exponents of Packed Double-Precision Floating-Point Values as Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VGETEXPPD.BCST.Z m64 k xmm
//	VGETEXPPD.BCST.Z m64 k ymm
//	VGETEXPPD.BCST.Z m64 k zmm
func VGETEXPPD_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETEXPPD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VGETEXPPD_SAE: Extract Exponents of Packed Double-Precision Floating-Point Values as Double-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VGETEXPPD.SAE zmm k zmm
//	VGETEXPPD.SAE zmm zmm
func VGETEXPPD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETEXPPD.Forms(), sffxs{sffxSAE}, ops)
}

// VGETEXPPD_SAE_Z: Extract Exponents of Packed Double-Precision Floating-Point Values as Double-Precision Floating-Point Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VGETEXPPD.SAE.Z zmm k zmm
func VGETEXPPD_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETEXPPD.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{z, k, z1})
}

// VGETEXPPD_Z: Extract Exponents of Packed Double-Precision Floating-Point Values as Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VGETEXPPD.Z m128 k xmm
//	VGETEXPPD.Z m256 k ymm
//	VGETEXPPD.Z xmm  k xmm
//	VGETEXPPD.Z ymm  k ymm
//	VGETEXPPD.Z m512 k zmm
//	VGETEXPPD.Z zmm  k zmm
func VGETEXPPD_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETEXPPD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VGETEXPPS: Extract Exponents of Packed Single-Precision Floating-Point Values as Single-Precision Floating-Point Values.
//
// Forms:
//
//	VGETEXPPS m128 k xmm
//	VGETEXPPS m128 xmm
//	VGETEXPPS m256 k ymm
//	VGETEXPPS m256 ymm
//	VGETEXPPS xmm  k xmm
//	VGETEXPPS xmm  xmm
//	VGETEXPPS ymm  k ymm
//	VGETEXPPS ymm  ymm
//	VGETEXPPS m512 k zmm
//	VGETEXPPS m512 zmm
//	VGETEXPPS zmm  k zmm
//	VGETEXPPS zmm  zmm
func VGETEXPPS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETEXPPS.Forms(), sffxs{}, ops)
}

// VGETEXPPS_BCST: Extract Exponents of Packed Single-Precision Floating-Point Values as Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VGETEXPPS.BCST m32 k xmm
//	VGETEXPPS.BCST m32 k ymm
//	VGETEXPPS.BCST m32 xmm
//	VGETEXPPS.BCST m32 ymm
//	VGETEXPPS.BCST m32 k zmm
//	VGETEXPPS.BCST m32 zmm
func VGETEXPPS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETEXPPS.Forms(), sffxs{sffxBCST}, ops)
}

// VGETEXPPS_BCST_Z: Extract Exponents of Packed Single-Precision Floating-Point Values as Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VGETEXPPS.BCST.Z m32 k xmm
//	VGETEXPPS.BCST.Z m32 k ymm
//	VGETEXPPS.BCST.Z m32 k zmm
func VGETEXPPS_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETEXPPS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VGETEXPPS_SAE: Extract Exponents of Packed Single-Precision Floating-Point Values as Single-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VGETEXPPS.SAE zmm k zmm
//	VGETEXPPS.SAE zmm zmm
func VGETEXPPS_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETEXPPS.Forms(), sffxs{sffxSAE}, ops)
}

// VGETEXPPS_SAE_Z: Extract Exponents of Packed Single-Precision Floating-Point Values as Single-Precision Floating-Point Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VGETEXPPS.SAE.Z zmm k zmm
func VGETEXPPS_SAE_Z(z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETEXPPS.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{z, k, z1})
}

// VGETEXPPS_Z: Extract Exponents of Packed Single-Precision Floating-Point Values as Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VGETEXPPS.Z m128 k xmm
//	VGETEXPPS.Z m256 k ymm
//	VGETEXPPS.Z xmm  k xmm
//	VGETEXPPS.Z ymm  k ymm
//	VGETEXPPS.Z m512 k zmm
//	VGETEXPPS.Z zmm  k zmm
func VGETEXPPS_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETEXPPS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VGETEXPSD: Extract Exponent of Scalar Double-Precision Floating-Point Value as Double-Precision Floating-Point Value.
//
// Forms:
//
//	VGETEXPSD m64 xmm k xmm
//	VGETEXPSD m64 xmm xmm
//	VGETEXPSD xmm xmm k xmm
//	VGETEXPSD xmm xmm xmm
func VGETEXPSD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETEXPSD.Forms(), sffxs{}, ops)
}

// VGETEXPSD_SAE: Extract Exponent of Scalar Double-Precision Floating-Point Value as Double-Precision Floating-Point Value (Suppress All Exceptions).
//
// Forms:
//
//	VGETEXPSD.SAE xmm xmm k xmm
//	VGETEXPSD.SAE xmm xmm xmm
func VGETEXPSD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETEXPSD.Forms(), sffxs{sffxSAE}, ops)
}

// VGETEXPSD_SAE_Z: Extract Exponent of Scalar Double-Precision Floating-Point Value as Double-Precision Floating-Point Value (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VGETEXPSD.SAE.Z xmm xmm k xmm
func VGETEXPSD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETEXPSD.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VGETEXPSD_Z: Extract Exponent of Scalar Double-Precision Floating-Point Value as Double-Precision Floating-Point Value (Zeroing Masking).
//
// Forms:
//
//	VGETEXPSD.Z m64 xmm k xmm
//	VGETEXPSD.Z xmm xmm k xmm
func VGETEXPSD_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETEXPSD.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VGETEXPSS: Extract Exponent of Scalar Single-Precision Floating-Point Value as Single-Precision Floating-Point Value.
//
// Forms:
//
//	VGETEXPSS m32 xmm k xmm
//	VGETEXPSS m32 xmm xmm
//	VGETEXPSS xmm xmm k xmm
//	VGETEXPSS xmm xmm xmm
func VGETEXPSS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETEXPSS.Forms(), sffxs{}, ops)
}

// VGETEXPSS_SAE: Extract Exponent of Scalar Single-Precision Floating-Point Value as Single-Precision Floating-Point Value (Suppress All Exceptions).
//
// Forms:
//
//	VGETEXPSS.SAE xmm xmm k xmm
//	VGETEXPSS.SAE xmm xmm xmm
func VGETEXPSS_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETEXPSS.Forms(), sffxs{sffxSAE}, ops)
}

// VGETEXPSS_SAE_Z: Extract Exponent of Scalar Single-Precision Floating-Point Value as Single-Precision Floating-Point Value (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VGETEXPSS.SAE.Z xmm xmm k xmm
func VGETEXPSS_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETEXPSS.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VGETEXPSS_Z: Extract Exponent of Scalar Single-Precision Floating-Point Value as Single-Precision Floating-Point Value (Zeroing Masking).
//
// Forms:
//
//	VGETEXPSS.Z m32 xmm k xmm
//	VGETEXPSS.Z xmm xmm k xmm
func VGETEXPSS_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETEXPSS.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VGETMANTPD: Extract Normalized Mantissas from Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VGETMANTPD imm8 m128 k xmm
//	VGETMANTPD imm8 m128 xmm
//	VGETMANTPD imm8 m256 k ymm
//	VGETMANTPD imm8 m256 ymm
//	VGETMANTPD imm8 xmm  k xmm
//	VGETMANTPD imm8 xmm  xmm
//	VGETMANTPD imm8 ymm  k ymm
//	VGETMANTPD imm8 ymm  ymm
//	VGETMANTPD imm8 m512 k zmm
//	VGETMANTPD imm8 m512 zmm
//	VGETMANTPD imm8 zmm  k zmm
//	VGETMANTPD imm8 zmm  zmm
func VGETMANTPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETMANTPD.Forms(), sffxs{}, ops)
}

// VGETMANTPD_BCST: Extract Normalized Mantissas from Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VGETMANTPD.BCST imm8 m64 k xmm
//	VGETMANTPD.BCST imm8 m64 k ymm
//	VGETMANTPD.BCST imm8 m64 xmm
//	VGETMANTPD.BCST imm8 m64 ymm
//	VGETMANTPD.BCST imm8 m64 k zmm
//	VGETMANTPD.BCST imm8 m64 zmm
func VGETMANTPD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETMANTPD.Forms(), sffxs{sffxBCST}, ops)
}

// VGETMANTPD_BCST_Z: Extract Normalized Mantissas from Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VGETMANTPD.BCST.Z imm8 m64 k xmm
//	VGETMANTPD.BCST.Z imm8 m64 k ymm
//	VGETMANTPD.BCST.Z imm8 m64 k zmm
func VGETMANTPD_BCST_Z(i, m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETMANTPD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, k, xyz})
}

// VGETMANTPD_SAE: Extract Normalized Mantissas from Packed Double-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VGETMANTPD.SAE imm8 zmm k zmm
//	VGETMANTPD.SAE imm8 zmm zmm
func VGETMANTPD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETMANTPD.Forms(), sffxs{sffxSAE}, ops)
}

// VGETMANTPD_SAE_Z: Extract Normalized Mantissas from Packed Double-Precision Floating-Point Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VGETMANTPD.SAE.Z imm8 zmm k zmm
func VGETMANTPD_SAE_Z(i, z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETMANTPD.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{i, z, k, z1})
}

// VGETMANTPD_Z: Extract Normalized Mantissas from Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VGETMANTPD.Z imm8 m128 k xmm
//	VGETMANTPD.Z imm8 m256 k ymm
//	VGETMANTPD.Z imm8 xmm  k xmm
//	VGETMANTPD.Z imm8 ymm  k ymm
//	VGETMANTPD.Z imm8 m512 k zmm
//	VGETMANTPD.Z imm8 zmm  k zmm
func VGETMANTPD_Z(i, mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETMANTPD.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, k, xyz})
}

// VGETMANTPS: Extract Normalized Mantissas from Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VGETMANTPS imm8 m128 k xmm
//	VGETMANTPS imm8 m128 xmm
//	VGETMANTPS imm8 m256 k ymm
//	VGETMANTPS imm8 m256 ymm
//	VGETMANTPS imm8 xmm  k xmm
//	VGETMANTPS imm8 xmm  xmm
//	VGETMANTPS imm8 ymm  k ymm
//	VGETMANTPS imm8 ymm  ymm
//	VGETMANTPS imm8 m512 k zmm
//	VGETMANTPS imm8 m512 zmm
//	VGETMANTPS imm8 zmm  k zmm
//	VGETMANTPS imm8 zmm  zmm
func VGETMANTPS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETMANTPS.Forms(), sffxs{}, ops)
}

// VGETMANTPS_BCST: Extract Normalized Mantissas from Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VGETMANTPS.BCST imm8 m32 k xmm
//	VGETMANTPS.BCST imm8 m32 k ymm
//	VGETMANTPS.BCST imm8 m32 xmm
//	VGETMANTPS.BCST imm8 m32 ymm
//	VGETMANTPS.BCST imm8 m32 k zmm
//	VGETMANTPS.BCST imm8 m32 zmm
func VGETMANTPS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETMANTPS.Forms(), sffxs{sffxBCST}, ops)
}

// VGETMANTPS_BCST_Z: Extract Normalized Mantissas from Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VGETMANTPS.BCST.Z imm8 m32 k xmm
//	VGETMANTPS.BCST.Z imm8 m32 k ymm
//	VGETMANTPS.BCST.Z imm8 m32 k zmm
func VGETMANTPS_BCST_Z(i, m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETMANTPS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, k, xyz})
}

// VGETMANTPS_SAE: Extract Normalized Mantissas from Packed Single-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VGETMANTPS.SAE imm8 zmm k zmm
//	VGETMANTPS.SAE imm8 zmm zmm
func VGETMANTPS_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETMANTPS.Forms(), sffxs{sffxSAE}, ops)
}

// VGETMANTPS_SAE_Z: Extract Normalized Mantissas from Packed Single-Precision Floating-Point Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VGETMANTPS.SAE.Z imm8 zmm k zmm
func VGETMANTPS_SAE_Z(i, z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETMANTPS.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{i, z, k, z1})
}

// VGETMANTPS_Z: Extract Normalized Mantissas from Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VGETMANTPS.Z imm8 m128 k xmm
//	VGETMANTPS.Z imm8 m256 k ymm
//	VGETMANTPS.Z imm8 xmm  k xmm
//	VGETMANTPS.Z imm8 ymm  k ymm
//	VGETMANTPS.Z imm8 m512 k zmm
//	VGETMANTPS.Z imm8 zmm  k zmm
func VGETMANTPS_Z(i, mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETMANTPS.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, k, xyz})
}

// VGETMANTSD: Extract Normalized Mantissa from Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	VGETMANTSD imm8 m64 xmm k xmm
//	VGETMANTSD imm8 m64 xmm xmm
//	VGETMANTSD imm8 xmm xmm k xmm
//	VGETMANTSD imm8 xmm xmm xmm
func VGETMANTSD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETMANTSD.Forms(), sffxs{}, ops)
}

// VGETMANTSD_SAE: Extract Normalized Mantissa from Scalar Double-Precision Floating-Point Value (Suppress All Exceptions).
//
// Forms:
//
//	VGETMANTSD.SAE imm8 xmm xmm k xmm
//	VGETMANTSD.SAE imm8 xmm xmm xmm
func VGETMANTSD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETMANTSD.Forms(), sffxs{sffxSAE}, ops)
}

// VGETMANTSD_SAE_Z: Extract Normalized Mantissa from Scalar Double-Precision Floating-Point Value (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VGETMANTSD.SAE.Z imm8 xmm xmm k xmm
func VGETMANTSD_SAE_Z(i, x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETMANTSD.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{i, x, x1, k, x2})
}

// VGETMANTSD_Z: Extract Normalized Mantissa from Scalar Double-Precision Floating-Point Value (Zeroing Masking).
//
// Forms:
//
//	VGETMANTSD.Z imm8 m64 xmm k xmm
//	VGETMANTSD.Z imm8 xmm xmm k xmm
func VGETMANTSD_Z(i, mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETMANTSD.Forms(), sffxs{sffxZ}, []operand.Op{i, mx, x, k, x1})
}

// VGETMANTSS: Extract Normalized Mantissa from Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	VGETMANTSS imm8 m32 xmm k xmm
//	VGETMANTSS imm8 m32 xmm xmm
//	VGETMANTSS imm8 xmm xmm k xmm
//	VGETMANTSS imm8 xmm xmm xmm
func VGETMANTSS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETMANTSS.Forms(), sffxs{}, ops)
}

// VGETMANTSS_SAE: Extract Normalized Mantissa from Scalar Single-Precision Floating-Point Value (Suppress All Exceptions).
//
// Forms:
//
//	VGETMANTSS.SAE imm8 xmm xmm k xmm
//	VGETMANTSS.SAE imm8 xmm xmm xmm
func VGETMANTSS_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETMANTSS.Forms(), sffxs{sffxSAE}, ops)
}

// VGETMANTSS_SAE_Z: Extract Normalized Mantissa from Scalar Single-Precision Floating-Point Value (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VGETMANTSS.SAE.Z imm8 xmm xmm k xmm
func VGETMANTSS_SAE_Z(i, x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETMANTSS.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{i, x, x1, k, x2})
}

// VGETMANTSS_Z: Extract Normalized Mantissa from Scalar Single-Precision Floating-Point Value (Zeroing Masking).
//
// Forms:
//
//	VGETMANTSS.Z imm8 m32 xmm k xmm
//	VGETMANTSS.Z imm8 xmm xmm k xmm
func VGETMANTSS_Z(i, mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVGETMANTSS.Forms(), sffxs{sffxZ}, []operand.Op{i, mx, x, k, x1})
}

// VGF2P8AFFINEINVQB: Galois Field Affine Transformation Inverse.
//
// Forms:
//
//	VGF2P8AFFINEINVQB imm8 m128 xmm xmm
//	VGF2P8AFFINEINVQB imm8 m256 ymm ymm
//	VGF2P8AFFINEINVQB imm8 xmm  xmm xmm
//	VGF2P8AFFINEINVQB imm8 ymm  ymm ymm
//	VGF2P8AFFINEINVQB imm8 m512 zmm k zmm
//	VGF2P8AFFINEINVQB imm8 m512 zmm zmm
//	VGF2P8AFFINEINVQB imm8 zmm  zmm k zmm
//	VGF2P8AFFINEINVQB imm8 zmm  zmm zmm
//	VGF2P8AFFINEINVQB imm8 m128 xmm k xmm
//	VGF2P8AFFINEINVQB imm8 m256 ymm k ymm
//	VGF2P8AFFINEINVQB imm8 xmm  xmm k xmm
//	VGF2P8AFFINEINVQB imm8 ymm  ymm k ymm
func VGF2P8AFFINEINVQB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGF2P8AFFINEINVQB.Forms(), sffxs{}, ops)
}

// VGF2P8AFFINEINVQB_BCST: Galois Field Affine Transformation Inverse (Broadcast).
//
// Forms:
//
//	VGF2P8AFFINEINVQB.BCST imm8 m64 zmm k zmm
//	VGF2P8AFFINEINVQB.BCST imm8 m64 zmm zmm
//	VGF2P8AFFINEINVQB.BCST imm8 m64 xmm k xmm
//	VGF2P8AFFINEINVQB.BCST imm8 m64 xmm xmm
//	VGF2P8AFFINEINVQB.BCST imm8 m64 ymm k ymm
//	VGF2P8AFFINEINVQB.BCST imm8 m64 ymm ymm
func VGF2P8AFFINEINVQB_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGF2P8AFFINEINVQB.Forms(), sffxs{sffxBCST}, ops)
}

// VGF2P8AFFINEINVQB_BCST_Z: Galois Field Affine Transformation Inverse (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VGF2P8AFFINEINVQB.BCST.Z imm8 m64 zmm k zmm
//	VGF2P8AFFINEINVQB.BCST.Z imm8 m64 xmm k xmm
//	VGF2P8AFFINEINVQB.BCST.Z imm8 m64 ymm k ymm
func VGF2P8AFFINEINVQB_BCST_Z(i, m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVGF2P8AFFINEINVQB.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, xyz, k, xyz1})
}

// VGF2P8AFFINEINVQB_Z: Galois Field Affine Transformation Inverse (Zeroing Masking).
//
// Forms:
//
//	VGF2P8AFFINEINVQB.Z imm8 m512 zmm k zmm
//	VGF2P8AFFINEINVQB.Z imm8 zmm  zmm k zmm
//	VGF2P8AFFINEINVQB.Z imm8 m128 xmm k xmm
//	VGF2P8AFFINEINVQB.Z imm8 m256 ymm k ymm
//	VGF2P8AFFINEINVQB.Z imm8 xmm  xmm k xmm
//	VGF2P8AFFINEINVQB.Z imm8 ymm  ymm k ymm
func VGF2P8AFFINEINVQB_Z(i, mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVGF2P8AFFINEINVQB.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, xyz, k, xyz1})
}

// VGF2P8AFFINEQB: Galois Field Affine Transformation.
//
// Forms:
//
//	VGF2P8AFFINEQB imm8 m128 xmm xmm
//	VGF2P8AFFINEQB imm8 m256 ymm ymm
//	VGF2P8AFFINEQB imm8 xmm  xmm xmm
//	VGF2P8AFFINEQB imm8 ymm  ymm ymm
//	VGF2P8AFFINEQB imm8 m512 zmm k zmm
//	VGF2P8AFFINEQB imm8 m512 zmm zmm
//	VGF2P8AFFINEQB imm8 zmm  zmm k zmm
//	VGF2P8AFFINEQB imm8 zmm  zmm zmm
//	VGF2P8AFFINEQB imm8 m128 xmm k xmm
//	VGF2P8AFFINEQB imm8 m256 ymm k ymm
//	VGF2P8AFFINEQB imm8 xmm  xmm k xmm
//	VGF2P8AFFINEQB imm8 ymm  ymm k ymm
func VGF2P8AFFINEQB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGF2P8AFFINEQB.Forms(), sffxs{}, ops)
}

// VGF2P8AFFINEQB_BCST: Galois Field Affine Transformation (Broadcast).
//
// Forms:
//
//	VGF2P8AFFINEQB.BCST imm8 m64 zmm k zmm
//	VGF2P8AFFINEQB.BCST imm8 m64 zmm zmm
//	VGF2P8AFFINEQB.BCST imm8 m64 xmm k xmm
//	VGF2P8AFFINEQB.BCST imm8 m64 xmm xmm
//	VGF2P8AFFINEQB.BCST imm8 m64 ymm k ymm
//	VGF2P8AFFINEQB.BCST imm8 m64 ymm ymm
func VGF2P8AFFINEQB_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGF2P8AFFINEQB.Forms(), sffxs{sffxBCST}, ops)
}

// VGF2P8AFFINEQB_BCST_Z: Galois Field Affine Transformation (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VGF2P8AFFINEQB.BCST.Z imm8 m64 zmm k zmm
//	VGF2P8AFFINEQB.BCST.Z imm8 m64 xmm k xmm
//	VGF2P8AFFINEQB.BCST.Z imm8 m64 ymm k ymm
func VGF2P8AFFINEQB_BCST_Z(i, m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVGF2P8AFFINEQB.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, xyz, k, xyz1})
}

// VGF2P8AFFINEQB_Z: Galois Field Affine Transformation (Zeroing Masking).
//
// Forms:
//
//	VGF2P8AFFINEQB.Z imm8 m512 zmm k zmm
//	VGF2P8AFFINEQB.Z imm8 zmm  zmm k zmm
//	VGF2P8AFFINEQB.Z imm8 m128 xmm k xmm
//	VGF2P8AFFINEQB.Z imm8 m256 ymm k ymm
//	VGF2P8AFFINEQB.Z imm8 xmm  xmm k xmm
//	VGF2P8AFFINEQB.Z imm8 ymm  ymm k ymm
func VGF2P8AFFINEQB_Z(i, mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVGF2P8AFFINEQB.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, xyz, k, xyz1})
}

// VGF2P8MULB: Galois Field Multiply Bytes.
//
// Forms:
//
//	VGF2P8MULB m128 xmm xmm
//	VGF2P8MULB m256 ymm ymm
//	VGF2P8MULB xmm  xmm xmm
//	VGF2P8MULB ymm  ymm ymm
//	VGF2P8MULB m512 zmm k zmm
//	VGF2P8MULB m512 zmm zmm
//	VGF2P8MULB zmm  zmm k zmm
//	VGF2P8MULB zmm  zmm zmm
//	VGF2P8MULB m128 xmm k xmm
//	VGF2P8MULB m256 ymm k ymm
//	VGF2P8MULB xmm  xmm k xmm
//	VGF2P8MULB ymm  ymm k ymm
func VGF2P8MULB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVGF2P8MULB.Forms(), sffxs{}, ops)
}

// VGF2P8MULB_Z: Galois Field Multiply Bytes (Zeroing Masking).
//
// Forms:
//
//	VGF2P8MULB.Z m512 zmm k zmm
//	VGF2P8MULB.Z zmm  zmm k zmm
//	VGF2P8MULB.Z m128 xmm k xmm
//	VGF2P8MULB.Z m256 ymm k ymm
//	VGF2P8MULB.Z xmm  xmm k xmm
//	VGF2P8MULB.Z ymm  ymm k ymm
func VGF2P8MULB_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVGF2P8MULB.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VHADDPD: Packed Double-FP Horizontal Add.
//
// Forms:
//
//	VHADDPD m128 xmm xmm
//	VHADDPD m256 ymm ymm
//	VHADDPD xmm  xmm xmm
//	VHADDPD ymm  ymm ymm
func VHADDPD(mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVHADDPD.Forms(), sffxs{}, []operand.Op{mxy, xy, xy1})
}

// VHADDPS: Packed Single-FP Horizontal Add.
//
// Forms:
//
//	VHADDPS m128 xmm xmm
//	VHADDPS m256 ymm ymm
//	VHADDPS xmm  xmm xmm
//	VHADDPS ymm  ymm ymm
func VHADDPS(mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVHADDPS.Forms(), sffxs{}, []operand.Op{mxy, xy, xy1})
}

// VHSUBPD: Packed Double-FP Horizontal Subtract.
//
// Forms:
//
//	VHSUBPD m128 xmm xmm
//	VHSUBPD m256 ymm ymm
//	VHSUBPD xmm  xmm xmm
//	VHSUBPD ymm  ymm ymm
func VHSUBPD(mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVHSUBPD.Forms(), sffxs{}, []operand.Op{mxy, xy, xy1})
}

// VHSUBPS: Packed Single-FP Horizontal Subtract.
//
// Forms:
//
//	VHSUBPS m128 xmm xmm
//	VHSUBPS m256 ymm ymm
//	VHSUBPS xmm  xmm xmm
//	VHSUBPS ymm  ymm ymm
func VHSUBPS(mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVHSUBPS.Forms(), sffxs{}, []operand.Op{mxy, xy, xy1})
}

// VINSERTF128: Insert Packed Floating-Point Values.
//
// Forms:
//
//	VINSERTF128 imm8 m128 ymm ymm
//	VINSERTF128 imm8 xmm  ymm ymm
func VINSERTF128(i, mx, y, y1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVINSERTF128.Forms(), sffxs{}, []operand.Op{i, mx, y, y1})
}

// VINSERTF32X4: Insert 128 Bits of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VINSERTF32X4 imm8 m128 ymm k ymm
//	VINSERTF32X4 imm8 m128 ymm ymm
//	VINSERTF32X4 imm8 xmm  ymm k ymm
//	VINSERTF32X4 imm8 xmm  ymm ymm
//	VINSERTF32X4 imm8 m128 zmm k zmm
//	VINSERTF32X4 imm8 m128 zmm zmm
//	VINSERTF32X4 imm8 xmm  zmm k zmm
//	VINSERTF32X4 imm8 xmm  zmm zmm
func VINSERTF32X4(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVINSERTF32X4.Forms(), sffxs{}, ops)
}

// VINSERTF32X4_Z: Insert 128 Bits of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VINSERTF32X4.Z imm8 m128 ymm k ymm
//	VINSERTF32X4.Z imm8 xmm  ymm k ymm
//	VINSERTF32X4.Z imm8 m128 zmm k zmm
//	VINSERTF32X4.Z imm8 xmm  zmm k zmm
func VINSERTF32X4_Z(i, mx, yz, k, yz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVINSERTF32X4.Forms(), sffxs{sffxZ}, []operand.Op{i, mx, yz, k, yz1})
}

// VINSERTF32X8: Insert 256 Bits of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VINSERTF32X8 imm8 m256 zmm k zmm
//	VINSERTF32X8 imm8 m256 zmm zmm
//	VINSERTF32X8 imm8 ymm  zmm k zmm
//	VINSERTF32X8 imm8 ymm  zmm zmm
func VINSERTF32X8(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVINSERTF32X8.Forms(), sffxs{}, ops)
}

// VINSERTF32X8_Z: Insert 256 Bits of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VINSERTF32X8.Z imm8 m256 zmm k zmm
//	VINSERTF32X8.Z imm8 ymm  zmm k zmm
func VINSERTF32X8_Z(i, my, z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVINSERTF32X8.Forms(), sffxs{sffxZ}, []operand.Op{i, my, z, k, z1})
}

// VINSERTF64X2: Insert 128 Bits of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VINSERTF64X2 imm8 m128 ymm k ymm
//	VINSERTF64X2 imm8 m128 ymm ymm
//	VINSERTF64X2 imm8 xmm  ymm k ymm
//	VINSERTF64X2 imm8 xmm  ymm ymm
//	VINSERTF64X2 imm8 m128 zmm k zmm
//	VINSERTF64X2 imm8 m128 zmm zmm
//	VINSERTF64X2 imm8 xmm  zmm k zmm
//	VINSERTF64X2 imm8 xmm  zmm zmm
func VINSERTF64X2(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVINSERTF64X2.Forms(), sffxs{}, ops)
}

// VINSERTF64X2_Z: Insert 128 Bits of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VINSERTF64X2.Z imm8 m128 ymm k ymm
//	VINSERTF64X2.Z imm8 xmm  ymm k ymm
//	VINSERTF64X2.Z imm8 m128 zmm k zmm
//	VINSERTF64X2.Z imm8 xmm  zmm k zmm
func VINSERTF64X2_Z(i, mx, yz, k, yz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVINSERTF64X2.Forms(), sffxs{sffxZ}, []operand.Op{i, mx, yz, k, yz1})
}

// VINSERTF64X4: Insert 256 Bits of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VINSERTF64X4 imm8 m256 zmm k zmm
//	VINSERTF64X4 imm8 m256 zmm zmm
//	VINSERTF64X4 imm8 ymm  zmm k zmm
//	VINSERTF64X4 imm8 ymm  zmm zmm
func VINSERTF64X4(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVINSERTF64X4.Forms(), sffxs{}, ops)
}

// VINSERTF64X4_Z: Insert 256 Bits of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VINSERTF64X4.Z imm8 m256 zmm k zmm
//	VINSERTF64X4.Z imm8 ymm  zmm k zmm
func VINSERTF64X4_Z(i, my, z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVINSERTF64X4.Forms(), sffxs{sffxZ}, []operand.Op{i, my, z, k, z1})
}

// VINSERTI128: Insert Packed Integer Values.
//
// Forms:
//
//	VINSERTI128 imm8 m128 ymm ymm
//	VINSERTI128 imm8 xmm  ymm ymm
func VINSERTI128(i, mx, y, y1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVINSERTI128.Forms(), sffxs{}, []operand.Op{i, mx, y, y1})
}

// VINSERTI32X4: Insert 128 Bits of Packed Doubleword Integer Values.
//
// Forms:
//
//	VINSERTI32X4 imm8 m128 ymm k ymm
//	VINSERTI32X4 imm8 m128 ymm ymm
//	VINSERTI32X4 imm8 xmm  ymm k ymm
//	VINSERTI32X4 imm8 xmm  ymm ymm
//	VINSERTI32X4 imm8 m128 zmm k zmm
//	VINSERTI32X4 imm8 m128 zmm zmm
//	VINSERTI32X4 imm8 xmm  zmm k zmm
//	VINSERTI32X4 imm8 xmm  zmm zmm
func VINSERTI32X4(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVINSERTI32X4.Forms(), sffxs{}, ops)
}

// VINSERTI32X4_Z: Insert 128 Bits of Packed Doubleword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VINSERTI32X4.Z imm8 m128 ymm k ymm
//	VINSERTI32X4.Z imm8 xmm  ymm k ymm
//	VINSERTI32X4.Z imm8 m128 zmm k zmm
//	VINSERTI32X4.Z imm8 xmm  zmm k zmm
func VINSERTI32X4_Z(i, mx, yz, k, yz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVINSERTI32X4.Forms(), sffxs{sffxZ}, []operand.Op{i, mx, yz, k, yz1})
}

// VINSERTI32X8: Insert 256 Bits of Packed Doubleword Integer Values.
//
// Forms:
//
//	VINSERTI32X8 imm8 m256 zmm k zmm
//	VINSERTI32X8 imm8 m256 zmm zmm
//	VINSERTI32X8 imm8 ymm  zmm k zmm
//	VINSERTI32X8 imm8 ymm  zmm zmm
func VINSERTI32X8(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVINSERTI32X8.Forms(), sffxs{}, ops)
}

// VINSERTI32X8_Z: Insert 256 Bits of Packed Doubleword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VINSERTI32X8.Z imm8 m256 zmm k zmm
//	VINSERTI32X8.Z imm8 ymm  zmm k zmm
func VINSERTI32X8_Z(i, my, z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVINSERTI32X8.Forms(), sffxs{sffxZ}, []operand.Op{i, my, z, k, z1})
}

// VINSERTI64X2: Insert 128 Bits of Packed Quadword Integer Values.
//
// Forms:
//
//	VINSERTI64X2 imm8 m128 ymm k ymm
//	VINSERTI64X2 imm8 m128 ymm ymm
//	VINSERTI64X2 imm8 xmm  ymm k ymm
//	VINSERTI64X2 imm8 xmm  ymm ymm
//	VINSERTI64X2 imm8 m128 zmm k zmm
//	VINSERTI64X2 imm8 m128 zmm zmm
//	VINSERTI64X2 imm8 xmm  zmm k zmm
//	VINSERTI64X2 imm8 xmm  zmm zmm
func VINSERTI64X2(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVINSERTI64X2.Forms(), sffxs{}, ops)
}

// VINSERTI64X2_Z: Insert 128 Bits of Packed Quadword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VINSERTI64X2.Z imm8 m128 ymm k ymm
//	VINSERTI64X2.Z imm8 xmm  ymm k ymm
//	VINSERTI64X2.Z imm8 m128 zmm k zmm
//	VINSERTI64X2.Z imm8 xmm  zmm k zmm
func VINSERTI64X2_Z(i, mx, yz, k, yz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVINSERTI64X2.Forms(), sffxs{sffxZ}, []operand.Op{i, mx, yz, k, yz1})
}

// VINSERTI64X4: Insert 256 Bits of Packed Quadword Integer Values.
//
// Forms:
//
//	VINSERTI64X4 imm8 m256 zmm k zmm
//	VINSERTI64X4 imm8 m256 zmm zmm
//	VINSERTI64X4 imm8 ymm  zmm k zmm
//	VINSERTI64X4 imm8 ymm  zmm zmm
func VINSERTI64X4(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVINSERTI64X4.Forms(), sffxs{}, ops)
}

// VINSERTI64X4_Z: Insert 256 Bits of Packed Quadword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VINSERTI64X4.Z imm8 m256 zmm k zmm
//	VINSERTI64X4.Z imm8 ymm  zmm k zmm
func VINSERTI64X4_Z(i, my, z, k, z1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVINSERTI64X4.Forms(), sffxs{sffxZ}, []operand.Op{i, my, z, k, z1})
}

// VINSERTPS: Insert Packed Single Precision Floating-Point Value.
//
// Forms:
//
//	VINSERTPS imm8 m32 xmm xmm
//	VINSERTPS imm8 xmm xmm xmm
func VINSERTPS(i, mx, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVINSERTPS.Forms(), sffxs{}, []operand.Op{i, mx, x, x1})
}

// VLDDQU: Load Unaligned Integer 128 Bits.
//
// Forms:
//
//	VLDDQU m128 xmm
//	VLDDQU m256 ymm
func VLDDQU(m, xy operand.Op) (*intrep.Instruction, error) {
	return build(opcVLDDQU.Forms(), sffxs{}, []operand.Op{m, xy})
}

// VLDMXCSR: Load MXCSR Register.
//
// Forms:
//
//	VLDMXCSR m32
func VLDMXCSR(m operand.Op) (*intrep.Instruction, error) {
	return build(opcVLDMXCSR.Forms(), sffxs{}, []operand.Op{m})
}

// VMASKMOVDQU: Store Selected Bytes of Double Quadword.
//
// Forms:
//
//	VMASKMOVDQU xmm xmm
func VMASKMOVDQU(x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMASKMOVDQU.Forms(), sffxs{}, []operand.Op{x, x1})
}

// VMASKMOVPD: Conditional Move Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VMASKMOVPD m128 xmm xmm
//	VMASKMOVPD m256 ymm ymm
//	VMASKMOVPD xmm  xmm m128
//	VMASKMOVPD ymm  ymm m256
func VMASKMOVPD(mxy, xy, mxy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMASKMOVPD.Forms(), sffxs{}, []operand.Op{mxy, xy, mxy1})
}

// VMASKMOVPS: Conditional Move Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VMASKMOVPS m128 xmm xmm
//	VMASKMOVPS m256 ymm ymm
//	VMASKMOVPS xmm  xmm m128
//	VMASKMOVPS ymm  ymm m256
func VMASKMOVPS(mxy, xy, mxy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMASKMOVPS.Forms(), sffxs{}, []operand.Op{mxy, xy, mxy1})
}

// VMAXPD: Return Maximum Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VMAXPD m128 xmm xmm
//	VMAXPD m256 ymm ymm
//	VMAXPD xmm  xmm xmm
//	VMAXPD ymm  ymm ymm
//	VMAXPD m128 xmm k xmm
//	VMAXPD m256 ymm k ymm
//	VMAXPD xmm  xmm k xmm
//	VMAXPD ymm  ymm k ymm
//	VMAXPD m512 zmm k zmm
//	VMAXPD m512 zmm zmm
//	VMAXPD zmm  zmm k zmm
//	VMAXPD zmm  zmm zmm
func VMAXPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMAXPD.Forms(), sffxs{}, ops)
}

// VMAXPD_BCST: Return Maximum Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VMAXPD.BCST m64 xmm k xmm
//	VMAXPD.BCST m64 xmm xmm
//	VMAXPD.BCST m64 ymm k ymm
//	VMAXPD.BCST m64 ymm ymm
//	VMAXPD.BCST m64 zmm k zmm
//	VMAXPD.BCST m64 zmm zmm
func VMAXPD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMAXPD.Forms(), sffxs{sffxBCST}, ops)
}

// VMAXPD_BCST_Z: Return Maximum Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VMAXPD.BCST.Z m64 xmm k xmm
//	VMAXPD.BCST.Z m64 ymm k ymm
//	VMAXPD.BCST.Z m64 zmm k zmm
func VMAXPD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMAXPD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VMAXPD_SAE: Return Maximum Packed Double-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VMAXPD.SAE zmm zmm k zmm
//	VMAXPD.SAE zmm zmm zmm
func VMAXPD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMAXPD.Forms(), sffxs{sffxSAE}, ops)
}

// VMAXPD_SAE_Z: Return Maximum Packed Double-Precision Floating-Point Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VMAXPD.SAE.Z zmm zmm k zmm
func VMAXPD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMAXPD.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VMAXPD_Z: Return Maximum Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VMAXPD.Z m128 xmm k xmm
//	VMAXPD.Z m256 ymm k ymm
//	VMAXPD.Z xmm  xmm k xmm
//	VMAXPD.Z ymm  ymm k ymm
//	VMAXPD.Z m512 zmm k zmm
//	VMAXPD.Z zmm  zmm k zmm
func VMAXPD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMAXPD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VMAXPS: Return Maximum Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VMAXPS m128 xmm xmm
//	VMAXPS m256 ymm ymm
//	VMAXPS xmm  xmm xmm
//	VMAXPS ymm  ymm ymm
//	VMAXPS m128 xmm k xmm
//	VMAXPS m256 ymm k ymm
//	VMAXPS xmm  xmm k xmm
//	VMAXPS ymm  ymm k ymm
//	VMAXPS m512 zmm k zmm
//	VMAXPS m512 zmm zmm
//	VMAXPS zmm  zmm k zmm
//	VMAXPS zmm  zmm zmm
func VMAXPS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMAXPS.Forms(), sffxs{}, ops)
}

// VMAXPS_BCST: Return Maximum Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VMAXPS.BCST m32 xmm k xmm
//	VMAXPS.BCST m32 xmm xmm
//	VMAXPS.BCST m32 ymm k ymm
//	VMAXPS.BCST m32 ymm ymm
//	VMAXPS.BCST m32 zmm k zmm
//	VMAXPS.BCST m32 zmm zmm
func VMAXPS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMAXPS.Forms(), sffxs{sffxBCST}, ops)
}

// VMAXPS_BCST_Z: Return Maximum Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VMAXPS.BCST.Z m32 xmm k xmm
//	VMAXPS.BCST.Z m32 ymm k ymm
//	VMAXPS.BCST.Z m32 zmm k zmm
func VMAXPS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMAXPS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VMAXPS_SAE: Return Maximum Packed Single-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VMAXPS.SAE zmm zmm k zmm
//	VMAXPS.SAE zmm zmm zmm
func VMAXPS_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMAXPS.Forms(), sffxs{sffxSAE}, ops)
}

// VMAXPS_SAE_Z: Return Maximum Packed Single-Precision Floating-Point Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VMAXPS.SAE.Z zmm zmm k zmm
func VMAXPS_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMAXPS.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VMAXPS_Z: Return Maximum Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VMAXPS.Z m128 xmm k xmm
//	VMAXPS.Z m256 ymm k ymm
//	VMAXPS.Z xmm  xmm k xmm
//	VMAXPS.Z ymm  ymm k ymm
//	VMAXPS.Z m512 zmm k zmm
//	VMAXPS.Z zmm  zmm k zmm
func VMAXPS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMAXPS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VMAXSD: Return Maximum Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	VMAXSD m64 xmm xmm
//	VMAXSD xmm xmm xmm
//	VMAXSD m64 xmm k xmm
//	VMAXSD xmm xmm k xmm
func VMAXSD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMAXSD.Forms(), sffxs{}, ops)
}

// VMAXSD_SAE: Return Maximum Scalar Double-Precision Floating-Point Value (Suppress All Exceptions).
//
// Forms:
//
//	VMAXSD.SAE xmm xmm k xmm
//	VMAXSD.SAE xmm xmm xmm
func VMAXSD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMAXSD.Forms(), sffxs{sffxSAE}, ops)
}

// VMAXSD_SAE_Z: Return Maximum Scalar Double-Precision Floating-Point Value (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VMAXSD.SAE.Z xmm xmm k xmm
func VMAXSD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMAXSD.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VMAXSD_Z: Return Maximum Scalar Double-Precision Floating-Point Value (Zeroing Masking).
//
// Forms:
//
//	VMAXSD.Z m64 xmm k xmm
//	VMAXSD.Z xmm xmm k xmm
func VMAXSD_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMAXSD.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VMAXSS: Return Maximum Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	VMAXSS m32 xmm xmm
//	VMAXSS xmm xmm xmm
//	VMAXSS m32 xmm k xmm
//	VMAXSS xmm xmm k xmm
func VMAXSS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMAXSS.Forms(), sffxs{}, ops)
}

// VMAXSS_SAE: Return Maximum Scalar Single-Precision Floating-Point Value (Suppress All Exceptions).
//
// Forms:
//
//	VMAXSS.SAE xmm xmm k xmm
//	VMAXSS.SAE xmm xmm xmm
func VMAXSS_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMAXSS.Forms(), sffxs{sffxSAE}, ops)
}

// VMAXSS_SAE_Z: Return Maximum Scalar Single-Precision Floating-Point Value (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VMAXSS.SAE.Z xmm xmm k xmm
func VMAXSS_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMAXSS.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VMAXSS_Z: Return Maximum Scalar Single-Precision Floating-Point Value (Zeroing Masking).
//
// Forms:
//
//	VMAXSS.Z m32 xmm k xmm
//	VMAXSS.Z xmm xmm k xmm
func VMAXSS_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMAXSS.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VMINPD: Return Minimum Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VMINPD m128 xmm xmm
//	VMINPD m256 ymm ymm
//	VMINPD xmm  xmm xmm
//	VMINPD ymm  ymm ymm
//	VMINPD m128 xmm k xmm
//	VMINPD m256 ymm k ymm
//	VMINPD xmm  xmm k xmm
//	VMINPD ymm  ymm k ymm
//	VMINPD m512 zmm k zmm
//	VMINPD m512 zmm zmm
//	VMINPD zmm  zmm k zmm
//	VMINPD zmm  zmm zmm
func VMINPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMINPD.Forms(), sffxs{}, ops)
}

// VMINPD_BCST: Return Minimum Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VMINPD.BCST m64 xmm k xmm
//	VMINPD.BCST m64 xmm xmm
//	VMINPD.BCST m64 ymm k ymm
//	VMINPD.BCST m64 ymm ymm
//	VMINPD.BCST m64 zmm k zmm
//	VMINPD.BCST m64 zmm zmm
func VMINPD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMINPD.Forms(), sffxs{sffxBCST}, ops)
}

// VMINPD_BCST_Z: Return Minimum Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VMINPD.BCST.Z m64 xmm k xmm
//	VMINPD.BCST.Z m64 ymm k ymm
//	VMINPD.BCST.Z m64 zmm k zmm
func VMINPD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMINPD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VMINPD_SAE: Return Minimum Packed Double-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VMINPD.SAE zmm zmm k zmm
//	VMINPD.SAE zmm zmm zmm
func VMINPD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMINPD.Forms(), sffxs{sffxSAE}, ops)
}

// VMINPD_SAE_Z: Return Minimum Packed Double-Precision Floating-Point Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VMINPD.SAE.Z zmm zmm k zmm
func VMINPD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMINPD.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VMINPD_Z: Return Minimum Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VMINPD.Z m128 xmm k xmm
//	VMINPD.Z m256 ymm k ymm
//	VMINPD.Z xmm  xmm k xmm
//	VMINPD.Z ymm  ymm k ymm
//	VMINPD.Z m512 zmm k zmm
//	VMINPD.Z zmm  zmm k zmm
func VMINPD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMINPD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VMINPS: Return Minimum Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VMINPS m128 xmm xmm
//	VMINPS m256 ymm ymm
//	VMINPS xmm  xmm xmm
//	VMINPS ymm  ymm ymm
//	VMINPS m128 xmm k xmm
//	VMINPS m256 ymm k ymm
//	VMINPS xmm  xmm k xmm
//	VMINPS ymm  ymm k ymm
//	VMINPS m512 zmm k zmm
//	VMINPS m512 zmm zmm
//	VMINPS zmm  zmm k zmm
//	VMINPS zmm  zmm zmm
func VMINPS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMINPS.Forms(), sffxs{}, ops)
}

// VMINPS_BCST: Return Minimum Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VMINPS.BCST m32 xmm k xmm
//	VMINPS.BCST m32 xmm xmm
//	VMINPS.BCST m32 ymm k ymm
//	VMINPS.BCST m32 ymm ymm
//	VMINPS.BCST m32 zmm k zmm
//	VMINPS.BCST m32 zmm zmm
func VMINPS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMINPS.Forms(), sffxs{sffxBCST}, ops)
}

// VMINPS_BCST_Z: Return Minimum Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VMINPS.BCST.Z m32 xmm k xmm
//	VMINPS.BCST.Z m32 ymm k ymm
//	VMINPS.BCST.Z m32 zmm k zmm
func VMINPS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMINPS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VMINPS_SAE: Return Minimum Packed Single-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VMINPS.SAE zmm zmm k zmm
//	VMINPS.SAE zmm zmm zmm
func VMINPS_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMINPS.Forms(), sffxs{sffxSAE}, ops)
}

// VMINPS_SAE_Z: Return Minimum Packed Single-Precision Floating-Point Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VMINPS.SAE.Z zmm zmm k zmm
func VMINPS_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMINPS.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VMINPS_Z: Return Minimum Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VMINPS.Z m128 xmm k xmm
//	VMINPS.Z m256 ymm k ymm
//	VMINPS.Z xmm  xmm k xmm
//	VMINPS.Z ymm  ymm k ymm
//	VMINPS.Z m512 zmm k zmm
//	VMINPS.Z zmm  zmm k zmm
func VMINPS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMINPS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VMINSD: Return Minimum Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	VMINSD m64 xmm xmm
//	VMINSD xmm xmm xmm
//	VMINSD m64 xmm k xmm
//	VMINSD xmm xmm k xmm
func VMINSD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMINSD.Forms(), sffxs{}, ops)
}

// VMINSD_SAE: Return Minimum Scalar Double-Precision Floating-Point Value (Suppress All Exceptions).
//
// Forms:
//
//	VMINSD.SAE xmm xmm k xmm
//	VMINSD.SAE xmm xmm xmm
func VMINSD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMINSD.Forms(), sffxs{sffxSAE}, ops)
}

// VMINSD_SAE_Z: Return Minimum Scalar Double-Precision Floating-Point Value (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VMINSD.SAE.Z xmm xmm k xmm
func VMINSD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMINSD.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VMINSD_Z: Return Minimum Scalar Double-Precision Floating-Point Value (Zeroing Masking).
//
// Forms:
//
//	VMINSD.Z m64 xmm k xmm
//	VMINSD.Z xmm xmm k xmm
func VMINSD_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMINSD.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VMINSS: Return Minimum Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	VMINSS m32 xmm xmm
//	VMINSS xmm xmm xmm
//	VMINSS m32 xmm k xmm
//	VMINSS xmm xmm k xmm
func VMINSS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMINSS.Forms(), sffxs{}, ops)
}

// VMINSS_SAE: Return Minimum Scalar Single-Precision Floating-Point Value (Suppress All Exceptions).
//
// Forms:
//
//	VMINSS.SAE xmm xmm k xmm
//	VMINSS.SAE xmm xmm xmm
func VMINSS_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMINSS.Forms(), sffxs{sffxSAE}, ops)
}

// VMINSS_SAE_Z: Return Minimum Scalar Single-Precision Floating-Point Value (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VMINSS.SAE.Z xmm xmm k xmm
func VMINSS_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMINSS.Forms(), sffxs{sffxSAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VMINSS_Z: Return Minimum Scalar Single-Precision Floating-Point Value (Zeroing Masking).
//
// Forms:
//
//	VMINSS.Z m32 xmm k xmm
//	VMINSS.Z xmm xmm k xmm
func VMINSS_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMINSS.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VMOVAPD: Move Aligned Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VMOVAPD m128 xmm
//	VMOVAPD m256 ymm
//	VMOVAPD xmm  m128
//	VMOVAPD xmm  xmm
//	VMOVAPD ymm  m256
//	VMOVAPD ymm  ymm
//	VMOVAPD m128 k xmm
//	VMOVAPD m256 k ymm
//	VMOVAPD xmm  k m128
//	VMOVAPD xmm  k xmm
//	VMOVAPD ymm  k m256
//	VMOVAPD ymm  k ymm
//	VMOVAPD m512 k zmm
//	VMOVAPD m512 zmm
//	VMOVAPD zmm  k m512
//	VMOVAPD zmm  k zmm
//	VMOVAPD zmm  m512
//	VMOVAPD zmm  zmm
func VMOVAPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVAPD.Forms(), sffxs{}, ops)
}

// VMOVAPD_Z: Move Aligned Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VMOVAPD.Z m128 k xmm
//	VMOVAPD.Z m256 k ymm
//	VMOVAPD.Z xmm  k m128
//	VMOVAPD.Z xmm  k xmm
//	VMOVAPD.Z ymm  k m256
//	VMOVAPD.Z ymm  k ymm
//	VMOVAPD.Z m512 k zmm
//	VMOVAPD.Z zmm  k m512
//	VMOVAPD.Z zmm  k zmm
func VMOVAPD_Z(mxyz, k, mxyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVAPD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, mxyz1})
}

// VMOVAPS: Move Aligned Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VMOVAPS m128 xmm
//	VMOVAPS m256 ymm
//	VMOVAPS xmm  m128
//	VMOVAPS xmm  xmm
//	VMOVAPS ymm  m256
//	VMOVAPS ymm  ymm
//	VMOVAPS m128 k xmm
//	VMOVAPS m256 k ymm
//	VMOVAPS xmm  k m128
//	VMOVAPS xmm  k xmm
//	VMOVAPS ymm  k m256
//	VMOVAPS ymm  k ymm
//	VMOVAPS m512 k zmm
//	VMOVAPS m512 zmm
//	VMOVAPS zmm  k m512
//	VMOVAPS zmm  k zmm
//	VMOVAPS zmm  m512
//	VMOVAPS zmm  zmm
func VMOVAPS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVAPS.Forms(), sffxs{}, ops)
}

// VMOVAPS_Z: Move Aligned Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VMOVAPS.Z m128 k xmm
//	VMOVAPS.Z m256 k ymm
//	VMOVAPS.Z xmm  k m128
//	VMOVAPS.Z xmm  k xmm
//	VMOVAPS.Z ymm  k m256
//	VMOVAPS.Z ymm  k ymm
//	VMOVAPS.Z m512 k zmm
//	VMOVAPS.Z zmm  k m512
//	VMOVAPS.Z zmm  k zmm
func VMOVAPS_Z(mxyz, k, mxyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVAPS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, mxyz1})
}

// VMOVD: Move Doubleword.
//
// Forms:
//
//	VMOVD m32 xmm
//	VMOVD r32 xmm
//	VMOVD xmm m32
//	VMOVD xmm r32
func VMOVD(mrx, mrx1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVD.Forms(), sffxs{}, []operand.Op{mrx, mrx1})
}

// VMOVDDUP: Move One Double-FP and Duplicate.
//
// Forms:
//
//	VMOVDDUP m256 ymm
//	VMOVDDUP m64  xmm
//	VMOVDDUP xmm  xmm
//	VMOVDDUP ymm  ymm
//	VMOVDDUP m256 k ymm
//	VMOVDDUP m64  k xmm
//	VMOVDDUP xmm  k xmm
//	VMOVDDUP ymm  k ymm
//	VMOVDDUP m512 k zmm
//	VMOVDDUP m512 zmm
//	VMOVDDUP zmm  k zmm
//	VMOVDDUP zmm  zmm
func VMOVDDUP(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVDDUP.Forms(), sffxs{}, ops)
}

// VMOVDDUP_Z: Move One Double-FP and Duplicate (Zeroing Masking).
//
// Forms:
//
//	VMOVDDUP.Z m256 k ymm
//	VMOVDDUP.Z m64  k xmm
//	VMOVDDUP.Z xmm  k xmm
//	VMOVDDUP.Z ymm  k ymm
//	VMOVDDUP.Z m512 k zmm
//	VMOVDDUP.Z zmm  k zmm
func VMOVDDUP_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVDDUP.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VMOVDQA: Move Aligned Double Quadword.
//
// Forms:
//
//	VMOVDQA m128 xmm
//	VMOVDQA m256 ymm
//	VMOVDQA xmm  m128
//	VMOVDQA xmm  xmm
//	VMOVDQA ymm  m256
//	VMOVDQA ymm  ymm
func VMOVDQA(mxy, mxy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVDQA.Forms(), sffxs{}, []operand.Op{mxy, mxy1})
}

// VMOVDQA32: Move Aligned Doubleword Values.
//
// Forms:
//
//	VMOVDQA32 m128 k xmm
//	VMOVDQA32 m128 xmm
//	VMOVDQA32 m256 k ymm
//	VMOVDQA32 m256 ymm
//	VMOVDQA32 xmm  k m128
//	VMOVDQA32 xmm  k xmm
//	VMOVDQA32 xmm  m128
//	VMOVDQA32 xmm  xmm
//	VMOVDQA32 ymm  k m256
//	VMOVDQA32 ymm  k ymm
//	VMOVDQA32 ymm  m256
//	VMOVDQA32 ymm  ymm
//	VMOVDQA32 m512 k zmm
//	VMOVDQA32 m512 zmm
//	VMOVDQA32 zmm  k m512
//	VMOVDQA32 zmm  k zmm
//	VMOVDQA32 zmm  m512
//	VMOVDQA32 zmm  zmm
func VMOVDQA32(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVDQA32.Forms(), sffxs{}, ops)
}

// VMOVDQA32_Z: Move Aligned Doubleword Values (Zeroing Masking).
//
// Forms:
//
//	VMOVDQA32.Z m128 k xmm
//	VMOVDQA32.Z m256 k ymm
//	VMOVDQA32.Z xmm  k m128
//	VMOVDQA32.Z xmm  k xmm
//	VMOVDQA32.Z ymm  k m256
//	VMOVDQA32.Z ymm  k ymm
//	VMOVDQA32.Z m512 k zmm
//	VMOVDQA32.Z zmm  k m512
//	VMOVDQA32.Z zmm  k zmm
func VMOVDQA32_Z(mxyz, k, mxyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVDQA32.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, mxyz1})
}

// VMOVDQA64: Move Aligned Quadword Values.
//
// Forms:
//
//	VMOVDQA64 m128 k xmm
//	VMOVDQA64 m128 xmm
//	VMOVDQA64 m256 k ymm
//	VMOVDQA64 m256 ymm
//	VMOVDQA64 xmm  k m128
//	VMOVDQA64 xmm  k xmm
//	VMOVDQA64 xmm  m128
//	VMOVDQA64 xmm  xmm
//	VMOVDQA64 ymm  k m256
//	VMOVDQA64 ymm  k ymm
//	VMOVDQA64 ymm  m256
//	VMOVDQA64 ymm  ymm
//	VMOVDQA64 m512 k zmm
//	VMOVDQA64 m512 zmm
//	VMOVDQA64 zmm  k m512
//	VMOVDQA64 zmm  k zmm
//	VMOVDQA64 zmm  m512
//	VMOVDQA64 zmm  zmm
func VMOVDQA64(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVDQA64.Forms(), sffxs{}, ops)
}

// VMOVDQA64_Z: Move Aligned Quadword Values (Zeroing Masking).
//
// Forms:
//
//	VMOVDQA64.Z m128 k xmm
//	VMOVDQA64.Z m256 k ymm
//	VMOVDQA64.Z xmm  k m128
//	VMOVDQA64.Z xmm  k xmm
//	VMOVDQA64.Z ymm  k m256
//	VMOVDQA64.Z ymm  k ymm
//	VMOVDQA64.Z m512 k zmm
//	VMOVDQA64.Z zmm  k m512
//	VMOVDQA64.Z zmm  k zmm
func VMOVDQA64_Z(mxyz, k, mxyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVDQA64.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, mxyz1})
}

// VMOVDQU: Move Unaligned Double Quadword.
//
// Forms:
//
//	VMOVDQU m128 xmm
//	VMOVDQU m256 ymm
//	VMOVDQU xmm  m128
//	VMOVDQU xmm  xmm
//	VMOVDQU ymm  m256
//	VMOVDQU ymm  ymm
func VMOVDQU(mxy, mxy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVDQU.Forms(), sffxs{}, []operand.Op{mxy, mxy1})
}

// VMOVDQU16: Move Unaligned Word Values.
//
// Forms:
//
//	VMOVDQU16 m128 k xmm
//	VMOVDQU16 m128 xmm
//	VMOVDQU16 m256 k ymm
//	VMOVDQU16 m256 ymm
//	VMOVDQU16 xmm  k m128
//	VMOVDQU16 xmm  k xmm
//	VMOVDQU16 xmm  m128
//	VMOVDQU16 xmm  xmm
//	VMOVDQU16 ymm  k m256
//	VMOVDQU16 ymm  k ymm
//	VMOVDQU16 ymm  m256
//	VMOVDQU16 ymm  ymm
//	VMOVDQU16 m512 k zmm
//	VMOVDQU16 m512 zmm
//	VMOVDQU16 zmm  k m512
//	VMOVDQU16 zmm  k zmm
//	VMOVDQU16 zmm  m512
//	VMOVDQU16 zmm  zmm
func VMOVDQU16(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVDQU16.Forms(), sffxs{}, ops)
}

// VMOVDQU16_Z: Move Unaligned Word Values (Zeroing Masking).
//
// Forms:
//
//	VMOVDQU16.Z m128 k xmm
//	VMOVDQU16.Z m256 k ymm
//	VMOVDQU16.Z xmm  k m128
//	VMOVDQU16.Z xmm  k xmm
//	VMOVDQU16.Z ymm  k m256
//	VMOVDQU16.Z ymm  k ymm
//	VMOVDQU16.Z m512 k zmm
//	VMOVDQU16.Z zmm  k m512
//	VMOVDQU16.Z zmm  k zmm
func VMOVDQU16_Z(mxyz, k, mxyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVDQU16.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, mxyz1})
}

// VMOVDQU32: Move Unaligned Doubleword Values.
//
// Forms:
//
//	VMOVDQU32 m128 k xmm
//	VMOVDQU32 m128 xmm
//	VMOVDQU32 m256 k ymm
//	VMOVDQU32 m256 ymm
//	VMOVDQU32 xmm  k m128
//	VMOVDQU32 xmm  k xmm
//	VMOVDQU32 xmm  m128
//	VMOVDQU32 xmm  xmm
//	VMOVDQU32 ymm  k m256
//	VMOVDQU32 ymm  k ymm
//	VMOVDQU32 ymm  m256
//	VMOVDQU32 ymm  ymm
//	VMOVDQU32 m512 k zmm
//	VMOVDQU32 m512 zmm
//	VMOVDQU32 zmm  k m512
//	VMOVDQU32 zmm  k zmm
//	VMOVDQU32 zmm  m512
//	VMOVDQU32 zmm  zmm
func VMOVDQU32(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVDQU32.Forms(), sffxs{}, ops)
}

// VMOVDQU32_Z: Move Unaligned Doubleword Values (Zeroing Masking).
//
// Forms:
//
//	VMOVDQU32.Z m128 k xmm
//	VMOVDQU32.Z m256 k ymm
//	VMOVDQU32.Z xmm  k m128
//	VMOVDQU32.Z xmm  k xmm
//	VMOVDQU32.Z ymm  k m256
//	VMOVDQU32.Z ymm  k ymm
//	VMOVDQU32.Z m512 k zmm
//	VMOVDQU32.Z zmm  k m512
//	VMOVDQU32.Z zmm  k zmm
func VMOVDQU32_Z(mxyz, k, mxyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVDQU32.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, mxyz1})
}

// VMOVDQU64: Move Unaligned Quadword Values.
//
// Forms:
//
//	VMOVDQU64 m128 k xmm
//	VMOVDQU64 m128 xmm
//	VMOVDQU64 m256 k ymm
//	VMOVDQU64 m256 ymm
//	VMOVDQU64 xmm  k m128
//	VMOVDQU64 xmm  k xmm
//	VMOVDQU64 xmm  m128
//	VMOVDQU64 xmm  xmm
//	VMOVDQU64 ymm  k m256
//	VMOVDQU64 ymm  k ymm
//	VMOVDQU64 ymm  m256
//	VMOVDQU64 ymm  ymm
//	VMOVDQU64 m512 k zmm
//	VMOVDQU64 m512 zmm
//	VMOVDQU64 zmm  k m512
//	VMOVDQU64 zmm  k zmm
//	VMOVDQU64 zmm  m512
//	VMOVDQU64 zmm  zmm
func VMOVDQU64(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVDQU64.Forms(), sffxs{}, ops)
}

// VMOVDQU64_Z: Move Unaligned Quadword Values (Zeroing Masking).
//
// Forms:
//
//	VMOVDQU64.Z m128 k xmm
//	VMOVDQU64.Z m256 k ymm
//	VMOVDQU64.Z xmm  k m128
//	VMOVDQU64.Z xmm  k xmm
//	VMOVDQU64.Z ymm  k m256
//	VMOVDQU64.Z ymm  k ymm
//	VMOVDQU64.Z m512 k zmm
//	VMOVDQU64.Z zmm  k m512
//	VMOVDQU64.Z zmm  k zmm
func VMOVDQU64_Z(mxyz, k, mxyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVDQU64.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, mxyz1})
}

// VMOVDQU8: Move Unaligned Byte Values.
//
// Forms:
//
//	VMOVDQU8 m128 k xmm
//	VMOVDQU8 m128 xmm
//	VMOVDQU8 m256 k ymm
//	VMOVDQU8 m256 ymm
//	VMOVDQU8 xmm  k m128
//	VMOVDQU8 xmm  k xmm
//	VMOVDQU8 xmm  m128
//	VMOVDQU8 xmm  xmm
//	VMOVDQU8 ymm  k m256
//	VMOVDQU8 ymm  k ymm
//	VMOVDQU8 ymm  m256
//	VMOVDQU8 ymm  ymm
//	VMOVDQU8 m512 k zmm
//	VMOVDQU8 m512 zmm
//	VMOVDQU8 zmm  k m512
//	VMOVDQU8 zmm  k zmm
//	VMOVDQU8 zmm  m512
//	VMOVDQU8 zmm  zmm
func VMOVDQU8(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVDQU8.Forms(), sffxs{}, ops)
}

// VMOVDQU8_Z: Move Unaligned Byte Values (Zeroing Masking).
//
// Forms:
//
//	VMOVDQU8.Z m128 k xmm
//	VMOVDQU8.Z m256 k ymm
//	VMOVDQU8.Z xmm  k m128
//	VMOVDQU8.Z xmm  k xmm
//	VMOVDQU8.Z ymm  k m256
//	VMOVDQU8.Z ymm  k ymm
//	VMOVDQU8.Z m512 k zmm
//	VMOVDQU8.Z zmm  k m512
//	VMOVDQU8.Z zmm  k zmm
func VMOVDQU8_Z(mxyz, k, mxyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVDQU8.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, mxyz1})
}

// VMOVHLPS: Move Packed Single-Precision Floating-Point Values High to Low.
//
// Forms:
//
//	VMOVHLPS xmm xmm xmm
func VMOVHLPS(x, x1, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVHLPS.Forms(), sffxs{}, []operand.Op{x, x1, x2})
}

// VMOVHPD: Move High Packed Double-Precision Floating-Point Value.
//
// Forms:
//
//	VMOVHPD m64 xmm xmm
//	VMOVHPD xmm m64
func VMOVHPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVHPD.Forms(), sffxs{}, ops)
}

// VMOVHPS: Move High Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VMOVHPS m64 xmm xmm
//	VMOVHPS xmm m64
func VMOVHPS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVHPS.Forms(), sffxs{}, ops)
}

// VMOVLHPS: Move Packed Single-Precision Floating-Point Values Low to High.
//
// Forms:
//
//	VMOVLHPS xmm xmm xmm
func VMOVLHPS(x, x1, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVLHPS.Forms(), sffxs{}, []operand.Op{x, x1, x2})
}

// VMOVLPD: Move Low Packed Double-Precision Floating-Point Value.
//
// Forms:
//
//	VMOVLPD m64 xmm xmm
//	VMOVLPD xmm m64
func VMOVLPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVLPD.Forms(), sffxs{}, ops)
}

// VMOVLPS: Move Low Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VMOVLPS m64 xmm xmm
//	VMOVLPS xmm m64
func VMOVLPS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVLPS.Forms(), sffxs{}, ops)
}

// VMOVMSKPD: Extract Packed Double-Precision Floating-Point Sign Mask.
//
// Forms:
//
//	VMOVMSKPD xmm r32
//	VMOVMSKPD ymm r32
func VMOVMSKPD(xy, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVMSKPD.Forms(), sffxs{}, []operand.Op{xy, r})
}

// VMOVMSKPS: Extract Packed Single-Precision Floating-Point Sign Mask.
//
// Forms:
//
//	VMOVMSKPS xmm r32
//	VMOVMSKPS ymm r32
func VMOVMSKPS(xy, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVMSKPS.Forms(), sffxs{}, []operand.Op{xy, r})
}

// VMOVNTDQ: Store Double Quadword Using Non-Temporal Hint.
//
// Forms:
//
//	VMOVNTDQ xmm m128
//	VMOVNTDQ ymm m256
//	VMOVNTDQ zmm m512
func VMOVNTDQ(xyz, m operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVNTDQ.Forms(), sffxs{}, []operand.Op{xyz, m})
}

// VMOVNTDQA: Load Double Quadword Non-Temporal Aligned Hint.
//
// Forms:
//
//	VMOVNTDQA m256 ymm
//	VMOVNTDQA m128 xmm
//	VMOVNTDQA m512 zmm
func VMOVNTDQA(m, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVNTDQA.Forms(), sffxs{}, []operand.Op{m, xyz})
}

// VMOVNTPD: Store Packed Double-Precision Floating-Point Values Using Non-Temporal Hint.
//
// Forms:
//
//	VMOVNTPD xmm m128
//	VMOVNTPD ymm m256
//	VMOVNTPD zmm m512
func VMOVNTPD(xyz, m operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVNTPD.Forms(), sffxs{}, []operand.Op{xyz, m})
}

// VMOVNTPS: Store Packed Single-Precision Floating-Point Values Using Non-Temporal Hint.
//
// Forms:
//
//	VMOVNTPS xmm m128
//	VMOVNTPS ymm m256
//	VMOVNTPS zmm m512
func VMOVNTPS(xyz, m operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVNTPS.Forms(), sffxs{}, []operand.Op{xyz, m})
}

// VMOVQ: Move Quadword.
//
// Forms:
//
//	VMOVQ m64 xmm
//	VMOVQ r64 xmm
//	VMOVQ xmm m64
//	VMOVQ xmm r64
//	VMOVQ xmm xmm
func VMOVQ(mrx, mrx1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVQ.Forms(), sffxs{}, []operand.Op{mrx, mrx1})
}

// VMOVSD: Move Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	VMOVSD m64 xmm
//	VMOVSD xmm m64
//	VMOVSD xmm xmm xmm
//	VMOVSD m64 k   xmm
//	VMOVSD xmm k   m64
//	VMOVSD xmm xmm k xmm
func VMOVSD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVSD.Forms(), sffxs{}, ops)
}

// VMOVSD_Z: Move Scalar Double-Precision Floating-Point Value (Zeroing Masking).
//
// Forms:
//
//	VMOVSD.Z m64 k   xmm
//	VMOVSD.Z xmm xmm k xmm
func VMOVSD_Z(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVSD.Forms(), sffxs{sffxZ}, ops)
}

// VMOVSHDUP: Move Packed Single-FP High and Duplicate.
//
// Forms:
//
//	VMOVSHDUP m128 xmm
//	VMOVSHDUP m256 ymm
//	VMOVSHDUP xmm  xmm
//	VMOVSHDUP ymm  ymm
//	VMOVSHDUP m128 k xmm
//	VMOVSHDUP m256 k ymm
//	VMOVSHDUP xmm  k xmm
//	VMOVSHDUP ymm  k ymm
//	VMOVSHDUP m512 k zmm
//	VMOVSHDUP m512 zmm
//	VMOVSHDUP zmm  k zmm
//	VMOVSHDUP zmm  zmm
func VMOVSHDUP(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVSHDUP.Forms(), sffxs{}, ops)
}

// VMOVSHDUP_Z: Move Packed Single-FP High and Duplicate (Zeroing Masking).
//
// Forms:
//
//	VMOVSHDUP.Z m128 k xmm
//	VMOVSHDUP.Z m256 k ymm
//	VMOVSHDUP.Z xmm  k xmm
//	VMOVSHDUP.Z ymm  k ymm
//	VMOVSHDUP.Z m512 k zmm
//	VMOVSHDUP.Z zmm  k zmm
func VMOVSHDUP_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVSHDUP.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VMOVSLDUP: Move Packed Single-FP Low and Duplicate.
//
// Forms:
//
//	VMOVSLDUP m128 xmm
//	VMOVSLDUP m256 ymm
//	VMOVSLDUP xmm  xmm
//	VMOVSLDUP ymm  ymm
//	VMOVSLDUP m128 k xmm
//	VMOVSLDUP m256 k ymm
//	VMOVSLDUP xmm  k xmm
//	VMOVSLDUP ymm  k ymm
//	VMOVSLDUP m512 k zmm
//	VMOVSLDUP m512 zmm
//	VMOVSLDUP zmm  k zmm
//	VMOVSLDUP zmm  zmm
func VMOVSLDUP(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVSLDUP.Forms(), sffxs{}, ops)
}

// VMOVSLDUP_Z: Move Packed Single-FP Low and Duplicate (Zeroing Masking).
//
// Forms:
//
//	VMOVSLDUP.Z m128 k xmm
//	VMOVSLDUP.Z m256 k ymm
//	VMOVSLDUP.Z xmm  k xmm
//	VMOVSLDUP.Z ymm  k ymm
//	VMOVSLDUP.Z m512 k zmm
//	VMOVSLDUP.Z zmm  k zmm
func VMOVSLDUP_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVSLDUP.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VMOVSS: Move Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VMOVSS m32 xmm
//	VMOVSS xmm m32
//	VMOVSS xmm xmm xmm
//	VMOVSS m32 k   xmm
//	VMOVSS xmm k   m32
//	VMOVSS xmm xmm k xmm
func VMOVSS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVSS.Forms(), sffxs{}, ops)
}

// VMOVSS_Z: Move Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VMOVSS.Z m32 k   xmm
//	VMOVSS.Z xmm xmm k xmm
func VMOVSS_Z(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVSS.Forms(), sffxs{sffxZ}, ops)
}

// VMOVUPD: Move Unaligned Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VMOVUPD m128 xmm
//	VMOVUPD m256 ymm
//	VMOVUPD xmm  m128
//	VMOVUPD xmm  xmm
//	VMOVUPD ymm  m256
//	VMOVUPD ymm  ymm
//	VMOVUPD m128 k xmm
//	VMOVUPD m256 k ymm
//	VMOVUPD xmm  k m128
//	VMOVUPD xmm  k xmm
//	VMOVUPD ymm  k m256
//	VMOVUPD ymm  k ymm
//	VMOVUPD m512 k zmm
//	VMOVUPD m512 zmm
//	VMOVUPD zmm  k m512
//	VMOVUPD zmm  k zmm
//	VMOVUPD zmm  m512
//	VMOVUPD zmm  zmm
func VMOVUPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVUPD.Forms(), sffxs{}, ops)
}

// VMOVUPD_Z: Move Unaligned Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VMOVUPD.Z m128 k xmm
//	VMOVUPD.Z m256 k ymm
//	VMOVUPD.Z xmm  k m128
//	VMOVUPD.Z xmm  k xmm
//	VMOVUPD.Z ymm  k m256
//	VMOVUPD.Z ymm  k ymm
//	VMOVUPD.Z m512 k zmm
//	VMOVUPD.Z zmm  k m512
//	VMOVUPD.Z zmm  k zmm
func VMOVUPD_Z(mxyz, k, mxyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVUPD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, mxyz1})
}

// VMOVUPS: Move Unaligned Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VMOVUPS m128 xmm
//	VMOVUPS m256 ymm
//	VMOVUPS xmm  m128
//	VMOVUPS xmm  xmm
//	VMOVUPS ymm  m256
//	VMOVUPS ymm  ymm
//	VMOVUPS m128 k xmm
//	VMOVUPS m256 k ymm
//	VMOVUPS xmm  k m128
//	VMOVUPS xmm  k xmm
//	VMOVUPS ymm  k m256
//	VMOVUPS ymm  k ymm
//	VMOVUPS m512 k zmm
//	VMOVUPS m512 zmm
//	VMOVUPS zmm  k m512
//	VMOVUPS zmm  k zmm
//	VMOVUPS zmm  m512
//	VMOVUPS zmm  zmm
func VMOVUPS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVUPS.Forms(), sffxs{}, ops)
}

// VMOVUPS_Z: Move Unaligned Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VMOVUPS.Z m128 k xmm
//	VMOVUPS.Z m256 k ymm
//	VMOVUPS.Z xmm  k m128
//	VMOVUPS.Z xmm  k xmm
//	VMOVUPS.Z ymm  k m256
//	VMOVUPS.Z ymm  k ymm
//	VMOVUPS.Z m512 k zmm
//	VMOVUPS.Z zmm  k m512
//	VMOVUPS.Z zmm  k zmm
func VMOVUPS_Z(mxyz, k, mxyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMOVUPS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, mxyz1})
}

// VMPSADBW: Compute Multiple Packed Sums of Absolute Difference.
//
// Forms:
//
//	VMPSADBW imm8 m256 ymm ymm
//	VMPSADBW imm8 ymm  ymm ymm
//	VMPSADBW imm8 m128 xmm xmm
//	VMPSADBW imm8 xmm  xmm xmm
func VMPSADBW(i, mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMPSADBW.Forms(), sffxs{}, []operand.Op{i, mxy, xy, xy1})
}

// VMULPD: Multiply Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VMULPD m128 xmm xmm
//	VMULPD m256 ymm ymm
//	VMULPD xmm  xmm xmm
//	VMULPD ymm  ymm ymm
//	VMULPD m128 xmm k xmm
//	VMULPD m256 ymm k ymm
//	VMULPD xmm  xmm k xmm
//	VMULPD ymm  ymm k ymm
//	VMULPD m512 zmm k zmm
//	VMULPD m512 zmm zmm
//	VMULPD zmm  zmm k zmm
//	VMULPD zmm  zmm zmm
func VMULPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPD.Forms(), sffxs{}, ops)
}

// VMULPD_BCST: Multiply Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VMULPD.BCST m64 xmm k xmm
//	VMULPD.BCST m64 xmm xmm
//	VMULPD.BCST m64 ymm k ymm
//	VMULPD.BCST m64 ymm ymm
//	VMULPD.BCST m64 zmm k zmm
//	VMULPD.BCST m64 zmm zmm
func VMULPD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPD.Forms(), sffxs{sffxBCST}, ops)
}

// VMULPD_BCST_Z: Multiply Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VMULPD.BCST.Z m64 xmm k xmm
//	VMULPD.BCST.Z m64 ymm k ymm
//	VMULPD.BCST.Z m64 zmm k zmm
func VMULPD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VMULPD_RD_SAE: Multiply Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VMULPD.RD_SAE zmm zmm k zmm
//	VMULPD.RD_SAE zmm zmm zmm
func VMULPD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VMULPD_RD_SAE_Z: Multiply Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VMULPD.RD_SAE.Z zmm zmm k zmm
func VMULPD_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VMULPD_RN_SAE: Multiply Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VMULPD.RN_SAE zmm zmm k zmm
//	VMULPD.RN_SAE zmm zmm zmm
func VMULPD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VMULPD_RN_SAE_Z: Multiply Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VMULPD.RN_SAE.Z zmm zmm k zmm
func VMULPD_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VMULPD_RU_SAE: Multiply Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VMULPD.RU_SAE zmm zmm k zmm
//	VMULPD.RU_SAE zmm zmm zmm
func VMULPD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VMULPD_RU_SAE_Z: Multiply Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VMULPD.RU_SAE.Z zmm zmm k zmm
func VMULPD_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VMULPD_RZ_SAE: Multiply Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VMULPD.RZ_SAE zmm zmm k zmm
//	VMULPD.RZ_SAE zmm zmm zmm
func VMULPD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VMULPD_RZ_SAE_Z: Multiply Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VMULPD.RZ_SAE.Z zmm zmm k zmm
func VMULPD_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VMULPD_Z: Multiply Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VMULPD.Z m128 xmm k xmm
//	VMULPD.Z m256 ymm k ymm
//	VMULPD.Z xmm  xmm k xmm
//	VMULPD.Z ymm  ymm k ymm
//	VMULPD.Z m512 zmm k zmm
//	VMULPD.Z zmm  zmm k zmm
func VMULPD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VMULPS: Multiply Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VMULPS m128 xmm xmm
//	VMULPS m256 ymm ymm
//	VMULPS xmm  xmm xmm
//	VMULPS ymm  ymm ymm
//	VMULPS m128 xmm k xmm
//	VMULPS m256 ymm k ymm
//	VMULPS xmm  xmm k xmm
//	VMULPS ymm  ymm k ymm
//	VMULPS m512 zmm k zmm
//	VMULPS m512 zmm zmm
//	VMULPS zmm  zmm k zmm
//	VMULPS zmm  zmm zmm
func VMULPS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPS.Forms(), sffxs{}, ops)
}

// VMULPS_BCST: Multiply Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VMULPS.BCST m32 xmm k xmm
//	VMULPS.BCST m32 xmm xmm
//	VMULPS.BCST m32 ymm k ymm
//	VMULPS.BCST m32 ymm ymm
//	VMULPS.BCST m32 zmm k zmm
//	VMULPS.BCST m32 zmm zmm
func VMULPS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPS.Forms(), sffxs{sffxBCST}, ops)
}

// VMULPS_BCST_Z: Multiply Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VMULPS.BCST.Z m32 xmm k xmm
//	VMULPS.BCST.Z m32 ymm k ymm
//	VMULPS.BCST.Z m32 zmm k zmm
func VMULPS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VMULPS_RD_SAE: Multiply Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VMULPS.RD_SAE zmm zmm k zmm
//	VMULPS.RD_SAE zmm zmm zmm
func VMULPS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VMULPS_RD_SAE_Z: Multiply Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VMULPS.RD_SAE.Z zmm zmm k zmm
func VMULPS_RD_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VMULPS_RN_SAE: Multiply Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VMULPS.RN_SAE zmm zmm k zmm
//	VMULPS.RN_SAE zmm zmm zmm
func VMULPS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VMULPS_RN_SAE_Z: Multiply Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VMULPS.RN_SAE.Z zmm zmm k zmm
func VMULPS_RN_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VMULPS_RU_SAE: Multiply Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VMULPS.RU_SAE zmm zmm k zmm
//	VMULPS.RU_SAE zmm zmm zmm
func VMULPS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VMULPS_RU_SAE_Z: Multiply Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VMULPS.RU_SAE.Z zmm zmm k zmm
func VMULPS_RU_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VMULPS_RZ_SAE: Multiply Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VMULPS.RZ_SAE zmm zmm k zmm
//	VMULPS.RZ_SAE zmm zmm zmm
func VMULPS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VMULPS_RZ_SAE_Z: Multiply Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VMULPS.RZ_SAE.Z zmm zmm k zmm
func VMULPS_RZ_SAE_Z(z, z1, k, z2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{z, z1, k, z2})
}

// VMULPS_Z: Multiply Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VMULPS.Z m128 xmm k xmm
//	VMULPS.Z m256 ymm k ymm
//	VMULPS.Z xmm  xmm k xmm
//	VMULPS.Z ymm  ymm k ymm
//	VMULPS.Z m512 zmm k zmm
//	VMULPS.Z zmm  zmm k zmm
func VMULPS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULPS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VMULSD: Multiply Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VMULSD m64 xmm xmm
//	VMULSD xmm xmm xmm
//	VMULSD m64 xmm k xmm
//	VMULSD xmm xmm k xmm
func VMULSD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULSD.Forms(), sffxs{}, ops)
}

// VMULSD_RD_SAE: Multiply Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VMULSD.RD_SAE xmm xmm k xmm
//	VMULSD.RD_SAE xmm xmm xmm
func VMULSD_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULSD.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VMULSD_RD_SAE_Z: Multiply Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VMULSD.RD_SAE.Z xmm xmm k xmm
func VMULSD_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULSD.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VMULSD_RN_SAE: Multiply Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VMULSD.RN_SAE xmm xmm k xmm
//	VMULSD.RN_SAE xmm xmm xmm
func VMULSD_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULSD.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VMULSD_RN_SAE_Z: Multiply Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VMULSD.RN_SAE.Z xmm xmm k xmm
func VMULSD_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULSD.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VMULSD_RU_SAE: Multiply Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VMULSD.RU_SAE xmm xmm k xmm
//	VMULSD.RU_SAE xmm xmm xmm
func VMULSD_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULSD.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VMULSD_RU_SAE_Z: Multiply Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VMULSD.RU_SAE.Z xmm xmm k xmm
func VMULSD_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULSD.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VMULSD_RZ_SAE: Multiply Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VMULSD.RZ_SAE xmm xmm k xmm
//	VMULSD.RZ_SAE xmm xmm xmm
func VMULSD_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULSD.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VMULSD_RZ_SAE_Z: Multiply Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VMULSD.RZ_SAE.Z xmm xmm k xmm
func VMULSD_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULSD.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VMULSD_Z: Multiply Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VMULSD.Z m64 xmm k xmm
//	VMULSD.Z xmm xmm k xmm
func VMULSD_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULSD.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VMULSS: Multiply Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VMULSS m32 xmm xmm
//	VMULSS xmm xmm xmm
//	VMULSS m32 xmm k xmm
//	VMULSS xmm xmm k xmm
func VMULSS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULSS.Forms(), sffxs{}, ops)
}

// VMULSS_RD_SAE: Multiply Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VMULSS.RD_SAE xmm xmm k xmm
//	VMULSS.RD_SAE xmm xmm xmm
func VMULSS_RD_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULSS.Forms(), sffxs{sffxRD_SAE}, ops)
}

// VMULSS_RD_SAE_Z: Multiply Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VMULSS.RD_SAE.Z xmm xmm k xmm
func VMULSS_RD_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULSS.Forms(), sffxs{sffxRD_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VMULSS_RN_SAE: Multiply Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VMULSS.RN_SAE xmm xmm k xmm
//	VMULSS.RN_SAE xmm xmm xmm
func VMULSS_RN_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULSS.Forms(), sffxs{sffxRN_SAE}, ops)
}

// VMULSS_RN_SAE_Z: Multiply Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VMULSS.RN_SAE.Z xmm xmm k xmm
func VMULSS_RN_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULSS.Forms(), sffxs{sffxRN_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VMULSS_RU_SAE: Multiply Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VMULSS.RU_SAE xmm xmm k xmm
//	VMULSS.RU_SAE xmm xmm xmm
func VMULSS_RU_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULSS.Forms(), sffxs{sffxRU_SAE}, ops)
}

// VMULSS_RU_SAE_Z: Multiply Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VMULSS.RU_SAE.Z xmm xmm k xmm
func VMULSS_RU_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULSS.Forms(), sffxs{sffxRU_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VMULSS_RZ_SAE: Multiply Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VMULSS.RZ_SAE xmm xmm k xmm
//	VMULSS.RZ_SAE xmm xmm xmm
func VMULSS_RZ_SAE(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULSS.Forms(), sffxs{sffxRZ_SAE}, ops)
}

// VMULSS_RZ_SAE_Z: Multiply Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VMULSS.RZ_SAE.Z xmm xmm k xmm
func VMULSS_RZ_SAE_Z(x, x1, k, x2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULSS.Forms(), sffxs{sffxRZ_SAE, sffxZ}, []operand.Op{x, x1, k, x2})
}

// VMULSS_Z: Multiply Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VMULSS.Z m32 xmm k xmm
//	VMULSS.Z xmm xmm k xmm
func VMULSS_Z(mx, x, k, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVMULSS.Forms(), sffxs{sffxZ}, []operand.Op{mx, x, k, x1})
}

// VORPD: Bitwise Logical OR of Double-Precision Floating-Point Values.
//
// Forms:
//
//	VORPD m128 xmm xmm
//	VORPD m256 ymm ymm
//	VORPD xmm  xmm xmm
//	VORPD ymm  ymm ymm
//	VORPD m128 xmm k xmm
//	VORPD m256 ymm k ymm
//	VORPD xmm  xmm k xmm
//	VORPD ymm  ymm k ymm
//	VORPD m512 zmm k zmm
//	VORPD m512 zmm zmm
//	VORPD zmm  zmm k zmm
//	VORPD zmm  zmm zmm
func VORPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVORPD.Forms(), sffxs{}, ops)
}

// VORPD_BCST: Bitwise Logical OR of Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VORPD.BCST m64 xmm k xmm
//	VORPD.BCST m64 xmm xmm
//	VORPD.BCST m64 ymm k ymm
//	VORPD.BCST m64 ymm ymm
//	VORPD.BCST m64 zmm k zmm
//	VORPD.BCST m64 zmm zmm
func VORPD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVORPD.Forms(), sffxs{sffxBCST}, ops)
}

// VORPD_BCST_Z: Bitwise Logical OR of Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VORPD.BCST.Z m64 xmm k xmm
//	VORPD.BCST.Z m64 ymm k ymm
//	VORPD.BCST.Z m64 zmm k zmm
func VORPD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVORPD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VORPD_Z: Bitwise Logical OR of Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VORPD.Z m128 xmm k xmm
//	VORPD.Z m256 ymm k ymm
//	VORPD.Z xmm  xmm k xmm
//	VORPD.Z ymm  ymm k ymm
//	VORPD.Z m512 zmm k zmm
//	VORPD.Z zmm  zmm k zmm
func VORPD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVORPD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VORPS: Bitwise Logical OR of Single-Precision Floating-Point Values.
//
// Forms:
//
//	VORPS m128 xmm xmm
//	VORPS m256 ymm ymm
//	VORPS xmm  xmm xmm
//	VORPS ymm  ymm ymm
//	VORPS m128 xmm k xmm
//	VORPS m256 ymm k ymm
//	VORPS xmm  xmm k xmm
//	VORPS ymm  ymm k ymm
//	VORPS m512 zmm k zmm
//	VORPS m512 zmm zmm
//	VORPS zmm  zmm k zmm
//	VORPS zmm  zmm zmm
func VORPS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVORPS.Forms(), sffxs{}, ops)
}

// VORPS_BCST: Bitwise Logical OR of Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VORPS.BCST m32 xmm k xmm
//	VORPS.BCST m32 xmm xmm
//	VORPS.BCST m32 ymm k ymm
//	VORPS.BCST m32 ymm ymm
//	VORPS.BCST m32 zmm k zmm
//	VORPS.BCST m32 zmm zmm
func VORPS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVORPS.Forms(), sffxs{sffxBCST}, ops)
}

// VORPS_BCST_Z: Bitwise Logical OR of Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VORPS.BCST.Z m32 xmm k xmm
//	VORPS.BCST.Z m32 ymm k ymm
//	VORPS.BCST.Z m32 zmm k zmm
func VORPS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVORPS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VORPS_Z: Bitwise Logical OR of Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VORPS.Z m128 xmm k xmm
//	VORPS.Z m256 ymm k ymm
//	VORPS.Z xmm  xmm k xmm
//	VORPS.Z ymm  ymm k ymm
//	VORPS.Z m512 zmm k zmm
//	VORPS.Z zmm  zmm k zmm
func VORPS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVORPS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPABSB: Packed Absolute Value of Byte Integers.
//
// Forms:
//
//	VPABSB m256 ymm
//	VPABSB ymm  ymm
//	VPABSB m128 xmm
//	VPABSB xmm  xmm
//	VPABSB m128 k xmm
//	VPABSB m256 k ymm
//	VPABSB xmm  k xmm
//	VPABSB ymm  k ymm
//	VPABSB m512 k zmm
//	VPABSB m512 zmm
//	VPABSB zmm  k zmm
//	VPABSB zmm  zmm
func VPABSB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPABSB.Forms(), sffxs{}, ops)
}

// VPABSB_Z: Packed Absolute Value of Byte Integers (Zeroing Masking).
//
// Forms:
//
//	VPABSB.Z m128 k xmm
//	VPABSB.Z m256 k ymm
//	VPABSB.Z xmm  k xmm
//	VPABSB.Z ymm  k ymm
//	VPABSB.Z m512 k zmm
//	VPABSB.Z zmm  k zmm
func VPABSB_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPABSB.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VPABSD: Packed Absolute Value of Doubleword Integers.
//
// Forms:
//
//	VPABSD m256 ymm
//	VPABSD ymm  ymm
//	VPABSD m128 xmm
//	VPABSD xmm  xmm
//	VPABSD m128 k xmm
//	VPABSD m256 k ymm
//	VPABSD xmm  k xmm
//	VPABSD ymm  k ymm
//	VPABSD m512 k zmm
//	VPABSD m512 zmm
//	VPABSD zmm  k zmm
//	VPABSD zmm  zmm
func VPABSD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPABSD.Forms(), sffxs{}, ops)
}

// VPABSD_BCST: Packed Absolute Value of Doubleword Integers (Broadcast).
//
// Forms:
//
//	VPABSD.BCST m32 k xmm
//	VPABSD.BCST m32 k ymm
//	VPABSD.BCST m32 xmm
//	VPABSD.BCST m32 ymm
//	VPABSD.BCST m32 k zmm
//	VPABSD.BCST m32 zmm
func VPABSD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPABSD.Forms(), sffxs{sffxBCST}, ops)
}

// VPABSD_BCST_Z: Packed Absolute Value of Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPABSD.BCST.Z m32 k xmm
//	VPABSD.BCST.Z m32 k ymm
//	VPABSD.BCST.Z m32 k zmm
func VPABSD_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPABSD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VPABSD_Z: Packed Absolute Value of Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VPABSD.Z m128 k xmm
//	VPABSD.Z m256 k ymm
//	VPABSD.Z xmm  k xmm
//	VPABSD.Z ymm  k ymm
//	VPABSD.Z m512 k zmm
//	VPABSD.Z zmm  k zmm
func VPABSD_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPABSD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VPABSQ: Packed Absolute Value of Quadword Integers.
//
// Forms:
//
//	VPABSQ m128 k xmm
//	VPABSQ m128 xmm
//	VPABSQ m256 k ymm
//	VPABSQ m256 ymm
//	VPABSQ xmm  k xmm
//	VPABSQ xmm  xmm
//	VPABSQ ymm  k ymm
//	VPABSQ ymm  ymm
//	VPABSQ m512 k zmm
//	VPABSQ m512 zmm
//	VPABSQ zmm  k zmm
//	VPABSQ zmm  zmm
func VPABSQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPABSQ.Forms(), sffxs{}, ops)
}

// VPABSQ_BCST: Packed Absolute Value of Quadword Integers (Broadcast).
//
// Forms:
//
//	VPABSQ.BCST m64 k xmm
//	VPABSQ.BCST m64 k ymm
//	VPABSQ.BCST m64 xmm
//	VPABSQ.BCST m64 ymm
//	VPABSQ.BCST m64 k zmm
//	VPABSQ.BCST m64 zmm
func VPABSQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPABSQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPABSQ_BCST_Z: Packed Absolute Value of Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPABSQ.BCST.Z m64 k xmm
//	VPABSQ.BCST.Z m64 k ymm
//	VPABSQ.BCST.Z m64 k zmm
func VPABSQ_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPABSQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VPABSQ_Z: Packed Absolute Value of Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VPABSQ.Z m128 k xmm
//	VPABSQ.Z m256 k ymm
//	VPABSQ.Z xmm  k xmm
//	VPABSQ.Z ymm  k ymm
//	VPABSQ.Z m512 k zmm
//	VPABSQ.Z zmm  k zmm
func VPABSQ_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPABSQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VPABSW: Packed Absolute Value of Word Integers.
//
// Forms:
//
//	VPABSW m256 ymm
//	VPABSW ymm  ymm
//	VPABSW m128 xmm
//	VPABSW xmm  xmm
//	VPABSW m128 k xmm
//	VPABSW m256 k ymm
//	VPABSW xmm  k xmm
//	VPABSW ymm  k ymm
//	VPABSW m512 k zmm
//	VPABSW m512 zmm
//	VPABSW zmm  k zmm
//	VPABSW zmm  zmm
func VPABSW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPABSW.Forms(), sffxs{}, ops)
}

// VPABSW_Z: Packed Absolute Value of Word Integers (Zeroing Masking).
//
// Forms:
//
//	VPABSW.Z m128 k xmm
//	VPABSW.Z m256 k ymm
//	VPABSW.Z xmm  k xmm
//	VPABSW.Z ymm  k ymm
//	VPABSW.Z m512 k zmm
//	VPABSW.Z zmm  k zmm
func VPABSW_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPABSW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VPACKSSDW: Pack Doublewords into Words with Signed Saturation.
//
// Forms:
//
//	VPACKSSDW m256 ymm ymm
//	VPACKSSDW ymm  ymm ymm
//	VPACKSSDW m128 xmm xmm
//	VPACKSSDW xmm  xmm xmm
//	VPACKSSDW m128 xmm k xmm
//	VPACKSSDW m256 ymm k ymm
//	VPACKSSDW xmm  xmm k xmm
//	VPACKSSDW ymm  ymm k ymm
//	VPACKSSDW m512 zmm k zmm
//	VPACKSSDW m512 zmm zmm
//	VPACKSSDW zmm  zmm k zmm
//	VPACKSSDW zmm  zmm zmm
func VPACKSSDW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPACKSSDW.Forms(), sffxs{}, ops)
}

// VPACKSSDW_BCST: Pack Doublewords into Words with Signed Saturation (Broadcast).
//
// Forms:
//
//	VPACKSSDW.BCST m32 xmm k xmm
//	VPACKSSDW.BCST m32 xmm xmm
//	VPACKSSDW.BCST m32 ymm k ymm
//	VPACKSSDW.BCST m32 ymm ymm
//	VPACKSSDW.BCST m32 zmm k zmm
//	VPACKSSDW.BCST m32 zmm zmm
func VPACKSSDW_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPACKSSDW.Forms(), sffxs{sffxBCST}, ops)
}

// VPACKSSDW_BCST_Z: Pack Doublewords into Words with Signed Saturation (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPACKSSDW.BCST.Z m32 xmm k xmm
//	VPACKSSDW.BCST.Z m32 ymm k ymm
//	VPACKSSDW.BCST.Z m32 zmm k zmm
func VPACKSSDW_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPACKSSDW.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPACKSSDW_Z: Pack Doublewords into Words with Signed Saturation (Zeroing Masking).
//
// Forms:
//
//	VPACKSSDW.Z m128 xmm k xmm
//	VPACKSSDW.Z m256 ymm k ymm
//	VPACKSSDW.Z xmm  xmm k xmm
//	VPACKSSDW.Z ymm  ymm k ymm
//	VPACKSSDW.Z m512 zmm k zmm
//	VPACKSSDW.Z zmm  zmm k zmm
func VPACKSSDW_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPACKSSDW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPACKSSWB: Pack Words into Bytes with Signed Saturation.
//
// Forms:
//
//	VPACKSSWB m256 ymm ymm
//	VPACKSSWB ymm  ymm ymm
//	VPACKSSWB m128 xmm xmm
//	VPACKSSWB xmm  xmm xmm
//	VPACKSSWB m128 xmm k xmm
//	VPACKSSWB m256 ymm k ymm
//	VPACKSSWB xmm  xmm k xmm
//	VPACKSSWB ymm  ymm k ymm
//	VPACKSSWB m512 zmm k zmm
//	VPACKSSWB m512 zmm zmm
//	VPACKSSWB zmm  zmm k zmm
//	VPACKSSWB zmm  zmm zmm
func VPACKSSWB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPACKSSWB.Forms(), sffxs{}, ops)
}

// VPACKSSWB_Z: Pack Words into Bytes with Signed Saturation (Zeroing Masking).
//
// Forms:
//
//	VPACKSSWB.Z m128 xmm k xmm
//	VPACKSSWB.Z m256 ymm k ymm
//	VPACKSSWB.Z xmm  xmm k xmm
//	VPACKSSWB.Z ymm  ymm k ymm
//	VPACKSSWB.Z m512 zmm k zmm
//	VPACKSSWB.Z zmm  zmm k zmm
func VPACKSSWB_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPACKSSWB.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPACKUSDW: Pack Doublewords into Words with Unsigned Saturation.
//
// Forms:
//
//	VPACKUSDW m256 ymm ymm
//	VPACKUSDW ymm  ymm ymm
//	VPACKUSDW m128 xmm xmm
//	VPACKUSDW xmm  xmm xmm
//	VPACKUSDW m128 xmm k xmm
//	VPACKUSDW m256 ymm k ymm
//	VPACKUSDW xmm  xmm k xmm
//	VPACKUSDW ymm  ymm k ymm
//	VPACKUSDW m512 zmm k zmm
//	VPACKUSDW m512 zmm zmm
//	VPACKUSDW zmm  zmm k zmm
//	VPACKUSDW zmm  zmm zmm
func VPACKUSDW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPACKUSDW.Forms(), sffxs{}, ops)
}

// VPACKUSDW_BCST: Pack Doublewords into Words with Unsigned Saturation (Broadcast).
//
// Forms:
//
//	VPACKUSDW.BCST m32 xmm k xmm
//	VPACKUSDW.BCST m32 xmm xmm
//	VPACKUSDW.BCST m32 ymm k ymm
//	VPACKUSDW.BCST m32 ymm ymm
//	VPACKUSDW.BCST m32 zmm k zmm
//	VPACKUSDW.BCST m32 zmm zmm
func VPACKUSDW_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPACKUSDW.Forms(), sffxs{sffxBCST}, ops)
}

// VPACKUSDW_BCST_Z: Pack Doublewords into Words with Unsigned Saturation (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPACKUSDW.BCST.Z m32 xmm k xmm
//	VPACKUSDW.BCST.Z m32 ymm k ymm
//	VPACKUSDW.BCST.Z m32 zmm k zmm
func VPACKUSDW_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPACKUSDW.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPACKUSDW_Z: Pack Doublewords into Words with Unsigned Saturation (Zeroing Masking).
//
// Forms:
//
//	VPACKUSDW.Z m128 xmm k xmm
//	VPACKUSDW.Z m256 ymm k ymm
//	VPACKUSDW.Z xmm  xmm k xmm
//	VPACKUSDW.Z ymm  ymm k ymm
//	VPACKUSDW.Z m512 zmm k zmm
//	VPACKUSDW.Z zmm  zmm k zmm
func VPACKUSDW_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPACKUSDW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPACKUSWB: Pack Words into Bytes with Unsigned Saturation.
//
// Forms:
//
//	VPACKUSWB m256 ymm ymm
//	VPACKUSWB ymm  ymm ymm
//	VPACKUSWB m128 xmm xmm
//	VPACKUSWB xmm  xmm xmm
//	VPACKUSWB m128 xmm k xmm
//	VPACKUSWB m256 ymm k ymm
//	VPACKUSWB xmm  xmm k xmm
//	VPACKUSWB ymm  ymm k ymm
//	VPACKUSWB m512 zmm k zmm
//	VPACKUSWB m512 zmm zmm
//	VPACKUSWB zmm  zmm k zmm
//	VPACKUSWB zmm  zmm zmm
func VPACKUSWB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPACKUSWB.Forms(), sffxs{}, ops)
}

// VPACKUSWB_Z: Pack Words into Bytes with Unsigned Saturation (Zeroing Masking).
//
// Forms:
//
//	VPACKUSWB.Z m128 xmm k xmm
//	VPACKUSWB.Z m256 ymm k ymm
//	VPACKUSWB.Z xmm  xmm k xmm
//	VPACKUSWB.Z ymm  ymm k ymm
//	VPACKUSWB.Z m512 zmm k zmm
//	VPACKUSWB.Z zmm  zmm k zmm
func VPACKUSWB_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPACKUSWB.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPADDB: Add Packed Byte Integers.
//
// Forms:
//
//	VPADDB m256 ymm ymm
//	VPADDB ymm  ymm ymm
//	VPADDB m128 xmm xmm
//	VPADDB xmm  xmm xmm
//	VPADDB m128 xmm k xmm
//	VPADDB m256 ymm k ymm
//	VPADDB xmm  xmm k xmm
//	VPADDB ymm  ymm k ymm
//	VPADDB m512 zmm k zmm
//	VPADDB m512 zmm zmm
//	VPADDB zmm  zmm k zmm
//	VPADDB zmm  zmm zmm
func VPADDB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPADDB.Forms(), sffxs{}, ops)
}

// VPADDB_Z: Add Packed Byte Integers (Zeroing Masking).
//
// Forms:
//
//	VPADDB.Z m128 xmm k xmm
//	VPADDB.Z m256 ymm k ymm
//	VPADDB.Z xmm  xmm k xmm
//	VPADDB.Z ymm  ymm k ymm
//	VPADDB.Z m512 zmm k zmm
//	VPADDB.Z zmm  zmm k zmm
func VPADDB_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPADDB.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPADDD: Add Packed Doubleword Integers.
//
// Forms:
//
//	VPADDD m256 ymm ymm
//	VPADDD ymm  ymm ymm
//	VPADDD m128 xmm xmm
//	VPADDD xmm  xmm xmm
//	VPADDD m128 xmm k xmm
//	VPADDD m256 ymm k ymm
//	VPADDD xmm  xmm k xmm
//	VPADDD ymm  ymm k ymm
//	VPADDD m512 zmm k zmm
//	VPADDD m512 zmm zmm
//	VPADDD zmm  zmm k zmm
//	VPADDD zmm  zmm zmm
func VPADDD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPADDD.Forms(), sffxs{}, ops)
}

// VPADDD_BCST: Add Packed Doubleword Integers (Broadcast).
//
// Forms:
//
//	VPADDD.BCST m32 xmm k xmm
//	VPADDD.BCST m32 xmm xmm
//	VPADDD.BCST m32 ymm k ymm
//	VPADDD.BCST m32 ymm ymm
//	VPADDD.BCST m32 zmm k zmm
//	VPADDD.BCST m32 zmm zmm
func VPADDD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPADDD.Forms(), sffxs{sffxBCST}, ops)
}

// VPADDD_BCST_Z: Add Packed Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPADDD.BCST.Z m32 xmm k xmm
//	VPADDD.BCST.Z m32 ymm k ymm
//	VPADDD.BCST.Z m32 zmm k zmm
func VPADDD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPADDD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPADDD_Z: Add Packed Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VPADDD.Z m128 xmm k xmm
//	VPADDD.Z m256 ymm k ymm
//	VPADDD.Z xmm  xmm k xmm
//	VPADDD.Z ymm  ymm k ymm
//	VPADDD.Z m512 zmm k zmm
//	VPADDD.Z zmm  zmm k zmm
func VPADDD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPADDD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPADDQ: Add Packed Quadword Integers.
//
// Forms:
//
//	VPADDQ m256 ymm ymm
//	VPADDQ ymm  ymm ymm
//	VPADDQ m128 xmm xmm
//	VPADDQ xmm  xmm xmm
//	VPADDQ m128 xmm k xmm
//	VPADDQ m256 ymm k ymm
//	VPADDQ xmm  xmm k xmm
//	VPADDQ ymm  ymm k ymm
//	VPADDQ m512 zmm k zmm
//	VPADDQ m512 zmm zmm
//	VPADDQ zmm  zmm k zmm
//	VPADDQ zmm  zmm zmm
func VPADDQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPADDQ.Forms(), sffxs{}, ops)
}

// VPADDQ_BCST: Add Packed Quadword Integers (Broadcast).
//
// Forms:
//
//	VPADDQ.BCST m64 xmm k xmm
//	VPADDQ.BCST m64 xmm xmm
//	VPADDQ.BCST m64 ymm k ymm
//	VPADDQ.BCST m64 ymm ymm
//	VPADDQ.BCST m64 zmm k zmm
//	VPADDQ.BCST m64 zmm zmm
func VPADDQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPADDQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPADDQ_BCST_Z: Add Packed Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPADDQ.BCST.Z m64 xmm k xmm
//	VPADDQ.BCST.Z m64 ymm k ymm
//	VPADDQ.BCST.Z m64 zmm k zmm
func VPADDQ_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPADDQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPADDQ_Z: Add Packed Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VPADDQ.Z m128 xmm k xmm
//	VPADDQ.Z m256 ymm k ymm
//	VPADDQ.Z xmm  xmm k xmm
//	VPADDQ.Z ymm  ymm k ymm
//	VPADDQ.Z m512 zmm k zmm
//	VPADDQ.Z zmm  zmm k zmm
func VPADDQ_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPADDQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPADDSB: Add Packed Signed Byte Integers with Signed Saturation.
//
// Forms:
//
//	VPADDSB m256 ymm ymm
//	VPADDSB ymm  ymm ymm
//	VPADDSB m128 xmm xmm
//	VPADDSB xmm  xmm xmm
//	VPADDSB m128 xmm k xmm
//	VPADDSB m256 ymm k ymm
//	VPADDSB xmm  xmm k xmm
//	VPADDSB ymm  ymm k ymm
//	VPADDSB m512 zmm k zmm
//	VPADDSB m512 zmm zmm
//	VPADDSB zmm  zmm k zmm
//	VPADDSB zmm  zmm zmm
func VPADDSB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPADDSB.Forms(), sffxs{}, ops)
}

// VPADDSB_Z: Add Packed Signed Byte Integers with Signed Saturation (Zeroing Masking).
//
// Forms:
//
//	VPADDSB.Z m128 xmm k xmm
//	VPADDSB.Z m256 ymm k ymm
//	VPADDSB.Z xmm  xmm k xmm
//	VPADDSB.Z ymm  ymm k ymm
//	VPADDSB.Z m512 zmm k zmm
//	VPADDSB.Z zmm  zmm k zmm
func VPADDSB_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPADDSB.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPADDSW: Add Packed Signed Word Integers with Signed Saturation.
//
// Forms:
//
//	VPADDSW m256 ymm ymm
//	VPADDSW ymm  ymm ymm
//	VPADDSW m128 xmm xmm
//	VPADDSW xmm  xmm xmm
//	VPADDSW m128 xmm k xmm
//	VPADDSW m256 ymm k ymm
//	VPADDSW xmm  xmm k xmm
//	VPADDSW ymm  ymm k ymm
//	VPADDSW m512 zmm k zmm
//	VPADDSW m512 zmm zmm
//	VPADDSW zmm  zmm k zmm
//	VPADDSW zmm  zmm zmm
func VPADDSW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPADDSW.Forms(), sffxs{}, ops)
}

// VPADDSW_Z: Add Packed Signed Word Integers with Signed Saturation (Zeroing Masking).
//
// Forms:
//
//	VPADDSW.Z m128 xmm k xmm
//	VPADDSW.Z m256 ymm k ymm
//	VPADDSW.Z xmm  xmm k xmm
//	VPADDSW.Z ymm  ymm k ymm
//	VPADDSW.Z m512 zmm k zmm
//	VPADDSW.Z zmm  zmm k zmm
func VPADDSW_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPADDSW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPADDUSB: Add Packed Unsigned Byte Integers with Unsigned Saturation.
//
// Forms:
//
//	VPADDUSB m256 ymm ymm
//	VPADDUSB ymm  ymm ymm
//	VPADDUSB m128 xmm xmm
//	VPADDUSB xmm  xmm xmm
//	VPADDUSB m128 xmm k xmm
//	VPADDUSB m256 ymm k ymm
//	VPADDUSB xmm  xmm k xmm
//	VPADDUSB ymm  ymm k ymm
//	VPADDUSB m512 zmm k zmm
//	VPADDUSB m512 zmm zmm
//	VPADDUSB zmm  zmm k zmm
//	VPADDUSB zmm  zmm zmm
func VPADDUSB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPADDUSB.Forms(), sffxs{}, ops)
}

// VPADDUSB_Z: Add Packed Unsigned Byte Integers with Unsigned Saturation (Zeroing Masking).
//
// Forms:
//
//	VPADDUSB.Z m128 xmm k xmm
//	VPADDUSB.Z m256 ymm k ymm
//	VPADDUSB.Z xmm  xmm k xmm
//	VPADDUSB.Z ymm  ymm k ymm
//	VPADDUSB.Z m512 zmm k zmm
//	VPADDUSB.Z zmm  zmm k zmm
func VPADDUSB_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPADDUSB.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPADDUSW: Add Packed Unsigned Word Integers with Unsigned Saturation.
//
// Forms:
//
//	VPADDUSW m256 ymm ymm
//	VPADDUSW ymm  ymm ymm
//	VPADDUSW m128 xmm xmm
//	VPADDUSW xmm  xmm xmm
//	VPADDUSW m128 xmm k xmm
//	VPADDUSW m256 ymm k ymm
//	VPADDUSW xmm  xmm k xmm
//	VPADDUSW ymm  ymm k ymm
//	VPADDUSW m512 zmm k zmm
//	VPADDUSW m512 zmm zmm
//	VPADDUSW zmm  zmm k zmm
//	VPADDUSW zmm  zmm zmm
func VPADDUSW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPADDUSW.Forms(), sffxs{}, ops)
}

// VPADDUSW_Z: Add Packed Unsigned Word Integers with Unsigned Saturation (Zeroing Masking).
//
// Forms:
//
//	VPADDUSW.Z m128 xmm k xmm
//	VPADDUSW.Z m256 ymm k ymm
//	VPADDUSW.Z xmm  xmm k xmm
//	VPADDUSW.Z ymm  ymm k ymm
//	VPADDUSW.Z m512 zmm k zmm
//	VPADDUSW.Z zmm  zmm k zmm
func VPADDUSW_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPADDUSW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPADDW: Add Packed Word Integers.
//
// Forms:
//
//	VPADDW m256 ymm ymm
//	VPADDW ymm  ymm ymm
//	VPADDW m128 xmm xmm
//	VPADDW xmm  xmm xmm
//	VPADDW m128 xmm k xmm
//	VPADDW m256 ymm k ymm
//	VPADDW xmm  xmm k xmm
//	VPADDW ymm  ymm k ymm
//	VPADDW m512 zmm k zmm
//	VPADDW m512 zmm zmm
//	VPADDW zmm  zmm k zmm
//	VPADDW zmm  zmm zmm
func VPADDW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPADDW.Forms(), sffxs{}, ops)
}

// VPADDW_Z: Add Packed Word Integers (Zeroing Masking).
//
// Forms:
//
//	VPADDW.Z m128 xmm k xmm
//	VPADDW.Z m256 ymm k ymm
//	VPADDW.Z xmm  xmm k xmm
//	VPADDW.Z ymm  ymm k ymm
//	VPADDW.Z m512 zmm k zmm
//	VPADDW.Z zmm  zmm k zmm
func VPADDW_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPADDW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPALIGNR: Packed Align Right.
//
// Forms:
//
//	VPALIGNR imm8 m256 ymm ymm
//	VPALIGNR imm8 ymm  ymm ymm
//	VPALIGNR imm8 m128 xmm xmm
//	VPALIGNR imm8 xmm  xmm xmm
//	VPALIGNR imm8 m128 xmm k xmm
//	VPALIGNR imm8 m256 ymm k ymm
//	VPALIGNR imm8 xmm  xmm k xmm
//	VPALIGNR imm8 ymm  ymm k ymm
//	VPALIGNR imm8 m512 zmm k zmm
//	VPALIGNR imm8 m512 zmm zmm
//	VPALIGNR imm8 zmm  zmm k zmm
//	VPALIGNR imm8 zmm  zmm zmm
func VPALIGNR(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPALIGNR.Forms(), sffxs{}, ops)
}

// VPALIGNR_Z: Packed Align Right (Zeroing Masking).
//
// Forms:
//
//	VPALIGNR.Z imm8 m128 xmm k xmm
//	VPALIGNR.Z imm8 m256 ymm k ymm
//	VPALIGNR.Z imm8 xmm  xmm k xmm
//	VPALIGNR.Z imm8 ymm  ymm k ymm
//	VPALIGNR.Z imm8 m512 zmm k zmm
//	VPALIGNR.Z imm8 zmm  zmm k zmm
func VPALIGNR_Z(i, mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPALIGNR.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, xyz, k, xyz1})
}

// VPAND: Packed Bitwise Logical AND.
//
// Forms:
//
//	VPAND m256 ymm ymm
//	VPAND ymm  ymm ymm
//	VPAND m128 xmm xmm
//	VPAND xmm  xmm xmm
func VPAND(mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPAND.Forms(), sffxs{}, []operand.Op{mxy, xy, xy1})
}

// VPANDD: Bitwise Logical AND of Packed Doubleword Integers.
//
// Forms:
//
//	VPANDD m128 xmm k xmm
//	VPANDD m128 xmm xmm
//	VPANDD m256 ymm k ymm
//	VPANDD m256 ymm ymm
//	VPANDD xmm  xmm k xmm
//	VPANDD xmm  xmm xmm
//	VPANDD ymm  ymm k ymm
//	VPANDD ymm  ymm ymm
//	VPANDD m512 zmm k zmm
//	VPANDD m512 zmm zmm
//	VPANDD zmm  zmm k zmm
//	VPANDD zmm  zmm zmm
func VPANDD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPANDD.Forms(), sffxs{}, ops)
}

// VPANDD_BCST: Bitwise Logical AND of Packed Doubleword Integers (Broadcast).
//
// Forms:
//
//	VPANDD.BCST m32 xmm k xmm
//	VPANDD.BCST m32 xmm xmm
//	VPANDD.BCST m32 ymm k ymm
//	VPANDD.BCST m32 ymm ymm
//	VPANDD.BCST m32 zmm k zmm
//	VPANDD.BCST m32 zmm zmm
func VPANDD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPANDD.Forms(), sffxs{sffxBCST}, ops)
}

// VPANDD_BCST_Z: Bitwise Logical AND of Packed Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPANDD.BCST.Z m32 xmm k xmm
//	VPANDD.BCST.Z m32 ymm k ymm
//	VPANDD.BCST.Z m32 zmm k zmm
func VPANDD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPANDD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPANDD_Z: Bitwise Logical AND of Packed Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VPANDD.Z m128 xmm k xmm
//	VPANDD.Z m256 ymm k ymm
//	VPANDD.Z xmm  xmm k xmm
//	VPANDD.Z ymm  ymm k ymm
//	VPANDD.Z m512 zmm k zmm
//	VPANDD.Z zmm  zmm k zmm
func VPANDD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPANDD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPANDN: Packed Bitwise Logical AND NOT.
//
// Forms:
//
//	VPANDN m256 ymm ymm
//	VPANDN ymm  ymm ymm
//	VPANDN m128 xmm xmm
//	VPANDN xmm  xmm xmm
func VPANDN(mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPANDN.Forms(), sffxs{}, []operand.Op{mxy, xy, xy1})
}

// VPANDND: Bitwise Logical AND NOT of Packed Doubleword Integers.
//
// Forms:
//
//	VPANDND m128 xmm k xmm
//	VPANDND m128 xmm xmm
//	VPANDND m256 ymm k ymm
//	VPANDND m256 ymm ymm
//	VPANDND xmm  xmm k xmm
//	VPANDND xmm  xmm xmm
//	VPANDND ymm  ymm k ymm
//	VPANDND ymm  ymm ymm
//	VPANDND m512 zmm k zmm
//	VPANDND m512 zmm zmm
//	VPANDND zmm  zmm k zmm
//	VPANDND zmm  zmm zmm
func VPANDND(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPANDND.Forms(), sffxs{}, ops)
}

// VPANDND_BCST: Bitwise Logical AND NOT of Packed Doubleword Integers (Broadcast).
//
// Forms:
//
//	VPANDND.BCST m32 xmm k xmm
//	VPANDND.BCST m32 xmm xmm
//	VPANDND.BCST m32 ymm k ymm
//	VPANDND.BCST m32 ymm ymm
//	VPANDND.BCST m32 zmm k zmm
//	VPANDND.BCST m32 zmm zmm
func VPANDND_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPANDND.Forms(), sffxs{sffxBCST}, ops)
}

// VPANDND_BCST_Z: Bitwise Logical AND NOT of Packed Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPANDND.BCST.Z m32 xmm k xmm
//	VPANDND.BCST.Z m32 ymm k ymm
//	VPANDND.BCST.Z m32 zmm k zmm
func VPANDND_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPANDND.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPANDND_Z: Bitwise Logical AND NOT of Packed Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VPANDND.Z m128 xmm k xmm
//	VPANDND.Z m256 ymm k ymm
//	VPANDND.Z xmm  xmm k xmm
//	VPANDND.Z ymm  ymm k ymm
//	VPANDND.Z m512 zmm k zmm
//	VPANDND.Z zmm  zmm k zmm
func VPANDND_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPANDND.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPANDNQ: Bitwise Logical AND NOT of Packed Quadword Integers.
//
// Forms:
//
//	VPANDNQ m128 xmm k xmm
//	VPANDNQ m128 xmm xmm
//	VPANDNQ m256 ymm k ymm
//	VPANDNQ m256 ymm ymm
//	VPANDNQ xmm  xmm k xmm
//	VPANDNQ xmm  xmm xmm
//	VPANDNQ ymm  ymm k ymm
//	VPANDNQ ymm  ymm ymm
//	VPANDNQ m512 zmm k zmm
//	VPANDNQ m512 zmm zmm
//	VPANDNQ zmm  zmm k zmm
//	VPANDNQ zmm  zmm zmm
func VPANDNQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPANDNQ.Forms(), sffxs{}, ops)
}

// VPANDNQ_BCST: Bitwise Logical AND NOT of Packed Quadword Integers (Broadcast).
//
// Forms:
//
//	VPANDNQ.BCST m64 xmm k xmm
//	VPANDNQ.BCST m64 xmm xmm
//	VPANDNQ.BCST m64 ymm k ymm
//	VPANDNQ.BCST m64 ymm ymm
//	VPANDNQ.BCST m64 zmm k zmm
//	VPANDNQ.BCST m64 zmm zmm
func VPANDNQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPANDNQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPANDNQ_BCST_Z: Bitwise Logical AND NOT of Packed Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPANDNQ.BCST.Z m64 xmm k xmm
//	VPANDNQ.BCST.Z m64 ymm k ymm
//	VPANDNQ.BCST.Z m64 zmm k zmm
func VPANDNQ_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPANDNQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPANDNQ_Z: Bitwise Logical AND NOT of Packed Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VPANDNQ.Z m128 xmm k xmm
//	VPANDNQ.Z m256 ymm k ymm
//	VPANDNQ.Z xmm  xmm k xmm
//	VPANDNQ.Z ymm  ymm k ymm
//	VPANDNQ.Z m512 zmm k zmm
//	VPANDNQ.Z zmm  zmm k zmm
func VPANDNQ_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPANDNQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPANDQ: Bitwise Logical AND of Packed Quadword Integers.
//
// Forms:
//
//	VPANDQ m128 xmm k xmm
//	VPANDQ m128 xmm xmm
//	VPANDQ m256 ymm k ymm
//	VPANDQ m256 ymm ymm
//	VPANDQ xmm  xmm k xmm
//	VPANDQ xmm  xmm xmm
//	VPANDQ ymm  ymm k ymm
//	VPANDQ ymm  ymm ymm
//	VPANDQ m512 zmm k zmm
//	VPANDQ m512 zmm zmm
//	VPANDQ zmm  zmm k zmm
//	VPANDQ zmm  zmm zmm
func VPANDQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPANDQ.Forms(), sffxs{}, ops)
}

// VPANDQ_BCST: Bitwise Logical AND of Packed Quadword Integers (Broadcast).
//
// Forms:
//
//	VPANDQ.BCST m64 xmm k xmm
//	VPANDQ.BCST m64 xmm xmm
//	VPANDQ.BCST m64 ymm k ymm
//	VPANDQ.BCST m64 ymm ymm
//	VPANDQ.BCST m64 zmm k zmm
//	VPANDQ.BCST m64 zmm zmm
func VPANDQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPANDQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPANDQ_BCST_Z: Bitwise Logical AND of Packed Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPANDQ.BCST.Z m64 xmm k xmm
//	VPANDQ.BCST.Z m64 ymm k ymm
//	VPANDQ.BCST.Z m64 zmm k zmm
func VPANDQ_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPANDQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPANDQ_Z: Bitwise Logical AND of Packed Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VPANDQ.Z m128 xmm k xmm
//	VPANDQ.Z m256 ymm k ymm
//	VPANDQ.Z xmm  xmm k xmm
//	VPANDQ.Z ymm  ymm k ymm
//	VPANDQ.Z m512 zmm k zmm
//	VPANDQ.Z zmm  zmm k zmm
func VPANDQ_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPANDQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPAVGB: Average Packed Byte Integers.
//
// Forms:
//
//	VPAVGB m256 ymm ymm
//	VPAVGB ymm  ymm ymm
//	VPAVGB m128 xmm xmm
//	VPAVGB xmm  xmm xmm
//	VPAVGB m128 xmm k xmm
//	VPAVGB m256 ymm k ymm
//	VPAVGB xmm  xmm k xmm
//	VPAVGB ymm  ymm k ymm
//	VPAVGB m512 zmm k zmm
//	VPAVGB m512 zmm zmm
//	VPAVGB zmm  zmm k zmm
//	VPAVGB zmm  zmm zmm
func VPAVGB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPAVGB.Forms(), sffxs{}, ops)
}

// VPAVGB_Z: Average Packed Byte Integers (Zeroing Masking).
//
// Forms:
//
//	VPAVGB.Z m128 xmm k xmm
//	VPAVGB.Z m256 ymm k ymm
//	VPAVGB.Z xmm  xmm k xmm
//	VPAVGB.Z ymm  ymm k ymm
//	VPAVGB.Z m512 zmm k zmm
//	VPAVGB.Z zmm  zmm k zmm
func VPAVGB_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPAVGB.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPAVGW: Average Packed Word Integers.
//
// Forms:
//
//	VPAVGW m256 ymm ymm
//	VPAVGW ymm  ymm ymm
//	VPAVGW m128 xmm xmm
//	VPAVGW xmm  xmm xmm
//	VPAVGW m128 xmm k xmm
//	VPAVGW m256 ymm k ymm
//	VPAVGW xmm  xmm k xmm
//	VPAVGW ymm  ymm k ymm
//	VPAVGW m512 zmm k zmm
//	VPAVGW m512 zmm zmm
//	VPAVGW zmm  zmm k zmm
//	VPAVGW zmm  zmm zmm
func VPAVGW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPAVGW.Forms(), sffxs{}, ops)
}

// VPAVGW_Z: Average Packed Word Integers (Zeroing Masking).
//
// Forms:
//
//	VPAVGW.Z m128 xmm k xmm
//	VPAVGW.Z m256 ymm k ymm
//	VPAVGW.Z xmm  xmm k xmm
//	VPAVGW.Z ymm  ymm k ymm
//	VPAVGW.Z m512 zmm k zmm
//	VPAVGW.Z zmm  zmm k zmm
func VPAVGW_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPAVGW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPBLENDD: Blend Packed Doublewords.
//
// Forms:
//
//	VPBLENDD imm8 m128 xmm xmm
//	VPBLENDD imm8 m256 ymm ymm
//	VPBLENDD imm8 xmm  xmm xmm
//	VPBLENDD imm8 ymm  ymm ymm
func VPBLENDD(i, mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBLENDD.Forms(), sffxs{}, []operand.Op{i, mxy, xy, xy1})
}

// VPBLENDMB: Blend Byte Vectors Using an OpMask Control.
//
// Forms:
//
//	VPBLENDMB m128 xmm k xmm
//	VPBLENDMB m128 xmm xmm
//	VPBLENDMB m256 ymm k ymm
//	VPBLENDMB m256 ymm ymm
//	VPBLENDMB xmm  xmm k xmm
//	VPBLENDMB xmm  xmm xmm
//	VPBLENDMB ymm  ymm k ymm
//	VPBLENDMB ymm  ymm ymm
//	VPBLENDMB m512 zmm k zmm
//	VPBLENDMB m512 zmm zmm
//	VPBLENDMB zmm  zmm k zmm
//	VPBLENDMB zmm  zmm zmm
func VPBLENDMB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBLENDMB.Forms(), sffxs{}, ops)
}

// VPBLENDMB_Z: Blend Byte Vectors Using an OpMask Control (Zeroing Masking).
//
// Forms:
//
//	VPBLENDMB.Z m128 xmm k xmm
//	VPBLENDMB.Z m256 ymm k ymm
//	VPBLENDMB.Z xmm  xmm k xmm
//	VPBLENDMB.Z ymm  ymm k ymm
//	VPBLENDMB.Z m512 zmm k zmm
//	VPBLENDMB.Z zmm  zmm k zmm
func VPBLENDMB_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBLENDMB.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPBLENDMD: Blend Doubleword Vectors Using an OpMask Control.
//
// Forms:
//
//	VPBLENDMD m128 xmm k xmm
//	VPBLENDMD m128 xmm xmm
//	VPBLENDMD m256 ymm k ymm
//	VPBLENDMD m256 ymm ymm
//	VPBLENDMD xmm  xmm k xmm
//	VPBLENDMD xmm  xmm xmm
//	VPBLENDMD ymm  ymm k ymm
//	VPBLENDMD ymm  ymm ymm
//	VPBLENDMD m512 zmm k zmm
//	VPBLENDMD m512 zmm zmm
//	VPBLENDMD zmm  zmm k zmm
//	VPBLENDMD zmm  zmm zmm
func VPBLENDMD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBLENDMD.Forms(), sffxs{}, ops)
}

// VPBLENDMD_BCST: Blend Doubleword Vectors Using an OpMask Control (Broadcast).
//
// Forms:
//
//	VPBLENDMD.BCST m32 xmm k xmm
//	VPBLENDMD.BCST m32 xmm xmm
//	VPBLENDMD.BCST m32 ymm k ymm
//	VPBLENDMD.BCST m32 ymm ymm
//	VPBLENDMD.BCST m32 zmm k zmm
//	VPBLENDMD.BCST m32 zmm zmm
func VPBLENDMD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBLENDMD.Forms(), sffxs{sffxBCST}, ops)
}

// VPBLENDMD_BCST_Z: Blend Doubleword Vectors Using an OpMask Control (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPBLENDMD.BCST.Z m32 xmm k xmm
//	VPBLENDMD.BCST.Z m32 ymm k ymm
//	VPBLENDMD.BCST.Z m32 zmm k zmm
func VPBLENDMD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBLENDMD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPBLENDMD_Z: Blend Doubleword Vectors Using an OpMask Control (Zeroing Masking).
//
// Forms:
//
//	VPBLENDMD.Z m128 xmm k xmm
//	VPBLENDMD.Z m256 ymm k ymm
//	VPBLENDMD.Z xmm  xmm k xmm
//	VPBLENDMD.Z ymm  ymm k ymm
//	VPBLENDMD.Z m512 zmm k zmm
//	VPBLENDMD.Z zmm  zmm k zmm
func VPBLENDMD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBLENDMD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPBLENDMQ: Blend Quadword Vectors Using an OpMask Control.
//
// Forms:
//
//	VPBLENDMQ m128 xmm k xmm
//	VPBLENDMQ m128 xmm xmm
//	VPBLENDMQ m256 ymm k ymm
//	VPBLENDMQ m256 ymm ymm
//	VPBLENDMQ xmm  xmm k xmm
//	VPBLENDMQ xmm  xmm xmm
//	VPBLENDMQ ymm  ymm k ymm
//	VPBLENDMQ ymm  ymm ymm
//	VPBLENDMQ m512 zmm k zmm
//	VPBLENDMQ m512 zmm zmm
//	VPBLENDMQ zmm  zmm k zmm
//	VPBLENDMQ zmm  zmm zmm
func VPBLENDMQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBLENDMQ.Forms(), sffxs{}, ops)
}

// VPBLENDMQ_BCST: Blend Quadword Vectors Using an OpMask Control (Broadcast).
//
// Forms:
//
//	VPBLENDMQ.BCST m64 xmm k xmm
//	VPBLENDMQ.BCST m64 xmm xmm
//	VPBLENDMQ.BCST m64 ymm k ymm
//	VPBLENDMQ.BCST m64 ymm ymm
//	VPBLENDMQ.BCST m64 zmm k zmm
//	VPBLENDMQ.BCST m64 zmm zmm
func VPBLENDMQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBLENDMQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPBLENDMQ_BCST_Z: Blend Quadword Vectors Using an OpMask Control (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPBLENDMQ.BCST.Z m64 xmm k xmm
//	VPBLENDMQ.BCST.Z m64 ymm k ymm
//	VPBLENDMQ.BCST.Z m64 zmm k zmm
func VPBLENDMQ_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBLENDMQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPBLENDMQ_Z: Blend Quadword Vectors Using an OpMask Control (Zeroing Masking).
//
// Forms:
//
//	VPBLENDMQ.Z m128 xmm k xmm
//	VPBLENDMQ.Z m256 ymm k ymm
//	VPBLENDMQ.Z xmm  xmm k xmm
//	VPBLENDMQ.Z ymm  ymm k ymm
//	VPBLENDMQ.Z m512 zmm k zmm
//	VPBLENDMQ.Z zmm  zmm k zmm
func VPBLENDMQ_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBLENDMQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPBLENDMW: Blend Word Vectors Using an OpMask Control.
//
// Forms:
//
//	VPBLENDMW m128 xmm k xmm
//	VPBLENDMW m128 xmm xmm
//	VPBLENDMW m256 ymm k ymm
//	VPBLENDMW m256 ymm ymm
//	VPBLENDMW xmm  xmm k xmm
//	VPBLENDMW xmm  xmm xmm
//	VPBLENDMW ymm  ymm k ymm
//	VPBLENDMW ymm  ymm ymm
//	VPBLENDMW m512 zmm k zmm
//	VPBLENDMW m512 zmm zmm
//	VPBLENDMW zmm  zmm k zmm
//	VPBLENDMW zmm  zmm zmm
func VPBLENDMW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBLENDMW.Forms(), sffxs{}, ops)
}

// VPBLENDMW_Z: Blend Word Vectors Using an OpMask Control (Zeroing Masking).
//
// Forms:
//
//	VPBLENDMW.Z m128 xmm k xmm
//	VPBLENDMW.Z m256 ymm k ymm
//	VPBLENDMW.Z xmm  xmm k xmm
//	VPBLENDMW.Z ymm  ymm k ymm
//	VPBLENDMW.Z m512 zmm k zmm
//	VPBLENDMW.Z zmm  zmm k zmm
func VPBLENDMW_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBLENDMW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPBLENDVB: Variable Blend Packed Bytes.
//
// Forms:
//
//	VPBLENDVB ymm m256 ymm ymm
//	VPBLENDVB ymm ymm  ymm ymm
//	VPBLENDVB xmm m128 xmm xmm
//	VPBLENDVB xmm xmm  xmm xmm
func VPBLENDVB(xy, mxy, xy1, xy2 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBLENDVB.Forms(), sffxs{}, []operand.Op{xy, mxy, xy1, xy2})
}

// VPBLENDW: Blend Packed Words.
//
// Forms:
//
//	VPBLENDW imm8 m256 ymm ymm
//	VPBLENDW imm8 ymm  ymm ymm
//	VPBLENDW imm8 m128 xmm xmm
//	VPBLENDW imm8 xmm  xmm xmm
func VPBLENDW(i, mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBLENDW.Forms(), sffxs{}, []operand.Op{i, mxy, xy, xy1})
}

// VPBROADCASTB: Broadcast Byte Integer.
//
// Forms:
//
//	VPBROADCASTB m8  xmm
//	VPBROADCASTB m8  ymm
//	VPBROADCASTB xmm xmm
//	VPBROADCASTB xmm ymm
//	VPBROADCASTB m8  k xmm
//	VPBROADCASTB m8  k ymm
//	VPBROADCASTB r32 k xmm
//	VPBROADCASTB r32 k ymm
//	VPBROADCASTB r32 xmm
//	VPBROADCASTB r32 ymm
//	VPBROADCASTB xmm k xmm
//	VPBROADCASTB xmm k ymm
//	VPBROADCASTB m8  k zmm
//	VPBROADCASTB m8  zmm
//	VPBROADCASTB r32 k zmm
//	VPBROADCASTB r32 zmm
//	VPBROADCASTB xmm k zmm
//	VPBROADCASTB xmm zmm
func VPBROADCASTB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBROADCASTB.Forms(), sffxs{}, ops)
}

// VPBROADCASTB_Z: Broadcast Byte Integer (Zeroing Masking).
//
// Forms:
//
//	VPBROADCASTB.Z m8  k xmm
//	VPBROADCASTB.Z m8  k ymm
//	VPBROADCASTB.Z r32 k xmm
//	VPBROADCASTB.Z r32 k ymm
//	VPBROADCASTB.Z xmm k xmm
//	VPBROADCASTB.Z xmm k ymm
//	VPBROADCASTB.Z m8  k zmm
//	VPBROADCASTB.Z r32 k zmm
//	VPBROADCASTB.Z xmm k zmm
func VPBROADCASTB_Z(mrx, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBROADCASTB.Forms(), sffxs{sffxZ}, []operand.Op{mrx, k, xyz})
}

// VPBROADCASTD: Broadcast Doubleword Integer.
//
// Forms:
//
//	VPBROADCASTD m32 xmm
//	VPBROADCASTD m32 ymm
//	VPBROADCASTD xmm xmm
//	VPBROADCASTD xmm ymm
//	VPBROADCASTD m32 k xmm
//	VPBROADCASTD m32 k ymm
//	VPBROADCASTD r32 k xmm
//	VPBROADCASTD r32 k ymm
//	VPBROADCASTD r32 xmm
//	VPBROADCASTD r32 ymm
//	VPBROADCASTD xmm k xmm
//	VPBROADCASTD xmm k ymm
//	VPBROADCASTD m32 k zmm
//	VPBROADCASTD m32 zmm
//	VPBROADCASTD r32 k zmm
//	VPBROADCASTD r32 zmm
//	VPBROADCASTD xmm k zmm
//	VPBROADCASTD xmm zmm
func VPBROADCASTD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBROADCASTD.Forms(), sffxs{}, ops)
}

// VPBROADCASTD_Z: Broadcast Doubleword Integer (Zeroing Masking).
//
// Forms:
//
//	VPBROADCASTD.Z m32 k xmm
//	VPBROADCASTD.Z m32 k ymm
//	VPBROADCASTD.Z r32 k xmm
//	VPBROADCASTD.Z r32 k ymm
//	VPBROADCASTD.Z xmm k xmm
//	VPBROADCASTD.Z xmm k ymm
//	VPBROADCASTD.Z m32 k zmm
//	VPBROADCASTD.Z r32 k zmm
//	VPBROADCASTD.Z xmm k zmm
func VPBROADCASTD_Z(mrx, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBROADCASTD.Forms(), sffxs{sffxZ}, []operand.Op{mrx, k, xyz})
}

// VPBROADCASTMB2Q: Broadcast Low Byte of Mask Register to Packed Quadword Values.
//
// Forms:
//
//	VPBROADCASTMB2Q k xmm
//	VPBROADCASTMB2Q k ymm
//	VPBROADCASTMB2Q k zmm
func VPBROADCASTMB2Q(k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBROADCASTMB2Q.Forms(), sffxs{}, []operand.Op{k, xyz})
}

// VPBROADCASTMW2D: Broadcast Low Word of Mask Register to Packed Doubleword Values.
//
// Forms:
//
//	VPBROADCASTMW2D k xmm
//	VPBROADCASTMW2D k ymm
//	VPBROADCASTMW2D k zmm
func VPBROADCASTMW2D(k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBROADCASTMW2D.Forms(), sffxs{}, []operand.Op{k, xyz})
}

// VPBROADCASTQ: Broadcast Quadword Integer.
//
// Forms:
//
//	VPBROADCASTQ m64 xmm
//	VPBROADCASTQ m64 ymm
//	VPBROADCASTQ xmm xmm
//	VPBROADCASTQ xmm ymm
//	VPBROADCASTQ m64 k xmm
//	VPBROADCASTQ m64 k ymm
//	VPBROADCASTQ r64 k xmm
//	VPBROADCASTQ r64 k ymm
//	VPBROADCASTQ r64 xmm
//	VPBROADCASTQ r64 ymm
//	VPBROADCASTQ xmm k xmm
//	VPBROADCASTQ xmm k ymm
//	VPBROADCASTQ m64 k zmm
//	VPBROADCASTQ m64 zmm
//	VPBROADCASTQ r64 k zmm
//	VPBROADCASTQ r64 zmm
//	VPBROADCASTQ xmm k zmm
//	VPBROADCASTQ xmm zmm
func VPBROADCASTQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBROADCASTQ.Forms(), sffxs{}, ops)
}

// VPBROADCASTQ_Z: Broadcast Quadword Integer (Zeroing Masking).
//
// Forms:
//
//	VPBROADCASTQ.Z m64 k xmm
//	VPBROADCASTQ.Z m64 k ymm
//	VPBROADCASTQ.Z r64 k xmm
//	VPBROADCASTQ.Z r64 k ymm
//	VPBROADCASTQ.Z xmm k xmm
//	VPBROADCASTQ.Z xmm k ymm
//	VPBROADCASTQ.Z m64 k zmm
//	VPBROADCASTQ.Z r64 k zmm
//	VPBROADCASTQ.Z xmm k zmm
func VPBROADCASTQ_Z(mrx, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBROADCASTQ.Forms(), sffxs{sffxZ}, []operand.Op{mrx, k, xyz})
}

// VPBROADCASTW: Broadcast Word Integer.
//
// Forms:
//
//	VPBROADCASTW m16 xmm
//	VPBROADCASTW m16 ymm
//	VPBROADCASTW xmm xmm
//	VPBROADCASTW xmm ymm
//	VPBROADCASTW m16 k xmm
//	VPBROADCASTW m16 k ymm
//	VPBROADCASTW r32 k xmm
//	VPBROADCASTW r32 k ymm
//	VPBROADCASTW r32 xmm
//	VPBROADCASTW r32 ymm
//	VPBROADCASTW xmm k xmm
//	VPBROADCASTW xmm k ymm
//	VPBROADCASTW m16 k zmm
//	VPBROADCASTW m16 zmm
//	VPBROADCASTW r32 k zmm
//	VPBROADCASTW r32 zmm
//	VPBROADCASTW xmm k zmm
//	VPBROADCASTW xmm zmm
func VPBROADCASTW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBROADCASTW.Forms(), sffxs{}, ops)
}

// VPBROADCASTW_Z: Broadcast Word Integer (Zeroing Masking).
//
// Forms:
//
//	VPBROADCASTW.Z m16 k xmm
//	VPBROADCASTW.Z m16 k ymm
//	VPBROADCASTW.Z r32 k xmm
//	VPBROADCASTW.Z r32 k ymm
//	VPBROADCASTW.Z xmm k xmm
//	VPBROADCASTW.Z xmm k ymm
//	VPBROADCASTW.Z m16 k zmm
//	VPBROADCASTW.Z r32 k zmm
//	VPBROADCASTW.Z xmm k zmm
func VPBROADCASTW_Z(mrx, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPBROADCASTW.Forms(), sffxs{sffxZ}, []operand.Op{mrx, k, xyz})
}

// VPCLMULQDQ: Carry-Less Quadword Multiplication.
//
// Forms:
//
//	VPCLMULQDQ imm8 m128 xmm xmm
//	VPCLMULQDQ imm8 xmm  xmm xmm
//	VPCLMULQDQ imm8 m256 ymm ymm
//	VPCLMULQDQ imm8 ymm  ymm ymm
//	VPCLMULQDQ imm8 m512 zmm zmm
//	VPCLMULQDQ imm8 zmm  zmm zmm
func VPCLMULQDQ(i, mxyz, xyz, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCLMULQDQ.Forms(), sffxs{}, []operand.Op{i, mxyz, xyz, xyz1})
}

// VPCMPB: Compare Packed Signed Byte Values.
//
// Forms:
//
//	VPCMPB imm8 m128 xmm k k
//	VPCMPB imm8 m128 xmm k
//	VPCMPB imm8 m256 ymm k k
//	VPCMPB imm8 m256 ymm k
//	VPCMPB imm8 xmm  xmm k k
//	VPCMPB imm8 xmm  xmm k
//	VPCMPB imm8 ymm  ymm k k
//	VPCMPB imm8 ymm  ymm k
//	VPCMPB imm8 m512 zmm k k
//	VPCMPB imm8 m512 zmm k
//	VPCMPB imm8 zmm  zmm k k
//	VPCMPB imm8 zmm  zmm k
func VPCMPB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPB.Forms(), sffxs{}, ops)
}

// VPCMPD: Compare Packed Signed Doubleword Values.
//
// Forms:
//
//	VPCMPD imm8 m128 xmm k k
//	VPCMPD imm8 m128 xmm k
//	VPCMPD imm8 m256 ymm k k
//	VPCMPD imm8 m256 ymm k
//	VPCMPD imm8 xmm  xmm k k
//	VPCMPD imm8 xmm  xmm k
//	VPCMPD imm8 ymm  ymm k k
//	VPCMPD imm8 ymm  ymm k
//	VPCMPD imm8 m512 zmm k k
//	VPCMPD imm8 m512 zmm k
//	VPCMPD imm8 zmm  zmm k k
//	VPCMPD imm8 zmm  zmm k
func VPCMPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPD.Forms(), sffxs{}, ops)
}

// VPCMPD_BCST: Compare Packed Signed Doubleword Values (Broadcast).
//
// Forms:
//
//	VPCMPD.BCST imm8 m32 xmm k k
//	VPCMPD.BCST imm8 m32 xmm k
//	VPCMPD.BCST imm8 m32 ymm k k
//	VPCMPD.BCST imm8 m32 ymm k
//	VPCMPD.BCST imm8 m32 zmm k k
//	VPCMPD.BCST imm8 m32 zmm k
func VPCMPD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPD.Forms(), sffxs{sffxBCST}, ops)
}

// VPCMPEQB: Compare Packed Byte Data for Equality.
//
// Forms:
//
//	VPCMPEQB m256 ymm ymm
//	VPCMPEQB ymm  ymm ymm
//	VPCMPEQB m128 xmm xmm
//	VPCMPEQB xmm  xmm xmm
//	VPCMPEQB m128 xmm k k
//	VPCMPEQB m128 xmm k
//	VPCMPEQB m256 ymm k k
//	VPCMPEQB m256 ymm k
//	VPCMPEQB xmm  xmm k k
//	VPCMPEQB xmm  xmm k
//	VPCMPEQB ymm  ymm k k
//	VPCMPEQB ymm  ymm k
//	VPCMPEQB m512 zmm k k
//	VPCMPEQB m512 zmm k
//	VPCMPEQB zmm  zmm k k
//	VPCMPEQB zmm  zmm k
func VPCMPEQB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPEQB.Forms(), sffxs{}, ops)
}

// VPCMPEQD: Compare Packed Doubleword Data for Equality.
//
// Forms:
//
//	VPCMPEQD m256 ymm ymm
//	VPCMPEQD ymm  ymm ymm
//	VPCMPEQD m128 xmm xmm
//	VPCMPEQD xmm  xmm xmm
//	VPCMPEQD m128 xmm k k
//	VPCMPEQD m128 xmm k
//	VPCMPEQD m256 ymm k k
//	VPCMPEQD m256 ymm k
//	VPCMPEQD xmm  xmm k k
//	VPCMPEQD xmm  xmm k
//	VPCMPEQD ymm  ymm k k
//	VPCMPEQD ymm  ymm k
//	VPCMPEQD m512 zmm k k
//	VPCMPEQD m512 zmm k
//	VPCMPEQD zmm  zmm k k
//	VPCMPEQD zmm  zmm k
func VPCMPEQD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPEQD.Forms(), sffxs{}, ops)
}

// VPCMPEQD_BCST: Compare Packed Doubleword Data for Equality (Broadcast).
//
// Forms:
//
//	VPCMPEQD.BCST m32 xmm k k
//	VPCMPEQD.BCST m32 xmm k
//	VPCMPEQD.BCST m32 ymm k k
//	VPCMPEQD.BCST m32 ymm k
//	VPCMPEQD.BCST m32 zmm k k
//	VPCMPEQD.BCST m32 zmm k
func VPCMPEQD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPEQD.Forms(), sffxs{sffxBCST}, ops)
}

// VPCMPEQQ: Compare Packed Quadword Data for Equality.
//
// Forms:
//
//	VPCMPEQQ m256 ymm ymm
//	VPCMPEQQ ymm  ymm ymm
//	VPCMPEQQ m128 xmm xmm
//	VPCMPEQQ xmm  xmm xmm
//	VPCMPEQQ m128 xmm k k
//	VPCMPEQQ m128 xmm k
//	VPCMPEQQ m256 ymm k k
//	VPCMPEQQ m256 ymm k
//	VPCMPEQQ xmm  xmm k k
//	VPCMPEQQ xmm  xmm k
//	VPCMPEQQ ymm  ymm k k
//	VPCMPEQQ ymm  ymm k
//	VPCMPEQQ m512 zmm k k
//	VPCMPEQQ m512 zmm k
//	VPCMPEQQ zmm  zmm k k
//	VPCMPEQQ zmm  zmm k
func VPCMPEQQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPEQQ.Forms(), sffxs{}, ops)
}

// VPCMPEQQ_BCST: Compare Packed Quadword Data for Equality (Broadcast).
//
// Forms:
//
//	VPCMPEQQ.BCST m64 xmm k k
//	VPCMPEQQ.BCST m64 xmm k
//	VPCMPEQQ.BCST m64 ymm k k
//	VPCMPEQQ.BCST m64 ymm k
//	VPCMPEQQ.BCST m64 zmm k k
//	VPCMPEQQ.BCST m64 zmm k
func VPCMPEQQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPEQQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPCMPEQW: Compare Packed Word Data for Equality.
//
// Forms:
//
//	VPCMPEQW m256 ymm ymm
//	VPCMPEQW ymm  ymm ymm
//	VPCMPEQW m128 xmm xmm
//	VPCMPEQW xmm  xmm xmm
//	VPCMPEQW m128 xmm k k
//	VPCMPEQW m128 xmm k
//	VPCMPEQW m256 ymm k k
//	VPCMPEQW m256 ymm k
//	VPCMPEQW xmm  xmm k k
//	VPCMPEQW xmm  xmm k
//	VPCMPEQW ymm  ymm k k
//	VPCMPEQW ymm  ymm k
//	VPCMPEQW m512 zmm k k
//	VPCMPEQW m512 zmm k
//	VPCMPEQW zmm  zmm k k
//	VPCMPEQW zmm  zmm k
func VPCMPEQW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPEQW.Forms(), sffxs{}, ops)
}

// VPCMPESTRI: Packed Compare Explicit Length Strings, Return Index.
//
// Forms:
//
//	VPCMPESTRI imm8 m128 xmm
//	VPCMPESTRI imm8 xmm  xmm
func VPCMPESTRI(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPESTRI.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// VPCMPESTRM: Packed Compare Explicit Length Strings, Return Mask.
//
// Forms:
//
//	VPCMPESTRM imm8 m128 xmm
//	VPCMPESTRM imm8 xmm  xmm
func VPCMPESTRM(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPESTRM.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// VPCMPGTB: Compare Packed Signed Byte Integers for Greater Than.
//
// Forms:
//
//	VPCMPGTB m256 ymm ymm
//	VPCMPGTB ymm  ymm ymm
//	VPCMPGTB m128 xmm xmm
//	VPCMPGTB xmm  xmm xmm
//	VPCMPGTB m128 xmm k k
//	VPCMPGTB m128 xmm k
//	VPCMPGTB m256 ymm k k
//	VPCMPGTB m256 ymm k
//	VPCMPGTB xmm  xmm k k
//	VPCMPGTB xmm  xmm k
//	VPCMPGTB ymm  ymm k k
//	VPCMPGTB ymm  ymm k
//	VPCMPGTB m512 zmm k k
//	VPCMPGTB m512 zmm k
//	VPCMPGTB zmm  zmm k k
//	VPCMPGTB zmm  zmm k
func VPCMPGTB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPGTB.Forms(), sffxs{}, ops)
}

// VPCMPGTD: Compare Packed Signed Doubleword Integers for Greater Than.
//
// Forms:
//
//	VPCMPGTD m256 ymm ymm
//	VPCMPGTD ymm  ymm ymm
//	VPCMPGTD m128 xmm xmm
//	VPCMPGTD xmm  xmm xmm
//	VPCMPGTD m128 xmm k k
//	VPCMPGTD m128 xmm k
//	VPCMPGTD m256 ymm k k
//	VPCMPGTD m256 ymm k
//	VPCMPGTD xmm  xmm k k
//	VPCMPGTD xmm  xmm k
//	VPCMPGTD ymm  ymm k k
//	VPCMPGTD ymm  ymm k
//	VPCMPGTD m512 zmm k k
//	VPCMPGTD m512 zmm k
//	VPCMPGTD zmm  zmm k k
//	VPCMPGTD zmm  zmm k
func VPCMPGTD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPGTD.Forms(), sffxs{}, ops)
}

// VPCMPGTD_BCST: Compare Packed Signed Doubleword Integers for Greater Than (Broadcast).
//
// Forms:
//
//	VPCMPGTD.BCST m32 xmm k k
//	VPCMPGTD.BCST m32 xmm k
//	VPCMPGTD.BCST m32 ymm k k
//	VPCMPGTD.BCST m32 ymm k
//	VPCMPGTD.BCST m32 zmm k k
//	VPCMPGTD.BCST m32 zmm k
func VPCMPGTD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPGTD.Forms(), sffxs{sffxBCST}, ops)
}

// VPCMPGTQ: Compare Packed Data for Greater Than.
//
// Forms:
//
//	VPCMPGTQ m256 ymm ymm
//	VPCMPGTQ ymm  ymm ymm
//	VPCMPGTQ m128 xmm xmm
//	VPCMPGTQ xmm  xmm xmm
//	VPCMPGTQ m128 xmm k k
//	VPCMPGTQ m128 xmm k
//	VPCMPGTQ m256 ymm k k
//	VPCMPGTQ m256 ymm k
//	VPCMPGTQ xmm  xmm k k
//	VPCMPGTQ xmm  xmm k
//	VPCMPGTQ ymm  ymm k k
//	VPCMPGTQ ymm  ymm k
//	VPCMPGTQ m512 zmm k k
//	VPCMPGTQ m512 zmm k
//	VPCMPGTQ zmm  zmm k k
//	VPCMPGTQ zmm  zmm k
func VPCMPGTQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPGTQ.Forms(), sffxs{}, ops)
}

// VPCMPGTQ_BCST: Compare Packed Data for Greater Than (Broadcast).
//
// Forms:
//
//	VPCMPGTQ.BCST m64 xmm k k
//	VPCMPGTQ.BCST m64 xmm k
//	VPCMPGTQ.BCST m64 ymm k k
//	VPCMPGTQ.BCST m64 ymm k
//	VPCMPGTQ.BCST m64 zmm k k
//	VPCMPGTQ.BCST m64 zmm k
func VPCMPGTQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPGTQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPCMPGTW: Compare Packed Signed Word Integers for Greater Than.
//
// Forms:
//
//	VPCMPGTW m256 ymm ymm
//	VPCMPGTW ymm  ymm ymm
//	VPCMPGTW m128 xmm xmm
//	VPCMPGTW xmm  xmm xmm
//	VPCMPGTW m128 xmm k k
//	VPCMPGTW m128 xmm k
//	VPCMPGTW m256 ymm k k
//	VPCMPGTW m256 ymm k
//	VPCMPGTW xmm  xmm k k
//	VPCMPGTW xmm  xmm k
//	VPCMPGTW ymm  ymm k k
//	VPCMPGTW ymm  ymm k
//	VPCMPGTW m512 zmm k k
//	VPCMPGTW m512 zmm k
//	VPCMPGTW zmm  zmm k k
//	VPCMPGTW zmm  zmm k
func VPCMPGTW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPGTW.Forms(), sffxs{}, ops)
}

// VPCMPISTRI: Packed Compare Implicit Length Strings, Return Index.
//
// Forms:
//
//	VPCMPISTRI imm8 m128 xmm
//	VPCMPISTRI imm8 xmm  xmm
func VPCMPISTRI(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPISTRI.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// VPCMPISTRM: Packed Compare Implicit Length Strings, Return Mask.
//
// Forms:
//
//	VPCMPISTRM imm8 m128 xmm
//	VPCMPISTRM imm8 xmm  xmm
func VPCMPISTRM(i, mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPISTRM.Forms(), sffxs{}, []operand.Op{i, mx, x})
}

// VPCMPQ: Compare Packed Signed Quadword Values.
//
// Forms:
//
//	VPCMPQ imm8 m128 xmm k k
//	VPCMPQ imm8 m128 xmm k
//	VPCMPQ imm8 m256 ymm k k
//	VPCMPQ imm8 m256 ymm k
//	VPCMPQ imm8 xmm  xmm k k
//	VPCMPQ imm8 xmm  xmm k
//	VPCMPQ imm8 ymm  ymm k k
//	VPCMPQ imm8 ymm  ymm k
//	VPCMPQ imm8 m512 zmm k k
//	VPCMPQ imm8 m512 zmm k
//	VPCMPQ imm8 zmm  zmm k k
//	VPCMPQ imm8 zmm  zmm k
func VPCMPQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPQ.Forms(), sffxs{}, ops)
}

// VPCMPQ_BCST: Compare Packed Signed Quadword Values (Broadcast).
//
// Forms:
//
//	VPCMPQ.BCST imm8 m64 xmm k k
//	VPCMPQ.BCST imm8 m64 xmm k
//	VPCMPQ.BCST imm8 m64 ymm k k
//	VPCMPQ.BCST imm8 m64 ymm k
//	VPCMPQ.BCST imm8 m64 zmm k k
//	VPCMPQ.BCST imm8 m64 zmm k
func VPCMPQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPCMPUB: Compare Packed Unsigned Byte Values.
//
// Forms:
//
//	VPCMPUB imm8 m128 xmm k k
//	VPCMPUB imm8 m128 xmm k
//	VPCMPUB imm8 m256 ymm k k
//	VPCMPUB imm8 m256 ymm k
//	VPCMPUB imm8 xmm  xmm k k
//	VPCMPUB imm8 xmm  xmm k
//	VPCMPUB imm8 ymm  ymm k k
//	VPCMPUB imm8 ymm  ymm k
//	VPCMPUB imm8 m512 zmm k k
//	VPCMPUB imm8 m512 zmm k
//	VPCMPUB imm8 zmm  zmm k k
//	VPCMPUB imm8 zmm  zmm k
func VPCMPUB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPUB.Forms(), sffxs{}, ops)
}

// VPCMPUD: Compare Packed Unsigned Doubleword Values.
//
// Forms:
//
//	VPCMPUD imm8 m128 xmm k k
//	VPCMPUD imm8 m128 xmm k
//	VPCMPUD imm8 m256 ymm k k
//	VPCMPUD imm8 m256 ymm k
//	VPCMPUD imm8 xmm  xmm k k
//	VPCMPUD imm8 xmm  xmm k
//	VPCMPUD imm8 ymm  ymm k k
//	VPCMPUD imm8 ymm  ymm k
//	VPCMPUD imm8 m512 zmm k k
//	VPCMPUD imm8 m512 zmm k
//	VPCMPUD imm8 zmm  zmm k k
//	VPCMPUD imm8 zmm  zmm k
func VPCMPUD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPUD.Forms(), sffxs{}, ops)
}

// VPCMPUD_BCST: Compare Packed Unsigned Doubleword Values (Broadcast).
//
// Forms:
//
//	VPCMPUD.BCST imm8 m32 xmm k k
//	VPCMPUD.BCST imm8 m32 xmm k
//	VPCMPUD.BCST imm8 m32 ymm k k
//	VPCMPUD.BCST imm8 m32 ymm k
//	VPCMPUD.BCST imm8 m32 zmm k k
//	VPCMPUD.BCST imm8 m32 zmm k
func VPCMPUD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPUD.Forms(), sffxs{sffxBCST}, ops)
}

// VPCMPUQ: Compare Packed Unsigned Quadword Values.
//
// Forms:
//
//	VPCMPUQ imm8 m128 xmm k k
//	VPCMPUQ imm8 m128 xmm k
//	VPCMPUQ imm8 m256 ymm k k
//	VPCMPUQ imm8 m256 ymm k
//	VPCMPUQ imm8 xmm  xmm k k
//	VPCMPUQ imm8 xmm  xmm k
//	VPCMPUQ imm8 ymm  ymm k k
//	VPCMPUQ imm8 ymm  ymm k
//	VPCMPUQ imm8 m512 zmm k k
//	VPCMPUQ imm8 m512 zmm k
//	VPCMPUQ imm8 zmm  zmm k k
//	VPCMPUQ imm8 zmm  zmm k
func VPCMPUQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPUQ.Forms(), sffxs{}, ops)
}

// VPCMPUQ_BCST: Compare Packed Unsigned Quadword Values (Broadcast).
//
// Forms:
//
//	VPCMPUQ.BCST imm8 m64 xmm k k
//	VPCMPUQ.BCST imm8 m64 xmm k
//	VPCMPUQ.BCST imm8 m64 ymm k k
//	VPCMPUQ.BCST imm8 m64 ymm k
//	VPCMPUQ.BCST imm8 m64 zmm k k
//	VPCMPUQ.BCST imm8 m64 zmm k
func VPCMPUQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPUQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPCMPUW: Compare Packed Unsigned Word Values.
//
// Forms:
//
//	VPCMPUW imm8 m128 xmm k k
//	VPCMPUW imm8 m128 xmm k
//	VPCMPUW imm8 m256 ymm k k
//	VPCMPUW imm8 m256 ymm k
//	VPCMPUW imm8 xmm  xmm k k
//	VPCMPUW imm8 xmm  xmm k
//	VPCMPUW imm8 ymm  ymm k k
//	VPCMPUW imm8 ymm  ymm k
//	VPCMPUW imm8 m512 zmm k k
//	VPCMPUW imm8 m512 zmm k
//	VPCMPUW imm8 zmm  zmm k k
//	VPCMPUW imm8 zmm  zmm k
func VPCMPUW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPUW.Forms(), sffxs{}, ops)
}

// VPCMPW: Compare Packed Signed Word Values.
//
// Forms:
//
//	VPCMPW imm8 m128 xmm k k
//	VPCMPW imm8 m128 xmm k
//	VPCMPW imm8 m256 ymm k k
//	VPCMPW imm8 m256 ymm k
//	VPCMPW imm8 xmm  xmm k k
//	VPCMPW imm8 xmm  xmm k
//	VPCMPW imm8 ymm  ymm k k
//	VPCMPW imm8 ymm  ymm k
//	VPCMPW imm8 m512 zmm k k
//	VPCMPW imm8 m512 zmm k
//	VPCMPW imm8 zmm  zmm k k
//	VPCMPW imm8 zmm  zmm k
func VPCMPW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCMPW.Forms(), sffxs{}, ops)
}

// VPCOMPRESSB: Store Sparse Packed Byte Integer Values into Dense Memory/Register.
//
// Forms:
//
//	VPCOMPRESSB xmm k m128
//	VPCOMPRESSB xmm k xmm
//	VPCOMPRESSB xmm m128
//	VPCOMPRESSB xmm xmm
//	VPCOMPRESSB ymm k m256
//	VPCOMPRESSB ymm k ymm
//	VPCOMPRESSB ymm m256
//	VPCOMPRESSB ymm ymm
//	VPCOMPRESSB zmm k m512
//	VPCOMPRESSB zmm k zmm
//	VPCOMPRESSB zmm m512
//	VPCOMPRESSB zmm zmm
func VPCOMPRESSB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCOMPRESSB.Forms(), sffxs{}, ops)
}

// VPCOMPRESSB_Z: Store Sparse Packed Byte Integer Values into Dense Memory/Register (Zeroing Masking).
//
// Forms:
//
//	VPCOMPRESSB.Z xmm k xmm
//	VPCOMPRESSB.Z ymm k ymm
//	VPCOMPRESSB.Z zmm k zmm
func VPCOMPRESSB_Z(xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCOMPRESSB.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, xyz1})
}

// VPCOMPRESSD: Store Sparse Packed Doubleword Integer Values into Dense Memory/Register.
//
// Forms:
//
//	VPCOMPRESSD xmm k m128
//	VPCOMPRESSD xmm k xmm
//	VPCOMPRESSD xmm m128
//	VPCOMPRESSD xmm xmm
//	VPCOMPRESSD ymm k m256
//	VPCOMPRESSD ymm k ymm
//	VPCOMPRESSD ymm m256
//	VPCOMPRESSD ymm ymm
//	VPCOMPRESSD zmm k m512
//	VPCOMPRESSD zmm k zmm
//	VPCOMPRESSD zmm m512
//	VPCOMPRESSD zmm zmm
func VPCOMPRESSD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCOMPRESSD.Forms(), sffxs{}, ops)
}

// VPCOMPRESSD_Z: Store Sparse Packed Doubleword Integer Values into Dense Memory/Register (Zeroing Masking).
//
// Forms:
//
//	VPCOMPRESSD.Z xmm k m128
//	VPCOMPRESSD.Z xmm k xmm
//	VPCOMPRESSD.Z ymm k m256
//	VPCOMPRESSD.Z ymm k ymm
//	VPCOMPRESSD.Z zmm k m512
//	VPCOMPRESSD.Z zmm k zmm
func VPCOMPRESSD_Z(xyz, k, mxyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCOMPRESSD.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mxyz})
}

// VPCOMPRESSQ: Store Sparse Packed Quadword Integer Values into Dense Memory/Register.
//
// Forms:
//
//	VPCOMPRESSQ xmm k m128
//	VPCOMPRESSQ xmm k xmm
//	VPCOMPRESSQ xmm m128
//	VPCOMPRESSQ xmm xmm
//	VPCOMPRESSQ ymm k m256
//	VPCOMPRESSQ ymm k ymm
//	VPCOMPRESSQ ymm m256
//	VPCOMPRESSQ ymm ymm
//	VPCOMPRESSQ zmm k m512
//	VPCOMPRESSQ zmm k zmm
//	VPCOMPRESSQ zmm m512
//	VPCOMPRESSQ zmm zmm
func VPCOMPRESSQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCOMPRESSQ.Forms(), sffxs{}, ops)
}

// VPCOMPRESSQ_Z: Store Sparse Packed Quadword Integer Values into Dense Memory/Register (Zeroing Masking).
//
// Forms:
//
//	VPCOMPRESSQ.Z xmm k m128
//	VPCOMPRESSQ.Z xmm k xmm
//	VPCOMPRESSQ.Z ymm k m256
//	VPCOMPRESSQ.Z ymm k ymm
//	VPCOMPRESSQ.Z zmm k m512
//	VPCOMPRESSQ.Z zmm k zmm
func VPCOMPRESSQ_Z(xyz, k, mxyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCOMPRESSQ.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mxyz})
}

// VPCOMPRESSW: Store Sparse Packed Word Integer Values into Dense Memory/Register.
//
// Forms:
//
//	VPCOMPRESSW xmm k m128
//	VPCOMPRESSW xmm k xmm
//	VPCOMPRESSW xmm m128
//	VPCOMPRESSW xmm xmm
//	VPCOMPRESSW ymm k m256
//	VPCOMPRESSW ymm k ymm
//	VPCOMPRESSW ymm m256
//	VPCOMPRESSW ymm ymm
//	VPCOMPRESSW zmm k m512
//	VPCOMPRESSW zmm k zmm
//	VPCOMPRESSW zmm m512
//	VPCOMPRESSW zmm zmm
func VPCOMPRESSW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCOMPRESSW.Forms(), sffxs{}, ops)
}

// VPCOMPRESSW_Z: Store Sparse Packed Word Integer Values into Dense Memory/Register (Zeroing Masking).
//
// Forms:
//
//	VPCOMPRESSW.Z xmm k xmm
//	VPCOMPRESSW.Z ymm k ymm
//	VPCOMPRESSW.Z zmm k zmm
func VPCOMPRESSW_Z(xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCOMPRESSW.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, xyz1})
}

// VPCONFLICTD: Detect Conflicts Within a Vector of Packed Doubleword Values into Dense Memory/Register.
//
// Forms:
//
//	VPCONFLICTD m128 k xmm
//	VPCONFLICTD m128 xmm
//	VPCONFLICTD m256 k ymm
//	VPCONFLICTD m256 ymm
//	VPCONFLICTD xmm  k xmm
//	VPCONFLICTD xmm  xmm
//	VPCONFLICTD ymm  k ymm
//	VPCONFLICTD ymm  ymm
//	VPCONFLICTD m512 k zmm
//	VPCONFLICTD m512 zmm
//	VPCONFLICTD zmm  k zmm
//	VPCONFLICTD zmm  zmm
func VPCONFLICTD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCONFLICTD.Forms(), sffxs{}, ops)
}

// VPCONFLICTD_BCST: Detect Conflicts Within a Vector of Packed Doubleword Values into Dense Memory/Register (Broadcast).
//
// Forms:
//
//	VPCONFLICTD.BCST m32 k xmm
//	VPCONFLICTD.BCST m32 k ymm
//	VPCONFLICTD.BCST m32 xmm
//	VPCONFLICTD.BCST m32 ymm
//	VPCONFLICTD.BCST m32 k zmm
//	VPCONFLICTD.BCST m32 zmm
func VPCONFLICTD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCONFLICTD.Forms(), sffxs{sffxBCST}, ops)
}

// VPCONFLICTD_BCST_Z: Detect Conflicts Within a Vector of Packed Doubleword Values into Dense Memory/Register (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPCONFLICTD.BCST.Z m32 k xmm
//	VPCONFLICTD.BCST.Z m32 k ymm
//	VPCONFLICTD.BCST.Z m32 k zmm
func VPCONFLICTD_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCONFLICTD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VPCONFLICTD_Z: Detect Conflicts Within a Vector of Packed Doubleword Values into Dense Memory/Register (Zeroing Masking).
//
// Forms:
//
//	VPCONFLICTD.Z m128 k xmm
//	VPCONFLICTD.Z m256 k ymm
//	VPCONFLICTD.Z xmm  k xmm
//	VPCONFLICTD.Z ymm  k ymm
//	VPCONFLICTD.Z m512 k zmm
//	VPCONFLICTD.Z zmm  k zmm
func VPCONFLICTD_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCONFLICTD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VPCONFLICTQ: Detect Conflicts Within a Vector of Packed Quadword Values into Dense Memory/Register.
//
// Forms:
//
//	VPCONFLICTQ m128 k xmm
//	VPCONFLICTQ m128 xmm
//	VPCONFLICTQ m256 k ymm
//	VPCONFLICTQ m256 ymm
//	VPCONFLICTQ xmm  k xmm
//	VPCONFLICTQ xmm  xmm
//	VPCONFLICTQ ymm  k ymm
//	VPCONFLICTQ ymm  ymm
//	VPCONFLICTQ m512 k zmm
//	VPCONFLICTQ m512 zmm
//	VPCONFLICTQ zmm  k zmm
//	VPCONFLICTQ zmm  zmm
func VPCONFLICTQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCONFLICTQ.Forms(), sffxs{}, ops)
}

// VPCONFLICTQ_BCST: Detect Conflicts Within a Vector of Packed Quadword Values into Dense Memory/Register (Broadcast).
//
// Forms:
//
//	VPCONFLICTQ.BCST m64 k xmm
//	VPCONFLICTQ.BCST m64 k ymm
//	VPCONFLICTQ.BCST m64 xmm
//	VPCONFLICTQ.BCST m64 ymm
//	VPCONFLICTQ.BCST m64 k zmm
//	VPCONFLICTQ.BCST m64 zmm
func VPCONFLICTQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCONFLICTQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPCONFLICTQ_BCST_Z: Detect Conflicts Within a Vector of Packed Quadword Values into Dense Memory/Register (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPCONFLICTQ.BCST.Z m64 k xmm
//	VPCONFLICTQ.BCST.Z m64 k ymm
//	VPCONFLICTQ.BCST.Z m64 k zmm
func VPCONFLICTQ_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCONFLICTQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VPCONFLICTQ_Z: Detect Conflicts Within a Vector of Packed Quadword Values into Dense Memory/Register (Zeroing Masking).
//
// Forms:
//
//	VPCONFLICTQ.Z m128 k xmm
//	VPCONFLICTQ.Z m256 k ymm
//	VPCONFLICTQ.Z xmm  k xmm
//	VPCONFLICTQ.Z ymm  k ymm
//	VPCONFLICTQ.Z m512 k zmm
//	VPCONFLICTQ.Z zmm  k zmm
func VPCONFLICTQ_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPCONFLICTQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VPDPBUSD: Multiply and Add Unsigned and Signed Bytes.
//
// Forms:
//
//	VPDPBUSD m128 xmm k xmm
//	VPDPBUSD m128 xmm xmm
//	VPDPBUSD m256 ymm k ymm
//	VPDPBUSD m256 ymm ymm
//	VPDPBUSD xmm  xmm k xmm
//	VPDPBUSD xmm  xmm xmm
//	VPDPBUSD ymm  ymm k ymm
//	VPDPBUSD ymm  ymm ymm
//	VPDPBUSD m512 zmm k zmm
//	VPDPBUSD m512 zmm zmm
//	VPDPBUSD zmm  zmm k zmm
//	VPDPBUSD zmm  zmm zmm
func VPDPBUSD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPDPBUSD.Forms(), sffxs{}, ops)
}

// VPDPBUSDS: Multiply and Add Unsigned and Signed Bytes with Saturation.
//
// Forms:
//
//	VPDPBUSDS m128 xmm k xmm
//	VPDPBUSDS m128 xmm xmm
//	VPDPBUSDS m256 ymm k ymm
//	VPDPBUSDS m256 ymm ymm
//	VPDPBUSDS xmm  xmm k xmm
//	VPDPBUSDS xmm  xmm xmm
//	VPDPBUSDS ymm  ymm k ymm
//	VPDPBUSDS ymm  ymm ymm
//	VPDPBUSDS m512 zmm k zmm
//	VPDPBUSDS m512 zmm zmm
//	VPDPBUSDS zmm  zmm k zmm
//	VPDPBUSDS zmm  zmm zmm
func VPDPBUSDS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPDPBUSDS.Forms(), sffxs{}, ops)
}

// VPDPBUSDS_BCST: Multiply and Add Unsigned and Signed Bytes with Saturation (Broadcast).
//
// Forms:
//
//	VPDPBUSDS.BCST m32 xmm k xmm
//	VPDPBUSDS.BCST m32 xmm xmm
//	VPDPBUSDS.BCST m32 ymm k ymm
//	VPDPBUSDS.BCST m32 ymm ymm
//	VPDPBUSDS.BCST m32 zmm k zmm
//	VPDPBUSDS.BCST m32 zmm zmm
func VPDPBUSDS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPDPBUSDS.Forms(), sffxs{sffxBCST}, ops)
}

// VPDPBUSDS_BCST_Z: Multiply and Add Unsigned and Signed Bytes with Saturation (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPDPBUSDS.BCST.Z m32 xmm k xmm
//	VPDPBUSDS.BCST.Z m32 ymm k ymm
//	VPDPBUSDS.BCST.Z m32 zmm k zmm
func VPDPBUSDS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPDPBUSDS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPDPBUSDS_Z: Multiply and Add Unsigned and Signed Bytes with Saturation (Zeroing Masking).
//
// Forms:
//
//	VPDPBUSDS.Z m128 xmm k xmm
//	VPDPBUSDS.Z m256 ymm k ymm
//	VPDPBUSDS.Z xmm  xmm k xmm
//	VPDPBUSDS.Z ymm  ymm k ymm
//	VPDPBUSDS.Z m512 zmm k zmm
//	VPDPBUSDS.Z zmm  zmm k zmm
func VPDPBUSDS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPDPBUSDS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPDPBUSD_BCST: Multiply and Add Unsigned and Signed Bytes (Broadcast).
//
// Forms:
//
//	VPDPBUSD.BCST m32 xmm k xmm
//	VPDPBUSD.BCST m32 xmm xmm
//	VPDPBUSD.BCST m32 ymm k ymm
//	VPDPBUSD.BCST m32 ymm ymm
//	VPDPBUSD.BCST m32 zmm k zmm
//	VPDPBUSD.BCST m32 zmm zmm
func VPDPBUSD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPDPBUSD.Forms(), sffxs{sffxBCST}, ops)
}

// VPDPBUSD_BCST_Z: Multiply and Add Unsigned and Signed Bytes (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPDPBUSD.BCST.Z m32 xmm k xmm
//	VPDPBUSD.BCST.Z m32 ymm k ymm
//	VPDPBUSD.BCST.Z m32 zmm k zmm
func VPDPBUSD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPDPBUSD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPDPBUSD_Z: Multiply and Add Unsigned and Signed Bytes (Zeroing Masking).
//
// Forms:
//
//	VPDPBUSD.Z m128 xmm k xmm
//	VPDPBUSD.Z m256 ymm k ymm
//	VPDPBUSD.Z xmm  xmm k xmm
//	VPDPBUSD.Z ymm  ymm k ymm
//	VPDPBUSD.Z m512 zmm k zmm
//	VPDPBUSD.Z zmm  zmm k zmm
func VPDPBUSD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPDPBUSD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPDPWSSD: Multiply and Add Signed Word Integers.
//
// Forms:
//
//	VPDPWSSD m128 xmm k xmm
//	VPDPWSSD m128 xmm xmm
//	VPDPWSSD m256 ymm k ymm
//	VPDPWSSD m256 ymm ymm
//	VPDPWSSD xmm  xmm k xmm
//	VPDPWSSD xmm  xmm xmm
//	VPDPWSSD ymm  ymm k ymm
//	VPDPWSSD ymm  ymm ymm
//	VPDPWSSD m512 zmm k zmm
//	VPDPWSSD m512 zmm zmm
//	VPDPWSSD zmm  zmm k zmm
//	VPDPWSSD zmm  zmm zmm
func VPDPWSSD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPDPWSSD.Forms(), sffxs{}, ops)
}

// VPDPWSSDS: Multiply and Add Signed Word Integers with Saturation.
//
// Forms:
//
//	VPDPWSSDS m128 xmm k xmm
//	VPDPWSSDS m128 xmm xmm
//	VPDPWSSDS m256 ymm k ymm
//	VPDPWSSDS m256 ymm ymm
//	VPDPWSSDS xmm  xmm k xmm
//	VPDPWSSDS xmm  xmm xmm
//	VPDPWSSDS ymm  ymm k ymm
//	VPDPWSSDS ymm  ymm ymm
//	VPDPWSSDS m512 zmm k zmm
//	VPDPWSSDS m512 zmm zmm
//	VPDPWSSDS zmm  zmm k zmm
//	VPDPWSSDS zmm  zmm zmm
func VPDPWSSDS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPDPWSSDS.Forms(), sffxs{}, ops)
}

// VPDPWSSDS_BCST: Multiply and Add Signed Word Integers with Saturation (Broadcast).
//
// Forms:
//
//	VPDPWSSDS.BCST m32 xmm k xmm
//	VPDPWSSDS.BCST m32 xmm xmm
//	VPDPWSSDS.BCST m32 ymm k ymm
//	VPDPWSSDS.BCST m32 ymm ymm
//	VPDPWSSDS.BCST m32 zmm k zmm
//	VPDPWSSDS.BCST m32 zmm zmm
func VPDPWSSDS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPDPWSSDS.Forms(), sffxs{sffxBCST}, ops)
}

// VPDPWSSDS_BCST_Z: Multiply and Add Signed Word Integers with Saturation (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPDPWSSDS.BCST.Z m32 xmm k xmm
//	VPDPWSSDS.BCST.Z m32 ymm k ymm
//	VPDPWSSDS.BCST.Z m32 zmm k zmm
func VPDPWSSDS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPDPWSSDS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPDPWSSDS_Z: Multiply and Add Signed Word Integers with Saturation (Zeroing Masking).
//
// Forms:
//
//	VPDPWSSDS.Z m128 xmm k xmm
//	VPDPWSSDS.Z m256 ymm k ymm
//	VPDPWSSDS.Z xmm  xmm k xmm
//	VPDPWSSDS.Z ymm  ymm k ymm
//	VPDPWSSDS.Z m512 zmm k zmm
//	VPDPWSSDS.Z zmm  zmm k zmm
func VPDPWSSDS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPDPWSSDS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPDPWSSD_BCST: Multiply and Add Signed Word Integers (Broadcast).
//
// Forms:
//
//	VPDPWSSD.BCST m32 xmm k xmm
//	VPDPWSSD.BCST m32 xmm xmm
//	VPDPWSSD.BCST m32 ymm k ymm
//	VPDPWSSD.BCST m32 ymm ymm
//	VPDPWSSD.BCST m32 zmm k zmm
//	VPDPWSSD.BCST m32 zmm zmm
func VPDPWSSD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPDPWSSD.Forms(), sffxs{sffxBCST}, ops)
}

// VPDPWSSD_BCST_Z: Multiply and Add Signed Word Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPDPWSSD.BCST.Z m32 xmm k xmm
//	VPDPWSSD.BCST.Z m32 ymm k ymm
//	VPDPWSSD.BCST.Z m32 zmm k zmm
func VPDPWSSD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPDPWSSD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPDPWSSD_Z: Multiply and Add Signed Word Integers (Zeroing Masking).
//
// Forms:
//
//	VPDPWSSD.Z m128 xmm k xmm
//	VPDPWSSD.Z m256 ymm k ymm
//	VPDPWSSD.Z xmm  xmm k xmm
//	VPDPWSSD.Z ymm  ymm k ymm
//	VPDPWSSD.Z m512 zmm k zmm
//	VPDPWSSD.Z zmm  zmm k zmm
func VPDPWSSD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPDPWSSD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPERM2F128: Permute Floating-Point Values.
//
// Forms:
//
//	VPERM2F128 imm8 m256 ymm ymm
//	VPERM2F128 imm8 ymm  ymm ymm
func VPERM2F128(i, my, y, y1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERM2F128.Forms(), sffxs{}, []operand.Op{i, my, y, y1})
}

// VPERM2I128: Permute 128-Bit Integer Values.
//
// Forms:
//
//	VPERM2I128 imm8 m256 ymm ymm
//	VPERM2I128 imm8 ymm  ymm ymm
func VPERM2I128(i, my, y, y1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERM2I128.Forms(), sffxs{}, []operand.Op{i, my, y, y1})
}

// VPERMB: Permute Byte Integers.
//
// Forms:
//
//	VPERMB m128 xmm k xmm
//	VPERMB m128 xmm xmm
//	VPERMB m256 ymm k ymm
//	VPERMB m256 ymm ymm
//	VPERMB xmm  xmm k xmm
//	VPERMB xmm  xmm xmm
//	VPERMB ymm  ymm k ymm
//	VPERMB ymm  ymm ymm
//	VPERMB m512 zmm k zmm
//	VPERMB m512 zmm zmm
//	VPERMB zmm  zmm k zmm
//	VPERMB zmm  zmm zmm
func VPERMB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMB.Forms(), sffxs{}, ops)
}

// VPERMB_Z: Permute Byte Integers (Zeroing Masking).
//
// Forms:
//
//	VPERMB.Z m128 xmm k xmm
//	VPERMB.Z m256 ymm k ymm
//	VPERMB.Z xmm  xmm k xmm
//	VPERMB.Z ymm  ymm k ymm
//	VPERMB.Z m512 zmm k zmm
//	VPERMB.Z zmm  zmm k zmm
func VPERMB_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMB.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPERMD: Permute Doubleword Integers.
//
// Forms:
//
//	VPERMD m256 ymm ymm
//	VPERMD ymm  ymm ymm
//	VPERMD m256 ymm k ymm
//	VPERMD ymm  ymm k ymm
//	VPERMD m512 zmm k zmm
//	VPERMD m512 zmm zmm
//	VPERMD zmm  zmm k zmm
//	VPERMD zmm  zmm zmm
func VPERMD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMD.Forms(), sffxs{}, ops)
}

// VPERMD_BCST: Permute Doubleword Integers (Broadcast).
//
// Forms:
//
//	VPERMD.BCST m32 ymm k ymm
//	VPERMD.BCST m32 ymm ymm
//	VPERMD.BCST m32 zmm k zmm
//	VPERMD.BCST m32 zmm zmm
func VPERMD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMD.Forms(), sffxs{sffxBCST}, ops)
}

// VPERMD_BCST_Z: Permute Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPERMD.BCST.Z m32 ymm k ymm
//	VPERMD.BCST.Z m32 zmm k zmm
func VPERMD_BCST_Z(m, yz, k, yz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, yz, k, yz1})
}

// VPERMD_Z: Permute Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VPERMD.Z m256 ymm k ymm
//	VPERMD.Z ymm  ymm k ymm
//	VPERMD.Z m512 zmm k zmm
//	VPERMD.Z zmm  zmm k zmm
func VPERMD_Z(myz, yz, k, yz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMD.Forms(), sffxs{sffxZ}, []operand.Op{myz, yz, k, yz1})
}

// VPERMI2B: Full Permute of Bytes From Two Tables Overwriting the Index.
//
// Forms:
//
//	VPERMI2B m128 xmm k xmm
//	VPERMI2B m128 xmm xmm
//	VPERMI2B m256 ymm k ymm
//	VPERMI2B m256 ymm ymm
//	VPERMI2B xmm  xmm k xmm
//	VPERMI2B xmm  xmm xmm
//	VPERMI2B ymm  ymm k ymm
//	VPERMI2B ymm  ymm ymm
//	VPERMI2B m512 zmm k zmm
//	VPERMI2B m512 zmm zmm
//	VPERMI2B zmm  zmm k zmm
//	VPERMI2B zmm  zmm zmm
func VPERMI2B(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMI2B.Forms(), sffxs{}, ops)
}

// VPERMI2B_Z: Full Permute of Bytes From Two Tables Overwriting the Index (Zeroing Masking).
//
// Forms:
//
//	VPERMI2B.Z m128 xmm k xmm
//	VPERMI2B.Z m256 ymm k ymm
//	VPERMI2B.Z xmm  xmm k xmm
//	VPERMI2B.Z ymm  ymm k ymm
//	VPERMI2B.Z m512 zmm k zmm
//	VPERMI2B.Z zmm  zmm k zmm
func VPERMI2B_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMI2B.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPERMI2D: Full Permute of Doublewords From Two Tables Overwriting the Index.
//
// Forms:
//
//	VPERMI2D m128 xmm k xmm
//	VPERMI2D m128 xmm xmm
//	VPERMI2D m256 ymm k ymm
//	VPERMI2D m256 ymm ymm
//	VPERMI2D xmm  xmm k xmm
//	VPERMI2D xmm  xmm xmm
//	VPERMI2D ymm  ymm k ymm
//	VPERMI2D ymm  ymm ymm
//	VPERMI2D m512 zmm k zmm
//	VPERMI2D m512 zmm zmm
//	VPERMI2D zmm  zmm k zmm
//	VPERMI2D zmm  zmm zmm
func VPERMI2D(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMI2D.Forms(), sffxs{}, ops)
}

// VPERMI2D_BCST: Full Permute of Doublewords From Two Tables Overwriting the Index (Broadcast).
//
// Forms:
//
//	VPERMI2D.BCST m32 xmm k xmm
//	VPERMI2D.BCST m32 xmm xmm
//	VPERMI2D.BCST m32 ymm k ymm
//	VPERMI2D.BCST m32 ymm ymm
//	VPERMI2D.BCST m32 zmm k zmm
//	VPERMI2D.BCST m32 zmm zmm
func VPERMI2D_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMI2D.Forms(), sffxs{sffxBCST}, ops)
}

// VPERMI2D_BCST_Z: Full Permute of Doublewords From Two Tables Overwriting the Index (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPERMI2D.BCST.Z m32 xmm k xmm
//	VPERMI2D.BCST.Z m32 ymm k ymm
//	VPERMI2D.BCST.Z m32 zmm k zmm
func VPERMI2D_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMI2D.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPERMI2D_Z: Full Permute of Doublewords From Two Tables Overwriting the Index (Zeroing Masking).
//
// Forms:
//
//	VPERMI2D.Z m128 xmm k xmm
//	VPERMI2D.Z m256 ymm k ymm
//	VPERMI2D.Z xmm  xmm k xmm
//	VPERMI2D.Z ymm  ymm k ymm
//	VPERMI2D.Z m512 zmm k zmm
//	VPERMI2D.Z zmm  zmm k zmm
func VPERMI2D_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMI2D.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPERMI2PD: Full Permute of Double-Precision Floating-Point Values From Two Tables Overwriting the Index.
//
// Forms:
//
//	VPERMI2PD m128 xmm k xmm
//	VPERMI2PD m128 xmm xmm
//	VPERMI2PD m256 ymm k ymm
//	VPERMI2PD m256 ymm ymm
//	VPERMI2PD xmm  xmm k xmm
//	VPERMI2PD xmm  xmm xmm
//	VPERMI2PD ymm  ymm k ymm
//	VPERMI2PD ymm  ymm ymm
//	VPERMI2PD m512 zmm k zmm
//	VPERMI2PD m512 zmm zmm
//	VPERMI2PD zmm  zmm k zmm
//	VPERMI2PD zmm  zmm zmm
func VPERMI2PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMI2PD.Forms(), sffxs{}, ops)
}

// VPERMI2PD_BCST: Full Permute of Double-Precision Floating-Point Values From Two Tables Overwriting the Index (Broadcast).
//
// Forms:
//
//	VPERMI2PD.BCST m64 xmm k xmm
//	VPERMI2PD.BCST m64 xmm xmm
//	VPERMI2PD.BCST m64 ymm k ymm
//	VPERMI2PD.BCST m64 ymm ymm
//	VPERMI2PD.BCST m64 zmm k zmm
//	VPERMI2PD.BCST m64 zmm zmm
func VPERMI2PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMI2PD.Forms(), sffxs{sffxBCST}, ops)
}

// VPERMI2PD_BCST_Z: Full Permute of Double-Precision Floating-Point Values From Two Tables Overwriting the Index (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPERMI2PD.BCST.Z m64 xmm k xmm
//	VPERMI2PD.BCST.Z m64 ymm k ymm
//	VPERMI2PD.BCST.Z m64 zmm k zmm
func VPERMI2PD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMI2PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPERMI2PD_Z: Full Permute of Double-Precision Floating-Point Values From Two Tables Overwriting the Index (Zeroing Masking).
//
// Forms:
//
//	VPERMI2PD.Z m128 xmm k xmm
//	VPERMI2PD.Z m256 ymm k ymm
//	VPERMI2PD.Z xmm  xmm k xmm
//	VPERMI2PD.Z ymm  ymm k ymm
//	VPERMI2PD.Z m512 zmm k zmm
//	VPERMI2PD.Z zmm  zmm k zmm
func VPERMI2PD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMI2PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPERMI2PS: Full Permute of Single-Precision Floating-Point Values From Two Tables Overwriting the Index.
//
// Forms:
//
//	VPERMI2PS m128 xmm k xmm
//	VPERMI2PS m128 xmm xmm
//	VPERMI2PS m256 ymm k ymm
//	VPERMI2PS m256 ymm ymm
//	VPERMI2PS xmm  xmm k xmm
//	VPERMI2PS xmm  xmm xmm
//	VPERMI2PS ymm  ymm k ymm
//	VPERMI2PS ymm  ymm ymm
//	VPERMI2PS m512 zmm k zmm
//	VPERMI2PS m512 zmm zmm
//	VPERMI2PS zmm  zmm k zmm
//	VPERMI2PS zmm  zmm zmm
func VPERMI2PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMI2PS.Forms(), sffxs{}, ops)
}

// VPERMI2PS_BCST: Full Permute of Single-Precision Floating-Point Values From Two Tables Overwriting the Index (Broadcast).
//
// Forms:
//
//	VPERMI2PS.BCST m32 xmm k xmm
//	VPERMI2PS.BCST m32 xmm xmm
//	VPERMI2PS.BCST m32 ymm k ymm
//	VPERMI2PS.BCST m32 ymm ymm
//	VPERMI2PS.BCST m32 zmm k zmm
//	VPERMI2PS.BCST m32 zmm zmm
func VPERMI2PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMI2PS.Forms(), sffxs{sffxBCST}, ops)
}

// VPERMI2PS_BCST_Z: Full Permute of Single-Precision Floating-Point Values From Two Tables Overwriting the Index (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPERMI2PS.BCST.Z m32 xmm k xmm
//	VPERMI2PS.BCST.Z m32 ymm k ymm
//	VPERMI2PS.BCST.Z m32 zmm k zmm
func VPERMI2PS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMI2PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPERMI2PS_Z: Full Permute of Single-Precision Floating-Point Values From Two Tables Overwriting the Index (Zeroing Masking).
//
// Forms:
//
//	VPERMI2PS.Z m128 xmm k xmm
//	VPERMI2PS.Z m256 ymm k ymm
//	VPERMI2PS.Z xmm  xmm k xmm
//	VPERMI2PS.Z ymm  ymm k ymm
//	VPERMI2PS.Z m512 zmm k zmm
//	VPERMI2PS.Z zmm  zmm k zmm
func VPERMI2PS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMI2PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPERMI2Q: Full Permute of Quadwords From Two Tables Overwriting the Index.
//
// Forms:
//
//	VPERMI2Q m128 xmm k xmm
//	VPERMI2Q m128 xmm xmm
//	VPERMI2Q m256 ymm k ymm
//	VPERMI2Q m256 ymm ymm
//	VPERMI2Q xmm  xmm k xmm
//	VPERMI2Q xmm  xmm xmm
//	VPERMI2Q ymm  ymm k ymm
//	VPERMI2Q ymm  ymm ymm
//	VPERMI2Q m512 zmm k zmm
//	VPERMI2Q m512 zmm zmm
//	VPERMI2Q zmm  zmm k zmm
//	VPERMI2Q zmm  zmm zmm
func VPERMI2Q(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMI2Q.Forms(), sffxs{}, ops)
}

// VPERMI2Q_BCST: Full Permute of Quadwords From Two Tables Overwriting the Index (Broadcast).
//
// Forms:
//
//	VPERMI2Q.BCST m64 xmm k xmm
//	VPERMI2Q.BCST m64 xmm xmm
//	VPERMI2Q.BCST m64 ymm k ymm
//	VPERMI2Q.BCST m64 ymm ymm
//	VPERMI2Q.BCST m64 zmm k zmm
//	VPERMI2Q.BCST m64 zmm zmm
func VPERMI2Q_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMI2Q.Forms(), sffxs{sffxBCST}, ops)
}

// VPERMI2Q_BCST_Z: Full Permute of Quadwords From Two Tables Overwriting the Index (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPERMI2Q.BCST.Z m64 xmm k xmm
//	VPERMI2Q.BCST.Z m64 ymm k ymm
//	VPERMI2Q.BCST.Z m64 zmm k zmm
func VPERMI2Q_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMI2Q.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPERMI2Q_Z: Full Permute of Quadwords From Two Tables Overwriting the Index (Zeroing Masking).
//
// Forms:
//
//	VPERMI2Q.Z m128 xmm k xmm
//	VPERMI2Q.Z m256 ymm k ymm
//	VPERMI2Q.Z xmm  xmm k xmm
//	VPERMI2Q.Z ymm  ymm k ymm
//	VPERMI2Q.Z m512 zmm k zmm
//	VPERMI2Q.Z zmm  zmm k zmm
func VPERMI2Q_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMI2Q.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPERMI2W: Full Permute of Words From Two Tables Overwriting the Index.
//
// Forms:
//
//	VPERMI2W m128 xmm k xmm
//	VPERMI2W m128 xmm xmm
//	VPERMI2W m256 ymm k ymm
//	VPERMI2W m256 ymm ymm
//	VPERMI2W xmm  xmm k xmm
//	VPERMI2W xmm  xmm xmm
//	VPERMI2W ymm  ymm k ymm
//	VPERMI2W ymm  ymm ymm
//	VPERMI2W m512 zmm k zmm
//	VPERMI2W m512 zmm zmm
//	VPERMI2W zmm  zmm k zmm
//	VPERMI2W zmm  zmm zmm
func VPERMI2W(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMI2W.Forms(), sffxs{}, ops)
}

// VPERMI2W_Z: Full Permute of Words From Two Tables Overwriting the Index (Zeroing Masking).
//
// Forms:
//
//	VPERMI2W.Z m128 xmm k xmm
//	VPERMI2W.Z m256 ymm k ymm
//	VPERMI2W.Z xmm  xmm k xmm
//	VPERMI2W.Z ymm  ymm k ymm
//	VPERMI2W.Z m512 zmm k zmm
//	VPERMI2W.Z zmm  zmm k zmm
func VPERMI2W_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMI2W.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPERMILPD: Permute Double-Precision Floating-Point Values.
//
// Forms:
//
//	VPERMILPD imm8 m128 xmm
//	VPERMILPD imm8 m256 ymm
//	VPERMILPD imm8 xmm  xmm
//	VPERMILPD imm8 ymm  ymm
//	VPERMILPD m128 xmm  xmm
//	VPERMILPD m256 ymm  ymm
//	VPERMILPD xmm  xmm  xmm
//	VPERMILPD ymm  ymm  ymm
//	VPERMILPD imm8 m128 k xmm
//	VPERMILPD imm8 m256 k ymm
//	VPERMILPD imm8 xmm  k xmm
//	VPERMILPD imm8 ymm  k ymm
//	VPERMILPD m128 xmm  k xmm
//	VPERMILPD m256 ymm  k ymm
//	VPERMILPD xmm  xmm  k xmm
//	VPERMILPD ymm  ymm  k ymm
//	VPERMILPD imm8 m512 k zmm
//	VPERMILPD imm8 m512 zmm
//	VPERMILPD imm8 zmm  k zmm
//	VPERMILPD imm8 zmm  zmm
//	VPERMILPD m512 zmm  k zmm
//	VPERMILPD m512 zmm  zmm
//	VPERMILPD zmm  zmm  k zmm
//	VPERMILPD zmm  zmm  zmm
func VPERMILPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMILPD.Forms(), sffxs{}, ops)
}

// VPERMILPD_BCST: Permute Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VPERMILPD.BCST imm8 m64 k xmm
//	VPERMILPD.BCST imm8 m64 k ymm
//	VPERMILPD.BCST imm8 m64 xmm
//	VPERMILPD.BCST imm8 m64 ymm
//	VPERMILPD.BCST m64  xmm k xmm
//	VPERMILPD.BCST m64  xmm xmm
//	VPERMILPD.BCST m64  ymm k ymm
//	VPERMILPD.BCST m64  ymm ymm
//	VPERMILPD.BCST imm8 m64 k zmm
//	VPERMILPD.BCST imm8 m64 zmm
//	VPERMILPD.BCST m64  zmm k zmm
//	VPERMILPD.BCST m64  zmm zmm
func VPERMILPD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMILPD.Forms(), sffxs{sffxBCST}, ops)
}

// VPERMILPD_BCST_Z: Permute Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPERMILPD.BCST.Z imm8 m64 k xmm
//	VPERMILPD.BCST.Z imm8 m64 k ymm
//	VPERMILPD.BCST.Z m64  xmm k xmm
//	VPERMILPD.BCST.Z m64  ymm k ymm
//	VPERMILPD.BCST.Z imm8 m64 k zmm
//	VPERMILPD.BCST.Z m64  zmm k zmm
func VPERMILPD_BCST_Z(im, mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMILPD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{im, mxyz, k, xyz})
}

// VPERMILPD_Z: Permute Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VPERMILPD.Z imm8 m128 k xmm
//	VPERMILPD.Z imm8 m256 k ymm
//	VPERMILPD.Z imm8 xmm  k xmm
//	VPERMILPD.Z imm8 ymm  k ymm
//	VPERMILPD.Z m128 xmm  k xmm
//	VPERMILPD.Z m256 ymm  k ymm
//	VPERMILPD.Z xmm  xmm  k xmm
//	VPERMILPD.Z ymm  ymm  k ymm
//	VPERMILPD.Z imm8 m512 k zmm
//	VPERMILPD.Z imm8 zmm  k zmm
//	VPERMILPD.Z m512 zmm  k zmm
//	VPERMILPD.Z zmm  zmm  k zmm
func VPERMILPD_Z(imxyz, mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMILPD.Forms(), sffxs{sffxZ}, []operand.Op{imxyz, mxyz, k, xyz})
}

// VPERMILPS: Permute Single-Precision Floating-Point Values.
//
// Forms:
//
//	VPERMILPS imm8 m128 xmm
//	VPERMILPS imm8 m256 ymm
//	VPERMILPS imm8 xmm  xmm
//	VPERMILPS imm8 ymm  ymm
//	VPERMILPS m128 xmm  xmm
//	VPERMILPS m256 ymm  ymm
//	VPERMILPS xmm  xmm  xmm
//	VPERMILPS ymm  ymm  ymm
//	VPERMILPS imm8 m128 k xmm
//	VPERMILPS imm8 m256 k ymm
//	VPERMILPS imm8 xmm  k xmm
//	VPERMILPS imm8 ymm  k ymm
//	VPERMILPS m128 xmm  k xmm
//	VPERMILPS m256 ymm  k ymm
//	VPERMILPS xmm  xmm  k xmm
//	VPERMILPS ymm  ymm  k ymm
//	VPERMILPS imm8 m512 k zmm
//	VPERMILPS imm8 m512 zmm
//	VPERMILPS imm8 zmm  k zmm
//	VPERMILPS imm8 zmm  zmm
//	VPERMILPS m512 zmm  k zmm
//	VPERMILPS m512 zmm  zmm
//	VPERMILPS zmm  zmm  k zmm
//	VPERMILPS zmm  zmm  zmm
func VPERMILPS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMILPS.Forms(), sffxs{}, ops)
}

// VPERMILPS_BCST: Permute Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VPERMILPS.BCST imm8 m32 k xmm
//	VPERMILPS.BCST imm8 m32 k ymm
//	VPERMILPS.BCST imm8 m32 xmm
//	VPERMILPS.BCST imm8 m32 ymm
//	VPERMILPS.BCST m32  xmm k xmm
//	VPERMILPS.BCST m32  xmm xmm
//	VPERMILPS.BCST m32  ymm k ymm
//	VPERMILPS.BCST m32  ymm ymm
//	VPERMILPS.BCST imm8 m32 k zmm
//	VPERMILPS.BCST imm8 m32 zmm
//	VPERMILPS.BCST m32  zmm k zmm
//	VPERMILPS.BCST m32  zmm zmm
func VPERMILPS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMILPS.Forms(), sffxs{sffxBCST}, ops)
}

// VPERMILPS_BCST_Z: Permute Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPERMILPS.BCST.Z imm8 m32 k xmm
//	VPERMILPS.BCST.Z imm8 m32 k ymm
//	VPERMILPS.BCST.Z m32  xmm k xmm
//	VPERMILPS.BCST.Z m32  ymm k ymm
//	VPERMILPS.BCST.Z imm8 m32 k zmm
//	VPERMILPS.BCST.Z m32  zmm k zmm
func VPERMILPS_BCST_Z(im, mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMILPS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{im, mxyz, k, xyz})
}

// VPERMILPS_Z: Permute Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VPERMILPS.Z imm8 m128 k xmm
//	VPERMILPS.Z imm8 m256 k ymm
//	VPERMILPS.Z imm8 xmm  k xmm
//	VPERMILPS.Z imm8 ymm  k ymm
//	VPERMILPS.Z m128 xmm  k xmm
//	VPERMILPS.Z m256 ymm  k ymm
//	VPERMILPS.Z xmm  xmm  k xmm
//	VPERMILPS.Z ymm  ymm  k ymm
//	VPERMILPS.Z imm8 m512 k zmm
//	VPERMILPS.Z imm8 zmm  k zmm
//	VPERMILPS.Z m512 zmm  k zmm
//	VPERMILPS.Z zmm  zmm  k zmm
func VPERMILPS_Z(imxyz, mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMILPS.Forms(), sffxs{sffxZ}, []operand.Op{imxyz, mxyz, k, xyz})
}

// VPERMPD: Permute Double-Precision Floating-Point Elements.
//
// Forms:
//
//	VPERMPD imm8 m256 ymm
//	VPERMPD imm8 ymm  ymm
//	VPERMPD imm8 m256 k ymm
//	VPERMPD imm8 ymm  k ymm
//	VPERMPD m256 ymm  k ymm
//	VPERMPD m256 ymm  ymm
//	VPERMPD ymm  ymm  k ymm
//	VPERMPD ymm  ymm  ymm
//	VPERMPD imm8 m512 k zmm
//	VPERMPD imm8 m512 zmm
//	VPERMPD imm8 zmm  k zmm
//	VPERMPD imm8 zmm  zmm
//	VPERMPD m512 zmm  k zmm
//	VPERMPD m512 zmm  zmm
//	VPERMPD zmm  zmm  k zmm
//	VPERMPD zmm  zmm  zmm
func VPERMPD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMPD.Forms(), sffxs{}, ops)
}

// VPERMPD_BCST: Permute Double-Precision Floating-Point Elements (Broadcast).
//
// Forms:
//
//	VPERMPD.BCST imm8 m64 k ymm
//	VPERMPD.BCST imm8 m64 ymm
//	VPERMPD.BCST m64  ymm k ymm
//	VPERMPD.BCST m64  ymm ymm
//	VPERMPD.BCST imm8 m64 k zmm
//	VPERMPD.BCST imm8 m64 zmm
//	VPERMPD.BCST m64  zmm k zmm
//	VPERMPD.BCST m64  zmm zmm
func VPERMPD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMPD.Forms(), sffxs{sffxBCST}, ops)
}

// VPERMPD_BCST_Z: Permute Double-Precision Floating-Point Elements (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPERMPD.BCST.Z imm8 m64 k ymm
//	VPERMPD.BCST.Z m64  ymm k ymm
//	VPERMPD.BCST.Z imm8 m64 k zmm
//	VPERMPD.BCST.Z m64  zmm k zmm
func VPERMPD_BCST_Z(im, myz, k, yz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMPD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{im, myz, k, yz})
}

// VPERMPD_Z: Permute Double-Precision Floating-Point Elements (Zeroing Masking).
//
// Forms:
//
//	VPERMPD.Z imm8 m256 k ymm
//	VPERMPD.Z imm8 ymm  k ymm
//	VPERMPD.Z m256 ymm  k ymm
//	VPERMPD.Z ymm  ymm  k ymm
//	VPERMPD.Z imm8 m512 k zmm
//	VPERMPD.Z imm8 zmm  k zmm
//	VPERMPD.Z m512 zmm  k zmm
//	VPERMPD.Z zmm  zmm  k zmm
func VPERMPD_Z(imyz, myz, k, yz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMPD.Forms(), sffxs{sffxZ}, []operand.Op{imyz, myz, k, yz})
}

// VPERMPS: Permute Single-Precision Floating-Point Elements.
//
// Forms:
//
//	VPERMPS m256 ymm ymm
//	VPERMPS ymm  ymm ymm
//	VPERMPS m256 ymm k ymm
//	VPERMPS ymm  ymm k ymm
//	VPERMPS m512 zmm k zmm
//	VPERMPS m512 zmm zmm
//	VPERMPS zmm  zmm k zmm
//	VPERMPS zmm  zmm zmm
func VPERMPS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMPS.Forms(), sffxs{}, ops)
}

// VPERMPS_BCST: Permute Single-Precision Floating-Point Elements (Broadcast).
//
// Forms:
//
//	VPERMPS.BCST m32 ymm k ymm
//	VPERMPS.BCST m32 ymm ymm
//	VPERMPS.BCST m32 zmm k zmm
//	VPERMPS.BCST m32 zmm zmm
func VPERMPS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMPS.Forms(), sffxs{sffxBCST}, ops)
}

// VPERMPS_BCST_Z: Permute Single-Precision Floating-Point Elements (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPERMPS.BCST.Z m32 ymm k ymm
//	VPERMPS.BCST.Z m32 zmm k zmm
func VPERMPS_BCST_Z(m, yz, k, yz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMPS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, yz, k, yz1})
}

// VPERMPS_Z: Permute Single-Precision Floating-Point Elements (Zeroing Masking).
//
// Forms:
//
//	VPERMPS.Z m256 ymm k ymm
//	VPERMPS.Z ymm  ymm k ymm
//	VPERMPS.Z m512 zmm k zmm
//	VPERMPS.Z zmm  zmm k zmm
func VPERMPS_Z(myz, yz, k, yz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMPS.Forms(), sffxs{sffxZ}, []operand.Op{myz, yz, k, yz1})
}

// VPERMQ: Permute Quadword Integers.
//
// Forms:
//
//	VPERMQ imm8 m256 ymm
//	VPERMQ imm8 ymm  ymm
//	VPERMQ imm8 m256 k ymm
//	VPERMQ imm8 ymm  k ymm
//	VPERMQ m256 ymm  k ymm
//	VPERMQ m256 ymm  ymm
//	VPERMQ ymm  ymm  k ymm
//	VPERMQ ymm  ymm  ymm
//	VPERMQ imm8 m512 k zmm
//	VPERMQ imm8 m512 zmm
//	VPERMQ imm8 zmm  k zmm
//	VPERMQ imm8 zmm  zmm
//	VPERMQ m512 zmm  k zmm
//	VPERMQ m512 zmm  zmm
//	VPERMQ zmm  zmm  k zmm
//	VPERMQ zmm  zmm  zmm
func VPERMQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMQ.Forms(), sffxs{}, ops)
}

// VPERMQ_BCST: Permute Quadword Integers (Broadcast).
//
// Forms:
//
//	VPERMQ.BCST imm8 m64 k ymm
//	VPERMQ.BCST imm8 m64 ymm
//	VPERMQ.BCST m64  ymm k ymm
//	VPERMQ.BCST m64  ymm ymm
//	VPERMQ.BCST imm8 m64 k zmm
//	VPERMQ.BCST imm8 m64 zmm
//	VPERMQ.BCST m64  zmm k zmm
//	VPERMQ.BCST m64  zmm zmm
func VPERMQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPERMQ_BCST_Z: Permute Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPERMQ.BCST.Z imm8 m64 k ymm
//	VPERMQ.BCST.Z m64  ymm k ymm
//	VPERMQ.BCST.Z imm8 m64 k zmm
//	VPERMQ.BCST.Z m64  zmm k zmm
func VPERMQ_BCST_Z(im, myz, k, yz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{im, myz, k, yz})
}

// VPERMQ_Z: Permute Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VPERMQ.Z imm8 m256 k ymm
//	VPERMQ.Z imm8 ymm  k ymm
//	VPERMQ.Z m256 ymm  k ymm
//	VPERMQ.Z ymm  ymm  k ymm
//	VPERMQ.Z imm8 m512 k zmm
//	VPERMQ.Z imm8 zmm  k zmm
//	VPERMQ.Z m512 zmm  k zmm
//	VPERMQ.Z zmm  zmm  k zmm
func VPERMQ_Z(imyz, myz, k, yz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMQ.Forms(), sffxs{sffxZ}, []operand.Op{imyz, myz, k, yz})
}

// VPERMT2B: Full Permute of Bytes From Two Tables Overwriting a Table.
//
// Forms:
//
//	VPERMT2B m128 xmm k xmm
//	VPERMT2B m128 xmm xmm
//	VPERMT2B m256 ymm k ymm
//	VPERMT2B m256 ymm ymm
//	VPERMT2B xmm  xmm k xmm
//	VPERMT2B xmm  xmm xmm
//	VPERMT2B ymm  ymm k ymm
//	VPERMT2B ymm  ymm ymm
//	VPERMT2B m512 zmm k zmm
//	VPERMT2B m512 zmm zmm
//	VPERMT2B zmm  zmm k zmm
//	VPERMT2B zmm  zmm zmm
func VPERMT2B(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMT2B.Forms(), sffxs{}, ops)
}

// VPERMT2B_Z: Full Permute of Bytes From Two Tables Overwriting a Table (Zeroing Masking).
//
// Forms:
//
//	VPERMT2B.Z m128 xmm k xmm
//	VPERMT2B.Z m256 ymm k ymm
//	VPERMT2B.Z xmm  xmm k xmm
//	VPERMT2B.Z ymm  ymm k ymm
//	VPERMT2B.Z m512 zmm k zmm
//	VPERMT2B.Z zmm  zmm k zmm
func VPERMT2B_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMT2B.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPERMT2D: Full Permute of Doublewords From Two Tables Overwriting a Table.
//
// Forms:
//
//	VPERMT2D m128 xmm k xmm
//	VPERMT2D m128 xmm xmm
//	VPERMT2D m256 ymm k ymm
//	VPERMT2D m256 ymm ymm
//	VPERMT2D xmm  xmm k xmm
//	VPERMT2D xmm  xmm xmm
//	VPERMT2D ymm  ymm k ymm
//	VPERMT2D ymm  ymm ymm
//	VPERMT2D m512 zmm k zmm
//	VPERMT2D m512 zmm zmm
//	VPERMT2D zmm  zmm k zmm
//	VPERMT2D zmm  zmm zmm
func VPERMT2D(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMT2D.Forms(), sffxs{}, ops)
}

// VPERMT2D_BCST: Full Permute of Doublewords From Two Tables Overwriting a Table (Broadcast).
//
// Forms:
//
//	VPERMT2D.BCST m32 xmm k xmm
//	VPERMT2D.BCST m32 xmm xmm
//	VPERMT2D.BCST m32 ymm k ymm
//	VPERMT2D.BCST m32 ymm ymm
//	VPERMT2D.BCST m32 zmm k zmm
//	VPERMT2D.BCST m32 zmm zmm
func VPERMT2D_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMT2D.Forms(), sffxs{sffxBCST}, ops)
}

// VPERMT2D_BCST_Z: Full Permute of Doublewords From Two Tables Overwriting a Table (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPERMT2D.BCST.Z m32 xmm k xmm
//	VPERMT2D.BCST.Z m32 ymm k ymm
//	VPERMT2D.BCST.Z m32 zmm k zmm
func VPERMT2D_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMT2D.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPERMT2D_Z: Full Permute of Doublewords From Two Tables Overwriting a Table (Zeroing Masking).
//
// Forms:
//
//	VPERMT2D.Z m128 xmm k xmm
//	VPERMT2D.Z m256 ymm k ymm
//	VPERMT2D.Z xmm  xmm k xmm
//	VPERMT2D.Z ymm  ymm k ymm
//	VPERMT2D.Z m512 zmm k zmm
//	VPERMT2D.Z zmm  zmm k zmm
func VPERMT2D_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMT2D.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPERMT2PD: Full Permute of Double-Precision Floating-Point Values From Two Tables Overwriting a Table.
//
// Forms:
//
//	VPERMT2PD m128 xmm k xmm
//	VPERMT2PD m128 xmm xmm
//	VPERMT2PD m256 ymm k ymm
//	VPERMT2PD m256 ymm ymm
//	VPERMT2PD xmm  xmm k xmm
//	VPERMT2PD xmm  xmm xmm
//	VPERMT2PD ymm  ymm k ymm
//	VPERMT2PD ymm  ymm ymm
//	VPERMT2PD m512 zmm k zmm
//	VPERMT2PD m512 zmm zmm
//	VPERMT2PD zmm  zmm k zmm
//	VPERMT2PD zmm  zmm zmm
func VPERMT2PD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMT2PD.Forms(), sffxs{}, ops)
}

// VPERMT2PD_BCST: Full Permute of Double-Precision Floating-Point Values From Two Tables Overwriting a Table (Broadcast).
//
// Forms:
//
//	VPERMT2PD.BCST m64 xmm k xmm
//	VPERMT2PD.BCST m64 xmm xmm
//	VPERMT2PD.BCST m64 ymm k ymm
//	VPERMT2PD.BCST m64 ymm ymm
//	VPERMT2PD.BCST m64 zmm k zmm
//	VPERMT2PD.BCST m64 zmm zmm
func VPERMT2PD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMT2PD.Forms(), sffxs{sffxBCST}, ops)
}

// VPERMT2PD_BCST_Z: Full Permute of Double-Precision Floating-Point Values From Two Tables Overwriting a Table (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPERMT2PD.BCST.Z m64 xmm k xmm
//	VPERMT2PD.BCST.Z m64 ymm k ymm
//	VPERMT2PD.BCST.Z m64 zmm k zmm
func VPERMT2PD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMT2PD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPERMT2PD_Z: Full Permute of Double-Precision Floating-Point Values From Two Tables Overwriting a Table (Zeroing Masking).
//
// Forms:
//
//	VPERMT2PD.Z m128 xmm k xmm
//	VPERMT2PD.Z m256 ymm k ymm
//	VPERMT2PD.Z xmm  xmm k xmm
//	VPERMT2PD.Z ymm  ymm k ymm
//	VPERMT2PD.Z m512 zmm k zmm
//	VPERMT2PD.Z zmm  zmm k zmm
func VPERMT2PD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMT2PD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPERMT2PS: Full Permute of Single-Precision Floating-Point Values From Two Tables Overwriting a Table.
//
// Forms:
//
//	VPERMT2PS m128 xmm k xmm
//	VPERMT2PS m128 xmm xmm
//	VPERMT2PS m256 ymm k ymm
//	VPERMT2PS m256 ymm ymm
//	VPERMT2PS xmm  xmm k xmm
//	VPERMT2PS xmm  xmm xmm
//	VPERMT2PS ymm  ymm k ymm
//	VPERMT2PS ymm  ymm ymm
//	VPERMT2PS m512 zmm k zmm
//	VPERMT2PS m512 zmm zmm
//	VPERMT2PS zmm  zmm k zmm
//	VPERMT2PS zmm  zmm zmm
func VPERMT2PS(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMT2PS.Forms(), sffxs{}, ops)
}

// VPERMT2PS_BCST: Full Permute of Single-Precision Floating-Point Values From Two Tables Overwriting a Table (Broadcast).
//
// Forms:
//
//	VPERMT2PS.BCST m32 xmm k xmm
//	VPERMT2PS.BCST m32 xmm xmm
//	VPERMT2PS.BCST m32 ymm k ymm
//	VPERMT2PS.BCST m32 ymm ymm
//	VPERMT2PS.BCST m32 zmm k zmm
//	VPERMT2PS.BCST m32 zmm zmm
func VPERMT2PS_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMT2PS.Forms(), sffxs{sffxBCST}, ops)
}

// VPERMT2PS_BCST_Z: Full Permute of Single-Precision Floating-Point Values From Two Tables Overwriting a Table (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPERMT2PS.BCST.Z m32 xmm k xmm
//	VPERMT2PS.BCST.Z m32 ymm k ymm
//	VPERMT2PS.BCST.Z m32 zmm k zmm
func VPERMT2PS_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMT2PS.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPERMT2PS_Z: Full Permute of Single-Precision Floating-Point Values From Two Tables Overwriting a Table (Zeroing Masking).
//
// Forms:
//
//	VPERMT2PS.Z m128 xmm k xmm
//	VPERMT2PS.Z m256 ymm k ymm
//	VPERMT2PS.Z xmm  xmm k xmm
//	VPERMT2PS.Z ymm  ymm k ymm
//	VPERMT2PS.Z m512 zmm k zmm
//	VPERMT2PS.Z zmm  zmm k zmm
func VPERMT2PS_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMT2PS.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPERMT2Q: Full Permute of Quadwords From Two Tables Overwriting a Table.
//
// Forms:
//
//	VPERMT2Q m128 xmm k xmm
//	VPERMT2Q m128 xmm xmm
//	VPERMT2Q m256 ymm k ymm
//	VPERMT2Q m256 ymm ymm
//	VPERMT2Q xmm  xmm k xmm
//	VPERMT2Q xmm  xmm xmm
//	VPERMT2Q ymm  ymm k ymm
//	VPERMT2Q ymm  ymm ymm
//	VPERMT2Q m512 zmm k zmm
//	VPERMT2Q m512 zmm zmm
//	VPERMT2Q zmm  zmm k zmm
//	VPERMT2Q zmm  zmm zmm
func VPERMT2Q(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMT2Q.Forms(), sffxs{}, ops)
}

// VPERMT2Q_BCST: Full Permute of Quadwords From Two Tables Overwriting a Table (Broadcast).
//
// Forms:
//
//	VPERMT2Q.BCST m64 xmm k xmm
//	VPERMT2Q.BCST m64 xmm xmm
//	VPERMT2Q.BCST m64 ymm k ymm
//	VPERMT2Q.BCST m64 ymm ymm
//	VPERMT2Q.BCST m64 zmm k zmm
//	VPERMT2Q.BCST m64 zmm zmm
func VPERMT2Q_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMT2Q.Forms(), sffxs{sffxBCST}, ops)
}

// VPERMT2Q_BCST_Z: Full Permute of Quadwords From Two Tables Overwriting a Table (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPERMT2Q.BCST.Z m64 xmm k xmm
//	VPERMT2Q.BCST.Z m64 ymm k ymm
//	VPERMT2Q.BCST.Z m64 zmm k zmm
func VPERMT2Q_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMT2Q.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPERMT2Q_Z: Full Permute of Quadwords From Two Tables Overwriting a Table (Zeroing Masking).
//
// Forms:
//
//	VPERMT2Q.Z m128 xmm k xmm
//	VPERMT2Q.Z m256 ymm k ymm
//	VPERMT2Q.Z xmm  xmm k xmm
//	VPERMT2Q.Z ymm  ymm k ymm
//	VPERMT2Q.Z m512 zmm k zmm
//	VPERMT2Q.Z zmm  zmm k zmm
func VPERMT2Q_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMT2Q.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPERMT2W: Full Permute of Words From Two Tables Overwriting a Table.
//
// Forms:
//
//	VPERMT2W m128 xmm k xmm
//	VPERMT2W m128 xmm xmm
//	VPERMT2W m256 ymm k ymm
//	VPERMT2W m256 ymm ymm
//	VPERMT2W xmm  xmm k xmm
//	VPERMT2W xmm  xmm xmm
//	VPERMT2W ymm  ymm k ymm
//	VPERMT2W ymm  ymm ymm
//	VPERMT2W m512 zmm k zmm
//	VPERMT2W m512 zmm zmm
//	VPERMT2W zmm  zmm k zmm
//	VPERMT2W zmm  zmm zmm
func VPERMT2W(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMT2W.Forms(), sffxs{}, ops)
}

// VPERMT2W_Z: Full Permute of Words From Two Tables Overwriting a Table (Zeroing Masking).
//
// Forms:
//
//	VPERMT2W.Z m128 xmm k xmm
//	VPERMT2W.Z m256 ymm k ymm
//	VPERMT2W.Z xmm  xmm k xmm
//	VPERMT2W.Z ymm  ymm k ymm
//	VPERMT2W.Z m512 zmm k zmm
//	VPERMT2W.Z zmm  zmm k zmm
func VPERMT2W_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMT2W.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPERMW: Permute Word Integers.
//
// Forms:
//
//	VPERMW m128 xmm k xmm
//	VPERMW m128 xmm xmm
//	VPERMW m256 ymm k ymm
//	VPERMW m256 ymm ymm
//	VPERMW xmm  xmm k xmm
//	VPERMW xmm  xmm xmm
//	VPERMW ymm  ymm k ymm
//	VPERMW ymm  ymm ymm
//	VPERMW m512 zmm k zmm
//	VPERMW m512 zmm zmm
//	VPERMW zmm  zmm k zmm
//	VPERMW zmm  zmm zmm
func VPERMW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMW.Forms(), sffxs{}, ops)
}

// VPERMW_Z: Permute Word Integers (Zeroing Masking).
//
// Forms:
//
//	VPERMW.Z m128 xmm k xmm
//	VPERMW.Z m256 ymm k ymm
//	VPERMW.Z xmm  xmm k xmm
//	VPERMW.Z ymm  ymm k ymm
//	VPERMW.Z m512 zmm k zmm
//	VPERMW.Z zmm  zmm k zmm
func VPERMW_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPERMW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPEXPANDB: Load Sparse Packed Byte Integer Values from Dense Memory/Register.
//
// Forms:
//
//	VPEXPANDB m128 k xmm
//	VPEXPANDB m128 xmm
//	VPEXPANDB m256 k ymm
//	VPEXPANDB m256 ymm
//	VPEXPANDB xmm  k xmm
//	VPEXPANDB xmm  xmm
//	VPEXPANDB ymm  k ymm
//	VPEXPANDB ymm  ymm
//	VPEXPANDB m512 k zmm
//	VPEXPANDB m512 zmm
//	VPEXPANDB zmm  k zmm
//	VPEXPANDB zmm  zmm
func VPEXPANDB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPEXPANDB.Forms(), sffxs{}, ops)
}

// VPEXPANDB_Z: Load Sparse Packed Byte Integer Values from Dense Memory/Register (Zeroing Masking).
//
// Forms:
//
//	VPEXPANDB.Z m128 k xmm
//	VPEXPANDB.Z m256 k ymm
//	VPEXPANDB.Z xmm  k xmm
//	VPEXPANDB.Z ymm  k ymm
//	VPEXPANDB.Z m512 k zmm
//	VPEXPANDB.Z zmm  k zmm
func VPEXPANDB_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPEXPANDB.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VPEXPANDD: Load Sparse Packed Doubleword Integer Values from Dense Memory/Register.
//
// Forms:
//
//	VPEXPANDD m128 k xmm
//	VPEXPANDD m128 xmm
//	VPEXPANDD m256 k ymm
//	VPEXPANDD m256 ymm
//	VPEXPANDD xmm  k xmm
//	VPEXPANDD xmm  xmm
//	VPEXPANDD ymm  k ymm
//	VPEXPANDD ymm  ymm
//	VPEXPANDD m512 k zmm
//	VPEXPANDD m512 zmm
//	VPEXPANDD zmm  k zmm
//	VPEXPANDD zmm  zmm
func VPEXPANDD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPEXPANDD.Forms(), sffxs{}, ops)
}

// VPEXPANDD_Z: Load Sparse Packed Doubleword Integer Values from Dense Memory/Register (Zeroing Masking).
//
// Forms:
//
//	VPEXPANDD.Z m128 k xmm
//	VPEXPANDD.Z m256 k ymm
//	VPEXPANDD.Z xmm  k xmm
//	VPEXPANDD.Z ymm  k ymm
//	VPEXPANDD.Z m512 k zmm
//	VPEXPANDD.Z zmm  k zmm
func VPEXPANDD_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPEXPANDD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VPEXPANDQ: Load Sparse Packed Quadword Integer Values from Dense Memory/Register.
//
// Forms:
//
//	VPEXPANDQ m128 k xmm
//	VPEXPANDQ m128 xmm
//	VPEXPANDQ m256 k ymm
//	VPEXPANDQ m256 ymm
//	VPEXPANDQ xmm  k xmm
//	VPEXPANDQ xmm  xmm
//	VPEXPANDQ ymm  k ymm
//	VPEXPANDQ ymm  ymm
//	VPEXPANDQ m512 k zmm
//	VPEXPANDQ m512 zmm
//	VPEXPANDQ zmm  k zmm
//	VPEXPANDQ zmm  zmm
func VPEXPANDQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPEXPANDQ.Forms(), sffxs{}, ops)
}

// VPEXPANDQ_Z: Load Sparse Packed Quadword Integer Values from Dense Memory/Register (Zeroing Masking).
//
// Forms:
//
//	VPEXPANDQ.Z m128 k xmm
//	VPEXPANDQ.Z m256 k ymm
//	VPEXPANDQ.Z xmm  k xmm
//	VPEXPANDQ.Z ymm  k ymm
//	VPEXPANDQ.Z m512 k zmm
//	VPEXPANDQ.Z zmm  k zmm
func VPEXPANDQ_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPEXPANDQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VPEXPANDW: Load Sparse Packed Word Integer Values from Dense Memory/Register.
//
// Forms:
//
//	VPEXPANDW m128 k xmm
//	VPEXPANDW m128 xmm
//	VPEXPANDW m256 k ymm
//	VPEXPANDW m256 ymm
//	VPEXPANDW xmm  k xmm
//	VPEXPANDW xmm  xmm
//	VPEXPANDW ymm  k ymm
//	VPEXPANDW ymm  ymm
//	VPEXPANDW m512 k zmm
//	VPEXPANDW m512 zmm
//	VPEXPANDW zmm  k zmm
//	VPEXPANDW zmm  zmm
func VPEXPANDW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPEXPANDW.Forms(), sffxs{}, ops)
}

// VPEXPANDW_Z: Load Sparse Packed Word Integer Values from Dense Memory/Register (Zeroing Masking).
//
// Forms:
//
//	VPEXPANDW.Z m128 k xmm
//	VPEXPANDW.Z m256 k ymm
//	VPEXPANDW.Z xmm  k xmm
//	VPEXPANDW.Z ymm  k ymm
//	VPEXPANDW.Z m512 k zmm
//	VPEXPANDW.Z zmm  k zmm
func VPEXPANDW_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPEXPANDW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VPEXTRB: Extract Byte.
//
// Forms:
//
//	VPEXTRB imm8 xmm m8
//	VPEXTRB imm8 xmm r32
func VPEXTRB(i, x, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcVPEXTRB.Forms(), sffxs{}, []operand.Op{i, x, mr})
}

// VPEXTRD: Extract Doubleword.
//
// Forms:
//
//	VPEXTRD imm8 xmm m32
//	VPEXTRD imm8 xmm r32
func VPEXTRD(i, x, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcVPEXTRD.Forms(), sffxs{}, []operand.Op{i, x, mr})
}

// VPEXTRQ: Extract Quadword.
//
// Forms:
//
//	VPEXTRQ imm8 xmm m64
//	VPEXTRQ imm8 xmm r64
func VPEXTRQ(i, x, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcVPEXTRQ.Forms(), sffxs{}, []operand.Op{i, x, mr})
}

// VPEXTRW: Extract Word.
//
// Forms:
//
//	VPEXTRW imm8 xmm m16
//	VPEXTRW imm8 xmm r32
func VPEXTRW(i, x, mr operand.Op) (*intrep.Instruction, error) {
	return build(opcVPEXTRW.Forms(), sffxs{}, []operand.Op{i, x, mr})
}

// VPGATHERDD: Gather Packed Doubleword Values Using Signed Doubleword Indices.
//
// Forms:
//
//	VPGATHERDD xmm   vm32x xmm
//	VPGATHERDD ymm   vm32y ymm
//	VPGATHERDD vm32x k     xmm
//	VPGATHERDD vm32y k     ymm
//	VPGATHERDD vm32z k     zmm
func VPGATHERDD(vxy, kv, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPGATHERDD.Forms(), sffxs{}, []operand.Op{vxy, kv, xyz})
}

// VPGATHERDQ: Gather Packed Quadword Values Using Signed Doubleword Indices.
//
// Forms:
//
//	VPGATHERDQ xmm   vm32x xmm
//	VPGATHERDQ ymm   vm32x ymm
//	VPGATHERDQ vm32x k     xmm
//	VPGATHERDQ vm32x k     ymm
//	VPGATHERDQ vm32y k     zmm
func VPGATHERDQ(vxy, kv, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPGATHERDQ.Forms(), sffxs{}, []operand.Op{vxy, kv, xyz})
}

// VPGATHERQD: Gather Packed Doubleword Values Using Signed Quadword Indices.
//
// Forms:
//
//	VPGATHERQD xmm   vm64x xmm
//	VPGATHERQD xmm   vm64y xmm
//	VPGATHERQD vm64x k     xmm
//	VPGATHERQD vm64y k     xmm
//	VPGATHERQD vm64z k     ymm
func VPGATHERQD(vx, kv, xy operand.Op) (*intrep.Instruction, error) {
	return build(opcVPGATHERQD.Forms(), sffxs{}, []operand.Op{vx, kv, xy})
}

// VPGATHERQQ: Gather Packed Quadword Values Using Signed Quadword Indices.
//
// Forms:
//
//	VPGATHERQQ xmm   vm64x xmm
//	VPGATHERQQ ymm   vm64y ymm
//	VPGATHERQQ vm64x k     xmm
//	VPGATHERQQ vm64y k     ymm
//	VPGATHERQQ vm64z k     zmm
func VPGATHERQQ(vxy, kv, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPGATHERQQ.Forms(), sffxs{}, []operand.Op{vxy, kv, xyz})
}

// VPHADDD: Packed Horizontal Add Doubleword Integer.
//
// Forms:
//
//	VPHADDD m256 ymm ymm
//	VPHADDD ymm  ymm ymm
//	VPHADDD m128 xmm xmm
//	VPHADDD xmm  xmm xmm
func VPHADDD(mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPHADDD.Forms(), sffxs{}, []operand.Op{mxy, xy, xy1})
}

// VPHADDSW: Packed Horizontal Add Signed Word Integers with Signed Saturation.
//
// Forms:
//
//	VPHADDSW m256 ymm ymm
//	VPHADDSW ymm  ymm ymm
//	VPHADDSW m128 xmm xmm
//	VPHADDSW xmm  xmm xmm
func VPHADDSW(mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPHADDSW.Forms(), sffxs{}, []operand.Op{mxy, xy, xy1})
}

// VPHADDW: Packed Horizontal Add Word Integers.
//
// Forms:
//
//	VPHADDW m256 ymm ymm
//	VPHADDW ymm  ymm ymm
//	VPHADDW m128 xmm xmm
//	VPHADDW xmm  xmm xmm
func VPHADDW(mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPHADDW.Forms(), sffxs{}, []operand.Op{mxy, xy, xy1})
}

// VPHMINPOSUW: Packed Horizontal Minimum of Unsigned Word Integers.
//
// Forms:
//
//	VPHMINPOSUW m128 xmm
//	VPHMINPOSUW xmm  xmm
func VPHMINPOSUW(mx, x operand.Op) (*intrep.Instruction, error) {
	return build(opcVPHMINPOSUW.Forms(), sffxs{}, []operand.Op{mx, x})
}

// VPHSUBD: Packed Horizontal Subtract Doubleword Integers.
//
// Forms:
//
//	VPHSUBD m256 ymm ymm
//	VPHSUBD ymm  ymm ymm
//	VPHSUBD m128 xmm xmm
//	VPHSUBD xmm  xmm xmm
func VPHSUBD(mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPHSUBD.Forms(), sffxs{}, []operand.Op{mxy, xy, xy1})
}

// VPHSUBSW: Packed Horizontal Subtract Signed Word Integers with Signed Saturation.
//
// Forms:
//
//	VPHSUBSW m256 ymm ymm
//	VPHSUBSW ymm  ymm ymm
//	VPHSUBSW m128 xmm xmm
//	VPHSUBSW xmm  xmm xmm
func VPHSUBSW(mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPHSUBSW.Forms(), sffxs{}, []operand.Op{mxy, xy, xy1})
}

// VPHSUBW: Packed Horizontal Subtract Word Integers.
//
// Forms:
//
//	VPHSUBW m256 ymm ymm
//	VPHSUBW ymm  ymm ymm
//	VPHSUBW m128 xmm xmm
//	VPHSUBW xmm  xmm xmm
func VPHSUBW(mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPHSUBW.Forms(), sffxs{}, []operand.Op{mxy, xy, xy1})
}

// VPINSRB: Insert Byte.
//
// Forms:
//
//	VPINSRB imm8 m8  xmm xmm
//	VPINSRB imm8 r32 xmm xmm
func VPINSRB(i, mr, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPINSRB.Forms(), sffxs{}, []operand.Op{i, mr, x, x1})
}

// VPINSRD: Insert Doubleword.
//
// Forms:
//
//	VPINSRD imm8 m32 xmm xmm
//	VPINSRD imm8 r32 xmm xmm
func VPINSRD(i, mr, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPINSRD.Forms(), sffxs{}, []operand.Op{i, mr, x, x1})
}

// VPINSRQ: Insert Quadword.
//
// Forms:
//
//	VPINSRQ imm8 m64 xmm xmm
//	VPINSRQ imm8 r64 xmm xmm
func VPINSRQ(i, mr, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPINSRQ.Forms(), sffxs{}, []operand.Op{i, mr, x, x1})
}

// VPINSRW: Insert Word.
//
// Forms:
//
//	VPINSRW imm8 m16 xmm xmm
//	VPINSRW imm8 r32 xmm xmm
func VPINSRW(i, mr, x, x1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPINSRW.Forms(), sffxs{}, []operand.Op{i, mr, x, x1})
}

// VPLZCNTD: Count the Number of Leading Zero Bits for Packed Doubleword Values.
//
// Forms:
//
//	VPLZCNTD m128 k xmm
//	VPLZCNTD m128 xmm
//	VPLZCNTD m256 k ymm
//	VPLZCNTD m256 ymm
//	VPLZCNTD xmm  k xmm
//	VPLZCNTD xmm  xmm
//	VPLZCNTD ymm  k ymm
//	VPLZCNTD ymm  ymm
//	VPLZCNTD m512 k zmm
//	VPLZCNTD m512 zmm
//	VPLZCNTD zmm  k zmm
//	VPLZCNTD zmm  zmm
func VPLZCNTD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPLZCNTD.Forms(), sffxs{}, ops)
}

// VPLZCNTD_BCST: Count the Number of Leading Zero Bits for Packed Doubleword Values (Broadcast).
//
// Forms:
//
//	VPLZCNTD.BCST m32 k xmm
//	VPLZCNTD.BCST m32 k ymm
//	VPLZCNTD.BCST m32 xmm
//	VPLZCNTD.BCST m32 ymm
//	VPLZCNTD.BCST m32 k zmm
//	VPLZCNTD.BCST m32 zmm
func VPLZCNTD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPLZCNTD.Forms(), sffxs{sffxBCST}, ops)
}

// VPLZCNTD_BCST_Z: Count the Number of Leading Zero Bits for Packed Doubleword Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPLZCNTD.BCST.Z m32 k xmm
//	VPLZCNTD.BCST.Z m32 k ymm
//	VPLZCNTD.BCST.Z m32 k zmm
func VPLZCNTD_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPLZCNTD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VPLZCNTD_Z: Count the Number of Leading Zero Bits for Packed Doubleword Values (Zeroing Masking).
//
// Forms:
//
//	VPLZCNTD.Z m128 k xmm
//	VPLZCNTD.Z m256 k ymm
//	VPLZCNTD.Z xmm  k xmm
//	VPLZCNTD.Z ymm  k ymm
//	VPLZCNTD.Z m512 k zmm
//	VPLZCNTD.Z zmm  k zmm
func VPLZCNTD_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPLZCNTD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VPLZCNTQ: Count the Number of Leading Zero Bits for Packed Quadword Values.
//
// Forms:
//
//	VPLZCNTQ m128 k xmm
//	VPLZCNTQ m128 xmm
//	VPLZCNTQ m256 k ymm
//	VPLZCNTQ m256 ymm
//	VPLZCNTQ xmm  k xmm
//	VPLZCNTQ xmm  xmm
//	VPLZCNTQ ymm  k ymm
//	VPLZCNTQ ymm  ymm
//	VPLZCNTQ m512 k zmm
//	VPLZCNTQ m512 zmm
//	VPLZCNTQ zmm  k zmm
//	VPLZCNTQ zmm  zmm
func VPLZCNTQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPLZCNTQ.Forms(), sffxs{}, ops)
}

// VPLZCNTQ_BCST: Count the Number of Leading Zero Bits for Packed Quadword Values (Broadcast).
//
// Forms:
//
//	VPLZCNTQ.BCST m64 k xmm
//	VPLZCNTQ.BCST m64 k ymm
//	VPLZCNTQ.BCST m64 xmm
//	VPLZCNTQ.BCST m64 ymm
//	VPLZCNTQ.BCST m64 k zmm
//	VPLZCNTQ.BCST m64 zmm
func VPLZCNTQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPLZCNTQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPLZCNTQ_BCST_Z: Count the Number of Leading Zero Bits for Packed Quadword Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPLZCNTQ.BCST.Z m64 k xmm
//	VPLZCNTQ.BCST.Z m64 k ymm
//	VPLZCNTQ.BCST.Z m64 k zmm
func VPLZCNTQ_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPLZCNTQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VPLZCNTQ_Z: Count the Number of Leading Zero Bits for Packed Quadword Values (Zeroing Masking).
//
// Forms:
//
//	VPLZCNTQ.Z m128 k xmm
//	VPLZCNTQ.Z m256 k ymm
//	VPLZCNTQ.Z xmm  k xmm
//	VPLZCNTQ.Z ymm  k ymm
//	VPLZCNTQ.Z m512 k zmm
//	VPLZCNTQ.Z zmm  k zmm
func VPLZCNTQ_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPLZCNTQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VPMADD52HUQ: Packed Multiply of Unsigned 52-bit Unsigned Integers and Add High 52-bit Products to Quadword Accumulators.
//
// Forms:
//
//	VPMADD52HUQ m128 xmm k xmm
//	VPMADD52HUQ m128 xmm xmm
//	VPMADD52HUQ m256 ymm k ymm
//	VPMADD52HUQ m256 ymm ymm
//	VPMADD52HUQ xmm  xmm k xmm
//	VPMADD52HUQ xmm  xmm xmm
//	VPMADD52HUQ ymm  ymm k ymm
//	VPMADD52HUQ ymm  ymm ymm
//	VPMADD52HUQ m512 zmm k zmm
//	VPMADD52HUQ m512 zmm zmm
//	VPMADD52HUQ zmm  zmm k zmm
//	VPMADD52HUQ zmm  zmm zmm
func VPMADD52HUQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMADD52HUQ.Forms(), sffxs{}, ops)
}

// VPMADD52HUQ_BCST: Packed Multiply of Unsigned 52-bit Unsigned Integers and Add High 52-bit Products to Quadword Accumulators (Broadcast).
//
// Forms:
//
//	VPMADD52HUQ.BCST m64 xmm k xmm
//	VPMADD52HUQ.BCST m64 xmm xmm
//	VPMADD52HUQ.BCST m64 ymm k ymm
//	VPMADD52HUQ.BCST m64 ymm ymm
//	VPMADD52HUQ.BCST m64 zmm k zmm
//	VPMADD52HUQ.BCST m64 zmm zmm
func VPMADD52HUQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMADD52HUQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPMADD52HUQ_BCST_Z: Packed Multiply of Unsigned 52-bit Unsigned Integers and Add High 52-bit Products to Quadword Accumulators (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPMADD52HUQ.BCST.Z m64 xmm k xmm
//	VPMADD52HUQ.BCST.Z m64 ymm k ymm
//	VPMADD52HUQ.BCST.Z m64 zmm k zmm
func VPMADD52HUQ_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMADD52HUQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPMADD52HUQ_Z: Packed Multiply of Unsigned 52-bit Unsigned Integers and Add High 52-bit Products to Quadword Accumulators (Zeroing Masking).
//
// Forms:
//
//	VPMADD52HUQ.Z m128 xmm k xmm
//	VPMADD52HUQ.Z m256 ymm k ymm
//	VPMADD52HUQ.Z xmm  xmm k xmm
//	VPMADD52HUQ.Z ymm  ymm k ymm
//	VPMADD52HUQ.Z m512 zmm k zmm
//	VPMADD52HUQ.Z zmm  zmm k zmm
func VPMADD52HUQ_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMADD52HUQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMADD52LUQ: Packed Multiply of Unsigned 52-bit Integers and Add the Low 52-bit Products to Quadword Accumulators.
//
// Forms:
//
//	VPMADD52LUQ m128 xmm k xmm
//	VPMADD52LUQ m128 xmm xmm
//	VPMADD52LUQ m256 ymm k ymm
//	VPMADD52LUQ m256 ymm ymm
//	VPMADD52LUQ xmm  xmm k xmm
//	VPMADD52LUQ xmm  xmm xmm
//	VPMADD52LUQ ymm  ymm k ymm
//	VPMADD52LUQ ymm  ymm ymm
//	VPMADD52LUQ m512 zmm k zmm
//	VPMADD52LUQ m512 zmm zmm
//	VPMADD52LUQ zmm  zmm k zmm
//	VPMADD52LUQ zmm  zmm zmm
func VPMADD52LUQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMADD52LUQ.Forms(), sffxs{}, ops)
}

// VPMADD52LUQ_BCST: Packed Multiply of Unsigned 52-bit Integers and Add the Low 52-bit Products to Quadword Accumulators (Broadcast).
//
// Forms:
//
//	VPMADD52LUQ.BCST m64 xmm k xmm
//	VPMADD52LUQ.BCST m64 xmm xmm
//	VPMADD52LUQ.BCST m64 ymm k ymm
//	VPMADD52LUQ.BCST m64 ymm ymm
//	VPMADD52LUQ.BCST m64 zmm k zmm
//	VPMADD52LUQ.BCST m64 zmm zmm
func VPMADD52LUQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMADD52LUQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPMADD52LUQ_BCST_Z: Packed Multiply of Unsigned 52-bit Integers and Add the Low 52-bit Products to Quadword Accumulators (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPMADD52LUQ.BCST.Z m64 xmm k xmm
//	VPMADD52LUQ.BCST.Z m64 ymm k ymm
//	VPMADD52LUQ.BCST.Z m64 zmm k zmm
func VPMADD52LUQ_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMADD52LUQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPMADD52LUQ_Z: Packed Multiply of Unsigned 52-bit Integers and Add the Low 52-bit Products to Quadword Accumulators (Zeroing Masking).
//
// Forms:
//
//	VPMADD52LUQ.Z m128 xmm k xmm
//	VPMADD52LUQ.Z m256 ymm k ymm
//	VPMADD52LUQ.Z xmm  xmm k xmm
//	VPMADD52LUQ.Z ymm  ymm k ymm
//	VPMADD52LUQ.Z m512 zmm k zmm
//	VPMADD52LUQ.Z zmm  zmm k zmm
func VPMADD52LUQ_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMADD52LUQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMADDUBSW: Multiply and Add Packed Signed and Unsigned Byte Integers.
//
// Forms:
//
//	VPMADDUBSW m256 ymm ymm
//	VPMADDUBSW ymm  ymm ymm
//	VPMADDUBSW m128 xmm xmm
//	VPMADDUBSW xmm  xmm xmm
//	VPMADDUBSW m128 xmm k xmm
//	VPMADDUBSW m256 ymm k ymm
//	VPMADDUBSW xmm  xmm k xmm
//	VPMADDUBSW ymm  ymm k ymm
//	VPMADDUBSW m512 zmm k zmm
//	VPMADDUBSW m512 zmm zmm
//	VPMADDUBSW zmm  zmm k zmm
//	VPMADDUBSW zmm  zmm zmm
func VPMADDUBSW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMADDUBSW.Forms(), sffxs{}, ops)
}

// VPMADDUBSW_Z: Multiply and Add Packed Signed and Unsigned Byte Integers (Zeroing Masking).
//
// Forms:
//
//	VPMADDUBSW.Z m128 xmm k xmm
//	VPMADDUBSW.Z m256 ymm k ymm
//	VPMADDUBSW.Z xmm  xmm k xmm
//	VPMADDUBSW.Z ymm  ymm k ymm
//	VPMADDUBSW.Z m512 zmm k zmm
//	VPMADDUBSW.Z zmm  zmm k zmm
func VPMADDUBSW_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMADDUBSW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMADDWD: Multiply and Add Packed Signed Word Integers.
//
// Forms:
//
//	VPMADDWD m256 ymm ymm
//	VPMADDWD ymm  ymm ymm
//	VPMADDWD m128 xmm xmm
//	VPMADDWD xmm  xmm xmm
//	VPMADDWD m128 xmm k xmm
//	VPMADDWD m256 ymm k ymm
//	VPMADDWD xmm  xmm k xmm
//	VPMADDWD ymm  ymm k ymm
//	VPMADDWD m512 zmm k zmm
//	VPMADDWD m512 zmm zmm
//	VPMADDWD zmm  zmm k zmm
//	VPMADDWD zmm  zmm zmm
func VPMADDWD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMADDWD.Forms(), sffxs{}, ops)
}

// VPMADDWD_Z: Multiply and Add Packed Signed Word Integers (Zeroing Masking).
//
// Forms:
//
//	VPMADDWD.Z m128 xmm k xmm
//	VPMADDWD.Z m256 ymm k ymm
//	VPMADDWD.Z xmm  xmm k xmm
//	VPMADDWD.Z ymm  ymm k ymm
//	VPMADDWD.Z m512 zmm k zmm
//	VPMADDWD.Z zmm  zmm k zmm
func VPMADDWD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMADDWD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMASKMOVD: Conditional Move Packed Doubleword Integers.
//
// Forms:
//
//	VPMASKMOVD m128 xmm xmm
//	VPMASKMOVD m256 ymm ymm
//	VPMASKMOVD xmm  xmm m128
//	VPMASKMOVD ymm  ymm m256
func VPMASKMOVD(mxy, xy, mxy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMASKMOVD.Forms(), sffxs{}, []operand.Op{mxy, xy, mxy1})
}

// VPMASKMOVQ: Conditional Move Packed Quadword Integers.
//
// Forms:
//
//	VPMASKMOVQ m128 xmm xmm
//	VPMASKMOVQ m256 ymm ymm
//	VPMASKMOVQ xmm  xmm m128
//	VPMASKMOVQ ymm  ymm m256
func VPMASKMOVQ(mxy, xy, mxy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMASKMOVQ.Forms(), sffxs{}, []operand.Op{mxy, xy, mxy1})
}

// VPMAXSB: Maximum of Packed Signed Byte Integers.
//
// Forms:
//
//	VPMAXSB m256 ymm ymm
//	VPMAXSB ymm  ymm ymm
//	VPMAXSB m128 xmm xmm
//	VPMAXSB xmm  xmm xmm
//	VPMAXSB m128 xmm k xmm
//	VPMAXSB m256 ymm k ymm
//	VPMAXSB xmm  xmm k xmm
//	VPMAXSB ymm  ymm k ymm
//	VPMAXSB m512 zmm k zmm
//	VPMAXSB m512 zmm zmm
//	VPMAXSB zmm  zmm k zmm
//	VPMAXSB zmm  zmm zmm
func VPMAXSB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXSB.Forms(), sffxs{}, ops)
}

// VPMAXSB_Z: Maximum of Packed Signed Byte Integers (Zeroing Masking).
//
// Forms:
//
//	VPMAXSB.Z m128 xmm k xmm
//	VPMAXSB.Z m256 ymm k ymm
//	VPMAXSB.Z xmm  xmm k xmm
//	VPMAXSB.Z ymm  ymm k ymm
//	VPMAXSB.Z m512 zmm k zmm
//	VPMAXSB.Z zmm  zmm k zmm
func VPMAXSB_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXSB.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMAXSD: Maximum of Packed Signed Doubleword Integers.
//
// Forms:
//
//	VPMAXSD m256 ymm ymm
//	VPMAXSD ymm  ymm ymm
//	VPMAXSD m128 xmm xmm
//	VPMAXSD xmm  xmm xmm
//	VPMAXSD m128 xmm k xmm
//	VPMAXSD m256 ymm k ymm
//	VPMAXSD xmm  xmm k xmm
//	VPMAXSD ymm  ymm k ymm
//	VPMAXSD m512 zmm k zmm
//	VPMAXSD m512 zmm zmm
//	VPMAXSD zmm  zmm k zmm
//	VPMAXSD zmm  zmm zmm
func VPMAXSD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXSD.Forms(), sffxs{}, ops)
}

// VPMAXSD_BCST: Maximum of Packed Signed Doubleword Integers (Broadcast).
//
// Forms:
//
//	VPMAXSD.BCST m32 xmm k xmm
//	VPMAXSD.BCST m32 xmm xmm
//	VPMAXSD.BCST m32 ymm k ymm
//	VPMAXSD.BCST m32 ymm ymm
//	VPMAXSD.BCST m32 zmm k zmm
//	VPMAXSD.BCST m32 zmm zmm
func VPMAXSD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXSD.Forms(), sffxs{sffxBCST}, ops)
}

// VPMAXSD_BCST_Z: Maximum of Packed Signed Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPMAXSD.BCST.Z m32 xmm k xmm
//	VPMAXSD.BCST.Z m32 ymm k ymm
//	VPMAXSD.BCST.Z m32 zmm k zmm
func VPMAXSD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXSD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPMAXSD_Z: Maximum of Packed Signed Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VPMAXSD.Z m128 xmm k xmm
//	VPMAXSD.Z m256 ymm k ymm
//	VPMAXSD.Z xmm  xmm k xmm
//	VPMAXSD.Z ymm  ymm k ymm
//	VPMAXSD.Z m512 zmm k zmm
//	VPMAXSD.Z zmm  zmm k zmm
func VPMAXSD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXSD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMAXSQ: Maximum of Packed Signed Quadword Integers.
//
// Forms:
//
//	VPMAXSQ m128 xmm k xmm
//	VPMAXSQ m128 xmm xmm
//	VPMAXSQ m256 ymm k ymm
//	VPMAXSQ m256 ymm ymm
//	VPMAXSQ xmm  xmm k xmm
//	VPMAXSQ xmm  xmm xmm
//	VPMAXSQ ymm  ymm k ymm
//	VPMAXSQ ymm  ymm ymm
//	VPMAXSQ m512 zmm k zmm
//	VPMAXSQ m512 zmm zmm
//	VPMAXSQ zmm  zmm k zmm
//	VPMAXSQ zmm  zmm zmm
func VPMAXSQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXSQ.Forms(), sffxs{}, ops)
}

// VPMAXSQ_BCST: Maximum of Packed Signed Quadword Integers (Broadcast).
//
// Forms:
//
//	VPMAXSQ.BCST m64 xmm k xmm
//	VPMAXSQ.BCST m64 xmm xmm
//	VPMAXSQ.BCST m64 ymm k ymm
//	VPMAXSQ.BCST m64 ymm ymm
//	VPMAXSQ.BCST m64 zmm k zmm
//	VPMAXSQ.BCST m64 zmm zmm
func VPMAXSQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXSQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPMAXSQ_BCST_Z: Maximum of Packed Signed Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPMAXSQ.BCST.Z m64 xmm k xmm
//	VPMAXSQ.BCST.Z m64 ymm k ymm
//	VPMAXSQ.BCST.Z m64 zmm k zmm
func VPMAXSQ_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXSQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPMAXSQ_Z: Maximum of Packed Signed Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VPMAXSQ.Z m128 xmm k xmm
//	VPMAXSQ.Z m256 ymm k ymm
//	VPMAXSQ.Z xmm  xmm k xmm
//	VPMAXSQ.Z ymm  ymm k ymm
//	VPMAXSQ.Z m512 zmm k zmm
//	VPMAXSQ.Z zmm  zmm k zmm
func VPMAXSQ_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXSQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMAXSW: Maximum of Packed Signed Word Integers.
//
// Forms:
//
//	VPMAXSW m256 ymm ymm
//	VPMAXSW ymm  ymm ymm
//	VPMAXSW m128 xmm xmm
//	VPMAXSW xmm  xmm xmm
//	VPMAXSW m128 xmm k xmm
//	VPMAXSW m256 ymm k ymm
//	VPMAXSW xmm  xmm k xmm
//	VPMAXSW ymm  ymm k ymm
//	VPMAXSW m512 zmm k zmm
//	VPMAXSW m512 zmm zmm
//	VPMAXSW zmm  zmm k zmm
//	VPMAXSW zmm  zmm zmm
func VPMAXSW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXSW.Forms(), sffxs{}, ops)
}

// VPMAXSW_Z: Maximum of Packed Signed Word Integers (Zeroing Masking).
//
// Forms:
//
//	VPMAXSW.Z m128 xmm k xmm
//	VPMAXSW.Z m256 ymm k ymm
//	VPMAXSW.Z xmm  xmm k xmm
//	VPMAXSW.Z ymm  ymm k ymm
//	VPMAXSW.Z m512 zmm k zmm
//	VPMAXSW.Z zmm  zmm k zmm
func VPMAXSW_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXSW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMAXUB: Maximum of Packed Unsigned Byte Integers.
//
// Forms:
//
//	VPMAXUB m256 ymm ymm
//	VPMAXUB ymm  ymm ymm
//	VPMAXUB m128 xmm xmm
//	VPMAXUB xmm  xmm xmm
//	VPMAXUB m128 xmm k xmm
//	VPMAXUB m256 ymm k ymm
//	VPMAXUB xmm  xmm k xmm
//	VPMAXUB ymm  ymm k ymm
//	VPMAXUB m512 zmm k zmm
//	VPMAXUB m512 zmm zmm
//	VPMAXUB zmm  zmm k zmm
//	VPMAXUB zmm  zmm zmm
func VPMAXUB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXUB.Forms(), sffxs{}, ops)
}

// VPMAXUB_Z: Maximum of Packed Unsigned Byte Integers (Zeroing Masking).
//
// Forms:
//
//	VPMAXUB.Z m128 xmm k xmm
//	VPMAXUB.Z m256 ymm k ymm
//	VPMAXUB.Z xmm  xmm k xmm
//	VPMAXUB.Z ymm  ymm k ymm
//	VPMAXUB.Z m512 zmm k zmm
//	VPMAXUB.Z zmm  zmm k zmm
func VPMAXUB_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXUB.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMAXUD: Maximum of Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	VPMAXUD m256 ymm ymm
//	VPMAXUD ymm  ymm ymm
//	VPMAXUD m128 xmm xmm
//	VPMAXUD xmm  xmm xmm
//	VPMAXUD m128 xmm k xmm
//	VPMAXUD m256 ymm k ymm
//	VPMAXUD xmm  xmm k xmm
//	VPMAXUD ymm  ymm k ymm
//	VPMAXUD m512 zmm k zmm
//	VPMAXUD m512 zmm zmm
//	VPMAXUD zmm  zmm k zmm
//	VPMAXUD zmm  zmm zmm
func VPMAXUD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXUD.Forms(), sffxs{}, ops)
}

// VPMAXUD_BCST: Maximum of Packed Unsigned Doubleword Integers (Broadcast).
//
// Forms:
//
//	VPMAXUD.BCST m32 xmm k xmm
//	VPMAXUD.BCST m32 xmm xmm
//	VPMAXUD.BCST m32 ymm k ymm
//	VPMAXUD.BCST m32 ymm ymm
//	VPMAXUD.BCST m32 zmm k zmm
//	VPMAXUD.BCST m32 zmm zmm
func VPMAXUD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXUD.Forms(), sffxs{sffxBCST}, ops)
}

// VPMAXUD_BCST_Z: Maximum of Packed Unsigned Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPMAXUD.BCST.Z m32 xmm k xmm
//	VPMAXUD.BCST.Z m32 ymm k ymm
//	VPMAXUD.BCST.Z m32 zmm k zmm
func VPMAXUD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXUD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPMAXUD_Z: Maximum of Packed Unsigned Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VPMAXUD.Z m128 xmm k xmm
//	VPMAXUD.Z m256 ymm k ymm
//	VPMAXUD.Z xmm  xmm k xmm
//	VPMAXUD.Z ymm  ymm k ymm
//	VPMAXUD.Z m512 zmm k zmm
//	VPMAXUD.Z zmm  zmm k zmm
func VPMAXUD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXUD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMAXUQ: Maximum of Packed Unsigned Quadword Integers.
//
// Forms:
//
//	VPMAXUQ m128 xmm k xmm
//	VPMAXUQ m128 xmm xmm
//	VPMAXUQ m256 ymm k ymm
//	VPMAXUQ m256 ymm ymm
//	VPMAXUQ xmm  xmm k xmm
//	VPMAXUQ xmm  xmm xmm
//	VPMAXUQ ymm  ymm k ymm
//	VPMAXUQ ymm  ymm ymm
//	VPMAXUQ m512 zmm k zmm
//	VPMAXUQ m512 zmm zmm
//	VPMAXUQ zmm  zmm k zmm
//	VPMAXUQ zmm  zmm zmm
func VPMAXUQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXUQ.Forms(), sffxs{}, ops)
}

// VPMAXUQ_BCST: Maximum of Packed Unsigned Quadword Integers (Broadcast).
//
// Forms:
//
//	VPMAXUQ.BCST m64 xmm k xmm
//	VPMAXUQ.BCST m64 xmm xmm
//	VPMAXUQ.BCST m64 ymm k ymm
//	VPMAXUQ.BCST m64 ymm ymm
//	VPMAXUQ.BCST m64 zmm k zmm
//	VPMAXUQ.BCST m64 zmm zmm
func VPMAXUQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXUQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPMAXUQ_BCST_Z: Maximum of Packed Unsigned Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPMAXUQ.BCST.Z m64 xmm k xmm
//	VPMAXUQ.BCST.Z m64 ymm k ymm
//	VPMAXUQ.BCST.Z m64 zmm k zmm
func VPMAXUQ_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXUQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPMAXUQ_Z: Maximum of Packed Unsigned Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VPMAXUQ.Z m128 xmm k xmm
//	VPMAXUQ.Z m256 ymm k ymm
//	VPMAXUQ.Z xmm  xmm k xmm
//	VPMAXUQ.Z ymm  ymm k ymm
//	VPMAXUQ.Z m512 zmm k zmm
//	VPMAXUQ.Z zmm  zmm k zmm
func VPMAXUQ_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXUQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMAXUW: Maximum of Packed Unsigned Word Integers.
//
// Forms:
//
//	VPMAXUW m256 ymm ymm
//	VPMAXUW ymm  ymm ymm
//	VPMAXUW m128 xmm xmm
//	VPMAXUW xmm  xmm xmm
//	VPMAXUW m128 xmm k xmm
//	VPMAXUW m256 ymm k ymm
//	VPMAXUW xmm  xmm k xmm
//	VPMAXUW ymm  ymm k ymm
//	VPMAXUW m512 zmm k zmm
//	VPMAXUW m512 zmm zmm
//	VPMAXUW zmm  zmm k zmm
//	VPMAXUW zmm  zmm zmm
func VPMAXUW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXUW.Forms(), sffxs{}, ops)
}

// VPMAXUW_Z: Maximum of Packed Unsigned Word Integers (Zeroing Masking).
//
// Forms:
//
//	VPMAXUW.Z m128 xmm k xmm
//	VPMAXUW.Z m256 ymm k ymm
//	VPMAXUW.Z xmm  xmm k xmm
//	VPMAXUW.Z ymm  ymm k ymm
//	VPMAXUW.Z m512 zmm k zmm
//	VPMAXUW.Z zmm  zmm k zmm
func VPMAXUW_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMAXUW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMINSB: Minimum of Packed Signed Byte Integers.
//
// Forms:
//
//	VPMINSB m256 ymm ymm
//	VPMINSB ymm  ymm ymm
//	VPMINSB m128 xmm xmm
//	VPMINSB xmm  xmm xmm
//	VPMINSB m128 xmm k xmm
//	VPMINSB m256 ymm k ymm
//	VPMINSB xmm  xmm k xmm
//	VPMINSB ymm  ymm k ymm
//	VPMINSB m512 zmm k zmm
//	VPMINSB m512 zmm zmm
//	VPMINSB zmm  zmm k zmm
//	VPMINSB zmm  zmm zmm
func VPMINSB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINSB.Forms(), sffxs{}, ops)
}

// VPMINSB_Z: Minimum of Packed Signed Byte Integers (Zeroing Masking).
//
// Forms:
//
//	VPMINSB.Z m128 xmm k xmm
//	VPMINSB.Z m256 ymm k ymm
//	VPMINSB.Z xmm  xmm k xmm
//	VPMINSB.Z ymm  ymm k ymm
//	VPMINSB.Z m512 zmm k zmm
//	VPMINSB.Z zmm  zmm k zmm
func VPMINSB_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINSB.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMINSD: Minimum of Packed Signed Doubleword Integers.
//
// Forms:
//
//	VPMINSD m256 ymm ymm
//	VPMINSD ymm  ymm ymm
//	VPMINSD m128 xmm xmm
//	VPMINSD xmm  xmm xmm
//	VPMINSD m128 xmm k xmm
//	VPMINSD m256 ymm k ymm
//	VPMINSD xmm  xmm k xmm
//	VPMINSD ymm  ymm k ymm
//	VPMINSD m512 zmm k zmm
//	VPMINSD m512 zmm zmm
//	VPMINSD zmm  zmm k zmm
//	VPMINSD zmm  zmm zmm
func VPMINSD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINSD.Forms(), sffxs{}, ops)
}

// VPMINSD_BCST: Minimum of Packed Signed Doubleword Integers (Broadcast).
//
// Forms:
//
//	VPMINSD.BCST m32 xmm k xmm
//	VPMINSD.BCST m32 xmm xmm
//	VPMINSD.BCST m32 ymm k ymm
//	VPMINSD.BCST m32 ymm ymm
//	VPMINSD.BCST m32 zmm k zmm
//	VPMINSD.BCST m32 zmm zmm
func VPMINSD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINSD.Forms(), sffxs{sffxBCST}, ops)
}

// VPMINSD_BCST_Z: Minimum of Packed Signed Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPMINSD.BCST.Z m32 xmm k xmm
//	VPMINSD.BCST.Z m32 ymm k ymm
//	VPMINSD.BCST.Z m32 zmm k zmm
func VPMINSD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINSD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPMINSD_Z: Minimum of Packed Signed Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VPMINSD.Z m128 xmm k xmm
//	VPMINSD.Z m256 ymm k ymm
//	VPMINSD.Z xmm  xmm k xmm
//	VPMINSD.Z ymm  ymm k ymm
//	VPMINSD.Z m512 zmm k zmm
//	VPMINSD.Z zmm  zmm k zmm
func VPMINSD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINSD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMINSQ: Minimum of Packed Signed Quadword Integers.
//
// Forms:
//
//	VPMINSQ m128 xmm k xmm
//	VPMINSQ m128 xmm xmm
//	VPMINSQ m256 ymm k ymm
//	VPMINSQ m256 ymm ymm
//	VPMINSQ xmm  xmm k xmm
//	VPMINSQ xmm  xmm xmm
//	VPMINSQ ymm  ymm k ymm
//	VPMINSQ ymm  ymm ymm
//	VPMINSQ m512 zmm k zmm
//	VPMINSQ m512 zmm zmm
//	VPMINSQ zmm  zmm k zmm
//	VPMINSQ zmm  zmm zmm
func VPMINSQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINSQ.Forms(), sffxs{}, ops)
}

// VPMINSQ_BCST: Minimum of Packed Signed Quadword Integers (Broadcast).
//
// Forms:
//
//	VPMINSQ.BCST m64 xmm k xmm
//	VPMINSQ.BCST m64 xmm xmm
//	VPMINSQ.BCST m64 ymm k ymm
//	VPMINSQ.BCST m64 ymm ymm
//	VPMINSQ.BCST m64 zmm k zmm
//	VPMINSQ.BCST m64 zmm zmm
func VPMINSQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINSQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPMINSQ_BCST_Z: Minimum of Packed Signed Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPMINSQ.BCST.Z m64 xmm k xmm
//	VPMINSQ.BCST.Z m64 ymm k ymm
//	VPMINSQ.BCST.Z m64 zmm k zmm
func VPMINSQ_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINSQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPMINSQ_Z: Minimum of Packed Signed Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VPMINSQ.Z m128 xmm k xmm
//	VPMINSQ.Z m256 ymm k ymm
//	VPMINSQ.Z xmm  xmm k xmm
//	VPMINSQ.Z ymm  ymm k ymm
//	VPMINSQ.Z m512 zmm k zmm
//	VPMINSQ.Z zmm  zmm k zmm
func VPMINSQ_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINSQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMINSW: Minimum of Packed Signed Word Integers.
//
// Forms:
//
//	VPMINSW m256 ymm ymm
//	VPMINSW ymm  ymm ymm
//	VPMINSW m128 xmm xmm
//	VPMINSW xmm  xmm xmm
//	VPMINSW m128 xmm k xmm
//	VPMINSW m256 ymm k ymm
//	VPMINSW xmm  xmm k xmm
//	VPMINSW ymm  ymm k ymm
//	VPMINSW m512 zmm k zmm
//	VPMINSW m512 zmm zmm
//	VPMINSW zmm  zmm k zmm
//	VPMINSW zmm  zmm zmm
func VPMINSW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINSW.Forms(), sffxs{}, ops)
}

// VPMINSW_Z: Minimum of Packed Signed Word Integers (Zeroing Masking).
//
// Forms:
//
//	VPMINSW.Z m128 xmm k xmm
//	VPMINSW.Z m256 ymm k ymm
//	VPMINSW.Z xmm  xmm k xmm
//	VPMINSW.Z ymm  ymm k ymm
//	VPMINSW.Z m512 zmm k zmm
//	VPMINSW.Z zmm  zmm k zmm
func VPMINSW_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINSW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMINUB: Minimum of Packed Unsigned Byte Integers.
//
// Forms:
//
//	VPMINUB m256 ymm ymm
//	VPMINUB ymm  ymm ymm
//	VPMINUB m128 xmm xmm
//	VPMINUB xmm  xmm xmm
//	VPMINUB m128 xmm k xmm
//	VPMINUB m256 ymm k ymm
//	VPMINUB xmm  xmm k xmm
//	VPMINUB ymm  ymm k ymm
//	VPMINUB m512 zmm k zmm
//	VPMINUB m512 zmm zmm
//	VPMINUB zmm  zmm k zmm
//	VPMINUB zmm  zmm zmm
func VPMINUB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINUB.Forms(), sffxs{}, ops)
}

// VPMINUB_Z: Minimum of Packed Unsigned Byte Integers (Zeroing Masking).
//
// Forms:
//
//	VPMINUB.Z m128 xmm k xmm
//	VPMINUB.Z m256 ymm k ymm
//	VPMINUB.Z xmm  xmm k xmm
//	VPMINUB.Z ymm  ymm k ymm
//	VPMINUB.Z m512 zmm k zmm
//	VPMINUB.Z zmm  zmm k zmm
func VPMINUB_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINUB.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMINUD: Minimum of Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	VPMINUD m256 ymm ymm
//	VPMINUD ymm  ymm ymm
//	VPMINUD m128 xmm xmm
//	VPMINUD xmm  xmm xmm
//	VPMINUD m128 xmm k xmm
//	VPMINUD m256 ymm k ymm
//	VPMINUD xmm  xmm k xmm
//	VPMINUD ymm  ymm k ymm
//	VPMINUD m512 zmm k zmm
//	VPMINUD m512 zmm zmm
//	VPMINUD zmm  zmm k zmm
//	VPMINUD zmm  zmm zmm
func VPMINUD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINUD.Forms(), sffxs{}, ops)
}

// VPMINUD_BCST: Minimum of Packed Unsigned Doubleword Integers (Broadcast).
//
// Forms:
//
//	VPMINUD.BCST m32 xmm k xmm
//	VPMINUD.BCST m32 xmm xmm
//	VPMINUD.BCST m32 ymm k ymm
//	VPMINUD.BCST m32 ymm ymm
//	VPMINUD.BCST m32 zmm k zmm
//	VPMINUD.BCST m32 zmm zmm
func VPMINUD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINUD.Forms(), sffxs{sffxBCST}, ops)
}

// VPMINUD_BCST_Z: Minimum of Packed Unsigned Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPMINUD.BCST.Z m32 xmm k xmm
//	VPMINUD.BCST.Z m32 ymm k ymm
//	VPMINUD.BCST.Z m32 zmm k zmm
func VPMINUD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINUD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPMINUD_Z: Minimum of Packed Unsigned Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VPMINUD.Z m128 xmm k xmm
//	VPMINUD.Z m256 ymm k ymm
//	VPMINUD.Z xmm  xmm k xmm
//	VPMINUD.Z ymm  ymm k ymm
//	VPMINUD.Z m512 zmm k zmm
//	VPMINUD.Z zmm  zmm k zmm
func VPMINUD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINUD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMINUQ: Minimum of Packed Unsigned Quadword Integers.
//
// Forms:
//
//	VPMINUQ m128 xmm k xmm
//	VPMINUQ m128 xmm xmm
//	VPMINUQ m256 ymm k ymm
//	VPMINUQ m256 ymm ymm
//	VPMINUQ xmm  xmm k xmm
//	VPMINUQ xmm  xmm xmm
//	VPMINUQ ymm  ymm k ymm
//	VPMINUQ ymm  ymm ymm
//	VPMINUQ m512 zmm k zmm
//	VPMINUQ m512 zmm zmm
//	VPMINUQ zmm  zmm k zmm
//	VPMINUQ zmm  zmm zmm
func VPMINUQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINUQ.Forms(), sffxs{}, ops)
}

// VPMINUQ_BCST: Minimum of Packed Unsigned Quadword Integers (Broadcast).
//
// Forms:
//
//	VPMINUQ.BCST m64 xmm k xmm
//	VPMINUQ.BCST m64 xmm xmm
//	VPMINUQ.BCST m64 ymm k ymm
//	VPMINUQ.BCST m64 ymm ymm
//	VPMINUQ.BCST m64 zmm k zmm
//	VPMINUQ.BCST m64 zmm zmm
func VPMINUQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINUQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPMINUQ_BCST_Z: Minimum of Packed Unsigned Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPMINUQ.BCST.Z m64 xmm k xmm
//	VPMINUQ.BCST.Z m64 ymm k ymm
//	VPMINUQ.BCST.Z m64 zmm k zmm
func VPMINUQ_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINUQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPMINUQ_Z: Minimum of Packed Unsigned Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VPMINUQ.Z m128 xmm k xmm
//	VPMINUQ.Z m256 ymm k ymm
//	VPMINUQ.Z xmm  xmm k xmm
//	VPMINUQ.Z ymm  ymm k ymm
//	VPMINUQ.Z m512 zmm k zmm
//	VPMINUQ.Z zmm  zmm k zmm
func VPMINUQ_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINUQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMINUW: Minimum of Packed Unsigned Word Integers.
//
// Forms:
//
//	VPMINUW m256 ymm ymm
//	VPMINUW ymm  ymm ymm
//	VPMINUW m128 xmm xmm
//	VPMINUW xmm  xmm xmm
//	VPMINUW m128 xmm k xmm
//	VPMINUW m256 ymm k ymm
//	VPMINUW xmm  xmm k xmm
//	VPMINUW ymm  ymm k ymm
//	VPMINUW m512 zmm k zmm
//	VPMINUW m512 zmm zmm
//	VPMINUW zmm  zmm k zmm
//	VPMINUW zmm  zmm zmm
func VPMINUW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINUW.Forms(), sffxs{}, ops)
}

// VPMINUW_Z: Minimum of Packed Unsigned Word Integers (Zeroing Masking).
//
// Forms:
//
//	VPMINUW.Z m128 xmm k xmm
//	VPMINUW.Z m256 ymm k ymm
//	VPMINUW.Z xmm  xmm k xmm
//	VPMINUW.Z ymm  ymm k ymm
//	VPMINUW.Z m512 zmm k zmm
//	VPMINUW.Z zmm  zmm k zmm
func VPMINUW_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMINUW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMOVB2M: Move Signs of Packed Byte Integers to Mask Register.
//
// Forms:
//
//	VPMOVB2M xmm k
//	VPMOVB2M ymm k
//	VPMOVB2M zmm k
func VPMOVB2M(xyz, k operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVB2M.Forms(), sffxs{}, []operand.Op{xyz, k})
}

// VPMOVD2M: Move Signs of Packed Doubleword Integers to Mask Register.
//
// Forms:
//
//	VPMOVD2M xmm k
//	VPMOVD2M ymm k
//	VPMOVD2M zmm k
func VPMOVD2M(xyz, k operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVD2M.Forms(), sffxs{}, []operand.Op{xyz, k})
}

// VPMOVDB: Down Convert Packed Doubleword Values to Byte Values with Truncation.
//
// Forms:
//
//	VPMOVDB xmm k m32
//	VPMOVDB xmm k xmm
//	VPMOVDB xmm m32
//	VPMOVDB xmm xmm
//	VPMOVDB ymm k m64
//	VPMOVDB ymm k xmm
//	VPMOVDB ymm m64
//	VPMOVDB ymm xmm
//	VPMOVDB zmm k m128
//	VPMOVDB zmm k xmm
//	VPMOVDB zmm m128
//	VPMOVDB zmm xmm
func VPMOVDB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVDB.Forms(), sffxs{}, ops)
}

// VPMOVDB_Z: Down Convert Packed Doubleword Values to Byte Values with Truncation (Zeroing Masking).
//
// Forms:
//
//	VPMOVDB.Z xmm k m32
//	VPMOVDB.Z xmm k xmm
//	VPMOVDB.Z ymm k m64
//	VPMOVDB.Z ymm k xmm
//	VPMOVDB.Z zmm k m128
//	VPMOVDB.Z zmm k xmm
func VPMOVDB_Z(xyz, k, mx operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVDB.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mx})
}

// VPMOVDW: Down Convert Packed Doubleword Values to Word Values with Truncation.
//
// Forms:
//
//	VPMOVDW xmm k m64
//	VPMOVDW xmm k xmm
//	VPMOVDW xmm m64
//	VPMOVDW xmm xmm
//	VPMOVDW ymm k m128
//	VPMOVDW ymm k xmm
//	VPMOVDW ymm m128
//	VPMOVDW ymm xmm
//	VPMOVDW zmm k m256
//	VPMOVDW zmm k ymm
//	VPMOVDW zmm m256
//	VPMOVDW zmm ymm
func VPMOVDW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVDW.Forms(), sffxs{}, ops)
}

// VPMOVDW_Z: Down Convert Packed Doubleword Values to Word Values with Truncation (Zeroing Masking).
//
// Forms:
//
//	VPMOVDW.Z xmm k m64
//	VPMOVDW.Z xmm k xmm
//	VPMOVDW.Z ymm k m128
//	VPMOVDW.Z ymm k xmm
//	VPMOVDW.Z zmm k m256
//	VPMOVDW.Z zmm k ymm
func VPMOVDW_Z(xyz, k, mxy operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVDW.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mxy})
}

// VPMOVM2B: Expand Bits of Mask Register to Packed Byte Integers.
//
// Forms:
//
//	VPMOVM2B k xmm
//	VPMOVM2B k ymm
//	VPMOVM2B k zmm
func VPMOVM2B(k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVM2B.Forms(), sffxs{}, []operand.Op{k, xyz})
}

// VPMOVM2D: Expand Bits of Mask Register to Packed Doubleword Integers.
//
// Forms:
//
//	VPMOVM2D k xmm
//	VPMOVM2D k ymm
//	VPMOVM2D k zmm
func VPMOVM2D(k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVM2D.Forms(), sffxs{}, []operand.Op{k, xyz})
}

// VPMOVM2Q: Expand Bits of Mask Register to Packed Quadword Integers.
//
// Forms:
//
//	VPMOVM2Q k xmm
//	VPMOVM2Q k ymm
//	VPMOVM2Q k zmm
func VPMOVM2Q(k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVM2Q.Forms(), sffxs{}, []operand.Op{k, xyz})
}

// VPMOVM2W: Expand Bits of Mask Register to Packed Word Integers.
//
// Forms:
//
//	VPMOVM2W k xmm
//	VPMOVM2W k ymm
//	VPMOVM2W k zmm
func VPMOVM2W(k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVM2W.Forms(), sffxs{}, []operand.Op{k, xyz})
}

// VPMOVMSKB: Move Byte Mask.
//
// Forms:
//
//	VPMOVMSKB ymm r32
//	VPMOVMSKB xmm r32
func VPMOVMSKB(xy, r operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVMSKB.Forms(), sffxs{}, []operand.Op{xy, r})
}

// VPMOVQ2M: Move Signs of Packed Quadword Integers to Mask Register.
//
// Forms:
//
//	VPMOVQ2M xmm k
//	VPMOVQ2M ymm k
//	VPMOVQ2M zmm k
func VPMOVQ2M(xyz, k operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVQ2M.Forms(), sffxs{}, []operand.Op{xyz, k})
}

// VPMOVQB: Down Convert Packed Quadword Values to Byte Values with Truncation.
//
// Forms:
//
//	VPMOVQB xmm k m16
//	VPMOVQB xmm k xmm
//	VPMOVQB xmm m16
//	VPMOVQB xmm xmm
//	VPMOVQB ymm k m32
//	VPMOVQB ymm k xmm
//	VPMOVQB ymm m32
//	VPMOVQB ymm xmm
//	VPMOVQB zmm k m64
//	VPMOVQB zmm k xmm
//	VPMOVQB zmm m64
//	VPMOVQB zmm xmm
func VPMOVQB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVQB.Forms(), sffxs{}, ops)
}

// VPMOVQB_Z: Down Convert Packed Quadword Values to Byte Values with Truncation (Zeroing Masking).
//
// Forms:
//
//	VPMOVQB.Z xmm k m16
//	VPMOVQB.Z xmm k xmm
//	VPMOVQB.Z ymm k m32
//	VPMOVQB.Z ymm k xmm
//	VPMOVQB.Z zmm k m64
//	VPMOVQB.Z zmm k xmm
func VPMOVQB_Z(xyz, k, mx operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVQB.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mx})
}

// VPMOVQD: Down Convert Packed Quadword Values to Doubleword Values with Truncation.
//
// Forms:
//
//	VPMOVQD xmm k m64
//	VPMOVQD xmm k xmm
//	VPMOVQD xmm m64
//	VPMOVQD xmm xmm
//	VPMOVQD ymm k m128
//	VPMOVQD ymm k xmm
//	VPMOVQD ymm m128
//	VPMOVQD ymm xmm
//	VPMOVQD zmm k m256
//	VPMOVQD zmm k ymm
//	VPMOVQD zmm m256
//	VPMOVQD zmm ymm
func VPMOVQD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVQD.Forms(), sffxs{}, ops)
}

// VPMOVQD_Z: Down Convert Packed Quadword Values to Doubleword Values with Truncation (Zeroing Masking).
//
// Forms:
//
//	VPMOVQD.Z xmm k m64
//	VPMOVQD.Z xmm k xmm
//	VPMOVQD.Z ymm k m128
//	VPMOVQD.Z ymm k xmm
//	VPMOVQD.Z zmm k m256
//	VPMOVQD.Z zmm k ymm
func VPMOVQD_Z(xyz, k, mxy operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVQD.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mxy})
}

// VPMOVQW: Down Convert Packed Quadword Values to Word Values with Truncation.
//
// Forms:
//
//	VPMOVQW xmm k m32
//	VPMOVQW xmm k xmm
//	VPMOVQW xmm m32
//	VPMOVQW xmm xmm
//	VPMOVQW ymm k m64
//	VPMOVQW ymm k xmm
//	VPMOVQW ymm m64
//	VPMOVQW ymm xmm
//	VPMOVQW zmm k m128
//	VPMOVQW zmm k xmm
//	VPMOVQW zmm m128
//	VPMOVQW zmm xmm
func VPMOVQW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVQW.Forms(), sffxs{}, ops)
}

// VPMOVQW_Z: Down Convert Packed Quadword Values to Word Values with Truncation (Zeroing Masking).
//
// Forms:
//
//	VPMOVQW.Z xmm k m32
//	VPMOVQW.Z xmm k xmm
//	VPMOVQW.Z ymm k m64
//	VPMOVQW.Z ymm k xmm
//	VPMOVQW.Z zmm k m128
//	VPMOVQW.Z zmm k xmm
func VPMOVQW_Z(xyz, k, mx operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVQW.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mx})
}

// VPMOVSDB: Down Convert Packed Doubleword Values to Byte Values with Signed Saturation.
//
// Forms:
//
//	VPMOVSDB xmm k m32
//	VPMOVSDB xmm k xmm
//	VPMOVSDB xmm m32
//	VPMOVSDB xmm xmm
//	VPMOVSDB ymm k m64
//	VPMOVSDB ymm k xmm
//	VPMOVSDB ymm m64
//	VPMOVSDB ymm xmm
//	VPMOVSDB zmm k m128
//	VPMOVSDB zmm k xmm
//	VPMOVSDB zmm m128
//	VPMOVSDB zmm xmm
func VPMOVSDB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSDB.Forms(), sffxs{}, ops)
}

// VPMOVSDB_Z: Down Convert Packed Doubleword Values to Byte Values with Signed Saturation (Zeroing Masking).
//
// Forms:
//
//	VPMOVSDB.Z xmm k m32
//	VPMOVSDB.Z xmm k xmm
//	VPMOVSDB.Z ymm k m64
//	VPMOVSDB.Z ymm k xmm
//	VPMOVSDB.Z zmm k m128
//	VPMOVSDB.Z zmm k xmm
func VPMOVSDB_Z(xyz, k, mx operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSDB.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mx})
}

// VPMOVSDW: Down Convert Packed Doubleword Values to Word Values with Signed Saturation.
//
// Forms:
//
//	VPMOVSDW xmm k m64
//	VPMOVSDW xmm k xmm
//	VPMOVSDW xmm m64
//	VPMOVSDW xmm xmm
//	VPMOVSDW ymm k m128
//	VPMOVSDW ymm k xmm
//	VPMOVSDW ymm m128
//	VPMOVSDW ymm xmm
//	VPMOVSDW zmm k m256
//	VPMOVSDW zmm k ymm
//	VPMOVSDW zmm m256
//	VPMOVSDW zmm ymm
func VPMOVSDW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSDW.Forms(), sffxs{}, ops)
}

// VPMOVSDW_Z: Down Convert Packed Doubleword Values to Word Values with Signed Saturation (Zeroing Masking).
//
// Forms:
//
//	VPMOVSDW.Z xmm k m64
//	VPMOVSDW.Z xmm k xmm
//	VPMOVSDW.Z ymm k m128
//	VPMOVSDW.Z ymm k xmm
//	VPMOVSDW.Z zmm k m256
//	VPMOVSDW.Z zmm k ymm
func VPMOVSDW_Z(xyz, k, mxy operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSDW.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mxy})
}

// VPMOVSQB: Down Convert Packed Quadword Values to Byte Values with Signed Saturation.
//
// Forms:
//
//	VPMOVSQB xmm k m16
//	VPMOVSQB xmm k xmm
//	VPMOVSQB xmm m16
//	VPMOVSQB xmm xmm
//	VPMOVSQB ymm k m32
//	VPMOVSQB ymm k xmm
//	VPMOVSQB ymm m32
//	VPMOVSQB ymm xmm
//	VPMOVSQB zmm k m64
//	VPMOVSQB zmm k xmm
//	VPMOVSQB zmm m64
//	VPMOVSQB zmm xmm
func VPMOVSQB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSQB.Forms(), sffxs{}, ops)
}

// VPMOVSQB_Z: Down Convert Packed Quadword Values to Byte Values with Signed Saturation (Zeroing Masking).
//
// Forms:
//
//	VPMOVSQB.Z xmm k m16
//	VPMOVSQB.Z xmm k xmm
//	VPMOVSQB.Z ymm k m32
//	VPMOVSQB.Z ymm k xmm
//	VPMOVSQB.Z zmm k m64
//	VPMOVSQB.Z zmm k xmm
func VPMOVSQB_Z(xyz, k, mx operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSQB.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mx})
}

// VPMOVSQD: Down Convert Packed Quadword Values to Doubleword Values with Signed Saturation.
//
// Forms:
//
//	VPMOVSQD xmm k m64
//	VPMOVSQD xmm k xmm
//	VPMOVSQD xmm m64
//	VPMOVSQD xmm xmm
//	VPMOVSQD ymm k m128
//	VPMOVSQD ymm k xmm
//	VPMOVSQD ymm m128
//	VPMOVSQD ymm xmm
//	VPMOVSQD zmm k m256
//	VPMOVSQD zmm k ymm
//	VPMOVSQD zmm m256
//	VPMOVSQD zmm ymm
func VPMOVSQD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSQD.Forms(), sffxs{}, ops)
}

// VPMOVSQD_Z: Down Convert Packed Quadword Values to Doubleword Values with Signed Saturation (Zeroing Masking).
//
// Forms:
//
//	VPMOVSQD.Z xmm k m64
//	VPMOVSQD.Z xmm k xmm
//	VPMOVSQD.Z ymm k m128
//	VPMOVSQD.Z ymm k xmm
//	VPMOVSQD.Z zmm k m256
//	VPMOVSQD.Z zmm k ymm
func VPMOVSQD_Z(xyz, k, mxy operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSQD.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mxy})
}

// VPMOVSQW: Down Convert Packed Quadword Values to Word Values with Signed Saturation.
//
// Forms:
//
//	VPMOVSQW xmm k m32
//	VPMOVSQW xmm k xmm
//	VPMOVSQW xmm m32
//	VPMOVSQW xmm xmm
//	VPMOVSQW ymm k m64
//	VPMOVSQW ymm k xmm
//	VPMOVSQW ymm m64
//	VPMOVSQW ymm xmm
//	VPMOVSQW zmm k m128
//	VPMOVSQW zmm k xmm
//	VPMOVSQW zmm m128
//	VPMOVSQW zmm xmm
func VPMOVSQW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSQW.Forms(), sffxs{}, ops)
}

// VPMOVSQW_Z: Down Convert Packed Quadword Values to Word Values with Signed Saturation (Zeroing Masking).
//
// Forms:
//
//	VPMOVSQW.Z xmm k m32
//	VPMOVSQW.Z xmm k xmm
//	VPMOVSQW.Z ymm k m64
//	VPMOVSQW.Z ymm k xmm
//	VPMOVSQW.Z zmm k m128
//	VPMOVSQW.Z zmm k xmm
func VPMOVSQW_Z(xyz, k, mx operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSQW.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mx})
}

// VPMOVSWB: Down Convert Packed Word Values to Byte Values with Signed Saturation.
//
// Forms:
//
//	VPMOVSWB xmm k m64
//	VPMOVSWB xmm k xmm
//	VPMOVSWB xmm m64
//	VPMOVSWB xmm xmm
//	VPMOVSWB ymm k m128
//	VPMOVSWB ymm k xmm
//	VPMOVSWB ymm m128
//	VPMOVSWB ymm xmm
//	VPMOVSWB zmm k m256
//	VPMOVSWB zmm k ymm
//	VPMOVSWB zmm m256
//	VPMOVSWB zmm ymm
func VPMOVSWB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSWB.Forms(), sffxs{}, ops)
}

// VPMOVSWB_Z: Down Convert Packed Word Values to Byte Values with Signed Saturation (Zeroing Masking).
//
// Forms:
//
//	VPMOVSWB.Z xmm k m64
//	VPMOVSWB.Z xmm k xmm
//	VPMOVSWB.Z ymm k m128
//	VPMOVSWB.Z ymm k xmm
//	VPMOVSWB.Z zmm k m256
//	VPMOVSWB.Z zmm k ymm
func VPMOVSWB_Z(xyz, k, mxy operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSWB.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mxy})
}

// VPMOVSXBD: Move Packed Byte Integers to Doubleword Integers with Sign Extension.
//
// Forms:
//
//	VPMOVSXBD m64  ymm
//	VPMOVSXBD xmm  ymm
//	VPMOVSXBD m32  xmm
//	VPMOVSXBD xmm  xmm
//	VPMOVSXBD m32  k xmm
//	VPMOVSXBD m64  k ymm
//	VPMOVSXBD xmm  k xmm
//	VPMOVSXBD xmm  k ymm
//	VPMOVSXBD m128 k zmm
//	VPMOVSXBD m128 zmm
//	VPMOVSXBD xmm  k zmm
//	VPMOVSXBD xmm  zmm
func VPMOVSXBD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSXBD.Forms(), sffxs{}, ops)
}

// VPMOVSXBD_Z: Move Packed Byte Integers to Doubleword Integers with Sign Extension (Zeroing Masking).
//
// Forms:
//
//	VPMOVSXBD.Z m32  k xmm
//	VPMOVSXBD.Z m64  k ymm
//	VPMOVSXBD.Z xmm  k xmm
//	VPMOVSXBD.Z xmm  k ymm
//	VPMOVSXBD.Z m128 k zmm
//	VPMOVSXBD.Z xmm  k zmm
func VPMOVSXBD_Z(mx, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSXBD.Forms(), sffxs{sffxZ}, []operand.Op{mx, k, xyz})
}

// VPMOVSXBQ: Move Packed Byte Integers to Quadword Integers with Sign Extension.
//
// Forms:
//
//	VPMOVSXBQ m32 ymm
//	VPMOVSXBQ xmm ymm
//	VPMOVSXBQ m16 xmm
//	VPMOVSXBQ xmm xmm
//	VPMOVSXBQ m16 k xmm
//	VPMOVSXBQ m32 k ymm
//	VPMOVSXBQ xmm k xmm
//	VPMOVSXBQ xmm k ymm
//	VPMOVSXBQ m64 k zmm
//	VPMOVSXBQ m64 zmm
//	VPMOVSXBQ xmm k zmm
//	VPMOVSXBQ xmm zmm
func VPMOVSXBQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSXBQ.Forms(), sffxs{}, ops)
}

// VPMOVSXBQ_Z: Move Packed Byte Integers to Quadword Integers with Sign Extension (Zeroing Masking).
//
// Forms:
//
//	VPMOVSXBQ.Z m16 k xmm
//	VPMOVSXBQ.Z m32 k ymm
//	VPMOVSXBQ.Z xmm k xmm
//	VPMOVSXBQ.Z xmm k ymm
//	VPMOVSXBQ.Z m64 k zmm
//	VPMOVSXBQ.Z xmm k zmm
func VPMOVSXBQ_Z(mx, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSXBQ.Forms(), sffxs{sffxZ}, []operand.Op{mx, k, xyz})
}

// VPMOVSXBW: Move Packed Byte Integers to Word Integers with Sign Extension.
//
// Forms:
//
//	VPMOVSXBW m128 ymm
//	VPMOVSXBW xmm  ymm
//	VPMOVSXBW m64  xmm
//	VPMOVSXBW xmm  xmm
//	VPMOVSXBW m128 k ymm
//	VPMOVSXBW m64  k xmm
//	VPMOVSXBW xmm  k xmm
//	VPMOVSXBW xmm  k ymm
//	VPMOVSXBW m256 k zmm
//	VPMOVSXBW m256 zmm
//	VPMOVSXBW ymm  k zmm
//	VPMOVSXBW ymm  zmm
func VPMOVSXBW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSXBW.Forms(), sffxs{}, ops)
}

// VPMOVSXBW_Z: Move Packed Byte Integers to Word Integers with Sign Extension (Zeroing Masking).
//
// Forms:
//
//	VPMOVSXBW.Z m128 k ymm
//	VPMOVSXBW.Z m64  k xmm
//	VPMOVSXBW.Z xmm  k xmm
//	VPMOVSXBW.Z xmm  k ymm
//	VPMOVSXBW.Z m256 k zmm
//	VPMOVSXBW.Z ymm  k zmm
func VPMOVSXBW_Z(mxy, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSXBW.Forms(), sffxs{sffxZ}, []operand.Op{mxy, k, xyz})
}

// VPMOVSXDQ: Move Packed Doubleword Integers to Quadword Integers with Sign Extension.
//
// Forms:
//
//	VPMOVSXDQ m128 ymm
//	VPMOVSXDQ xmm  ymm
//	VPMOVSXDQ m64  xmm
//	VPMOVSXDQ xmm  xmm
//	VPMOVSXDQ m128 k ymm
//	VPMOVSXDQ m64  k xmm
//	VPMOVSXDQ xmm  k xmm
//	VPMOVSXDQ xmm  k ymm
//	VPMOVSXDQ m256 k zmm
//	VPMOVSXDQ m256 zmm
//	VPMOVSXDQ ymm  k zmm
//	VPMOVSXDQ ymm  zmm
func VPMOVSXDQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSXDQ.Forms(), sffxs{}, ops)
}

// VPMOVSXDQ_Z: Move Packed Doubleword Integers to Quadword Integers with Sign Extension (Zeroing Masking).
//
// Forms:
//
//	VPMOVSXDQ.Z m128 k ymm
//	VPMOVSXDQ.Z m64  k xmm
//	VPMOVSXDQ.Z xmm  k xmm
//	VPMOVSXDQ.Z xmm  k ymm
//	VPMOVSXDQ.Z m256 k zmm
//	VPMOVSXDQ.Z ymm  k zmm
func VPMOVSXDQ_Z(mxy, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSXDQ.Forms(), sffxs{sffxZ}, []operand.Op{mxy, k, xyz})
}

// VPMOVSXWD: Move Packed Word Integers to Doubleword Integers with Sign Extension.
//
// Forms:
//
//	VPMOVSXWD m128 ymm
//	VPMOVSXWD xmm  ymm
//	VPMOVSXWD m64  xmm
//	VPMOVSXWD xmm  xmm
//	VPMOVSXWD m128 k ymm
//	VPMOVSXWD m64  k xmm
//	VPMOVSXWD xmm  k xmm
//	VPMOVSXWD xmm  k ymm
//	VPMOVSXWD m256 k zmm
//	VPMOVSXWD m256 zmm
//	VPMOVSXWD ymm  k zmm
//	VPMOVSXWD ymm  zmm
func VPMOVSXWD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSXWD.Forms(), sffxs{}, ops)
}

// VPMOVSXWD_Z: Move Packed Word Integers to Doubleword Integers with Sign Extension (Zeroing Masking).
//
// Forms:
//
//	VPMOVSXWD.Z m128 k ymm
//	VPMOVSXWD.Z m64  k xmm
//	VPMOVSXWD.Z xmm  k xmm
//	VPMOVSXWD.Z xmm  k ymm
//	VPMOVSXWD.Z m256 k zmm
//	VPMOVSXWD.Z ymm  k zmm
func VPMOVSXWD_Z(mxy, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSXWD.Forms(), sffxs{sffxZ}, []operand.Op{mxy, k, xyz})
}

// VPMOVSXWQ: Move Packed Word Integers to Quadword Integers with Sign Extension.
//
// Forms:
//
//	VPMOVSXWQ m64  ymm
//	VPMOVSXWQ xmm  ymm
//	VPMOVSXWQ m32  xmm
//	VPMOVSXWQ xmm  xmm
//	VPMOVSXWQ m32  k xmm
//	VPMOVSXWQ m64  k ymm
//	VPMOVSXWQ xmm  k xmm
//	VPMOVSXWQ xmm  k ymm
//	VPMOVSXWQ m128 k zmm
//	VPMOVSXWQ m128 zmm
//	VPMOVSXWQ xmm  k zmm
//	VPMOVSXWQ xmm  zmm
func VPMOVSXWQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSXWQ.Forms(), sffxs{}, ops)
}

// VPMOVSXWQ_Z: Move Packed Word Integers to Quadword Integers with Sign Extension (Zeroing Masking).
//
// Forms:
//
//	VPMOVSXWQ.Z m32  k xmm
//	VPMOVSXWQ.Z m64  k ymm
//	VPMOVSXWQ.Z xmm  k xmm
//	VPMOVSXWQ.Z xmm  k ymm
//	VPMOVSXWQ.Z m128 k zmm
//	VPMOVSXWQ.Z xmm  k zmm
func VPMOVSXWQ_Z(mx, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVSXWQ.Forms(), sffxs{sffxZ}, []operand.Op{mx, k, xyz})
}

// VPMOVUSDB: Down Convert Packed Doubleword Values to Byte Values with Unsigned Saturation.
//
// Forms:
//
//	VPMOVUSDB xmm k m32
//	VPMOVUSDB xmm k xmm
//	VPMOVUSDB xmm m32
//	VPMOVUSDB xmm xmm
//	VPMOVUSDB ymm k m64
//	VPMOVUSDB ymm k xmm
//	VPMOVUSDB ymm m64
//	VPMOVUSDB ymm xmm
//	VPMOVUSDB zmm k m128
//	VPMOVUSDB zmm k xmm
//	VPMOVUSDB zmm m128
//	VPMOVUSDB zmm xmm
func VPMOVUSDB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVUSDB.Forms(), sffxs{}, ops)
}

// VPMOVUSDB_Z: Down Convert Packed Doubleword Values to Byte Values with Unsigned Saturation (Zeroing Masking).
//
// Forms:
//
//	VPMOVUSDB.Z xmm k m32
//	VPMOVUSDB.Z xmm k xmm
//	VPMOVUSDB.Z ymm k m64
//	VPMOVUSDB.Z ymm k xmm
//	VPMOVUSDB.Z zmm k m128
//	VPMOVUSDB.Z zmm k xmm
func VPMOVUSDB_Z(xyz, k, mx operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVUSDB.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mx})
}

// VPMOVUSDW: Down Convert Packed Doubleword Values to Word Values with Unsigned Saturation.
//
// Forms:
//
//	VPMOVUSDW xmm k m64
//	VPMOVUSDW xmm k xmm
//	VPMOVUSDW xmm m64
//	VPMOVUSDW xmm xmm
//	VPMOVUSDW ymm k m128
//	VPMOVUSDW ymm k xmm
//	VPMOVUSDW ymm m128
//	VPMOVUSDW ymm xmm
//	VPMOVUSDW zmm k m256
//	VPMOVUSDW zmm k ymm
//	VPMOVUSDW zmm m256
//	VPMOVUSDW zmm ymm
func VPMOVUSDW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVUSDW.Forms(), sffxs{}, ops)
}

// VPMOVUSDW_Z: Down Convert Packed Doubleword Values to Word Values with Unsigned Saturation (Zeroing Masking).
//
// Forms:
//
//	VPMOVUSDW.Z xmm k m64
//	VPMOVUSDW.Z xmm k xmm
//	VPMOVUSDW.Z ymm k m128
//	VPMOVUSDW.Z ymm k xmm
//	VPMOVUSDW.Z zmm k m256
//	VPMOVUSDW.Z zmm k ymm
func VPMOVUSDW_Z(xyz, k, mxy operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVUSDW.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mxy})
}

// VPMOVUSQB: Down Convert Packed Quadword Values to Byte Values with Unsigned Saturation.
//
// Forms:
//
//	VPMOVUSQB xmm k m16
//	VPMOVUSQB xmm k xmm
//	VPMOVUSQB xmm m16
//	VPMOVUSQB xmm xmm
//	VPMOVUSQB ymm k m32
//	VPMOVUSQB ymm k xmm
//	VPMOVUSQB ymm m32
//	VPMOVUSQB ymm xmm
//	VPMOVUSQB zmm k m64
//	VPMOVUSQB zmm k xmm
//	VPMOVUSQB zmm m64
//	VPMOVUSQB zmm xmm
func VPMOVUSQB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVUSQB.Forms(), sffxs{}, ops)
}

// VPMOVUSQB_Z: Down Convert Packed Quadword Values to Byte Values with Unsigned Saturation (Zeroing Masking).
//
// Forms:
//
//	VPMOVUSQB.Z xmm k m16
//	VPMOVUSQB.Z xmm k xmm
//	VPMOVUSQB.Z ymm k m32
//	VPMOVUSQB.Z ymm k xmm
//	VPMOVUSQB.Z zmm k m64
//	VPMOVUSQB.Z zmm k xmm
func VPMOVUSQB_Z(xyz, k, mx operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVUSQB.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mx})
}

// VPMOVUSQD: Down Convert Packed Quadword Values to Doubleword Values with Unsigned Saturation.
//
// Forms:
//
//	VPMOVUSQD xmm k m64
//	VPMOVUSQD xmm k xmm
//	VPMOVUSQD xmm m64
//	VPMOVUSQD xmm xmm
//	VPMOVUSQD ymm k m128
//	VPMOVUSQD ymm k xmm
//	VPMOVUSQD ymm m128
//	VPMOVUSQD ymm xmm
//	VPMOVUSQD zmm k m256
//	VPMOVUSQD zmm k ymm
//	VPMOVUSQD zmm m256
//	VPMOVUSQD zmm ymm
func VPMOVUSQD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVUSQD.Forms(), sffxs{}, ops)
}

// VPMOVUSQD_Z: Down Convert Packed Quadword Values to Doubleword Values with Unsigned Saturation (Zeroing Masking).
//
// Forms:
//
//	VPMOVUSQD.Z xmm k m64
//	VPMOVUSQD.Z xmm k xmm
//	VPMOVUSQD.Z ymm k m128
//	VPMOVUSQD.Z ymm k xmm
//	VPMOVUSQD.Z zmm k m256
//	VPMOVUSQD.Z zmm k ymm
func VPMOVUSQD_Z(xyz, k, mxy operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVUSQD.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mxy})
}

// VPMOVUSQW: Down Convert Packed Quadword Values to Word Values with Unsigned Saturation.
//
// Forms:
//
//	VPMOVUSQW xmm k m32
//	VPMOVUSQW xmm k xmm
//	VPMOVUSQW xmm m32
//	VPMOVUSQW xmm xmm
//	VPMOVUSQW ymm k m64
//	VPMOVUSQW ymm k xmm
//	VPMOVUSQW ymm m64
//	VPMOVUSQW ymm xmm
//	VPMOVUSQW zmm k m128
//	VPMOVUSQW zmm k xmm
//	VPMOVUSQW zmm m128
//	VPMOVUSQW zmm xmm
func VPMOVUSQW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVUSQW.Forms(), sffxs{}, ops)
}

// VPMOVUSQW_Z: Down Convert Packed Quadword Values to Word Values with Unsigned Saturation (Zeroing Masking).
//
// Forms:
//
//	VPMOVUSQW.Z xmm k m32
//	VPMOVUSQW.Z xmm k xmm
//	VPMOVUSQW.Z ymm k m64
//	VPMOVUSQW.Z ymm k xmm
//	VPMOVUSQW.Z zmm k m128
//	VPMOVUSQW.Z zmm k xmm
func VPMOVUSQW_Z(xyz, k, mx operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVUSQW.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mx})
}

// VPMOVUSWB: Down Convert Packed Word Values to Byte Values with Unsigned Saturation.
//
// Forms:
//
//	VPMOVUSWB xmm k m64
//	VPMOVUSWB xmm k xmm
//	VPMOVUSWB xmm m64
//	VPMOVUSWB xmm xmm
//	VPMOVUSWB ymm k m128
//	VPMOVUSWB ymm k xmm
//	VPMOVUSWB ymm m128
//	VPMOVUSWB ymm xmm
//	VPMOVUSWB zmm k m256
//	VPMOVUSWB zmm k ymm
//	VPMOVUSWB zmm m256
//	VPMOVUSWB zmm ymm
func VPMOVUSWB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVUSWB.Forms(), sffxs{}, ops)
}

// VPMOVUSWB_Z: Down Convert Packed Word Values to Byte Values with Unsigned Saturation (Zeroing Masking).
//
// Forms:
//
//	VPMOVUSWB.Z xmm k m64
//	VPMOVUSWB.Z xmm k xmm
//	VPMOVUSWB.Z ymm k m128
//	VPMOVUSWB.Z ymm k xmm
//	VPMOVUSWB.Z zmm k m256
//	VPMOVUSWB.Z zmm k ymm
func VPMOVUSWB_Z(xyz, k, mxy operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVUSWB.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mxy})
}

// VPMOVW2M: Move Signs of Packed Word Integers to Mask Register.
//
// Forms:
//
//	VPMOVW2M xmm k
//	VPMOVW2M ymm k
//	VPMOVW2M zmm k
func VPMOVW2M(xyz, k operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVW2M.Forms(), sffxs{}, []operand.Op{xyz, k})
}

// VPMOVWB: Down Convert Packed Word Values to Byte Values with Truncation.
//
// Forms:
//
//	VPMOVWB xmm k m64
//	VPMOVWB xmm k xmm
//	VPMOVWB xmm m64
//	VPMOVWB xmm xmm
//	VPMOVWB ymm k m128
//	VPMOVWB ymm k xmm
//	VPMOVWB ymm m128
//	VPMOVWB ymm xmm
//	VPMOVWB zmm k m256
//	VPMOVWB zmm k ymm
//	VPMOVWB zmm m256
//	VPMOVWB zmm ymm
func VPMOVWB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVWB.Forms(), sffxs{}, ops)
}

// VPMOVWB_Z: Down Convert Packed Word Values to Byte Values with Truncation (Zeroing Masking).
//
// Forms:
//
//	VPMOVWB.Z xmm k m64
//	VPMOVWB.Z xmm k xmm
//	VPMOVWB.Z ymm k m128
//	VPMOVWB.Z ymm k xmm
//	VPMOVWB.Z zmm k m256
//	VPMOVWB.Z zmm k ymm
func VPMOVWB_Z(xyz, k, mxy operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVWB.Forms(), sffxs{sffxZ}, []operand.Op{xyz, k, mxy})
}

// VPMOVZXBD: Move Packed Byte Integers to Doubleword Integers with Zero Extension.
//
// Forms:
//
//	VPMOVZXBD m64  ymm
//	VPMOVZXBD xmm  ymm
//	VPMOVZXBD m32  xmm
//	VPMOVZXBD xmm  xmm
//	VPMOVZXBD m32  k xmm
//	VPMOVZXBD m64  k ymm
//	VPMOVZXBD xmm  k xmm
//	VPMOVZXBD xmm  k ymm
//	VPMOVZXBD m128 k zmm
//	VPMOVZXBD m128 zmm
//	VPMOVZXBD xmm  k zmm
//	VPMOVZXBD xmm  zmm
func VPMOVZXBD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVZXBD.Forms(), sffxs{}, ops)
}

// VPMOVZXBD_Z: Move Packed Byte Integers to Doubleword Integers with Zero Extension (Zeroing Masking).
//
// Forms:
//
//	VPMOVZXBD.Z m32  k xmm
//	VPMOVZXBD.Z m64  k ymm
//	VPMOVZXBD.Z xmm  k xmm
//	VPMOVZXBD.Z xmm  k ymm
//	VPMOVZXBD.Z m128 k zmm
//	VPMOVZXBD.Z xmm  k zmm
func VPMOVZXBD_Z(mx, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVZXBD.Forms(), sffxs{sffxZ}, []operand.Op{mx, k, xyz})
}

// VPMOVZXBQ: Move Packed Byte Integers to Quadword Integers with Zero Extension.
//
// Forms:
//
//	VPMOVZXBQ m32 ymm
//	VPMOVZXBQ xmm ymm
//	VPMOVZXBQ m16 xmm
//	VPMOVZXBQ xmm xmm
//	VPMOVZXBQ m16 k xmm
//	VPMOVZXBQ m32 k ymm
//	VPMOVZXBQ xmm k xmm
//	VPMOVZXBQ xmm k ymm
//	VPMOVZXBQ m64 k zmm
//	VPMOVZXBQ m64 zmm
//	VPMOVZXBQ xmm k zmm
//	VPMOVZXBQ xmm zmm
func VPMOVZXBQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVZXBQ.Forms(), sffxs{}, ops)
}

// VPMOVZXBQ_Z: Move Packed Byte Integers to Quadword Integers with Zero Extension (Zeroing Masking).
//
// Forms:
//
//	VPMOVZXBQ.Z m16 k xmm
//	VPMOVZXBQ.Z m32 k ymm
//	VPMOVZXBQ.Z xmm k xmm
//	VPMOVZXBQ.Z xmm k ymm
//	VPMOVZXBQ.Z m64 k zmm
//	VPMOVZXBQ.Z xmm k zmm
func VPMOVZXBQ_Z(mx, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVZXBQ.Forms(), sffxs{sffxZ}, []operand.Op{mx, k, xyz})
}

// VPMOVZXBW: Move Packed Byte Integers to Word Integers with Zero Extension.
//
// Forms:
//
//	VPMOVZXBW m128 ymm
//	VPMOVZXBW xmm  ymm
//	VPMOVZXBW m64  xmm
//	VPMOVZXBW xmm  xmm
//	VPMOVZXBW m128 k ymm
//	VPMOVZXBW m64  k xmm
//	VPMOVZXBW xmm  k xmm
//	VPMOVZXBW xmm  k ymm
//	VPMOVZXBW m256 k zmm
//	VPMOVZXBW m256 zmm
//	VPMOVZXBW ymm  k zmm
//	VPMOVZXBW ymm  zmm
func VPMOVZXBW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVZXBW.Forms(), sffxs{}, ops)
}

// VPMOVZXBW_Z: Move Packed Byte Integers to Word Integers with Zero Extension (Zeroing Masking).
//
// Forms:
//
//	VPMOVZXBW.Z m128 k ymm
//	VPMOVZXBW.Z m64  k xmm
//	VPMOVZXBW.Z xmm  k xmm
//	VPMOVZXBW.Z xmm  k ymm
//	VPMOVZXBW.Z m256 k zmm
//	VPMOVZXBW.Z ymm  k zmm
func VPMOVZXBW_Z(mxy, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVZXBW.Forms(), sffxs{sffxZ}, []operand.Op{mxy, k, xyz})
}

// VPMOVZXDQ: Move Packed Doubleword Integers to Quadword Integers with Zero Extension.
//
// Forms:
//
//	VPMOVZXDQ m128 ymm
//	VPMOVZXDQ xmm  ymm
//	VPMOVZXDQ m64  xmm
//	VPMOVZXDQ xmm  xmm
//	VPMOVZXDQ m128 k ymm
//	VPMOVZXDQ m64  k xmm
//	VPMOVZXDQ xmm  k xmm
//	VPMOVZXDQ xmm  k ymm
//	VPMOVZXDQ m256 k zmm
//	VPMOVZXDQ m256 zmm
//	VPMOVZXDQ ymm  k zmm
//	VPMOVZXDQ ymm  zmm
func VPMOVZXDQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVZXDQ.Forms(), sffxs{}, ops)
}

// VPMOVZXDQ_Z: Move Packed Doubleword Integers to Quadword Integers with Zero Extension (Zeroing Masking).
//
// Forms:
//
//	VPMOVZXDQ.Z m128 k ymm
//	VPMOVZXDQ.Z m64  k xmm
//	VPMOVZXDQ.Z xmm  k xmm
//	VPMOVZXDQ.Z xmm  k ymm
//	VPMOVZXDQ.Z m256 k zmm
//	VPMOVZXDQ.Z ymm  k zmm
func VPMOVZXDQ_Z(mxy, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVZXDQ.Forms(), sffxs{sffxZ}, []operand.Op{mxy, k, xyz})
}

// VPMOVZXWD: Move Packed Word Integers to Doubleword Integers with Zero Extension.
//
// Forms:
//
//	VPMOVZXWD m128 ymm
//	VPMOVZXWD xmm  ymm
//	VPMOVZXWD m64  xmm
//	VPMOVZXWD xmm  xmm
//	VPMOVZXWD m128 k ymm
//	VPMOVZXWD m64  k xmm
//	VPMOVZXWD xmm  k xmm
//	VPMOVZXWD xmm  k ymm
//	VPMOVZXWD m256 k zmm
//	VPMOVZXWD m256 zmm
//	VPMOVZXWD ymm  k zmm
//	VPMOVZXWD ymm  zmm
func VPMOVZXWD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVZXWD.Forms(), sffxs{}, ops)
}

// VPMOVZXWD_Z: Move Packed Word Integers to Doubleword Integers with Zero Extension (Zeroing Masking).
//
// Forms:
//
//	VPMOVZXWD.Z m128 k ymm
//	VPMOVZXWD.Z m64  k xmm
//	VPMOVZXWD.Z xmm  k xmm
//	VPMOVZXWD.Z xmm  k ymm
//	VPMOVZXWD.Z m256 k zmm
//	VPMOVZXWD.Z ymm  k zmm
func VPMOVZXWD_Z(mxy, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVZXWD.Forms(), sffxs{sffxZ}, []operand.Op{mxy, k, xyz})
}

// VPMOVZXWQ: Move Packed Word Integers to Quadword Integers with Zero Extension.
//
// Forms:
//
//	VPMOVZXWQ m64  ymm
//	VPMOVZXWQ xmm  ymm
//	VPMOVZXWQ m32  xmm
//	VPMOVZXWQ xmm  xmm
//	VPMOVZXWQ m32  k xmm
//	VPMOVZXWQ m64  k ymm
//	VPMOVZXWQ xmm  k xmm
//	VPMOVZXWQ xmm  k ymm
//	VPMOVZXWQ m128 k zmm
//	VPMOVZXWQ m128 zmm
//	VPMOVZXWQ xmm  k zmm
//	VPMOVZXWQ xmm  zmm
func VPMOVZXWQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVZXWQ.Forms(), sffxs{}, ops)
}

// VPMOVZXWQ_Z: Move Packed Word Integers to Quadword Integers with Zero Extension (Zeroing Masking).
//
// Forms:
//
//	VPMOVZXWQ.Z m32  k xmm
//	VPMOVZXWQ.Z m64  k ymm
//	VPMOVZXWQ.Z xmm  k xmm
//	VPMOVZXWQ.Z xmm  k ymm
//	VPMOVZXWQ.Z m128 k zmm
//	VPMOVZXWQ.Z xmm  k zmm
func VPMOVZXWQ_Z(mx, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMOVZXWQ.Forms(), sffxs{sffxZ}, []operand.Op{mx, k, xyz})
}

// VPMULDQ: Multiply Packed Signed Doubleword Integers and Store Quadword Result.
//
// Forms:
//
//	VPMULDQ m256 ymm ymm
//	VPMULDQ ymm  ymm ymm
//	VPMULDQ m128 xmm xmm
//	VPMULDQ xmm  xmm xmm
//	VPMULDQ m128 xmm k xmm
//	VPMULDQ m256 ymm k ymm
//	VPMULDQ xmm  xmm k xmm
//	VPMULDQ ymm  ymm k ymm
//	VPMULDQ m512 zmm k zmm
//	VPMULDQ m512 zmm zmm
//	VPMULDQ zmm  zmm k zmm
//	VPMULDQ zmm  zmm zmm
func VPMULDQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULDQ.Forms(), sffxs{}, ops)
}

// VPMULDQ_BCST: Multiply Packed Signed Doubleword Integers and Store Quadword Result (Broadcast).
//
// Forms:
//
//	VPMULDQ.BCST m64 xmm k xmm
//	VPMULDQ.BCST m64 xmm xmm
//	VPMULDQ.BCST m64 ymm k ymm
//	VPMULDQ.BCST m64 ymm ymm
//	VPMULDQ.BCST m64 zmm k zmm
//	VPMULDQ.BCST m64 zmm zmm
func VPMULDQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULDQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPMULDQ_BCST_Z: Multiply Packed Signed Doubleword Integers and Store Quadword Result (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPMULDQ.BCST.Z m64 xmm k xmm
//	VPMULDQ.BCST.Z m64 ymm k ymm
//	VPMULDQ.BCST.Z m64 zmm k zmm
func VPMULDQ_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULDQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPMULDQ_Z: Multiply Packed Signed Doubleword Integers and Store Quadword Result (Zeroing Masking).
//
// Forms:
//
//	VPMULDQ.Z m128 xmm k xmm
//	VPMULDQ.Z m256 ymm k ymm
//	VPMULDQ.Z xmm  xmm k xmm
//	VPMULDQ.Z ymm  ymm k ymm
//	VPMULDQ.Z m512 zmm k zmm
//	VPMULDQ.Z zmm  zmm k zmm
func VPMULDQ_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULDQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMULHRSW: Packed Multiply Signed Word Integers and Store High Result with Round and Scale.
//
// Forms:
//
//	VPMULHRSW m256 ymm ymm
//	VPMULHRSW ymm  ymm ymm
//	VPMULHRSW m128 xmm xmm
//	VPMULHRSW xmm  xmm xmm
//	VPMULHRSW m128 xmm k xmm
//	VPMULHRSW m256 ymm k ymm
//	VPMULHRSW xmm  xmm k xmm
//	VPMULHRSW ymm  ymm k ymm
//	VPMULHRSW m512 zmm k zmm
//	VPMULHRSW m512 zmm zmm
//	VPMULHRSW zmm  zmm k zmm
//	VPMULHRSW zmm  zmm zmm
func VPMULHRSW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULHRSW.Forms(), sffxs{}, ops)
}

// VPMULHRSW_Z: Packed Multiply Signed Word Integers and Store High Result with Round and Scale (Zeroing Masking).
//
// Forms:
//
//	VPMULHRSW.Z m128 xmm k xmm
//	VPMULHRSW.Z m256 ymm k ymm
//	VPMULHRSW.Z xmm  xmm k xmm
//	VPMULHRSW.Z ymm  ymm k ymm
//	VPMULHRSW.Z m512 zmm k zmm
//	VPMULHRSW.Z zmm  zmm k zmm
func VPMULHRSW_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULHRSW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMULHUW: Multiply Packed Unsigned Word Integers and Store High Result.
//
// Forms:
//
//	VPMULHUW m256 ymm ymm
//	VPMULHUW ymm  ymm ymm
//	VPMULHUW m128 xmm xmm
//	VPMULHUW xmm  xmm xmm
//	VPMULHUW m128 xmm k xmm
//	VPMULHUW m256 ymm k ymm
//	VPMULHUW xmm  xmm k xmm
//	VPMULHUW ymm  ymm k ymm
//	VPMULHUW m512 zmm k zmm
//	VPMULHUW m512 zmm zmm
//	VPMULHUW zmm  zmm k zmm
//	VPMULHUW zmm  zmm zmm
func VPMULHUW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULHUW.Forms(), sffxs{}, ops)
}

// VPMULHUW_Z: Multiply Packed Unsigned Word Integers and Store High Result (Zeroing Masking).
//
// Forms:
//
//	VPMULHUW.Z m128 xmm k xmm
//	VPMULHUW.Z m256 ymm k ymm
//	VPMULHUW.Z xmm  xmm k xmm
//	VPMULHUW.Z ymm  ymm k ymm
//	VPMULHUW.Z m512 zmm k zmm
//	VPMULHUW.Z zmm  zmm k zmm
func VPMULHUW_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULHUW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMULHW: Multiply Packed Signed Word Integers and Store High Result.
//
// Forms:
//
//	VPMULHW m256 ymm ymm
//	VPMULHW ymm  ymm ymm
//	VPMULHW m128 xmm xmm
//	VPMULHW xmm  xmm xmm
//	VPMULHW m128 xmm k xmm
//	VPMULHW m256 ymm k ymm
//	VPMULHW xmm  xmm k xmm
//	VPMULHW ymm  ymm k ymm
//	VPMULHW m512 zmm k zmm
//	VPMULHW m512 zmm zmm
//	VPMULHW zmm  zmm k zmm
//	VPMULHW zmm  zmm zmm
func VPMULHW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULHW.Forms(), sffxs{}, ops)
}

// VPMULHW_Z: Multiply Packed Signed Word Integers and Store High Result (Zeroing Masking).
//
// Forms:
//
//	VPMULHW.Z m128 xmm k xmm
//	VPMULHW.Z m256 ymm k ymm
//	VPMULHW.Z xmm  xmm k xmm
//	VPMULHW.Z ymm  ymm k ymm
//	VPMULHW.Z m512 zmm k zmm
//	VPMULHW.Z zmm  zmm k zmm
func VPMULHW_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULHW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMULLD: Multiply Packed Signed Doubleword Integers and Store Low Result.
//
// Forms:
//
//	VPMULLD m256 ymm ymm
//	VPMULLD ymm  ymm ymm
//	VPMULLD m128 xmm xmm
//	VPMULLD xmm  xmm xmm
//	VPMULLD m128 xmm k xmm
//	VPMULLD m256 ymm k ymm
//	VPMULLD xmm  xmm k xmm
//	VPMULLD ymm  ymm k ymm
//	VPMULLD m512 zmm k zmm
//	VPMULLD m512 zmm zmm
//	VPMULLD zmm  zmm k zmm
//	VPMULLD zmm  zmm zmm
func VPMULLD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULLD.Forms(), sffxs{}, ops)
}

// VPMULLD_BCST: Multiply Packed Signed Doubleword Integers and Store Low Result (Broadcast).
//
// Forms:
//
//	VPMULLD.BCST m32 xmm k xmm
//	VPMULLD.BCST m32 xmm xmm
//	VPMULLD.BCST m32 ymm k ymm
//	VPMULLD.BCST m32 ymm ymm
//	VPMULLD.BCST m32 zmm k zmm
//	VPMULLD.BCST m32 zmm zmm
func VPMULLD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULLD.Forms(), sffxs{sffxBCST}, ops)
}

// VPMULLD_BCST_Z: Multiply Packed Signed Doubleword Integers and Store Low Result (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPMULLD.BCST.Z m32 xmm k xmm
//	VPMULLD.BCST.Z m32 ymm k ymm
//	VPMULLD.BCST.Z m32 zmm k zmm
func VPMULLD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULLD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPMULLD_Z: Multiply Packed Signed Doubleword Integers and Store Low Result (Zeroing Masking).
//
// Forms:
//
//	VPMULLD.Z m128 xmm k xmm
//	VPMULLD.Z m256 ymm k ymm
//	VPMULLD.Z xmm  xmm k xmm
//	VPMULLD.Z ymm  ymm k ymm
//	VPMULLD.Z m512 zmm k zmm
//	VPMULLD.Z zmm  zmm k zmm
func VPMULLD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULLD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMULLQ: Multiply Packed Signed Quadword Integers and Store Low Result.
//
// Forms:
//
//	VPMULLQ m128 xmm k xmm
//	VPMULLQ m128 xmm xmm
//	VPMULLQ m256 ymm k ymm
//	VPMULLQ m256 ymm ymm
//	VPMULLQ xmm  xmm k xmm
//	VPMULLQ xmm  xmm xmm
//	VPMULLQ ymm  ymm k ymm
//	VPMULLQ ymm  ymm ymm
//	VPMULLQ m512 zmm k zmm
//	VPMULLQ m512 zmm zmm
//	VPMULLQ zmm  zmm k zmm
//	VPMULLQ zmm  zmm zmm
func VPMULLQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULLQ.Forms(), sffxs{}, ops)
}

// VPMULLQ_BCST: Multiply Packed Signed Quadword Integers and Store Low Result (Broadcast).
//
// Forms:
//
//	VPMULLQ.BCST m64 xmm k xmm
//	VPMULLQ.BCST m64 xmm xmm
//	VPMULLQ.BCST m64 ymm k ymm
//	VPMULLQ.BCST m64 ymm ymm
//	VPMULLQ.BCST m64 zmm k zmm
//	VPMULLQ.BCST m64 zmm zmm
func VPMULLQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULLQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPMULLQ_BCST_Z: Multiply Packed Signed Quadword Integers and Store Low Result (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPMULLQ.BCST.Z m64 xmm k xmm
//	VPMULLQ.BCST.Z m64 ymm k ymm
//	VPMULLQ.BCST.Z m64 zmm k zmm
func VPMULLQ_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULLQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPMULLQ_Z: Multiply Packed Signed Quadword Integers and Store Low Result (Zeroing Masking).
//
// Forms:
//
//	VPMULLQ.Z m128 xmm k xmm
//	VPMULLQ.Z m256 ymm k ymm
//	VPMULLQ.Z xmm  xmm k xmm
//	VPMULLQ.Z ymm  ymm k ymm
//	VPMULLQ.Z m512 zmm k zmm
//	VPMULLQ.Z zmm  zmm k zmm
func VPMULLQ_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULLQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMULLW: Multiply Packed Signed Word Integers and Store Low Result.
//
// Forms:
//
//	VPMULLW m256 ymm ymm
//	VPMULLW ymm  ymm ymm
//	VPMULLW m128 xmm xmm
//	VPMULLW xmm  xmm xmm
//	VPMULLW m128 xmm k xmm
//	VPMULLW m256 ymm k ymm
//	VPMULLW xmm  xmm k xmm
//	VPMULLW ymm  ymm k ymm
//	VPMULLW m512 zmm k zmm
//	VPMULLW m512 zmm zmm
//	VPMULLW zmm  zmm k zmm
//	VPMULLW zmm  zmm zmm
func VPMULLW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULLW.Forms(), sffxs{}, ops)
}

// VPMULLW_Z: Multiply Packed Signed Word Integers and Store Low Result (Zeroing Masking).
//
// Forms:
//
//	VPMULLW.Z m128 xmm k xmm
//	VPMULLW.Z m256 ymm k ymm
//	VPMULLW.Z xmm  xmm k xmm
//	VPMULLW.Z ymm  ymm k ymm
//	VPMULLW.Z m512 zmm k zmm
//	VPMULLW.Z zmm  zmm k zmm
func VPMULLW_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULLW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMULTISHIFTQB: Select Packed Unaligned Bytes from Quadword Sources.
//
// Forms:
//
//	VPMULTISHIFTQB m128 xmm k xmm
//	VPMULTISHIFTQB m128 xmm xmm
//	VPMULTISHIFTQB m256 ymm k ymm
//	VPMULTISHIFTQB m256 ymm ymm
//	VPMULTISHIFTQB xmm  xmm k xmm
//	VPMULTISHIFTQB xmm  xmm xmm
//	VPMULTISHIFTQB ymm  ymm k ymm
//	VPMULTISHIFTQB ymm  ymm ymm
//	VPMULTISHIFTQB m512 zmm k zmm
//	VPMULTISHIFTQB m512 zmm zmm
//	VPMULTISHIFTQB zmm  zmm k zmm
//	VPMULTISHIFTQB zmm  zmm zmm
func VPMULTISHIFTQB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULTISHIFTQB.Forms(), sffxs{}, ops)
}

// VPMULTISHIFTQB_BCST: Select Packed Unaligned Bytes from Quadword Sources (Broadcast).
//
// Forms:
//
//	VPMULTISHIFTQB.BCST m64 xmm k xmm
//	VPMULTISHIFTQB.BCST m64 xmm xmm
//	VPMULTISHIFTQB.BCST m64 ymm k ymm
//	VPMULTISHIFTQB.BCST m64 ymm ymm
//	VPMULTISHIFTQB.BCST m64 zmm k zmm
//	VPMULTISHIFTQB.BCST m64 zmm zmm
func VPMULTISHIFTQB_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULTISHIFTQB.Forms(), sffxs{sffxBCST}, ops)
}

// VPMULTISHIFTQB_BCST_Z: Select Packed Unaligned Bytes from Quadword Sources (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPMULTISHIFTQB.BCST.Z m64 xmm k xmm
//	VPMULTISHIFTQB.BCST.Z m64 ymm k ymm
//	VPMULTISHIFTQB.BCST.Z m64 zmm k zmm
func VPMULTISHIFTQB_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULTISHIFTQB.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPMULTISHIFTQB_Z: Select Packed Unaligned Bytes from Quadword Sources (Zeroing Masking).
//
// Forms:
//
//	VPMULTISHIFTQB.Z m128 xmm k xmm
//	VPMULTISHIFTQB.Z m256 ymm k ymm
//	VPMULTISHIFTQB.Z xmm  xmm k xmm
//	VPMULTISHIFTQB.Z ymm  ymm k ymm
//	VPMULTISHIFTQB.Z m512 zmm k zmm
//	VPMULTISHIFTQB.Z zmm  zmm k zmm
func VPMULTISHIFTQB_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULTISHIFTQB.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPMULUDQ: Multiply Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	VPMULUDQ m256 ymm ymm
//	VPMULUDQ ymm  ymm ymm
//	VPMULUDQ m128 xmm xmm
//	VPMULUDQ xmm  xmm xmm
//	VPMULUDQ m128 xmm k xmm
//	VPMULUDQ m256 ymm k ymm
//	VPMULUDQ xmm  xmm k xmm
//	VPMULUDQ ymm  ymm k ymm
//	VPMULUDQ m512 zmm k zmm
//	VPMULUDQ m512 zmm zmm
//	VPMULUDQ zmm  zmm k zmm
//	VPMULUDQ zmm  zmm zmm
func VPMULUDQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULUDQ.Forms(), sffxs{}, ops)
}

// VPMULUDQ_BCST: Multiply Packed Unsigned Doubleword Integers (Broadcast).
//
// Forms:
//
//	VPMULUDQ.BCST m64 xmm k xmm
//	VPMULUDQ.BCST m64 xmm xmm
//	VPMULUDQ.BCST m64 ymm k ymm
//	VPMULUDQ.BCST m64 ymm ymm
//	VPMULUDQ.BCST m64 zmm k zmm
//	VPMULUDQ.BCST m64 zmm zmm
func VPMULUDQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULUDQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPMULUDQ_BCST_Z: Multiply Packed Unsigned Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPMULUDQ.BCST.Z m64 xmm k xmm
//	VPMULUDQ.BCST.Z m64 ymm k ymm
//	VPMULUDQ.BCST.Z m64 zmm k zmm
func VPMULUDQ_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULUDQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPMULUDQ_Z: Multiply Packed Unsigned Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VPMULUDQ.Z m128 xmm k xmm
//	VPMULUDQ.Z m256 ymm k ymm
//	VPMULUDQ.Z xmm  xmm k xmm
//	VPMULUDQ.Z ymm  ymm k ymm
//	VPMULUDQ.Z m512 zmm k zmm
//	VPMULUDQ.Z zmm  zmm k zmm
func VPMULUDQ_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPMULUDQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPOPCNTB: Packed Population Count for Byte Integers.
//
// Forms:
//
//	VPOPCNTB m128 k xmm
//	VPOPCNTB m128 xmm
//	VPOPCNTB m256 k ymm
//	VPOPCNTB m256 ymm
//	VPOPCNTB xmm  k xmm
//	VPOPCNTB xmm  xmm
//	VPOPCNTB ymm  k ymm
//	VPOPCNTB ymm  ymm
//	VPOPCNTB m512 k zmm
//	VPOPCNTB m512 zmm
//	VPOPCNTB zmm  k zmm
//	VPOPCNTB zmm  zmm
func VPOPCNTB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPOPCNTB.Forms(), sffxs{}, ops)
}

// VPOPCNTB_Z: Packed Population Count for Byte Integers (Zeroing Masking).
//
// Forms:
//
//	VPOPCNTB.Z m128 k xmm
//	VPOPCNTB.Z m256 k ymm
//	VPOPCNTB.Z xmm  k xmm
//	VPOPCNTB.Z ymm  k ymm
//	VPOPCNTB.Z m512 k zmm
//	VPOPCNTB.Z zmm  k zmm
func VPOPCNTB_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPOPCNTB.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VPOPCNTD: Packed Population Count for Doubleword Integers.
//
// Forms:
//
//	VPOPCNTD m128 k xmm
//	VPOPCNTD m128 xmm
//	VPOPCNTD m256 k ymm
//	VPOPCNTD m256 ymm
//	VPOPCNTD xmm  k xmm
//	VPOPCNTD xmm  xmm
//	VPOPCNTD ymm  k ymm
//	VPOPCNTD ymm  ymm
//	VPOPCNTD m512 k zmm
//	VPOPCNTD m512 zmm
//	VPOPCNTD zmm  k zmm
//	VPOPCNTD zmm  zmm
func VPOPCNTD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPOPCNTD.Forms(), sffxs{}, ops)
}

// VPOPCNTD_BCST: Packed Population Count for Doubleword Integers (Broadcast).
//
// Forms:
//
//	VPOPCNTD.BCST m32 k xmm
//	VPOPCNTD.BCST m32 k ymm
//	VPOPCNTD.BCST m32 xmm
//	VPOPCNTD.BCST m32 ymm
//	VPOPCNTD.BCST m32 k zmm
//	VPOPCNTD.BCST m32 zmm
func VPOPCNTD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPOPCNTD.Forms(), sffxs{sffxBCST}, ops)
}

// VPOPCNTD_BCST_Z: Packed Population Count for Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPOPCNTD.BCST.Z m32 k xmm
//	VPOPCNTD.BCST.Z m32 k ymm
//	VPOPCNTD.BCST.Z m32 k zmm
func VPOPCNTD_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPOPCNTD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VPOPCNTD_Z: Packed Population Count for Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VPOPCNTD.Z m128 k xmm
//	VPOPCNTD.Z m256 k ymm
//	VPOPCNTD.Z xmm  k xmm
//	VPOPCNTD.Z ymm  k ymm
//	VPOPCNTD.Z m512 k zmm
//	VPOPCNTD.Z zmm  k zmm
func VPOPCNTD_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPOPCNTD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VPOPCNTQ: Packed Population Count for Quadword Integers.
//
// Forms:
//
//	VPOPCNTQ m128 k xmm
//	VPOPCNTQ m128 xmm
//	VPOPCNTQ m256 k ymm
//	VPOPCNTQ m256 ymm
//	VPOPCNTQ xmm  k xmm
//	VPOPCNTQ xmm  xmm
//	VPOPCNTQ ymm  k ymm
//	VPOPCNTQ ymm  ymm
//	VPOPCNTQ m512 k zmm
//	VPOPCNTQ m512 zmm
//	VPOPCNTQ zmm  k zmm
//	VPOPCNTQ zmm  zmm
func VPOPCNTQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPOPCNTQ.Forms(), sffxs{}, ops)
}

// VPOPCNTQ_BCST: Packed Population Count for Quadword Integers (Broadcast).
//
// Forms:
//
//	VPOPCNTQ.BCST m64 k xmm
//	VPOPCNTQ.BCST m64 k ymm
//	VPOPCNTQ.BCST m64 xmm
//	VPOPCNTQ.BCST m64 ymm
//	VPOPCNTQ.BCST m64 k zmm
//	VPOPCNTQ.BCST m64 zmm
func VPOPCNTQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPOPCNTQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPOPCNTQ_BCST_Z: Packed Population Count for Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPOPCNTQ.BCST.Z m64 k xmm
//	VPOPCNTQ.BCST.Z m64 k ymm
//	VPOPCNTQ.BCST.Z m64 k zmm
func VPOPCNTQ_BCST_Z(m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPOPCNTQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, k, xyz})
}

// VPOPCNTQ_Z: Packed Population Count for Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VPOPCNTQ.Z m128 k xmm
//	VPOPCNTQ.Z m256 k ymm
//	VPOPCNTQ.Z xmm  k xmm
//	VPOPCNTQ.Z ymm  k ymm
//	VPOPCNTQ.Z m512 k zmm
//	VPOPCNTQ.Z zmm  k zmm
func VPOPCNTQ_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPOPCNTQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VPOPCNTW: Packed Population Count for Word Integers.
//
// Forms:
//
//	VPOPCNTW m128 k xmm
//	VPOPCNTW m128 xmm
//	VPOPCNTW m256 k ymm
//	VPOPCNTW m256 ymm
//	VPOPCNTW xmm  k xmm
//	VPOPCNTW xmm  xmm
//	VPOPCNTW ymm  k ymm
//	VPOPCNTW ymm  ymm
//	VPOPCNTW m512 k zmm
//	VPOPCNTW m512 zmm
//	VPOPCNTW zmm  k zmm
//	VPOPCNTW zmm  zmm
func VPOPCNTW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPOPCNTW.Forms(), sffxs{}, ops)
}

// VPOPCNTW_Z: Packed Population Count for Word Integers (Zeroing Masking).
//
// Forms:
//
//	VPOPCNTW.Z m128 k xmm
//	VPOPCNTW.Z m256 k ymm
//	VPOPCNTW.Z xmm  k xmm
//	VPOPCNTW.Z ymm  k ymm
//	VPOPCNTW.Z m512 k zmm
//	VPOPCNTW.Z zmm  k zmm
func VPOPCNTW_Z(mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPOPCNTW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, k, xyz})
}

// VPOR: Packed Bitwise Logical OR.
//
// Forms:
//
//	VPOR m256 ymm ymm
//	VPOR ymm  ymm ymm
//	VPOR m128 xmm xmm
//	VPOR xmm  xmm xmm
func VPOR(mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPOR.Forms(), sffxs{}, []operand.Op{mxy, xy, xy1})
}

// VPORD: Bitwise Logical OR of Packed Doubleword Integers.
//
// Forms:
//
//	VPORD m128 xmm k xmm
//	VPORD m128 xmm xmm
//	VPORD m256 ymm k ymm
//	VPORD m256 ymm ymm
//	VPORD xmm  xmm k xmm
//	VPORD xmm  xmm xmm
//	VPORD ymm  ymm k ymm
//	VPORD ymm  ymm ymm
//	VPORD m512 zmm k zmm
//	VPORD m512 zmm zmm
//	VPORD zmm  zmm k zmm
//	VPORD zmm  zmm zmm
func VPORD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPORD.Forms(), sffxs{}, ops)
}

// VPORD_BCST: Bitwise Logical OR of Packed Doubleword Integers (Broadcast).
//
// Forms:
//
//	VPORD.BCST m32 xmm k xmm
//	VPORD.BCST m32 xmm xmm
//	VPORD.BCST m32 ymm k ymm
//	VPORD.BCST m32 ymm ymm
//	VPORD.BCST m32 zmm k zmm
//	VPORD.BCST m32 zmm zmm
func VPORD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPORD.Forms(), sffxs{sffxBCST}, ops)
}

// VPORD_BCST_Z: Bitwise Logical OR of Packed Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPORD.BCST.Z m32 xmm k xmm
//	VPORD.BCST.Z m32 ymm k ymm
//	VPORD.BCST.Z m32 zmm k zmm
func VPORD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPORD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPORD_Z: Bitwise Logical OR of Packed Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VPORD.Z m128 xmm k xmm
//	VPORD.Z m256 ymm k ymm
//	VPORD.Z xmm  xmm k xmm
//	VPORD.Z ymm  ymm k ymm
//	VPORD.Z m512 zmm k zmm
//	VPORD.Z zmm  zmm k zmm
func VPORD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPORD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPORQ: Bitwise Logical OR of Packed Quadword Integers.
//
// Forms:
//
//	VPORQ m128 xmm k xmm
//	VPORQ m128 xmm xmm
//	VPORQ m256 ymm k ymm
//	VPORQ m256 ymm ymm
//	VPORQ xmm  xmm k xmm
//	VPORQ xmm  xmm xmm
//	VPORQ ymm  ymm k ymm
//	VPORQ ymm  ymm ymm
//	VPORQ m512 zmm k zmm
//	VPORQ m512 zmm zmm
//	VPORQ zmm  zmm k zmm
//	VPORQ zmm  zmm zmm
func VPORQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPORQ.Forms(), sffxs{}, ops)
}

// VPORQ_BCST: Bitwise Logical OR of Packed Quadword Integers (Broadcast).
//
// Forms:
//
//	VPORQ.BCST m64 xmm k xmm
//	VPORQ.BCST m64 xmm xmm
//	VPORQ.BCST m64 ymm k ymm
//	VPORQ.BCST m64 ymm ymm
//	VPORQ.BCST m64 zmm k zmm
//	VPORQ.BCST m64 zmm zmm
func VPORQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPORQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPORQ_BCST_Z: Bitwise Logical OR of Packed Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPORQ.BCST.Z m64 xmm k xmm
//	VPORQ.BCST.Z m64 ymm k ymm
//	VPORQ.BCST.Z m64 zmm k zmm
func VPORQ_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPORQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPORQ_Z: Bitwise Logical OR of Packed Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VPORQ.Z m128 xmm k xmm
//	VPORQ.Z m256 ymm k ymm
//	VPORQ.Z xmm  xmm k xmm
//	VPORQ.Z ymm  ymm k ymm
//	VPORQ.Z m512 zmm k zmm
//	VPORQ.Z zmm  zmm k zmm
func VPORQ_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPORQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPROLD: Rotate Packed Doubleword Left.
//
// Forms:
//
//	VPROLD imm8 m128 k xmm
//	VPROLD imm8 m128 xmm
//	VPROLD imm8 m256 k ymm
//	VPROLD imm8 m256 ymm
//	VPROLD imm8 xmm  k xmm
//	VPROLD imm8 xmm  xmm
//	VPROLD imm8 ymm  k ymm
//	VPROLD imm8 ymm  ymm
//	VPROLD imm8 m512 k zmm
//	VPROLD imm8 m512 zmm
//	VPROLD imm8 zmm  k zmm
//	VPROLD imm8 zmm  zmm
func VPROLD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPROLD.Forms(), sffxs{}, ops)
}

// VPROLD_BCST: Rotate Packed Doubleword Left (Broadcast).
//
// Forms:
//
//	VPROLD.BCST imm8 m32 k xmm
//	VPROLD.BCST imm8 m32 k ymm
//	VPROLD.BCST imm8 m32 xmm
//	VPROLD.BCST imm8 m32 ymm
//	VPROLD.BCST imm8 m32 k zmm
//	VPROLD.BCST imm8 m32 zmm
func VPROLD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPROLD.Forms(), sffxs{sffxBCST}, ops)
}

// VPROLD_BCST_Z: Rotate Packed Doubleword Left (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPROLD.BCST.Z imm8 m32 k xmm
//	VPROLD.BCST.Z imm8 m32 k ymm
//	VPROLD.BCST.Z imm8 m32 k zmm
func VPROLD_BCST_Z(i, m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPROLD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, k, xyz})
}

// VPROLD_Z: Rotate Packed Doubleword Left (Zeroing Masking).
//
// Forms:
//
//	VPROLD.Z imm8 m128 k xmm
//	VPROLD.Z imm8 m256 k ymm
//	VPROLD.Z imm8 xmm  k xmm
//	VPROLD.Z imm8 ymm  k ymm
//	VPROLD.Z imm8 m512 k zmm
//	VPROLD.Z imm8 zmm  k zmm
func VPROLD_Z(i, mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPROLD.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, k, xyz})
}

// VPROLQ: Rotate Packed Quadword Left.
//
// Forms:
//
//	VPROLQ imm8 m128 k xmm
//	VPROLQ imm8 m128 xmm
//	VPROLQ imm8 m256 k ymm
//	VPROLQ imm8 m256 ymm
//	VPROLQ imm8 xmm  k xmm
//	VPROLQ imm8 xmm  xmm
//	VPROLQ imm8 ymm  k ymm
//	VPROLQ imm8 ymm  ymm
//	VPROLQ imm8 m512 k zmm
//	VPROLQ imm8 m512 zmm
//	VPROLQ imm8 zmm  k zmm
//	VPROLQ imm8 zmm  zmm
func VPROLQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPROLQ.Forms(), sffxs{}, ops)
}

// VPROLQ_BCST: Rotate Packed Quadword Left (Broadcast).
//
// Forms:
//
//	VPROLQ.BCST imm8 m64 k xmm
//	VPROLQ.BCST imm8 m64 k ymm
//	VPROLQ.BCST imm8 m64 xmm
//	VPROLQ.BCST imm8 m64 ymm
//	VPROLQ.BCST imm8 m64 k zmm
//	VPROLQ.BCST imm8 m64 zmm
func VPROLQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPROLQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPROLQ_BCST_Z: Rotate Packed Quadword Left (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPROLQ.BCST.Z imm8 m64 k xmm
//	VPROLQ.BCST.Z imm8 m64 k ymm
//	VPROLQ.BCST.Z imm8 m64 k zmm
func VPROLQ_BCST_Z(i, m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPROLQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, k, xyz})
}

// VPROLQ_Z: Rotate Packed Quadword Left (Zeroing Masking).
//
// Forms:
//
//	VPROLQ.Z imm8 m128 k xmm
//	VPROLQ.Z imm8 m256 k ymm
//	VPROLQ.Z imm8 xmm  k xmm
//	VPROLQ.Z imm8 ymm  k ymm
//	VPROLQ.Z imm8 m512 k zmm
//	VPROLQ.Z imm8 zmm  k zmm
func VPROLQ_Z(i, mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPROLQ.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, k, xyz})
}

// VPROLVD: Variable Rotate Packed Doubleword Left.
//
// Forms:
//
//	VPROLVD m128 xmm k xmm
//	VPROLVD m128 xmm xmm
//	VPROLVD m256 ymm k ymm
//	VPROLVD m256 ymm ymm
//	VPROLVD xmm  xmm k xmm
//	VPROLVD xmm  xmm xmm
//	VPROLVD ymm  ymm k ymm
//	VPROLVD ymm  ymm ymm
//	VPROLVD m512 zmm k zmm
//	VPROLVD m512 zmm zmm
//	VPROLVD zmm  zmm k zmm
//	VPROLVD zmm  zmm zmm
func VPROLVD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPROLVD.Forms(), sffxs{}, ops)
}

// VPROLVD_BCST: Variable Rotate Packed Doubleword Left (Broadcast).
//
// Forms:
//
//	VPROLVD.BCST m32 xmm k xmm
//	VPROLVD.BCST m32 xmm xmm
//	VPROLVD.BCST m32 ymm k ymm
//	VPROLVD.BCST m32 ymm ymm
//	VPROLVD.BCST m32 zmm k zmm
//	VPROLVD.BCST m32 zmm zmm
func VPROLVD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPROLVD.Forms(), sffxs{sffxBCST}, ops)
}

// VPROLVD_BCST_Z: Variable Rotate Packed Doubleword Left (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPROLVD.BCST.Z m32 xmm k xmm
//	VPROLVD.BCST.Z m32 ymm k ymm
//	VPROLVD.BCST.Z m32 zmm k zmm
func VPROLVD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPROLVD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPROLVD_Z: Variable Rotate Packed Doubleword Left (Zeroing Masking).
//
// Forms:
//
//	VPROLVD.Z m128 xmm k xmm
//	VPROLVD.Z m256 ymm k ymm
//	VPROLVD.Z xmm  xmm k xmm
//	VPROLVD.Z ymm  ymm k ymm
//	VPROLVD.Z m512 zmm k zmm
//	VPROLVD.Z zmm  zmm k zmm
func VPROLVD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPROLVD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPROLVQ: Variable Rotate Packed Quadword Left.
//
// Forms:
//
//	VPROLVQ m128 xmm k xmm
//	VPROLVQ m128 xmm xmm
//	VPROLVQ m256 ymm k ymm
//	VPROLVQ m256 ymm ymm
//	VPROLVQ xmm  xmm k xmm
//	VPROLVQ xmm  xmm xmm
//	VPROLVQ ymm  ymm k ymm
//	VPROLVQ ymm  ymm ymm
//	VPROLVQ m512 zmm k zmm
//	VPROLVQ m512 zmm zmm
//	VPROLVQ zmm  zmm k zmm
//	VPROLVQ zmm  zmm zmm
func VPROLVQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPROLVQ.Forms(), sffxs{}, ops)
}

// VPROLVQ_BCST: Variable Rotate Packed Quadword Left (Broadcast).
//
// Forms:
//
//	VPROLVQ.BCST m64 xmm k xmm
//	VPROLVQ.BCST m64 xmm xmm
//	VPROLVQ.BCST m64 ymm k ymm
//	VPROLVQ.BCST m64 ymm ymm
//	VPROLVQ.BCST m64 zmm k zmm
//	VPROLVQ.BCST m64 zmm zmm
func VPROLVQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPROLVQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPROLVQ_BCST_Z: Variable Rotate Packed Quadword Left (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPROLVQ.BCST.Z m64 xmm k xmm
//	VPROLVQ.BCST.Z m64 ymm k ymm
//	VPROLVQ.BCST.Z m64 zmm k zmm
func VPROLVQ_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPROLVQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPROLVQ_Z: Variable Rotate Packed Quadword Left (Zeroing Masking).
//
// Forms:
//
//	VPROLVQ.Z m128 xmm k xmm
//	VPROLVQ.Z m256 ymm k ymm
//	VPROLVQ.Z xmm  xmm k xmm
//	VPROLVQ.Z ymm  ymm k ymm
//	VPROLVQ.Z m512 zmm k zmm
//	VPROLVQ.Z zmm  zmm k zmm
func VPROLVQ_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPROLVQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPRORD: Rotate Packed Doubleword Right.
//
// Forms:
//
//	VPRORD imm8 m128 k xmm
//	VPRORD imm8 m128 xmm
//	VPRORD imm8 m256 k ymm
//	VPRORD imm8 m256 ymm
//	VPRORD imm8 xmm  k xmm
//	VPRORD imm8 xmm  xmm
//	VPRORD imm8 ymm  k ymm
//	VPRORD imm8 ymm  ymm
//	VPRORD imm8 m512 k zmm
//	VPRORD imm8 m512 zmm
//	VPRORD imm8 zmm  k zmm
//	VPRORD imm8 zmm  zmm
func VPRORD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPRORD.Forms(), sffxs{}, ops)
}

// VPRORD_BCST: Rotate Packed Doubleword Right (Broadcast).
//
// Forms:
//
//	VPRORD.BCST imm8 m32 k xmm
//	VPRORD.BCST imm8 m32 k ymm
//	VPRORD.BCST imm8 m32 xmm
//	VPRORD.BCST imm8 m32 ymm
//	VPRORD.BCST imm8 m32 k zmm
//	VPRORD.BCST imm8 m32 zmm
func VPRORD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPRORD.Forms(), sffxs{sffxBCST}, ops)
}

// VPRORD_BCST_Z: Rotate Packed Doubleword Right (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPRORD.BCST.Z imm8 m32 k xmm
//	VPRORD.BCST.Z imm8 m32 k ymm
//	VPRORD.BCST.Z imm8 m32 k zmm
func VPRORD_BCST_Z(i, m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPRORD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, k, xyz})
}

// VPRORD_Z: Rotate Packed Doubleword Right (Zeroing Masking).
//
// Forms:
//
//	VPRORD.Z imm8 m128 k xmm
//	VPRORD.Z imm8 m256 k ymm
//	VPRORD.Z imm8 xmm  k xmm
//	VPRORD.Z imm8 ymm  k ymm
//	VPRORD.Z imm8 m512 k zmm
//	VPRORD.Z imm8 zmm  k zmm
func VPRORD_Z(i, mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPRORD.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, k, xyz})
}

// VPRORQ: Rotate Packed Quadword Right.
//
// Forms:
//
//	VPRORQ imm8 m128 k xmm
//	VPRORQ imm8 m128 xmm
//	VPRORQ imm8 m256 k ymm
//	VPRORQ imm8 m256 ymm
//	VPRORQ imm8 xmm  k xmm
//	VPRORQ imm8 xmm  xmm
//	VPRORQ imm8 ymm  k ymm
//	VPRORQ imm8 ymm  ymm
//	VPRORQ imm8 m512 k zmm
//	VPRORQ imm8 m512 zmm
//	VPRORQ imm8 zmm  k zmm
//	VPRORQ imm8 zmm  zmm
func VPRORQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPRORQ.Forms(), sffxs{}, ops)
}

// VPRORQ_BCST: Rotate Packed Quadword Right (Broadcast).
//
// Forms:
//
//	VPRORQ.BCST imm8 m64 k xmm
//	VPRORQ.BCST imm8 m64 k ymm
//	VPRORQ.BCST imm8 m64 xmm
//	VPRORQ.BCST imm8 m64 ymm
//	VPRORQ.BCST imm8 m64 k zmm
//	VPRORQ.BCST imm8 m64 zmm
func VPRORQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPRORQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPRORQ_BCST_Z: Rotate Packed Quadword Right (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPRORQ.BCST.Z imm8 m64 k xmm
//	VPRORQ.BCST.Z imm8 m64 k ymm
//	VPRORQ.BCST.Z imm8 m64 k zmm
func VPRORQ_BCST_Z(i, m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPRORQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, k, xyz})
}

// VPRORQ_Z: Rotate Packed Quadword Right (Zeroing Masking).
//
// Forms:
//
//	VPRORQ.Z imm8 m128 k xmm
//	VPRORQ.Z imm8 m256 k ymm
//	VPRORQ.Z imm8 xmm  k xmm
//	VPRORQ.Z imm8 ymm  k ymm
//	VPRORQ.Z imm8 m512 k zmm
//	VPRORQ.Z imm8 zmm  k zmm
func VPRORQ_Z(i, mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPRORQ.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, k, xyz})
}

// VPRORVD: Variable Rotate Packed Doubleword Right.
//
// Forms:
//
//	VPRORVD m128 xmm k xmm
//	VPRORVD m128 xmm xmm
//	VPRORVD m256 ymm k ymm
//	VPRORVD m256 ymm ymm
//	VPRORVD xmm  xmm k xmm
//	VPRORVD xmm  xmm xmm
//	VPRORVD ymm  ymm k ymm
//	VPRORVD ymm  ymm ymm
//	VPRORVD m512 zmm k zmm
//	VPRORVD m512 zmm zmm
//	VPRORVD zmm  zmm k zmm
//	VPRORVD zmm  zmm zmm
func VPRORVD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPRORVD.Forms(), sffxs{}, ops)
}

// VPRORVD_BCST: Variable Rotate Packed Doubleword Right (Broadcast).
//
// Forms:
//
//	VPRORVD.BCST m32 xmm k xmm
//	VPRORVD.BCST m32 xmm xmm
//	VPRORVD.BCST m32 ymm k ymm
//	VPRORVD.BCST m32 ymm ymm
//	VPRORVD.BCST m32 zmm k zmm
//	VPRORVD.BCST m32 zmm zmm
func VPRORVD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPRORVD.Forms(), sffxs{sffxBCST}, ops)
}

// VPRORVD_BCST_Z: Variable Rotate Packed Doubleword Right (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPRORVD.BCST.Z m32 xmm k xmm
//	VPRORVD.BCST.Z m32 ymm k ymm
//	VPRORVD.BCST.Z m32 zmm k zmm
func VPRORVD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPRORVD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPRORVD_Z: Variable Rotate Packed Doubleword Right (Zeroing Masking).
//
// Forms:
//
//	VPRORVD.Z m128 xmm k xmm
//	VPRORVD.Z m256 ymm k ymm
//	VPRORVD.Z xmm  xmm k xmm
//	VPRORVD.Z ymm  ymm k ymm
//	VPRORVD.Z m512 zmm k zmm
//	VPRORVD.Z zmm  zmm k zmm
func VPRORVD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPRORVD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPRORVQ: Variable Rotate Packed Quadword Right.
//
// Forms:
//
//	VPRORVQ m128 xmm k xmm
//	VPRORVQ m128 xmm xmm
//	VPRORVQ m256 ymm k ymm
//	VPRORVQ m256 ymm ymm
//	VPRORVQ xmm  xmm k xmm
//	VPRORVQ xmm  xmm xmm
//	VPRORVQ ymm  ymm k ymm
//	VPRORVQ ymm  ymm ymm
//	VPRORVQ m512 zmm k zmm
//	VPRORVQ m512 zmm zmm
//	VPRORVQ zmm  zmm k zmm
//	VPRORVQ zmm  zmm zmm
func VPRORVQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPRORVQ.Forms(), sffxs{}, ops)
}

// VPRORVQ_BCST: Variable Rotate Packed Quadword Right (Broadcast).
//
// Forms:
//
//	VPRORVQ.BCST m64 xmm k xmm
//	VPRORVQ.BCST m64 xmm xmm
//	VPRORVQ.BCST m64 ymm k ymm
//	VPRORVQ.BCST m64 ymm ymm
//	VPRORVQ.BCST m64 zmm k zmm
//	VPRORVQ.BCST m64 zmm zmm
func VPRORVQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPRORVQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPRORVQ_BCST_Z: Variable Rotate Packed Quadword Right (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPRORVQ.BCST.Z m64 xmm k xmm
//	VPRORVQ.BCST.Z m64 ymm k ymm
//	VPRORVQ.BCST.Z m64 zmm k zmm
func VPRORVQ_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPRORVQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPRORVQ_Z: Variable Rotate Packed Quadword Right (Zeroing Masking).
//
// Forms:
//
//	VPRORVQ.Z m128 xmm k xmm
//	VPRORVQ.Z m256 ymm k ymm
//	VPRORVQ.Z xmm  xmm k xmm
//	VPRORVQ.Z ymm  ymm k ymm
//	VPRORVQ.Z m512 zmm k zmm
//	VPRORVQ.Z zmm  zmm k zmm
func VPRORVQ_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPRORVQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPSADBW: Compute Sum of Absolute Differences.
//
// Forms:
//
//	VPSADBW m256 ymm ymm
//	VPSADBW ymm  ymm ymm
//	VPSADBW m128 xmm xmm
//	VPSADBW xmm  xmm xmm
//	VPSADBW m512 zmm zmm
//	VPSADBW zmm  zmm zmm
func VPSADBW(mxyz, xyz, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSADBW.Forms(), sffxs{}, []operand.Op{mxyz, xyz, xyz1})
}

// VPSCATTERDD: Scatter Packed Doubleword Values with Signed Doubleword Indices.
//
// Forms:
//
//	VPSCATTERDD xmm k vm32x
//	VPSCATTERDD ymm k vm32y
//	VPSCATTERDD zmm k vm32z
func VPSCATTERDD(xyz, k, v operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSCATTERDD.Forms(), sffxs{}, []operand.Op{xyz, k, v})
}

// VPSCATTERDQ: Scatter Packed Quadword Values with Signed Doubleword Indices.
//
// Forms:
//
//	VPSCATTERDQ xmm k vm32x
//	VPSCATTERDQ ymm k vm32x
//	VPSCATTERDQ zmm k vm32y
func VPSCATTERDQ(xyz, k, v operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSCATTERDQ.Forms(), sffxs{}, []operand.Op{xyz, k, v})
}

// VPSCATTERQD: Scatter Packed Doubleword Values with Signed Quadword Indices.
//
// Forms:
//
//	VPSCATTERQD xmm k vm64x
//	VPSCATTERQD xmm k vm64y
//	VPSCATTERQD ymm k vm64z
func VPSCATTERQD(xy, k, v operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSCATTERQD.Forms(), sffxs{}, []operand.Op{xy, k, v})
}

// VPSCATTERQQ: Scatter Packed Quadword Values with Signed Quadword Indices.
//
// Forms:
//
//	VPSCATTERQQ xmm k vm64x
//	VPSCATTERQQ ymm k vm64y
//	VPSCATTERQQ zmm k vm64z
func VPSCATTERQQ(xyz, k, v operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSCATTERQQ.Forms(), sffxs{}, []operand.Op{xyz, k, v})
}

// VPSHLDD: Concatenate Dwords and Shift Packed Data Left Logical.
//
// Forms:
//
//	VPSHLDD imm8 m128 xmm k xmm
//	VPSHLDD imm8 m128 xmm xmm
//	VPSHLDD imm8 m256 ymm k ymm
//	VPSHLDD imm8 m256 ymm ymm
//	VPSHLDD imm8 xmm  xmm k xmm
//	VPSHLDD imm8 xmm  xmm xmm
//	VPSHLDD imm8 ymm  ymm k ymm
//	VPSHLDD imm8 ymm  ymm ymm
//	VPSHLDD imm8 m512 zmm k zmm
//	VPSHLDD imm8 m512 zmm zmm
//	VPSHLDD imm8 zmm  zmm k zmm
//	VPSHLDD imm8 zmm  zmm zmm
func VPSHLDD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHLDD.Forms(), sffxs{}, ops)
}

// VPSHLDD_BCST: Concatenate Dwords and Shift Packed Data Left Logical (Broadcast).
//
// Forms:
//
//	VPSHLDD.BCST imm8 m32 xmm k xmm
//	VPSHLDD.BCST imm8 m32 xmm xmm
//	VPSHLDD.BCST imm8 m32 ymm k ymm
//	VPSHLDD.BCST imm8 m32 ymm ymm
//	VPSHLDD.BCST imm8 m32 zmm k zmm
//	VPSHLDD.BCST imm8 m32 zmm zmm
func VPSHLDD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHLDD.Forms(), sffxs{sffxBCST}, ops)
}

// VPSHLDD_BCST_Z: Concatenate Dwords and Shift Packed Data Left Logical (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPSHLDD.BCST.Z imm8 m32 xmm k xmm
//	VPSHLDD.BCST.Z imm8 m32 ymm k ymm
//	VPSHLDD.BCST.Z imm8 m32 zmm k zmm
func VPSHLDD_BCST_Z(i, m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHLDD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, xyz, k, xyz1})
}

// VPSHLDD_Z: Concatenate Dwords and Shift Packed Data Left Logical (Zeroing Masking).
//
// Forms:
//
//	VPSHLDD.Z imm8 m128 xmm k xmm
//	VPSHLDD.Z imm8 m256 ymm k ymm
//	VPSHLDD.Z imm8 xmm  xmm k xmm
//	VPSHLDD.Z imm8 ymm  ymm k ymm
//	VPSHLDD.Z imm8 m512 zmm k zmm
//	VPSHLDD.Z imm8 zmm  zmm k zmm
func VPSHLDD_Z(i, mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHLDD.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, xyz, k, xyz1})
}

// VPSHLDQ: Concatenate Quadwords and Shift Packed Data Left Logical.
//
// Forms:
//
//	VPSHLDQ imm8 m128 xmm k xmm
//	VPSHLDQ imm8 m128 xmm xmm
//	VPSHLDQ imm8 m256 ymm k ymm
//	VPSHLDQ imm8 m256 ymm ymm
//	VPSHLDQ imm8 xmm  xmm k xmm
//	VPSHLDQ imm8 xmm  xmm xmm
//	VPSHLDQ imm8 ymm  ymm k ymm
//	VPSHLDQ imm8 ymm  ymm ymm
//	VPSHLDQ imm8 m512 zmm k zmm
//	VPSHLDQ imm8 m512 zmm zmm
//	VPSHLDQ imm8 zmm  zmm k zmm
//	VPSHLDQ imm8 zmm  zmm zmm
func VPSHLDQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHLDQ.Forms(), sffxs{}, ops)
}

// VPSHLDQ_BCST: Concatenate Quadwords and Shift Packed Data Left Logical (Broadcast).
//
// Forms:
//
//	VPSHLDQ.BCST imm8 m64 xmm k xmm
//	VPSHLDQ.BCST imm8 m64 xmm xmm
//	VPSHLDQ.BCST imm8 m64 ymm k ymm
//	VPSHLDQ.BCST imm8 m64 ymm ymm
//	VPSHLDQ.BCST imm8 m64 zmm k zmm
//	VPSHLDQ.BCST imm8 m64 zmm zmm
func VPSHLDQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHLDQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPSHLDQ_BCST_Z: Concatenate Quadwords and Shift Packed Data Left Logical (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPSHLDQ.BCST.Z imm8 m64 xmm k xmm
//	VPSHLDQ.BCST.Z imm8 m64 ymm k ymm
//	VPSHLDQ.BCST.Z imm8 m64 zmm k zmm
func VPSHLDQ_BCST_Z(i, m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHLDQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, xyz, k, xyz1})
}

// VPSHLDQ_Z: Concatenate Quadwords and Shift Packed Data Left Logical (Zeroing Masking).
//
// Forms:
//
//	VPSHLDQ.Z imm8 m128 xmm k xmm
//	VPSHLDQ.Z imm8 m256 ymm k ymm
//	VPSHLDQ.Z imm8 xmm  xmm k xmm
//	VPSHLDQ.Z imm8 ymm  ymm k ymm
//	VPSHLDQ.Z imm8 m512 zmm k zmm
//	VPSHLDQ.Z imm8 zmm  zmm k zmm
func VPSHLDQ_Z(i, mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHLDQ.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, xyz, k, xyz1})
}

// VPSHLDVD: Concatenate Dwords and Variable Shift Packed Data Left Logical.
//
// Forms:
//
//	VPSHLDVD m128 xmm k xmm
//	VPSHLDVD m128 xmm xmm
//	VPSHLDVD m256 ymm k ymm
//	VPSHLDVD m256 ymm ymm
//	VPSHLDVD xmm  xmm k xmm
//	VPSHLDVD xmm  xmm xmm
//	VPSHLDVD ymm  ymm k ymm
//	VPSHLDVD ymm  ymm ymm
//	VPSHLDVD m512 zmm k zmm
//	VPSHLDVD m512 zmm zmm
//	VPSHLDVD zmm  zmm k zmm
//	VPSHLDVD zmm  zmm zmm
func VPSHLDVD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHLDVD.Forms(), sffxs{}, ops)
}

// VPSHLDVD_BCST: Concatenate Dwords and Variable Shift Packed Data Left Logical (Broadcast).
//
// Forms:
//
//	VPSHLDVD.BCST m32 xmm k xmm
//	VPSHLDVD.BCST m32 xmm xmm
//	VPSHLDVD.BCST m32 ymm k ymm
//	VPSHLDVD.BCST m32 ymm ymm
//	VPSHLDVD.BCST m32 zmm k zmm
//	VPSHLDVD.BCST m32 zmm zmm
func VPSHLDVD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHLDVD.Forms(), sffxs{sffxBCST}, ops)
}

// VPSHLDVD_BCST_Z: Concatenate Dwords and Variable Shift Packed Data Left Logical (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPSHLDVD.BCST.Z m32 xmm k xmm
//	VPSHLDVD.BCST.Z m32 ymm k ymm
//	VPSHLDVD.BCST.Z m32 zmm k zmm
func VPSHLDVD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHLDVD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPSHLDVD_Z: Concatenate Dwords and Variable Shift Packed Data Left Logical (Zeroing Masking).
//
// Forms:
//
//	VPSHLDVD.Z m128 xmm k xmm
//	VPSHLDVD.Z m256 ymm k ymm
//	VPSHLDVD.Z xmm  xmm k xmm
//	VPSHLDVD.Z ymm  ymm k ymm
//	VPSHLDVD.Z m512 zmm k zmm
//	VPSHLDVD.Z zmm  zmm k zmm
func VPSHLDVD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHLDVD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPSHLDVQ: Concatenate Quadwords and Variable Shift Packed Data Left Logical.
//
// Forms:
//
//	VPSHLDVQ m128 xmm k xmm
//	VPSHLDVQ m128 xmm xmm
//	VPSHLDVQ m256 ymm k ymm
//	VPSHLDVQ m256 ymm ymm
//	VPSHLDVQ xmm  xmm k xmm
//	VPSHLDVQ xmm  xmm xmm
//	VPSHLDVQ ymm  ymm k ymm
//	VPSHLDVQ ymm  ymm ymm
//	VPSHLDVQ m512 zmm k zmm
//	VPSHLDVQ m512 zmm zmm
//	VPSHLDVQ zmm  zmm k zmm
//	VPSHLDVQ zmm  zmm zmm
func VPSHLDVQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHLDVQ.Forms(), sffxs{}, ops)
}

// VPSHLDVQ_BCST: Concatenate Quadwords and Variable Shift Packed Data Left Logical (Broadcast).
//
// Forms:
//
//	VPSHLDVQ.BCST m64 xmm k xmm
//	VPSHLDVQ.BCST m64 xmm xmm
//	VPSHLDVQ.BCST m64 ymm k ymm
//	VPSHLDVQ.BCST m64 ymm ymm
//	VPSHLDVQ.BCST m64 zmm k zmm
//	VPSHLDVQ.BCST m64 zmm zmm
func VPSHLDVQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHLDVQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPSHLDVQ_BCST_Z: Concatenate Quadwords and Variable Shift Packed Data Left Logical (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPSHLDVQ.BCST.Z m64 xmm k xmm
//	VPSHLDVQ.BCST.Z m64 ymm k ymm
//	VPSHLDVQ.BCST.Z m64 zmm k zmm
func VPSHLDVQ_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHLDVQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPSHLDVQ_Z: Concatenate Quadwords and Variable Shift Packed Data Left Logical (Zeroing Masking).
//
// Forms:
//
//	VPSHLDVQ.Z m128 xmm k xmm
//	VPSHLDVQ.Z m256 ymm k ymm
//	VPSHLDVQ.Z xmm  xmm k xmm
//	VPSHLDVQ.Z ymm  ymm k ymm
//	VPSHLDVQ.Z m512 zmm k zmm
//	VPSHLDVQ.Z zmm  zmm k zmm
func VPSHLDVQ_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHLDVQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPSHLDVW: Concatenate Words and Variable Shift Packed Data Left Logical.
//
// Forms:
//
//	VPSHLDVW m128 xmm k xmm
//	VPSHLDVW m128 xmm xmm
//	VPSHLDVW m256 ymm k ymm
//	VPSHLDVW m256 ymm ymm
//	VPSHLDVW xmm  xmm k xmm
//	VPSHLDVW xmm  xmm xmm
//	VPSHLDVW ymm  ymm k ymm
//	VPSHLDVW ymm  ymm ymm
//	VPSHLDVW m512 zmm k zmm
//	VPSHLDVW m512 zmm zmm
//	VPSHLDVW zmm  zmm k zmm
//	VPSHLDVW zmm  zmm zmm
func VPSHLDVW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHLDVW.Forms(), sffxs{}, ops)
}

// VPSHLDVW_Z: Concatenate Words and Variable Shift Packed Data Left Logical (Zeroing Masking).
//
// Forms:
//
//	VPSHLDVW.Z m128 xmm k xmm
//	VPSHLDVW.Z m256 ymm k ymm
//	VPSHLDVW.Z xmm  xmm k xmm
//	VPSHLDVW.Z ymm  ymm k ymm
//	VPSHLDVW.Z m512 zmm k zmm
//	VPSHLDVW.Z zmm  zmm k zmm
func VPSHLDVW_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHLDVW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPSHLDW: Concatenate Words and Shift Packed Data Left Logical.
//
// Forms:
//
//	VPSHLDW imm8 m128 xmm k xmm
//	VPSHLDW imm8 m128 xmm xmm
//	VPSHLDW imm8 m256 ymm k ymm
//	VPSHLDW imm8 m256 ymm ymm
//	VPSHLDW imm8 xmm  xmm k xmm
//	VPSHLDW imm8 xmm  xmm xmm
//	VPSHLDW imm8 ymm  ymm k ymm
//	VPSHLDW imm8 ymm  ymm ymm
//	VPSHLDW imm8 m512 zmm k zmm
//	VPSHLDW imm8 m512 zmm zmm
//	VPSHLDW imm8 zmm  zmm k zmm
//	VPSHLDW imm8 zmm  zmm zmm
func VPSHLDW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHLDW.Forms(), sffxs{}, ops)
}

// VPSHLDW_Z: Concatenate Words and Shift Packed Data Left Logical (Zeroing Masking).
//
// Forms:
//
//	VPSHLDW.Z imm8 m128 xmm k xmm
//	VPSHLDW.Z imm8 m256 ymm k ymm
//	VPSHLDW.Z imm8 xmm  xmm k xmm
//	VPSHLDW.Z imm8 ymm  ymm k ymm
//	VPSHLDW.Z imm8 m512 zmm k zmm
//	VPSHLDW.Z imm8 zmm  zmm k zmm
func VPSHLDW_Z(i, mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHLDW.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, xyz, k, xyz1})
}

// VPSHRDD: Concatenate Dwords and Shift Packed Data Right Logical.
//
// Forms:
//
//	VPSHRDD imm8 m128 xmm k xmm
//	VPSHRDD imm8 m128 xmm xmm
//	VPSHRDD imm8 m256 ymm k ymm
//	VPSHRDD imm8 m256 ymm ymm
//	VPSHRDD imm8 xmm  xmm k xmm
//	VPSHRDD imm8 xmm  xmm xmm
//	VPSHRDD imm8 ymm  ymm k ymm
//	VPSHRDD imm8 ymm  ymm ymm
//	VPSHRDD imm8 m512 zmm k zmm
//	VPSHRDD imm8 m512 zmm zmm
//	VPSHRDD imm8 zmm  zmm k zmm
//	VPSHRDD imm8 zmm  zmm zmm
func VPSHRDD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHRDD.Forms(), sffxs{}, ops)
}

// VPSHRDD_BCST: Concatenate Dwords and Shift Packed Data Right Logical (Broadcast).
//
// Forms:
//
//	VPSHRDD.BCST imm8 m32 xmm k xmm
//	VPSHRDD.BCST imm8 m32 xmm xmm
//	VPSHRDD.BCST imm8 m32 ymm k ymm
//	VPSHRDD.BCST imm8 m32 ymm ymm
//	VPSHRDD.BCST imm8 m32 zmm k zmm
//	VPSHRDD.BCST imm8 m32 zmm zmm
func VPSHRDD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHRDD.Forms(), sffxs{sffxBCST}, ops)
}

// VPSHRDD_BCST_Z: Concatenate Dwords and Shift Packed Data Right Logical (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPSHRDD.BCST.Z imm8 m32 xmm k xmm
//	VPSHRDD.BCST.Z imm8 m32 ymm k ymm
//	VPSHRDD.BCST.Z imm8 m32 zmm k zmm
func VPSHRDD_BCST_Z(i, m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHRDD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, xyz, k, xyz1})
}

// VPSHRDD_Z: Concatenate Dwords and Shift Packed Data Right Logical (Zeroing Masking).
//
// Forms:
//
//	VPSHRDD.Z imm8 m128 xmm k xmm
//	VPSHRDD.Z imm8 m256 ymm k ymm
//	VPSHRDD.Z imm8 xmm  xmm k xmm
//	VPSHRDD.Z imm8 ymm  ymm k ymm
//	VPSHRDD.Z imm8 m512 zmm k zmm
//	VPSHRDD.Z imm8 zmm  zmm k zmm
func VPSHRDD_Z(i, mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHRDD.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, xyz, k, xyz1})
}

// VPSHRDQ: Concatenate Quadwords and Shift Packed Data Right Logical.
//
// Forms:
//
//	VPSHRDQ imm8 m128 xmm k xmm
//	VPSHRDQ imm8 m128 xmm xmm
//	VPSHRDQ imm8 m256 ymm k ymm
//	VPSHRDQ imm8 m256 ymm ymm
//	VPSHRDQ imm8 xmm  xmm k xmm
//	VPSHRDQ imm8 xmm  xmm xmm
//	VPSHRDQ imm8 ymm  ymm k ymm
//	VPSHRDQ imm8 ymm  ymm ymm
//	VPSHRDQ imm8 m512 zmm k zmm
//	VPSHRDQ imm8 m512 zmm zmm
//	VPSHRDQ imm8 zmm  zmm k zmm
//	VPSHRDQ imm8 zmm  zmm zmm
func VPSHRDQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHRDQ.Forms(), sffxs{}, ops)
}

// VPSHRDQ_BCST: Concatenate Quadwords and Shift Packed Data Right Logical (Broadcast).
//
// Forms:
//
//	VPSHRDQ.BCST imm8 m64 xmm k xmm
//	VPSHRDQ.BCST imm8 m64 xmm xmm
//	VPSHRDQ.BCST imm8 m64 ymm k ymm
//	VPSHRDQ.BCST imm8 m64 ymm ymm
//	VPSHRDQ.BCST imm8 m64 zmm k zmm
//	VPSHRDQ.BCST imm8 m64 zmm zmm
func VPSHRDQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHRDQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPSHRDQ_BCST_Z: Concatenate Quadwords and Shift Packed Data Right Logical (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPSHRDQ.BCST.Z imm8 m64 xmm k xmm
//	VPSHRDQ.BCST.Z imm8 m64 ymm k ymm
//	VPSHRDQ.BCST.Z imm8 m64 zmm k zmm
func VPSHRDQ_BCST_Z(i, m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHRDQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, xyz, k, xyz1})
}

// VPSHRDQ_Z: Concatenate Quadwords and Shift Packed Data Right Logical (Zeroing Masking).
//
// Forms:
//
//	VPSHRDQ.Z imm8 m128 xmm k xmm
//	VPSHRDQ.Z imm8 m256 ymm k ymm
//	VPSHRDQ.Z imm8 xmm  xmm k xmm
//	VPSHRDQ.Z imm8 ymm  ymm k ymm
//	VPSHRDQ.Z imm8 m512 zmm k zmm
//	VPSHRDQ.Z imm8 zmm  zmm k zmm
func VPSHRDQ_Z(i, mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHRDQ.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, xyz, k, xyz1})
}

// VPSHRDVD: Concatenate Dwords and Variable Shift Packed Data Right Logical.
//
// Forms:
//
//	VPSHRDVD m128 xmm k xmm
//	VPSHRDVD m128 xmm xmm
//	VPSHRDVD m256 ymm k ymm
//	VPSHRDVD m256 ymm ymm
//	VPSHRDVD xmm  xmm k xmm
//	VPSHRDVD xmm  xmm xmm
//	VPSHRDVD ymm  ymm k ymm
//	VPSHRDVD ymm  ymm ymm
//	VPSHRDVD m512 zmm k zmm
//	VPSHRDVD m512 zmm zmm
//	VPSHRDVD zmm  zmm k zmm
//	VPSHRDVD zmm  zmm zmm
func VPSHRDVD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHRDVD.Forms(), sffxs{}, ops)
}

// VPSHRDVD_BCST: Concatenate Dwords and Variable Shift Packed Data Right Logical (Broadcast).
//
// Forms:
//
//	VPSHRDVD.BCST m32 xmm k xmm
//	VPSHRDVD.BCST m32 xmm xmm
//	VPSHRDVD.BCST m32 ymm k ymm
//	VPSHRDVD.BCST m32 ymm ymm
//	VPSHRDVD.BCST m32 zmm k zmm
//	VPSHRDVD.BCST m32 zmm zmm
func VPSHRDVD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHRDVD.Forms(), sffxs{sffxBCST}, ops)
}

// VPSHRDVD_BCST_Z: Concatenate Dwords and Variable Shift Packed Data Right Logical (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPSHRDVD.BCST.Z m32 xmm k xmm
//	VPSHRDVD.BCST.Z m32 ymm k ymm
//	VPSHRDVD.BCST.Z m32 zmm k zmm
func VPSHRDVD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHRDVD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPSHRDVD_Z: Concatenate Dwords and Variable Shift Packed Data Right Logical (Zeroing Masking).
//
// Forms:
//
//	VPSHRDVD.Z m128 xmm k xmm
//	VPSHRDVD.Z m256 ymm k ymm
//	VPSHRDVD.Z xmm  xmm k xmm
//	VPSHRDVD.Z ymm  ymm k ymm
//	VPSHRDVD.Z m512 zmm k zmm
//	VPSHRDVD.Z zmm  zmm k zmm
func VPSHRDVD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHRDVD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPSHRDVQ: Concatenate Quadwords and Variable Shift Packed Data Right Logical.
//
// Forms:
//
//	VPSHRDVQ m128 xmm k xmm
//	VPSHRDVQ m128 xmm xmm
//	VPSHRDVQ m256 ymm k ymm
//	VPSHRDVQ m256 ymm ymm
//	VPSHRDVQ xmm  xmm k xmm
//	VPSHRDVQ xmm  xmm xmm
//	VPSHRDVQ ymm  ymm k ymm
//	VPSHRDVQ ymm  ymm ymm
//	VPSHRDVQ m512 zmm k zmm
//	VPSHRDVQ m512 zmm zmm
//	VPSHRDVQ zmm  zmm k zmm
//	VPSHRDVQ zmm  zmm zmm
func VPSHRDVQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHRDVQ.Forms(), sffxs{}, ops)
}

// VPSHRDVQ_BCST: Concatenate Quadwords and Variable Shift Packed Data Right Logical (Broadcast).
//
// Forms:
//
//	VPSHRDVQ.BCST m64 xmm k xmm
//	VPSHRDVQ.BCST m64 xmm xmm
//	VPSHRDVQ.BCST m64 ymm k ymm
//	VPSHRDVQ.BCST m64 ymm ymm
//	VPSHRDVQ.BCST m64 zmm k zmm
//	VPSHRDVQ.BCST m64 zmm zmm
func VPSHRDVQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHRDVQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPSHRDVQ_BCST_Z: Concatenate Quadwords and Variable Shift Packed Data Right Logical (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPSHRDVQ.BCST.Z m64 xmm k xmm
//	VPSHRDVQ.BCST.Z m64 ymm k ymm
//	VPSHRDVQ.BCST.Z m64 zmm k zmm
func VPSHRDVQ_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHRDVQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPSHRDVQ_Z: Concatenate Quadwords and Variable Shift Packed Data Right Logical (Zeroing Masking).
//
// Forms:
//
//	VPSHRDVQ.Z m128 xmm k xmm
//	VPSHRDVQ.Z m256 ymm k ymm
//	VPSHRDVQ.Z xmm  xmm k xmm
//	VPSHRDVQ.Z ymm  ymm k ymm
//	VPSHRDVQ.Z m512 zmm k zmm
//	VPSHRDVQ.Z zmm  zmm k zmm
func VPSHRDVQ_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHRDVQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPSHRDVW: Concatenate Words and Variable Shift Packed Data Right Logical.
//
// Forms:
//
//	VPSHRDVW m128 xmm k xmm
//	VPSHRDVW m128 xmm xmm
//	VPSHRDVW m256 ymm k ymm
//	VPSHRDVW m256 ymm ymm
//	VPSHRDVW xmm  xmm k xmm
//	VPSHRDVW xmm  xmm xmm
//	VPSHRDVW ymm  ymm k ymm
//	VPSHRDVW ymm  ymm ymm
//	VPSHRDVW m512 zmm k zmm
//	VPSHRDVW m512 zmm zmm
//	VPSHRDVW zmm  zmm k zmm
//	VPSHRDVW zmm  zmm zmm
func VPSHRDVW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHRDVW.Forms(), sffxs{}, ops)
}

// VPSHRDVW_Z: Concatenate Words and Variable Shift Packed Data Right Logical (Zeroing Masking).
//
// Forms:
//
//	VPSHRDVW.Z m128 xmm k xmm
//	VPSHRDVW.Z m256 ymm k ymm
//	VPSHRDVW.Z xmm  xmm k xmm
//	VPSHRDVW.Z ymm  ymm k ymm
//	VPSHRDVW.Z m512 zmm k zmm
//	VPSHRDVW.Z zmm  zmm k zmm
func VPSHRDVW_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHRDVW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPSHRDW: Concatenate Words and Shift Packed Data Right Logical.
//
// Forms:
//
//	VPSHRDW imm8 m128 xmm k xmm
//	VPSHRDW imm8 m128 xmm xmm
//	VPSHRDW imm8 m256 ymm k ymm
//	VPSHRDW imm8 m256 ymm ymm
//	VPSHRDW imm8 xmm  xmm k xmm
//	VPSHRDW imm8 xmm  xmm xmm
//	VPSHRDW imm8 ymm  ymm k ymm
//	VPSHRDW imm8 ymm  ymm ymm
//	VPSHRDW imm8 m512 zmm k zmm
//	VPSHRDW imm8 m512 zmm zmm
//	VPSHRDW imm8 zmm  zmm k zmm
//	VPSHRDW imm8 zmm  zmm zmm
func VPSHRDW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHRDW.Forms(), sffxs{}, ops)
}

// VPSHRDW_Z: Concatenate Words and Shift Packed Data Right Logical (Zeroing Masking).
//
// Forms:
//
//	VPSHRDW.Z imm8 m128 xmm k xmm
//	VPSHRDW.Z imm8 m256 ymm k ymm
//	VPSHRDW.Z imm8 xmm  xmm k xmm
//	VPSHRDW.Z imm8 ymm  ymm k ymm
//	VPSHRDW.Z imm8 m512 zmm k zmm
//	VPSHRDW.Z imm8 zmm  zmm k zmm
func VPSHRDW_Z(i, mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHRDW.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, xyz, k, xyz1})
}

// VPSHUFB: Packed Shuffle Bytes.
//
// Forms:
//
//	VPSHUFB m256 ymm ymm
//	VPSHUFB ymm  ymm ymm
//	VPSHUFB m128 xmm xmm
//	VPSHUFB xmm  xmm xmm
//	VPSHUFB m128 xmm k xmm
//	VPSHUFB m256 ymm k ymm
//	VPSHUFB xmm  xmm k xmm
//	VPSHUFB ymm  ymm k ymm
//	VPSHUFB m512 zmm k zmm
//	VPSHUFB m512 zmm zmm
//	VPSHUFB zmm  zmm k zmm
//	VPSHUFB zmm  zmm zmm
func VPSHUFB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHUFB.Forms(), sffxs{}, ops)
}

// VPSHUFBITQMB: Shuffle Bits from Quadword Elements Using Byte Indexes into Mask.
//
// Forms:
//
//	VPSHUFBITQMB m128 xmm k k
//	VPSHUFBITQMB m128 xmm k
//	VPSHUFBITQMB m256 ymm k k
//	VPSHUFBITQMB m256 ymm k
//	VPSHUFBITQMB xmm  xmm k k
//	VPSHUFBITQMB xmm  xmm k
//	VPSHUFBITQMB ymm  ymm k k
//	VPSHUFBITQMB ymm  ymm k
//	VPSHUFBITQMB zmm  zmm k k
//	VPSHUFBITQMB zmm  zmm k
//	VPSHUFBITQMB m512 zmm k k
//	VPSHUFBITQMB m512 zmm k
func VPSHUFBITQMB(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHUFBITQMB.Forms(), sffxs{}, ops)
}

// VPSHUFB_Z: Packed Shuffle Bytes (Zeroing Masking).
//
// Forms:
//
//	VPSHUFB.Z m128 xmm k xmm
//	VPSHUFB.Z m256 ymm k ymm
//	VPSHUFB.Z xmm  xmm k xmm
//	VPSHUFB.Z ymm  ymm k ymm
//	VPSHUFB.Z m512 zmm k zmm
//	VPSHUFB.Z zmm  zmm k zmm
func VPSHUFB_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHUFB.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPSHUFD: Shuffle Packed Doublewords.
//
// Forms:
//
//	VPSHUFD imm8 m256 ymm
//	VPSHUFD imm8 ymm  ymm
//	VPSHUFD imm8 m128 xmm
//	VPSHUFD imm8 xmm  xmm
//	VPSHUFD imm8 m128 k xmm
//	VPSHUFD imm8 m256 k ymm
//	VPSHUFD imm8 xmm  k xmm
//	VPSHUFD imm8 ymm  k ymm
//	VPSHUFD imm8 m512 k zmm
//	VPSHUFD imm8 m512 zmm
//	VPSHUFD imm8 zmm  k zmm
//	VPSHUFD imm8 zmm  zmm
func VPSHUFD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHUFD.Forms(), sffxs{}, ops)
}

// VPSHUFD_BCST: Shuffle Packed Doublewords (Broadcast).
//
// Forms:
//
//	VPSHUFD.BCST imm8 m32 k xmm
//	VPSHUFD.BCST imm8 m32 k ymm
//	VPSHUFD.BCST imm8 m32 xmm
//	VPSHUFD.BCST imm8 m32 ymm
//	VPSHUFD.BCST imm8 m32 k zmm
//	VPSHUFD.BCST imm8 m32 zmm
func VPSHUFD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHUFD.Forms(), sffxs{sffxBCST}, ops)
}

// VPSHUFD_BCST_Z: Shuffle Packed Doublewords (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPSHUFD.BCST.Z imm8 m32 k xmm
//	VPSHUFD.BCST.Z imm8 m32 k ymm
//	VPSHUFD.BCST.Z imm8 m32 k zmm
func VPSHUFD_BCST_Z(i, m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHUFD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, k, xyz})
}

// VPSHUFD_Z: Shuffle Packed Doublewords (Zeroing Masking).
//
// Forms:
//
//	VPSHUFD.Z imm8 m128 k xmm
//	VPSHUFD.Z imm8 m256 k ymm
//	VPSHUFD.Z imm8 xmm  k xmm
//	VPSHUFD.Z imm8 ymm  k ymm
//	VPSHUFD.Z imm8 m512 k zmm
//	VPSHUFD.Z imm8 zmm  k zmm
func VPSHUFD_Z(i, mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHUFD.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, k, xyz})
}

// VPSHUFHW: Shuffle Packed High Words.
//
// Forms:
//
//	VPSHUFHW imm8 m256 ymm
//	VPSHUFHW imm8 ymm  ymm
//	VPSHUFHW imm8 m128 xmm
//	VPSHUFHW imm8 xmm  xmm
//	VPSHUFHW imm8 m128 k xmm
//	VPSHUFHW imm8 m256 k ymm
//	VPSHUFHW imm8 xmm  k xmm
//	VPSHUFHW imm8 ymm  k ymm
//	VPSHUFHW imm8 m512 k zmm
//	VPSHUFHW imm8 m512 zmm
//	VPSHUFHW imm8 zmm  k zmm
//	VPSHUFHW imm8 zmm  zmm
func VPSHUFHW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHUFHW.Forms(), sffxs{}, ops)
}

// VPSHUFHW_Z: Shuffle Packed High Words (Zeroing Masking).
//
// Forms:
//
//	VPSHUFHW.Z imm8 m128 k xmm
//	VPSHUFHW.Z imm8 m256 k ymm
//	VPSHUFHW.Z imm8 xmm  k xmm
//	VPSHUFHW.Z imm8 ymm  k ymm
//	VPSHUFHW.Z imm8 m512 k zmm
//	VPSHUFHW.Z imm8 zmm  k zmm
func VPSHUFHW_Z(i, mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHUFHW.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, k, xyz})
}

// VPSHUFLW: Shuffle Packed Low Words.
//
// Forms:
//
//	VPSHUFLW imm8 m256 ymm
//	VPSHUFLW imm8 ymm  ymm
//	VPSHUFLW imm8 m128 xmm
//	VPSHUFLW imm8 xmm  xmm
//	VPSHUFLW imm8 m128 k xmm
//	VPSHUFLW imm8 m256 k ymm
//	VPSHUFLW imm8 xmm  k xmm
//	VPSHUFLW imm8 ymm  k ymm
//	VPSHUFLW imm8 m512 k zmm
//	VPSHUFLW imm8 m512 zmm
//	VPSHUFLW imm8 zmm  k zmm
//	VPSHUFLW imm8 zmm  zmm
func VPSHUFLW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHUFLW.Forms(), sffxs{}, ops)
}

// VPSHUFLW_Z: Shuffle Packed Low Words (Zeroing Masking).
//
// Forms:
//
//	VPSHUFLW.Z imm8 m128 k xmm
//	VPSHUFLW.Z imm8 m256 k ymm
//	VPSHUFLW.Z imm8 xmm  k xmm
//	VPSHUFLW.Z imm8 ymm  k ymm
//	VPSHUFLW.Z imm8 m512 k zmm
//	VPSHUFLW.Z imm8 zmm  k zmm
func VPSHUFLW_Z(i, mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSHUFLW.Forms(), sffxs{sffxZ}, []operand.Op{i, mxyz, k, xyz})
}

// VPSIGNB: Packed Sign of Byte Integers.
//
// Forms:
//
//	VPSIGNB m256 ymm ymm
//	VPSIGNB ymm  ymm ymm
//	VPSIGNB m128 xmm xmm
//	VPSIGNB xmm  xmm xmm
func VPSIGNB(mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSIGNB.Forms(), sffxs{}, []operand.Op{mxy, xy, xy1})
}

// VPSIGND: Packed Sign of Doubleword Integers.
//
// Forms:
//
//	VPSIGND m256 ymm ymm
//	VPSIGND ymm  ymm ymm
//	VPSIGND m128 xmm xmm
//	VPSIGND xmm  xmm xmm
func VPSIGND(mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSIGND.Forms(), sffxs{}, []operand.Op{mxy, xy, xy1})
}

// VPSIGNW: Packed Sign of Word Integers.
//
// Forms:
//
//	VPSIGNW m256 ymm ymm
//	VPSIGNW ymm  ymm ymm
//	VPSIGNW m128 xmm xmm
//	VPSIGNW xmm  xmm xmm
func VPSIGNW(mxy, xy, xy1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSIGNW.Forms(), sffxs{}, []operand.Op{mxy, xy, xy1})
}

// VPSLLD: Shift Packed Doubleword Data Left Logical.
//
// Forms:
//
//	VPSLLD imm8 ymm  ymm
//	VPSLLD m128 ymm  ymm
//	VPSLLD xmm  ymm  ymm
//	VPSLLD imm8 xmm  xmm
//	VPSLLD m128 xmm  xmm
//	VPSLLD xmm  xmm  xmm
//	VPSLLD imm8 m128 k xmm
//	VPSLLD imm8 m128 xmm
//	VPSLLD imm8 m256 k ymm
//	VPSLLD imm8 m256 ymm
//	VPSLLD imm8 xmm  k xmm
//	VPSLLD imm8 ymm  k ymm
//	VPSLLD m128 xmm  k xmm
//	VPSLLD m128 ymm  k ymm
//	VPSLLD xmm  xmm  k xmm
//	VPSLLD xmm  ymm  k ymm
//	VPSLLD imm8 m512 k zmm
//	VPSLLD imm8 m512 zmm
//	VPSLLD imm8 zmm  k zmm
//	VPSLLD imm8 zmm  zmm
//	VPSLLD m128 zmm  k zmm
//	VPSLLD m128 zmm  zmm
//	VPSLLD xmm  zmm  k zmm
//	VPSLLD xmm  zmm  zmm
func VPSLLD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSLLD.Forms(), sffxs{}, ops)
}

// VPSLLDQ: Shift Packed Double Quadword Left Logical.
//
// Forms:
//
//	VPSLLDQ imm8 ymm  ymm
//	VPSLLDQ imm8 xmm  xmm
//	VPSLLDQ imm8 m128 xmm
//	VPSLLDQ imm8 m256 ymm
//	VPSLLDQ imm8 m512 zmm
//	VPSLLDQ imm8 zmm  zmm
func VPSLLDQ(i, mxyz, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSLLDQ.Forms(), sffxs{}, []operand.Op{i, mxyz, xyz})
}

// VPSLLD_BCST: Shift Packed Doubleword Data Left Logical (Broadcast).
//
// Forms:
//
//	VPSLLD.BCST imm8 m32 k xmm
//	VPSLLD.BCST imm8 m32 k ymm
//	VPSLLD.BCST imm8 m32 xmm
//	VPSLLD.BCST imm8 m32 ymm
//	VPSLLD.BCST imm8 m32 k zmm
//	VPSLLD.BCST imm8 m32 zmm
func VPSLLD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSLLD.Forms(), sffxs{sffxBCST}, ops)
}

// VPSLLD_BCST_Z: Shift Packed Doubleword Data Left Logical (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPSLLD.BCST.Z imm8 m32 k xmm
//	VPSLLD.BCST.Z imm8 m32 k ymm
//	VPSLLD.BCST.Z imm8 m32 k zmm
func VPSLLD_BCST_Z(i, m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSLLD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, k, xyz})
}

// VPSLLD_Z: Shift Packed Doubleword Data Left Logical (Zeroing Masking).
//
// Forms:
//
//	VPSLLD.Z imm8 m128 k xmm
//	VPSLLD.Z imm8 m256 k ymm
//	VPSLLD.Z imm8 xmm  k xmm
//	VPSLLD.Z imm8 ymm  k ymm
//	VPSLLD.Z m128 xmm  k xmm
//	VPSLLD.Z m128 ymm  k ymm
//	VPSLLD.Z xmm  xmm  k xmm
//	VPSLLD.Z xmm  ymm  k ymm
//	VPSLLD.Z imm8 m512 k zmm
//	VPSLLD.Z imm8 zmm  k zmm
//	VPSLLD.Z m128 zmm  k zmm
//	VPSLLD.Z xmm  zmm  k zmm
func VPSLLD_Z(imx, mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSLLD.Forms(), sffxs{sffxZ}, []operand.Op{imx, mxyz, k, xyz})
}

// VPSLLQ: Shift Packed Quadword Data Left Logical.
//
// Forms:
//
//	VPSLLQ imm8 ymm  ymm
//	VPSLLQ m128 ymm  ymm
//	VPSLLQ xmm  ymm  ymm
//	VPSLLQ imm8 xmm  xmm
//	VPSLLQ m128 xmm  xmm
//	VPSLLQ xmm  xmm  xmm
//	VPSLLQ imm8 m128 k xmm
//	VPSLLQ imm8 m128 xmm
//	VPSLLQ imm8 m256 k ymm
//	VPSLLQ imm8 m256 ymm
//	VPSLLQ imm8 xmm  k xmm
//	VPSLLQ imm8 ymm  k ymm
//	VPSLLQ m128 xmm  k xmm
//	VPSLLQ m128 ymm  k ymm
//	VPSLLQ xmm  xmm  k xmm
//	VPSLLQ xmm  ymm  k ymm
//	VPSLLQ imm8 m512 k zmm
//	VPSLLQ imm8 m512 zmm
//	VPSLLQ imm8 zmm  k zmm
//	VPSLLQ imm8 zmm  zmm
//	VPSLLQ m128 zmm  k zmm
//	VPSLLQ m128 zmm  zmm
//	VPSLLQ xmm  zmm  k zmm
//	VPSLLQ xmm  zmm  zmm
func VPSLLQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSLLQ.Forms(), sffxs{}, ops)
}

// VPSLLQ_BCST: Shift Packed Quadword Data Left Logical (Broadcast).
//
// Forms:
//
//	VPSLLQ.BCST imm8 m64 k xmm
//	VPSLLQ.BCST imm8 m64 k ymm
//	VPSLLQ.BCST imm8 m64 xmm
//	VPSLLQ.BCST imm8 m64 ymm
//	VPSLLQ.BCST imm8 m64 k zmm
//	VPSLLQ.BCST imm8 m64 zmm
func VPSLLQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSLLQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPSLLQ_BCST_Z: Shift Packed Quadword Data Left Logical (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPSLLQ.BCST.Z imm8 m64 k xmm
//	VPSLLQ.BCST.Z imm8 m64 k ymm
//	VPSLLQ.BCST.Z imm8 m64 k zmm
func VPSLLQ_BCST_Z(i, m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSLLQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, k, xyz})
}

// VPSLLQ_Z: Shift Packed Quadword Data Left Logical (Zeroing Masking).
//
// Forms:
//
//	VPSLLQ.Z imm8 m128 k xmm
//	VPSLLQ.Z imm8 m256 k ymm
//	VPSLLQ.Z imm8 xmm  k xmm
//	VPSLLQ.Z imm8 ymm  k ymm
//	VPSLLQ.Z m128 xmm  k xmm
//	VPSLLQ.Z m128 ymm  k ymm
//	VPSLLQ.Z xmm  xmm  k xmm
//	VPSLLQ.Z xmm  ymm  k ymm
//	VPSLLQ.Z imm8 m512 k zmm
//	VPSLLQ.Z imm8 zmm  k zmm
//	VPSLLQ.Z m128 zmm  k zmm
//	VPSLLQ.Z xmm  zmm  k zmm
func VPSLLQ_Z(imx, mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSLLQ.Forms(), sffxs{sffxZ}, []operand.Op{imx, mxyz, k, xyz})
}

// VPSLLVD: Variable Shift Packed Doubleword Data Left Logical.
//
// Forms:
//
//	VPSLLVD m128 xmm xmm
//	VPSLLVD m256 ymm ymm
//	VPSLLVD xmm  xmm xmm
//	VPSLLVD ymm  ymm ymm
//	VPSLLVD m128 xmm k xmm
//	VPSLLVD m256 ymm k ymm
//	VPSLLVD xmm  xmm k xmm
//	VPSLLVD ymm  ymm k ymm
//	VPSLLVD m512 zmm k zmm
//	VPSLLVD m512 zmm zmm
//	VPSLLVD zmm  zmm k zmm
//	VPSLLVD zmm  zmm zmm
func VPSLLVD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSLLVD.Forms(), sffxs{}, ops)
}

// VPSLLVD_BCST: Variable Shift Packed Doubleword Data Left Logical (Broadcast).
//
// Forms:
//
//	VPSLLVD.BCST m32 xmm k xmm
//	VPSLLVD.BCST m32 xmm xmm
//	VPSLLVD.BCST m32 ymm k ymm
//	VPSLLVD.BCST m32 ymm ymm
//	VPSLLVD.BCST m32 zmm k zmm
//	VPSLLVD.BCST m32 zmm zmm
func VPSLLVD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSLLVD.Forms(), sffxs{sffxBCST}, ops)
}

// VPSLLVD_BCST_Z: Variable Shift Packed Doubleword Data Left Logical (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPSLLVD.BCST.Z m32 xmm k xmm
//	VPSLLVD.BCST.Z m32 ymm k ymm
//	VPSLLVD.BCST.Z m32 zmm k zmm
func VPSLLVD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSLLVD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPSLLVD_Z: Variable Shift Packed Doubleword Data Left Logical (Zeroing Masking).
//
// Forms:
//
//	VPSLLVD.Z m128 xmm k xmm
//	VPSLLVD.Z m256 ymm k ymm
//	VPSLLVD.Z xmm  xmm k xmm
//	VPSLLVD.Z ymm  ymm k ymm
//	VPSLLVD.Z m512 zmm k zmm
//	VPSLLVD.Z zmm  zmm k zmm
func VPSLLVD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSLLVD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPSLLVQ: Variable Shift Packed Quadword Data Left Logical.
//
// Forms:
//
//	VPSLLVQ m128 xmm xmm
//	VPSLLVQ m256 ymm ymm
//	VPSLLVQ xmm  xmm xmm
//	VPSLLVQ ymm  ymm ymm
//	VPSLLVQ m128 xmm k xmm
//	VPSLLVQ m256 ymm k ymm
//	VPSLLVQ xmm  xmm k xmm
//	VPSLLVQ ymm  ymm k ymm
//	VPSLLVQ m512 zmm k zmm
//	VPSLLVQ m512 zmm zmm
//	VPSLLVQ zmm  zmm k zmm
//	VPSLLVQ zmm  zmm zmm
func VPSLLVQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSLLVQ.Forms(), sffxs{}, ops)
}

// VPSLLVQ_BCST: Variable Shift Packed Quadword Data Left Logical (Broadcast).
//
// Forms:
//
//	VPSLLVQ.BCST m64 xmm k xmm
//	VPSLLVQ.BCST m64 xmm xmm
//	VPSLLVQ.BCST m64 ymm k ymm
//	VPSLLVQ.BCST m64 ymm ymm
//	VPSLLVQ.BCST m64 zmm k zmm
//	VPSLLVQ.BCST m64 zmm zmm
func VPSLLVQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSLLVQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPSLLVQ_BCST_Z: Variable Shift Packed Quadword Data Left Logical (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPSLLVQ.BCST.Z m64 xmm k xmm
//	VPSLLVQ.BCST.Z m64 ymm k ymm
//	VPSLLVQ.BCST.Z m64 zmm k zmm
func VPSLLVQ_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSLLVQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPSLLVQ_Z: Variable Shift Packed Quadword Data Left Logical (Zeroing Masking).
//
// Forms:
//
//	VPSLLVQ.Z m128 xmm k xmm
//	VPSLLVQ.Z m256 ymm k ymm
//	VPSLLVQ.Z xmm  xmm k xmm
//	VPSLLVQ.Z ymm  ymm k ymm
//	VPSLLVQ.Z m512 zmm k zmm
//	VPSLLVQ.Z zmm  zmm k zmm
func VPSLLVQ_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSLLVQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPSLLVW: Variable Shift Packed Word Data Left Logical.
//
// Forms:
//
//	VPSLLVW m128 xmm k xmm
//	VPSLLVW m128 xmm xmm
//	VPSLLVW m256 ymm k ymm
//	VPSLLVW m256 ymm ymm
//	VPSLLVW xmm  xmm k xmm
//	VPSLLVW xmm  xmm xmm
//	VPSLLVW ymm  ymm k ymm
//	VPSLLVW ymm  ymm ymm
//	VPSLLVW m512 zmm k zmm
//	VPSLLVW m512 zmm zmm
//	VPSLLVW zmm  zmm k zmm
//	VPSLLVW zmm  zmm zmm
func VPSLLVW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSLLVW.Forms(), sffxs{}, ops)
}

// VPSLLVW_Z: Variable Shift Packed Word Data Left Logical (Zeroing Masking).
//
// Forms:
//
//	VPSLLVW.Z m128 xmm k xmm
//	VPSLLVW.Z m256 ymm k ymm
//	VPSLLVW.Z xmm  xmm k xmm
//	VPSLLVW.Z ymm  ymm k ymm
//	VPSLLVW.Z m512 zmm k zmm
//	VPSLLVW.Z zmm  zmm k zmm
func VPSLLVW_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSLLVW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPSLLW: Shift Packed Word Data Left Logical.
//
// Forms:
//
//	VPSLLW imm8 ymm  ymm
//	VPSLLW m128 ymm  ymm
//	VPSLLW xmm  ymm  ymm
//	VPSLLW imm8 xmm  xmm
//	VPSLLW m128 xmm  xmm
//	VPSLLW xmm  xmm  xmm
//	VPSLLW imm8 m128 k xmm
//	VPSLLW imm8 m128 xmm
//	VPSLLW imm8 m256 k ymm
//	VPSLLW imm8 m256 ymm
//	VPSLLW imm8 xmm  k xmm
//	VPSLLW imm8 ymm  k ymm
//	VPSLLW m128 xmm  k xmm
//	VPSLLW m128 ymm  k ymm
//	VPSLLW xmm  xmm  k xmm
//	VPSLLW xmm  ymm  k ymm
//	VPSLLW imm8 m512 k zmm
//	VPSLLW imm8 m512 zmm
//	VPSLLW imm8 zmm  k zmm
//	VPSLLW imm8 zmm  zmm
//	VPSLLW m128 zmm  k zmm
//	VPSLLW m128 zmm  zmm
//	VPSLLW xmm  zmm  k zmm
//	VPSLLW xmm  zmm  zmm
func VPSLLW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSLLW.Forms(), sffxs{}, ops)
}

// VPSLLW_Z: Shift Packed Word Data Left Logical (Zeroing Masking).
//
// Forms:
//
//	VPSLLW.Z imm8 m128 k xmm
//	VPSLLW.Z imm8 m256 k ymm
//	VPSLLW.Z imm8 xmm  k xmm
//	VPSLLW.Z imm8 ymm  k ymm
//	VPSLLW.Z m128 xmm  k xmm
//	VPSLLW.Z m128 ymm  k ymm
//	VPSLLW.Z xmm  xmm  k xmm
//	VPSLLW.Z xmm  ymm  k ymm
//	VPSLLW.Z imm8 m512 k zmm
//	VPSLLW.Z imm8 zmm  k zmm
//	VPSLLW.Z m128 zmm  k zmm
//	VPSLLW.Z xmm  zmm  k zmm
func VPSLLW_Z(imx, mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSLLW.Forms(), sffxs{sffxZ}, []operand.Op{imx, mxyz, k, xyz})
}

// VPSRAD: Shift Packed Doubleword Data Right Arithmetic.
//
// Forms:
//
//	VPSRAD imm8 ymm  ymm
//	VPSRAD m128 ymm  ymm
//	VPSRAD xmm  ymm  ymm
//	VPSRAD imm8 xmm  xmm
//	VPSRAD m128 xmm  xmm
//	VPSRAD xmm  xmm  xmm
//	VPSRAD imm8 m128 k xmm
//	VPSRAD imm8 m128 xmm
//	VPSRAD imm8 m256 k ymm
//	VPSRAD imm8 m256 ymm
//	VPSRAD imm8 xmm  k xmm
//	VPSRAD imm8 ymm  k ymm
//	VPSRAD m128 xmm  k xmm
//	VPSRAD m128 ymm  k ymm
//	VPSRAD xmm  xmm  k xmm
//	VPSRAD xmm  ymm  k ymm
//	VPSRAD imm8 m512 k zmm
//	VPSRAD imm8 m512 zmm
//	VPSRAD imm8 zmm  k zmm
//	VPSRAD imm8 zmm  zmm
//	VPSRAD m128 zmm  k zmm
//	VPSRAD m128 zmm  zmm
//	VPSRAD xmm  zmm  k zmm
//	VPSRAD xmm  zmm  zmm
func VPSRAD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRAD.Forms(), sffxs{}, ops)
}

// VPSRAD_BCST: Shift Packed Doubleword Data Right Arithmetic (Broadcast).
//
// Forms:
//
//	VPSRAD.BCST imm8 m32 k xmm
//	VPSRAD.BCST imm8 m32 k ymm
//	VPSRAD.BCST imm8 m32 xmm
//	VPSRAD.BCST imm8 m32 ymm
//	VPSRAD.BCST imm8 m32 k zmm
//	VPSRAD.BCST imm8 m32 zmm
func VPSRAD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRAD.Forms(), sffxs{sffxBCST}, ops)
}

// VPSRAD_BCST_Z: Shift Packed Doubleword Data Right Arithmetic (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPSRAD.BCST.Z imm8 m32 k xmm
//	VPSRAD.BCST.Z imm8 m32 k ymm
//	VPSRAD.BCST.Z imm8 m32 k zmm
func VPSRAD_BCST_Z(i, m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRAD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, k, xyz})
}

// VPSRAD_Z: Shift Packed Doubleword Data Right Arithmetic (Zeroing Masking).
//
// Forms:
//
//	VPSRAD.Z imm8 m128 k xmm
//	VPSRAD.Z imm8 m256 k ymm
//	VPSRAD.Z imm8 xmm  k xmm
//	VPSRAD.Z imm8 ymm  k ymm
//	VPSRAD.Z m128 xmm  k xmm
//	VPSRAD.Z m128 ymm  k ymm
//	VPSRAD.Z xmm  xmm  k xmm
//	VPSRAD.Z xmm  ymm  k ymm
//	VPSRAD.Z imm8 m512 k zmm
//	VPSRAD.Z imm8 zmm  k zmm
//	VPSRAD.Z m128 zmm  k zmm
//	VPSRAD.Z xmm  zmm  k zmm
func VPSRAD_Z(imx, mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRAD.Forms(), sffxs{sffxZ}, []operand.Op{imx, mxyz, k, xyz})
}

// VPSRAQ: Shift Packed Quadword Data Right Arithmetic.
//
// Forms:
//
//	VPSRAQ imm8 m128 k xmm
//	VPSRAQ imm8 m128 xmm
//	VPSRAQ imm8 m256 k ymm
//	VPSRAQ imm8 m256 ymm
//	VPSRAQ imm8 xmm  k xmm
//	VPSRAQ imm8 xmm  xmm
//	VPSRAQ imm8 ymm  k ymm
//	VPSRAQ imm8 ymm  ymm
//	VPSRAQ m128 xmm  k xmm
//	VPSRAQ m128 xmm  xmm
//	VPSRAQ m128 ymm  k ymm
//	VPSRAQ m128 ymm  ymm
//	VPSRAQ xmm  xmm  k xmm
//	VPSRAQ xmm  xmm  xmm
//	VPSRAQ xmm  ymm  k ymm
//	VPSRAQ xmm  ymm  ymm
//	VPSRAQ imm8 m512 k zmm
//	VPSRAQ imm8 m512 zmm
//	VPSRAQ imm8 zmm  k zmm
//	VPSRAQ imm8 zmm  zmm
//	VPSRAQ m128 zmm  k zmm
//	VPSRAQ m128 zmm  zmm
//	VPSRAQ xmm  zmm  k zmm
//	VPSRAQ xmm  zmm  zmm
func VPSRAQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRAQ.Forms(), sffxs{}, ops)
}

// VPSRAQ_BCST: Shift Packed Quadword Data Right Arithmetic (Broadcast).
//
// Forms:
//
//	VPSRAQ.BCST imm8 m64 k xmm
//	VPSRAQ.BCST imm8 m64 k ymm
//	VPSRAQ.BCST imm8 m64 xmm
//	VPSRAQ.BCST imm8 m64 ymm
//	VPSRAQ.BCST imm8 m64 k zmm
//	VPSRAQ.BCST imm8 m64 zmm
func VPSRAQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRAQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPSRAQ_BCST_Z: Shift Packed Quadword Data Right Arithmetic (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPSRAQ.BCST.Z imm8 m64 k xmm
//	VPSRAQ.BCST.Z imm8 m64 k ymm
//	VPSRAQ.BCST.Z imm8 m64 k zmm
func VPSRAQ_BCST_Z(i, m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRAQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, k, xyz})
}

// VPSRAQ_Z: Shift Packed Quadword Data Right Arithmetic (Zeroing Masking).
//
// Forms:
//
//	VPSRAQ.Z imm8 m128 k xmm
//	VPSRAQ.Z imm8 m256 k ymm
//	VPSRAQ.Z imm8 xmm  k xmm
//	VPSRAQ.Z imm8 ymm  k ymm
//	VPSRAQ.Z m128 xmm  k xmm
//	VPSRAQ.Z m128 ymm  k ymm
//	VPSRAQ.Z xmm  xmm  k xmm
//	VPSRAQ.Z xmm  ymm  k ymm
//	VPSRAQ.Z imm8 m512 k zmm
//	VPSRAQ.Z imm8 zmm  k zmm
//	VPSRAQ.Z m128 zmm  k zmm
//	VPSRAQ.Z xmm  zmm  k zmm
func VPSRAQ_Z(imx, mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRAQ.Forms(), sffxs{sffxZ}, []operand.Op{imx, mxyz, k, xyz})
}

// VPSRAVD: Variable Shift Packed Doubleword Data Right Arithmetic.
//
// Forms:
//
//	VPSRAVD m128 xmm xmm
//	VPSRAVD m256 ymm ymm
//	VPSRAVD xmm  xmm xmm
//	VPSRAVD ymm  ymm ymm
//	VPSRAVD m128 xmm k xmm
//	VPSRAVD m256 ymm k ymm
//	VPSRAVD xmm  xmm k xmm
//	VPSRAVD ymm  ymm k ymm
//	VPSRAVD m512 zmm k zmm
//	VPSRAVD m512 zmm zmm
//	VPSRAVD zmm  zmm k zmm
//	VPSRAVD zmm  zmm zmm
func VPSRAVD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRAVD.Forms(), sffxs{}, ops)
}

// VPSRAVD_BCST: Variable Shift Packed Doubleword Data Right Arithmetic (Broadcast).
//
// Forms:
//
//	VPSRAVD.BCST m32 xmm k xmm
//	VPSRAVD.BCST m32 xmm xmm
//	VPSRAVD.BCST m32 ymm k ymm
//	VPSRAVD.BCST m32 ymm ymm
//	VPSRAVD.BCST m32 zmm k zmm
//	VPSRAVD.BCST m32 zmm zmm
func VPSRAVD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRAVD.Forms(), sffxs{sffxBCST}, ops)
}

// VPSRAVD_BCST_Z: Variable Shift Packed Doubleword Data Right Arithmetic (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPSRAVD.BCST.Z m32 xmm k xmm
//	VPSRAVD.BCST.Z m32 ymm k ymm
//	VPSRAVD.BCST.Z m32 zmm k zmm
func VPSRAVD_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRAVD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPSRAVD_Z: Variable Shift Packed Doubleword Data Right Arithmetic (Zeroing Masking).
//
// Forms:
//
//	VPSRAVD.Z m128 xmm k xmm
//	VPSRAVD.Z m256 ymm k ymm
//	VPSRAVD.Z xmm  xmm k xmm
//	VPSRAVD.Z ymm  ymm k ymm
//	VPSRAVD.Z m512 zmm k zmm
//	VPSRAVD.Z zmm  zmm k zmm
func VPSRAVD_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRAVD.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPSRAVQ: Variable Shift Packed Quadword Data Right Arithmetic.
//
// Forms:
//
//	VPSRAVQ m128 xmm k xmm
//	VPSRAVQ m128 xmm xmm
//	VPSRAVQ m256 ymm k ymm
//	VPSRAVQ m256 ymm ymm
//	VPSRAVQ xmm  xmm k xmm
//	VPSRAVQ xmm  xmm xmm
//	VPSRAVQ ymm  ymm k ymm
//	VPSRAVQ ymm  ymm ymm
//	VPSRAVQ m512 zmm k zmm
//	VPSRAVQ m512 zmm zmm
//	VPSRAVQ zmm  zmm k zmm
//	VPSRAVQ zmm  zmm zmm
func VPSRAVQ(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRAVQ.Forms(), sffxs{}, ops)
}

// VPSRAVQ_BCST: Variable Shift Packed Quadword Data Right Arithmetic (Broadcast).
//
// Forms:
//
//	VPSRAVQ.BCST m64 xmm k xmm
//	VPSRAVQ.BCST m64 xmm xmm
//	VPSRAVQ.BCST m64 ymm k ymm
//	VPSRAVQ.BCST m64 ymm ymm
//	VPSRAVQ.BCST m64 zmm k zmm
//	VPSRAVQ.BCST m64 zmm zmm
func VPSRAVQ_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRAVQ.Forms(), sffxs{sffxBCST}, ops)
}

// VPSRAVQ_BCST_Z: Variable Shift Packed Quadword Data Right Arithmetic (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPSRAVQ.BCST.Z m64 xmm k xmm
//	VPSRAVQ.BCST.Z m64 ymm k ymm
//	VPSRAVQ.BCST.Z m64 zmm k zmm
func VPSRAVQ_BCST_Z(m, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRAVQ.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{m, xyz, k, xyz1})
}

// VPSRAVQ_Z: Variable Shift Packed Quadword Data Right Arithmetic (Zeroing Masking).
//
// Forms:
//
//	VPSRAVQ.Z m128 xmm k xmm
//	VPSRAVQ.Z m256 ymm k ymm
//	VPSRAVQ.Z xmm  xmm k xmm
//	VPSRAVQ.Z ymm  ymm k ymm
//	VPSRAVQ.Z m512 zmm k zmm
//	VPSRAVQ.Z zmm  zmm k zmm
func VPSRAVQ_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRAVQ.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPSRAVW: Variable Shift Packed Word Data Right Arithmetic.
//
// Forms:
//
//	VPSRAVW m128 xmm k xmm
//	VPSRAVW m128 xmm xmm
//	VPSRAVW m256 ymm k ymm
//	VPSRAVW m256 ymm ymm
//	VPSRAVW xmm  xmm k xmm
//	VPSRAVW xmm  xmm xmm
//	VPSRAVW ymm  ymm k ymm
//	VPSRAVW ymm  ymm ymm
//	VPSRAVW m512 zmm k zmm
//	VPSRAVW m512 zmm zmm
//	VPSRAVW zmm  zmm k zmm
//	VPSRAVW zmm  zmm zmm
func VPSRAVW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRAVW.Forms(), sffxs{}, ops)
}

// VPSRAVW_Z: Variable Shift Packed Word Data Right Arithmetic (Zeroing Masking).
//
// Forms:
//
//	VPSRAVW.Z m128 xmm k xmm
//	VPSRAVW.Z m256 ymm k ymm
//	VPSRAVW.Z xmm  xmm k xmm
//	VPSRAVW.Z ymm  ymm k ymm
//	VPSRAVW.Z m512 zmm k zmm
//	VPSRAVW.Z zmm  zmm k zmm
func VPSRAVW_Z(mxyz, xyz, k, xyz1 operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRAVW.Forms(), sffxs{sffxZ}, []operand.Op{mxyz, xyz, k, xyz1})
}

// VPSRAW: Shift Packed Word Data Right Arithmetic.
//
// Forms:
//
//	VPSRAW imm8 ymm  ymm
//	VPSRAW m128 ymm  ymm
//	VPSRAW xmm  ymm  ymm
//	VPSRAW imm8 xmm  xmm
//	VPSRAW m128 xmm  xmm
//	VPSRAW xmm  xmm  xmm
//	VPSRAW imm8 m128 k xmm
//	VPSRAW imm8 m128 xmm
//	VPSRAW imm8 m256 k ymm
//	VPSRAW imm8 m256 ymm
//	VPSRAW imm8 xmm  k xmm
//	VPSRAW imm8 ymm  k ymm
//	VPSRAW m128 xmm  k xmm
//	VPSRAW m128 ymm  k ymm
//	VPSRAW xmm  xmm  k xmm
//	VPSRAW xmm  ymm  k ymm
//	VPSRAW imm8 m512 k zmm
//	VPSRAW imm8 m512 zmm
//	VPSRAW imm8 zmm  k zmm
//	VPSRAW imm8 zmm  zmm
//	VPSRAW m128 zmm  k zmm
//	VPSRAW m128 zmm  zmm
//	VPSRAW xmm  zmm  k zmm
//	VPSRAW xmm  zmm  zmm
func VPSRAW(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRAW.Forms(), sffxs{}, ops)
}

// VPSRAW_Z: Shift Packed Word Data Right Arithmetic (Zeroing Masking).
//
// Forms:
//
//	VPSRAW.Z imm8 m128 k xmm
//	VPSRAW.Z imm8 m256 k ymm
//	VPSRAW.Z imm8 xmm  k xmm
//	VPSRAW.Z imm8 ymm  k ymm
//	VPSRAW.Z m128 xmm  k xmm
//	VPSRAW.Z m128 ymm  k ymm
//	VPSRAW.Z xmm  xmm  k xmm
//	VPSRAW.Z xmm  ymm  k ymm
//	VPSRAW.Z imm8 m512 k zmm
//	VPSRAW.Z imm8 zmm  k zmm
//	VPSRAW.Z m128 zmm  k zmm
//	VPSRAW.Z xmm  zmm  k zmm
func VPSRAW_Z(imx, mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRAW.Forms(), sffxs{sffxZ}, []operand.Op{imx, mxyz, k, xyz})
}

// VPSRLD: Shift Packed Doubleword Data Right Logical.
//
// Forms:
//
//	VPSRLD imm8 ymm  ymm
//	VPSRLD m128 ymm  ymm
//	VPSRLD xmm  ymm  ymm
//	VPSRLD imm8 xmm  xmm
//	VPSRLD m128 xmm  xmm
//	VPSRLD xmm  xmm  xmm
//	VPSRLD imm8 m128 k xmm
//	VPSRLD imm8 m128 xmm
//	VPSRLD imm8 m256 k ymm
//	VPSRLD imm8 m256 ymm
//	VPSRLD imm8 xmm  k xmm
//	VPSRLD imm8 ymm  k ymm
//	VPSRLD m128 xmm  k xmm
//	VPSRLD m128 ymm  k ymm
//	VPSRLD xmm  xmm  k xmm
//	VPSRLD xmm  ymm  k ymm
//	VPSRLD imm8 m512 k zmm
//	VPSRLD imm8 m512 zmm
//	VPSRLD imm8 zmm  k zmm
//	VPSRLD imm8 zmm  zmm
//	VPSRLD m128 zmm  k zmm
//	VPSRLD m128 zmm  zmm
//	VPSRLD xmm  zmm  k zmm
//	VPSRLD xmm  zmm  zmm
func VPSRLD(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRLD.Forms(), sffxs{}, ops)
}

// VPSRLDQ: Shift Packed Double Quadword Right Logical.
//
// Forms:
//
//	VPSRLDQ imm8 ymm  ymm
//	VPSRLDQ imm8 xmm  xmm
//	VPSRLDQ imm8 m128 xmm
//	VPSRLDQ imm8 m256 ymm
//	VPSRLDQ imm8 m512 zmm
//	VPSRLDQ imm8 zmm  zmm
func VPSRLDQ(i, mxyz, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRLDQ.Forms(), sffxs{}, []operand.Op{i, mxyz, xyz})
}

// VPSRLD_BCST: Shift Packed Doubleword Data Right Logical (Broadcast).
//
// Forms:
//
//	VPSRLD.BCST imm8 m32 k xmm
//	VPSRLD.BCST imm8 m32 k ymm
//	VPSRLD.BCST imm8 m32 xmm
//	VPSRLD.BCST imm8 m32 ymm
//	VPSRLD.BCST imm8 m32 k zmm
//	VPSRLD.BCST imm8 m32 zmm
func VPSRLD_BCST(ops ...operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRLD.Forms(), sffxs{sffxBCST}, ops)
}

// VPSRLD_BCST_Z: Shift Packed Doubleword Data Right Logical (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VPSRLD.BCST.Z imm8 m32 k xmm
//	VPSRLD.BCST.Z imm8 m32 k ymm
//	VPSRLD.BCST.Z imm8 m32 k zmm
func VPSRLD_BCST_Z(i, m, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRLD.Forms(), sffxs{sffxBCST, sffxZ}, []operand.Op{i, m, k, xyz})
}

// VPSRLD_Z: Shift Packed Doubleword Data Right Logical (Zeroing Masking).
//
// Forms:
//
//	VPSRLD.Z imm8 m128 k xmm
//	VPSRLD.Z imm8 m256 k ymm
//	VPSRLD.Z imm8 xmm  k xmm
//	VPSRLD.Z imm8 ymm  k ymm
//	VPSRLD.Z m128 xmm  k xmm
//	VPSRLD.Z m128 ymm  k ymm
//	VPSRLD.Z xmm  xmm  k xmm
//	VPSRLD.Z xmm  ymm  k ymm
//	VPSRLD.Z imm8 m512 k zmm
//	VPSRLD.Z imm8 zmm  k zmm
//	VPSRLD.Z m128 zmm  k zmm
//	VPSRLD.Z xmm  zmm  k zmm
func VPSRLD_Z(imx, mxyz, k, xyz operand.Op) (*intrep.Instruction, error) {
	return build(opcVPSRLD.Forms(), sffxs{sffxZ}, []operand.Op{imx, mxyz, k, xyz})
}

// VPSRLQ: Shift Packed Quadword Data Right Logical.
//
// Forms:
//
//	VPSRLQ imm8 ymm  ymm
//	VPSRLQ m128 ymm  ymm
//	VPSRLQ xmm  ymm  ymm
//	VPSRLQ imm8 xmm  xmm
//	VPSRLQ m128 xmm  xmm
//	VPSRLQ xmm  xmm  xmm
//	VPSRLQ imm8 m128 k xmm
//	VPSRLQ imm8 m128 x