// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"strings"
)

// ScanResultScoreEnum Enum with underlying type: string
type ScanResultScoreEnum string

// Set of constants representing the allowable values for ScanResultScoreEnum
const (
	ScanResultScorePass ScanResultScoreEnum = "PASS"
	ScanResultScoreFail ScanResultScoreEnum = "FAIL"
)

var mappingScanResultScoreEnum = map[string]ScanResultScoreEnum{
	"PASS": ScanResultScorePass,
	"FAIL": ScanResultScoreFail,
}

var mappingScanResultScoreEnumLowerCase = map[string]ScanResultScoreEnum{
	"pass": ScanResultScorePass,
	"fail": ScanResultScoreFail,
}

// GetScanResultScoreEnumValues Enumerates the set of values for ScanResultScoreEnum
func GetScanResultScoreEnumValues() []ScanResultScoreEnum {
	values := make([]ScanResultScoreEnum, 0)
	for _, v := range mappingScanResultScoreEnum {
		values = append(values, v)
	}
	return values
}

// GetScanResultScoreEnumStringValues Enumerates the set of values in String for ScanResultScoreEnum
func GetScanResultScoreEnumStringValues() []string {
	return []string{
		"PASS",
		"FAIL",
	}
}

// GetMappingScanResultScoreEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingScanResultScoreEnum(val string) (ScanResultScoreEnum, bool) {
	enum, ok := mappingScanResultScoreEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
