// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Database Management API
//
// Use the Database Management API to monitor and manage resources such as
// Oracle Databases, MySQL Databases, and External Database Systems.
// For more information, see Database Management (https://docs.oracle.com/iaas/database-management/home.htm).
//

package databasemanagement

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// MySqlQueryDetails The details of a given MySQL query, it consists of the query sample details, the explain plan and potential warnings.
type MySqlQueryDetails struct {
	QuerySampleDetails *MySqlQuerySampleDetails `mandatory:"true" json:"querySampleDetails"`

	QueryExplainPlan *MySqlQueryExplainPlan `mandatory:"false" json:"queryExplainPlan"`

	// The errors, warnings and notes that could be raised by the execution of the query.
	QueryMessages []MySqlQueryMessage `mandatory:"false" json:"queryMessages"`
}

func (m MySqlQueryDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m MySqlQueryDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
