// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Vault Secret Management API
//
// Use the Secret Management API to manage secrets and secret versions. For more information, see Managing Secrets (https://docs.oracle.com/iaas/Content/KeyManagement/Tasks/managingsecrets.htm).
//

package vault

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// SecretVersion The details of the secret version, excluding the contents of the secret.
type SecretVersion struct {

	// The content type of the secret version's secret contents.
	ContentType SecretVersionContentTypeEnum `mandatory:"false" json:"contentType,omitempty"`

	// The name of the secret version. A name is unique across versions of a secret.
	Name *string `mandatory:"false" json:"name"`

	// The OCID of the secret.
	SecretId *string `mandatory:"false" json:"secretId"`

	// A list of possible rotation states for the secret version. A secret version marked `CURRENT` is currently in use. A secret version
	// marked `PENDING` is staged and available for use, but has not been applied on the target system and, therefore, has not been rotated
	// into current, active use. The secret most recently uploaded to a vault is always marked `LATEST`. (The first version of a secret is
	// always marked as both `CURRENT` and `LATEST`.) A secret version marked `PREVIOUS` is the secret version that was most recently marked
	// `CURRENT`, before the last secret version rotation. A secret version marked `DEPRECATED` is neither current, pending, nor the previous
	// one in use. Only secret versions marked `DEPRECATED` can be scheduled for deletion.
	Stages []SecretVersionStagesEnum `mandatory:"false" json:"stages,omitempty"`

	// A optional property indicating when the secret version was created, expressed in RFC 3339 (https://tools.ietf.org/html/rfc3339) timestamp format.
	// Example: `2019-04-03T21:10:29.600Z`
	TimeCreated *common.SDKTime `mandatory:"false" json:"timeCreated"`

	// An optional property indicating when to delete the secret version, expressed in RFC 3339 (https://tools.ietf.org/html/rfc3339) timestamp format.
	// Example: `2019-04-03T21:10:29.600Z`
	TimeOfDeletion *common.SDKTime `mandatory:"false" json:"timeOfDeletion"`

	// An optional property indicating when the current secret version will expire, expressed in RFC 3339 (https://tools.ietf.org/html/rfc3339) timestamp format.
	// Example: `2019-04-03T21:10:29.600Z`
	TimeOfCurrentVersionExpiry *common.SDKTime `mandatory:"false" json:"timeOfCurrentVersionExpiry"`

	// The version number of the secret.
	VersionNumber *int64 `mandatory:"false" json:"versionNumber"`

	// Boolean flag indicating whether secret content for this secret version was auto-generated or not.
	IsContentAutoGenerated *bool `mandatory:"false" json:"isContentAutoGenerated"`
}

func (m SecretVersion) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m SecretVersion) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if _, ok := GetMappingSecretVersionContentTypeEnum(string(m.ContentType)); !ok && m.ContentType != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for ContentType: %s. Supported values are: %s.", m.ContentType, strings.Join(GetSecretVersionContentTypeEnumStringValues(), ",")))
	}
	for _, val := range m.Stages {
		if _, ok := GetMappingSecretVersionStagesEnum(string(val)); !ok && val != "" {
			errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for Stages: %s. Supported values are: %s.", val, strings.Join(GetSecretVersionStagesEnumStringValues(), ",")))
		}
	}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// SecretVersionContentTypeEnum Enum with underlying type: string
type SecretVersionContentTypeEnum string

// Set of constants representing the allowable values for SecretVersionContentTypeEnum
const (
	SecretVersionContentTypeBase64 SecretVersionContentTypeEnum = "BASE64"
)

var mappingSecretVersionContentTypeEnum = map[string]SecretVersionContentTypeEnum{
	"BASE64": SecretVersionContentTypeBase64,
}

var mappingSecretVersionContentTypeEnumLowerCase = map[string]SecretVersionContentTypeEnum{
	"base64": SecretVersionContentTypeBase64,
}

// GetSecretVersionContentTypeEnumValues Enumerates the set of values for SecretVersionContentTypeEnum
func GetSecretVersionContentTypeEnumValues() []SecretVersionContentTypeEnum {
	values := make([]SecretVersionContentTypeEnum, 0)
	for _, v := range mappingSecretVersionContentTypeEnum {
		values = append(values, v)
	}
	return values
}

// GetSecretVersionContentTypeEnumStringValues Enumerates the set of values in String for SecretVersionContentTypeEnum
func GetSecretVersionContentTypeEnumStringValues() []string {
	return []string{
		"BASE64",
	}
}

// GetMappingSecretVersionContentTypeEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingSecretVersionContentTypeEnum(val string) (SecretVersionContentTypeEnum, bool) {
	enum, ok := mappingSecretVersionContentTypeEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// SecretVersionStagesEnum Enum with underlying type: string
type SecretVersionStagesEnum string

// Set of constants representing the allowable values for SecretVersionStagesEnum
const (
	SecretVersionStagesCurrent    SecretVersionStagesEnum = "CURRENT"
	SecretVersionStagesPending    SecretVersionStagesEnum = "PENDING"
	SecretVersionStagesLatest     SecretVersionStagesEnum = "LATEST"
	SecretVersionStagesPrevious   SecretVersionStagesEnum = "PREVIOUS"
	SecretVersionStagesDeprecated SecretVersionStagesEnum = "DEPRECATED"
)

var mappingSecretVersionStagesEnum = map[string]SecretVersionStagesEnum{
	"CURRENT":    SecretVersionStagesCurrent,
	"PENDING":    SecretVersionStagesPending,
	"LATEST":     SecretVersionStagesLatest,
	"PREVIOUS":   SecretVersionStagesPrevious,
	"DEPRECATED": SecretVersionStagesDeprecated,
}

var mappingSecretVersionStagesEnumLowerCase = map[string]SecretVersionStagesEnum{
	"current":    SecretVersionStagesCurrent,
	"pending":    SecretVersionStagesPending,
	"latest":     SecretVersionStagesLatest,
	"previous":   SecretVersionStagesPrevious,
	"deprecated": SecretVersionStagesDeprecated,
}

// GetSecretVersionStagesEnumValues Enumerates the set of values for SecretVersionStagesEnum
func GetSecretVersionStagesEnumValues() []SecretVersionStagesEnum {
	values := make([]SecretVersionStagesEnum, 0)
	for _, v := range mappingSecretVersionStagesEnum {
		values = append(values, v)
	}
	return values
}

// GetSecretVersionStagesEnumStringValues Enumerates the set of values in String for SecretVersionStagesEnum
func GetSecretVersionStagesEnumStringValues() []string {
	return []string{
		"CURRENT",
		"PENDING",
		"LATEST",
		"PREVIOUS",
		"DEPRECATED",
	}
}

// GetMappingSecretVersionStagesEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingSecretVersionStagesEnum(val string) (SecretVersionStagesEnum, bool) {
	enum, ok := mappingSecretVersionStagesEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
