package encryption

import (
	"bytes"
	"crypto/cipher"
	"crypto/des"

	"github.com/vulncheck-oss/go-exploit/output"
)

func PKCS5Padding(src []byte, blockSize int) []byte {
	padding := blockSize - len(src)%blockSize
	padtext := bytes.Repeat([]byte{byte(padding)}, padding)

	return append(src, padtext...)
}

func TripleDesEncryption(key, iv, plainText []byte) ([]byte, bool) {
	block, err := des.NewTripleDESCipher(key)
	if err != nil {
		output.PrintFrameworkError(err.Error())

		return nil, false
	}

	blockSize := block.BlockSize()
	origData := PKCS5Padding(plainText, blockSize)
	blockMode := cipher.NewCBCEncrypter(block, iv)
	cryted := make([]byte, len(origData))
	blockMode.CryptBlocks(cryted, origData)

	return cryted, true
}
